/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class HelloBankPDFExtractor
extends AbstractPDFExtractor {
    public HelloBankPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("Hellobank");
        this.addBankIdentifier("Hello bank!");
        this.addBuyTransaction();
        this.addSellTransaction();
        this.addDividendTransaction();
        this.addInboundDelivery();
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Gesch\u00e4ftsart: Kauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Gesch\u00e4ftsart: Kauf");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("isin", "name", "currency").match("Titel: (?<isin>\\S*) (?<name>.*)$").match("Kurs: [\\d+,.]* (?<currency>\\w{3}+) *").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("^Zugang: (?<shares>[\\d+,.]*) Stk.*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("amount", "currency").match("Zu Lasten .* -(?<amount>[\\d+,.]*) (?<currency>\\w{3}+) *$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("date").match("Handelszeit: (?<date>\\d+.\\d+.\\d{4}+).*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("fee", "currency").optional().match("Grundgeb\u00fchr: -(?<fee>[\\d+,.]*) (?<currency>\\w{3}+) *").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match("Fremde Spesen: -(?<fee>[\\d+,.]*) (?<currency>\\w{3}+) *").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("gross", "currency", "exchangeRate").optional().match("Kurswert: -(?<gross>[\\d+,.-]*) (?<currency>\\w{3}+) *").match("-[\\d+,.-]* \\w{3}+ *").match("Devisenkurs: (?<exchangeRate>[\\d+,.]*) \\(\\d+.\\d+.\\d{4}+\\) -[\\d+,.]* \\w{3}+ *").assign((t, v) -> {
            long gross = this.asAmount((String)v.get("gross"));
            String currency = this.asCurrencyCode((String)v.get("currency"));
            BigDecimal exchangeRate = BigDecimal.ONE.divide(this.asExchangeRate((String)v.get("exchangeRate")), 10, RoundingMode.HALF_UP);
            PortfolioTransaction tx = t.getPortfolioTransaction();
            if (currency.equals(tx.getSecurity().getCurrencyCode())) {
                long convertedGross = BigDecimal.valueOf(gross).multiply(exchangeRate).setScale(0, RoundingMode.HALF_UP).longValue();
                tx.addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, Money.of(tx.getCurrencyCode(), convertedGross), Money.of(currency, gross), exchangeRate));
            }
        }).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Gesch\u00e4ftsart: Verkauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Gesch\u00e4ftsart: Verkauf");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("isin", "name", "currency").match("Titel: (?<isin>\\S*) (?<name>.*)$").match("Kurs: [\\d+,.]* (?<currency>\\w{3}+) *").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("^Abgang: (?<shares>[\\d+,.]*) Stk.*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("amount", "currency").match("Zu Gunsten .* (?<amount>[\\d+,.]*) (?<currency>\\w{3}+) *$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("date").match("Handelszeit: (?<date>\\d+.\\d+.\\d{4}+).*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("fee", "currency").optional().match("Grundgeb\u00fchr: -(?<fee>[\\d+,.]*) (?<currency>\\w{3}+) *").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match("Fremde Spesen: -(?<fee>[\\d+,.]*) (?<currency>\\w{3}+) *").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match("Eigene Spesen: -(?<fee>[\\d+,.]*) (?<currency>\\w{3}+) *").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("gross", "tax", "currency", "exchangeRate").match("Kurswert: (?<gross>[\\d+,.-]*) (?<currency>\\w{3}+) *").match("Kapitalertragsteuer: -(?<tax>[\\d+,.-]*) \\w{3}+ *").match("[\\d+,.-]* \\w{3}+ *").match("Devisenkurs: (?<exchangeRate>[\\d+,.]*) \\(\\d+.\\d+.\\d{4}+\\) [\\d+,.]* \\w{3}+ *").assign((t, v) -> {
            long gross = this.asAmount((String)v.get("gross"));
            long tax = this.asAmount((String)v.get("tax"));
            String currency = this.asCurrencyCode((String)v.get("currency"));
            BigDecimal exchangeRate = BigDecimal.ONE.divide(this.asExchangeRate((String)v.get("exchangeRate")), 10, RoundingMode.HALF_UP);
            PortfolioTransaction tx = t.getPortfolioTransaction();
            if (currency.equals(tx.getSecurity().getCurrencyCode())) {
                long convertedGross = BigDecimal.valueOf(gross).multiply(exchangeRate).setScale(0, RoundingMode.HALF_UP).longValue();
                tx.addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, Money.of(tx.getCurrencyCode(), convertedGross), Money.of(currency, gross), exchangeRate));
                long convertedTax = BigDecimal.valueOf(tax).multiply(exchangeRate).setScale(0, RoundingMode.HALF_UP).longValue();
                tx.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(tx.getCurrencyCode(), convertedTax), Money.of(currency, tax), exchangeRate));
            } else {
                long convertedTax = BigDecimal.valueOf(tax).multiply(exchangeRate).setScale(0, RoundingMode.HALF_UP).longValue();
                tx.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(tx.getCurrencyCode(), convertedTax)));
            }
        }).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addDividendTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Gesch\u00e4ftsart: Ertrag", (context, lines) -> {
            Pattern exchangeRatePattern = Pattern.compile("Devisenkurs: (?<exchangeRate>[\\d+,.]*) \\(\\d+.\\d+.\\d{4}+\\) [\\d+,.]* \\w{3}+ *");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher matcher = exchangeRatePattern.matcher(line);
                if (matcher.matches()) {
                    context.put("exchangeRate", matcher.group(1));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Gesch\u00e4ftsart: Ertrag");
        type.addBlock(block);
        BiConsumer<AccountTransaction, Map> taxProcessor = (t, v) -> {
            long tax = this.asAmount((String)v.get("tax"));
            String currency = this.asCurrencyCode((String)v.get("currency"));
            if (currency.equals(t.getCurrencyCode())) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(t.getCurrencyCode(), tax)));
            } else {
                String exchangeRateString = type.getCurrentContext().get("exchangeRate");
                if (exchangeRateString != null) {
                    BigDecimal exchangeRate = BigDecimal.ONE.divide(this.asExchangeRate(exchangeRateString), 10, RoundingMode.HALF_UP);
                    if (currency.equals(t.getSecurity().getCurrencyCode())) {
                        long convertedTax = BigDecimal.valueOf(tax).multiply(exchangeRate).setScale(0, RoundingMode.HALF_UP).longValue();
                        t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(t.getCurrencyCode(), convertedTax), Money.of(currency, tax), exchangeRate));
                    } else {
                        long convertedTax = BigDecimal.valueOf(tax).multiply(exchangeRate).setScale(0, RoundingMode.HALF_UP).longValue();
                        t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(t.getCurrencyCode(), convertedTax)));
                    }
                }
            }
        };
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DIVIDENDS);
            return transaction;
        }).section("isin", "name", "currency").match("Titel: (?<isin>\\S*) (?<name>.*)$").match("Dividende: [\\d+,.]* (?<currency>\\w{3}+) *").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("^(Abgang: )?(?<shares>[\\d+,.]*) Stk$").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("amount", "currency").match("Zu Gunsten .* (?<amount>[\\d+,.]*) (?<currency>\\w{3}+) *$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("date").match("Valuta (?<date>\\d+.\\d+.\\d{4}+)").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("tax", "currency").optional().match("Inkassoprovision: -(?<tax>[\\d+,.]*) (?<currency>\\w{3}+) *").assign(taxProcessor).section("tax", "currency").optional().match("Umsatzsteuer: -(?<tax>[\\d+,.]*) (?<currency>\\w{3}+) *").assign(taxProcessor).section("tax", "currency").optional().match("Fremde Spesen: -(?<tax>[\\d+,.-]*) (?<currency>\\w{3}+) *").assign(taxProcessor).section("tax", "currency").optional().match("KESt Ausl\u00e4ndische Dividende: -(?<tax>[\\d+,.]*) (?<currency>\\w{3}+) *").assign(taxProcessor).section("tax", "currency").optional().match("Quellensteuer[^.]*: -(?<tax>[\\d+,.]*) (?<currency>\\w{3}+) *").assign(taxProcessor).section("gross", "currency").optional().match("Bruttoertrag: (?<gross>[\\d+,.-]*) (?<currency>\\w{3}+) *").assign((t, v) -> {
            String exchangeRateString;
            long gross = this.asAmount((String)v.get("gross"));
            String currency = this.asCurrencyCode((String)v.get("currency"));
            if (currency.equals(t.getSecurity().getCurrencyCode()) && (exchangeRateString = type.getCurrentContext().get("exchangeRate")) != null) {
                BigDecimal exchangeRate = BigDecimal.ONE.divide(this.asExchangeRate(exchangeRateString), 10, RoundingMode.HALF_UP);
                long convertedGross = BigDecimal.valueOf(gross).multiply(exchangeRate).setScale(0, RoundingMode.HALF_UP).longValue();
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, Money.of(t.getCurrencyCode(), convertedGross), Money.of(currency, gross), exchangeRate));
            }
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addInboundDelivery() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Freier Erhalt");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Gesch.ftsart: Freier Erhalt");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<PortfolioTransaction>().subject(() -> {
            PortfolioTransaction transaction = new PortfolioTransaction();
            transaction.setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
            return transaction;
        }).section("isin", "name", "currency").match("Titel: (?<isin>\\S*) (?<name>.*)$").match("steuerlicher Anschaffungswert: [\\d+,.-]* (?<currency>\\w{3}+) *").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("^Zugang: (?<shares>[\\d+,.]*) Stk.*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("date").match("Kassatag: (?<date>\\d+.\\d+.\\d{4}+).*").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("amount", "currency").match("steuerlicher Anschaffungswert: (?<amount>[\\d+,.-]*) (?<currency>\\w{3}+) *").assign((t, v) -> t.setMonetaryAmount(Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount"))))).wrap(Extractor.TransactionItem::new));
    }

    @Override
    public String getLabel() {
        return "Hello Bank";
    }
}

