/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class INGDiBaExtractor
extends AbstractPDFExtractor {
    private static final String IS_JOINT_ACCOUNT = "isjointaccount";
    BiConsumer<Map<String, String>, String[]> isJointAccount = (context, lines) -> {
        Pattern pJointAccount = Pattern.compile("KapSt anteilig 50,00 %.*");
        Boolean bJointAccount = false;
        String[] stringArray = lines;
        int n = ((String[])lines).length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher m = pJointAccount.matcher(line);
            if (m.matches()) {
                context.put(IS_JOINT_ACCOUNT, Boolean.TRUE.toString());
                bJointAccount = true;
                break;
            }
            ++n2;
        }
        if (!bJointAccount.booleanValue()) {
            context.put(IS_JOINT_ACCOUNT, Boolean.FALSE.toString());
        }
    };

    public INGDiBaExtractor(Client client) {
        super(client);
        this.addBuyTransaction();
        this.addSellTransaction();
        this.addErtragsgutschrift();
        this.addZinsgutschrift();
        this.addDividendengutschrift();
    }

    @Override
    public String getPDFAuthor() {
        return "ING-DiBa";
    }

    @Override
    public String getLabel() {
        return "ING-DiBa";
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertpapierabrechnung Kauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Wertpapierabrechnung Kauf.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("wkn", "isin", "name", "name1").match("^ISIN \\(WKN\\) (?<isin>[^ ]*) \\((?<wkn>.*)\\)$").match("Wertpapierbezeichnung (?<name>.*)").match("(?<name1>.*)").assign((t, v) -> {
            if (!((String)v.get("name1")).startsWith("Nominale")) {
                v.put("name", String.valueOf((String)v.get("name")) + " " + (String)v.get("name1"));
            }
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("shares").match("^Nominale( St.ck)? (?<shares>[\\d.]+(,\\d+)?).*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("time").optional().match("(Ausf.hrungstag . -zeit|Ausf.hrungstag|Schlusstag . -zeit|Schlusstag) .* (?<time>\\d+:\\d+:\\d+).*").assign((t, v) -> type.getCurrentContext().put("time", (String)v.get("time"))).section("date").match("(Ausf.hrungstag . -zeit|Ausf.hrungstag|Schlusstag . -zeit|Schlusstag) (?<date>\\d+.\\d+.\\d{4}+).*").assign((t, v) -> {
            if (type.getCurrentContext().get("time") != null) {
                t.setDate(this.asDate((String)v.get("date"), type.getCurrentContext().get("time")));
            } else {
                t.setDate(this.asDate((String)v.get("date")));
            }
        }).section("amount", "currency").match("Endbetrag zu Ihren Lasten (?<currency>\\w{3}+) (?<amount>[\\d.]+,\\d+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("fee", "currency").optional().match("Handelsplatzgeb.hr (?<currency>\\w{3}+) (?<fee>[\\d.]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match("Provision (?<currency>\\w{3}+) (?<fee>[\\d.]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match("Handelsentgelt (?<currency>\\w{3}+) (?<fee>[\\d.]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).wrap(t -> {
            if (t.getPortfolioTransaction().getDateTime() == null) {
                throw new IllegalArgumentException("Missing date");
            }
            return new Extractor.BuySellEntryItem((BuySellEntry)t);
        }));
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertpapierabrechnung Verkauf", this.isJointAccount);
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Wertpapierabrechnung Verkauf.*");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> transaction = new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("wkn", "isin", "name", "name1").match("^ISIN \\(WKN\\) (?<isin>[^ ]*) \\((?<wkn>.*)\\)$").match("Wertpapierbezeichnung (?<name>.*)").match("(?<name1>.*)").assign((t, v) -> {
            if (!((String)v.get("name1")).startsWith("Nominale")) {
                v.put("name", String.valueOf((String)v.get("name")) + " " + (String)v.get("name1"));
            }
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("shares").match("^Nominale St.ck (?<shares>[\\d.]+(,\\d+)?)").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("date").match("(Ausf.hrungstag . -zeit|Ausf.hrungstag|Schlusstag . -zeit|Schlusstag) (?<date>\\d+.\\d+.\\d{4}+).*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("date", "time").optional().match("(Ausf.hrungstag . -zeit|Ausf.hrungstag|Schlusstag . -zeit|Schlusstag) (?<date>\\d+.\\d+.\\d{4}+) .* (?<time>\\d+:\\d+:\\d+).*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date"), (String)v.get("time")))).section("amount", "currency").match("Endbetrag zu Ihren Gunsten (?<currency>\\w{3}+) (?<amount>[\\d.]+,\\d+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("fee", "currency").optional().match("Handelsplatzgeb.hr (?<currency>\\w{3}+) (?<fee>[\\d.]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match("Provision (?<currency>\\w{3}+) (?<fee>[\\d.]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match("Handelsentgelt (?<currency>\\w{3}+) (?<fee>[\\d.]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).wrap(Extractor.BuySellEntryItem::new);
        this.addTaxSectionToBuySellEntry(type, transaction);
        block.set(transaction);
    }

    private void addErtragsgutschrift() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Ertragsgutschrift", this.isJointAccount);
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Ertragsgutschrift.*");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> transaction = new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.DIVIDENDS);
            return entry;
        }).section("wkn", "isin", "name").match("^ISIN \\(WKN\\) (?<isin>[^ ]*) \\((?<wkn>.*)\\)$").match("Wertpapierbezeichnung (?<name>.*)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("^Nominale (?<shares>[\\d.]+(,\\d+)?) .*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("date").match("Zahltag (?<date>\\d+.\\d+.\\d{4}+)").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("currency").match("Gesamtbetrag zu Ihren (Gunsten|Lasten) (?<currency>\\w{3}+) .*").assign((t, v) -> t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency"))));
        this.addTaxSectionToAccountTransaction(type, transaction);
        transaction.section("amount").match("Gesamtbetrag zu Ihren (Gunsten|Lasten) \\w{3}+ (?<amount>(- )?[\\d.]+,\\d+)").assign((t, v) -> {
            if (((String)v.get("amount")).startsWith("-")) {
                Money amount = t.getUnitSum(Transaction.Unit.Type.TAX);
                t.setType(AccountTransaction.Type.TAXES);
                t.clearUnits();
                t.setMonetaryAmount(amount);
            } else {
                t.setAmount(this.asAmount((String)v.get("amount")));
            }
        }).wrap(Extractor.TransactionItem::new);
        block.set(transaction);
    }

    private void addZinsgutschrift() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Zinsgutschrift", this.isJointAccount);
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Zinsgutschrift.*");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> transaction = new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.DIVIDENDS);
            return entry;
        }).section("wkn", "isin", "name").match("^ISIN \\(WKN\\) (?<isin>[^ ]*) \\((?<wkn>.*)\\)$").match("Wertpapierbezeichnung (?<name>.*)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("date").match("Zahltag (?<date>\\d+.\\d+.\\d{4}+)").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("amount", "currency").match("Gesamtbetrag zu Ihren Gunsten (?<currency>\\w{3}+) (?<amount>[\\d.]+,\\d+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(Extractor.TransactionItem::new);
        this.addTaxSectionToAccountTransaction(type, transaction);
        block.set(transaction);
    }

    private void addDividendengutschrift() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Dividendengutschrift", this.isJointAccount);
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Dividendengutschrift.*");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> transaction = new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.DIVIDENDS);
            return entry;
        }).section("wkn", "isin", "name").match("^ISIN \\(WKN\\) (?<isin>[^ ]*) \\((?<wkn>.*)\\)$").match("Wertpapierbezeichnung (?<name>.*)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("^Nominale (?<shares>[\\d.]+(,\\d+)?) .*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("amount", "currency").match("Gesamtbetrag zu Ihren Gunsten (?<currency>\\w{3}+) (?<amount>[\\d.]+,\\d+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("date").match("Valuta (?<date>\\d+.\\d+.\\d{4}+)").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).wrap(Extractor.TransactionItem::new);
        this.addTaxSectionToAccountTransaction(type, transaction);
        block.set(transaction);
    }

    private void addTaxSectionToBuySellEntry(PDFParser.DocumentType type, PDFParser.Transaction<BuySellEntry> transaction) {
        transaction.section("tax", "currency").optional().match("Kapitalertragsteuer \\d+,\\d+ ?% (?<currency>\\w{3}+) (?<tax>[\\d.]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).section("tax1", "currency1", "tax2", "currency2").optional().match("KapSt anteilig 50,00 ?% \\d+,\\d+ ?% (?<currency1>\\w{3}+) (?<tax1>[\\d.]+,\\d+)").match("KapSt anteilig 50,00 ?% \\d+,\\d+ ?% (?<currency2>\\w{3}+) (?<tax2>[\\d.]+,\\d+)").assign((t, v) -> {
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency1")), this.asAmount((String)v.get("tax1")))));
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency2")), this.asAmount((String)v.get("tax2")))));
        }).section("tax", "currency").optional().match("Solidarit.tszuschlag \\d+,\\d+ ?% (?<currency>\\w{3}+) (?<tax>[\\d.]+,\\d+)").assign((t, v) -> {
            if (!Boolean.parseBoolean(type.getCurrentContext().get(IS_JOINT_ACCOUNT))) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))));
            }
        }).section("tax1", "currency1", "tax2", "currency2").optional().match("Solidarit.tszuschlag \\d+,\\d+ ?% (?<currency1>\\w{3}+) (?<tax1>[\\d.]+,\\d+)").match("Solidarit.tszuschlag \\d+,\\d+ ?% (?<currency2>\\w{3}+) (?<tax2>[\\d.]+,\\d+)").assign((t, v) -> {
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency1")), this.asAmount((String)v.get("tax1")))));
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency2")), this.asAmount((String)v.get("tax2")))));
        }).section("tax", "currency").optional().match("Kirchensteuer \\d+,\\d+ ?% (?<currency>\\w{3}+) (?<tax>[\\d.]+,\\d+)").assign((t, v) -> {
            if (!Boolean.parseBoolean(type.getCurrentContext().get(IS_JOINT_ACCOUNT))) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))));
            }
        }).section("tax1", "currency1", "tax2", "currency2").optional().match("Kirchensteuer \\d+,\\d+ ?% (?<currency1>\\w{3}+) (?<tax1>[\\d.]+,\\d+)").match("Kirchensteuer \\d+,\\d+ ?% (?<currency2>\\w{3}+) (?<tax2>[\\d.]+,\\d+)").assign((t, v) -> {
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency1")), this.asAmount((String)v.get("tax1")))));
            t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency2")), this.asAmount((String)v.get("tax2")))));
        });
    }

    private void addTaxSectionToAccountTransaction(PDFParser.DocumentType type, PDFParser.Transaction<AccountTransaction> transaction) {
        transaction.section("tax", "currency").optional().match("Kapitalertragsteuer \\d+,\\d+ ?% (?<currency>\\w{3}+) (?<tax>[\\d.]+,\\d+)").assign((t, v) -> t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).section("tax1", "currency1", "tax2", "currency2").optional().match("KapSt anteilig 50,00 ?% \\d+,\\d+ ?% (?<currency1>\\w{3}+) (?<tax1>[\\d.]+,\\d+)").match("KapSt anteilig 50,00 ?% \\d+,\\d+ ?% (?<currency2>\\w{3}+) (?<tax2>[\\d.]+,\\d+)").assign((t, v) -> {
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency1")), this.asAmount((String)v.get("tax1")))));
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency2")), this.asAmount((String)v.get("tax2")))));
        }).section("tax", "currency").optional().match("Solidarit.tszuschlag \\d+,\\d+ ?% (?<currency>\\w{3}+) (?<tax>[\\d.]+,\\d+)").assign((t, v) -> {
            if (!Boolean.parseBoolean(type.getCurrentContext().get(IS_JOINT_ACCOUNT))) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))));
            }
        }).section("tax1", "currency1", "tax2", "currency2").optional().match("Solidarit.tszuschlag \\d+,\\d+ ?% (?<currency1>\\w{3}+) (?<tax1>[\\d.]+,\\d+)").match("Solidarit.tszuschlag \\d+,\\d+ ?% (?<currency2>\\w{3}+) (?<tax2>[\\d.]+,\\d+)").assign((t, v) -> {
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency1")), this.asAmount((String)v.get("tax1")))));
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency2")), this.asAmount((String)v.get("tax2")))));
        }).section("tax", "currency").optional().match("Kirchensteuer \\d+,\\d+ ?% (?<currency>\\w{3}+) (?<tax>[\\d.]+,\\d+)").assign((t, v) -> {
            if (!Boolean.parseBoolean(type.getCurrentContext().get(IS_JOINT_ACCOUNT))) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))));
            }
        }).section("tax1", "currency1", "tax2", "currency2").optional().match("Kirchensteuer \\d+,\\d+ ?% (?<currency1>\\w{3}+) (?<tax1>[\\d.]+,\\d+)").match("Kirchensteuer \\d+,\\d+ ?% (?<currency2>\\w{3}+) (?<tax2>[\\d.]+,\\d+)").assign((t, v) -> {
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency1")), this.asAmount((String)v.get("tax1")))));
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency2")), this.asAmount((String)v.get("tax2")))));
        }).section("tax", "currency", "taxTx", "currencyTx").optional().match("QuSt \\d+,\\d+ % \\((?<currencyTx>\\w{3}+) (?<taxTx>[\\d.,]*)\\) (?<currency>\\w{3}+) (?<tax>[\\d.,]*)").assign((t, v) -> {
            String currency = this.asCurrencyCode((String)v.get("currency"));
            String currencyTx = this.asCurrencyCode((String)v.get("currencyTx"));
            if (currency.equals(t.getCurrencyCode())) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(currency, this.asAmount((String)v.get("tax")))));
            } else {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(currencyTx, this.asAmount((String)v.get("taxTx")))));
            }
        }).section("tax", "currency").optional().match("QuSt \\d+,\\d+ % (?<currency>\\w{3}+) (?<tax>[\\d.,]*)").assign((t, v) -> {
            String currency = this.asCurrencyCode((String)v.get("currency"));
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(currency, this.asAmount((String)v.get("tax")))));
        });
    }
}

