/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.util.Map;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.datatransfer.pdf.SwissBasedPDFExtractor;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class PostfinancePDFExtractor
extends SwissBasedPDFExtractor {
    public PostfinancePDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("PostFinance");
        this.addBuyTransaction();
        this.addSellTransaction();
        this.addDividendsTransaction();
        this.addCapitalGainTransaction();
        this.addFeeTransaction();
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("B\u00f6rsentransaktion: Kauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^B\u00f6rsentransaktion: Kauf (.*)$");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("name", "isin", "shares", "currency", "transactionCurrency", "amount").find("Titel Ort der Ausf\u00fchrung").match("^(?<name>.*) ISIN: (?<isin>\\S*) (.*)$").match("^(?<shares>[\\d+',.]*) ([\\d+',.]*) (?<currency>\\w{3}+) ([\\d+',.]*)$").match("^Zu Ihren Lasten (?<transactionCurrency>\\w{3}+) (?<amount>[\\d+',.]*)$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("transactionCurrency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("feecurrency", "fee").optional().match("^Kommission (?<feecurrency>\\w{3}+) (?<fee>[\\d+',.]*)$").assign((t, v) -> {
            Money fee = Money.of(this.asCurrencyCode((String)v.get("feecurrency")), this.asAmount((String)v.get("fee")));
            if (fee.getCurrencyCode().equals(t.getAccountTransaction().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, fee));
            }
        }).section("taxcurrency", "tax").optional().match("^Abgabe \\(Eidg. Stempelsteuer\\) (?<taxcurrency>\\w{3}+) (?<tax>[\\d+',.]*)$").assign((t, v) -> {
            Money tax = Money.of(this.asCurrencyCode((String)v.get("taxcurrency")), this.asAmount((String)v.get("tax")));
            if (tax.getCurrencyCode().equals(t.getAccountTransaction().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, tax));
            }
        }).section("stockfeecurrency", "stockfee").optional().match("^B\u00f6rsengeb\u00fchren (?<stockfeecurrency>\\w{3}+) (?<stockfee>[\\d+',.]*)$").assign((t, v) -> {
            Money stock_fee = Money.of(this.asCurrencyCode((String)v.get("stockfeecurrency")), this.asAmount((String)v.get("stockfee")));
            if (stock_fee.getCurrencyCode().equals(t.getAccountTransaction().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, stock_fee));
            }
        }).section("amount", "currency", "exchangeRate", "forexCurrency", "forexAmount").optional().match("^Total (?<forexCurrency>\\w{3}+) (?<forexAmount>[\\d+',.]*)$").match("^Wechselkurs (?<exchangeRate>[\\d+',.]*)$").match("^(?<currency>\\w{3}+) (?<amount>[\\d+',.]*)$").assign((t, v) -> {
            Money forex = Money.of(this.asCurrencyCode((String)v.get("forexCurrency")), this.asAmount((String)v.get("forexAmount")));
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            Money gross = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
            if (forex.getCurrencyCode().equals(t.getPortfolioTransaction().getSecurity().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, gross, forex, exchangeRate));
            }
        }).section("date").match("^Betrag belastet auf Kontonummer (\\d+), Valutadatum (?<date>\\d+\\.\\d+\\.\\d{4})$").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("B\u00f6rsentransaktion: Verkauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^B\u00f6rsentransaktion: Verkauf (.*)$");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("name", "isin", "shares", "currency").find("Titel Ort der Ausf\u00fchrung").match("^(?<name>.*) ISIN: (?<isin>\\S*) (.*)$").match("^(?<shares>[\\d+',.]*) ([\\d+',.]*) (?<currency>\\w{3}+) ([\\d+',.]*)$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("feecurrency", "fee").optional().match("^Kommission (?<feecurrency>\\w{3}+) (?<fee>[\\d+',.]*)$").assign((t, v) -> {
            Money fee = Money.of(this.asCurrencyCode((String)v.get("feecurrency")), this.asAmount((String)v.get("fee")));
            if (fee.getCurrencyCode().equals(t.getAccountTransaction().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, fee));
            }
        }).section("taxcurrency", "tax").optional().match("^Abgabe \\(Eidg. Stempelsteuer\\) (?<taxcurrency>\\w{3}+) (?<tax>[\\d+',.]*)$").assign((t, v) -> {
            Money tax = Money.of(this.asCurrencyCode((String)v.get("taxcurrency")), this.asAmount((String)v.get("tax")));
            if (tax.getCurrencyCode().equals(t.getAccountTransaction().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, tax));
            }
        }).section("stockfeecurrency", "stockfee").optional().match("^B\u00f6rsengeb\u00fchren (?<stockfeecurrency>\\w{3}+) (?<stockfee>[\\d+',.]*)$").assign((t, v) -> {
            Money stock_fee = Money.of(this.asCurrencyCode((String)v.get("stockfeecurrency")), this.asAmount((String)v.get("stockfee")));
            if (stock_fee.getCurrencyCode().equals(t.getAccountTransaction().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, stock_fee));
            }
        }).section("amount").match("^Zu Ihren Gunsten (\\w{3}+) (?<amount>[\\d+',.]*)$").assign((t, v) -> t.setAmount(this.asAmount((String)v.get("amount")))).section("date").match("^Betrag gutgeschrieben auf Ihrer Kontonummer (\\d+), Valutadatum (?<date>\\d+\\.\\d+\\.\\d{4})$").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addDividendsTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Dividende");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^Dividende Unsere Referenz(.*)$");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DIVIDENDS);
            return transaction;
        }).oneOf(section -> section.attributes("name", "isin", "shares").match("^ISIN: (?<isin>\\S*)$").match("^(?<name>.*)NKN: [\\d+]* (?<shares>[\\d+',.]*)$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }), section -> section.attributes("name", "isin", "shares").match("^(?<name>.*) ISIN: (?<isin>\\S*)NKN: [\\d+]* (?<shares>[\\d+',.]*)$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        })).section("date").match("^Ausf\u00fchrungsdatum (?<date>\\d+\\.\\d+\\.\\d{4})$").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("gross", "grosscurrency", "amount", "currency").match("^Betrag (?<grosscurrency>\\w{3}+) (?<gross>[\\d+',.]*)$").match("^Total (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.getSecurity().setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            long gross = this.asAmount((String)v.get("gross"));
            long tax = gross - t.getAmount();
            Transaction.Unit unit = new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), tax));
            if (unit.getAmount().getCurrencyCode().equals(t.getCurrencyCode())) {
                t.addUnit(unit);
            }
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addCapitalGainTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Kapitalgewinn");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^Kapitalgewinn Unsere Referenz(.*)$");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DIVIDENDS);
            return transaction;
        }).oneOf(section -> section.attributes("name", "isin", "shares").match("^ISIN: (?<isin>\\S*)$").match("^(?<name>.*)NKN: [\\d+]* (?<shares>[\\d+',.]*)$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }), section -> section.attributes("name", "isin", "shares").match("^(?<name>.*) ISIN: (?<isin>\\S*)NKN: [\\d+]* (?<shares>[\\d+',.]*)$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        })).section("date").match("^Ausf\u00fchrungsdatum (?<date>\\d+\\.\\d+\\.\\d{4})$").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("currency", "amount").match("^Total (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.getSecurity().setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addFeeTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Jahresgeb\u00fchr");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^Jahresgeb\u00fchr (.*)$");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.FEES);
            return transaction;
        }).section("date", "amount", "currency").find("^Jahresgeb\u00fchr (.*)").match("^Valutadatum (?<date>\\d+.\\d+.\\d{4}+)$").match("^Betrag belastet (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)$").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.TransactionItem::new));
    }

    @Override
    public String getLabel() {
        return "PostFinance";
    }
}

