/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class QuirionPDFExtractor
extends AbstractPDFExtractor {
    public QuirionPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("Quirin Privatbank AG");
        this.addPeriodenauszugTransactions();
    }

    private void addPeriodenauszugTransactions() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("(Kontoauszug)", (context, lines) -> {
            Pattern pCurrency = Pattern.compile("(Verm\u00f6gensverwaltungskonto in )(\\w{3})\\n");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = pCurrency.matcher(line);
                if (m.matches()) {
                    context.put("currency", m.group(1));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block depositBlock = new PDFParser.Block("^((Konto\u00fcbertrag (\\d+))|(Sammelgutschrift)|(Interne Buchung)|(\u00dcberweisungsgutschrift Inland)) (\\d+\\.\\d+\\.\\d{4}) (\\d+\\.\\d+\\.\\d{4}) ([\\d.]+,\\d{2}) (\\w{3})");
        type.addBlock(depositBlock);
        depositBlock.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DEPOSIT);
            return t;
        }).section("valuta", "amount").match("^((Konto\u00fcbertrag (\\d+))|(Sammelgutschrift)|(Interne Buchung)|(\u00dcberweisungsgutschrift Inland)) (\\d+\\.\\d+\\.\\d{4}) (?<valuta>\\d+\\.\\d+\\.\\d{4}) (?<amount>[\\d.]+,\\d{2}) (\\w{3})").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            t.setDateTime(this.asDate((String)v.get("valuta")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
        PDFParser.Block taxReturnBlock = new PDFParser.Block("^Steueroptimierung (\\d+.\\d+.\\d{4}+) (\\d+.\\d+.\\d{4}+) ([\\d.]+,\\d{2}).*");
        type.addBlock(taxReturnBlock);
        taxReturnBlock.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.TAX_REFUND);
            return t;
        }).section("amount", "currency", "date").match("^Steueroptimierung (\\d+.\\d+.\\d{4}+) (?<date>\\d+.\\d+.\\d{4}+) (?<amount>[\\d.]+,\\d{2}) (?<currency>\\w{3}).*").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
        PDFParser.Block removalBlock = new PDFParser.Block("^(R\u00fcck\u00fcberweisung Inland) (\\d+\\.\\d+\\.\\d{4}) (\\d+\\.\\d+\\.\\d{4}) -([\\d.]+,\\d{2}) (\\w{3})");
        type.addBlock(removalBlock);
        removalBlock.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.REMOVAL);
            return t;
        }).section("valuta", "amount").match("^(R\u00fcck\u00fcberweisung Inland) (\\d+\\.\\d+\\.\\d{4}) (?<valuta>\\d+\\.\\d+\\.\\d{4}) -(?<amount>[\\d.]+,\\d{2}) (\\w{3})").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            t.setDateTime(this.asDate((String)v.get("valuta")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
        PDFParser.Block feesBlock = new PDFParser.Block("(Verm\u00f6gensverwaltungshonorar)(.*) (\\d+\\.\\d+\\.\\d{4}) (\\d+\\.\\d+\\.\\d{4}) (-[\\d.]+,\\d{2}) (\\w{3})");
        type.addBlock(feesBlock);
        feesBlock.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.FEES);
            return t;
        }).section("valuta", "amount").match("(Verm\u00f6gensverwaltungshonorar)(.*) (\\d+\\.\\d+\\.\\d{4}) (?<valuta>\\d+\\.\\d+\\.\\d{4}) -(?<amount>[\\d.]+,\\d{2}) (\\w{3})").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            t.setDateTime(this.asDate((String)v.get("valuta")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
        PDFParser.Block buyBlock = new PDFParser.Block("(Wertpapier Kauf, Ref.: \\d+) (\\d+.\\d+.\\d{4}+) (\\d+.\\d+.\\d{4}+) (-[\\d.]+,\\d{2}) (\\w{3}).*");
        type.addBlock(buyBlock);
        buyBlock.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("isin", "name").match("(Wertpapier Kauf, Ref.: \\d+) (\\d+.\\d+.\\d{4}+) (\\d+.\\d+.\\d{4}+) (-[\\d.]+,\\d{2}) (\\w{3}).*").match("^(?<name>.*)$").match("((^o.N.\\n)|(^))(?<isin>.{12}).*").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            v.put("currency", context.get("currency"));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("amount", "date", "shares").match("(Wertpapier Kauf, Ref.: \\d+) (\\d+.\\d+.\\d{4}+) (?<date>\\d+.\\d+.\\d{4}+) -(?<amount>[\\d.]+,\\d{2}) (\\w{3}).*").match("^(.*)$").match("^(.{12}, ST) (?<shares>[\\d.,]+).*").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            t.setDate(this.asDate((String)v.get("date")));
            t.setShares(this.asShares((String)v.get("shares")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(Extractor.BuySellEntryItem::new));
        PDFParser.Block taxpayblock = new PDFParser.Block("(Thesaurierung, Ref.: \\d+) (\\d+.\\d+.\\d{4}+) (\\d+.\\d+.\\d{4}+) (-[\\d.]+,\\d{2}) (\\w{3}).*");
        type.addBlock(taxpayblock);
        PDFParser.Transaction<AccountTransaction> taxVorabpauschaleTransaction = new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.TAXES);
            return entry;
        }).section("name", "isin", "date").match("(Thesaurierung, Ref.: \\d+) (\\d+.\\d+.\\d{4}+) (?<date>\\d+.\\d+.\\d{4}+) (-[\\d.]+,\\d{2}) (\\w{3}).*").match("^(?<name>.*)$").match("((^o.N.\\n)|(^))(?<isin>.{12}).*").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("tax", "currency").optional().match("(Thesaurierung, Ref.: \\d+) (\\d+.\\d+.\\d{4}+) (\\d+.\\d+.\\d{4}+) (?<tax>-[\\d.]+,\\d{2}) (?<currency>\\w{3}).*").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("tax")));
        }).wrap(t -> t.getAmount() != 0L ? new Extractor.TransactionItem((AccountTransaction)t) : new Extractor.NonImportableItem("Steuerpflichtige Vorabpauschale mit 0 " + t.getCurrencyCode()));
        taxpayblock.set(taxVorabpauschaleTransaction);
        PDFParser.Block dividendBlock = new PDFParser.Block("^Ertr\u00e4gnisabrechnung, Ref.: \\d+ (\\d+.\\d+.\\d{4}+) (\\d+.\\d+.\\d{4}+) ([\\d.]+,\\d{2}).*");
        dividendBlock.setMaxSize(5);
        type.addBlock(dividendBlock);
        dividendBlock.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DIVIDENDS);
            return t;
        }).section("isin", "name").match("^Ertr\u00e4gnisabrechnung, Ref.: \\d+ (\\d+.\\d+.\\d{4}+) (\\d+.\\d+.\\d{4}+) ([\\d.]+,\\d{2})(.*)$").match("^(?<name>.*)$").match("((^Dis.oN\\n)|(^))(?<isin>.{12})(.*)").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            v.put("currency", context.get("currency"));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("amount", "date", "shares").match("^Ertr\u00e4gnisabrechnung, Ref.: \\d+ (\\d+.\\d+.\\d{4}+) (?<date>\\d+.\\d+.\\d{4}+) (?<amount>[\\d.]+,\\d{2})(.*)$").match("^(.*)$").match("((^Dis.oN\\n)|(^))(.{12}, ST) (?<shares>[\\d.,]+)(.*)").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setShares(this.asShares((String)v.get("shares")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("tax", "currency").optional().match("^(.*)(KEST: )(?<currency>\\w{3}) -(?<tax>[\\d.]+,\\d{2}).*").assign((t, v) -> {
            Money taxes = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")));
            if (taxes.getCurrencyCode().equals(t.getCurrencyCode())) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, taxes));
            }
        }).section("tax", "currency").optional().match("^(.*)(SOLI: )(?<currency>\\w{3}) -(?<tax>[\\d.]+,\\d{2})(.*)$").assign((t, v) -> {
            Money taxes = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")));
            if (taxes.getCurrencyCode().equals(t.getCurrencyCode())) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, taxes));
            }
        }).wrap(Extractor.TransactionItem::new));
        PDFParser.Block sellBlock = new PDFParser.Block("(Wertpapier Verkauf, Ref.: \\d+) (\\d+.\\d+.\\d{4}+) (\\d+.\\d+.\\d{4}+) ([\\d.]+,\\d{2}) (\\w{3}).*");
        sellBlock.setMaxSize(4);
        type.addBlock(sellBlock);
        sellBlock.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("isin", "name", "amount", "date", "shares").match("(Wertpapier Verkauf, Ref.: \\d+) (\\d+.\\d+.\\d{4}+) (?<date>\\d+.\\d+.\\d{4}+) (?<amount>[\\d.]+,\\d{2}) (\\w{3}).*").match("^(?<name>.*)$").match("^((Dis.oN\\n)|())((?<isin>.{12}), ST) -(?<shares>[\\d.,]+)(.*)").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            v.put("currency", context.get("currency"));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setDate(this.asDate((String)v.get("date")));
            t.setShares(this.asShares((String)v.get("shares")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("kest", "currency").optional().match("^(KEST: )(?<currency>\\w{3}) -(?<kest>[\\d.]+,\\d{2}).*$").assign((t, v) -> {
            Money kest = Money.of(this.asCurrencyCode("EUR"), this.asAmount((String)v.get("kest")));
            if (!kest.isZero() && kest.getCurrencyCode().equals(t.getPortfolioTransaction().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, kest));
            }
        }).section("soli", "currency").optional().match(".*(SOLI: )(?<currency>\\w{3}) -(?<soli>[\\d.]+,\\d{2}).*$").assign((t, v) -> {
            Money soli = Money.of(this.asCurrencyCode("EUR"), this.asAmount((String)v.get("soli")));
            if (!soli.isZero() && soli.getCurrencyCode().equals(t.getPortfolioTransaction().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, soli));
            }
        }).wrap(Extractor.BuySellEntryItem::new));
    }

    @Override
    public String getLabel() {
        return "Quirion";
    }
}

