/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.util.Map;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;

public class SutorPDFExtractor
extends AbstractPDFExtractor {
    private static final String REGEX_AMOUNT = "^(\\d+\\.\\d+\\.\\d{4}) (\\d+\\.\\d+\\.\\d{4}) -?(?<amount>[\\.\\d]+[,\\d]*).*$";
    private static final String REGEX_AMOUNT_NEW_FORMAT = "^(\\d+\\.\\d+\\.\\d{4}) (\\d+\\.\\d+\\.\\d{4}).*(\\s|-)(?<amount>[\\.\\d]+,\\d{2})$";
    private static final String REGEX_AMOUNT_AND_SHARES = "^(\\d+.\\d+.\\d{4}+) (\\d+.\\d+.\\d{4}+) (?<sign>[-])?(?<amount>[\\.\\d]+[,\\d]*) .* -?(?<shares>[\\.\\d]+[,\\d]*)$";
    private static final String REGEX_AMOUNT_AND_SHARES_NEW_FORMAT = "^(\\d+.\\d+.\\d{4}+) (\\d+.\\d+.\\d{4}+)[^,]* -?(?<shares>[\\.\\d]+,\\d{4}) ([\\.\\d]+,\\d{4}\\s)?(?<sign>[-])?(?<amount>[\\.\\d]+,\\d{2})$";
    private static final String REGEX_DATE = "^(\\d+\\.\\d+\\.\\d{4}) (?<date>\\d+\\.\\d+\\.\\d{4}) .*";

    public SutorPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("Sutor");
        this.addBankIdentifier("Sutor Bank");
        this.addDeposit();
        this.addBuySellTransaction();
        this.addFeePayment();
    }

    @Override
    public String getPDFAuthor() {
        return "Sutor Bank";
    }

    private void addDeposit() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Sutor fairriester 2.0 | Ums\u00e4tze");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block(".*(Zulage|automatischer Lastschrifteinzug|Einzahlung).*");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> pdfTransaction = new PDFParser.Transaction<AccountTransaction>();
        pdfTransaction.subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DEPOSIT);
            return transaction;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("date").match(REGEX_DATE).assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).oneOf(section -> section.attributes("amount").match(REGEX_AMOUNT).assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode("EUR");
        }), section -> section.attributes("amount").match(REGEX_AMOUNT_NEW_FORMAT).assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode("EUR");
        })).wrap(Extractor.TransactionItem::new);
    }

    private void addBuySellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Sutor fairriester 2.0 | Ums\u00e4tze");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block(".* (Kauf|Verkauf|Geb\u00fchrentilgung) .*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("name").match("^.* (Kauf|Verkauf|Geb\u00fchrentilgung) (?<name>[^,]*) .*").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("date").match(REGEX_DATE).assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).oneOf(section -> section.attributes("amount", "shares", "sign").match(REGEX_AMOUNT_AND_SHARES).assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode("EUR");
            t.setShares(this.asShares((String)v.get("shares")));
        }), section -> section.attributes("amount", "shares").match(REGEX_AMOUNT_AND_SHARES).assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode("EUR");
            t.setShares(this.asShares((String)v.get("shares")));
            t.setType(PortfolioTransaction.Type.SELL);
        }), section -> section.attributes("amount", "shares", "sign").match(REGEX_AMOUNT_AND_SHARES_NEW_FORMAT).assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode("EUR");
            t.setShares(this.asShares((String)v.get("shares")));
        }), section -> section.attributes("amount", "shares").match(REGEX_AMOUNT_AND_SHARES_NEW_FORMAT).assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode("EUR");
            t.setShares(this.asShares((String)v.get("shares")));
            t.setType(PortfolioTransaction.Type.SELL);
        })).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addFeePayment() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Sutor fairriester 2.0 | Ums\u00e4tze");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block(".* (Verwaltungsgeb\u00fchr/Vertriebskosten|anteil.Verwaltgeb\u00fchr/Vertriebskosten|Kontof\u00fchrungs-u.Depotgeb\u00fchren).*");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> pdfTransaction = new PDFParser.Transaction<AccountTransaction>();
        pdfTransaction.subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.FEES);
            return transaction;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("date").match(REGEX_DATE).assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).oneOf(section -> section.attributes("amount").match(REGEX_AMOUNT).assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode("EUR");
        }), section -> section.attributes("amount").match(REGEX_AMOUNT_NEW_FORMAT).assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode("EUR");
        })).wrap(Extractor.TransactionItem::new);
    }

    @Override
    public String getLabel() {
        return "Sutor Fairriester";
    }
}

