/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class TradeRepublicPDFExtractor
extends AbstractPDFExtractor {
    public TradeRepublicPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("TRADE REPUBLIC");
        this.addBuyTransaction();
        this.addSellTransaction();
        this.addLiquidationTransaction();
        this.addAccountStatementTransaction();
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Order Kauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block(".*Order Kauf.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("name", "isin", "shares").find("POSITION ANZAHL KURS BETRAG").match("(?<name>.*) (?<shares>[\\d+,.]*) Stk. ([\\d+,.]*) (\\w{3}+) ([\\d+,.]*) (\\w{3}+)$").match(".*").match("(ISIN:)?(?<isin>.*)").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("amount", "currency").match("GESAMT -(?<amount>[\\d+,.]*) (?<currency>\\w{3}+)").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("date", "time").match(".*Order Kauf am (?<date>\\d+\\.\\d+\\.\\d{4}|\\d{4}-\\d+-\\d+), um (?<time>\\d+:\\d+) Uhr.*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date"), (String)v.get("time")))).section("fee", "currency").optional().match("Fremdkostenzuschlag -(?<fee>[\\d+,.]*) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Order Verkauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block(".*Order Verkauf.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("name", "isin", "shares").find("POSITION ANZAHL KURS BETRAG").match("(?<name>.*) (?<shares>[\\d+,.]*) Stk. ([\\d+,.]*) (\\w{3}+) ([\\d+,.]*) (\\w{3}+)$").match(".*").match("(ISIN:)?(?<isin>.*)").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("amount", "currency").optional().match("GESAMT ([\\d+,.]*) (\\w{3}+)").match("GESAMT (?<amount>[\\d+,.]*) (?<currency>\\w{3}+)").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("amount", "currency").match("GESAMT (?<amount>[\\d+,.]*) (?<currency>\\w{3}+)").assign((t, v) -> {
            if (t.getPortfolioTransaction().getAmount() == 0L) {
                t.setAmount(this.asAmount((String)v.get("amount")));
                t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            }
        }).section("date", "time").match(".*Order Verkauf am (?<date>\\d+\\.\\d+\\.\\d{4}|\\d{4}-\\d+-\\d+), um (?<time>\\d+:\\d+) Uhr.*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date"), (String)v.get("time")))).section("fee", "currency").optional().match("Fremdkostenzuschlag -(?<fee>[\\d+,.]*) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("tax", "currency").optional().match("Kapitalertragssteuer -(?<tax>[\\d+,.]*) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).section("tax", "currency").optional().match("Kapitalertragssteuer Optimierung (?<tax>[\\d+,.]*) (?<currency>\\w{3}+)").assign((t, v) -> t.setAmount(t.getPortfolioTransaction().getAmount() - this.asAmount((String)v.get("tax")))).section("tax", "currency").optional().match("Solidarit\u00e4tszuschlag -(?<tax>[\\d+,.]*) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).section("tax", "currency").optional().match("Solidarit\u00e4tszuschlag Optimierung (?<tax>[\\d+,.]*) (?<currency>\\w{3}+)").assign((t, v) -> t.setAmount(t.getPortfolioTransaction().getAmount() - this.asAmount((String)v.get("tax")))).section("tax", "currency").optional().match("Kirchensteuer -(?<tax>[\\d+,.]*) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).section("tax", "currency").optional().match("Kirchensteuer Optimierung (?<tax>[\\d+,.]*) (?<currency>\\w{3}+)").assign((t, v) -> t.setAmount(t.getPortfolioTransaction().getAmount() - this.asAmount((String)v.get("tax")))).wrap(Extractor.BuySellEntryItem::new));
        PDFParser.Block taxBlock = new PDFParser.Block("Kapitalertragssteuer Optimierung.*");
        type.addBlock(taxBlock);
        taxBlock.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.TAX_REFUND);
            return t;
        }).section("tax", "currency", "date").optional().match("Kapitalertragssteuer Optimierung (?<tax>[\\d+,.]*) (?<currency>\\w{3}+)").match("VERRECHNUNGSKONTO VALUTA BETRAG").match(".* (?<date>\\d+\\.\\d+\\.\\d{4}|\\d{4}-\\d+-\\d+) (?<amount>[\\d+,.]*) (\\w{3}+)").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("tax")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
        }).section("tax", "currency", "date").optional().match("Solidarit\u00e4tszuschlag Optimierung (?<tax>[\\d+,.]*) (?<currency>\\w{3}+)").match("VERRECHNUNGSKONTO VALUTA BETRAG").match(".* (?<date>\\d+\\.\\d+\\.\\d{4}|\\d{4}-\\d+-\\d+) (?<amount>[\\d+,.]*) (\\w{3}+)").assign((t, v) -> {
            t.setAmount(t.getAmount() + this.asAmount((String)v.get("tax")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
        }).section("tax", "currency", "date").optional().match("Kirchensteuer Optimierung (?<tax>[\\d+,.]*) (?<currency>\\w{3}+)").match("VERRECHNUNGSKONTO VALUTA BETRAG").match(".* (?<date>\\d+\\.\\d+\\.\\d{4}|\\d{4}-\\d+-\\d+) (?<amount>[\\d+,.]*) (\\w{3}+)").assign((t, v) -> {
            t.setAmount(t.getAmount() + this.asAmount((String)v.get("tax")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
    }

    private void addLiquidationTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("TILGUNG");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("TILGUNG");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("name", "isin", "shares").find("NR. BUCHUNG WERTPAPIER ANZAHL.*").match(".* Tilgung (?<name>.*) (?<shares>[\\d+,.]*) Stk.$").match(".*").match("(ISIN:)?(?<isin>\\w{12})").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("amount", "currency").match("NR. POSITION SUMME").match("1 Kurswert .*").match("SUMME (?<amount>[\\d+,.]*) (?<currency>\\w{3})").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("date").match("VERRECHNUNGSKONTO VALUTA BETRAG").match("\\w* (?<date>\\d+\\.\\d+\\.\\d{4}|\\d{4}-\\d+-\\d+) .*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).wrap(Extractor.BuySellEntryItem::new));
        PDFParser.Block taxBlock = new PDFParser.Block(".*Kapitalertragssteuer Optimierung.*");
        type.addBlock(taxBlock);
        taxBlock.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.TAX_REFUND);
            return t;
        }).section("tax", "currency", "date").optional().match(".*Kapitalertragssteuer Optimierung (?<tax>[\\d+,.]*) (?<currency>\\w{3}+)").match("VERRECHNUNGSKONTO VALUTA BETRAG").match(".* (?<date>\\d+\\.\\d+\\.\\d{4}|\\d{4}-\\d+-\\d+) ([\\d+,.]*) (\\w{3}+)").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("tax")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
        }).section("tax", "currency", "date").optional().match("Solidarit\u00e4tszuschlag Optimierung (?<tax>[\\d+,.]*) (?<currency>\\w{3}+)").match("VERRECHNUNGSKONTO VALUTA BETRAG").match(".* (?<date>\\d+\\.\\d+\\.\\d{4}|\\d{4}-\\d+-\\d+) ([\\d+,.]*) (\\w{3}+)").assign((t, v) -> {
            t.setAmount(t.getAmount() + this.asAmount((String)v.get("tax")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
        }).section("tax", "currency", "date").optional().match("Kirchensteuer Optimierung (?<tax>[\\d+,.]*) (?<currency>\\w{3}+)").match("VERRECHNUNGSKONTO VALUTA BETRAG").match(".* (?<date>\\d+\\.\\d+\\.\\d{4}|\\d{4}-\\d+-\\d+) ([\\d+,.]*) (\\w{3}+)").assign((t, v) -> {
            t.setAmount(t.getAmount() + this.asAmount((String)v.get("tax")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setDateTime(this.asDate((String)v.get("date")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
    }

    private void addAccountStatementTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("KONTOAUSZUG", (context, lines) -> {
            Pattern currency = Pattern.compile("BUCHUNGSTAG / BUCHUNGSTEXT BETRAG IN (?<currency>\\w{3}+)");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = currency.matcher(line);
                if (m.matches()) {
                    context.put("currency", m.group(1));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("\\d+.\\d+.\\d{4}+ Accepted PayIn.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DEPOSIT);
            return t;
        }).section("date", "amount").match("(?<date>\\d+\\.\\d+\\.\\d{4}|\\d{4}-\\d+-\\d+) Accepted PayIn:.* to.* (?<amount>[\\d+,.]*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode(type.getCurrentContext().get("currency")));
        }).wrap(Extractor.TransactionItem::new));
    }

    @Override
    public String getLabel() {
        return "Trade Republic";
    }
}

