/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.util.Map;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class UnicreditPDFExtractor
extends AbstractPDFExtractor {
    public UnicreditPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("UniCredit Bank AG");
        this.addBuyTransaction();
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("UniCredit");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("W e r t p a p i e r - A b r e c h n u n g K a u f .*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("name", "wkn", "isin").find("Nennbetrag Wertpapierbezeichnung Wertpapierkennnummer/ISIN").match("^(?<name>.*) (?<wkn>[^ ]*)$").match("^.* (?<isin>[A-Z]{2}[A-Z\\d]{9}\\d)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("^ST *(?<shares>[\\.\\d]+[,\\d]*)$").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("amount", "currency").match("^Belastung.* (?<currency>\\w{3}) (?<amount>[\\d.]+,\\d{2})$").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("date").match("^Valuta (?<date>\\d+\\.\\d+\\.\\d{4}) .*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("fee", "currency").optional().match("^Brokerkommission.* (?<currency>\\w{3}) (?<fee>[\\d.]+,\\d{2})$").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match("^Transaktionsentgelt.* (?<currency>\\w{3}) (?<fee>[\\d.]+,\\d{2})$").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match("^Provision.* (?<currency>\\w{3}) (?<fee>[\\d.]+,\\d{2})$").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).wrap(t -> new Extractor.BuySellEntryItem((BuySellEntry)t)));
    }

    @Override
    public String getLabel() {
        return "UniCredit / HypoVereinsbank";
    }
}

