/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.util.Map;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.datatransfer.pdf.SwissBasedPDFExtractor;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class ViacPDFExtractor
extends SwissBasedPDFExtractor {
    public ViacPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("Terzo");
        this.addBankIdentifier("WIR Bank");
        this.addDepositTransaction();
        this.addDepositTransactionEnglish();
        this.addBuyTransaction();
        this.addBuyTransactionEnglish();
        this.addSellTransaction();
        this.addSellTransactionEnglish();
        this.addInterestTransaction();
        this.addInterestTransactionEnglish();
        this.addFeeTransaction();
        this.addFeeTransactionEnglish();
        this.addDividendsTransaction();
        this.addDividendsTransactionEnglish();
        this.addTaxRefundTransaction();
    }

    private void addDepositTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Einzahlung 3a");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Einzahlung 3a");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DEPOSIT);
            return transaction;
        }).section("date", "amount", "currency").find("Einzahlung 3a").match("Gutschrift: Valuta (?<date>\\d+.\\d+.\\d{4}+) (?<currency>\\w{3}+) (?<amount>-?[\\d+',.]*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addDepositTransactionEnglish() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Deposit 3a");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Deposit 3a");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DEPOSIT);
            return transaction;
        }).section("date", "amount", "currency").find("Deposit 3a").match("Credit: Value date (?<date>\\d+.\\d+.\\d{4}+) (?<currency>\\w{3}+) (?<amount>-?[\\d+',.]*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("B.rsenabrechnung - Kauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("B.rsenabrechnung - Kauf");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("isin", "name", "currency", "shares").find("Order: Kauf").match("(?<shares>[\\d+,.]*) Ant (?<name>.*)$").match("ISIN: (?<isin>\\S*)").match("Kurs: (?<currency>\\w{3}+) .*").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("date", "amount", "currency").match("Verrechneter Betrag: Valuta (?<date>\\d+.\\d+.\\d{4}+) (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)").assign((t, v) -> {
            t.setDate(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("tax", "currency").optional().match("Stempelsteuer (?<currency>\\w{3}+) (?<tax>[\\d+',.]*)").assign((t, v) -> {
            Money tax = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")));
            if (tax.getCurrencyCode().equals(t.getAccountTransaction().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, tax));
            }
        }).section("forex", "forexCurrency", "amount", "currency", "exchangeRate").optional().match("Betrag (?<forexCurrency>\\w{3}+) (?<forex>[\\d+',.]*)").match("Umrechnungskurs CHF/\\w{3}+ (?<exchangeRate>[\\d+',.]*) (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)").assign((t, v) -> {
            Money forex = Money.of(this.asCurrencyCode((String)v.get("forexCurrency")), this.asAmount((String)v.get("forex")));
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            Money gross = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
            if (forex.getCurrencyCode().equals(t.getPortfolioTransaction().getSecurity().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, gross, forex, exchangeRate));
            }
        }).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addBuyTransactionEnglish() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Exchange Settlement - Buy");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Exchange Settlement - Buy");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("isin", "name", "currency", "shares").find("Order: Buy").match("(?<shares>[\\d+,.]*) Qty (?<name>.*)$").match("ISIN: (?<isin>\\S*)").match("Price: (?<currency>\\w{3}+) .*").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("date", "amount", "currency").match("Charged amount: Value date (?<date>\\d+.\\d+.\\d{4}+) (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)").assign((t, v) -> {
            t.setDate(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("tax", "currency").optional().match("Stamp duty (?<currency>\\w{3}+) (?<tax>[\\d+',.]*)").assign((t, v) -> {
            Money tax = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")));
            if (tax.getCurrencyCode().equals(t.getAccountTransaction().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, tax));
            }
        }).section("forex", "forexCurrency", "amount", "currency", "exchangeRate").optional().match("Amount (?<forexCurrency>\\w{3}+) (?<forex>[\\d+',.]*)").match("Exchange rate CHF/\\w{3}+ (?<exchangeRate>[\\d+',.]*) (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)").assign((t, v) -> {
            Money forex = Money.of(this.asCurrencyCode((String)v.get("forexCurrency")), this.asAmount((String)v.get("forex")));
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            Money gross = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
            if (forex.getCurrencyCode().equals(t.getPortfolioTransaction().getSecurity().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, gross, forex, exchangeRate));
            }
        }).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("abrechnung - Verkauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("B.rsenabrechnung - Verkauf");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("isin", "name", "currency", "shares").find("Order: Verkauf").match("(?<shares>[\\d+,.]*) Ant (?<name>.*)$").match("ISIN: (?<isin>\\S*)").match("Kurs: (?<currency>\\w{3}+) .*").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("date", "amount", "currency").match("Verrechneter Betrag: Valuta (?<date>\\d+.\\d+.\\d{4}+) (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)").assign((t, v) -> {
            t.setDate(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("forex", "forexCurrency", "amount", "currency", "exchangeRate").optional().match("Betrag (?<forexCurrency>\\w{3}+) (?<forex>[\\d+',.]*)").match("Umrechnungskurs CHF/\\w{3}+ (?<exchangeRate>[\\d+',.]*) (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)").assign((t, v) -> {
            Money forex = Money.of(this.asCurrencyCode((String)v.get("forexCurrency")), this.asAmount((String)v.get("forex")));
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            Money gross = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
            if (forex.getCurrencyCode().equals(t.getPortfolioTransaction().getSecurity().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, gross, forex, exchangeRate));
            }
        }).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addSellTransactionEnglish() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Exchange Settlement - Sell");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Exchange Settlement - Sell");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("isin", "name", "currency", "shares").find("Order: Sell").match("(?<shares>[\\d+,.]*) Qty (?<name>.*)$").match("ISIN: (?<isin>\\S*)").match("Price: (?<currency>\\w{3}+) .*").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("date", "amount", "currency").match("Charged amount: Value date (?<date>\\d+.\\d+.\\d{4}+) (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)").assign((t, v) -> {
            t.setDate(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("forex", "forexCurrency", "amount", "currency", "exchangeRate").optional().match("Amount (?<forexCurrency>\\w{3}+) (?<forex>[\\d+',.]*)").match("Exchange rate CHF/\\w{3}+ (?<exchangeRate>[\\d+',.]*) (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)").assign((t, v) -> {
            Money forex = Money.of(this.asCurrencyCode((String)v.get("forexCurrency")), this.asAmount((String)v.get("forex")));
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            Money gross = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
            if (forex.getCurrencyCode().equals(t.getPortfolioTransaction().getSecurity().getCurrencyCode())) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, gross, forex, exchangeRate));
            }
        }).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addInterestTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Zins");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Zins");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.INTEREST);
            return transaction;
        }).section("date", "amount", "currency").find("Zins").match("Am (?<date>\\d+.\\d+.\\d{4}+) haben wir Ihrem Konto gutgeschrieben:").match("Zinsgutschrift: (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addInterestTransactionEnglish() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Interest");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Interest");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.INTEREST);
            return transaction;
        }).section("date", "amount", "currency").find("Interest").match("On (?<date>\\d+.\\d+.\\d{4}+) we have credited your account:").match("Interest credit: (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addFeeTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Belastung");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Belastung");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.FEES);
            return transaction;
        }).section("date", "amount", "currency").find("Belastung").match("Verrechneter Betrag: Valuta (?<date>\\d+.\\d+.\\d{4}+) (?<currency>\\w{3}+) (?<amount>-?[\\d+',.]*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addFeeTransactionEnglish() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Commission");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Commission");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.FEES);
            return transaction;
        }).section("date", "amount", "currency").find("Commission").match("Charged amount: Value date (?<date>\\d+.\\d+.\\d{4}+) (?<currency>\\w{3}+) (?<amount>-?[\\d+',.]*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addDividendsTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Dividendenaussch");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Dividendenart: Ordentliche Dividende");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DIVIDENDS);
            return transaction;
        }).section("shares", "name", "isin", "currency").match("(?<shares>[\\d+,.]*) Ant (?<name>.*)$").match("ISIN: (?<isin>\\S*)").match("Aussch.ttung: (?<currency>\\w{3}+) .*").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("date", "amount", "currency").match("Gutgeschriebener Betrag: Valuta (?<date>\\d+.\\d+.\\d{4}+) (?<currency>\\w{3}+) (?<amount>-?[\\d+',.]*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("forex", "forexCurrency", "amount", "currency", "exchangeRate").optional().match("Betrag (?<forexCurrency>\\w{3}+) (?<forex>[\\d+',.]*)").match("Umrechnungskurs CHF/\\w{3}+ (?<exchangeRate>[\\d+',.]*) (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)").assign((t, v) -> {
            Money forex = Money.of(this.asCurrencyCode((String)v.get("forexCurrency")), this.asAmount((String)v.get("forex")));
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            Money gross = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
            if (forex.getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, gross, forex, exchangeRate));
            }
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addDividendsTransactionEnglish() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Dividend Payment");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Type of dividend: Ordinary dividend");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DIVIDENDS);
            return transaction;
        }).section("shares", "name", "isin", "currency").match("(?<shares>[\\d+,.]*) Qty (?<name>.*)$").match("ISIN: (?<isin>\\S*)").match("Dividend payment: (?<currency>\\w{3}+) .*").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("date", "amount", "currency").match("Amount credited: Value date (?<date>\\d+.\\d+.\\d{4}+) (?<currency>\\w{3}+) (?<amount>-?[\\d+',.]*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("forex", "forexCurrency", "amount", "currency", "exchangeRate").optional().match("Amount (?<forexCurrency>\\w{3}+) (?<forex>[\\d+',.]*)").match("Exchange rate CHF/\\w{3}+ (?<exchangeRate>[\\d+',.]*) (?<currency>\\w{3}+) (?<amount>[\\d+',.]*)").assign((t, v) -> {
            Money forex = Money.of(this.asCurrencyCode((String)v.get("forexCurrency")), this.asAmount((String)v.get("forex")));
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            Money gross = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
            if (forex.getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, gross, forex, exchangeRate));
            }
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addTaxRefundTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Dividendenaussch");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Dividendenart: R.ckerstattung Quellensteuer");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.TAX_REFUND);
            return transaction;
        }).section("shares", "name", "isin", "currency").match("(?<shares>[\\d+,.]*) Ant (?<name>.*)$").match("ISIN: (?<isin>\\S*)").match("Aussch.ttung: (?<currency>\\w{3}+) .*").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("date", "amount", "currency").match("Gutgeschriebener Betrag: Valuta (?<date>\\d+.\\d+.\\d{4}+) (?<currency>\\w{3}+) (?<amount>-?[\\d+',.]*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            if (!t.getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                t.setNote(t.getSecurity().getName());
                t.setSecurity(null);
                t.setShares(0L);
            }
        }).wrap(Extractor.TransactionItem::new));
    }

    @Override
    public String getLabel() {
        return "VIAC";
    }
}

