/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.json;

import java.math.BigDecimal;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Values;

public class JTransactionUnit {
    private Transaction.Unit.Type type;
    private Double amount;
    private String fxCurrency;
    private Double fxAmount;
    private BigDecimal fxRateToBase;

    public Transaction.Unit.Type getType() {
        return this.type;
    }

    public void setType(Transaction.Unit.Type type) {
        this.type = type;
    }

    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public String getFxCurrency() {
        return this.fxCurrency;
    }

    public void setFxCurrency(String fxCurrency) {
        this.fxCurrency = fxCurrency;
    }

    public Double getFxAmount() {
        return this.fxAmount;
    }

    public void setFxAmount(Double fxAmount) {
        this.fxAmount = fxAmount;
    }

    public BigDecimal getFxRateToBase() {
        return this.fxRateToBase;
    }

    public void setFxRateToBase(BigDecimal fxRateToBase) {
        this.fxRateToBase = fxRateToBase;
    }

    public static JTransactionUnit from(Transaction.Unit unit) {
        JTransactionUnit u = new JTransactionUnit();
        u.type = unit.getType();
        u.amount = (double)unit.getAmount().getAmount() / Values.Amount.divider();
        if (unit.getForex() != null) {
            u.fxCurrency = unit.getForex().getCurrencyCode();
            u.fxAmount = (double)unit.getForex().getAmount() / Values.Amount.divider();
            u.fxRateToBase = unit.getExchangeRate();
        }
        return u;
    }
}

