/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.math;

import java.time.LocalDate;
import java.util.List;
import name.abuchen.portfolio.math.NPVFunction;
import name.abuchen.portfolio.math.NewtonGoalSeek;
import name.abuchen.portfolio.math.PseudoDerivativeFunction;

public final class IRR {
    private IRR() {
    }

    public static double calculate(List<LocalDate> dates, List<Double> values) {
        NPVFunction npv = new NPVFunction(dates, values);
        PseudoDerivativeFunction derivative = new PseudoDerivativeFunction(npv);
        return NewtonGoalSeek.seek(npv, derivative, 0.05) - 1.0;
    }
}

