/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.math;

import java.time.LocalDate;
import java.util.Objects;
import java.util.function.IntPredicate;
import name.abuchen.portfolio.util.Interval;

public final class Risk {
    private Risk() {
    }

    public static class Drawdown {
        private double maxDD;
        private Interval maxDDDuration;
        private Interval intervalMaxDD;
        private Interval recoveryTime;

        public Drawdown(double[] values, LocalDate[] dates, int startAt) {
            if (values.length != dates.length) {
                throw new IllegalArgumentException();
            }
            if (startAt >= values.length) {
                throw new IllegalArgumentException();
            }
            double peak = values[startAt] + 1.0;
            double bottom = values[startAt] + 1.0;
            LocalDate lastPeakDate = dates[startAt];
            LocalDate lastBottomDate = dates[startAt];
            this.maxDD = 0.0;
            this.intervalMaxDD = Interval.of(lastPeakDate, lastPeakDate);
            this.maxDDDuration = Interval.of(lastPeakDate, lastPeakDate);
            this.recoveryTime = Interval.of(lastBottomDate, lastPeakDate);
            Interval currentDrawdownDuration = null;
            Interval currentRecoveryTime = null;
            int ii = startAt;
            while (ii < values.length) {
                double value = values[ii] + 1.0;
                currentDrawdownDuration = Interval.of(lastPeakDate, dates[ii]);
                currentRecoveryTime = Interval.of(lastBottomDate, dates[ii]);
                if (value > peak) {
                    peak = value;
                    lastPeakDate = dates[ii];
                    if (currentDrawdownDuration.isLongerThan(this.maxDDDuration)) {
                        this.maxDDDuration = currentDrawdownDuration;
                    }
                    if (currentRecoveryTime.isLongerThan(this.recoveryTime)) {
                        this.recoveryTime = currentRecoveryTime;
                    }
                    lastBottomDate = dates[ii];
                    bottom = value;
                } else {
                    double drawdown = (peak - value) / peak;
                    if (drawdown > this.maxDD) {
                        this.maxDD = drawdown;
                        this.intervalMaxDD = Interval.of(lastPeakDate, dates[ii]);
                    }
                }
                if (value < bottom) {
                    bottom = value;
                    lastBottomDate = dates[ii];
                }
                ++ii;
            }
            if (currentDrawdownDuration != null && currentDrawdownDuration.isLongerThan(this.maxDDDuration)) {
                this.maxDDDuration = currentDrawdownDuration;
            }
            if (currentRecoveryTime != null && currentRecoveryTime.isLongerThan(this.recoveryTime)) {
                this.recoveryTime = currentRecoveryTime;
            }
        }

        public Interval getLongestRecoveryTime() {
            return this.recoveryTime;
        }

        public double getMaxDrawdown() {
            return this.maxDD;
        }

        public Interval getIntervalOfMaxDrawdown() {
            return this.intervalMaxDD;
        }

        public Interval getMaxDrawdownDuration() {
            return this.maxDDDuration;
        }
    }

    public static class Volatility {
        private final double stdDeviation;
        private final double semiDeviation;

        public Volatility(double[] returns, IntPredicate filter) {
            Objects.requireNonNull(returns);
            double tempStandard = 0.0;
            double tempSemi = 0.0;
            int count = 0;
            double averageLogReturn = this.logAverage(returns, filter);
            int ii = 0;
            while (ii < returns.length) {
                if (filter.test(ii)) {
                    double logReturn = Math.log(1.0 + returns[ii]);
                    double add = Math.pow(logReturn - averageLogReturn, 2.0);
                    tempStandard += add;
                    ++count;
                    if (logReturn < averageLogReturn) {
                        tempSemi += add;
                    }
                }
                ++ii;
            }
            if (count <= 1) {
                this.stdDeviation = 0.0;
                this.semiDeviation = 0.0;
            } else {
                this.stdDeviation = Math.sqrt(tempStandard / (double)(count - 1) * (double)count);
                this.semiDeviation = Math.sqrt(tempSemi / (double)(count - 1) * (double)count);
            }
        }

        private double logAverage(double[] returns, IntPredicate filter) {
            double sum = 0.0;
            int count = 0;
            int ii = 0;
            while (ii < returns.length) {
                if (filter.test(ii)) {
                    sum += Math.log(1.0 + returns[ii]);
                    ++count;
                }
                ++ii;
            }
            if (count == 0) {
                return 0.0;
            }
            return sum / (double)count;
        }

        public double getStandardDeviation() {
            return this.stdDeviation;
        }

        public double getSemiDeviation() {
            return this.semiDeviation;
        }

        public double getExpectedSemiDeviation() {
            return this.stdDeviation / Math.sqrt(2.0);
        }

        public String getNormalizedSemiDeviationComparison() {
            double expectedSemiDeviation = this.getExpectedSemiDeviation();
            if (expectedSemiDeviation > this.semiDeviation) {
                return ">";
            }
            if (expectedSemiDeviation < this.semiDeviation) {
                return "<";
            }
            return "=";
        }
    }
}

