/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.time.LocalDateTime;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Annotated;
import name.abuchen.portfolio.model.CrossEntry;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;

public class AccountTransferEntry
implements CrossEntry,
Annotated {
    private Account accountFrom;
    private AccountTransaction transactionFrom = new AccountTransaction();
    private Account accountTo;
    private AccountTransaction transactionTo;

    public AccountTransferEntry() {
        this.transactionFrom.setType(AccountTransaction.Type.TRANSFER_OUT);
        this.transactionFrom.setCrossEntry(this);
        this.transactionTo = new AccountTransaction();
        this.transactionTo.setType(AccountTransaction.Type.TRANSFER_IN);
        this.transactionTo.setCrossEntry(this);
    }

    public AccountTransferEntry(Account accountFrom, Account accountTo) {
        this();
        this.accountFrom = accountFrom;
        this.accountTo = accountTo;
    }

    public void setSourceTransaction(AccountTransaction transaction) {
        this.transactionFrom = transaction;
    }

    public void setTargetTransaction(AccountTransaction transaction) {
        this.transactionTo = transaction;
    }

    public AccountTransaction getSourceTransaction() {
        return this.transactionFrom;
    }

    public AccountTransaction getTargetTransaction() {
        return this.transactionTo;
    }

    public void setSourceAccount(Account account) {
        this.accountFrom = account;
    }

    public Account getSourceAccount() {
        return this.accountFrom;
    }

    public void setTargetAccount(Account account) {
        this.accountTo = account;
    }

    public Account getTargetAccount() {
        return this.accountTo;
    }

    public void setDate(LocalDateTime date) {
        this.transactionFrom.setDateTime(date);
        this.transactionTo.setDateTime(date);
    }

    public void setAmount(long amount) {
        this.transactionFrom.setAmount(amount);
        this.transactionTo.setAmount(amount);
    }

    public void setCurrencyCode(String currencyCode) {
        this.transactionFrom.setCurrencyCode(currencyCode);
        this.transactionTo.setCurrencyCode(currencyCode);
    }

    @Override
    public String getNote() {
        return this.transactionFrom.getNote();
    }

    @Override
    public void setNote(String note) {
        this.transactionFrom.setNote(note);
        this.transactionTo.setNote(note);
    }

    @Override
    public void insert() {
        this.accountFrom.addTransaction(this.transactionFrom);
        this.accountTo.addTransaction(this.transactionTo);
    }

    @Override
    public void updateFrom(Transaction t) {
        if (t == this.transactionFrom) {
            this.copyAttributesOver(this.transactionFrom, this.transactionTo);
        } else if (t == this.transactionTo) {
            this.copyAttributesOver(this.transactionTo, this.transactionFrom);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void copyAttributesOver(AccountTransaction source, AccountTransaction target) {
        target.setDateTime(source.getDateTime());
        target.setNote(source.getNote());
    }

    @Override
    public TransactionOwner<? extends Transaction> getOwner(Transaction t) {
        if (t.equals(this.transactionFrom)) {
            return this.accountFrom;
        }
        if (t.equals(this.transactionTo)) {
            return this.accountTo;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOwner(Transaction t, TransactionOwner<? extends Transaction> owner) {
        if (!(owner instanceof Account)) {
            throw new IllegalArgumentException();
        }
        if (t.equals(this.transactionFrom) && !this.accountTo.equals(owner)) {
            this.accountFrom = (Account)owner;
        } else if (t.equals(this.transactionTo) && !this.accountFrom.equals(owner)) {
            this.accountTo = (Account)owner;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Transaction getCrossTransaction(Transaction t) {
        if (t.equals(this.transactionFrom)) {
            return this.transactionTo;
        }
        if (t.equals(this.transactionTo)) {
            return this.transactionFrom;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public TransactionOwner<? extends Transaction> getCrossOwner(Transaction t) {
        if (t.equals(this.transactionFrom)) {
            return this.accountTo;
        }
        if (t.equals(this.transactionTo)) {
            return this.accountFrom;
        }
        throw new UnsupportedOperationException();
    }
}

