/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Dashboard {
    private String name;
    private Map<String, String> configuration;
    private List<Column> columns;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, String>();
        }
        return this.configuration;
    }

    public List<Column> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>();
        }
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public Dashboard copy() {
        Dashboard copy = new Dashboard();
        copy.setName(this.name);
        copy.getConfiguration().putAll(this.getConfiguration());
        for (Column column : this.columns) {
            Column copyColumn = new Column();
            column.getWidgets().stream().map(w -> {
                Widget c = new Widget();
                c.setLabel(w.getLabel());
                c.setType(w.getType());
                c.getConfiguration().putAll(w.getConfiguration());
                return c;
            }).forEach(copyColumn.getWidgets()::add);
            copy.getColumns().add(copyColumn);
        }
        return copy;
    }

    public static final class Column {
        private int weight = 1;
        private List<Widget> widgets = new ArrayList<Widget>();

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            if (weight <= 0) {
                throw new IllegalArgumentException();
            }
            this.weight = weight;
        }

        public List<Widget> getWidgets() {
            return this.widgets;
        }

        public void setWidgets(List<Widget> widgets) {
            this.widgets = widgets;
        }

        public void increaseWeight() {
            ++this.weight;
        }

        public void decreaseWeight() {
            if (this.weight > 1) {
                --this.weight;
            }
        }
    }

    public static enum Config {
        REPORTING_PERIOD,
        DATA_SERIES,
        SECONDARY_DATA_SERIES,
        CONFIG_UUID,
        AGGREGATION,
        EXCHANGE_RATE_SERIES,
        COLOR_SCHEMA,
        LAYOUT,
        HEIGHT,
        EARNING_TYPE,
        NET_GROSS,
        CLIENT_FILTER,
        CALCULATION_METHOD,
        METRIC;

    }

    public static final class Widget {
        private String type;
        private String label;
        private Map<String, String> configuration;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public Map<String, String> getConfiguration() {
            if (this.configuration == null) {
                this.configuration = new HashMap<String, String>();
            }
            return this.configuration;
        }
    }
}

