/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.util.HashMap;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.AttributeType;
import name.abuchen.portfolio.util.ImageUtil;
import org.eclipse.swt.graphics.Image;

public final class ImageManager {
    private HashMap<String, Image> imageCache = new HashMap();
    private static ImageManager instance = new ImageManager();

    public static ImageManager instance() {
        return instance;
    }

    private ImageManager() {
    }

    public Image getImage(Attributable target, AttributeType attr) {
        return this.getImage(target, attr, 16, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(Attributable target, AttributeType attr, int width, int height) {
        if (target != null && target.getAttributes().exists(attr) && attr.getConverter() instanceof AttributeType.ImageConverter) {
            String imgString = target.getAttributes().get(attr).toString();
            String imgKey = String.valueOf(imgString) + width + height;
            HashMap<String, Image> hashMap = this.imageCache;
            synchronized (hashMap) {
                Image img = this.imageCache.getOrDefault(imgKey, null);
                if (img != null) {
                    return img;
                }
                img = ImageUtil.toImage(imgString, width, height);
                if (img != null) {
                    this.imageCache.put(imgKey, img);
                    return img;
                }
            }
        }
        return null;
    }
}

