/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.time.LocalDate;
import java.util.Objects;
import java.util.ResourceBundle;
import name.abuchen.portfolio.money.Money;

public class SecurityEvent {
    private LocalDate date;
    private Type type;
    private String details;

    public SecurityEvent() {
    }

    public SecurityEvent(LocalDate date, Type type, String details) {
        this.date = date;
        this.type = type;
        this.details = details;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.date, this.details, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityEvent other = (SecurityEvent)obj;
        return Objects.equals(this.date, other.date) && Objects.equals(this.details, other.details) && this.type == other.type;
    }

    public static class DividendEvent
    extends SecurityEvent {
        private LocalDate paymentDate;
        private Money amount;
        private String source;

        public DividendEvent() {
            super(null, Type.DIVIDEND_PAYMENT, null);
        }

        public DividendEvent(LocalDate exDate, LocalDate payDate, Money amount, String source) {
            super(exDate, Type.DIVIDEND_PAYMENT, null);
            this.paymentDate = payDate;
            this.amount = amount;
            this.source = source;
        }

        @Override
        public void setType(Type type) {
            if (type != Type.DIVIDEND_PAYMENT) {
                throw new IllegalArgumentException();
            }
        }

        public LocalDate getPaymentDate() {
            return this.paymentDate;
        }

        public void setPaymentDate(LocalDate payDate) {
            this.paymentDate = payDate;
        }

        public Money getAmount() {
            return this.amount;
        }

        public void setAmount(Money amount) {
            this.amount = amount;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.amount, this.paymentDate, this.source);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DividendEvent other = (DividendEvent)obj;
            return Objects.equals(this.amount, other.amount) && Objects.equals(this.paymentDate, other.paymentDate) && Objects.equals(this.source, other.source);
        }
    }

    public static enum Type {
        STOCK_SPLIT(false),
        NOTE(true),
        DIVIDEND_PAYMENT(false);

        private static final ResourceBundle RESOURCES;
        private boolean isUserEditable;

        static {
            RESOURCES = ResourceBundle.getBundle("name.abuchen.portfolio.model.labels");
        }

        private Type(boolean isUserEditable) {
            this.isUserEditable = isUserEditable;
        }

        public boolean isUserEditable() {
            return this.isUserEditable;
        }

        public String toString() {
            return RESOURCES.getString("event." + this.name());
        }
    }
}

