/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Adaptable;
import name.abuchen.portfolio.model.Annotated;
import name.abuchen.portfolio.model.CrossEntry;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MoneyCollectors;
import name.abuchen.portfolio.money.Values;

public abstract class Transaction
implements Annotated,
Adaptable {
    private LocalDateTime date;
    private String currencyCode;
    private long amount;
    private Security security;
    private CrossEntry crossEntry;
    private long shares;
    private String note;
    private List<Unit> units;

    public Transaction() {
    }

    public Transaction(LocalDateTime date, String currencyCode, long amount) {
        this(date, currencyCode, amount, null, 0L, null);
    }

    public Transaction(LocalDateTime date, String currencyCode, long amount, Security security, long shares, String note) {
        this.date = date;
        this.currencyCode = currencyCode;
        this.amount = amount;
        this.security = security;
        this.shares = shares;
        this.note = note;
    }

    public LocalDateTime getDateTime() {
        return this.date;
    }

    public void setDateTime(LocalDateTime date) {
        this.date = date;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public Money getMonetaryAmount() {
        return Money.of(this.currencyCode, this.amount);
    }

    public void setMonetaryAmount(Money value) {
        this.currencyCode = value.getCurrencyCode();
        this.amount = value.getAmount();
    }

    public Security getSecurity() {
        return this.security;
    }

    public Optional<Security> getOptionalSecurity() {
        return Optional.ofNullable(this.security);
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public CrossEntry getCrossEntry() {
        return this.crossEntry;
    }

    void setCrossEntry(CrossEntry crossEntry) {
        this.crossEntry = crossEntry;
    }

    public long getShares() {
        return this.shares;
    }

    public void setShares(long shares) {
        this.shares = shares;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public void setNote(String note) {
        this.note = note;
    }

    public Stream<Unit> getUnits() {
        return this.units != null ? this.units.stream() : Stream.empty();
    }

    public Optional<Unit> getUnit(Unit.Type type) {
        return this.getUnits().filter(u -> u.getType() == type).findAny();
    }

    public void clearUnits() {
        this.units = null;
    }

    public void addUnit(Unit unit) {
        Objects.requireNonNull(unit.getAmount());
        if (!unit.getAmount().getCurrencyCode().equals(this.currencyCode)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.MsgErrorUnitCurrencyMismatch, unit.getType().toString(), unit.getAmount().getCurrencyCode(), this.currencyCode));
        }
        if (this.units == null) {
            this.units = new ArrayList<Unit>();
        }
        this.units.add(unit);
    }

    public void addUnits(Stream<Unit> items) {
        if (this.units == null) {
            this.units = new ArrayList<Unit>();
        }
        items.forEach(this.units::add);
    }

    public void removeUnit(Unit unit) {
        if (this.units == null) {
            this.units = new ArrayList<Unit>();
        }
        this.units.remove(unit);
    }

    public Money getUnitSum(Unit.Type type) {
        return this.getUnits().filter(u -> u.getType() == type).collect(MoneyCollectors.sum(this.getCurrencyCode(), Unit::getAmount));
    }

    public Money getUnitSum(Unit.Type first, Unit.Type ... rest) {
        EnumSet<Unit.Type[]> set = EnumSet.of(first, rest);
        return this.getUnits().filter(u -> set.contains((Object)u.getType())).collect(MoneyCollectors.sum(this.getCurrencyCode(), Unit::getAmount));
    }

    public Money getUnitSum(Unit.Type type, CurrencyConverter converter) {
        return this.getUnits().filter(u -> u.getType() == type).collect(MoneyCollectors.sum(converter.getTermCurrency(), unit -> {
            if (converter.getTermCurrency().equals(unit.getAmount().getCurrencyCode())) {
                return unit.getAmount();
            }
            if (unit.getForex() != null && converter.getTermCurrency().equals(unit.getForex().getCurrencyCode())) {
                return unit.getForex();
            }
            return unit.getAmount().with(converter.at(this.date));
        }));
    }

    public static final <E extends Transaction> List<E> sortByDate(List<E> transactions) {
        Collections.sort(transactions, new ByDate());
        return transactions;
    }

    @Override
    public <T> T adapt(Class<T> type) {
        if (type == Security.class) {
            return type.cast(this.security);
        }
        return null;
    }

    public static final class ByDate
    implements Comparator<Transaction>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Transaction t1, Transaction t2) {
            return t1.getDateTime().compareTo(t2.getDateTime());
        }
    }

    public static class Unit {
        private final Type type;
        private final Money amount;
        private final Money forex;
        private final BigDecimal exchangeRate;

        public Unit(Type type, Money amount) {
            this.type = Objects.requireNonNull(type);
            this.amount = Objects.requireNonNull(amount);
            this.forex = null;
            this.exchangeRate = null;
        }

        public Unit(Type type, Money amount, Money forex, BigDecimal exchangeRate) {
            this(type, amount, forex, exchangeRate, true);
        }

        private Unit(Type type, Money amount, Money forex, BigDecimal exchangeRate, boolean doValidityCheck) {
            this.type = Objects.requireNonNull(type);
            this.amount = Objects.requireNonNull(amount);
            this.forex = Objects.requireNonNull(forex);
            this.exchangeRate = Objects.requireNonNull(exchangeRate);
            if (doValidityCheck) {
                long upper = Math.round(exchangeRate.add(BigDecimal.valueOf(0.003)).multiply(BigDecimal.valueOf(forex.getAmount())).doubleValue());
                long lower = Math.round(exchangeRate.add(BigDecimal.valueOf(-0.003)).multiply(BigDecimal.valueOf(forex.getAmount())).doubleValue());
                if (amount.getAmount() < lower || amount.getAmount() > upper) {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.MsgErrorIllegalForexUnit, type.toString(), Values.Money.format(forex), exchangeRate, Values.Money.format(amount)));
                }
            }
        }

        public Unit split(double weight) {
            Money newAmount = Money.of(this.amount.getCurrencyCode(), Math.round((double)this.amount.getAmount() * weight));
            if (this.forex == null) {
                return new Unit(this.type, newAmount);
            }
            Money newForex = Money.of(this.forex.getCurrencyCode(), Math.round((double)this.forex.getAmount() * weight));
            return new Unit(this.type, newAmount, newForex, this.exchangeRate, false);
        }

        public Type getType() {
            return this.type;
        }

        public Money getAmount() {
            return this.amount;
        }

        public Money getForex() {
            return this.forex;
        }

        public BigDecimal getExchangeRate() {
            return this.exchangeRate;
        }

        public String toString() {
            return String.format("%-17s %s %s %s", this.type.name(), this.amount.toString(), this.forex != null ? this.forex.toString() : "<no forex>", this.exchangeRate != null ? this.exchangeRate.toString() : "<no exchange>");
        }

        public static enum Type {
            GROSS_VALUE,
            TAX,
            FEE;

        }
    }
}

