/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.Objects;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.ExchangeRateTimeSeries;
import name.abuchen.portfolio.money.MonetaryException;

public class CurrencyConverterImpl
implements CurrencyConverter {
    private static final ExchangeRate FALLBACK_EXCHANGE_RATE = new ExchangeRate(LocalDate.now(), BigDecimal.ONE);
    private final ExchangeRateProviderFactory factory;
    private final String termCurrency;

    public CurrencyConverterImpl(ExchangeRateProviderFactory factory, String termCurrency) {
        this.factory = Objects.requireNonNull(factory);
        this.termCurrency = Objects.requireNonNull(termCurrency);
    }

    @Override
    public String getTermCurrency() {
        return this.termCurrency;
    }

    @Override
    public ExchangeRate getRate(LocalDate date, String currencyCode) {
        if (this.termCurrency.equals(currencyCode)) {
            return new ExchangeRate(date, BigDecimal.ONE);
        }
        ExchangeRateTimeSeries series = this.lookupSeries(currencyCode);
        return series.lookupRate(date).orElse(FALLBACK_EXCHANGE_RATE);
    }

    private ExchangeRateTimeSeries lookupSeries(String currencyCode) {
        ExchangeRateTimeSeries series = this.factory.getTimeSeries(currencyCode, this.termCurrency);
        if (series == null) {
            throw new MonetaryException(MessageFormat.format(Messages.MsgNoExchangeRateTimeSeriesFound, currencyCode, this.termCurrency));
        }
        return series;
    }

    @Override
    public CurrencyConverter with(String currencyCode) {
        if (currencyCode.equals(this.termCurrency)) {
            return this;
        }
        return new CurrencyConverterImpl(this.factory, currencyCode);
    }
}

