/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money;

import java.math.BigDecimal;
import java.util.Objects;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;

public final class Quote
implements Comparable<Quote> {
    private final String currencyCode;
    private final long amount;

    private Quote(String currencyCode, long amount) {
        Objects.requireNonNull(currencyCode);
        this.currencyCode = currencyCode;
        this.amount = amount;
    }

    public static Quote of(String currencyCode, long amount) {
        return new Quote(currencyCode, amount);
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public long getAmount() {
        return this.amount;
    }

    public boolean isZero() {
        return this.amount == 0L;
    }

    public Money toMoney() {
        return Money.of(this.currencyCode, Math.round((double)this.amount / Values.Quote.dividerToMoney()));
    }

    public BigDecimal toBigDecimal() {
        return BigDecimal.valueOf((double)this.amount / Values.Quote.divider());
    }

    public int hashCode() {
        return Objects.hash(this.currencyCode, this.amount);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quote other = (Quote)obj;
        if (this.amount != other.amount) {
            return false;
        }
        return Objects.equals(this.currencyCode, other.currencyCode);
    }

    @Override
    public int compareTo(Quote other) {
        int compare = this.getCurrencyCode().compareTo(other.getCurrencyCode());
        if (compare != 0) {
            return compare;
        }
        return Long.compare(this.getAmount(), other.getAmount());
    }

    public String toString() {
        return Values.Quote.format(this);
    }
}

