/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.ExchangeRateProvider;
import name.abuchen.portfolio.money.ExchangeRateTimeSeries;
import name.abuchen.portfolio.money.impl.ECBData;
import name.abuchen.portfolio.money.impl.ECBUpdater;
import name.abuchen.portfolio.money.impl.ExchangeRateTimeSeriesImpl;
import name.abuchen.portfolio.util.XStreamLocalDateConverter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ECBExchangeRateProvider
implements ExchangeRateProvider {
    public static final String EUR = "EUR";
    private static final String FILE_STORAGE = "ecb_exchange_rates.xml";
    private static final String FILE_SUMMARY = "ecb_exchange_rates_summary.xml";
    private volatile XStream xstream;
    private ECBData data = new ECBData();

    public ECBExchangeRateProvider() {
        this.fillInDefaultData(this.data);
    }

    ECBExchangeRateProvider(ECBData data) {
        this.data = data;
    }

    @Override
    public String getName() {
        return Messages.LabelEuropeanCentralBank;
    }

    @Override
    public synchronized void load(IProgressMonitor monitor) throws IOException {
        Object loaded;
        monitor.beginTask(MessageFormat.format(Messages.MsgLoadingExchangeRates, this.getName()), 2);
        File file = this.getStorageFile(FILE_SUMMARY);
        if (file.exists()) {
            loaded = (Map)this.xstream().fromXML(file);
            ECBData summary = new ECBData();
            for (Map.Entry entry : loaded.entrySet()) {
                ExchangeRateTimeSeriesImpl s = new ExchangeRateTimeSeriesImpl(this, EUR, (String)entry.getKey());
                s.addRate((ExchangeRate)entry.getValue());
                summary.addSeries(s);
            }
            this.data = summary;
        }
        monitor.worked(1);
        file = this.getStorageFile(FILE_STORAGE);
        if (file.exists()) {
            loaded = (ECBData)this.xstream().fromXML(file);
            ((ECBData)loaded).doPostLoadProcessing(this);
            this.data = loaded;
        }
        monitor.worked(1);
    }

    @Override
    public synchronized void update(IProgressMonitor monitor) throws IOException {
        ECBData copy = this.data.copy();
        new ECBUpdater().update(this, copy);
        this.data = copy;
    }

    @Override
    public synchronized void save(IProgressMonitor monitor) throws IOException {
        if (!this.data.isDirty()) {
            return;
        }
        File file = this.getStorageFile(FILE_SUMMARY);
        HashMap summary = new HashMap();
        for (ExchangeRateTimeSeriesImpl s : this.data.getSeries()) {
            s.getLatest().ifPresent(rate -> {
                ExchangeRate exchangeRate = summary.put(s.getTermCurrency(), rate);
            });
        }
        this.write(summary, file);
        file = this.getStorageFile(FILE_STORAGE);
        this.write(this.data, file);
    }

    @Override
    public List<ExchangeRateTimeSeries> getAvailableTimeSeries(Client client) {
        return new ArrayList<ExchangeRateTimeSeries>(this.data.getSeries());
    }

    private File getStorageFile(String name) {
        Bundle bundle = FrameworkUtil.getBundle(ECBExchangeRateProvider.class);
        return bundle.getDataFile(name);
    }

    private void write(Object object, File file) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream out = new FileOutputStream(file);){
            this.xstream().toXML(object, (OutputStream)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void fillInDefaultData(ECBData summary) {
        String date20151218 = "2015-12-18";
        summary.addSeries(this.createDefault("CHF", date20151218, BigDecimal.valueOf(1.0768)));
        summary.addSeries(this.createDefault("HRK", date20151218, BigDecimal.valueOf(7.6495)));
        summary.addSeries(this.createDefault("MXN", date20151218, BigDecimal.valueOf(18.4429)));
        summary.addSeries(this.createDefault("LVL", "2013-12-31", BigDecimal.valueOf(0.702804)));
        summary.addSeries(this.createDefault("MTL", "2007-12-31", BigDecimal.valueOf(0.4293)));
        summary.addSeries(this.createDefault("LTL", "2014-12-31", BigDecimal.valueOf(3.4528)));
        summary.addSeries(this.createDefault("ZAR", date20151218, BigDecimal.valueOf(16.2998)));
        summary.addSeries(this.createDefault("INR", date20151218, BigDecimal.valueOf(71.955)));
        summary.addSeries(this.createDefault("CNY", date20151218, BigDecimal.valueOf(7.0274)));
        summary.addSeries(this.createDefault("THB", date20151218, BigDecimal.valueOf(39.175)));
        summary.addSeries(this.createDefault("TRL", "2004-12-31", BigDecimal.valueOf(1836200L)));
        summary.addSeries(this.createDefault("AUD", date20151218, BigDecimal.valueOf(1.5206)));
        summary.addSeries(this.createDefault("ILS", date20151218, BigDecimal.valueOf(4.221)));
        summary.addSeries(this.createDefault("KRW", date20151218, BigDecimal.valueOf(1280.16)));
        summary.addSeries(this.createDefault("JPY", date20151218, BigDecimal.valueOf(131.6)));
        summary.addSeries(this.createDefault("PLN", date20151218, BigDecimal.valueOf(4.2806)));
        summary.addSeries(this.createDefault("GBP", date20151218, BigDecimal.valueOf(0.72666)));
        summary.addSeries(this.createDefault("IDR", date20151218, BigDecimal.valueOf(15096.1)));
        summary.addSeries(this.createDefault("HUF", date20151218, BigDecimal.valueOf(314.25)));
        summary.addSeries(this.createDefault("PHP", date20151218, BigDecimal.valueOf(51.253)));
        summary.addSeries(this.createDefault("TRY", date20151218, BigDecimal.valueOf(3.1581)));
        summary.addSeries(this.createDefault("CYP", "2007-12-31", BigDecimal.valueOf(0.585274)));
        summary.addSeries(this.createDefault("RUB", date20151218, BigDecimal.valueOf(77.1005)));
        summary.addSeries(this.createDefault("HKD", date20151218, BigDecimal.valueOf(8.4005)));
        summary.addSeries(this.createDefault("ISK", "2008-12-09", BigDecimal.valueOf(290L)));
        summary.addSeries(this.createDefault("DKK", date20151218, BigDecimal.valueOf(7.4613)));
        summary.addSeries(this.createDefault("USD", date20151218, BigDecimal.valueOf(1.0836)));
        summary.addSeries(this.createDefault("CAD", date20151218, BigDecimal.valueOf(1.5123)));
        summary.addSeries(this.createDefault("MYR", date20151218, BigDecimal.valueOf(4.644)));
        summary.addSeries(this.createDefault("BGN", date20151218, BigDecimal.valueOf(1.9558)));
        summary.addSeries(this.createDefault("EEK", "2010-12-31", BigDecimal.valueOf(15.6466)));
        summary.addSeries(this.createDefault("NOK", date20151218, BigDecimal.valueOf(9.5)));
        summary.addSeries(this.createDefault("ROL", "2005-06-30", BigDecimal.valueOf(36030L)));
        summary.addSeries(this.createDefault("RON", date20151218, BigDecimal.valueOf(4.516)));
        summary.addSeries(this.createDefault("SGD", date20151218, BigDecimal.valueOf(1.53)));
        summary.addSeries(this.createDefault("SKK", "2008-12-31", BigDecimal.valueOf(30.126)));
        summary.addSeries(this.createDefault("CZK", date20151218, BigDecimal.valueOf(27.03)));
        summary.addSeries(this.createDefault("SEK", date20151218, BigDecimal.valueOf(9.266)));
        summary.addSeries(this.createDefault("NZD", date20151218, BigDecimal.valueOf(1.616)));
        summary.addSeries(this.createDefault("BRL", date20151218, BigDecimal.valueOf(4.2265)));
        summary.addSeries(this.createDefault("SIT", "2006-12-29", BigDecimal.valueOf(239.64)));
    }

    private ExchangeRateTimeSeriesImpl createDefault(String cur, String date, BigDecimal value) {
        ExchangeRateTimeSeriesImpl s = new ExchangeRateTimeSeriesImpl(this, EUR, cur);
        s.addRate(new ExchangeRate(LocalDate.parse(date), value));
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XStream xstream() {
        if (this.xstream == null) {
            ECBExchangeRateProvider eCBExchangeRateProvider = this;
            synchronized (eCBExchangeRateProvider) {
                if (this.xstream == null) {
                    this.xstream = new XStream();
                    this.xstream.setClassLoader(ECBExchangeRateProvider.class.getClassLoader());
                    this.xstream.registerConverter((SingleValueConverter)new XStreamLocalDateConverter());
                    this.xstream.alias("data", ECBData.class);
                    this.xstream.alias("series", ExchangeRateTimeSeriesImpl.class);
                    this.xstream.alias("rate", ExchangeRate.class);
                    this.xstream.useAttributeFor(ExchangeRate.class, "time");
                    this.xstream.aliasField("t", ExchangeRate.class, "time");
                    this.xstream.useAttributeFor(ExchangeRate.class, "value");
                    this.xstream.aliasField("v", ExchangeRate.class, "value");
                }
            }
        }
        return this.xstream;
    }
}

