/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.ExchangeRateProvider;
import name.abuchen.portfolio.money.impl.ECBData;
import name.abuchen.portfolio.money.impl.ExchangeRateTimeSeriesImpl;
import name.abuchen.portfolio.util.Dates;

class ECBUpdater {
    private static final String SOURCE_URL = "https://www.ecb.europa.eu/stats/eurofxref/";

    ECBUpdater() {
    }

    public void update(ExchangeRateProvider provider, ECBData data) throws IOException {
        Feeds f = Feeds.HISTORIC;
        if (data.getLastModified() != 0L) {
            LocalDate lastModified = LocalDate.from(Instant.ofEpochMilli(data.getLastModified()).atZone(ZoneId.systemDefault()));
            int days = Dates.daysBetween(lastModified, LocalDate.now());
            f = days <= 1 ? Feeds.DAILY : (days <= 90 ? Feeds.LAST_90_DAYS : Feeds.HISTORIC);
        }
        InputStream input = null;
        HttpURLConnection connection = null;
        try {
            URL feedUrl = new URI(SOURCE_URL + f.getXmlFileName()).toURL();
            connection = (HttpURLConnection)feedUrl.openConnection();
            long lastModified = connection.getLastModified();
            if (lastModified <= data.getLastModified()) {
                return;
            }
            try {
                input = connection.getInputStream();
                XMLInputFactory factory = XMLInputFactory.newInstance();
                factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
                XMLStreamReader reader = factory.createXMLStreamReader(new InputStreamReader(input, StandardCharsets.UTF_8));
                this.readCubes(provider, data, reader);
                data.setDirty(true);
                data.setLastModified(lastModified);
            }
            catch (URISyntaxException | XMLStreamException e) {
                throw new IOException(e);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void readCubes(ExchangeRateProvider provider, ECBData data, XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, ExchangeRateTimeSeriesImpl> currency2series = new HashMap<String, ExchangeRateTimeSeriesImpl>();
        for (ExchangeRateTimeSeriesImpl series : data.getSeries()) {
            currency2series.put(series.getTermCurrency(), series);
        }
        LocalDate currentDate = null;
        while (reader.hasNext()) {
            int event = reader.next();
            if (event != 1 || !"Cube".equals(reader.getLocalName())) continue;
            String termCurrency = reader.getAttributeValue(null, "currency");
            if (termCurrency != null) {
                ExchangeRateTimeSeriesImpl series = (ExchangeRateTimeSeriesImpl)currency2series.get(termCurrency);
                if (series == null) {
                    series = new ExchangeRateTimeSeriesImpl();
                    series.setProvider(provider);
                    series.setBaseCurrency("EUR");
                    series.setTermCurrency(termCurrency);
                    currency2series.put(termCurrency, series);
                    data.addSeries(series);
                }
                String rateValue = reader.getAttributeValue(null, "rate");
                BigDecimal rateNumber = new BigDecimal(rateValue);
                ExchangeRate rate = new ExchangeRate(currentDate, rateNumber);
                series.addRate(rate);
                continue;
            }
            String time = reader.getAttributeValue(null, "time");
            if (time == null) continue;
            currentDate = LocalDate.parse(time);
        }
    }

    private static enum Feeds {
        HISTORIC("eurofxref-hist.xml"),
        LAST_90_DAYS("eurofxref-hist-90d.xml"),
        DAILY("eurofxref-daily.xml");

        private String xmlFileName;

        private Feeds(String xmlFileName) {
            this.xmlFileName = xmlFileName;
        }

        public String getXmlFileName() {
            return this.xmlFileName;
        }
    }
}

