/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money.impl;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.ExchangeRateProvider;
import name.abuchen.portfolio.money.ExchangeRateTimeSeries;
import name.abuchen.portfolio.money.Values;

public class SecurityBasedExchangeRateProvider
implements ExchangeRateProvider {
    @Override
    public List<ExchangeRateTimeSeries> getAvailableTimeSeries(Client client) {
        ArrayList<ExchangeRateTimeSeries> answer = new ArrayList<ExchangeRateTimeSeries>();
        if (client != null) {
            for (Security security : client.getSecurities()) {
                if (!security.isExchangeRate()) continue;
                answer.add(new SecurityBasedExchangeRate(security));
            }
        }
        return answer;
    }

    @Override
    public String getName() {
        return Messages.SecurityBasedExchangeRateProvider;
    }

    private class SecurityBasedExchangeRate
    implements ExchangeRateTimeSeries {
        private final Security security;
        private boolean hasWarningLogged = false;

        public SecurityBasedExchangeRate(Security security) {
            this.security = security;
        }

        @Override
        public String getBaseCurrency() {
            return this.security.getCurrencyCode();
        }

        @Override
        public Optional<ExchangeRateProvider> getProvider() {
            return Optional.of(SecurityBasedExchangeRateProvider.this);
        }

        @Override
        public List<ExchangeRate> getRates() {
            ArrayList<ExchangeRate> answer = new ArrayList<ExchangeRate>();
            for (SecurityPrice price : this.security.getPricesIncludingLatest()) {
                answer.add(this.toExchangeRate(price));
            }
            return answer;
        }

        @Override
        public String getTermCurrency() {
            return this.security.getTargetCurrencyCode();
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public Optional<ExchangeRate> lookupRate(LocalDate requestedTime) {
            SecurityPrice price = this.security.getSecurityPrice(requestedTime);
            if (price != null && price.getValue() != 0L) {
                return Optional.of(this.toExchangeRate(price));
            }
            if (!this.hasWarningLogged) {
                PortfolioLog.warning(MessageFormat.format(Messages.MsgNoExchangeRatesAvailableForCustomSeries, this.security.getName(), this.security.getCurrencyCode(), this.security.getTargetCurrencyCode()));
                this.hasWarningLogged = true;
            }
            return Optional.empty();
        }

        private ExchangeRate toExchangeRate(SecurityPrice price) {
            return new ExchangeRate(price.getDate(), BigDecimal.valueOf((double)price.getValue() / Values.Quote.divider()));
        }

        @Override
        public String getLabel() {
            return MessageFormat.format(Messages.LabelExchangeRateSeriesBasedOnSecurity, ExchangeRateTimeSeries.super.getLabel(), this.security.getName());
        }
    }
}

