/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl;

import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.QuoteFeedData;
import name.abuchen.portfolio.online.impl.YahooHelper;
import name.abuchen.portfolio.util.Dates;
import name.abuchen.portfolio.util.RateLimitExceededException;
import name.abuchen.portfolio.util.WebAccess;

public class AlphavantageQuoteFeed
implements QuoteFeed {
    public static final String ID = "ALPHAVANTAGE";
    private static final int DAYS_THRESHOLD = 80;
    private static RateLimiter rateLimiter = RateLimiter.create((double)0.075);
    private String apiKey;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "Alpha Vantage";
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setCallFrequencyLimit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException();
        }
        rateLimiter.setRate(((double)limit - 0.5) / 60.0);
    }

    public String rpcLatestQuote(Security security) throws IOException {
        return new WebAccess("www.alphavantage.co", "/query").addParameter("function", "TIME_SERIES_INTRADAY").addParameter("symbol", security.getTickerSymbol()).addParameter("interval", "1min").addParameter("apikey", this.apiKey).addParameter("datatype", "csv").addParameter("outputsize", "compact").get();
    }

    @Override
    public Optional<LatestSecurityPrice> getLatestQuote(Security security) {
        if (security.getTickerSymbol() == null) {
            PortfolioLog.error(MessageFormat.format(Messages.MsgMissingTickerSymbol, security.getName()));
            return Optional.empty();
        }
        if (this.apiKey == null) {
            throw new IllegalArgumentException(Messages.MsgAlphaVantageAPIKeyMissing);
        }
        if (!rateLimiter.tryAcquire()) {
            throw new RateLimitExceededException(Messages.MsgAlphaVantageRateLimitExceeded);
        }
        try {
            String html = this.rpcLatestQuote(security);
            String[] lines = html.split("\\r?\\n");
            if (lines.length <= 2) {
                return Optional.empty();
            }
            if (!"timestamp,open,high,low,close,volume".equals(lines[0])) {
                PortfolioLog.error(MessageFormat.format(Messages.MsgUnexpectedHeader, html));
                return Optional.empty();
            }
            String line = lines[1];
            String[] values = line.split(",");
            if (values.length != 6) {
                throw new IOException(MessageFormat.format(Messages.MsgUnexpectedValue, line));
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LatestSecurityPrice price = new LatestSecurityPrice();
            price.setDate(LocalDate.parse(values[0], formatter));
            price.setValue(YahooHelper.asPrice(values[4]));
            price.setHigh(YahooHelper.asPrice(values[2]));
            price.setLow(YahooHelper.asPrice(values[3]));
            price.setVolume(Long.parseLong(values[5]));
            price.setPreviousClose(-1L);
            if (price.getValue() != 0L) {
                return Optional.of(price);
            }
        }
        catch (IOException | ParseException e) {
            PortfolioLog.error(e);
        }
        return Optional.empty();
    }

    @Override
    public QuoteFeedData getHistoricalQuotes(Security security, boolean collectRawResponse) {
        OutputSize outputSize = OutputSize.FULL;
        if (!security.getPrices().isEmpty()) {
            SecurityPrice lastHistoricalQuote = security.getPrices().get(security.getPrices().size() - 1);
            int days = Dates.daysBetween(lastHistoricalQuote.getDate(), LocalDate.now());
            outputSize = days >= 80 ? OutputSize.FULL : OutputSize.COMPACT;
        }
        return this.getHistoricalQuotes(security, collectRawResponse, outputSize);
    }

    @Override
    public QuoteFeedData previewHistoricalQuotes(Security security) {
        LocalDate now = LocalDate.now();
        int days = Dates.daysBetween(now.minusMonths(2L), now);
        return this.getHistoricalQuotes(security, true, days >= 80 ? OutputSize.FULL : OutputSize.COMPACT);
    }

    private QuoteFeedData getHistoricalQuotes(Security security, boolean collectRawResponse, OutputSize outputSize) {
        if (security.getTickerSymbol() == null) {
            return QuoteFeedData.withError(new IOException(MessageFormat.format(Messages.MsgMissingTickerSymbol, security.getName())));
        }
        if (this.apiKey == null) {
            throw new IllegalArgumentException(Messages.MsgAlphaVantageAPIKeyMissing);
        }
        if (!rateLimiter.tryAcquire()) {
            throw new RateLimitExceededException(Messages.MsgAlphaVantageRateLimitExceeded);
        }
        QuoteFeedData data = new QuoteFeedData();
        try {
            String[] lines;
            WebAccess webaccess = new WebAccess("www.alphavantage.co", "/query").addParameter("function", "TIME_SERIES_DAILY").addParameter("symbol", security.getTickerSymbol()).addParameter("apikey", this.apiKey).addParameter("datatype", "csv").addParameter("outputsize", outputSize.name().toLowerCase(Locale.US));
            String html = webaccess.get();
            if (collectRawResponse) {
                data.addResponse(webaccess.getURL(), html);
            }
            if ((lines = html.split("\\r?\\n")).length <= 2) {
                return data;
            }
            if (!"timestamp,open,high,low,close,volume".equals(lines[0])) {
                data.addError(new IOException(MessageFormat.format(Messages.MsgUnexpectedHeader, html)));
                return data;
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            int ii = 1;
            while (ii < lines.length) {
                String line = lines[ii];
                String[] values = line.split(",");
                if (values.length != 6) {
                    throw new IOException(MessageFormat.format(Messages.MsgUnexpectedValue, line));
                }
                LatestSecurityPrice price = new LatestSecurityPrice();
                if (values[0].length() > 10) {
                    values[0] = values[0].substring(0, 10);
                }
                price.setDate(LocalDate.parse(values[0], formatter));
                price.setValue(YahooHelper.asPrice(values[4]));
                price.setHigh(YahooHelper.asPrice(values[2]));
                price.setLow(YahooHelper.asPrice(values[3]));
                price.setVolume(Long.parseLong(values[5]));
                price.setPreviousClose(-1L);
                if (price.getValue() != 0L) {
                    data.addPrice(price);
                }
                ++ii;
            }
        }
        catch (IOException | URISyntaxException | ParseException e) {
            data.addError(e);
        }
        return data;
    }

    private static enum OutputSize {
        COMPACT,
        FULL;

    }
}

