/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.model.SecurityProperty;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.QuoteFeedData;
import name.abuchen.portfolio.online.impl.PageCache;
import name.abuchen.portfolio.online.impl.YahooHelper;
import name.abuchen.portfolio.online.impl.variableurl.Factory;
import name.abuchen.portfolio.online.impl.variableurl.urls.VariableURL;
import name.abuchen.portfolio.util.WebAccess;

public class GenericJSONQuoteFeed
implements QuoteFeed {
    public static final String ID = "GENERIC-JSON";
    public static final String DATE_PROPERTY_NAME_HISTORIC = "GENERIC-JSON-DATE";
    public static final String CLOSE_PROPERTY_NAME_HISTORIC = "GENERIC-JSON-CLOSE";
    public static final String DATE_PROPERTY_NAME_LATEST = "GENERIC-JSON-DATE-LATEST";
    public static final String CLOSE_PROPERTY_NAME_LATEST = "GENERIC-JSON-CLOSE-LATEST";
    private final PageCache<String> cache = new PageCache();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "JSON";
    }

    @Override
    public Optional<String> getHelpURL() {
        return Optional.of("https://help.portfolio-performance.info/kursdaten_laden/#json");
    }

    @Override
    public QuoteFeedData getHistoricalQuotes(Security security, boolean collectRawResponse) {
        return this.getHistoricalQuotes(security, security.getFeedURL(), collectRawResponse, false, false);
    }

    @Override
    public QuoteFeedData previewHistoricalQuotes(Security security) {
        return this.getHistoricalQuotes(security, security.getFeedURL(), true, true, false);
    }

    public String getJson(String url) throws IOException, URISyntaxException {
        return new WebAccess(url).get();
    }

    private QuoteFeedData getHistoricalQuotes(Security security, String feedURL, boolean collectRawResponse, boolean isPreview, boolean isLatest) {
        Optional<String> dateProperty = security.getPropertyValue(SecurityProperty.Type.FEED, isLatest ? DATE_PROPERTY_NAME_LATEST : DATE_PROPERTY_NAME_HISTORIC);
        Optional<String> closeProperty = security.getPropertyValue(SecurityProperty.Type.FEED, isLatest ? CLOSE_PROPERTY_NAME_LATEST : CLOSE_PROPERTY_NAME_HISTORIC);
        if (!dateProperty.isPresent() || !closeProperty.isPresent()) {
            return QuoteFeedData.withError(new IOException(MessageFormat.format(Messages.MsgErrorMissingPathToDateOrClose, security.getName())));
        }
        if (feedURL == null || feedURL.length() == 0) {
            return QuoteFeedData.withError(new IOException(MessageFormat.format(Messages.MsgMissingFeedURL, security.getName())));
        }
        VariableURL variableURL = Factory.fromString(feedURL);
        variableURL.setSecurity(security);
        QuoteFeedData data = new QuoteFeedData();
        TreeSet<SecurityPrice> newPricesByDate = new TreeSet<SecurityPrice>(new SecurityPrice.ByDate());
        long failedAttempts = 0L;
        long maxFailedAttempts = variableURL.getMaxFailedAttempts();
        for (String url : variableURL) {
            String json = this.cache.lookup(url);
            if (json == null) {
                try {
                    json = this.getJson(url);
                }
                catch (IOException | URISyntaxException e) {
                    data.addError(new IOException(String.valueOf(url) + '\n' + e.getMessage(), e));
                }
                if (json != null) {
                    this.cache.put(url, json);
                }
            }
            if (collectRawResponse) {
                data.addResponse(url, json);
            }
            int sizeBefore = newPricesByDate.size();
            if (json != null) {
                newPricesByDate.addAll(this.parse(url, json, dateProperty.get(), closeProperty.get(), data));
            }
            if (newPricesByDate.size() > sizeBefore) {
                failedAttempts = 0L;
            } else if (++failedAttempts > maxFailedAttempts) break;
            if (isPreview && newPricesByDate.size() >= 100) break;
        }
        data.addAllPrices(newPricesByDate);
        return data;
    }

    @Override
    public Optional<LatestSecurityPrice> getLatestQuote(Security security) {
        List<LatestSecurityPrice> prices;
        String latestFeedURL = security.getLatestFeedURL();
        if (latestFeedURL == null) {
            return QuoteFeed.super.getLatestQuote(security);
        }
        QuoteFeedData data = this.getHistoricalQuotes(security, latestFeedURL, false, false, true);
        if (!data.getErrors().isEmpty()) {
            PortfolioLog.error(data.getErrors());
        }
        if ((prices = data.getLatestPrices()).isEmpty()) {
            return Optional.empty();
        }
        Collections.sort(prices, new SecurityPrice.ByDate());
        return Optional.of(prices.get(prices.size() - 1));
    }

    protected List<LatestSecurityPrice> parse(String url, String json, String datePath, String closePath, QuoteFeedData data) {
        try {
            JsonPath dateP = JsonPath.compile((String)datePath, (Predicate[])new Predicate[0]);
            JsonPath closeP = JsonPath.compile((String)closePath, (Predicate[])new Predicate[0]);
            Configuration configuration = Configuration.defaultConfiguration().addOptions(new Option[]{Option.ALWAYS_RETURN_LIST}).addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
            DocumentContext ctx = JsonPath.parse((String)json, (Configuration)configuration);
            List dates = (List)ctx.read(dateP);
            List close = (List)ctx.read(closeP);
            if (dates.size() != close.size()) {
                data.addError(new IOException(MessageFormat.format(Messages.MsgErrorNumberOfDateAndCloseRecordsDoNotMatch, dates.size(), close.size())));
                return Collections.emptyList();
            }
            ArrayList<LatestSecurityPrice> prices = new ArrayList<LatestSecurityPrice>();
            int size = dates.size();
            int index = 0;
            while (index < size) {
                LatestSecurityPrice price = new LatestSecurityPrice();
                Object object = dates.get(index);
                price.setDate(this.extractDate(object));
                object = close.get(index);
                price.setValue(this.extractValue(object));
                if (price.getDate() != null && price.getValue() > 0L) {
                    price.setHigh(-1L);
                    price.setLow(-1L);
                    price.setVolume(-1L);
                    prices.add(price);
                }
                ++index;
            }
            return prices;
        }
        catch (JsonPathException | ParseException e) {
            data.addError(new IOException(String.valueOf(url) + '\n' + e.getMessage(), e));
            return Collections.emptyList();
        }
    }

    long extractValue(Object object) throws ParseException {
        if (object instanceof Number) {
            return Values.Quote.factorize(((Number)object).doubleValue());
        }
        if (object instanceof String) {
            return YahooHelper.asPrice((String)object);
        }
        return 0L;
    }

    LocalDate extractDate(Object object) {
        if (object instanceof String) {
            return YahooHelper.fromISODate((String)object);
        }
        if (object instanceof Long) {
            return this.parseDateTimestamp((Long)object);
        }
        if (object instanceof Integer) {
            return this.parseDateTimestamp((long)((Integer)object));
        }
        if (object instanceof Double) {
            return this.parseDateTimestamp(((Double)object).longValue());
        }
        if (object instanceof LocalDate) {
            return (LocalDate)object;
        }
        return null;
    }

    private LocalDate parseDateTimestamp(Long object) {
        Long futureEpoch = LocalDateTime.of(2200, 1, 1, 0, 0, 0, 0).toEpochSecond(ZoneOffset.UTC);
        if (object > futureEpoch) {
            object = object / 1000L;
        } else if (object < futureEpoch / 86400L) {
            object = object * 24L * 60L * 60L;
        }
        return LocalDateTime.ofEpochSecond(object, 0, ZoneOffset.UTC).toLocalDate();
    }
}

