/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityProperty;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.QuoteFeedData;
import name.abuchen.portfolio.online.impl.YahooHelper;
import name.abuchen.portfolio.util.WebAccess;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class QuandlQuoteFeed
implements QuoteFeed {
    public static final String ID = "QUANDL-DATASETS";
    public static final String QUANDL_CODE_PROPERTY_NAME = "QUANDLCODE";
    public static final String QUANDL_CLOSE_COLUMN_NAME_PROPERTY_NAME = "QUANDLCLOSE";
    private String apiKey;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "Quandl";
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public Optional<LatestSecurityPrice> getLatestQuote(Security security) {
        QuoteFeedData data = this.getHistoricalQuotes(security, false, a -> {
            WebAccess webAccess = a.addParameter("limit", "1");
        });
        List<LatestSecurityPrice> prices = data.getLatestPrices();
        return prices.isEmpty() ? Optional.empty() : Optional.of(prices.get(prices.size() - 1));
    }

    @Override
    public QuoteFeedData getHistoricalQuotes(Security security, boolean collectRawResponse) {
        Consumer<WebAccess> parameters = null;
        if (!security.getPrices().isEmpty()) {
            LocalDate startDate = security.getPrices().get(security.getPrices().size() - 1).getDate();
            parameters = a -> {
                WebAccess webAccess = a.addParameter("start_date", startDate.toString());
            };
        }
        return this.getHistoricalQuotes(security, collectRawResponse, parameters);
    }

    @Override
    public QuoteFeedData previewHistoricalQuotes(Security security) {
        return this.getHistoricalQuotes(security, true, a -> {
            WebAccess webAccess = a.addParameter("limit", "100");
        });
    }

    public QuoteFeedData getHistoricalQuotes(Security security, boolean collectRawResponse, Consumer<WebAccess> parameters) {
        if (this.apiKey == null) {
            throw new IllegalArgumentException(Messages.MsgErrorQuandlMissingAPIKey);
        }
        Optional<String> quandlCode = security.getPropertyValue(SecurityProperty.Type.FEED, QUANDL_CODE_PROPERTY_NAME);
        if (!quandlCode.isPresent()) {
            return QuoteFeedData.withError(new IOException(MessageFormat.format(Messages.MsgErrorQuandlMissingCode, security.getName())));
        }
        QuoteFeedData data = new QuoteFeedData();
        try {
            JSONObject json;
            JSONObject dataset;
            WebAccess webaccess = new WebAccess("www.quandl.com", "/api/v3/datasets/" + quandlCode.get() + "/data.json").addParameter("api_key", this.apiKey);
            if (parameters != null) {
                parameters.accept(webaccess);
            }
            String response = webaccess.get();
            if (collectRawResponse) {
                data.addResponse(webaccess.getURL(), response);
            }
            if ((dataset = (JSONObject)(json = (JSONObject)JSONValue.parse((String)response)).get((Object)"dataset_data")) == null) {
                data.addError(new IOException(MessageFormat.format(Messages.MsgErrorMissingKeyValueInJSON, "dataset")));
                return data;
            }
            JSONArray columnNames = (JSONArray)dataset.get((Object)"column_names");
            if (columnNames == null) {
                data.addError(new IOException(MessageFormat.format(Messages.MsgErrorMissingKeyValueInJSON, "column_names")));
                return data;
            }
            int[] mapping = this.extractColumnMapping(security, columnNames);
            if (mapping[0] == -1) {
                data.addError(new IOException(MessageFormat.format(Messages.MsgErrorMissingKeyValueInJSON, "column_names[data]")));
                return data;
            }
            if (mapping[4] == -1) {
                data.addError(new IOException(MessageFormat.format(Messages.MsgErrorMissingKeyValueInJSON, "column_names[close]")));
                return data;
            }
            JSONArray jsondata = (JSONArray)dataset.get((Object)"data");
            if (jsondata == null) {
                return data;
            }
            jsondata.forEach(entry -> {
                try {
                    int volume;
                    JSONArray row = (JSONArray)entry;
                    LocalDate date = LocalDate.parse(row.get(mapping[0]).toString());
                    long high = mapping[2] == -1 ? -1L : YahooHelper.asPrice(String.valueOf(row.get(mapping[2])));
                    long low = mapping[3] == -1 ? -1L : YahooHelper.asPrice(String.valueOf(row.get(mapping[3])));
                    long close = mapping[4] == -1 ? -1L : YahooHelper.asPrice(String.valueOf(row.get(mapping[4])));
                    int n = volume = mapping[5] == -1 ? -1 : YahooHelper.asNumber(String.valueOf(row.get(mapping[5])));
                    if (close > 0L) {
                        LatestSecurityPrice price = new LatestSecurityPrice();
                        price.setDate(date);
                        price.setValue(close);
                        price.setHigh(high);
                        price.setLow(low);
                        price.setVolume(volume);
                        data.addPrice(price);
                    }
                }
                catch (IllegalArgumentException | ParseException ex) {
                    data.addError(ex);
                }
            });
        }
        catch (IOException | URISyntaxException e) {
            data.addError(e);
        }
        return data;
    }

    private int[] extractColumnMapping(Security security, JSONArray columnNames) {
        int[] mapping = new int[6];
        Arrays.fill(mapping, -1);
        int columnSize = columnNames.size();
        int index = 0;
        while (index < columnSize) {
            String name;
            switch (name = columnNames.get(index).toString()) {
                case "DATE": 
                case "Date": {
                    mapping[0] = index;
                    break;
                }
                case "Open": {
                    mapping[1] = index;
                    break;
                }
                case "High": {
                    mapping[2] = index;
                    break;
                }
                case "Low": {
                    mapping[3] = index;
                    break;
                }
                case "Net Asset Value": 
                case "Close": {
                    mapping[4] = index;
                    break;
                }
                case "Traded Volume": {
                    mapping[5] = index;
                }
            }
            ++index;
        }
        Optional<String> closeColumnName = security.getPropertyValue(SecurityProperty.Type.FEED, QUANDL_CLOSE_COLUMN_NAME_PROPERTY_NAME);
        closeColumnName.ifPresent(columnName -> {
            int index = 0;
            while (index < columnSize) {
                String name = columnNames.get(index).toString();
                if (name.equals(columnName)) {
                    nArray[4] = index;
                    break;
                }
                ++index;
            }
        });
        return mapping;
    }
}

