/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl.variableurl.macros;

import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAmount;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.online.impl.variableurl.VariableURLConstructor;
import name.abuchen.portfolio.online.impl.variableurl.macros.Macro;

public class Today
implements Macro {
    private static final Pattern MACRO = Pattern.compile("TODAY(:([^:]*)(:([PYMWDpymwd0123456789-]*))?)?");
    private final DateTimeFormatter formatter;
    private final TemporalAmount delta;

    public Today(CharSequence input) {
        Matcher matcher = MACRO.matcher(input);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        String p = matcher.group(2);
        this.formatter = p == null || p.isEmpty() ? DateTimeFormatter.ISO_DATE : DateTimeFormatter.ofPattern(p);
        String d = matcher.group(4);
        this.delta = d == null || d.isEmpty() ? Period.ZERO : Period.parse(d);
    }

    @Override
    public VariableURLConstructor getVariableURLConstructor() {
        return null;
    }

    @Override
    public CharSequence resolve(Security security) {
        return this.formatter.format(LocalDate.now().plus(this.delta));
    }
}

