/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import name.abuchen.portfolio.math.IRR;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.ClientSnapshot;
import name.abuchen.portfolio.util.Interval;

public class ClientIRRYield {
    private double irr;

    public static ClientIRRYield create(Client client, ClientSnapshot snapshotStart, ClientSnapshot snapshotEnd) {
        Interval interval = Interval.of(snapshotStart.getTime(), snapshotEnd.getTime());
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        ClientIRRYield.collectAccountTransactions(client, interval, transactions);
        ClientIRRYield.collectPortfolioTransactions(client, interval, transactions);
        Collections.sort(transactions, new Transaction.ByDate());
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        ArrayList<Double> values = new ArrayList<Double>();
        ClientIRRYield.collectDatesAndValues(interval, snapshotStart, snapshotEnd, transactions, dates, values);
        double irr = IRR.calculate(dates, values);
        return new ClientIRRYield(irr);
    }

    private ClientIRRYield(double irr) {
        this.irr = irr;
    }

    public double getIrr() {
        return this.irr;
    }

    private static void collectPortfolioTransactions(Client client, Interval interval, List<Transaction> transactions) {
        for (Portfolio portfolio : client.getPortfolios()) {
            portfolio.getTransactions().stream().filter(t -> interval.contains(t.getDateTime())).forEach(t -> {
                switch (t.getType()) {
                    case TRANSFER_IN: 
                    case TRANSFER_OUT: 
                    case DELIVERY_INBOUND: 
                    case DELIVERY_OUTBOUND: {
                        transactions.add((Transaction)t);
                        break;
                    }
                    case BUY: 
                    case SELL: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            });
        }
    }

    private static void collectAccountTransactions(Client client, Interval interval, List<Transaction> transactions) {
        for (Account account : client.getAccounts()) {
            account.getTransactions().stream().filter(t -> interval.contains(t.getDateTime())).forEach(t -> {
                switch (t.getType()) {
                    case DEPOSIT: 
                    case REMOVAL: 
                    case TRANSFER_IN: 
                    case TRANSFER_OUT: {
                        transactions.add((Transaction)t);
                        break;
                    }
                    case INTEREST: 
                    case INTEREST_CHARGE: 
                    case DIVIDENDS: 
                    case FEES: 
                    case FEES_REFUND: 
                    case TAXES: 
                    case TAX_REFUND: 
                    case BUY: 
                    case SELL: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            });
        }
    }

    private static void collectDatesAndValues(Interval interval, ClientSnapshot snapshotStart, ClientSnapshot snapshotEnd, List<Transaction> transactions, List<LocalDate> dates, List<Double> values) {
        CurrencyConverter converter = snapshotStart.getCurrencyConverter();
        dates.add(interval.getStart());
        values.add((double)(-snapshotStart.getMonetaryAssets().getAmount()) / Values.Amount.divider());
        for (Transaction t : transactions) {
            long amount;
            dates.add(t.getDateTime().toLocalDate());
            if (t instanceof AccountTransaction) {
                AccountTransaction at = (AccountTransaction)t;
                amount = converter.convert(t.getDateTime(), t.getMonetaryAmount()).getAmount();
                if (at.getType() == AccountTransaction.Type.DEPOSIT || at.getType() == AccountTransaction.Type.TRANSFER_IN) {
                    amount = -amount;
                }
                values.add((double)amount / Values.Amount.divider());
                continue;
            }
            if (t instanceof PortfolioTransaction) {
                PortfolioTransaction pt = (PortfolioTransaction)t;
                amount = converter.convert(t.getDateTime(), t.getMonetaryAmount()).getAmount();
                if (pt.getType() == PortfolioTransaction.Type.DELIVERY_INBOUND || pt.getType() == PortfolioTransaction.Type.TRANSFER_IN) {
                    amount = -amount;
                }
                values.add((double)amount / Values.Amount.divider());
                continue;
            }
            throw new UnsupportedOperationException();
        }
        dates.add(interval.getEnd());
        values.add((double)snapshotEnd.getMonetaryAssets().getAmount() / Values.Amount.divider());
    }
}

