/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MoneyCollectors;
import name.abuchen.portfolio.snapshot.GroupByTaxonomy;
import name.abuchen.portfolio.snapshot.SecurityPosition;
import name.abuchen.portfolio.snapshot.filter.ReadOnlyPortfolio;

public class PortfolioSnapshot {
    private final Portfolio portfolio;
    private final CurrencyConverter converter;
    private final LocalDate date;
    private final List<SecurityPosition> positions;

    public static PortfolioSnapshot create(Portfolio portfolio, CurrencyConverter converter, LocalDate date) {
        List<SecurityPosition> positions = portfolio.getTransactions().stream().filter(t -> !t.getDateTime().toLocalDate().isAfter(date)).collect(Collectors.groupingBy(Transaction::getSecurity)).entrySet().stream().map(e -> {
            List tx;
            Optional last;
            SecurityPrice price = ((Security)e.getKey()).getSecurityPrice(date);
            if (price.getValue() == 0L && (last = (tx = (List)e.getValue()).stream().sorted(new Transaction.ByDate().reversed()).findFirst()).isPresent()) {
                PortfolioTransaction t = (PortfolioTransaction)last.get();
                price = new SecurityPrice(t.getDateTime().toLocalDate(), t.getGrossPricePerShare(converter.with(((Security)e.getKey()).getCurrencyCode())).getAmount());
            }
            return new SecurityPosition((Security)e.getKey(), converter, price, (List)e.getValue());
        }).filter(p -> p.getShares() != 0L).collect(Collectors.toList());
        return new PortfolioSnapshot(portfolio, converter, date, positions);
    }

    public static PortfolioSnapshot merge(List<PortfolioSnapshot> snapshots, CurrencyConverter converter) {
        if (snapshots.isEmpty()) {
            throw new IllegalArgumentException("Error: PortfolioSnapshots to be merged must not be empty");
        }
        Portfolio portfolio = new Portfolio(){

            @Override
            public void shallowDeleteTransaction(PortfolioTransaction transaction, Client client) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void deleteTransaction(PortfolioTransaction transaction, Client client) {
                throw new UnsupportedOperationException();
            }
        };
        portfolio.setName(Messages.LabelJointPortfolio);
        Account referenceAccount = new Account(Messages.LabelJointPortfolio);
        referenceAccount.setCurrencyCode(converter.getTermCurrency());
        portfolio.setReferenceAccount(referenceAccount);
        snapshots.forEach(s -> portfolio.addAllTransaction(s.getPortfolio().getTransactions()));
        return PortfolioSnapshot.create(portfolio, snapshots.get(0).getCurrencyConverter(), snapshots.get(0).getTime());
    }

    private PortfolioSnapshot(Portfolio source, CurrencyConverter converter, LocalDate date, List<SecurityPosition> positions) {
        this.portfolio = source;
        this.converter = converter;
        this.date = date;
        this.positions = positions;
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    public Portfolio unwrapPortfolio() {
        return this.portfolio instanceof ReadOnlyPortfolio ? ((ReadOnlyPortfolio)this.portfolio).unwrap() : this.portfolio;
    }

    public CurrencyConverter getCurrencyConverter() {
        return this.converter;
    }

    public LocalDate getTime() {
        return this.date;
    }

    public List<SecurityPosition> getPositions() {
        return this.positions;
    }

    public Map<Security, SecurityPosition> getPositionsBySecurity() {
        return this.positions.stream().collect(Collectors.toMap(SecurityPosition::getSecurity, p -> p));
    }

    public Money getValue() {
        return this.positions.stream().map(SecurityPosition::calculateValue).map(money -> money.with(this.converter.at(this.date))).collect(MoneyCollectors.sum(this.converter.getTermCurrency()));
    }

    public GroupByTaxonomy groupByTaxonomy(Taxonomy taxonomy) {
        return new GroupByTaxonomy(taxonomy, this);
    }
}

