/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.filter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.snapshot.filter.ClientFilter;
import name.abuchen.portfolio.snapshot.filter.ClientFilterHelper;
import name.abuchen.portfolio.snapshot.filter.ReadOnlyAccount;
import name.abuchen.portfolio.snapshot.filter.ReadOnlyClient;
import name.abuchen.portfolio.snapshot.filter.ReadOnlyPortfolio;

public class ClientSecurityFilter
implements ClientFilter {
    private final List<Security> securities;

    public ClientSecurityFilter(Security ... securities) {
        this.securities = Arrays.asList(securities);
    }

    @Override
    public Client filter(Client client) {
        ReadOnlyClient pseudoClient = new ReadOnlyClient(client);
        HashMap account2readonly = new HashMap();
        HashMap portfolio2readonly = new HashMap();
        Function<Account, ReadOnlyAccount> transformAccount = a -> account2readonly.computeIfAbsent(a, aa -> {
            ReadOnlyAccount readonly = new ReadOnlyAccount((Account)aa);
            pseudoClient.internalAddAccount(readonly);
            return readonly;
        });
        Function<Portfolio, ReadOnlyPortfolio> transformPortfolio = p -> portfolio2readonly.computeIfAbsent(p, pp -> {
            ReadOnlyPortfolio pseudoPortfolio = new ReadOnlyPortfolio((Portfolio)pp);
            pseudoPortfolio.setReferenceAccount((Account)transformAccount.apply(pp.getReferenceAccount()));
            pseudoClient.internalAddPortfolio(pseudoPortfolio);
            return pseudoPortfolio;
        });
        for (Security security : this.securities) {
            pseudoClient.internalAddSecurity(security);
            this.addSecurity(client, transformPortfolio, transformAccount, security);
        }
        return pseudoClient;
    }

    private void addSecurity(Client client, Function<Portfolio, ReadOnlyPortfolio> getPortfolio, Function<Account, ReadOnlyAccount> getAccount, Security security) {
        List<TransactionPair<?>> transactions = security.getTransactions(client);
        for (TransactionPair<PortfolioTransaction> transactionPair : transactions) {
            if (transactionPair.getTransaction() instanceof PortfolioTransaction) {
                this.addPortfolioTransaction(getPortfolio, transactionPair);
                continue;
            }
            if (!(transactionPair.getTransaction() instanceof AccountTransaction)) continue;
            this.addAccountTransaction(getAccount, transactionPair);
        }
    }

    private void addPortfolioTransaction(Function<Portfolio, ReadOnlyPortfolio> getPortfolio, TransactionPair<PortfolioTransaction> pair) {
        switch (pair.getTransaction().getType()) {
            case BUY: 
            case DELIVERY_INBOUND: {
                getPortfolio.apply((Portfolio)pair.getOwner()).internalAddTransaction(this.convertToDelivery(pair.getTransaction(), PortfolioTransaction.Type.DELIVERY_INBOUND));
                break;
            }
            case SELL: 
            case DELIVERY_OUTBOUND: {
                getPortfolio.apply((Portfolio)pair.getOwner()).internalAddTransaction(this.convertToDelivery(pair.getTransaction(), PortfolioTransaction.Type.DELIVERY_OUTBOUND));
                break;
            }
            case TRANSFER_IN: {
                this.convertTransfer(getPortfolio, pair);
            }
            case TRANSFER_OUT: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void addAccountTransaction(Function<Account, ReadOnlyAccount> getAccount, TransactionPair<AccountTransaction> pair) {
        AccountTransaction t = pair.getTransaction();
        switch (pair.getTransaction().getType()) {
            case DIVIDENDS: {
                long taxes = t.getUnitSum(Transaction.Unit.Type.TAX).getAmount();
                long amount = t.getAmount();
                AccountTransaction copy = new AccountTransaction(t.getDateTime(), t.getCurrencyCode(), amount + taxes, t.getSecurity(), t.getType());
                t.getUnits().filter((? super T u) -> u.getType() != Transaction.Unit.Type.TAX).forEach(copy::addUnit);
                getAccount.apply((Account)pair.getOwner()).internalAddTransaction(copy);
                getAccount.apply((Account)pair.getOwner()).internalAddTransaction(new AccountTransaction(t.getDateTime(), t.getCurrencyCode(), amount + taxes, null, AccountTransaction.Type.REMOVAL));
                break;
            }
            case FEES: {
                getAccount.apply((Account)pair.getOwner()).internalAddTransaction(t);
                getAccount.apply((Account)pair.getOwner()).internalAddTransaction(new AccountTransaction(t.getDateTime(), t.getCurrencyCode(), t.getAmount(), null, AccountTransaction.Type.DEPOSIT));
                break;
            }
            case FEES_REFUND: {
                getAccount.apply((Account)pair.getOwner()).internalAddTransaction(t);
                getAccount.apply((Account)pair.getOwner()).internalAddTransaction(new AccountTransaction(t.getDateTime(), t.getCurrencyCode(), t.getAmount(), null, AccountTransaction.Type.REMOVAL));
                break;
            }
            case TAXES: 
            case TAX_REFUND: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private PortfolioTransaction convertToDelivery(PortfolioTransaction t, PortfolioTransaction.Type targetType) {
        PortfolioTransaction pseudo = new PortfolioTransaction();
        pseudo.setDateTime(t.getDateTime());
        pseudo.setCurrencyCode(t.getCurrencyCode());
        pseudo.setSecurity(t.getSecurity());
        pseudo.setShares(t.getShares());
        pseudo.setType(targetType);
        long taxes = t.getUnitSum(Transaction.Unit.Type.TAX).getAmount();
        long amount = t.getAmount();
        pseudo.setAmount(pseudo.getType() == PortfolioTransaction.Type.DELIVERY_INBOUND ? amount - taxes : amount + taxes);
        t.getUnits().filter((? super T u) -> u.getType() != Transaction.Unit.Type.TAX).forEach(pseudo::addUnit);
        return pseudo;
    }

    private void convertTransfer(Function<Portfolio, ReadOnlyPortfolio> getPortfolio, TransactionPair<PortfolioTransaction> pair) {
        PortfolioTransferEntry entry = (PortfolioTransferEntry)pair.getTransaction().getCrossEntry();
        ReadOnlyPortfolio source = getPortfolio.apply(entry.getSourcePortfolio());
        ReadOnlyPortfolio target = getPortfolio.apply(entry.getTargetPortfolio());
        ClientFilterHelper.recreateTransfer(entry, source, target);
    }
}

