/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.security;

import java.util.List;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.snapshot.security.CalculationLineItem;

abstract class Calculation {
    private Security security;
    private String termCurrency;

    Calculation() {
    }

    public void prepare() {
    }

    public void finish(CurrencyConverter converter, List<CalculationLineItem> lineItems) {
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public String getTermCurrency() {
        return this.termCurrency;
    }

    public void setTermCurrency(String termCurrency) {
        this.termCurrency = termCurrency;
    }

    public void visit(CurrencyConverter converter, CalculationLineItem.ValuationAtStart t) {
    }

    public void visit(CurrencyConverter converter, CalculationLineItem.ValuationAtEnd t) {
    }

    public void visit(CurrencyConverter converter, CalculationLineItem.DividendPayment t) {
    }

    public void visit(CurrencyConverter converter, CalculationLineItem.TransactionItem item, PortfolioTransaction t) {
    }

    public void visit(CurrencyConverter converter, CalculationLineItem.TransactionItem item, AccountTransaction t) {
    }

    final void visitAll(CurrencyConverter converter, List<CalculationLineItem> lineItems) {
        for (CalculationLineItem item : lineItems) {
            if (item instanceof CalculationLineItem.ValuationAtStart) {
                this.visit(converter, (CalculationLineItem.ValuationAtStart)item);
                continue;
            }
            if (item instanceof CalculationLineItem.ValuationAtEnd) {
                this.visit(converter, (CalculationLineItem.ValuationAtEnd)item);
                continue;
            }
            if (item instanceof CalculationLineItem.DividendPayment) {
                this.visit(converter, (CalculationLineItem.DividendPayment)item);
                continue;
            }
            if (item instanceof CalculationLineItem.TransactionItem) {
                Transaction tx = ((CalculationLineItem.TransactionItem)item).getTransaction().orElseThrow(IllegalArgumentException::new);
                if (tx instanceof PortfolioTransaction) {
                    this.visit(converter, (CalculationLineItem.TransactionItem)item, (PortfolioTransaction)tx);
                    continue;
                }
                if (tx instanceof AccountTransaction) {
                    this.visit(converter, (CalculationLineItem.TransactionItem)item, (AccountTransaction)tx);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
    }

    public static <T extends Calculation> T perform(Class<T> type, CurrencyConverter converter, Security security, List<CalculationLineItem> lineItems) {
        try {
            Calculation thing = (Calculation)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            thing.setSecurity(security);
            thing.setTermCurrency(converter.getTermCurrency());
            thing.prepare();
            thing.visitAll(converter, lineItems);
            thing.finish(converter, lineItems);
            return (T)thing;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

