/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.security;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.Optional;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MoneyCollectors;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.SecurityPosition;

public interface CalculationLineItem {
    public static CalculationLineItem of(TransactionPair<?> transaction) {
        boolean isDividendPayment = transaction.getTransaction() instanceof AccountTransaction && ((AccountTransaction)transaction.getTransaction()).getType() == AccountTransaction.Type.DIVIDENDS;
        return isDividendPayment ? new DividendPayment(transaction) : new TransactionItem(transaction, null, null);
    }

    public static CalculationLineItem of(Portfolio portfolio, PortfolioTransaction transaction) {
        return CalculationLineItem.of(new TransactionPair<PortfolioTransaction>(portfolio, transaction));
    }

    public static CalculationLineItem of(Account account, AccountTransaction transaction) {
        return CalculationLineItem.of(new TransactionPair<AccountTransaction>(account, transaction));
    }

    public static CalculationLineItem atStart(Portfolio portfolio, SecurityPosition position, LocalDateTime date) {
        return new ValuationAtStart(portfolio, position, date);
    }

    public static CalculationLineItem atEnd(Portfolio portfolio, SecurityPosition position, LocalDateTime date) {
        return new ValuationAtEnd(portfolio, position, date);
    }

    public TransactionOwner<?> getOwner();

    public String getLabel();

    public LocalDateTime getDateTime();

    public Money getValue();

    default public Optional<Transaction> getTransaction() {
        return Optional.empty();
    }

    default public Optional<SecurityPosition> getSecurityPosition() {
        return Optional.empty();
    }

    public static class DividendPayment
    extends TransactionItem {
        private long totalShares;
        private Money fifoCost;
        private Money movingAverageCost;

        private DividendPayment(TransactionPair<?> transaction) {
            super(transaction);
        }

        public long getDividendPerShare() {
            return DividendPayment.amountFractionPerShare(this.getGrossValueAmount(), this.tx().getShares());
        }

        Money getFifoCost() {
            return this.fifoCost;
        }

        void setFifoCost(Money fifoCost) {
            this.fifoCost = fifoCost;
        }

        Money getMovingAverageCost() {
            return this.movingAverageCost;
        }

        void setMovingAverageCost(Money movingAverageCost) {
            this.movingAverageCost = movingAverageCost;
        }

        void setTotalShares(long totalShares) {
            this.totalShares = totalShares;
        }

        public double getPersonalDividendYield() {
            if (this.fifoCost == null || this.fifoCost.getAmount() <= 0L) {
                return 0.0;
            }
            double cost = this.fifoCost.getAmount();
            if (this.tx().getShares() > 0L) {
                cost = (double)this.fifoCost.getAmount() * ((double)this.tx().getShares() / (double)this.totalShares);
            }
            return (double)this.getGrossValueAmount() / cost;
        }

        public double getPersonalDividendYieldMovingAverage() {
            if (this.movingAverageCost == null || this.movingAverageCost.getAmount() <= 0L) {
                return 0.0;
            }
            double cost = this.movingAverageCost.getAmount();
            if (this.tx().getShares() > 0L) {
                cost = (double)this.movingAverageCost.getAmount() * ((double)this.tx().getShares() / (double)this.totalShares);
            }
            return (double)this.getGrossValueAmount() / cost;
        }

        static long amountFractionPerShare(long amount, long shares) {
            if (shares == 0L) {
                return 0L;
            }
            return BigDecimal.valueOf(amount).movePointLeft(Values.Amount.precision()).movePointRight(Values.AmountFraction.precision()).movePointRight(Values.Share.precision()).divide(BigDecimal.valueOf(shares), Values.MC).setScale(0, RoundingMode.HALF_EVEN).longValue();
        }

        public long getGrossValueAmount() {
            long taxes = this.tx().getUnits().filter(u -> u.getType() == Transaction.Unit.Type.TAX).collect(MoneyCollectors.sum(this.tx().getCurrencyCode(), Transaction.Unit::getAmount)).getAmount();
            return this.tx().getAmount() + taxes;
        }

        public Money getGrossValue() {
            return Money.of(this.tx().getCurrencyCode(), this.getGrossValueAmount());
        }
    }

    public static class TransactionItem
    implements CalculationLineItem {
        private final TransactionPair<?> txPair;

        private TransactionItem(TransactionPair<?> transaction) {
            this.txPair = transaction;
        }

        @Override
        public TransactionOwner<?> getOwner() {
            return this.txPair.getOwner();
        }

        @Override
        public String getLabel() {
            if (this.txPair.getTransaction() instanceof AccountTransaction) {
                return ((AccountTransaction)this.txPair.getTransaction()).getType().toString();
            }
            if (this.txPair.getTransaction() instanceof PortfolioTransaction) {
                return ((PortfolioTransaction)this.txPair.getTransaction()).getType().toString();
            }
            return null;
        }

        @Override
        public LocalDateTime getDateTime() {
            return ((Transaction)this.txPair.getTransaction()).getDateTime();
        }

        @Override
        public Money getValue() {
            return ((Transaction)this.txPair.getTransaction()).getMonetaryAmount();
        }

        @Override
        public Optional<Transaction> getTransaction() {
            return Optional.of(this.txPair.getTransaction());
        }

        protected Transaction tx() {
            return this.txPair.getTransaction();
        }

        /* synthetic */ TransactionItem(TransactionPair transactionPair, TransactionItem transactionItem, TransactionItem transactionItem2) {
            this(transactionPair);
        }
    }

    public static abstract class Valuation
    implements CalculationLineItem {
        private final Portfolio portfolio;
        private final SecurityPosition position;
        private final LocalDateTime date;

        protected Valuation(Portfolio portfolio, SecurityPosition position, LocalDateTime date) {
            this.portfolio = portfolio;
            this.position = position;
            this.date = date;
        }

        @Override
        public TransactionOwner<?> getOwner() {
            return this.portfolio;
        }

        @Override
        public String getLabel() {
            return Messages.LabelQuotation;
        }

        @Override
        public LocalDateTime getDateTime() {
            return this.date;
        }

        @Override
        public Money getValue() {
            return this.position.calculateValue();
        }

        @Override
        public Optional<SecurityPosition> getSecurityPosition() {
            return Optional.of(this.position);
        }
    }

    public static class ValuationAtEnd
    extends Valuation {
        private ValuationAtEnd(Portfolio portfolio, SecurityPosition position, LocalDateTime date) {
            super(portfolio, position, date);
        }
    }

    public static class ValuationAtStart
    extends Valuation {
        private ValuationAtStart(Portfolio portfolio, SecurityPosition position, LocalDateTime date) {
            super(portfolio, position, date);
        }
    }
}

