/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.security;

import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MutableMoney;
import name.abuchen.portfolio.snapshot.security.Calculation;
import name.abuchen.portfolio.snapshot.security.CalculationLineItem;

class DeltaCalculation
extends Calculation {
    private MutableMoney delta;
    private MutableMoney cost;

    DeltaCalculation() {
    }

    @Override
    public void setTermCurrency(String termCurrency) {
        super.setTermCurrency(termCurrency);
        this.delta = MutableMoney.of(termCurrency);
        this.cost = MutableMoney.of(termCurrency);
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.ValuationAtStart t) {
        Money amount = t.getValue().with(converter.at(t.getDateTime()));
        this.delta.subtract(amount);
        this.cost.add(amount);
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.ValuationAtEnd t) {
        this.delta.add(t.getValue().with(converter.at(t.getDateTime())));
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.DividendPayment t) {
        this.delta.add(t.getValue().with(converter.at(t.getDateTime())));
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.TransactionItem item, AccountTransaction t) {
        switch (t.getType()) {
            case FEES: 
            case TAXES: {
                this.delta.subtract(t.getMonetaryAmount().with(converter.at(t.getDateTime())));
                break;
            }
            case FEES_REFUND: 
            case TAX_REFUND: {
                this.delta.add(t.getMonetaryAmount().with(converter.at(t.getDateTime())));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.TransactionItem item, PortfolioTransaction t) {
        switch (t.getType()) {
            case BUY: 
            case DELIVERY_INBOUND: {
                Money amount = t.getMonetaryAmount().with(converter.at(t.getDateTime()));
                this.delta.subtract(amount);
                this.cost.add(amount);
                break;
            }
            case SELL: 
            case DELIVERY_OUTBOUND: {
                this.delta.add(t.getMonetaryAmount().with(converter.at(t.getDateTime())));
                break;
            }
            case TRANSFER_IN: 
            case TRANSFER_OUT: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public Money getDelta() {
        return this.delta.toMoney();
    }

    public double getDeltaPercent() {
        if (this.delta.getAmount() == 0L && this.cost.getAmount() == 0L) {
            return 0.0;
        }
        return (double)this.delta.getAmount() / (double)this.cost.getAmount();
    }
}

