/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.trail;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.snapshot.trail.TrailRecord;

class DefaultTrail
implements TrailRecord {
    private final LocalDate date;
    private final String label;
    private final Long shares;
    private final Money value;
    private final List<TrailRecord> children = new ArrayList<TrailRecord>();

    public DefaultTrail(LocalDate date, String label, Long shares, Money value, TrailRecord ... inputs) {
        this.date = date;
        this.label = label;
        this.shares = shares;
        this.value = value;
        this.children.addAll(Arrays.asList(inputs));
    }

    @Override
    public LocalDate getDate() {
        return this.date;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Long getShares() {
        return this.shares;
    }

    @Override
    public Money getValue() {
        return this.value;
    }

    @Override
    public List<TrailRecord> getInputs() {
        return Collections.unmodifiableList(this.children);
    }
}

