/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import name.abuchen.portfolio.PortfolioLog;

public enum BuildInfo {
    INSTANCE;

    private final LocalDateTime buildTime = this.readBuildTime();

    public LocalDateTime getBuildTime() {
        return this.buildTime;
    }

    private LocalDateTime readBuildTime() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("build-info");
            return Instant.parse(bundle.getString("build.timestamp")).atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        catch (DateTimeParseException | MissingResourceException e) {
            PortfolioLog.error(e);
            return LocalDateTime.now();
        }
    }
}

