/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TextUtil {
    public static final String PARAGRAPH_BREAK = "\n\n";
    private static final String VALID_NUM_CHARACTERS = "0123456789,.'-";
    public static final char DECIMAL_SEPARATOR = new DecimalFormatSymbols().getDecimalSeparator();

    private TextUtil() {
    }

    public static final String wordwrap(String text) {
        if (text == null) {
            return null;
        }
        String raw = String.valueOf(text) + " ";
        StringBuilder wrapped = new StringBuilder();
        Pattern p = Pattern.compile(".{0,80}[ \\t\\n\\x0b\\r\\f,.]+");
        Matcher m = p.matcher(raw);
        while (m.find()) {
            String fragment;
            if (wrapped.length() > 0) {
                wrapped.append("\n");
            }
            if ((fragment = raw.substring(m.start(), m.end())).length() > 0 && fragment.charAt(fragment.length() - 1) == '\n') {
                fragment = fragment.substring(0, fragment.length() - 1);
            }
            wrapped.append(fragment.replace("&", "&&"));
        }
        return wrapped.substring(0, wrapped.length() - 1);
    }

    public static final String tooltip(String text) {
        return text == null ? null : text.replace("&", "&&");
    }

    public static final String sanitizeFilename(String label) {
        String filename = label;
        try {
            filename = new String(label.getBytes(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        filename = filename.replaceAll("[\\?\\\\/:|<>\\*]", " ");
        filename = filename.replaceAll("\\s+", "_");
        return filename;
    }

    public static String strip(String value) {
        if (value == null) {
            return null;
        }
        int len = value.length();
        int st = 0;
        while (st < len && (Character.isWhitespace(value.charAt(st)) || Character.isSpaceChar(value.charAt(st)))) {
            ++st;
        }
        while (st < len && (Character.isWhitespace(value.charAt(len - 1)) || Character.isSpaceChar(value.charAt(len - 1)))) {
            --len;
        }
        return st > 0 || len < value.length() ? value.substring(st, len) : value;
    }

    public static String[] strip(String[] values) {
        if (values == null) {
            return new String[0];
        }
        String[] answer = new String[values.length];
        int i = 0;
        while (i < values.length) {
            answer[i] = TextUtil.strip(values[i]);
            ++i;
        }
        return answer;
    }

    public static String stripNonNumberCharacters(String value) {
        int start = 0;
        int len = value.length();
        while (start < len && VALID_NUM_CHARACTERS.indexOf(value.charAt(start)) < 0) {
            ++start;
        }
        while (start < len && VALID_NUM_CHARACTERS.indexOf(value.charAt(len - 1)) < 0) {
            --len;
        }
        return start > 0 || len < value.length() ? value.substring(start, len) : value;
    }

    public static char getListSeparatorChar() {
        if ("CH".equals(Locale.getDefault().getCountry())) {
            return ';';
        }
        return DECIMAL_SEPARATOR == ',' ? (char)';' : ',';
    }

    public static String fromCamelCase(String camelCase) {
        if (camelCase == null) {
            return null;
        }
        String[] parts = camelCase.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        StringBuilder buffer = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(Character.toUpperCase(string.charAt(0)));
            buffer.append(string.substring(1));
            ++n2;
        }
        return buffer.toString();
    }
}

