/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.util;

import java.text.Collator;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import name.abuchen.portfolio.util.Holiday;
import name.abuchen.portfolio.util.HolidayType;

public class TradeCalendar
implements Comparable<TradeCalendar> {
    public static final String EMPTY_CODE = "empty";
    private static final Set<DayOfWeek> WEEKEND = EnumSet.of(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    private final String code;
    private final String description;
    private final List<HolidayType> holidayTypes = new ArrayList<HolidayType>();
    private final Map<Integer, Map<LocalDate, Holiday>> cache = new HashMap<Integer, Map<LocalDate, Holiday>>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Map<LocalDate, Holiday> get(Object key) {
            return super.computeIfAbsent((Integer)key, year -> TradeCalendar.this.holidayTypes.stream().map(type -> type.getHoliday((int)year)).filter(Objects::nonNull).collect(Collectors.toMap(Holiday::getDate, t -> t, (r, l) -> r)));
        }
    };

    TradeCalendar(String code, String description) {
        this.code = Objects.requireNonNull(code);
        this.description = Objects.requireNonNull(description);
    }

    void add(HolidayType type) {
        this.holidayTypes.add(type);
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean isHoliday(LocalDate date) {
        if (EMPTY_CODE.equals(this.getCode())) {
            return false;
        }
        if (WEEKEND.contains(date.getDayOfWeek())) {
            return true;
        }
        return this.cache.get(date.getYear()).containsKey(date);
    }

    public Collection<Holiday> getHolidays(int year) {
        return this.cache.get(year).values();
    }

    @Override
    public int compareTo(TradeCalendar other) {
        Collator collator = Collator.getInstance();
        collator.setStrength(1);
        return collator.compare(this.getDescription(), other.getDescription());
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TradeCalendar other = (TradeCalendar)obj;
        return this.code.equals(other.code);
    }
}

