/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.util;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.time.LocalDate;
import name.abuchen.portfolio.model.SecurityPrice;

public class XStreamSecurityPriceConverter
implements Converter {
    public boolean canConvert(Class object) {
        return object.equals(SecurityPrice.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        SecurityPrice price = (SecurityPrice)value;
        if (price.getDate() != null) {
            writer.addAttribute("t", price.getDate().toString());
        }
        writer.addAttribute("v", Long.toString(price.getValue()));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        SecurityPrice price = new SecurityPrice();
        String attribute = reader.getAttribute("t");
        if (attribute != null) {
            price.setDate(LocalDate.parse(attribute));
        }
        price.setValue(Long.parseLong(reader.getAttribute("v")));
        return price;
    }
}

