__version__   = "$Revision: 1.2 $"[11:-2]
__copyright__ = """Copyright (c) 2003 Not Another Corporation Incorporated
                   www.notanothercorporation.com"""
__license__   = """Licensed under the GNU LGPL

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__doc__ = """
** %(name)s **
File version %(version)s::
 
    %(copyright)s

    %(license)s

Part of the C{mongoose} package, provides the C{SessionInfo} object
which allows read-only retrieval of information about the current user
session.

The information is set (indirectly) by the Python program currently
under the eye of the Mongoose, and is fixed when the C{SessionInfo}
object is created.

The C{SessionInfo} object is passed to C{Reporter} subclass instances.

I{* $Id: sessioninfo.py,v 1.2 2003/09/24 17:03:31 philiplindsay Exp $ *}
""" % {'name':__name__, 'version':__version__, 'copyright':__copyright__,
       'license':__license__}


from safereadonlymixin import SafeReadOnlyMixin

    
STRING_UNKNOWN = "unknown"

class SessionInfo(SafeReadOnlyMixin):
    """
    Stores read-only information about the current session.

    This object is created by the C{mongoose} when an exception occurs, from
    a dictionary which has entries specified by the program under the
    C{mongooses}'s care.
    """
    def __init__(self, infoDict):
        """
        Calls super
        """
        # Note: The 'str' here is kinda redundant since we already do that
        #       for 'setSessionInfo()'...
        super(SessionInfo, self).__init__(infoDict, str)


    def __getattr__(self, name):
        """
        Returns the value of the attribute C{name} or the value of
        C{STRING_UNKNOWN} if no attribute of the requested name is
        known.
        """
        value = super(SessionInfo, self).__getattr__(name)

        if value is None:
            value = STRING_UNKNOWN
            
        return value
