# The PEP 484 type hints stub file for the QtChart module.
#
# Generated by SIP 4.19.25
#
# Copyright (c) 2021 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQtChart.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import typing
import sip

from PyQt5 import QtWidgets
from PyQt5 import QtGui

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt5.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt5.sip.Buffer, int, None]


class QtCharts(sip.simplewrapper):

    class QAbstractAxis(QtCore.QObject):

        class AxisType(int): ...
        AxisTypeNoAxis = ... # type: 'QAbstractAxis.AxisType'
        AxisTypeValue = ... # type: 'QAbstractAxis.AxisType'
        AxisTypeBarCategory = ... # type: 'QAbstractAxis.AxisType'
        AxisTypeCategory = ... # type: 'QAbstractAxis.AxisType'
        AxisTypeDateTime = ... # type: 'QAbstractAxis.AxisType'
        AxisTypeLogValue = ... # type: 'QAbstractAxis.AxisType'

        class AxisTypes(sip.simplewrapper):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, f: typing.Union['QAbstractAxis.AxisTypes', 'QAbstractAxis.AxisType']) -> None: ...
            @typing.overload
            def __init__(self, a0: 'QAbstractAxis.AxisTypes') -> None: ...

            def __hash__(self) -> int: ...
            def __bool__(self) -> int: ...
            def __invert__(self) -> 'QAbstractAxis.AxisTypes': ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...

        def labelsEditableChanged(self, editable: bool) -> None: ...
        def labelsEditable(self) -> bool: ...
        def setLabelsEditable(self, editable: bool = ...) -> None: ...
        def reverseChanged(self, reverse: bool) -> None: ...
        def minorGridLineColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def gridLineColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def minorGridLinePenChanged(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def minorGridVisibleChanged(self, visible: bool) -> None: ...
        def isReverse(self) -> bool: ...
        def setReverse(self, reverse: bool = ...) -> None: ...
        def minorGridLineColor(self) -> QtGui.QColor: ...
        def setMinorGridLineColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def gridLineColor(self) -> QtGui.QColor: ...
        def setGridLineColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def minorGridLinePen(self) -> QtGui.QPen: ...
        def setMinorGridLinePen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def setMinorGridLineVisible(self, visible: bool = ...) -> None: ...
        def isMinorGridLineVisible(self) -> bool: ...
        def shadesBrushChanged(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def shadesPenChanged(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def titleFontChanged(self, font: QtGui.QFont) -> None: ...
        def titleVisibleChanged(self, visible: bool) -> None: ...
        def titleBrushChanged(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def titleTextChanged(self, title: str) -> None: ...
        def gridLinePenChanged(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def labelsAngleChanged(self, angle: int) -> None: ...
        def labelsFontChanged(self, pen: QtGui.QFont) -> None: ...
        def labelsBrushChanged(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def linePenChanged(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def alignment(self) -> QtCore.Qt.Alignment: ...
        def titleText(self) -> str: ...
        def setTitleText(self, title: str) -> None: ...
        def titleFont(self) -> QtGui.QFont: ...
        def setTitleFont(self, font: QtGui.QFont) -> None: ...
        def titleBrush(self) -> QtGui.QBrush: ...
        def setTitleBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def setTitleVisible(self, visible: bool = ...) -> None: ...
        def isTitleVisible(self) -> bool: ...
        def shadesBorderColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def shadesColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def shadesVisibleChanged(self, visible: bool) -> None: ...
        def labelsColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def colorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def gridVisibleChanged(self, visible: bool) -> None: ...
        def labelsVisibleChanged(self, visible: bool) -> None: ...
        def lineVisibleChanged(self, visible: bool) -> None: ...
        def visibleChanged(self, visible: bool) -> None: ...
        def orientation(self) -> QtCore.Qt.Orientation: ...
        def hide(self) -> None: ...
        def show(self) -> None: ...
        def setRange(self, min: typing.Any, max: typing.Any) -> None: ...
        def setMax(self, max: typing.Any) -> None: ...
        def setMin(self, min: typing.Any) -> None: ...
        def shadesBorderColor(self) -> QtGui.QColor: ...
        def setShadesBorderColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def shadesColor(self) -> QtGui.QColor: ...
        def setShadesColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def shadesBrush(self) -> QtGui.QBrush: ...
        def setShadesBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def shadesPen(self) -> QtGui.QPen: ...
        def setShadesPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def setShadesVisible(self, visible: bool = ...) -> None: ...
        def shadesVisible(self) -> bool: ...
        def labelsColor(self) -> QtGui.QColor: ...
        def setLabelsColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def labelsAngle(self) -> int: ...
        def setLabelsAngle(self, angle: int) -> None: ...
        def labelsFont(self) -> QtGui.QFont: ...
        def setLabelsFont(self, font: QtGui.QFont) -> None: ...
        def labelsBrush(self) -> QtGui.QBrush: ...
        def setLabelsBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def setLabelsVisible(self, visible: bool = ...) -> None: ...
        def labelsVisible(self) -> bool: ...
        def gridLinePen(self) -> QtGui.QPen: ...
        def setGridLinePen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def setGridLineVisible(self, visible: bool = ...) -> None: ...
        def isGridLineVisible(self) -> bool: ...
        def linePenColor(self) -> QtGui.QColor: ...
        def setLinePenColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def linePen(self) -> QtGui.QPen: ...
        def setLinePen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def setLineVisible(self, visible: bool = ...) -> None: ...
        def isLineVisible(self) -> bool: ...
        def setVisible(self, visible: bool = ...) -> None: ...
        def isVisible(self) -> bool: ...
        def type(self) -> 'QAbstractAxis.AxisType': ...

    class QAbstractSeries(QtCore.QObject):

        class SeriesType(int): ...
        SeriesTypeLine = ... # type: 'QAbstractSeries.SeriesType'
        SeriesTypeArea = ... # type: 'QAbstractSeries.SeriesType'
        SeriesTypeBar = ... # type: 'QAbstractSeries.SeriesType'
        SeriesTypeStackedBar = ... # type: 'QAbstractSeries.SeriesType'
        SeriesTypePercentBar = ... # type: 'QAbstractSeries.SeriesType'
        SeriesTypePie = ... # type: 'QAbstractSeries.SeriesType'
        SeriesTypeScatter = ... # type: 'QAbstractSeries.SeriesType'
        SeriesTypeSpline = ... # type: 'QAbstractSeries.SeriesType'
        SeriesTypeHorizontalBar = ... # type: 'QAbstractSeries.SeriesType'
        SeriesTypeHorizontalStackedBar = ... # type: 'QAbstractSeries.SeriesType'
        SeriesTypeHorizontalPercentBar = ... # type: 'QAbstractSeries.SeriesType'
        SeriesTypeBoxPlot = ... # type: 'QAbstractSeries.SeriesType'
        SeriesTypeCandlestick = ... # type: 'QAbstractSeries.SeriesType'

        def useOpenGLChanged(self) -> None: ...
        def useOpenGL(self) -> bool: ...
        def setUseOpenGL(self, enable: bool = ...) -> None: ...
        def opacityChanged(self) -> None: ...
        def attachedAxes(self) -> typing.List['QAbstractAxis']: ...
        def detachAxis(self, axis: 'QAbstractAxis') -> bool: ...
        def attachAxis(self, axis: 'QAbstractAxis') -> bool: ...
        def setOpacity(self, opacity: float) -> None: ...
        def opacity(self) -> float: ...
        def visibleChanged(self) -> None: ...
        def nameChanged(self) -> None: ...
        def hide(self) -> None: ...
        def show(self) -> None: ...
        def chart(self) -> 'QChart': ...
        def isVisible(self) -> bool: ...
        def setVisible(self, visible: bool = ...) -> None: ...
        def name(self) -> str: ...
        def setName(self, name: str) -> None: ...
        def type(self) -> 'QAbstractSeries.SeriesType': ...

    class QAbstractBarSeries('QAbstractSeries'):

        class LabelsPosition(int): ...
        LabelsCenter = ... # type: 'QAbstractBarSeries.LabelsPosition'
        LabelsInsideEnd = ... # type: 'QAbstractBarSeries.LabelsPosition'
        LabelsInsideBase = ... # type: 'QAbstractBarSeries.LabelsPosition'
        LabelsOutsideEnd = ... # type: 'QAbstractBarSeries.LabelsPosition'

        def labelsPrecisionChanged(self, precision: int) -> None: ...
        def labelsPrecision(self) -> int: ...
        def setLabelsPrecision(self, precision: int) -> None: ...
        def labelsAngleChanged(self, angle: float) -> None: ...
        def labelsAngle(self) -> float: ...
        def setLabelsAngle(self, angle: float) -> None: ...
        def doubleClicked(self, index: int, barset: 'QBarSet') -> None: ...
        def released(self, index: int, barset: 'QBarSet') -> None: ...
        def pressed(self, index: int, barset: 'QBarSet') -> None: ...
        def labelsPositionChanged(self, position: 'QAbstractBarSeries.LabelsPosition') -> None: ...
        def labelsFormatChanged(self, format: str) -> None: ...
        def labelsPosition(self) -> 'QAbstractBarSeries.LabelsPosition': ...
        def setLabelsPosition(self, position: 'QAbstractBarSeries.LabelsPosition') -> None: ...
        def labelsFormat(self) -> str: ...
        def setLabelsFormat(self, format: str) -> None: ...
        def barsetsRemoved(self, sets: typing.Iterable['QBarSet']) -> None: ...
        def barsetsAdded(self, sets: typing.Iterable['QBarSet']) -> None: ...
        def labelsVisibleChanged(self) -> None: ...
        def countChanged(self) -> None: ...
        def hovered(self, status: bool, index: int, barset: 'QBarSet') -> None: ...
        def clicked(self, index: int, barset: 'QBarSet') -> None: ...
        def take(self, set: 'QBarSet') -> bool: ...
        def isLabelsVisible(self) -> bool: ...
        def setLabelsVisible(self, visible: bool = ...) -> None: ...
        def clear(self) -> None: ...
        def barSets(self) -> typing.List['QBarSet']: ...
        def __len__(self) -> int: ...
        def count(self) -> int: ...
        def insert(self, index: int, set: 'QBarSet') -> bool: ...
        def remove(self, set: 'QBarSet') -> bool: ...
        @typing.overload
        def append(self, set: 'QBarSet') -> bool: ...
        @typing.overload
        def append(self, sets: typing.Iterable['QBarSet']) -> bool: ...
        def barWidth(self) -> float: ...
        def setBarWidth(self, width: float) -> None: ...

    class QLegendMarker(QtCore.QObject):

        class LegendMarkerType(int): ...
        LegendMarkerTypeArea = ... # type: 'QLegendMarker.LegendMarkerType'
        LegendMarkerTypeBar = ... # type: 'QLegendMarker.LegendMarkerType'
        LegendMarkerTypePie = ... # type: 'QLegendMarker.LegendMarkerType'
        LegendMarkerTypeXY = ... # type: 'QLegendMarker.LegendMarkerType'
        LegendMarkerTypeBoxPlot = ... # type: 'QLegendMarker.LegendMarkerType'
        LegendMarkerTypeCandlestick = ... # type: 'QLegendMarker.LegendMarkerType'

        def shapeChanged(self) -> None: ...
        def setShape(self, shape: 'QLegend.MarkerShape') -> None: ...
        def shape(self) -> 'QLegend.MarkerShape': ...
        def visibleChanged(self) -> None: ...
        def brushChanged(self) -> None: ...
        def penChanged(self) -> None: ...
        def fontChanged(self) -> None: ...
        def labelBrushChanged(self) -> None: ...
        def labelChanged(self) -> None: ...
        def hovered(self, status: bool) -> None: ...
        def clicked(self) -> None: ...
        def series(self) -> 'QAbstractSeries': ...
        def setVisible(self, visible: bool) -> None: ...
        def isVisible(self) -> bool: ...
        def setBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def brush(self) -> QtGui.QBrush: ...
        def setPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def pen(self) -> QtGui.QPen: ...
        def setFont(self, font: QtGui.QFont) -> None: ...
        def font(self) -> QtGui.QFont: ...
        def setLabelBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def labelBrush(self) -> QtGui.QBrush: ...
        def setLabel(self, label: str) -> None: ...
        def label(self) -> str: ...
        def type(self) -> 'QLegendMarker.LegendMarkerType': ...

    class QAreaLegendMarker('QLegendMarker'):

        def __init__(self, series: 'QAreaSeries', legend: 'QLegend', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def series(self) -> 'QAreaSeries': ...
        def type(self) -> 'QLegendMarker.LegendMarkerType': ...

    class QAreaSeries('QAbstractSeries'):

        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, upperSeries: 'QLineSeries', lowerSeries: typing.Optional['QLineSeries'] = ...) -> None: ...

        def pointLabelsClippingChanged(self, clipping: bool) -> None: ...
        def pointLabelsClipping(self) -> bool: ...
        def setPointLabelsClipping(self, enable: bool = ...) -> None: ...
        def doubleClicked(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
        def released(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
        def pressed(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
        def pointLabelsColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def pointLabelsFontChanged(self, font: QtGui.QFont) -> None: ...
        def pointLabelsVisibilityChanged(self, visible: bool) -> None: ...
        def pointLabelsFormatChanged(self, format: str) -> None: ...
        def pointLabelsColor(self) -> QtGui.QColor: ...
        def setPointLabelsColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def pointLabelsFont(self) -> QtGui.QFont: ...
        def setPointLabelsFont(self, font: QtGui.QFont) -> None: ...
        def pointLabelsVisible(self) -> bool: ...
        def setPointLabelsVisible(self, visible: bool = ...) -> None: ...
        def pointLabelsFormat(self) -> str: ...
        def setPointLabelsFormat(self, format: str) -> None: ...
        def hovered(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], state: bool) -> None: ...
        def selected(self) -> None: ...
        def clicked(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
        def colorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def borderColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def borderColor(self) -> QtGui.QColor: ...
        def setBorderColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def color(self) -> QtGui.QColor: ...
        def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def pointsVisible(self) -> bool: ...
        def setPointsVisible(self, visible: bool = ...) -> None: ...
        def brush(self) -> QtGui.QBrush: ...
        def setBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def pen(self) -> QtGui.QPen: ...
        def setPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def lowerSeries(self) -> 'QLineSeries': ...
        def setLowerSeries(self, series: 'QLineSeries') -> None: ...
        def upperSeries(self) -> 'QLineSeries': ...
        def setUpperSeries(self, series: 'QLineSeries') -> None: ...
        def type(self) -> 'QAbstractSeries.SeriesType': ...

    class QBarCategoryAxis('QAbstractAxis'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def countChanged(self) -> None: ...
        def rangeChanged(self, min: str, max: str) -> None: ...
        def maxChanged(self, max: str) -> None: ...
        def minChanged(self, min: str) -> None: ...
        def categoriesChanged(self) -> None: ...
        def setRange(self, minCategory: str, maxCategory: str) -> None: ...
        def max(self) -> str: ...
        def setMax(self, maxCategory: str) -> None: ...
        def min(self) -> str: ...
        def setMin(self, minCategory: str) -> None: ...
        def at(self, index: int) -> str: ...
        def __len__(self) -> int: ...
        def count(self) -> int: ...
        def categories(self) -> typing.List[str]: ...
        def setCategories(self, categories: typing.Iterable[str]) -> None: ...
        def clear(self) -> None: ...
        def replace(self, oldCategory: str, newCategory: str) -> None: ...
        def insert(self, index: int, category: str) -> None: ...
        def remove(self, category: str) -> None: ...
        @typing.overload
        def append(self, categories: typing.Iterable[str]) -> None: ...
        @typing.overload
        def append(self, category: str) -> None: ...
        def type(self) -> 'QAbstractAxis.AxisType': ...

    class QBarLegendMarker('QLegendMarker'):

        def __init__(self, series: 'QAbstractBarSeries', barset: 'QBarSet', legend: 'QLegend', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def barset(self) -> 'QBarSet': ...
        def series(self) -> 'QAbstractBarSeries': ...
        def type(self) -> 'QLegendMarker.LegendMarkerType': ...

    class QBarSeries('QAbstractBarSeries'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def type(self) -> 'QAbstractSeries.SeriesType': ...

    class QBarSet(QtCore.QObject):

        def __init__(self, name: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def doubleClicked(self, index: int) -> None: ...
        def released(self, index: int) -> None: ...
        def pressed(self, index: int) -> None: ...
        def labelColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def borderColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def colorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def hovered(self, status: bool, index: int) -> None: ...
        def clicked(self, index: int) -> None: ...
        def valueChanged(self, index: int) -> None: ...
        def valuesRemoved(self, index: int, count: int) -> None: ...
        def valuesAdded(self, index: int, count: int) -> None: ...
        def labelFontChanged(self) -> None: ...
        def labelBrushChanged(self) -> None: ...
        def labelChanged(self) -> None: ...
        def brushChanged(self) -> None: ...
        def penChanged(self) -> None: ...
        def setLabelColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def labelColor(self) -> QtGui.QColor: ...
        def setBorderColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def borderColor(self) -> QtGui.QColor: ...
        def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def color(self) -> QtGui.QColor: ...
        def __getitem__(self, index: int) -> float: ...
        def at(self, index: int) -> float: ...
        def remove(self, index: int, count: int = ...) -> None: ...
        def label(self) -> str: ...
        def setLabel(self, label: str) -> None: ...
        def labelFont(self) -> QtGui.QFont: ...
        def setLabelFont(self, font: QtGui.QFont) -> None: ...
        def labelBrush(self) -> QtGui.QBrush: ...
        def setLabelBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def brush(self) -> QtGui.QBrush: ...
        def setBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def pen(self) -> QtGui.QPen: ...
        def setPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def sum(self) -> float: ...
        def __len__(self) -> int: ...
        def count(self) -> int: ...
        def replace(self, index: int, value: float) -> None: ...
        def insert(self, index: int, value: float) -> None: ...
        @typing.overload
        def append(self, value: float) -> None: ...
        @typing.overload
        def append(self, values: typing.Iterable[float]) -> None: ...

    class QBoxPlotLegendMarker('QLegendMarker'):

        def __init__(self, series: 'QBoxPlotSeries', legend: 'QLegend', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def series(self) -> 'QBoxPlotSeries': ...
        def type(self) -> 'QLegendMarker.LegendMarkerType': ...

    class QBoxPlotSeries('QAbstractSeries'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def doubleClicked(self, boxset: 'QBoxSet') -> None: ...
        def released(self, boxset: 'QBoxSet') -> None: ...
        def pressed(self, boxset: 'QBoxSet') -> None: ...
        def boxsetsRemoved(self, sets: typing.Iterable['QBoxSet']) -> None: ...
        def boxsetsAdded(self, sets: typing.Iterable['QBoxSet']) -> None: ...
        def boxWidthChanged(self) -> None: ...
        def boxOutlineVisibilityChanged(self) -> None: ...
        def brushChanged(self) -> None: ...
        def penChanged(self) -> None: ...
        def countChanged(self) -> None: ...
        def hovered(self, status: bool, boxset: 'QBoxSet') -> None: ...
        def clicked(self, boxset: 'QBoxSet') -> None: ...
        def pen(self) -> QtGui.QPen: ...
        def setPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def brush(self) -> QtGui.QBrush: ...
        def setBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def boxWidth(self) -> float: ...
        def setBoxWidth(self, width: float) -> None: ...
        def boxOutlineVisible(self) -> bool: ...
        def setBoxOutlineVisible(self, visible: bool) -> None: ...
        def type(self) -> 'QAbstractSeries.SeriesType': ...
        def clear(self) -> None: ...
        def boxSets(self) -> typing.List['QBoxSet']: ...
        def __len__(self) -> int: ...
        def count(self) -> int: ...
        def insert(self, index: int, box: 'QBoxSet') -> bool: ...
        def take(self, box: 'QBoxSet') -> bool: ...
        def remove(self, box: 'QBoxSet') -> bool: ...
        @typing.overload
        def append(self, box: 'QBoxSet') -> bool: ...
        @typing.overload
        def append(self, boxes: typing.Iterable['QBoxSet']) -> bool: ...

    class QBoxSet(QtCore.QObject):

        class ValuePositions(int): ...
        LowerExtreme = ... # type: 'QBoxSet.ValuePositions'
        LowerQuartile = ... # type: 'QBoxSet.ValuePositions'
        Median = ... # type: 'QBoxSet.ValuePositions'
        UpperQuartile = ... # type: 'QBoxSet.ValuePositions'
        UpperExtreme = ... # type: 'QBoxSet.ValuePositions'

        @typing.overload
        def __init__(self, label: str = ..., parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, le: float, lq: float, m: float, uq: float, ue: float, label: str = ..., parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def doubleClicked(self) -> None: ...
        def released(self) -> None: ...
        def pressed(self) -> None: ...
        def cleared(self) -> None: ...
        def valueChanged(self, index: int) -> None: ...
        def valuesChanged(self) -> None: ...
        def brushChanged(self) -> None: ...
        def penChanged(self) -> None: ...
        def hovered(self, status: bool) -> None: ...
        def clicked(self) -> None: ...
        def brush(self) -> QtGui.QBrush: ...
        def setBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def pen(self) -> QtGui.QPen: ...
        def setPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def __len__(self) -> int: ...
        def count(self) -> int: ...
        def __getitem__(self, index: int) -> float: ...
        def at(self, index: int) -> float: ...
        def setValue(self, index: int, value: float) -> None: ...
        def label(self) -> str: ...
        def setLabel(self, label: str) -> None: ...
        def clear(self) -> None: ...
        @typing.overload
        def append(self, value: float) -> None: ...
        @typing.overload
        def append(self, values: typing.Iterable[float]) -> None: ...

    class QCandlestickLegendMarker('QLegendMarker'):

        def __init__(self, series: 'QCandlestickSeries', legend: 'QLegend', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def series(self) -> 'QCandlestickSeries': ...
        def type(self) -> 'QLegendMarker.LegendMarkerType': ...

    class QCandlestickModelMapper(QtCore.QObject):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def lastSetSection(self) -> int: ...
        def setLastSetSection(self, lastSetSection: int) -> None: ...
        def firstSetSection(self) -> int: ...
        def setFirstSetSection(self, firstSetSection: int) -> None: ...
        def close(self) -> int: ...
        def setClose(self, close: int) -> None: ...
        def low(self) -> int: ...
        def setLow(self, low: int) -> None: ...
        def high(self) -> int: ...
        def setHigh(self, high: int) -> None: ...
        def open(self) -> int: ...
        def setOpen(self, open: int) -> None: ...
        def timestamp(self) -> int: ...
        def setTimestamp(self, timestamp: int) -> None: ...
        def seriesReplaced(self) -> None: ...
        def modelReplaced(self) -> None: ...
        def orientation(self) -> QtCore.Qt.Orientation: ...
        def series(self) -> 'QCandlestickSeries': ...
        def setSeries(self, series: 'QCandlestickSeries') -> None: ...
        def model(self) -> QtCore.QAbstractItemModel: ...
        def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...

    class QCandlestickSeries('QAbstractSeries'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def penChanged(self) -> None: ...
        def brushChanged(self) -> None: ...
        def decreasingColorChanged(self) -> None: ...
        def increasingColorChanged(self) -> None: ...
        def capsVisibilityChanged(self) -> None: ...
        def capsWidthChanged(self) -> None: ...
        def bodyOutlineVisibilityChanged(self) -> None: ...
        def bodyWidthChanged(self) -> None: ...
        def minimumColumnWidthChanged(self) -> None: ...
        def maximumColumnWidthChanged(self) -> None: ...
        def countChanged(self) -> None: ...
        def candlestickSetsRemoved(self, sets: typing.Iterable['QCandlestickSet']) -> None: ...
        def candlestickSetsAdded(self, sets: typing.Iterable['QCandlestickSet']) -> None: ...
        def doubleClicked(self, set: 'QCandlestickSet') -> None: ...
        def released(self, set: 'QCandlestickSet') -> None: ...
        def pressed(self, set: 'QCandlestickSet') -> None: ...
        def hovered(self, status: bool, set: 'QCandlestickSet') -> None: ...
        def clicked(self, set: 'QCandlestickSet') -> None: ...
        def pen(self) -> QtGui.QPen: ...
        def setPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def brush(self) -> QtGui.QBrush: ...
        def setBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def decreasingColor(self) -> QtGui.QColor: ...
        def setDecreasingColor(self, decreasingColor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def increasingColor(self) -> QtGui.QColor: ...
        def setIncreasingColor(self, increasingColor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def capsVisible(self) -> bool: ...
        def setCapsVisible(self, capsVisible: bool) -> None: ...
        def capsWidth(self) -> float: ...
        def setCapsWidth(self, capsWidth: float) -> None: ...
        def bodyOutlineVisible(self) -> bool: ...
        def setBodyOutlineVisible(self, bodyOutlineVisible: bool) -> None: ...
        def bodyWidth(self) -> float: ...
        def setBodyWidth(self, bodyWidth: float) -> None: ...
        def minimumColumnWidth(self) -> float: ...
        def setMinimumColumnWidth(self, minimumColumnWidth: float) -> None: ...
        def maximumColumnWidth(self) -> float: ...
        def setMaximumColumnWidth(self, maximumColumnWidth: float) -> None: ...
        def type(self) -> 'QAbstractSeries.SeriesType': ...
        def __len__(self) -> int: ...
        def count(self) -> int: ...
        def sets(self) -> typing.List['QCandlestickSet']: ...
        def clear(self) -> None: ...
        def take(self, set: 'QCandlestickSet') -> bool: ...
        def insert(self, index: int, set: 'QCandlestickSet') -> bool: ...
        @typing.overload
        def remove(self, set: 'QCandlestickSet') -> bool: ...
        @typing.overload
        def remove(self, sets: typing.Iterable['QCandlestickSet']) -> bool: ...
        @typing.overload
        def append(self, set: 'QCandlestickSet') -> bool: ...
        @typing.overload
        def append(self, sets: typing.Iterable['QCandlestickSet']) -> bool: ...

    class QCandlestickSet(QtCore.QObject):

        @typing.overload
        def __init__(self, timestamp: float = ..., parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, open: float, high: float, low: float, close: float, timestamp: float = ..., parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def penChanged(self) -> None: ...
        def brushChanged(self) -> None: ...
        def closeChanged(self) -> None: ...
        def lowChanged(self) -> None: ...
        def highChanged(self) -> None: ...
        def openChanged(self) -> None: ...
        def timestampChanged(self) -> None: ...
        def doubleClicked(self) -> None: ...
        def released(self) -> None: ...
        def pressed(self) -> None: ...
        def hovered(self, status: bool) -> None: ...
        def clicked(self) -> None: ...
        def pen(self) -> QtGui.QPen: ...
        def setPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def brush(self) -> QtGui.QBrush: ...
        def setBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def close(self) -> float: ...
        def setClose(self, close: float) -> None: ...
        def low(self) -> float: ...
        def setLow(self, low: float) -> None: ...
        def high(self) -> float: ...
        def setHigh(self, high: float) -> None: ...
        def open(self) -> float: ...
        def setOpen(self, open: float) -> None: ...
        def timestamp(self) -> float: ...
        def setTimestamp(self, timestamp: float) -> None: ...

    class QValueAxis('QAbstractAxis'):

        class TickType(int): ...
        TicksDynamic = ... # type: 'QValueAxis.TickType'
        TicksFixed = ... # type: 'QValueAxis.TickType'

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def tickTypeChanged(self, type: 'QValueAxis.TickType') -> None: ...
        def tickAnchorChanged(self, anchor: float) -> None: ...
        def tickIntervalChanged(self, interval: float) -> None: ...
        def tickType(self) -> 'QValueAxis.TickType': ...
        def setTickType(self, type: 'QValueAxis.TickType') -> None: ...
        def tickInterval(self) -> float: ...
        def setTickInterval(self, insterval: float) -> None: ...
        def tickAnchor(self) -> float: ...
        def setTickAnchor(self, anchor: float) -> None: ...
        def minorTickCountChanged(self, tickCount: int) -> None: ...
        def minorTickCount(self) -> int: ...
        def setMinorTickCount(self, count: int) -> None: ...
        def labelFormatChanged(self, format: str) -> None: ...
        def tickCountChanged(self, tickCount: int) -> None: ...
        def rangeChanged(self, min: float, max: float) -> None: ...
        def maxChanged(self, max: float) -> None: ...
        def minChanged(self, min: float) -> None: ...
        def applyNiceNumbers(self) -> None: ...
        def labelFormat(self) -> str: ...
        def setLabelFormat(self, format: str) -> None: ...
        def tickCount(self) -> int: ...
        def setTickCount(self, count: int) -> None: ...
        def setRange(self, min: float, max: float) -> None: ...
        def max(self) -> float: ...
        def setMax(self, max: float) -> None: ...
        def min(self) -> float: ...
        def setMin(self, min: float) -> None: ...
        def type(self) -> 'QAbstractAxis.AxisType': ...

    class QCategoryAxis('QValueAxis'):

        class AxisLabelsPosition(int): ...
        AxisLabelsPositionCenter = ... # type: 'QCategoryAxis.AxisLabelsPosition'
        AxisLabelsPositionOnValue = ... # type: 'QCategoryAxis.AxisLabelsPosition'

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def labelsPositionChanged(self, position: 'QCategoryAxis.AxisLabelsPosition') -> None: ...
        def setLabelsPosition(self, position: 'QCategoryAxis.AxisLabelsPosition') -> None: ...
        def labelsPosition(self) -> 'QCategoryAxis.AxisLabelsPosition': ...
        def categoriesChanged(self) -> None: ...
        def __len__(self) -> int: ...
        def count(self) -> int: ...
        def categoriesLabels(self) -> typing.List[str]: ...
        def endValue(self, categoryLabel: str) -> float: ...
        def setStartValue(self, min: float) -> None: ...
        def startValue(self, categoryLabel: str = ...) -> float: ...
        def replaceLabel(self, oldLabel: str, newLabel: str) -> None: ...
        def remove(self, label: str) -> None: ...
        def append(self, label: str, categoryEndValue: float) -> None: ...
        def type(self) -> 'QAbstractAxis.AxisType': ...

    class QChart(QtWidgets.QGraphicsWidget):

        class ChartType(int): ...
        ChartTypeUndefined = ... # type: 'QChart.ChartType'
        ChartTypeCartesian = ... # type: 'QChart.ChartType'
        ChartTypePolar = ... # type: 'QChart.ChartType'

        class AnimationOption(int): ...
        NoAnimation = ... # type: 'QChart.AnimationOption'
        GridAxisAnimations = ... # type: 'QChart.AnimationOption'
        SeriesAnimations = ... # type: 'QChart.AnimationOption'
        AllAnimations = ... # type: 'QChart.AnimationOption'

        class ChartTheme(int): ...
        ChartThemeLight = ... # type: 'QChart.ChartTheme'
        ChartThemeBlueCerulean = ... # type: 'QChart.ChartTheme'
        ChartThemeDark = ... # type: 'QChart.ChartTheme'
        ChartThemeBrownSand = ... # type: 'QChart.ChartTheme'
        ChartThemeBlueNcs = ... # type: 'QChart.ChartTheme'
        ChartThemeHighContrast = ... # type: 'QChart.ChartTheme'
        ChartThemeBlueIcy = ... # type: 'QChart.ChartTheme'
        ChartThemeQt = ... # type: 'QChart.ChartTheme'

        class AnimationOptions(sip.simplewrapper):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, f: typing.Union['QChart.AnimationOptions', 'QChart.AnimationOption']) -> None: ...
            @typing.overload
            def __init__(self, a0: 'QChart.AnimationOptions') -> None: ...

            def __hash__(self) -> int: ...
            def __bool__(self) -> int: ...
            def __invert__(self) -> 'QChart.AnimationOptions': ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...

        def __init__(self, parent: typing.Optional[QtWidgets.QGraphicsItem] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

        def animationEasingCurve(self) -> QtCore.QEasingCurve: ...
        def setAnimationEasingCurve(self, curve: typing.Union[QtCore.QEasingCurve, QtCore.QEasingCurve.Type]) -> None: ...
        def animationDuration(self) -> int: ...
        def setAnimationDuration(self, msecs: int) -> None: ...
        def plotAreaChanged(self, plotArea: QtCore.QRectF) -> None: ...
        def locale(self) -> QtCore.QLocale: ...
        def setLocale(self, locale: QtCore.QLocale) -> None: ...
        def localizeNumbers(self) -> bool: ...
        def setLocalizeNumbers(self, localize: bool) -> None: ...
        def chartType(self) -> 'QChart.ChartType': ...
        def isPlotAreaBackgroundVisible(self) -> bool: ...
        def setPlotAreaBackgroundVisible(self, visible: bool = ...) -> None: ...
        def plotAreaBackgroundPen(self) -> QtGui.QPen: ...
        def setPlotAreaBackgroundPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def plotAreaBackgroundBrush(self) -> QtGui.QBrush: ...
        def setPlotAreaBackgroundBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def setPlotArea(self, rect: QtCore.QRectF) -> None: ...
        def isZoomed(self) -> bool: ...
        def zoomReset(self) -> None: ...
        def backgroundRoundness(self) -> float: ...
        def setBackgroundRoundness(self, diameter: float) -> None: ...
        def mapToPosition(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint], series: typing.Optional['QAbstractSeries'] = ...) -> QtCore.QPointF: ...
        def mapToValue(self, position: typing.Union[QtCore.QPointF, QtCore.QPoint], series: typing.Optional['QAbstractSeries'] = ...) -> QtCore.QPointF: ...
        def margins(self) -> QtCore.QMargins: ...
        def setMargins(self, margins: QtCore.QMargins) -> None: ...
        def axes(self, orientation: typing.Union[QtCore.Qt.Orientations, QtCore.Qt.Orientation] = ..., series: typing.Optional['QAbstractSeries'] = ...) -> typing.List['QAbstractAxis']: ...
        def removeAxis(self, axis: 'QAbstractAxis') -> None: ...
        def addAxis(self, axis: 'QAbstractAxis', alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
        def plotArea(self) -> QtCore.QRectF: ...
        def scroll(self, dx: float, dy: float) -> None: ...
        def isDropShadowEnabled(self) -> bool: ...
        def setDropShadowEnabled(self, enabled: bool = ...) -> None: ...
        def createDefaultAxes(self) -> None: ...
        def axisY(self, series: typing.Optional['QAbstractSeries'] = ...) -> 'QAbstractAxis': ...
        def axisX(self, series: typing.Optional['QAbstractSeries'] = ...) -> 'QAbstractAxis': ...
        def setAxisY(self, axis: 'QAbstractAxis', series: typing.Optional['QAbstractSeries'] = ...) -> None: ...
        def setAxisX(self, axis: 'QAbstractAxis', series: typing.Optional['QAbstractSeries'] = ...) -> None: ...
        def legend(self) -> 'QLegend': ...
        def zoom(self, factor: float) -> None: ...
        def zoomOut(self) -> None: ...
        @typing.overload
        def zoomIn(self) -> None: ...
        @typing.overload
        def zoomIn(self, rect: QtCore.QRectF) -> None: ...
        def animationOptions(self) -> 'QChart.AnimationOptions': ...
        def setAnimationOptions(self, options: typing.Union['QChart.AnimationOptions', 'QChart.AnimationOption']) -> None: ...
        def isBackgroundVisible(self) -> bool: ...
        def setBackgroundVisible(self, visible: bool = ...) -> None: ...
        def backgroundPen(self) -> QtGui.QPen: ...
        def setBackgroundPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def backgroundBrush(self) -> QtGui.QBrush: ...
        def setBackgroundBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def titleBrush(self) -> QtGui.QBrush: ...
        def setTitleBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def titleFont(self) -> QtGui.QFont: ...
        def setTitleFont(self, font: QtGui.QFont) -> None: ...
        def title(self) -> str: ...
        def setTitle(self, title: str) -> None: ...
        def theme(self) -> 'QChart.ChartTheme': ...
        def setTheme(self, theme: 'QChart.ChartTheme') -> None: ...
        def series(self) -> typing.List['QAbstractSeries']: ...
        def removeAllSeries(self) -> None: ...
        def removeSeries(self, series: 'QAbstractSeries') -> None: ...
        def addSeries(self, series: 'QAbstractSeries') -> None: ...

    class QChartView(QtWidgets.QGraphicsView):

        class RubberBand(int): ...
        NoRubberBand = ... # type: 'QChartView.RubberBand'
        VerticalRubberBand = ... # type: 'QChartView.RubberBand'
        HorizontalRubberBand = ... # type: 'QChartView.RubberBand'
        RectangleRubberBand = ... # type: 'QChartView.RubberBand'

        class RubberBands(sip.simplewrapper):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, f: typing.Union['QChartView.RubberBands', 'QChartView.RubberBand']) -> None: ...
            @typing.overload
            def __init__(self, a0: 'QChartView.RubberBands') -> None: ...

            def __hash__(self) -> int: ...
            def __bool__(self) -> int: ...
            def __invert__(self) -> 'QChartView.RubberBands': ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...

        @typing.overload
        def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...
        @typing.overload
        def __init__(self, chart: 'QChart', parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

        def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
        def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
        def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
        def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
        def chart(self) -> 'QChart': ...
        def setChart(self, chart: 'QChart') -> None: ...
        def rubberBand(self) -> 'QChartView.RubberBands': ...
        def setRubberBand(self, rubberBands: typing.Union['QChartView.RubberBands', 'QChartView.RubberBand']) -> None: ...

    class QDateTimeAxis('QAbstractAxis'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def tickCountChanged(self, tick: int) -> None: ...
        def formatChanged(self, format: str) -> None: ...
        def rangeChanged(self, min: typing.Union[QtCore.QDateTime, datetime.datetime], max: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
        def maxChanged(self, max: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
        def minChanged(self, min: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
        def tickCount(self) -> int: ...
        def setTickCount(self, count: int) -> None: ...
        def format(self) -> str: ...
        def setFormat(self, format: str) -> None: ...
        def setRange(self, min: typing.Union[QtCore.QDateTime, datetime.datetime], max: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
        def max(self) -> QtCore.QDateTime: ...
        def setMax(self, max: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
        def min(self) -> QtCore.QDateTime: ...
        def setMin(self, min: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
        def type(self) -> 'QAbstractAxis.AxisType': ...

    class QHBarModelMapper(QtCore.QObject):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def columnCountChanged(self) -> None: ...
        def firstColumnChanged(self) -> None: ...
        def lastBarSetRowChanged(self) -> None: ...
        def firstBarSetRowChanged(self) -> None: ...
        def modelReplaced(self) -> None: ...
        def seriesReplaced(self) -> None: ...
        def setColumnCount(self, columnCount: int) -> None: ...
        def columnCount(self) -> int: ...
        def setFirstColumn(self, firstColumn: int) -> None: ...
        def firstColumn(self) -> int: ...
        def setSeries(self, series: 'QAbstractBarSeries') -> None: ...
        def series(self) -> 'QAbstractBarSeries': ...
        def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...
        def model(self) -> QtCore.QAbstractItemModel: ...
        def setLastBarSetRow(self, lastBarSetRow: int) -> None: ...
        def lastBarSetRow(self) -> int: ...
        def setFirstBarSetRow(self, firstBarSetRow: int) -> None: ...
        def firstBarSetRow(self) -> int: ...

    class QHBoxPlotModelMapper(QtCore.QObject):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def columnCountChanged(self) -> None: ...
        def firstColumnChanged(self) -> None: ...
        def lastBoxSetRowChanged(self) -> None: ...
        def firstBoxSetRowChanged(self) -> None: ...
        def modelReplaced(self) -> None: ...
        def seriesReplaced(self) -> None: ...
        def setColumnCount(self, rowCount: int) -> None: ...
        def columnCount(self) -> int: ...
        def setFirstColumn(self, firstColumn: int) -> None: ...
        def firstColumn(self) -> int: ...
        def setLastBoxSetRow(self, lastBoxSetRow: int) -> None: ...
        def lastBoxSetRow(self) -> int: ...
        def setFirstBoxSetRow(self, firstBoxSetRow: int) -> None: ...
        def firstBoxSetRow(self) -> int: ...
        def setSeries(self, series: 'QBoxPlotSeries') -> None: ...
        def series(self) -> 'QBoxPlotSeries': ...
        def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...
        def model(self) -> QtCore.QAbstractItemModel: ...

    class QHCandlestickModelMapper('QCandlestickModelMapper'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def lastSetRowChanged(self) -> None: ...
        def firstSetRowChanged(self) -> None: ...
        def closeColumnChanged(self) -> None: ...
        def lowColumnChanged(self) -> None: ...
        def highColumnChanged(self) -> None: ...
        def openColumnChanged(self) -> None: ...
        def timestampColumnChanged(self) -> None: ...
        def lastSetRow(self) -> int: ...
        def setLastSetRow(self, lastSetRow: int) -> None: ...
        def firstSetRow(self) -> int: ...
        def setFirstSetRow(self, firstSetRow: int) -> None: ...
        def closeColumn(self) -> int: ...
        def setCloseColumn(self, closeColumn: int) -> None: ...
        def lowColumn(self) -> int: ...
        def setLowColumn(self, lowColumn: int) -> None: ...
        def highColumn(self) -> int: ...
        def setHighColumn(self, highColumn: int) -> None: ...
        def openColumn(self) -> int: ...
        def setOpenColumn(self, openColumn: int) -> None: ...
        def timestampColumn(self) -> int: ...
        def setTimestampColumn(self, timestampColumn: int) -> None: ...
        def orientation(self) -> QtCore.Qt.Orientation: ...

    class QHorizontalBarSeries('QAbstractBarSeries'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def type(self) -> 'QAbstractSeries.SeriesType': ...

    class QHorizontalPercentBarSeries('QAbstractBarSeries'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def type(self) -> 'QAbstractSeries.SeriesType': ...

    class QHorizontalStackedBarSeries('QAbstractBarSeries'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def type(self) -> 'QAbstractSeries.SeriesType': ...

    class QHPieModelMapper(QtCore.QObject):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def columnCountChanged(self) -> None: ...
        def firstColumnChanged(self) -> None: ...
        def labelsRowChanged(self) -> None: ...
        def valuesRowChanged(self) -> None: ...
        def modelReplaced(self) -> None: ...
        def seriesReplaced(self) -> None: ...
        def setColumnCount(self, columnCount: int) -> None: ...
        def columnCount(self) -> int: ...
        def setFirstColumn(self, firstColumn: int) -> None: ...
        def firstColumn(self) -> int: ...
        def setSeries(self, series: 'QPieSeries') -> None: ...
        def series(self) -> 'QPieSeries': ...
        def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...
        def model(self) -> QtCore.QAbstractItemModel: ...
        def setLabelsRow(self, labelsRow: int) -> None: ...
        def labelsRow(self) -> int: ...
        def setValuesRow(self, valuesRow: int) -> None: ...
        def valuesRow(self) -> int: ...

    class QHXYModelMapper(QtCore.QObject):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def columnCountChanged(self) -> None: ...
        def firstColumnChanged(self) -> None: ...
        def yRowChanged(self) -> None: ...
        def xRowChanged(self) -> None: ...
        def modelReplaced(self) -> None: ...
        def seriesReplaced(self) -> None: ...
        def setColumnCount(self, columnCount: int) -> None: ...
        def columnCount(self) -> int: ...
        def setFirstColumn(self, firstColumn: int) -> None: ...
        def firstColumn(self) -> int: ...
        def setSeries(self, series: 'QXYSeries') -> None: ...
        def series(self) -> 'QXYSeries': ...
        def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...
        def model(self) -> QtCore.QAbstractItemModel: ...
        def setYRow(self, yRow: int) -> None: ...
        def yRow(self) -> int: ...
        def setXRow(self, xRow: int) -> None: ...
        def xRow(self) -> int: ...

    class QLegend(QtWidgets.QGraphicsWidget):

        class MarkerShape(int): ...
        MarkerShapeDefault = ... # type: 'QLegend.MarkerShape'
        MarkerShapeRectangle = ... # type: 'QLegend.MarkerShape'
        MarkerShapeCircle = ... # type: 'QLegend.MarkerShape'
        MarkerShapeFromSeries = ... # type: 'QLegend.MarkerShape'

        def markerShapeChanged(self, shape: 'QLegend.MarkerShape') -> None: ...
        def setMarkerShape(self, shape: 'QLegend.MarkerShape') -> None: ...
        def markerShape(self) -> 'QLegend.MarkerShape': ...
        def showToolTipsChanged(self, showToolTips: bool) -> None: ...
        def setShowToolTips(self, show: bool) -> None: ...
        def showToolTips(self) -> bool: ...
        def reverseMarkersChanged(self, reverseMarkers: bool) -> None: ...
        def setReverseMarkers(self, reverseMarkers: bool = ...) -> None: ...
        def reverseMarkers(self) -> bool: ...
        def showEvent(self, event: QtGui.QShowEvent) -> None: ...
        def hideEvent(self, event: QtGui.QHideEvent) -> None: ...
        def labelColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def fontChanged(self, font: QtGui.QFont) -> None: ...
        def borderColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def colorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def backgroundVisibleChanged(self, visible: bool) -> None: ...
        def markers(self, series: typing.Optional['QAbstractSeries'] = ...) -> typing.List['QLegendMarker']: ...
        def labelColor(self) -> QtGui.QColor: ...
        def setLabelColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def labelBrush(self) -> QtGui.QBrush: ...
        def setLabelBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def font(self) -> QtGui.QFont: ...
        def setFont(self, font: QtGui.QFont) -> None: ...
        def borderColor(self) -> QtGui.QColor: ...
        def setBorderColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def color(self) -> QtGui.QColor: ...
        def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def isBackgroundVisible(self) -> bool: ...
        def setBackgroundVisible(self, visible: bool = ...) -> None: ...
        def isAttachedToChart(self) -> bool: ...
        def attachToChart(self) -> None: ...
        def detachFromChart(self) -> None: ...
        def alignment(self) -> QtCore.Qt.Alignment: ...
        def setAlignment(self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
        def pen(self) -> QtGui.QPen: ...
        def setPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def brush(self) -> QtGui.QBrush: ...
        def setBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def paint(self, painter: QtGui.QPainter, option: QtWidgets.QStyleOptionGraphicsItem, widget: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    class QXYSeries('QAbstractSeries'):

        def penChanged(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def pointsRemoved(self, index: int, count: int) -> None: ...
        def pointLabelsClippingChanged(self, clipping: bool) -> None: ...
        def pointLabelsClipping(self) -> bool: ...
        def setPointLabelsClipping(self, enable: bool = ...) -> None: ...
        def pointsVector(self) -> typing.List[QtCore.QPointF]: ...
        def removePoints(self, index: int, count: int) -> None: ...
        def doubleClicked(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
        def released(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
        def pressed(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
        def pointLabelsColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def pointLabelsFontChanged(self, font: QtGui.QFont) -> None: ...
        def pointLabelsVisibilityChanged(self, visible: bool) -> None: ...
        def pointLabelsFormatChanged(self, format: str) -> None: ...
        def pointLabelsColor(self) -> QtGui.QColor: ...
        def setPointLabelsColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def pointLabelsFont(self) -> QtGui.QFont: ...
        def setPointLabelsFont(self, font: QtGui.QFont) -> None: ...
        def pointLabelsVisible(self) -> bool: ...
        def setPointLabelsVisible(self, visible: bool = ...) -> None: ...
        def pointLabelsFormat(self) -> str: ...
        def setPointLabelsFormat(self, format: str) -> None: ...
        def hovered(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], state: bool) -> None: ...
        def pointsReplaced(self) -> None: ...
        def pointAdded(self, index: int) -> None: ...
        def pointRemoved(self, index: int) -> None: ...
        def pointReplaced(self, index: int) -> None: ...
        def colorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def clicked(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
        def at(self, index: int) -> QtCore.QPointF: ...
        def pointsVisible(self) -> bool: ...
        def setPointsVisible(self, visible: bool = ...) -> None: ...
        def color(self) -> QtGui.QColor: ...
        def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def brush(self) -> QtGui.QBrush: ...
        def setBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def pen(self) -> QtGui.QPen: ...
        def setPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def __len__(self) -> int: ...
        def count(self) -> int: ...
        def clear(self) -> None: ...
        def insert(self, index: int, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
        @typing.overload
        def remove(self, x: float, y: float) -> None: ...
        @typing.overload
        def remove(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
        @typing.overload
        def remove(self, index: int) -> None: ...
        @typing.overload
        def replace(self, oldX: float, oldY: float, newX: float, newY: float) -> None: ...
        @typing.overload
        def replace(self, oldPoint: typing.Union[QtCore.QPointF, QtCore.QPoint], newPoint: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
        @typing.overload
        def replace(self, points: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...
        @typing.overload
        def replace(self, index: int, newX: float, newY: float) -> None: ...
        @typing.overload
        def replace(self, index: int, newPoint: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
        @typing.overload
        def append(self, x: float, y: float) -> None: ...
        @typing.overload
        def append(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
        @typing.overload
        def append(self, points: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...

    class QLineSeries('QXYSeries'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def type(self) -> 'QAbstractSeries.SeriesType': ...

    class QLogValueAxis('QAbstractAxis'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def minorTickCountChanged(self, minorTickCount: int) -> None: ...
        def tickCountChanged(self, tickCount: int) -> None: ...
        def minorTickCount(self) -> int: ...
        def setMinorTickCount(self, minorTickCount: int) -> None: ...
        def tickCount(self) -> int: ...
        def baseChanged(self, base: float) -> None: ...
        def labelFormatChanged(self, format: str) -> None: ...
        def rangeChanged(self, min: float, max: float) -> None: ...
        def maxChanged(self, max: float) -> None: ...
        def minChanged(self, min: float) -> None: ...
        def base(self) -> float: ...
        def setBase(self, base: float) -> None: ...
        def labelFormat(self) -> str: ...
        def setLabelFormat(self, format: str) -> None: ...
        def setRange(self, min: float, max: float) -> None: ...
        def max(self) -> float: ...
        def setMax(self, max: float) -> None: ...
        def min(self) -> float: ...
        def setMin(self, min: float) -> None: ...
        def type(self) -> 'QAbstractAxis.AxisType': ...

    class QPercentBarSeries('QAbstractBarSeries'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def type(self) -> 'QAbstractSeries.SeriesType': ...

    class QPieLegendMarker('QLegendMarker'):

        def __init__(self, series: 'QPieSeries', slice: 'QPieSlice', legend: 'QLegend', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def slice(self) -> 'QPieSlice': ...
        def series(self) -> 'QPieSeries': ...
        def type(self) -> 'QLegendMarker.LegendMarkerType': ...

    class QPieSeries('QAbstractSeries'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def doubleClicked(self, slice: 'QPieSlice') -> None: ...
        def released(self, slice: 'QPieSlice') -> None: ...
        def pressed(self, slice: 'QPieSlice') -> None: ...
        def setLabelsPosition(self, position: 'QPieSlice.LabelPosition') -> None: ...
        def holeSize(self) -> float: ...
        def setHoleSize(self, holeSize: float) -> None: ...
        def take(self, slice: 'QPieSlice') -> bool: ...
        def sumChanged(self) -> None: ...
        def countChanged(self) -> None: ...
        def hovered(self, slice: 'QPieSlice', state: bool) -> None: ...
        def clicked(self, slice: 'QPieSlice') -> None: ...
        def removed(self, slices: typing.Iterable['QPieSlice']) -> None: ...
        def added(self, slices: typing.Iterable['QPieSlice']) -> None: ...
        def setLabelsVisible(self, visible: bool = ...) -> None: ...
        def pieEndAngle(self) -> float: ...
        def setPieEndAngle(self, endAngle: float) -> None: ...
        def pieStartAngle(self) -> float: ...
        def setPieStartAngle(self, startAngle: float) -> None: ...
        def pieSize(self) -> float: ...
        def setPieSize(self, relativeSize: float) -> None: ...
        def verticalPosition(self) -> float: ...
        def setVerticalPosition(self, relativePosition: float) -> None: ...
        def horizontalPosition(self) -> float: ...
        def setHorizontalPosition(self, relativePosition: float) -> None: ...
        def sum(self) -> float: ...
        def isEmpty(self) -> bool: ...
        def __len__(self) -> int: ...
        def count(self) -> int: ...
        def slices(self) -> typing.List['QPieSlice']: ...
        def clear(self) -> None: ...
        def remove(self, slice: 'QPieSlice') -> bool: ...
        def insert(self, index: int, slice: 'QPieSlice') -> bool: ...
        @typing.overload
        def append(self, slice: 'QPieSlice') -> bool: ...
        @typing.overload
        def append(self, slices: typing.Iterable['QPieSlice']) -> bool: ...
        @typing.overload
        def append(self, label: str, value: float) -> 'QPieSlice': ...
        def type(self) -> 'QAbstractSeries.SeriesType': ...

    class QPieSlice(QtCore.QObject):

        class LabelPosition(int): ...
        LabelOutside = ... # type: 'QPieSlice.LabelPosition'
        LabelInsideHorizontal = ... # type: 'QPieSlice.LabelPosition'
        LabelInsideTangential = ... # type: 'QPieSlice.LabelPosition'
        LabelInsideNormal = ... # type: 'QPieSlice.LabelPosition'

        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, label: str, value: float, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def doubleClicked(self) -> None: ...
        def released(self) -> None: ...
        def pressed(self) -> None: ...
        def hovered(self, state: bool) -> None: ...
        def clicked(self) -> None: ...
        def labelColorChanged(self) -> None: ...
        def borderWidthChanged(self) -> None: ...
        def borderColorChanged(self) -> None: ...
        def colorChanged(self) -> None: ...
        def angleSpanChanged(self) -> None: ...
        def startAngleChanged(self) -> None: ...
        def percentageChanged(self) -> None: ...
        def labelFontChanged(self) -> None: ...
        def labelBrushChanged(self) -> None: ...
        def brushChanged(self) -> None: ...
        def penChanged(self) -> None: ...
        def labelVisibleChanged(self) -> None: ...
        def valueChanged(self) -> None: ...
        def labelChanged(self) -> None: ...
        def setLabelPosition(self, position: 'QPieSlice.LabelPosition') -> None: ...
        def labelPosition(self) -> 'QPieSlice.LabelPosition': ...
        def series(self) -> 'QPieSeries': ...
        def angleSpan(self) -> float: ...
        def startAngle(self) -> float: ...
        def percentage(self) -> float: ...
        def explodeDistanceFactor(self) -> float: ...
        def setExplodeDistanceFactor(self, factor: float) -> None: ...
        def labelArmLengthFactor(self) -> float: ...
        def setLabelArmLengthFactor(self, factor: float) -> None: ...
        def labelFont(self) -> QtGui.QFont: ...
        def setLabelFont(self, font: QtGui.QFont) -> None: ...
        def setLabelColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def labelColor(self) -> QtGui.QColor: ...
        def labelBrush(self) -> QtGui.QBrush: ...
        def setLabelBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def color(self) -> QtGui.QColor: ...
        def brush(self) -> QtGui.QBrush: ...
        def setBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def setBorderWidth(self, width: int) -> None: ...
        def borderWidth(self) -> int: ...
        def setBorderColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def borderColor(self) -> QtGui.QColor: ...
        def pen(self) -> QtGui.QPen: ...
        def setPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def isExploded(self) -> bool: ...
        def setExploded(self, exploded: bool = ...) -> None: ...
        def isLabelVisible(self) -> bool: ...
        def setLabelVisible(self, visible: bool = ...) -> None: ...
        def value(self) -> float: ...
        def setValue(self, value: float) -> None: ...
        def label(self) -> str: ...
        def setLabel(self, label: str) -> None: ...

    class QPolarChart('QChart'):

        class PolarOrientation(int): ...
        PolarOrientationRadial = ... # type: 'QPolarChart.PolarOrientation'
        PolarOrientationAngular = ... # type: 'QPolarChart.PolarOrientation'

        class PolarOrientations(sip.simplewrapper):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, f: typing.Union['QPolarChart.PolarOrientations', 'QPolarChart.PolarOrientation']) -> None: ...
            @typing.overload
            def __init__(self, a0: 'QPolarChart.PolarOrientations') -> None: ...

            def __hash__(self) -> int: ...
            def __bool__(self) -> int: ...
            def __invert__(self) -> 'QPolarChart.PolarOrientations': ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...

        def __init__(self, parent: typing.Optional[QtWidgets.QGraphicsItem] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

        @staticmethod
        def axisPolarOrientation(axis: 'QAbstractAxis') -> 'QPolarChart.PolarOrientation': ...
        def axes(self, polarOrientation: 'QPolarChart.PolarOrientations' = ..., series: typing.Optional['QAbstractSeries'] = ...) -> typing.List['QAbstractAxis']: ...
        def addAxis(self, axis: 'QAbstractAxis', polarOrientation: 'QPolarChart.PolarOrientation') -> None: ...

    class QScatterSeries('QXYSeries'):

        class MarkerShape(int): ...
        MarkerShapeCircle = ... # type: 'QScatterSeries.MarkerShape'
        MarkerShapeRectangle = ... # type: 'QScatterSeries.MarkerShape'

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def markerSizeChanged(self, size: float) -> None: ...
        def markerShapeChanged(self, shape: 'QScatterSeries.MarkerShape') -> None: ...
        def borderColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def colorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def borderColor(self) -> QtGui.QColor: ...
        def setBorderColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def color(self) -> QtGui.QColor: ...
        def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def setBrush(self, brush: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def brush(self) -> QtGui.QBrush: ...
        def setPen(self, pen: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
        def setMarkerSize(self, size: float) -> None: ...
        def markerSize(self) -> float: ...
        def setMarkerShape(self, shape: 'QScatterSeries.MarkerShape') -> None: ...
        def markerShape(self) -> 'QScatterSeries.MarkerShape': ...
        def type(self) -> 'QAbstractSeries.SeriesType': ...

    class QSplineSeries('QLineSeries'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def type(self) -> 'QAbstractSeries.SeriesType': ...

    class QStackedBarSeries('QAbstractBarSeries'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def type(self) -> 'QAbstractSeries.SeriesType': ...

    class QVBarModelMapper(QtCore.QObject):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def rowCountChanged(self) -> None: ...
        def firstRowChanged(self) -> None: ...
        def lastBarSetColumnChanged(self) -> None: ...
        def firstBarSetColumnChanged(self) -> None: ...
        def modelReplaced(self) -> None: ...
        def seriesReplaced(self) -> None: ...
        def setRowCount(self, rowCount: int) -> None: ...
        def rowCount(self) -> int: ...
        def setFirstRow(self, firstRow: int) -> None: ...
        def firstRow(self) -> int: ...
        def setSeries(self, series: 'QAbstractBarSeries') -> None: ...
        def series(self) -> 'QAbstractBarSeries': ...
        def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...
        def model(self) -> QtCore.QAbstractItemModel: ...
        def setLastBarSetColumn(self, lastBarSetColumn: int) -> None: ...
        def lastBarSetColumn(self) -> int: ...
        def setFirstBarSetColumn(self, firstBarSetColumn: int) -> None: ...
        def firstBarSetColumn(self) -> int: ...

    class QVBoxPlotModelMapper(QtCore.QObject):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def rowCountChanged(self) -> None: ...
        def firstRowChanged(self) -> None: ...
        def lastBoxSetColumnChanged(self) -> None: ...
        def firstBoxSetColumnChanged(self) -> None: ...
        def modelReplaced(self) -> None: ...
        def seriesReplaced(self) -> None: ...
        def setRowCount(self, rowCount: int) -> None: ...
        def rowCount(self) -> int: ...
        def setFirstRow(self, firstRow: int) -> None: ...
        def firstRow(self) -> int: ...
        def setLastBoxSetColumn(self, lastBoxSetColumn: int) -> None: ...
        def lastBoxSetColumn(self) -> int: ...
        def setFirstBoxSetColumn(self, firstBoxSetColumn: int) -> None: ...
        def firstBoxSetColumn(self) -> int: ...
        def setSeries(self, series: 'QBoxPlotSeries') -> None: ...
        def series(self) -> 'QBoxPlotSeries': ...
        def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...
        def model(self) -> QtCore.QAbstractItemModel: ...

    class QVCandlestickModelMapper('QCandlestickModelMapper'):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def lastSetColumnChanged(self) -> None: ...
        def firstSetColumnChanged(self) -> None: ...
        def closeRowChanged(self) -> None: ...
        def lowRowChanged(self) -> None: ...
        def highRowChanged(self) -> None: ...
        def openRowChanged(self) -> None: ...
        def timestampRowChanged(self) -> None: ...
        def lastSetColumn(self) -> int: ...
        def setLastSetColumn(self, lastSetColumn: int) -> None: ...
        def firstSetColumn(self) -> int: ...
        def setFirstSetColumn(self, firstSetColumn: int) -> None: ...
        def closeRow(self) -> int: ...
        def setCloseRow(self, closeRow: int) -> None: ...
        def lowRow(self) -> int: ...
        def setLowRow(self, lowRow: int) -> None: ...
        def highRow(self) -> int: ...
        def setHighRow(self, highRow: int) -> None: ...
        def openRow(self) -> int: ...
        def setOpenRow(self, openRow: int) -> None: ...
        def timestampRow(self) -> int: ...
        def setTimestampRow(self, timestampRow: int) -> None: ...
        def orientation(self) -> QtCore.Qt.Orientation: ...

    class QVPieModelMapper(QtCore.QObject):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def rowCountChanged(self) -> None: ...
        def firstRowChanged(self) -> None: ...
        def labelsColumnChanged(self) -> None: ...
        def valuesColumnChanged(self) -> None: ...
        def modelReplaced(self) -> None: ...
        def seriesReplaced(self) -> None: ...
        def setRowCount(self, rowCount: int) -> None: ...
        def rowCount(self) -> int: ...
        def setFirstRow(self, firstRow: int) -> None: ...
        def firstRow(self) -> int: ...
        def setSeries(self, series: 'QPieSeries') -> None: ...
        def series(self) -> 'QPieSeries': ...
        def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...
        def model(self) -> QtCore.QAbstractItemModel: ...
        def setLabelsColumn(self, labelsColumn: int) -> None: ...
        def labelsColumn(self) -> int: ...
        def setValuesColumn(self, valuesColumn: int) -> None: ...
        def valuesColumn(self) -> int: ...

    class QVXYModelMapper(QtCore.QObject):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def rowCountChanged(self) -> None: ...
        def firstRowChanged(self) -> None: ...
        def yColumnChanged(self) -> None: ...
        def xColumnChanged(self) -> None: ...
        def modelReplaced(self) -> None: ...
        def seriesReplaced(self) -> None: ...
        def setRowCount(self, rowCount: int) -> None: ...
        def rowCount(self) -> int: ...
        def setFirstRow(self, firstRow: int) -> None: ...
        def firstRow(self) -> int: ...
        def setSeries(self, series: 'QXYSeries') -> None: ...
        def series(self) -> 'QXYSeries': ...
        def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...
        def model(self) -> QtCore.QAbstractItemModel: ...
        def setYColumn(self, yColumn: int) -> None: ...
        def yColumn(self) -> int: ...
        def setXColumn(self, xColumn: int) -> None: ...
        def xColumn(self) -> int: ...

    class QXYLegendMarker('QLegendMarker'):

        def __init__(self, series: 'QXYSeries', legend: 'QLegend', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def series(self) -> 'QXYSeries': ...
        def type(self) -> 'QLegendMarker.LegendMarkerType': ...


PYQT_CHART_VERSION = ... # type: int
PYQT_CHART_VERSION_STR = ... # type: str
