# encoding: utf-8
'''Character encodings
'''

charsets = {
ur'ascii': {ur'alias':ur'646, us-ascii',ur'language':ur'English'},
ur'big5': {ur'alias':ur'big5-tw, csbig5',ur'language':ur'Traditional Chinese'},
ur'big5hkscs': {ur'alias':ur'big5-hkscs, hkscs',ur'language':ur'Traditional Chinese'},
ur'cp037': {ur'alias':ur'IBM037, IBM039',ur'language':ur'English'},
ur'cp424': {ur'alias':ur'EBCDIC-CP-HE, IBM424',ur'language':ur'Hebrew'},
ur'cp437': {ur'alias':ur'437, IBM437',ur'language':ur'English'},
ur'cp500': {ur'alias':ur'EBCDIC-CP-BE, EBCDIC-CP-CH, IBM500',ur'language':ur'Western Europe'},
ur'cp737': {ur'language':ur'Greek'},
ur'cp775': {ur'alias':ur'IBM775',ur'language':ur'Baltic languages'},
ur'cp850': {ur'alias':ur'850, IBM850',ur'language':ur'Western Europe'},
ur'cp852': {ur'alias':ur'852, IBM852',ur'language':ur'Central and Eastern Europe'},
ur'cp855': {ur'alias':ur'855, IBM855',ur'language':ur'Bulgarian, Byelorussian, Macedonian, Russian, Serbian'},
ur'cp856': {ur'language':ur'Hebrew'},
ur'cp857': {ur'alias':ur'857, IBM857',ur'language':ur'Turkish'},
ur'cp860': {ur'alias':ur'860, IBM860',ur'language':ur'Portuguese'},
ur'cp861': {ur'alias':ur'861, CP-IS, IBM861',ur'language':ur'Icelandic'},
ur'cp862': {ur'alias':ur'862, IBM862',ur'language':ur'Hebrew'},
ur'cp863': {ur'alias':ur'863, IBM863',ur'language':ur'Canadian'},
ur'cp864': {ur'alias':ur'IBM864',ur'language':ur'Arabic'},
ur'cp865': {ur'alias':ur'865, IBM865',ur'language':ur'Danish, Norwegian'},
ur'cp866': {ur'alias':ur'866, IBM866',ur'language':ur'Russian'},
ur'cp869': {ur'alias':ur'869, CP-GR, IBM869',ur'language':ur'Greek'},
ur'cp874': {ur'language':ur'Thai'},
ur'cp875': {ur'language':ur'Greek'},
ur'cp932': {ur'alias':ur'932, ms932, mskanji, ms-kanji',ur'language':ur'Japanese'},
ur'cp949': {ur'alias':ur'949, ms949, uhc',ur'language':ur'Korean'},
ur'cp950': {ur'alias':ur'950, ms950',ur'language':ur'Traditional Chinese'},
ur'cp1006': {ur'language':ur'Urdu'},
ur'cp1026': {ur'alias':ur'ibm1026',ur'language':ur'Turkish'},
ur'cp1140': {ur'alias':ur'ibm1140',ur'language':ur'Western Europe'},
ur'cp1250': {ur'alias':ur'windows-1250',ur'language':ur'Central and Eastern Europe'},
ur'cp1251': {ur'alias':ur'windows-1251',ur'language':ur'Bulgarian, Byelorussian, Macedonian, Russian, Serbian'},
ur'cp1252': {ur'alias':ur'windows-1252',ur'language':ur'Western Europe'},
ur'cp1253': {ur'alias':ur'windows-1253',ur'language':ur'Greek'},
ur'cp1254': {ur'alias':ur'windows-1254',ur'language':ur'Turkish'},
ur'cp1255': {ur'alias':ur'windows-1255',ur'language':ur'Hebrew'},
ur'cp1256': {ur'alias':ur'windows1256',ur'language':ur'Arabic'},
ur'cp1257': {ur'alias':ur'windows-1257',ur'language':ur'Baltic languages'},
ur'cp1258': {ur'alias':ur'windows-1258',ur'language':ur'Vietnamese'},
ur'euc_jp': {ur'alias':ur'eucjp, ujis, u-jis',ur'language':ur'Japanese'},
ur'euc_jis_2004': {ur'alias':ur'jisx0213, eucjis2004',ur'language':ur'Japanese'},
ur'euc_jisx0213': {ur'alias':ur'eucjisx0213',ur'language':ur'Japanese'},
ur'euc_kr': {ur'alias':ur'euckr, korean, ksc5601, ks_c-5601, ks_c-5601-1987, ksx1001, ks_x-1001',ur'language':ur'Korean'},
ur'gb2312': {ur'alias':ur'chinese, csiso58gb231280, euc-cn, euccn, eucgb2312-cn, gb2312-1980, gb2312-80, iso-ir-58',ur'language':ur'Simplified Chinese'},
ur'gbk': {ur'alias':ur'936, cp936, ms936',ur'language':ur'Unified Chinese'},
ur'gb18030': {ur'alias':ur'gb18030-2000',ur'language':ur'Unified Chinese'},
ur'hz': {ur'alias':ur'hzgb, hz-gb, hz-gb-2312',ur'language':ur'Simplified Chinese'},
ur'iso2022_jp': {ur'alias':ur'csiso2022jp, iso2022jp, iso-2022-jp',ur'language':ur'Japanese'},
ur'iso2022_jp_1': {ur'alias':ur'iso2022jp-1, iso-2022-jp-1',ur'language':ur'Japanese'},
ur'iso2022_jp_2': {ur'alias':ur'iso2022jp-2, iso-2022-jp-2',ur'language':ur'Japanese, Korean, Simplified Chinese, Western Europe, Greek'},
ur'iso2022_jp_2004': {ur'alias':ur'iso2022jp-2004, iso-2022-jp-2004',ur'language':ur'Japanese'},
ur'iso2022_jp_3': {ur'alias':ur'iso2022jp-3, iso-2022-jp-3',ur'language':ur'Japanese'},
ur'iso2022_jp_ext': {ur'alias':ur'iso2022jp-ext, iso-2022-jp-ext',ur'language':ur'Japanese'},
ur'iso2022_kr': {ur'alias':ur'csiso2022kr, iso2022kr, iso-2022-kr',ur'language':ur'Korean'},
ur'latin_1': {ur'alias':ur'iso-8859-1, iso8859-1, 8859, cp819, latin, latin1, L1',ur'language':ur'West Europe'},
ur'iso8859_2': {ur'alias':ur'iso-8859-2, latin2, L2',ur'language':ur'Central and Eastern Europe'},
ur'iso8859_3': {ur'alias':ur'iso-8859-3, latin3, L3',ur'language':ur'Esperanto, Maltese'},
ur'iso8859_4': {ur'alias':ur'iso-8859-4, latin4, L4',ur'language':ur'Baltic languagues'},
ur'iso8859_5': {ur'alias':ur'iso-8859-5, cyrillic',ur'language':ur'Bulgarian, Byelorussian, Macedonian, Russian, Serbian'},
ur'iso8859_6': {ur'alias':ur'iso-8859-6, arabic',ur'language':ur'Arabic'},
ur'iso8859_7': {ur'alias':ur'iso-8859-7, greek, greek8',ur'language':ur'Greek'},
ur'iso8859_8': {ur'alias':ur'iso-8859-8, hebrew',ur'language':ur'Hebrew'},
ur'iso8859_9': {ur'alias':ur'iso-8859-9, latin5, L5',ur'language':ur'Turkish'},
ur'iso8859_10': {ur'alias':ur'iso-8859-10, latin6, L6',ur'language':ur'Nordic languages'},
ur'iso8859_13': {ur'alias':ur'iso-8859-13',ur'language':ur'Baltic languages'},
ur'iso8859_14': {ur'alias':ur'iso-8859-14, latin8, L8',ur'language':ur'Celtic languages'},
ur'iso8859_15': {ur'alias':ur'iso-8859-15',ur'language':ur'Western Europe'},
ur'johab': {ur'alias':ur'cp1361, ms1361',ur'language':ur'Korean'},
ur'koi8_r': {ur'language':ur'Russian'},
ur'koi8_u': {ur'language':ur'Ukrainian'},
ur'mac_cyrillic': {ur'alias':ur'maccyrillic',ur'language':ur'Bulgarian, Byelorussian, Macedonian, Russian, Serbian'},
ur'mac_greek': {ur'alias':ur'macgreek',ur'language':ur'Greek'},
ur'mac_iceland': {ur'alias':ur'maciceland',ur'language':ur'Icelandic'},
ur'mac_latin2': {ur'alias':ur'maclatin2, maccentraleurope',ur'language':ur'Central and Eastern Europe'},
ur'mac_roman': {ur'alias':ur'macroman',ur'language':ur'Western Europe'},
ur'mac_turkish': {ur'alias':ur'macturkish',ur'language':ur'Turkish'},
ur'ptcp154': {ur'alias':ur'csptcp154, pt154, cp154, cyrillic-asian',ur'language':ur'Kazakh'},
ur'shift_jis': {ur'alias':ur'csshiftjis, shiftjis, sjis, s_jis',ur'language':ur'Japanese'},
ur'shift_jis_2004': {ur'alias':ur'shiftjis2004, sjis_2004, sjis2004',ur'language':ur'Japanese'},
ur'shift_jisx0213': {ur'alias':ur'shiftjisx0213, sjisx0213, s_jisx0213',ur'language':ur'Japanese'},
ur'utf_16': {ur'alias':ur'U16, utf16',ur'language':ur'all'},
ur'utf_16_be': {ur'alias':ur'UTF-16BE',ur'language':ur'all (BMP only)'},
ur'utf_16_le': {ur'alias':ur'UTF-16LE',ur'language':ur'all (BMP only)'},
ur'utf_7': {ur'alias':ur'U7, unicode-1-1-utf-7',ur'language':ur'all'},
ur'utf_8': {ur'alias':ur'U8, UTF, utf8',ur'language':ur'all'},
ur'utf_8_sig': {ur'language':ur'all'},
# Specials
ur'idna': {ur'description':ur'Implements RFC 3490.'},
ur'palmos': {ur'description':ur'Encoding of PalmOS 3.5'},
ur'punycode': {ur'description':ur'RFC 3492'},
ur'raw_unicode_escape': {ur'description':ur'Produce a string that is suitable as raw Unicode literal in source code'},
ur'rot_13': {ur'alias':ur'rot13',ur'description':ur'Returns the Caesar-cypher encryption of the operand'},
ur'unicode_escape': {ur'description':ur'Produce a string that is suitable as Unicode literal in source code'},
ur'unicode_internal': {ur'description':ur'Return the internal representation of the operand'},
}
'''Available character encodings.
'''

import codecs
for k in charsets.keys():
  try:
    codecs.lookup(k)
  except LookupError:
    del charsets[k]
del k