/*******************************************************************************
* Copyright 1999-2018 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!      Intel(R) Math Kernel Library (Intel(R) MKL) interface for LAPACK routines
!******************************************************************************/

#ifndef _MKL_LAPACK_H_
#define _MKL_LAPACK_H_

#include "mkl_types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* LAPACK specific types */

typedef MKL_INT (*MKL_C_SELECT_FUNCTION_1) ( const MKL_Complex8* );
typedef MKL_INT (*MKL_C_SELECT_FUNCTION_2) ( const MKL_Complex8*, const MKL_Complex8* );
typedef MKL_INT (*MKL_D_SELECT_FUNCTION_2) ( const double*, const double* );
typedef MKL_INT (*MKL_D_SELECT_FUNCTION_3) ( const double*, const double*, const double* );
typedef MKL_INT (*MKL_S_SELECT_FUNCTION_2) ( const float*, const float* );
typedef MKL_INT (*MKL_S_SELECT_FUNCTION_3) ( const float*, const float*, const float* );
typedef MKL_INT (*MKL_Z_SELECT_FUNCTION_1) ( const MKL_Complex16* );
typedef MKL_INT (*MKL_Z_SELECT_FUNCTION_2) ( const MKL_Complex16*, const MKL_Complex16* );

#if defined(_WIN32) && defined(MKL_STDCALL) && !defined(__MIC__) && !defined(__TARGET_ARCH_MIC)
#include "mkl_lapack_stdcall.h"
#else

void CGELQ( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
            MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CGELQ_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cgelq( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
            MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cgelq_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CGELQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void CGELQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void cgelqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void cgelqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );

void CGELQT3( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_INT* info );
void CGELQT3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt,
               MKL_INT* info );
void cgelqt3( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_INT* info );
void cgelqt3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* ldt,
               MKL_INT* info );

void CGEMLQ( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* t,
             const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CGEMLQ_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* t,
              const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cgemlq( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* t,
             const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cgemlq_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* t,
              const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CGEMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const MKL_Complex8* v, const MKL_INT* ldv, const MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info );
void CGEMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
               const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );
void cgemlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const MKL_Complex8* v, const MKL_INT* ldv, const MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info );
void cgemlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
               const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );

void CGEQR( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
            MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CGEQR_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cgeqr( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
            MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cgeqr_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* t, const MKL_INT* tsize,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CGETSLS( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void CGETSLS_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );
void cgetsls( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void cgetsls_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );

void CLAMSWLQ( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
               const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info );
void CLAMSWLQ_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
                const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
                MKL_INT* info );
void clamswlq( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
               const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info );
void clamswlq_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
                const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
                MKL_INT* info );

void CLAMTSQR( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
               const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info );
void CLAMTSQR_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
                const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
                MKL_INT* info );
void clamtsqr( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
               const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info );
void clamtsqr_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
                const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
                MKL_INT* info );

void CLASWLQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void CLASWLQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );
void claswlq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void claswlq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );

void CLATSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void CLATSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );
void clatsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void clatsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );

void CTPLQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void CTPLQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void ctplqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );
void ctplqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* work, MKL_INT* info );

void CTPLQT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_INT* info );
void CTPLQT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* t, const MKL_INT* ldt,
               MKL_INT* info );
void ctplqt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_INT* info );
void ctplqt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* t, const MKL_INT* ldt,
               MKL_INT* info );

void CTPMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* work, MKL_INT* info );
void CTPMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, MKL_INT* info );
void ctpmlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* work, MKL_INT* info );
void ctpmlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, MKL_INT* info );

void DGELQ( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
            double* t, const MKL_INT* tsize, double* work,
            const MKL_INT* lwork, MKL_INT* info );
void DGELQ_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* t, const MKL_INT* tsize, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void dgelq( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
            double* t, const MKL_INT* tsize, double* work,
            const MKL_INT* lwork, MKL_INT* info );
void dgelq_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* t, const MKL_INT* tsize, double* work,
             const MKL_INT* lwork, MKL_INT* info );

void DGELQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, double* a,
             const MKL_INT* lda, double* t, const MKL_INT* ldt, double* work,
             MKL_INT* info );
void DGELQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, double* a,
              const MKL_INT* lda, double* t, const MKL_INT* ldt, double* work,
              MKL_INT* info );
void dgelqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, double* a,
             const MKL_INT* lda, double* t, const MKL_INT* ldt, double* work,
             MKL_INT* info );
void dgelqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, double* a,
              const MKL_INT* lda, double* t, const MKL_INT* ldt, double* work,
              MKL_INT* info );

void DGELQT3( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* t, const MKL_INT* ldt,
              MKL_INT* info );
void DGELQT3_( const MKL_INT* m, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* t, const MKL_INT* ldt,
               MKL_INT* info );
void dgelqt3( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* t, const MKL_INT* ldt,
              MKL_INT* info );
void dgelqt3_( const MKL_INT* m, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* t, const MKL_INT* ldt,
               MKL_INT* info );

void DGEMLQ( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* lda,
             const double* t, const MKL_INT* tsize, double* c,
             const MKL_INT* ldc, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void DGEMLQ_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const double* a,
              const MKL_INT* lda, const double* t, const MKL_INT* tsize,
              double* c, const MKL_INT* ldc, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dgemlq( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const double* a, const MKL_INT* lda,
             const double* t, const MKL_INT* tsize, double* c,
             const MKL_INT* ldc, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void dgemlq_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const double* a,
              const MKL_INT* lda, const double* t, const MKL_INT* tsize,
              double* c, const MKL_INT* ldc, double* work,
              const MKL_INT* lwork, MKL_INT* info );

void DGEMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const double* v, const MKL_INT* ldv, const double* t,
              const MKL_INT* ldt, double* c, const MKL_INT* ldc, double* work,
              MKL_INT* info );
void DGEMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const double* v, const MKL_INT* ldv, const double* t,
               const MKL_INT* ldt, double* c, const MKL_INT* ldc, double* work,
               MKL_INT* info );
void dgemlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const double* v, const MKL_INT* ldv, const double* t,
              const MKL_INT* ldt, double* c, const MKL_INT* ldc, double* work,
              MKL_INT* info );
void dgemlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const double* v, const MKL_INT* ldv, const double* t,
               const MKL_INT* ldt, double* c, const MKL_INT* ldc, double* work,
               MKL_INT* info );

void DGEQR( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
            double* t, const MKL_INT* tsize, double* work,
            const MKL_INT* lwork, MKL_INT* info );
void DGEQR_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* t, const MKL_INT* tsize, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void dgeqr( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
            double* t, const MKL_INT* tsize, double* work,
            const MKL_INT* lwork, MKL_INT* info );
void dgeqr_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* t, const MKL_INT* tsize, double* work,
             const MKL_INT* lwork, MKL_INT* info );

void DLAMSWLQ( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda,
               const double* t, const MKL_INT* ldt, double* c,
               const MKL_INT* ldc, double* work, const MKL_INT* lwork,
               MKL_INT* info );
void DLAMSWLQ_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, double* a, const MKL_INT* lda,
                const double* t, const MKL_INT* ldt, double* c,
                const MKL_INT* ldc, double* work, const MKL_INT* lwork,
                MKL_INT* info );
void dlamswlq( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda,
               const double* t, const MKL_INT* ldt, double* c,
               const MKL_INT* ldc, double* work, const MKL_INT* lwork,
               MKL_INT* info );
void dlamswlq_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, double* a, const MKL_INT* lda,
                const double* t, const MKL_INT* ldt, double* c,
                const MKL_INT* ldc, double* work, const MKL_INT* lwork,
                MKL_INT* info );

void DLAMTSQR( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda,
               const double* t, const MKL_INT* ldt, double* c,
               const MKL_INT* ldc, double* work, const MKL_INT* lwork,
               MKL_INT* info );
void DLAMTSQR_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, double* a, const MKL_INT* lda,
                const double* t, const MKL_INT* ldt, double* c,
                const MKL_INT* ldc, double* work, const MKL_INT* lwork,
                MKL_INT* info );
void dlamtsqr( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda,
               const double* t, const MKL_INT* ldt, double* c,
               const MKL_INT* ldc, double* work, const MKL_INT* lwork,
               MKL_INT* info );
void dlamtsqr_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, double* a, const MKL_INT* lda,
                const double* t, const MKL_INT* ldt, double* c,
                const MKL_INT* ldc, double* work, const MKL_INT* lwork,
                MKL_INT* info );

void DLASWLQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
              const MKL_INT* ldt, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void DLASWLQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
               const MKL_INT* ldt, double* work, const MKL_INT* lwork,
               MKL_INT* info );
void dlaswlq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
              const MKL_INT* ldt, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void dlaswlq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
               const MKL_INT* ldt, double* work, const MKL_INT* lwork,
               MKL_INT* info );

void DLATSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
              const MKL_INT* ldt, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void DLATSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
               const MKL_INT* ldt, double* work, const MKL_INT* lwork,
               MKL_INT* info );
void dlatsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
              const MKL_INT* ldt, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void dlatsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, double* a, const MKL_INT* lda, double* t,
               const MKL_INT* ldt, double* work, const MKL_INT* lwork,
               MKL_INT* info );

void DTPLQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, double* t, const MKL_INT* ldt, double* work,
             MKL_INT* info );
void DTPLQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, double* t, const MKL_INT* ldt, double* work,
              MKL_INT* info );
void dtplqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, double* t, const MKL_INT* ldt, double* work,
             MKL_INT* info );
void dtplqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, double* t, const MKL_INT* ldt, double* work,
              MKL_INT* info );

void DTPLQT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* t,
              const MKL_INT* ldt, MKL_INT* info );
void DTPLQT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, double* a,
               const MKL_INT* lda, double* b, const MKL_INT* ldb, double* t,
               const MKL_INT* ldt, MKL_INT* info );
void dtplqt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* t,
              const MKL_INT* ldt, MKL_INT* info );
void dtplqt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, double* a,
               const MKL_INT* lda, double* b, const MKL_INT* ldb, double* t,
               const MKL_INT* ldt, MKL_INT* info );

void DTPMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const double* v, const MKL_INT* ldv,
              const double* t, const MKL_INT* ldt, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* work,
              MKL_INT* info );
void DTPMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const double* v, const MKL_INT* ldv,
               const double* t, const MKL_INT* ldt, double* a,
               const MKL_INT* lda, double* b, const MKL_INT* ldb, double* work,
               MKL_INT* info );
void dtpmlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const double* v, const MKL_INT* ldv,
              const double* t, const MKL_INT* ldt, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* work,
              MKL_INT* info );
void dtpmlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const double* v, const MKL_INT* ldv,
               const double* t, const MKL_INT* ldt, double* a,
               const MKL_INT* lda, double* b, const MKL_INT* ldb, double* work,
               MKL_INT* info );

void SGELQ( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
            float* t, const MKL_INT* tsize, float* work,
            const MKL_INT* lwork, MKL_INT* info );
void SGELQ_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
             float* t, const MKL_INT* tsize, float* work,
             const MKL_INT* lwork, MKL_INT* info );
void sgelq( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
            float* t, const MKL_INT* tsize, float* work,
            const MKL_INT* lwork, MKL_INT* info );
void sgelq_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
             float* t, const MKL_INT* tsize, float* work,
             const MKL_INT* lwork, MKL_INT* info );

void DGETSLS( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void DGETSLS_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
               const MKL_INT* ldb, double* work, const MKL_INT* lwork,
               MKL_INT* info );
void dgetsls( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void dgetsls_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
               const MKL_INT* ldb, double* work, const MKL_INT* lwork,
               MKL_INT* info );

void SGELQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, float* a,
             const MKL_INT* lda, float* t, const MKL_INT* ldt, float* work,
             MKL_INT* info );
void SGELQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, float* a,
              const MKL_INT* lda, float* t, const MKL_INT* ldt, float* work,
              MKL_INT* info );
void sgelqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, float* a,
             const MKL_INT* lda, float* t, const MKL_INT* ldt, float* work,
             MKL_INT* info );
void sgelqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb, float* a,
              const MKL_INT* lda, float* t, const MKL_INT* ldt, float* work,
              MKL_INT* info );

void SGELQT3( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
              float* t, const MKL_INT* ldt, MKL_INT* info );
void SGELQT3_( const MKL_INT* m, const MKL_INT* n, float* a,
               const MKL_INT* lda, float* t, const MKL_INT* ldt,
               MKL_INT* info );
void sgelqt3( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
              float* t, const MKL_INT* ldt, MKL_INT* info );
void sgelqt3_( const MKL_INT* m, const MKL_INT* n, float* a,
               const MKL_INT* lda, float* t, const MKL_INT* ldt,
               MKL_INT* info );

void SGEMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const float* v, const MKL_INT* ldv, const float* t,
              const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
              MKL_INT* info );
void SGEMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const float* v, const MKL_INT* ldv, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               MKL_INT* info );
void sgemlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const float* v, const MKL_INT* ldv, const float* t,
              const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
              MKL_INT* info );
void sgemlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const float* v, const MKL_INT* ldv, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               MKL_INT* info );

void SGEQR( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
            float* t, const MKL_INT* tsize, float* work,
            const MKL_INT* lwork, MKL_INT* info );
void SGEQR_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
             float* t, const MKL_INT* tsize, float* work,
             const MKL_INT* lwork, MKL_INT* info );
void sgeqr( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
            float* t, const MKL_INT* tsize, float* work,
            const MKL_INT* lwork, MKL_INT* info );
void sgeqr_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda,
             float* t, const MKL_INT* tsize, float* work,
             const MKL_INT* lwork, MKL_INT* info );

void SGETSLS( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, float* a, const MKL_INT* lda, float* b,
              const MKL_INT* ldb, float* work, const MKL_INT* lwork,
              MKL_INT* info );
void SGETSLS_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, float* a, const MKL_INT* lda, float* b,
               const MKL_INT* ldb, float* work, const MKL_INT* lwork,
               MKL_INT* info );
void sgetsls( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, float* a, const MKL_INT* lda, float* b,
              const MKL_INT* ldb, float* work, const MKL_INT* lwork,
              MKL_INT* info );
void sgetsls_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, float* a, const MKL_INT* lda, float* b,
               const MKL_INT* ldb, float* work, const MKL_INT* lwork,
               MKL_INT* info );

void SLAMTSQR( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               const MKL_INT* lwork, MKL_INT* info );
void SLAMTSQR_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, float* a, const MKL_INT* lda,
                const float* t, const MKL_INT* ldt, float* c,
                const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                MKL_INT* info );
void slamtsqr( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               const MKL_INT* lwork, MKL_INT* info );
void slamtsqr_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, float* a, const MKL_INT* lda,
                const float* t, const MKL_INT* ldt, float* c,
                const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                MKL_INT* info );

void SLASWLQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
              const MKL_INT* ldt, float* work, const MKL_INT* lwork,
              MKL_INT* info );
void SLASWLQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
               const MKL_INT* ldt, float* work, const MKL_INT* lwork,
               MKL_INT* info );
void slaswlq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
              const MKL_INT* ldt, float* work, const MKL_INT* lwork,
              MKL_INT* info );
void slaswlq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
               const MKL_INT* ldt, float* work, const MKL_INT* lwork,
               MKL_INT* info );

void STPLQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, float* a, const MKL_INT* lda, float* b,
             const MKL_INT* ldb, float* t, const MKL_INT* ldt, float* work,
             MKL_INT* info );
void STPLQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, float* a, const MKL_INT* lda, float* b,
              const MKL_INT* ldb, float* t, const MKL_INT* ldt, float* work,
              MKL_INT* info );
void stplqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, float* a, const MKL_INT* lda, float* b,
             const MKL_INT* ldb, float* t, const MKL_INT* ldt, float* work,
             MKL_INT* info );
void stplqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, float* a, const MKL_INT* lda, float* b,
              const MKL_INT* ldb, float* t, const MKL_INT* ldt, float* work,
              MKL_INT* info );

void STPMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const float* v, const MKL_INT* ldv,
              const float* t, const MKL_INT* ldt, float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb, float* work, MKL_INT* info );
void STPMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const float* v, const MKL_INT* ldv,
               const float* t, const MKL_INT* ldt, float* a,
               const MKL_INT* lda, float* b, const MKL_INT* ldb, float* work,
               MKL_INT* info );
void stpmlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const float* v, const MKL_INT* ldv,
              const float* t, const MKL_INT* ldt, float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb, float* work, MKL_INT* info );
void stpmlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const float* v, const MKL_INT* ldv,
               const float* t, const MKL_INT* ldt, float* a,
               const MKL_INT* lda, float* b, const MKL_INT* ldb, float* work,
               MKL_INT* info );

void ZGELQ( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
            const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
            MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZGELQ_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zgelq( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
            const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
            MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zgelq_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void SGEMLQ( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* lda,
             const float* t, const MKL_INT* tsize, float* c,
             const MKL_INT* ldc, float* work, const MKL_INT* lwork,
             MKL_INT* info );
void SGEMLQ_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* lda,
              const float* t, const MKL_INT* tsize, float* c,
              const MKL_INT* ldc, float* work, const MKL_INT* lwork,
              MKL_INT* info );
void sgemlq( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* lda,
             const float* t, const MKL_INT* tsize, float* c,
             const MKL_INT* ldc, float* work, const MKL_INT* lwork,
             MKL_INT* info );
void sgemlq_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const float* a, const MKL_INT* lda,
              const float* t, const MKL_INT* tsize, float* c,
              const MKL_INT* ldc, float* work, const MKL_INT* lwork,
              MKL_INT* info );

void SLAMSWLQ( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               const MKL_INT* lwork, MKL_INT* info );
void SLAMSWLQ_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, float* a, const MKL_INT* lda,
                const float* t, const MKL_INT* ldt, float* c,
                const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                MKL_INT* info );
void slamswlq( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               const MKL_INT* lwork, MKL_INT* info );
void slamswlq_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, float* a, const MKL_INT* lda,
                const float* t, const MKL_INT* ldt, float* c,
                const MKL_INT* ldc, float* work, const MKL_INT* lwork,
                MKL_INT* info );

void SLATSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
              const MKL_INT* ldt, float* work, const MKL_INT* lwork,
              MKL_INT* info );
void SLATSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
               const MKL_INT* ldt, float* work, const MKL_INT* lwork,
               MKL_INT* info );
void slatsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
              const MKL_INT* ldt, float* work, const MKL_INT* lwork,
              MKL_INT* info );
void slatsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, float* a, const MKL_INT* lda, float* t,
               const MKL_INT* ldt, float* work, const MKL_INT* lwork,
               MKL_INT* info );

void STPLQT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, float* a,
              const MKL_INT* lda, float* b, const MKL_INT* ldb, float* t,
              const MKL_INT* ldt, MKL_INT* info );
void STPLQT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, float* a,
               const MKL_INT* lda, float* b, const MKL_INT* ldb, float* t,
               const MKL_INT* ldt, MKL_INT* info );
void stplqt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, float* a,
              const MKL_INT* lda, float* b, const MKL_INT* ldb, float* t,
              const MKL_INT* ldt, MKL_INT* info );
void stplqt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, float* a,
               const MKL_INT* lda, float* b, const MKL_INT* ldb, float* t,
               const MKL_INT* ldt, MKL_INT* info );

void ZGELQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
             MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t,
             const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info );
void ZGELQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t,
              const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info );
void zgelqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
             MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t,
             const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info );
void zgelqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* t,
              const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info );

void ZGELQT3( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt,
              MKL_INT* info );
void ZGELQT3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt,
               MKL_INT* info );
void zgelqt3( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt,
              MKL_INT* info );
void zgelqt3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* ldt,
               MKL_INT* info );

void ZGEMLQ( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
             const MKL_INT* lda, const MKL_Complex16* t,
             const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZGEMLQ_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
              const MKL_INT* lda, const MKL_Complex16* t,
              const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zgemlq( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
             const MKL_INT* lda, const MKL_Complex16* t,
             const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zgemlq_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
              const MKL_INT* lda, const MKL_Complex16* t,
              const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void ZGEMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
              const MKL_INT* ldc, MKL_Complex16* work, MKL_INT* info );
void ZGEMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
               const MKL_INT* ldc, MKL_Complex16* work, MKL_INT* info );
void zgemlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
              const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
              const MKL_INT* ldc, MKL_Complex16* work, MKL_INT* info );
void zgemlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
               const MKL_INT* ldc, MKL_Complex16* work, MKL_INT* info );

void ZGEQR( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
            const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
            MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZGEQR_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zgeqr( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
            const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
            MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zgeqr_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* t, const MKL_INT* tsize,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void ZGETSLS( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info );
void ZGETSLS_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );
void zgetsls( const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info );
void zgetsls_( const char* trans, const MKL_INT* m, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );

void ZLAMSWLQ( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
               const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info );
void ZLAMSWLQ_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
                const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info );
void zlamswlq( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
               const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info );
void zlamswlq_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
                const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info );

void ZLAMTSQR( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
               const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info );
void ZLAMTSQR_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
                const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info );
void zlamtsqr( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
               const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info );
void zlamtsqr_( const char* side, const char* trans, const MKL_INT* m,
                const MKL_INT* n, const MKL_INT* k, const MKL_INT* mb,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* c,
                const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info );

void ZLASWLQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info );
void ZLASWLQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );
void zlaswlq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info );
void zlaswlq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );

void ZLATSQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info );
void ZLATSQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );
void zlatsqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
              const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info );
void zlatsqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* mb,
               const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );

void ZTPLQT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, MKL_Complex16* a, const MKL_INT* lda,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* t,
             const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info );
void ZTPLQT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* t,
              const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info );
void ztplqt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             const MKL_INT* mb, MKL_Complex16* a, const MKL_INT* lda,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* t,
             const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info );
void ztplqt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              const MKL_INT* mb, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* t,
              const MKL_INT* ldt, MKL_Complex16* work, MKL_INT* info );

void ZTPLQT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
              const MKL_INT* ldb, MKL_Complex16* t, const MKL_INT* ldt,
              MKL_INT* info );
void ZTPLQT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
               const MKL_INT* ldb, MKL_Complex16* t, const MKL_INT* ldt,
               MKL_INT* info );
void ztplqt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
              const MKL_INT* ldb, MKL_Complex16* t, const MKL_INT* ldt,
              MKL_INT* info );
void ztplqt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
               const MKL_INT* ldb, MKL_Complex16* t, const MKL_INT* ldt,
               MKL_INT* info );

void ZTPMLQT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* work, MKL_INT* info );
void ZTPMLQT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* a,
               const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, MKL_INT* info );
void ztpmlqt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_INT* mb, const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* work, MKL_INT* info );
void ztpmlqt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
               const MKL_INT* mb, const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt, MKL_Complex16* a,
               const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, MKL_INT* info );

void CHESV_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );
void CHESV_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info );
void chesv_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );
void chesv_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info );

void CHETRF_AA( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info );
void CHETRF_AA_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info );
void chetrf_aa( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info );
void chetrf_aa_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info );

void CHETRS_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info );
void CHETRS_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex8* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                 const MKL_Complex8* work, const MKL_INT* lwork,
                 MKL_INT* info );
void chetrs_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info );
void chetrs_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex8* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                 const MKL_Complex8* work, const MKL_INT* lwork,
                 MKL_INT* info );

void CLAHEF_AA( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                MKL_Complex8* work );
void CLAHEF_AA_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                 MKL_Complex8* work );
void clahef_aa( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                MKL_Complex8* work );
void clahef_aa_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                 MKL_Complex8* work );

void DLASYF_AA( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, double* a, const MKL_INT* lda,
                MKL_INT* ipiv, double* h, const MKL_INT* ldh, double* work) ;
void DLASYF_AA_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, double* a, const MKL_INT* lda,
                 MKL_INT* ipiv, double* h, const MKL_INT* ldh, double* work) ;
void dlasyf_aa( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, double* a, const MKL_INT* lda,
                MKL_INT* ipiv, double* h, const MKL_INT* ldh, double* work) ;
void dlasyf_aa_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, double* a, const MKL_INT* lda,
                 MKL_INT* ipiv, double* h, const MKL_INT* ldh, double* work) ;

void DSYSV_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               double* a, const MKL_INT* lda, MKL_INT* ipiv, double* b,
               const MKL_INT* ldb, double* work, const MKL_INT* lwork,
               MKL_INT* info );
void DSYSV_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                double* a, const MKL_INT* lda, MKL_INT* ipiv, double* b,
                const MKL_INT* ldb, double* work, const MKL_INT* lwork,
                MKL_INT* info );
void dsysv_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               double* a, const MKL_INT* lda, MKL_INT* ipiv, double* b,
               const MKL_INT* ldb, double* work, const MKL_INT* lwork,
               MKL_INT* info );
void dsysv_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                double* a, const MKL_INT* lda, MKL_INT* ipiv, double* b,
                const MKL_INT* ldb, double* work, const MKL_INT* lwork,
                MKL_INT* info );

void DSYTRF_AA( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, MKL_INT* ipiv, double* work,
                const MKL_INT* lwork, MKL_INT* info );
void DSYTRF_AA_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, MKL_INT* ipiv, double* work,
                 const MKL_INT* lwork, MKL_INT* info );
void dsytrf_aa( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, MKL_INT* ipiv, double* work,
                const MKL_INT* lwork, MKL_INT* info );
void dsytrf_aa_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, MKL_INT* ipiv, double* work,
                 const MKL_INT* lwork, MKL_INT* info );

void DSYTRS_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                double* b, const MKL_INT* ldb, const double* work,
                const MKL_INT* lwork, MKL_INT* info );
void DSYTRS_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                 double* b, const MKL_INT* ldb, const double* work,
                 const MKL_INT* lwork, MKL_INT* info );
void dsytrs_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                double* b, const MKL_INT* ldb, const double* work,
                const MKL_INT* lwork, MKL_INT* info );
void dsytrs_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                 double* b, const MKL_INT* ldb, const double* work,
                 const MKL_INT* lwork, MKL_INT* info );

void SLASYF_AA( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                float* h, const MKL_INT* ldh, float* work );
void SLASYF_AA_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, float* a, const MKL_INT* lda,
                 MKL_INT* ipiv, float* h, const MKL_INT* ldh, float* work );
void slasyf_aa( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                float* h, const MKL_INT* ldh, float* work );
void slasyf_aa_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, float* a, const MKL_INT* lda,
                 MKL_INT* ipiv, float* h, const MKL_INT* ldh, float* work );

void SSYSV_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               float* a, const MKL_INT* lda, MKL_INT* ipiv, float* b,
               const MKL_INT* ldb, float* work, const MKL_INT* lwork,
               MKL_INT* info );
void SSYSV_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                float* a, const MKL_INT* lda, MKL_INT* ipiv, float* b,
                const MKL_INT* ldb, float* work, const MKL_INT* lwork,
                MKL_INT* info );
void ssysv_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               float* a, const MKL_INT* lda, MKL_INT* ipiv, float* b,
               const MKL_INT* ldb, float* work, const MKL_INT* lwork,
               MKL_INT* info );
void ssysv_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                float* a, const MKL_INT* lda, MKL_INT* ipiv, float* b,
                const MKL_INT* ldb, float* work, const MKL_INT* lwork,
                MKL_INT* info );

void SSYTRF_AA( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, MKL_INT* ipiv, float* work,
                const MKL_INT* lwork, MKL_INT* info );
void SSYTRF_AA_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, MKL_INT* ipiv, float* work,
                 const MKL_INT* lwork, MKL_INT* info );
void ssytrf_aa( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, MKL_INT* ipiv, float* work,
                const MKL_INT* lwork, MKL_INT* info );
void ssytrf_aa_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, MKL_INT* ipiv, float* work,
                 const MKL_INT* lwork, MKL_INT* info );

void SSYTRS_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                float* b, const MKL_INT* ldb, const float* work,
                const MKL_INT* lwork, MKL_INT* info );
void SSYTRS_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                 float* b, const MKL_INT* ldb, const float* work,
                 const MKL_INT* lwork, MKL_INT* info );
void ssytrs_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                float* b, const MKL_INT* ldb, const float* work,
                const MKL_INT* lwork, MKL_INT* info );
void ssytrs_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                 float* b, const MKL_INT* ldb, const float* work,
                 const MKL_INT* lwork, MKL_INT* info );

void ZHESV_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );
void ZHESV_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info );
void zhesv_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );
void zhesv_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info );

void ZHETRF_AA( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info );
void ZHETRF_AA_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info );
void zhetrf_aa( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info );
void zhetrf_aa_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info );

void ZHETRS_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                const MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info );
void ZHETRS_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex16* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                 const MKL_Complex16* work, const MKL_INT* lwork,
                 MKL_INT* info );
void zhetrs_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                const MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info );
void zhetrs_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex16* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                 const MKL_Complex16* work, const MKL_INT* lwork,
                 MKL_INT* info );

void ZLAHEF_AA( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                MKL_Complex16* work );
void ZLAHEF_AA_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                 MKL_Complex16* work );
void zlahef_aa( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                MKL_Complex16* work );
void zlahef_aa_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                 MKL_Complex16* work );

void CGEMQR( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* t,
             const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CGEMQR_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* t,
              const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cgemqr( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* t,
             const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cgemqr_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* t,
              const MKL_INT* tsize, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void DGEMQR( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const double* a,
             const MKL_INT* lda, const double* t, const MKL_INT* tsize,
             double* c, const MKL_INT* ldc, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void DGEMQR_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const double* a,
              const MKL_INT* lda, const double* t, const MKL_INT* tsize,
              double* c, const MKL_INT* ldc, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dgemqr( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const double* a,
             const MKL_INT* lda, const double* t, const MKL_INT* tsize,
             double* c, const MKL_INT* ldc, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void dgemqr_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const double* a,
              const MKL_INT* lda, const double* t, const MKL_INT* tsize,
              double* c, const MKL_INT* ldc, double* work,
              const MKL_INT* lwork, MKL_INT* info );

void SGEMQR( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const float* a,
             const MKL_INT* lda, const float* t, const MKL_INT* tsize,
             float* c, const MKL_INT* ldc, float* work, const MKL_INT* lwork,
             MKL_INT* info );
void SGEMQR_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const float* a,
              const MKL_INT* lda, const float* t, const MKL_INT* tsize,
              float* c, const MKL_INT* ldc, float* work,
              const MKL_INT* lwork, MKL_INT* info );
void sgemqr( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const float* a,
             const MKL_INT* lda, const float* t, const MKL_INT* tsize,
             float* c, const MKL_INT* ldc, float* work, const MKL_INT* lwork,
             MKL_INT* info );
void sgemqr_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const float* a,
              const MKL_INT* lda, const float* t, const MKL_INT* tsize,
              float* c, const MKL_INT* ldc, float* work,
              const MKL_INT* lwork, MKL_INT* info );

void ZGEMQR( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
             const MKL_INT* lda, const MKL_Complex16* t,
             const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZGEMQR_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
              const MKL_INT* lda, const MKL_Complex16* t,
              const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zgemqr( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
             const MKL_INT* lda, const MKL_Complex16* t,
             const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zgemqr_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex16* a,
              const MKL_INT* lda, const MKL_Complex16* t,
              const MKL_INT* tsize, MKL_Complex16* c, const MKL_INT* ldc,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void CHECON_3( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               const float* anorm, float* rcond, MKL_Complex8* work,
               MKL_INT* info );
void CHECON_3_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                const float* anorm, float* rcond, MKL_Complex8* work,
                MKL_INT* info );
void checon_3( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               const float* anorm, float* rcond, MKL_Complex8* work,
               MKL_INT* info );
void checon_3_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                const float* anorm, float* rcond, MKL_Complex8* work,
                MKL_INT* info );

void CHESV_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
               MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CHESV_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void chesv_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
               MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void chesv_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CHETF2_RK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_INT* info );
void CHETF2_RK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_INT* info );
void chetf2_rk( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_INT* info );
void chetf2_rk_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_INT* info );

void CHETRF_RK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CHETRF_RK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void chetrf_rk( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void chetrf_rk_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CHETRI_3( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CHETRI_3_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void chetri_3( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void chetri_3_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CHETRI_3X( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* nb, MKL_INT* info );
void CHETRI_3X_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, const MKL_Complex8* e,
                 const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* nb,
                 MKL_INT* info );
void chetri_3x( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* nb, MKL_INT* info );
void chetri_3x_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, const MKL_Complex8* e,
                 const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* nb,
                 MKL_INT* info );

void CHETRS_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_INT* info );
void CHETRS_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
                const MKL_INT* ldb, MKL_INT* info );
void chetrs_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_INT* info );
void chetrs_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
                const MKL_INT* ldb, MKL_INT* info );

void CLAHEF_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                const MKL_INT* ldw, MKL_INT* info );
void CLAHEF_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                 const MKL_INT* ldw, MKL_INT* info );
void clahef_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                const MKL_INT* ldw, MKL_INT* info );
void clahef_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                 const MKL_INT* ldw, MKL_INT* info );

void CLARFY( const char* uplo, const MKL_INT* n, const MKL_Complex8* v,
             const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work );
void CLARFY_( const char* uplo, const MKL_INT* n, const MKL_Complex8* v,
              const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work );
void clarfy( const char* uplo, const MKL_INT* n, const MKL_Complex8* v,
             const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work );
void clarfy_( const char* uplo, const MKL_INT* n, const MKL_Complex8* v,
              const MKL_INT* incv, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work );

void CLASYF_AA( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                MKL_Complex8* work );
void CLASYF_AA_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                 MKL_Complex8* work );
void clasyf_aa( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                MKL_Complex8* work );
void clasyf_aa_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex8* h, const MKL_INT* ldh,
                 MKL_Complex8* work );

void CLASYF_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                const MKL_INT* ldw, MKL_INT* info );
void CLASYF_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                 const MKL_INT* ldw, MKL_INT* info );
void clasyf_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                const MKL_INT* ldw, MKL_INT* info );
void clasyf_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda,
                 MKL_Complex8* e, MKL_INT* ipiv, MKL_Complex8* w,
                 const MKL_INT* ldw, MKL_INT* info );

void CSYCON_3( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               const float* anorm, float* rcond, MKL_Complex8* work,
               MKL_INT* info );
void CSYCON_3_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                const float* anorm, float* rcond, MKL_Complex8* work,
                MKL_INT* info );
void csycon_3( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               const float* anorm, float* rcond, MKL_Complex8* work,
               MKL_INT* info );
void csycon_3_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                const float* anorm, float* rcond, MKL_Complex8* work,
                MKL_INT* info );

void CSYCONVF( const char* uplo, const char* way, const MKL_INT* n,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
               MKL_INT* ipiv, MKL_INT* info );
void CSYCONVF_( const char* uplo, const char* way, const MKL_INT* n,
                MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                MKL_INT* ipiv, MKL_INT* info );
void csyconvf( const char* uplo, const char* way, const MKL_INT* n,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
               MKL_INT* ipiv, MKL_INT* info );
void csyconvf_( const char* uplo, const char* way, const MKL_INT* n,
                MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                MKL_INT* ipiv, MKL_INT* info );

void CSYCONVF_ROOK( const char* uplo, const char* way, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                    const MKL_INT* ipiv, MKL_INT* info );
void CSYCONVF_ROOK_( const char* uplo, const char* way, const MKL_INT* n,
                     MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                     const MKL_INT* ipiv, MKL_INT* info );
void csyconvf_rook( const char* uplo, const char* way, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                    const MKL_INT* ipiv, MKL_INT* info );
void csyconvf_rook_( const char* uplo, const char* way, const MKL_INT* n,
                     MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                     const MKL_INT* ipiv, MKL_INT* info );

void CSYSV_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );
void CSYSV_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info );
void csysv_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );
void csysv_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info );

void CSYSV_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
               MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CSYSV_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void csysv_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
               MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void csysv_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* e,
                MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CSYTF2_RK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_INT* info );
void CSYTF2_RK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_INT* info );
void csytf2_rk( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_INT* info );
void csytf2_rk_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_INT* info );

void CSYTRF_AA( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info );
void CSYTRF_AA_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info );
void csytrf_aa( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info );
void csytrf_aa_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info );

void CSYTRF_RK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CSYTRF_RK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void csytrf_rk( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void csytrf_rk_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, MKL_Complex8* e, MKL_INT* ipiv,
                 MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CSYTRI_3( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CSYTRI_3_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void csytri_3( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void csytri_3_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CSYTRI_3X( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* nb, MKL_INT* info );
void CSYTRI_3X_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, const MKL_Complex8* e,
                 const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* nb,
                 MKL_INT* info );
void csytri_3x( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_Complex8* e, const MKL_INT* ipiv,
                MKL_Complex8* work, const MKL_INT* nb, MKL_INT* info );
void csytri_3x_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                 const MKL_INT* lda, const MKL_Complex8* e,
                 const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* nb,
                 MKL_INT* info );

void CSYTRS_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_INT* info );
void CSYTRS_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
                const MKL_INT* ldb, MKL_INT* info );
void csytrs_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_INT* info );
void csytrs_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda,
                const MKL_Complex8* e, const MKL_INT* ipiv, MKL_Complex8* b,
                const MKL_INT* ldb, MKL_INT* info );

void CSYTRS_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info );
void CSYTRS_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex8* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                 const MKL_Complex8* work, const MKL_INT* lwork,
                 MKL_INT* info );
void csytrs_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* work,
                const MKL_INT* lwork, MKL_INT* info );
void csytrs_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex8* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
                 const MKL_Complex8* work, const MKL_INT* lwork,
                 MKL_INT* info );

void DLARFY( const char* uplo, const MKL_INT* n, const double* v,
             const MKL_INT* incv, const double* tau, double* c,
             const MKL_INT* ldc, double* work );
void DLARFY_( const char* uplo, const MKL_INT* n, const double* v,
              const MKL_INT* incv, const double* tau, double* c,
              const MKL_INT* ldc, double* work );
void dlarfy( const char* uplo, const MKL_INT* n, const double* v,
             const MKL_INT* incv, const double* tau, double* c,
             const MKL_INT* ldc, double* work );
void dlarfy_( const char* uplo, const MKL_INT* n, const double* v,
              const MKL_INT* incv, const double* tau, double* c,
              const MKL_INT* ldc, double* work );

void DLASYF_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, double* a, const MKL_INT* lda, double* e,
                MKL_INT* ipiv, double* w, const MKL_INT* ldw, MKL_INT* info );
void DLASYF_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, double* a, const MKL_INT* lda, double* e,
                 MKL_INT* ipiv, double* w, const MKL_INT* ldw, MKL_INT* info );
void dlasyf_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, double* a, const MKL_INT* lda, double* e,
                MKL_INT* ipiv, double* w, const MKL_INT* ldw, MKL_INT* info );
void dlasyf_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, double* a, const MKL_INT* lda, double* e,
                 MKL_INT* ipiv, double* w, const MKL_INT* ldw, MKL_INT* info );

void DSYCON_3( const char* uplo, const MKL_INT* n, const double* a,
               const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
               const double* anorm, double* rcond, double* work,
               MKL_INT* iwork, MKL_INT* info );
void DSYCON_3_( const char* uplo, const MKL_INT* n, const double* a,
                const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                const double* anorm, double* rcond, double* work,
                MKL_INT* iwork, MKL_INT* info );
void dsycon_3( const char* uplo, const MKL_INT* n, const double* a,
               const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
               const double* anorm, double* rcond, double* work,
               MKL_INT* iwork, MKL_INT* info );
void dsycon_3_( const char* uplo, const MKL_INT* n, const double* a,
                const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                const double* anorm, double* rcond, double* work,
                MKL_INT* iwork, MKL_INT* info );

void DSYCONVF( const char* uplo, const char* way, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info );
void DSYCONVF_( const char* uplo, const char* way, const MKL_INT* n, double* a,
                const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info );
void dsyconvf( const char* uplo, const char* way, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info );
void dsyconvf_( const char* uplo, const char* way, const MKL_INT* n, double* a,
                const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info );

void DSYCONVF_ROOK( const char* uplo, const char* way, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* e,
                    const MKL_INT* ipiv, MKL_INT* info );
void DSYCONVF_ROOK_( const char* uplo, const char* way, const MKL_INT* n,
                     double* a, const MKL_INT* lda, double* e,
                     const MKL_INT* ipiv, MKL_INT* info );
void dsyconvf_rook( const char* uplo, const char* way, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* e,
                    const MKL_INT* ipiv, MKL_INT* info );
void dsyconvf_rook_( const char* uplo, const char* way, const MKL_INT* n,
                     double* a, const MKL_INT* lda, double* e,
                     const MKL_INT* ipiv, MKL_INT* info );

void DSYSV_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               double* a, const MKL_INT* lda, double* e, MKL_INT* ipiv,
               double* b, const MKL_INT* ldb, double* work,
               const MKL_INT* lwork, MKL_INT* info );
void DSYSV_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                double* a, const MKL_INT* lda, double* e, MKL_INT* ipiv,
                double* b, const MKL_INT* ldb, double* work,
                const MKL_INT* lwork, MKL_INT* info );
void dsysv_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               double* a, const MKL_INT* lda, double* e, MKL_INT* ipiv,
               double* b, const MKL_INT* ldb, double* work,
               const MKL_INT* lwork, MKL_INT* info );
void dsysv_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                double* a, const MKL_INT* lda, double* e, MKL_INT* ipiv,
                double* b, const MKL_INT* ldb, double* work,
                const MKL_INT* lwork, MKL_INT* info );

void DSYTF2_RK( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info );
void DSYTF2_RK_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info );
void dsytf2_rk( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info );
void dsytf2_rk_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, double* e, MKL_INT* ipiv, MKL_INT* info );

void DSYTRF_RK( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, double* e, MKL_INT* ipiv, double* work,
                const MKL_INT* lwork, MKL_INT* info );
void DSYTRF_RK_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, double* e, MKL_INT* ipiv, double* work,
                 const MKL_INT* lwork, MKL_INT* info );
void dsytrf_rk( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, double* e, MKL_INT* ipiv, double* work,
                const MKL_INT* lwork, MKL_INT* info );
void dsytrf_rk_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, double* e, MKL_INT* ipiv, double* work,
                 const MKL_INT* lwork, MKL_INT* info );

void DSYTRI_3( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
               double* work, const MKL_INT* lwork, MKL_INT* info );
void DSYTRI_3_( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                double* work, const MKL_INT* lwork, MKL_INT* info );
void dsytri_3( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
               double* work, const MKL_INT* lwork, MKL_INT* info );
void dsytri_3_( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                double* work, const MKL_INT* lwork, MKL_INT* info );

void DSYTRI_3X( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                double* work, const MKL_INT* nb, MKL_INT* info );
void DSYTRI_3X_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                 double* work, const MKL_INT* nb, MKL_INT* info );
void dsytri_3x( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                double* work, const MKL_INT* nb, MKL_INT* info );
void dsytri_3x_( const char* uplo, const MKL_INT* n, double* a,
                 const MKL_INT* lda, const double* e, const MKL_INT* ipiv,
                 double* work, const MKL_INT* nb, MKL_INT* info );

void DSYTRS_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const double* a, const MKL_INT* lda, const double* e,
               const MKL_INT* ipiv, double* b, const MKL_INT* ldb,
               MKL_INT* info );
void DSYTRS_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const double* a, const MKL_INT* lda, const double* e,
                const MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                MKL_INT* info );
void dsytrs_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const double* a, const MKL_INT* lda, const double* e,
               const MKL_INT* ipiv, double* b, const MKL_INT* ldb,
               MKL_INT* info );
void dsytrs_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const double* a, const MKL_INT* lda, const double* e,
                const MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                MKL_INT* info );

void SLARFY( const char* uplo, const MKL_INT* n, const float* v,
             const MKL_INT* incv, const float* tau, float* c,
             const MKL_INT* ldc, float* work );
void SLARFY_( const char* uplo, const MKL_INT* n, const float* v,
              const MKL_INT* incv, const float* tau, float* c,
              const MKL_INT* ldc, float* work );
void slarfy( const char* uplo, const MKL_INT* n, const float* v,
             const MKL_INT* incv, const float* tau, float* c,
             const MKL_INT* ldc, float* work );
void slarfy_( const char* uplo, const MKL_INT* n, const float* v,
              const MKL_INT* incv, const float* tau, float* c,
              const MKL_INT* ldc, float* work );

void SLASYF_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, float* a, const MKL_INT* lda, float* e,
                MKL_INT* ipiv, float* w, const MKL_INT* ldw, MKL_INT* info );
void SLASYF_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, float* a, const MKL_INT* lda, float* e,
                 MKL_INT* ipiv, float* w, const MKL_INT* ldw, MKL_INT* info );
void slasyf_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, float* a, const MKL_INT* lda, float* e,
                MKL_INT* ipiv, float* w, const MKL_INT* ldw, MKL_INT* info );
void slasyf_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, float* a, const MKL_INT* lda, float* e,
                 MKL_INT* ipiv, float* w, const MKL_INT* ldw, MKL_INT* info );

void SSYCON_3( const char* uplo, const MKL_INT* n, const float* a,
               const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
               const float* anorm, float* rcond, float* work, MKL_INT* iwork,
               MKL_INT* info );
void SSYCON_3_( const char* uplo, const MKL_INT* n, const float* a,
                const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                const float* anorm, float* rcond, float* work, MKL_INT* iwork,
                MKL_INT* info );
void ssycon_3( const char* uplo, const MKL_INT* n, const float* a,
               const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
               const float* anorm, float* rcond, float* work, MKL_INT* iwork,
               MKL_INT* info );
void ssycon_3_( const char* uplo, const MKL_INT* n, const float* a,
                const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                const float* anorm, float* rcond, float* work, MKL_INT* iwork,
                MKL_INT* info );

void SSYCONVF( const char* uplo, const char* way, const MKL_INT* n, float* a,
               const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info );
void SSYCONVF_( const char* uplo, const char* way, const MKL_INT* n, float* a,
                const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info );
void ssyconvf( const char* uplo, const char* way, const MKL_INT* n, float* a,
               const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info );
void ssyconvf_( const char* uplo, const char* way, const MKL_INT* n, float* a,
                const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info );

void SSYCONVF_ROOK( const char* uplo, const char* way, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* e,
                    const MKL_INT* ipiv, MKL_INT* info );
void SSYCONVF_ROOK_( const char* uplo, const char* way, const MKL_INT* n,
                     float* a, const MKL_INT* lda, float* e,
                     const MKL_INT* ipiv, MKL_INT* info );
void ssyconvf_rook( const char* uplo, const char* way, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* e,
                    const MKL_INT* ipiv, MKL_INT* info );
void ssyconvf_rook_( const char* uplo, const char* way, const MKL_INT* n,
                     float* a, const MKL_INT* lda, float* e,
                     const MKL_INT* ipiv, MKL_INT* info );

void SSYSV_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               float* a, const MKL_INT* lda, float* e, MKL_INT* ipiv, float* b,
               const MKL_INT* ldb, float* work, const MKL_INT* lwork,
               MKL_INT* info );
void SSYSV_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                float* a, const MKL_INT* lda, float* e, MKL_INT* ipiv,
                float* b, const MKL_INT* ldb, float* work,
                const MKL_INT* lwork, MKL_INT* info );
void ssysv_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               float* a, const MKL_INT* lda, float* e, MKL_INT* ipiv, float* b,
               const MKL_INT* ldb, float* work, const MKL_INT* lwork,
               MKL_INT* info );
void ssysv_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                float* a, const MKL_INT* lda, float* e, MKL_INT* ipiv,
                float* b, const MKL_INT* ldb, float* work,
                const MKL_INT* lwork, MKL_INT* info );

void SSYTF2_RK( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info );
void SSYTF2_RK_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info );
void ssytf2_rk( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info );
void ssytf2_rk_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, float* e, MKL_INT* ipiv, MKL_INT* info );

void SSYTRF_RK( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, float* e, MKL_INT* ipiv, float* work,
                const MKL_INT* lwork, MKL_INT* info );
void SSYTRF_RK_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, float* e, MKL_INT* ipiv, float* work,
                 const MKL_INT* lwork, MKL_INT* info );
void ssytrf_rk( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, float* e, MKL_INT* ipiv, float* work,
                const MKL_INT* lwork, MKL_INT* info );
void ssytrf_rk_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, float* e, MKL_INT* ipiv, float* work,
                 const MKL_INT* lwork, MKL_INT* info );

void SSYTRI_3( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
               float* work, const MKL_INT* lwork, MKL_INT* info );
void SSYTRI_3_( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                float* work, const MKL_INT* lwork, MKL_INT* info );
void ssytri_3( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
               float* work, const MKL_INT* lwork, MKL_INT* info );
void ssytri_3_( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                float* work, const MKL_INT* lwork, MKL_INT* info );

void SSYTRI_3X( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                float* work, const MKL_INT* nb, MKL_INT* info );
void SSYTRI_3X_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                 float* work, const MKL_INT* nb, MKL_INT* info );
void ssytri_3x( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                float* work, const MKL_INT* nb, MKL_INT* info );
void ssytri_3x_( const char* uplo, const MKL_INT* n, float* a,
                 const MKL_INT* lda, const float* e, const MKL_INT* ipiv,
                 float* work, const MKL_INT* nb, MKL_INT* info );

void SSYTRS_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const float* a, const MKL_INT* lda, const float* e,
               const MKL_INT* ipiv, float* b, const MKL_INT* ldb,
               MKL_INT* info );
void SSYTRS_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const float* a, const MKL_INT* lda, const float* e,
                const MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                MKL_INT* info );
void ssytrs_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const float* a, const MKL_INT* lda, const float* e,
               const MKL_INT* ipiv, float* b, const MKL_INT* ldb,
               MKL_INT* info );
void ssytrs_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const float* a, const MKL_INT* lda, const float* e,
                const MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                MKL_INT* info );

void ZHECON_3( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               const double* anorm, double* rcond, MKL_Complex16* work,
               MKL_INT* info );
void ZHECON_3_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, const double* anorm, double* rcond,
                MKL_Complex16* work, MKL_INT* info );
void zhecon_3( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               const double* anorm, double* rcond, MKL_Complex16* work,
               MKL_INT* info );
void zhecon_3_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, const double* anorm, double* rcond,
                MKL_Complex16* work, MKL_INT* info );

void ZHESV_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
               MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZHESV_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zhesv_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
               MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zhesv_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void ZHETF2_RK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_INT* info );
void ZHETF2_RK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_INT* info );
void zhetf2_rk( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_INT* info );
void zhetf2_rk_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_INT* info );

void ZHETRF_RK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZHETRF_RK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zhetrf_rk( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zhetrf_rk_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void ZHETRI_3( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZHETRI_3_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info );
void zhetri_3( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zhetri_3_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info );

void ZHETRI_3X( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                MKL_INT* info );
void ZHETRI_3X_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, const MKL_Complex16* e,
                 const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                 MKL_INT* info );
void zhetri_3x( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                MKL_INT* info );
void zhetri_3x_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, const MKL_Complex16* e,
                 const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                 MKL_INT* info );

void ZHETRS_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
               const MKL_INT* ldb, MKL_INT* info );
void ZHETRS_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
                const MKL_INT* ldb, MKL_INT* info );
void zhetrs_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
               const MKL_INT* ldb, MKL_INT* info );
void zhetrs_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
                const MKL_INT* ldb, MKL_INT* info );

void ZLAHEF_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                const MKL_INT* ldw, MKL_INT* info );
void ZLAHEF_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                 const MKL_INT* ldw, MKL_INT* info );
void zlahef_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                const MKL_INT* ldw, MKL_INT* info );
void zlahef_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                 const MKL_INT* ldw, MKL_INT* info );

void ZLARFY( const char* uplo, const MKL_INT* n, const MKL_Complex16* v,
             const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c,
             const MKL_INT* ldc, MKL_Complex16* work );
void ZLARFY_( const char* uplo, const MKL_INT* n, const MKL_Complex16* v,
              const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c,
              const MKL_INT* ldc, MKL_Complex16* work );
void zlarfy( const char* uplo, const MKL_INT* n, const MKL_Complex16* v,
             const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c,
             const MKL_INT* ldc, MKL_Complex16* work );
void zlarfy_( const char* uplo, const MKL_INT* n, const MKL_Complex16* v,
              const MKL_INT* incv, const MKL_Complex16* tau, MKL_Complex16* c,
              const MKL_INT* ldc, MKL_Complex16* work );

void ZLASYF_AA( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                MKL_Complex16* work );
void ZLASYF_AA_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                 MKL_Complex16* work );
void zlasyf_aa( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                MKL_Complex16* work );
void zlasyf_aa_( const char* uplo, const MKL_INT* j1, const MKL_INT* m,
                 const MKL_INT* nb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_INT* ipiv, MKL_Complex16* h, const MKL_INT* ldh,
                 MKL_Complex16* work );

void ZLASYF_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                const MKL_INT* ldw, MKL_INT* info );
void ZLASYF_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                 const MKL_INT* ldw, MKL_INT* info );
void zlasyf_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                const MKL_INT* ldw, MKL_INT* info );
void zlasyf_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                 MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda,
                 MKL_Complex16* e, MKL_INT* ipiv, MKL_Complex16* w,
                 const MKL_INT* ldw, MKL_INT* info );

void ZSYCON_3( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               const double* anorm, double* rcond, MKL_Complex16* work,
               MKL_INT* info );
void ZSYCON_3_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, const double* anorm, double* rcond,
                MKL_Complex16* work, MKL_INT* info );
void zsycon_3( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               const double* anorm, double* rcond, MKL_Complex16* work,
               MKL_INT* info );
void zsycon_3_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, const double* anorm, double* rcond,
                MKL_Complex16* work, MKL_INT* info );

void ZSYCONVF( const char* uplo, const char* way, const MKL_INT* n,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
               MKL_INT* ipiv, MKL_INT* info );
void ZSYCONVF_( const char* uplo, const char* way, const MKL_INT* n,
                MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                MKL_INT* ipiv, MKL_INT* info );
void zsyconvf( const char* uplo, const char* way, const MKL_INT* n,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
               MKL_INT* ipiv, MKL_INT* info );
void zsyconvf_( const char* uplo, const char* way, const MKL_INT* n,
                MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                MKL_INT* ipiv, MKL_INT* info );

void ZSYCONVF_ROOK( const char* uplo, const char* way, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                    const MKL_INT* ipiv, MKL_INT* info );
void ZSYCONVF_ROOK_( const char* uplo, const char* way, const MKL_INT* n,
                     MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                     const MKL_INT* ipiv, MKL_INT* info );
void zsyconvf_rook( const char* uplo, const char* way, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                    const MKL_INT* ipiv, MKL_INT* info );
void zsyconvf_rook_( const char* uplo, const char* way, const MKL_INT* n,
                     MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                     const MKL_INT* ipiv, MKL_INT* info );

void ZSYSV_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );
void ZSYSV_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info );
void zsysv_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );
void zsysv_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info );

void ZSYSV_RK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
               MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZSYSV_RK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zsysv_rk( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
               MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zsysv_rk_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* e,
                MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void ZSYTF2_RK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_INT* info );
void ZSYTF2_RK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_INT* info );
void zsytf2_rk( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_INT* info );
void zsytf2_rk_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_INT* info );

void ZSYTRF_AA( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info );
void ZSYTRF_AA_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info );
void zsytrf_aa( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                const MKL_INT* lwork, MKL_INT* info );
void zsytrf_aa_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info );

void ZSYTRF_RK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZSYTRF_RK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zsytrf_rk( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zsytrf_rk_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, MKL_Complex16* e, MKL_INT* ipiv,
                 MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void ZSYTRI_3( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZSYTRI_3_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info );
void zsytri_3( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_Complex16* e, const MKL_INT* ipiv,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zsytri_3_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info );

void ZSYTRI_3X( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                MKL_INT* info );
void ZSYTRI_3X_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, const MKL_Complex16* e,
                 const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                 MKL_INT* info );
void zsytri_3x( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_Complex16* e,
                const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                MKL_INT* info );
void zsytri_3x_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                 const MKL_INT* lda, const MKL_Complex16* e,
                 const MKL_INT* ipiv, MKL_Complex16* work, const MKL_INT* nb,
                 MKL_INT* info );

void ZSYTRS_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
               const MKL_INT* ldb, MKL_INT* info );
void ZSYTRS_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
                const MKL_INT* ldb, MKL_INT* info );
void zsytrs_3( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex16* a, const MKL_INT* lda,
               const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
               const MKL_INT* ldb, MKL_INT* info );
void zsytrs_3_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_Complex16* e, const MKL_INT* ipiv, MKL_Complex16* b,
                const MKL_INT* ldb, MKL_INT* info );

void ZSYTRS_AA( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                const MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info );
void ZSYTRS_AA_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex16* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                 const MKL_Complex16* work, const MKL_INT* lwork,
                 MKL_INT* info );
void zsytrs_aa( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                const MKL_Complex16* a, const MKL_INT* lda,
                const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                const MKL_Complex16* work, const MKL_INT* lwork,
                MKL_INT* info );
void zsytrs_aa_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 const MKL_Complex16* a, const MKL_INT* lda,
                 const MKL_INT* ipiv, MKL_Complex16* b, const MKL_INT* ldb,
                 const MKL_Complex16* work, const MKL_INT* lwork,
                 MKL_INT* info );

void CHB2ST_KERNELS( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, MKL_Complex8* a,
                     const MKL_INT* lda, MKL_Complex8* v, MKL_Complex8* tau,
                     const MKL_INT* ldvt, const MKL_Complex8* work );
void CHB2ST_KERNELS_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* v,
                      MKL_Complex8* tau, const MKL_INT* ldvt,
                      const MKL_Complex8* work );
void chb2st_kernels( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, MKL_Complex8* a,
                     const MKL_INT* lda, MKL_Complex8* v, MKL_Complex8* tau,
                     const MKL_INT* ldvt, const MKL_Complex8* work );
void chb2st_kernels_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* v,
                      MKL_Complex8* tau, const MKL_INT* ldvt,
                      const MKL_Complex8* work );

void CHBEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                   float* w, MKL_Complex8* z, const MKL_INT* ldz,
                   MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                   MKL_INT* info );
void CHBEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* info );
void chbev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                   float* w, MKL_Complex8* z, const MKL_INT* ldz,
                   MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                   MKL_INT* info );
void chbev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* info );

void CHBEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void CHBEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );
void chbevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void chbevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );

void CHBEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                    const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void CHBEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                     const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void chbevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                    const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void chbevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                     const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );

void CHEEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   MKL_Complex8* a, const MKL_INT* lda, float* w,
                   MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                   MKL_INT* info );
void CHEEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, float* w,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* info );
void cheev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   MKL_Complex8* a, const MKL_INT* lda, float* w,
                   MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                   MKL_INT* info );
void cheev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, float* w,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* info );

void CHEEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, float* w,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void CHEEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     MKL_Complex8* a, const MKL_INT* lda, float* w,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );
void cheevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, float* w,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void cheevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     MKL_Complex8* a, const MKL_INT* lda, float* w,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );

void CHEEVR_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_INT* isuppz, MKL_Complex8* work, const MKL_INT* lwork,
                    float* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void CHEEVR_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_INT* isuppz, MKL_Complex8* work, const MKL_INT* lwork,
                     float* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );
void cheevr_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_INT* isuppz, MKL_Complex8* work, const MKL_INT* lwork,
                    float* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void cheevr_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_INT* isuppz, MKL_Complex8* work, const MKL_INT* lwork,
                     float* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );

void CHEEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void CHEEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void cheevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, MKL_Complex8* z, const MKL_INT* ldz,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void cheevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, MKL_Complex8* z, const MKL_INT* ldz,
                     MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );

void CHEGV_2STAGE( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                   MKL_Complex8* b, const MKL_INT* ldb, float* w,
                   MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                   MKL_INT* info );
void CHEGV_2STAGE_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    MKL_Complex8* b, const MKL_INT* ldb, float* w,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* info );
void chegv_2stage( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                   MKL_Complex8* b, const MKL_INT* ldb, float* w,
                   MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                   MKL_INT* info );
void chegv_2stage_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    MKL_Complex8* b, const MKL_INT* ldb, float* w,
                    MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
                    MKL_INT* info );

void CHETRD_2STAGE( const char* vect, const char* uplo, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
                    MKL_Complex8* tau, MKL_Complex8* hous2,
                    const MKL_INT* lhous2, MKL_Complex8* work,
                    const MKL_INT* lwork, MKL_INT* info );
void CHETRD_2STAGE_( const char* vect, const char* uplo, const MKL_INT* n,
                     MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
                     MKL_Complex8* tau, MKL_Complex8* hous2,
                     const MKL_INT* lhous2, MKL_Complex8* work,
                     const MKL_INT* lwork, MKL_INT* info );
void chetrd_2stage( const char* vect, const char* uplo, const MKL_INT* n,
                    MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
                    MKL_Complex8* tau, MKL_Complex8* hous2,
                    const MKL_INT* lhous2, MKL_Complex8* work,
                    const MKL_INT* lwork, MKL_INT* info );
void chetrd_2stage_( const char* vect, const char* uplo, const MKL_INT* n,
                     MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
                     MKL_Complex8* tau, MKL_Complex8* hous2,
                     const MKL_INT* lhous2, MKL_Complex8* work,
                     const MKL_INT* lwork, MKL_INT* info );

void CHETRD_HB2ST( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                   const MKL_INT* ldab, float* d, float* e, MKL_Complex8* hous,
                   const MKL_INT* lhous, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info );
void CHETRD_HB2ST_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                    const MKL_INT* ldab, float* d, float* e,
                    MKL_Complex8* hous, const MKL_INT* lhous,
                    MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void chetrd_hb2st( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                   const MKL_INT* ldab, float* d, float* e, MKL_Complex8* hous,
                   const MKL_INT* lhous, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info );
void chetrd_hb2st_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
                    const MKL_INT* ldab, float* d, float* e,
                    MKL_Complex8* hous, const MKL_INT* lhous,
                    MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CHETRD_HE2HB( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* ab,
                   const MKL_INT* ldab, MKL_Complex8* tau, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info );
void CHETRD_HE2HB_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* ab,
                    const MKL_INT* ldab, MKL_Complex8* tau, MKL_Complex8* work,
                    const MKL_INT* lwork, MKL_INT* info );
void chetrd_he2hb( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* ab,
                   const MKL_INT* ldab, MKL_Complex8* tau, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info );
void chetrd_he2hb_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* ab,
                    const MKL_INT* ldab, MKL_Complex8* tau, MKL_Complex8* work,
                    const MKL_INT* lwork, MKL_INT* info );

void DSB2ST_KERNELS( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, double* a,
                     const MKL_INT* lda, double* v, double* tau,
                     const MKL_INT* ldvt, const double* work );
void DSB2ST_KERNELS_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      double* a, const MKL_INT* lda, double* v, double* tau,
                      const MKL_INT* ldvt, const double* work );
void dsb2st_kernels( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, double* a,
                     const MKL_INT* lda, double* v, double* tau,
                     const MKL_INT* ldvt, const double* work );
void dsb2st_kernels_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      double* a, const MKL_INT* lda, double* v, double* tau,
                      const MKL_INT* ldvt, const double* work );

void DSBEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                   double* w, double* z, const MKL_INT* ldz, double* work,
                   const MKL_INT* lwork, MKL_INT* info );
void DSBEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* info );
void dsbev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                   double* w, double* z, const MKL_INT* ldz, double* work,
                   const MKL_INT* lwork, MKL_INT* info );
void dsbev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* info );

void DSBEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void DSBEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                     double* w, double* z, const MKL_INT* ldz, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );
void dsbevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void dsbevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, double* ab, const MKL_INT* ldab,
                     double* w, double* z, const MKL_INT* ldz, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );

void DSBEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, double* ab,
                    const MKL_INT* ldab, double* q, const MKL_INT* ldq,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info );
void DSBEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, double* ab,
                     const MKL_INT* ldab, double* q, const MKL_INT* ldq,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, double* z, const MKL_INT* ldz, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info );
void dsbevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, double* ab,
                    const MKL_INT* ldab, double* q, const MKL_INT* ldq,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info );
void dsbevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, double* ab,
                     const MKL_INT* ldab, double* q, const MKL_INT* ldq,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, double* z, const MKL_INT* ldz, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info );

void DSYEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   double* a, const MKL_INT* lda, double* w, double* work,
                   const MKL_INT* lwork, MKL_INT* info );
void DSYEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* w, double* work,
                    const MKL_INT* lwork, MKL_INT* info );
void dsyev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   double* a, const MKL_INT* lda, double* w, double* work,
                   const MKL_INT* lwork, MKL_INT* info );
void dsyev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* w, double* work,
                    const MKL_INT* lwork, MKL_INT* info );

void DSYEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* w, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void DSYEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     double* a, const MKL_INT* lda, double* w, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );
void dsyevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* w, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void dsyevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     double* a, const MKL_INT* lda, double* w, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );

void DSYEVR_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, double* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, double* z, const MKL_INT* ldz, MKL_INT* isuppz,
                    double* work, const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void DSYEVR_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, double* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, double* z, const MKL_INT* ldz, MKL_INT* isuppz,
                     double* work, const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );
void dsyevr_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, double* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, double* z, const MKL_INT* ldz, MKL_INT* isuppz,
                    double* work, const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void dsyevr_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, double* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, double* z, const MKL_INT* ldz, MKL_INT* isuppz,
                     double* work, const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );

void DSYEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, double* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info );
void DSYEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, double* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, double* z, const MKL_INT* ldz, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info );
void dsyevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, double* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, double* z, const MKL_INT* ldz, double* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info );
void dsyevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, double* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, double* z, const MKL_INT* ldz, double* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info );

void DSYGV_2STAGE( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                   const MKL_INT* ldb, double* w, double* work,
                   const MKL_INT* lwork, MKL_INT* info );
void DSYGV_2STAGE_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                    const MKL_INT* ldb, double* w, double* work,
                    const MKL_INT* lwork, MKL_INT* info );
void dsygv_2stage( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                   const MKL_INT* ldb, double* w, double* work,
                   const MKL_INT* lwork, MKL_INT* info );
void dsygv_2stage_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
                    const MKL_INT* ldb, double* w, double* work,
                    const MKL_INT* lwork, MKL_INT* info );

void DSYTRD_2STAGE( const char* vect, const char* uplo, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* d, double* e,
                    double* tau, double* hous2, const MKL_INT* lhous2,
                    double* work, const MKL_INT* lwork, MKL_INT* info );
void DSYTRD_2STAGE_( const char* vect, const char* uplo, const MKL_INT* n,
                     double* a, const MKL_INT* lda, double* d, double* e,
                     double* tau, double* hous2, const MKL_INT* lhous2,
                     double* work, const MKL_INT* lwork, MKL_INT* info );
void dsytrd_2stage( const char* vect, const char* uplo, const MKL_INT* n,
                    double* a, const MKL_INT* lda, double* d, double* e,
                    double* tau, double* hous2, const MKL_INT* lhous2,
                    double* work, const MKL_INT* lwork, MKL_INT* info );
void dsytrd_2stage_( const char* vect, const char* uplo, const MKL_INT* n,
                     double* a, const MKL_INT* lda, double* d, double* e,
                     double* tau, double* hous2, const MKL_INT* lhous2,
                     double* work, const MKL_INT* lwork, MKL_INT* info );

void DSYTRD_SB2ST( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, double* ab,
                   const MKL_INT* ldab, double* d, double* e, double* hous,
                   const MKL_INT* lhous, double* work, const MKL_INT* lwork,
                   MKL_INT* info );
void DSYTRD_SB2ST_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, double* ab,
                    const MKL_INT* ldab, double* d, double* e, double* hous,
                    const MKL_INT* lhous, double* work, const MKL_INT* lwork,
                    MKL_INT* info );
void dsytrd_sb2st( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, double* ab,
                   const MKL_INT* ldab, double* d, double* e, double* hous,
                   const MKL_INT* lhous, double* work, const MKL_INT* lwork,
                   MKL_INT* info );
void dsytrd_sb2st_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, double* ab,
                    const MKL_INT* ldab, double* d, double* e, double* hous,
                    const MKL_INT* lhous, double* work, const MKL_INT* lwork,
                    MKL_INT* info );

void DSYTRD_SY2SB( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   double* a, const MKL_INT* lda, double* ab,
                   const MKL_INT* ldab, double* tau, double* work,
                   const MKL_INT* lwork, MKL_INT* info );
void DSYTRD_SY2SB_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    double* a, const MKL_INT* lda, double* ab,
                    const MKL_INT* ldab, double* tau, double* work,
                    const MKL_INT* lwork, MKL_INT* info );
void dsytrd_sy2sb( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   double* a, const MKL_INT* lda, double* ab,
                   const MKL_INT* ldab, double* tau, double* work,
                   const MKL_INT* lwork, MKL_INT* info );
void dsytrd_sy2sb_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    double* a, const MKL_INT* lda, double* ab,
                    const MKL_INT* ldab, double* tau, double* work,
                    const MKL_INT* lwork, MKL_INT* info );

MKL_INT IPARAM2STAGE( const MKL_INT* ispec, const char* name, const char* opts,
                      const MKL_INT* ni, const MKL_INT* nbi,
                      const MKL_INT* ibi, const MKL_INT* nxi );
MKL_INT IPARAM2STAGE_( const MKL_INT* ispec, const char* name,
                       const char* opts, const MKL_INT* ni, const MKL_INT* nbi,
                       const MKL_INT* ibi, const MKL_INT* nxi );
MKL_INT iparam2stage( const MKL_INT* ispec, const char* name, const char* opts,
                      const MKL_INT* ni, const MKL_INT* nbi,
                      const MKL_INT* ibi, const MKL_INT* nxi );
MKL_INT iparam2stage_( const MKL_INT* ispec, const char* name,
                       const char* opts, const MKL_INT* ni, const MKL_INT* nbi,
                       const MKL_INT* ibi, const MKL_INT* nxi );

void SSB2ST_KERNELS( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, float* a,
                     const MKL_INT* lda, float* v, float* tau,
                     const MKL_INT* ldvt, const float* work );
void SSB2ST_KERNELS_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      float* a, const MKL_INT* lda, float* v, float* tau,
                      const MKL_INT* ldvt, const float* work );
void ssb2st_kernels( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, float* a,
                     const MKL_INT* lda, float* v, float* tau,
                     const MKL_INT* ldvt, const float* work );
void ssb2st_kernels_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      float* a, const MKL_INT* lda, float* v, float* tau,
                      const MKL_INT* ldvt, const float* work );

void SSBEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, float* ab, const MKL_INT* ldab, float* w,
                   float* z, const MKL_INT* ldz, float* work,
                   const MKL_INT* lwork, MKL_INT* info );
void SSBEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, float* ab, const MKL_INT* ldab,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* info );
void ssbev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, float* ab, const MKL_INT* ldab, float* w,
                   float* z, const MKL_INT* ldz, float* work,
                   const MKL_INT* lwork, MKL_INT* info );
void ssbev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, float* ab, const MKL_INT* ldab,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* info );

void SSBEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, float* ab, const MKL_INT* ldab,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void SSBEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, float* ab, const MKL_INT* ldab,
                     float* w, float* z, const MKL_INT* ldz, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );
void ssbevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, float* ab, const MKL_INT* ldab,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void ssbevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, float* ab, const MKL_INT* ldab,
                     float* w, float* z, const MKL_INT* ldz, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );

void SSBEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, float* ab,
                    const MKL_INT* ldab, float* q, const MKL_INT* ldq,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info );
void SSBEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, float* ab,
                     const MKL_INT* ldab, float* q, const MKL_INT* ldq,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, float* z, const MKL_INT* ldz, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info );
void ssbevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, float* ab,
                    const MKL_INT* ldab, float* q, const MKL_INT* ldq,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info );
void ssbevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, float* ab,
                     const MKL_INT* ldab, float* q, const MKL_INT* ldq,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, float* z, const MKL_INT* ldz, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info );

void SSYEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   float* a, const MKL_INT* lda, float* w, float* work,
                   const MKL_INT* lwork, MKL_INT* info );
void SSYEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* w, float* work,
                    const MKL_INT* lwork, MKL_INT* info );
void ssyev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   float* a, const MKL_INT* lda, float* w, float* work,
                   const MKL_INT* lwork, MKL_INT* info );
void ssyev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* w, float* work,
                    const MKL_INT* lwork, MKL_INT* info );

void SSYEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* w, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void SSYEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     float* a, const MKL_INT* lda, float* w, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );
void ssyevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* w, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void ssyevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     float* a, const MKL_INT* lda, float* w, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );

void SSYEVR_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, float* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, float* z, const MKL_INT* ldz, MKL_INT* isuppz,
                    float* work, const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void SSYEVR_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, float* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, float* z, const MKL_INT* ldz, MKL_INT* isuppz,
                     float* work, const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );
void ssyevr_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, float* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, float* z, const MKL_INT* ldz, MKL_INT* isuppz,
                    float* work, const MKL_INT* lwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void ssyevr_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, float* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, float* z, const MKL_INT* ldz, MKL_INT* isuppz,
                     float* work, const MKL_INT* lwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );

void SSYEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, float* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info );
void SSYEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, float* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, float* z, const MKL_INT* ldz, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info );
void ssyevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, float* a, const MKL_INT* lda,
                    const float* vl, const float* vu, const MKL_INT* il,
                    const MKL_INT* iu, const float* abstol, MKL_INT* m,
                    float* w, float* z, const MKL_INT* ldz, float* work,
                    const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                    MKL_INT* info );
void ssyevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, float* a, const MKL_INT* lda,
                     const float* vl, const float* vu, const MKL_INT* il,
                     const MKL_INT* iu, const float* abstol, MKL_INT* m,
                     float* w, float* z, const MKL_INT* ldz, float* work,
                     const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* ifail,
                     MKL_INT* info );

void SSYGV_2STAGE( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                   const MKL_INT* ldb, float* w, float* work,
                   const MKL_INT* lwork, MKL_INT* info );
void SSYGV_2STAGE_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                    const MKL_INT* ldb, float* w, float* work,
                    const MKL_INT* lwork, MKL_INT* info );
void ssygv_2stage( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                   const MKL_INT* ldb, float* w, float* work,
                   const MKL_INT* lwork, MKL_INT* info );
void ssygv_2stage_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, float* a, const MKL_INT* lda, float* b,
                    const MKL_INT* ldb, float* w, float* work,
                    const MKL_INT* lwork, MKL_INT* info );

void SSYTRD_2STAGE( const char* vect, const char* uplo, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* d, float* e,
                    float* tau, float* hous2, const MKL_INT* lhous2,
                    float* work, const MKL_INT* lwork, MKL_INT* info );
void SSYTRD_2STAGE_( const char* vect, const char* uplo, const MKL_INT* n,
                     float* a, const MKL_INT* lda, float* d, float* e,
                     float* tau, float* hous2, const MKL_INT* lhous2,
                     float* work, const MKL_INT* lwork, MKL_INT* info );
void ssytrd_2stage( const char* vect, const char* uplo, const MKL_INT* n,
                    float* a, const MKL_INT* lda, float* d, float* e,
                    float* tau, float* hous2, const MKL_INT* lhous2,
                    float* work, const MKL_INT* lwork, MKL_INT* info );
void ssytrd_2stage_( const char* vect, const char* uplo, const MKL_INT* n,
                     float* a, const MKL_INT* lda, float* d, float* e,
                     float* tau, float* hous2, const MKL_INT* lhous2,
                     float* work, const MKL_INT* lwork, MKL_INT* info );

void SSYTRD_SB2ST( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, float* ab,
                   const MKL_INT* ldab, float* d, float* e, float* hous,
                   const MKL_INT* lhous, float* work, const MKL_INT* lwork,
                   MKL_INT* info );
void SSYTRD_SB2ST_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, float* ab,
                    const MKL_INT* ldab, float* d, float* e, float* hous,
                    const MKL_INT* lhous, float* work, const MKL_INT* lwork,
                    MKL_INT* info );
void ssytrd_sb2st( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, float* ab,
                   const MKL_INT* ldab, float* d, float* e, float* hous,
                   const MKL_INT* lhous, float* work, const MKL_INT* lwork,
                   MKL_INT* info );
void ssytrd_sb2st_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, float* ab,
                    const MKL_INT* ldab, float* d, float* e, float* hous,
                    const MKL_INT* lhous, float* work, const MKL_INT* lwork,
                    MKL_INT* info );

void SSYTRD_SY2SB( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   float* a, const MKL_INT* lda, float* ab,
                   const MKL_INT* ldab, float* tau, float* work,
                   const MKL_INT* lwork, MKL_INT* info );
void SSYTRD_SY2SB_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    float* a, const MKL_INT* lda, float* ab,
                    const MKL_INT* ldab, float* tau, float* work,
                    const MKL_INT* lwork, MKL_INT* info );
void ssytrd_sy2sb( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   float* a, const MKL_INT* lda, float* ab,
                   const MKL_INT* ldab, float* tau, float* work,
                   const MKL_INT* lwork, MKL_INT* info );
void ssytrd_sy2sb_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    float* a, const MKL_INT* lda, float* ab,
                    const MKL_INT* ldab, float* tau, float* work,
                    const MKL_INT* lwork, MKL_INT* info );

void ZHB2ST_KERNELS( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, MKL_Complex16* a,
                     const MKL_INT* lda, MKL_Complex16* v, MKL_Complex16* tau,
                     const MKL_INT* ldvt, const MKL_Complex16* work );
void ZHB2ST_KERNELS_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* v,
                      MKL_Complex16* tau, const MKL_INT* ldvt,
                      const MKL_Complex16* work );
void zhb2st_kernels( const char* uplo, const MKL_INT* wantz,
                     const MKL_INT* ttype, const MKL_INT* st,
                     const MKL_INT* ed, const MKL_INT* sweep, const MKL_INT* n,
                     const MKL_INT* nb, const MKL_INT* ib, MKL_Complex16* a,
                     const MKL_INT* lda, MKL_Complex16* v, MKL_Complex16* tau,
                     const MKL_INT* ldvt, const MKL_Complex16* work );
void zhb2st_kernels_( const char* uplo, const MKL_INT* wantz,
                      const MKL_INT* ttype, const MKL_INT* st,
                      const MKL_INT* ed, const MKL_INT* sweep,
                      const MKL_INT* n, const MKL_INT* nb, const MKL_INT* ib,
                      MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* v,
                      MKL_Complex16* tau, const MKL_INT* ldvt,
                      const MKL_Complex16* work );

void ZHBEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                   double* w, MKL_Complex16* z, const MKL_INT* ldz,
                   MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                   MKL_INT* info );
void ZHBEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* info );
void zhbev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                   double* w, MKL_Complex16* z, const MKL_INT* ldz,
                   MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                   MKL_INT* info );
void zhbev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* info );

void ZHBEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void ZHBEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );
void zhbevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void zhbevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     const MKL_INT* kd, MKL_Complex16* ab, const MKL_INT* ldab,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );

void ZHBEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                    const MKL_INT* ldab, MKL_Complex16* q, const MKL_INT* ldq,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void ZHBEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                     const MKL_INT* ldab, MKL_Complex16* q, const MKL_INT* ldq,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void zhbevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                    const MKL_INT* ldab, MKL_Complex16* q, const MKL_INT* ldq,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void zhbevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                     const MKL_INT* ldab, MKL_Complex16* q, const MKL_INT* ldq,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );

void ZHEEV_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                   MKL_Complex16* a, const MKL_INT* lda, double* w,
                   MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                   MKL_INT* info );
void ZHEEV_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, double* w,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* info );
void zheev_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                   MKL_Complex16* a, const MKL_INT* lda, double* w,
                   MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                   MKL_INT* info );
void zheev_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, double* w,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* info );

void ZHEEVD_2STAGE( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, double* w,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void ZHEEVD_2STAGE_( const char* jobz, const char* uplo, const MKL_INT* n,
                     MKL_Complex16* a, const MKL_INT* lda, double* w,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );
void zheevd_2stage( const char* jobz, const char* uplo, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, double* w,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void zheevd_2stage_( const char* jobz, const char* uplo, const MKL_INT* n,
                     MKL_Complex16* a, const MKL_INT* lda, double* w,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );

void ZHEEVR_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_INT* isuppz, MKL_Complex16* work, const MKL_INT* lwork,
                    double* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void ZHEEVR_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_INT* isuppz, MKL_Complex16* work,
                     const MKL_INT* lwork, double* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );
void zheevr_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_INT* isuppz, MKL_Complex16* work, const MKL_INT* lwork,
                    double* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
                    const MKL_INT* liwork, MKL_INT* info );
void zheevr_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_INT* isuppz, MKL_Complex16* work,
                     const MKL_INT* lwork, double* rwork,
                     const MKL_INT* lrwork, MKL_INT* iwork,
                     const MKL_INT* liwork, MKL_INT* info );

void ZHEEVX_2STAGE( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void ZHEEVX_2STAGE_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void zheevx_2stage( const char* jobz, const char* range, const char* uplo,
                    const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    const double* vl, const double* vu, const MKL_INT* il,
                    const MKL_INT* iu, const double* abstol, MKL_INT* m,
                    double* w, MKL_Complex16* z, const MKL_INT* ldz,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void zheevx_2stage_( const char* jobz, const char* range, const char* uplo,
                     const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                     const double* vl, const double* vu, const MKL_INT* il,
                     const MKL_INT* iu, const double* abstol, MKL_INT* m,
                     double* w, MKL_Complex16* z, const MKL_INT* ldz,
                     MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                     MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );

void ZHEGV_2STAGE( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                   MKL_Complex16* b, const MKL_INT* ldb, double* w,
                   MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                   MKL_INT* info );
void ZHEGV_2STAGE_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    MKL_Complex16* b, const MKL_INT* ldb, double* w,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* info );
void zhegv_2stage( const MKL_INT* itype, const char* jobz, const char* uplo,
                   const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                   MKL_Complex16* b, const MKL_INT* ldb, double* w,
                   MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                   MKL_INT* info );
void zhegv_2stage_( const MKL_INT* itype, const char* jobz, const char* uplo,
                    const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    MKL_Complex16* b, const MKL_INT* ldb, double* w,
                    MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
                    MKL_INT* info );

void ZHETRD_2STAGE( const char* vect, const char* uplo, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, double* d, double* e,
                    MKL_Complex16* tau, MKL_Complex16* hous2,
                    const MKL_INT* lhous2, MKL_Complex16* work,
                    const MKL_INT* lwork, MKL_INT* info );
void ZHETRD_2STAGE_( const char* vect, const char* uplo, const MKL_INT* n,
                     MKL_Complex16* a, const MKL_INT* lda, double* d,
                     double* e, MKL_Complex16* tau, MKL_Complex16* hous2,
                     const MKL_INT* lhous2, MKL_Complex16* work,
                     const MKL_INT* lwork, MKL_INT* info );
void zhetrd_2stage( const char* vect, const char* uplo, const MKL_INT* n,
                    MKL_Complex16* a, const MKL_INT* lda, double* d, double* e,
                    MKL_Complex16* tau, MKL_Complex16* hous2,
                    const MKL_INT* lhous2, MKL_Complex16* work,
                    const MKL_INT* lwork, MKL_INT* info );
void zhetrd_2stage_( const char* vect, const char* uplo, const MKL_INT* n,
                     MKL_Complex16* a, const MKL_INT* lda, double* d,
                     double* e, MKL_Complex16* tau, MKL_Complex16* hous2,
                     const MKL_INT* lhous2, MKL_Complex16* work,
                     const MKL_INT* lwork, MKL_INT* info );

void ZHETRD_HB2ST( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                   const MKL_INT* ldab, double* d, double* e,
                   MKL_Complex16* hous, const MKL_INT* lhous,
                   MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZHETRD_HB2ST_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                    const MKL_INT* ldab, double* d, double* e,
                    MKL_Complex16* hous, const MKL_INT* lhous,
                    MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zhetrd_hb2st( const char* stage1, const char* vect, const char* uplo,
                   const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                   const MKL_INT* ldab, double* d, double* e,
                   MKL_Complex16* hous, const MKL_INT* lhous,
                   MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zhetrd_hb2st_( const char* stage1, const char* vect, const char* uplo,
                    const MKL_INT* n, const MKL_INT* kd, MKL_Complex16* ab,
                    const MKL_INT* ldab, double* d, double* e,
                    MKL_Complex16* hous, const MKL_INT* lhous,
                    MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void ZHETRD_HE2HB( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* ab,
                   const MKL_INT* ldab, MKL_Complex16* tau,
                   MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZHETRD_HE2HB_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* ab,
                    const MKL_INT* ldab, MKL_Complex16* tau,
                    MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zhetrd_he2hb( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                   MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* ab,
                   const MKL_INT* ldab, MKL_Complex16* tau,
                   MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zhetrd_he2hb_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
                    MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* ab,
                    const MKL_INT* ldab, MKL_Complex16* tau,
                    MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void MKL_CGETRFNP( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* info );
void MKL_CGETRFNP_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                    const MKL_INT* lda, MKL_INT* info );
void mkl_cgetrfnp( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* info );
void mkl_cgetrfnp_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
                    const MKL_INT* lda, MKL_INT* info );

void MKL_DGETRFNP( const MKL_INT* m, const MKL_INT* n, double* a,
                   const MKL_INT* lda, MKL_INT* info );
void MKL_DGETRFNP_( const MKL_INT* m, const MKL_INT* n, double* a,
                    const MKL_INT* lda, MKL_INT* info );
void mkl_dgetrfnp( const MKL_INT* m, const MKL_INT* n, double* a,
                   const MKL_INT* lda, MKL_INT* info );
void mkl_dgetrfnp_( const MKL_INT* m, const MKL_INT* n, double* a,
                    const MKL_INT* lda, MKL_INT* info );

void MKL_SGETRFNP( const MKL_INT* m, const MKL_INT* n, float* a,
                   const MKL_INT* lda, MKL_INT* info );
void MKL_SGETRFNP_( const MKL_INT* m, const MKL_INT* n, float* a,
                    const MKL_INT* lda, MKL_INT* info );
void mkl_sgetrfnp( const MKL_INT* m, const MKL_INT* n, float* a,
                   const MKL_INT* lda, MKL_INT* info );
void mkl_sgetrfnp_( const MKL_INT* m, const MKL_INT* n, float* a,
                    const MKL_INT* lda, MKL_INT* info );

void MKL_ZGETRFNP( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* info );
void MKL_ZGETRFNP_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                    const MKL_INT* lda, MKL_INT* info );
void mkl_zgetrfnp( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* info );
void mkl_zgetrfnp_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
                    const MKL_INT* lda, MKL_INT* info );

void MKL_CGETRINP( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                   MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void MKL_CGETRINP_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void mkl_cgetrinp( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                   MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void mkl_cgetrinp_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
                    MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void MKL_DGETRINP( const MKL_INT* n, double* a, const MKL_INT* lda,
                   double* work, const MKL_INT* lwork, MKL_INT* info );
void MKL_DGETRINP_( const MKL_INT* n, double* a, const MKL_INT* lda,
                    double* work, const MKL_INT* lwork, MKL_INT* info );
void mkl_dgetrinp( const MKL_INT* n, double* a, const MKL_INT* lda,
                   double* work, const MKL_INT* lwork, MKL_INT* info );
void mkl_dgetrinp_( const MKL_INT* n, double* a, const MKL_INT* lda,
                    double* work, const MKL_INT* lwork, MKL_INT* info );

void MKL_SGETRINP( const MKL_INT* n, float* a, const MKL_INT* lda, float* work,
                   const MKL_INT* lwork, MKL_INT* info );
void MKL_SGETRINP_( const MKL_INT* n, float* a, const MKL_INT* lda,
                    float* work, const MKL_INT* lwork, MKL_INT* info );
void mkl_sgetrinp( const MKL_INT* n, float* a, const MKL_INT* lda, float* work,
                   const MKL_INT* lwork, MKL_INT* info );
void mkl_sgetrinp_( const MKL_INT* n, float* a, const MKL_INT* lda,
                    float* work, const MKL_INT* lwork, MKL_INT* info );

void MKL_ZGETRINP( const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                   MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void MKL_ZGETRINP_( const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void mkl_zgetrinp( const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                   MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void mkl_zgetrinp_( const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
                    MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void DSYTRF_AA_2STAGE( const char* uplo, const MKL_INT* n, double* a,
                       const MKL_INT* lda, double* tb, const MKL_INT* ltb,
                       MKL_INT* ipiv, MKL_INT* ipiv2, double* work,
                       const MKL_INT* lwork, MKL_INT* info );
void DSYTRF_AA_2STAGE_( const char* uplo, const MKL_INT* n, double* a,
                        const MKL_INT* lda, double* tb, const MKL_INT* ltb,
                        MKL_INT* ipiv, MKL_INT* ipiv2, double* work,
                        const MKL_INT* lwork, MKL_INT* info );
void dsytrf_aa_2stage( const char* uplo, const MKL_INT* n, double* a,
                       const MKL_INT* lda, double* tb, const MKL_INT* ltb,
                       MKL_INT* ipiv, MKL_INT* ipiv2, double* work,
                       const MKL_INT* lwork, MKL_INT* info );
void dsytrf_aa_2stage_( const char* uplo, const MKL_INT* n, double* a,
                        const MKL_INT* lda, double* tb, const MKL_INT* ltb,
                        MKL_INT* ipiv, MKL_INT* ipiv2, double* work,
                        const MKL_INT* lwork, MKL_INT* info );

void CHESV_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info );
void CHESV_AA_2STAGE_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void chesv_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info );
void chesv_aa_2stage_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );

void CHETRF_AA_2STAGE( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void CHETRF_AA_2STAGE_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void chetrf_aa_2stage( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void chetrf_aa_2stage_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );

void CHETRS_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void CHETRS_AA_2STAGE_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );
void chetrs_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void chetrs_aa_2stage_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );

void CSYSV_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info );
void CSYSV_AA_2STAGE_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );
void csysv_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                      const MKL_INT* lwork, MKL_INT* info );
void csysv_aa_2stage_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                       const MKL_INT* lwork, MKL_INT* info );

void CSYTRF_AA_2STAGE( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void CSYTRF_AA_2STAGE_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );
void csytrf_aa_2stage( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                       const MKL_INT* lda, MKL_Complex8* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex8* work, const MKL_INT* lwork,
                       MKL_INT* info );
void csytrf_aa_2stage_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex8* work, const MKL_INT* lwork,
                        MKL_INT* info );

void CSYTRS_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void CSYTRS_AA_2STAGE_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );
void csytrs_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex8* a, const MKL_INT* lda,
                       MKL_Complex8* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void csytrs_aa_2stage_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex8* a,
                        const MKL_INT* lda, MKL_Complex8* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex8* b,
                        const MKL_INT* ldb, MKL_INT* info );

void ZHESV_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex16* b, const MKL_INT* ldb,
                      MKL_Complex16* work, const MKL_INT* lwork,
                      MKL_INT* info );
void ZHESV_AA_2STAGE_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info );
void zhesv_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex16* b, const MKL_INT* ldb,
                      MKL_Complex16* work, const MKL_INT* lwork,
                      MKL_INT* info );
void zhesv_aa_2stage_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info );

void ZHETRF_AA_2STAGE( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                       const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info );
void ZHETRF_AA_2STAGE_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info );
void zhetrf_aa_2stage( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                       const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info );
void zhetrf_aa_2stage_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info );

void ZHETRS_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex16* a, const MKL_INT* lda,
                       MKL_Complex16* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void ZHETRS_AA_2STAGE_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_INT* info );
void zhetrs_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex16* a, const MKL_INT* lda,
                       MKL_Complex16* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void zhetrs_aa_2stage_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_INT* info );

void ZSYSV_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex16* b, const MKL_INT* ldb,
                      MKL_Complex16* work, const MKL_INT* lwork,
                      MKL_INT* info );
void ZSYSV_AA_2STAGE_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info );
void zsysv_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      MKL_Complex16* b, const MKL_INT* ldb,
                      MKL_Complex16* work, const MKL_INT* lwork,
                      MKL_INT* info );
void zsysv_aa_2stage_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info );

void ZSYTRF_AA_2STAGE( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                       const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info );
void ZSYTRF_AA_2STAGE_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info );
void zsytrf_aa_2stage( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                       const MKL_INT* lda, MKL_Complex16* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       MKL_Complex16* work, const MKL_INT* lwork,
                       MKL_INT* info );
void zsytrf_aa_2stage_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                        MKL_Complex16* work, const MKL_INT* lwork,
                        MKL_INT* info );

void ZSYTRS_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex16* a, const MKL_INT* lda,
                       MKL_Complex16* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void ZSYTRS_AA_2STAGE_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_INT* info );
void zsytrs_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const MKL_Complex16* a, const MKL_INT* lda,
                       MKL_Complex16* tb, const MKL_INT* ltb,
                       const MKL_INT* ipiv, const MKL_INT* ipiv2,
                       MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void zsytrs_aa_2stage_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const MKL_Complex16* a,
                        const MKL_INT* lda, MKL_Complex16* tb,
                        const MKL_INT* ltb, const MKL_INT* ipiv,
                        const MKL_INT* ipiv2, MKL_Complex16* b,
                        const MKL_INT* ldb, MKL_INT* info );

void DSYTRS_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const double* a, const MKL_INT* lda, double* tb,
                       const MKL_INT* ltb, const MKL_INT* ipiv,
                       const MKL_INT* ipiv2, double* b, const MKL_INT* ldb,
                       MKL_INT* info );
void DSYTRS_AA_2STAGE_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const double* a,
                        const MKL_INT* lda, double* tb, const MKL_INT* ltb,
                        const MKL_INT* ipiv, const MKL_INT* ipiv2, double* b,
                        const MKL_INT* ldb, MKL_INT* info );
void dsytrs_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const double* a, const MKL_INT* lda, double* tb,
                       const MKL_INT* ltb, const MKL_INT* ipiv,
                       const MKL_INT* ipiv2, double* b, const MKL_INT* ldb,
                       MKL_INT* info );
void dsytrs_aa_2stage_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const double* a,
                        const MKL_INT* lda, double* tb, const MKL_INT* ltb,
                        const MKL_INT* ipiv, const MKL_INT* ipiv2, double* b,
                        const MKL_INT* ldb, MKL_INT* info );

void DSYSV_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      double* a, const MKL_INT* lda, double* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      double* b, const MKL_INT* ldb, double* work,
                      const MKL_INT* lwork, MKL_INT* info );
void DSYSV_AA_2STAGE_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       double* a, const MKL_INT* lda, double* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       double* b, const MKL_INT* ldb, double* work,
                       const MKL_INT* lwork, MKL_INT* info );
void dsysv_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      double* a, const MKL_INT* lda, double* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      double* b, const MKL_INT* ldb, double* work,
                      const MKL_INT* lwork, MKL_INT* info );
void dsysv_aa_2stage_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       double* a, const MKL_INT* lda, double* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       double* b, const MKL_INT* ldb, double* work,
                       const MKL_INT* lwork, MKL_INT* info );

void SSYSV_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      float* a, const MKL_INT* lda, float* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      float* b, const MKL_INT* ldb, float* work,
                      const MKL_INT* lwork, MKL_INT* info );
void SSYSV_AA_2STAGE_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       float* a, const MKL_INT* lda, float* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       float* b, const MKL_INT* ldb, float* work,
                       const MKL_INT* lwork, MKL_INT* info );
void ssysv_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                      float* a, const MKL_INT* lda, float* tb,
                      const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                      float* b, const MKL_INT* ldb, float* work,
                      const MKL_INT* lwork, MKL_INT* info );
void ssysv_aa_2stage_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       float* a, const MKL_INT* lda, float* tb,
                       const MKL_INT* ltb, MKL_INT* ipiv, MKL_INT* ipiv2,
                       float* b, const MKL_INT* ldb, float* work,
                       const MKL_INT* lwork, MKL_INT* info );

void SSYTRS_AA_2STAGE( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* a, const MKL_INT* lda, float* tb,
                       const MKL_INT* ltb, const MKL_INT* ipiv,
                       const MKL_INT* ipiv2, float* b, const MKL_INT* ldb,
                       MKL_INT* info );
void SSYTRS_AA_2STAGE_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const float* a,
                        const MKL_INT* lda, float* tb, const MKL_INT* ltb,
                        const MKL_INT* ipiv, const MKL_INT* ipiv2, float* b,
                        const MKL_INT* ldb, MKL_INT* info );
void ssytrs_aa_2stage( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                       const float* a, const MKL_INT* lda, float* tb,
                       const MKL_INT* ltb, const MKL_INT* ipiv,
                       const MKL_INT* ipiv2, float* b, const MKL_INT* ldb,
                       MKL_INT* info );
void ssytrs_aa_2stage_( const char* uplo, const MKL_INT* n,
                        const MKL_INT* nrhs, const float* a,
                        const MKL_INT* lda, float* tb, const MKL_INT* ltb,
                        const MKL_INT* ipiv, const MKL_INT* ipiv2, float* b,
                        const MKL_INT* ldb, MKL_INT* info );

void SSYTRF_AA_2STAGE( const char* uplo, const MKL_INT* n, float* a,
                       const MKL_INT* lda, float* tb, const MKL_INT* ltb,
                       MKL_INT* ipiv, MKL_INT* ipiv2, float* work,
                       const MKL_INT* lwork, MKL_INT* info );
void SSYTRF_AA_2STAGE_( const char* uplo, const MKL_INT* n, float* a,
                        const MKL_INT* lda, float* tb, const MKL_INT* ltb,
                        MKL_INT* ipiv, MKL_INT* ipiv2, float* work,
                        const MKL_INT* lwork, MKL_INT* info );
void ssytrf_aa_2stage( const char* uplo, const MKL_INT* n, float* a,
                       const MKL_INT* lda, float* tb, const MKL_INT* ltb,
                       MKL_INT* ipiv, MKL_INT* ipiv2, float* work,
                       const MKL_INT* lwork, MKL_INT* info );
void ssytrf_aa_2stage_( const char* uplo, const MKL_INT* n, float* a,
                        const MKL_INT* lda, float* tb, const MKL_INT* ltb,
                        MKL_INT* ipiv, MKL_INT* ipiv2, float* work,
                        const MKL_INT* lwork, MKL_INT* info );

void DTREVC3( const char* side, const char* howmny, MKL_INT* select,
              const MKL_INT* n, const double* t, const MKL_INT* ldt,
              double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void DTREVC3_( const char* side, const char* howmny, MKL_INT* select,
               const MKL_INT* n, const double* t, const MKL_INT* ldt,
               double* vl, const MKL_INT* ldvl, double* vr,
               const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
               double* work, const MKL_INT* lwork, MKL_INT* info );
void dtrevc3( const char* side, const char* howmny, MKL_INT* select,
              const MKL_INT* n, const double* t, const MKL_INT* ldt,
              double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dtrevc3_( const char* side, const char* howmny, MKL_INT* select,
               const MKL_INT* n, const double* t, const MKL_INT* ldt,
               double* vl, const MKL_INT* ldvl, double* vr,
               const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
               double* work, const MKL_INT* lwork, MKL_INT* info );

void STREVC3( const char* side, const char* howmny, MKL_INT* select,
              const MKL_INT* n, const float* t, const MKL_INT* ldt, float* vl,
              const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, float* work, const MKL_INT* lwork,
              MKL_INT* info );
void STREVC3_( const char* side, const char* howmny, MKL_INT* select,
               const MKL_INT* n, const float* t, const MKL_INT* ldt, float* vl,
               const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
               const MKL_INT* mm, MKL_INT* m, float* work,
               const MKL_INT* lwork, MKL_INT* info );
void strevc3( const char* side, const char* howmny, MKL_INT* select,
              const MKL_INT* n, const float* t, const MKL_INT* ldt, float* vl,
              const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, float* work, const MKL_INT* lwork,
              MKL_INT* info );
void strevc3_( const char* side, const char* howmny, MKL_INT* select,
               const MKL_INT* n, const float* t, const MKL_INT* ldt, float* vl,
               const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr,
               const MKL_INT* mm, MKL_INT* m, float* work,
               const MKL_INT* lwork, MKL_INT* info );

void CTREVC3( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
              const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* info );
void CTREVC3_( const char* side, const char* howmny, const MKL_INT* select,
               const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
               MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
               const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
               MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
               const MKL_INT* lrwork, MKL_INT* info );
void ctrevc3( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
              const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* info );
void ctrevc3_( const char* side, const char* howmny, const MKL_INT* select,
               const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
               MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
               const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
               MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
               const MKL_INT* lrwork, MKL_INT* info );

void ZTREVC3( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
              const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
              MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
              const MKL_INT* lrwork, MKL_INT* info );
void ZTREVC3_( const char* side, const char* howmny, const MKL_INT* select,
               const MKL_INT* n, MKL_Complex16* t, const MKL_INT* ldt,
               MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
               const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
               MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
               const MKL_INT* lrwork, MKL_INT* info );
void ztrevc3( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
              const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
              MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
              const MKL_INT* lrwork, MKL_INT* info );
void ztrevc3_( const char* side, const char* howmny, const MKL_INT* select,
               const MKL_INT* n, MKL_Complex16* t, const MKL_INT* ldt,
               MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
               const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
               MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
               const MKL_INT* lrwork, MKL_INT* info );

/* LAPACK 3.6.0 routines */

void CGEJSV( const char* joba, const char* jobu, const char* jobv, const char* jobr,
             const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* sva, MKL_Complex8* u, const MKL_INT* ldu,
             MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork, const MKL_INT* lwork,
             float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info );
void CGEJSV_( const char* joba, const char* jobu, const char* jobv, const char* jobr,
              const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, float* sva, MKL_Complex8* u, const MKL_INT* ldu,
              MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork, const MKL_INT* lwork,
              float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info );
void cgejsv( const char* joba, const char* jobu, const char* jobv, const char* jobr,
             const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* sva, MKL_Complex8* u, const MKL_INT* ldu,
             MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork, const MKL_INT* lwork,
             float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info );
void cgejsv_( const char* joba, const char* jobu, const char* jobv, const char* jobr,
              const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, float* sva, MKL_Complex8* u, const MKL_INT* ldu,
              MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork, const MKL_INT* lwork,
              float* rwork, const MKL_INT* lrwork, MKL_INT* iwork, MKL_INT* info );

void ZGEJSV( const char* joba, const char* jobu, const char* jobv, const char* jobr,
             const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex16* a, const MKL_INT* lda, double* sva, MKL_Complex16* u,
             const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
             const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
             MKL_INT* info );
void ZGEJSV_( const char* joba, const char* jobu, const char* jobv, const char* jobr,
              const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex16* a, const MKL_INT* lda, double* sva, MKL_Complex16* u,
              const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
              const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
              MKL_INT* info );
void zgejsv( const char* joba, const char* jobu, const char* jobv, const char* jobr,
             const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex16* a, const MKL_INT* lda, double* sva, MKL_Complex16* u,
             const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
             const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
             MKL_INT* info );
void zgejsv_( const char* joba, const char* jobu, const char* jobv, const char* jobr,
              const char* jobt, const char* jobp, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex16* a, const MKL_INT* lda, double* sva, MKL_Complex16* u,
              const MKL_INT* ldu, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
              const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* iwork,
              MKL_INT* info );

void DGESVDX( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, double* a, const MKL_INT* lda, const double* vl,
              const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
              double* s, double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
              double* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void DGESVDX_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, double* a, const MKL_INT* lda, const double* vl,
               const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
               double* s, double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
               double* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void dgesvdx( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, double* a, const MKL_INT* lda, const double* vl,
              const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
              double* s, double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
              double* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void dgesvdx_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, double* a, const MKL_INT* lda, const double* vl,
               const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
               double* s, double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
               double* work, const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );

void SGESVDX( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, float* a, const MKL_INT* lda, const float* vl, const float* vu,
              const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s,
              float* u, const MKL_INT* ldu, float* vt, const MKL_INT* ldvt, float* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void SGESVDX_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, float* a, const MKL_INT* lda, const float* vl, const float* vu,
               const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s,
               float* u, const MKL_INT* ldu, float* vt, const MKL_INT* ldvt, float* work,
               const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void sgesvdx( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, float* a, const MKL_INT* lda, const float* vl, const float* vu,
              const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s,
              float* u, const MKL_INT* ldu, float* vt, const MKL_INT* ldvt, float* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void sgesvdx_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, float* a, const MKL_INT* lda, const float* vl, const float* vu,
               const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s,
               float* u, const MKL_INT* ldu, float* vt, const MKL_INT* ldvt, float* work,
               const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );

void CGESVDX( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, const float* vl,
              const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
              float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
              MKL_Complex8* work,const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              MKL_INT* info );
void CGESVDX_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, const float* vl,
               const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
               float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
               MKL_Complex8* work,const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
               MKL_INT* info );
void cgesvdx( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, const float* vl,
              const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
              float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
              MKL_Complex8* work,const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              MKL_INT* info );
void cgesvdx_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, const float* vl,
               const float* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
               float* s, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
               MKL_Complex8* work,const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
               MKL_INT* info );

void ZGESVDX( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, const double* vl,
              const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
              double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* vt,
              const MKL_INT* ldvt, MKL_Complex16* work,const MKL_INT* lwork, double* rwork,
              MKL_INT* iwork, MKL_INT* info );
void ZGESVDX_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, const double* vl,
               const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
               double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* vt,
               const MKL_INT* ldvt, MKL_Complex16* work,const MKL_INT* lwork, double* rwork,
               MKL_INT* iwork, MKL_INT* info );
void zgesvdx( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, const double* vl,
              const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
              double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* vt,
              const MKL_INT* ldvt, MKL_Complex16* work,const MKL_INT* lwork, double* rwork,
              MKL_INT* iwork, MKL_INT* info );
void zgesvdx_( const char* jobu, const char* jobvt, const char* range, const MKL_INT* m,
               const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, const double* vl,
               const double* vu, const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns,
               double* s, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* vt,
               const MKL_INT* ldvt, MKL_Complex16* work,const MKL_INT* lwork, double* rwork,
               MKL_INT* iwork, MKL_INT* info );

void CGESVJ( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* sva,
             const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void CGESVJ_( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* sva,
              const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void cgesvj( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* sva,
             const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );
void cgesvj_( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* sva,
              const MKL_INT* mv, MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* cwork,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void ZGESVJ( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* sva,
             const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
             const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void ZGESVJ_( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* sva,
              const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
              const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void zgesvj( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* sva,
             const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
             const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );
void zgesvj_( const char* joba, const char* jobu, const char* jobv, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, double* sva,
              const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, MKL_Complex16* cwork,
              const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void DGGSVD3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alpha,
              double* beta, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
              double* q, const MKL_INT* ldq, double* work, const MKL_INT* lwork,
              MKL_INT* iwork, MKL_INT* info );
void DGGSVD3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, double* a,
               const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alpha,
               double* beta, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
               double* q, const MKL_INT* ldq, double* work, const MKL_INT* lwork,
               MKL_INT* iwork, MKL_INT* info );
void dggsvd3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alpha,
              double* beta, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
              double* q, const MKL_INT* ldq, double* work, const MKL_INT* lwork,
              MKL_INT* iwork, MKL_INT* info );
void dggsvd3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, double* a,
               const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alpha,
               double* beta, double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
               double* q, const MKL_INT* ldq, double* work, const MKL_INT* lwork,
               MKL_INT* iwork, MKL_INT* info );

void SGGSVD3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, float* a,
              const MKL_INT* lda, float* b, const MKL_INT* ldb, float* alpha, float* beta,
              float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, float* q,
              const MKL_INT* ldq, float* work, const MKL_INT* lwork, MKL_INT* iwork,
              MKL_INT* info );
void SGGSVD3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, float* a,
               const MKL_INT* lda, float* b, const MKL_INT* ldb, float* alpha, float* beta,
               float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, float* q,
               const MKL_INT* ldq, float* work, const MKL_INT* lwork, MKL_INT* iwork,
               MKL_INT* info );
void sggsvd3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, float* a,
              const MKL_INT* lda, float* b, const MKL_INT* ldb, float* alpha, float* beta,
              float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, float* q,
              const MKL_INT* ldq, float* work, const MKL_INT* lwork, MKL_INT* iwork,
              MKL_INT* info );
void sggsvd3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, float* a,
               const MKL_INT* lda, float* b, const MKL_INT* ldb, float* alpha, float* beta,
               float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv, float* q,
               const MKL_INT* ldq, float* work, const MKL_INT* lwork, MKL_INT* iwork,
               MKL_INT* info );

void CGGSVD3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, float* alpha,
              float* beta, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork, MKL_INT* info );
void CGGSVD3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, float* alpha,
               float* beta, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
               const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
               const MKL_INT* lwork, float* rwork, MKL_INT* iwork, MKL_INT* info );
void cggsvd3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, float* alpha,
              float* beta, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork, MKL_INT* info );
void cggsvd3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, float* alpha,
               float* beta, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
               const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
               const MKL_INT* lwork, float* rwork, MKL_INT* iwork, MKL_INT* info );

void ZGGSVD3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, double* alpha,
              double* beta, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
              const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* work,
              const MKL_INT* lwork, double* rwork, MKL_INT* iwork, MKL_INT* info );
void ZGGSVD3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex16* a,
               const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, double* alpha,
               double* beta, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
               const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* work,
               const MKL_INT* lwork, double* rwork, MKL_INT* iwork, MKL_INT* info );
void zggsvd3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, double* alpha,
              double* beta, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
              const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* work,
              const MKL_INT* lwork, double* rwork, MKL_INT* iwork, MKL_INT* info );
void zggsvd3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* p, MKL_INT* k, MKL_INT* l, MKL_Complex16* a,
               const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, double* alpha,
               double* beta, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
               const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* work,
               const MKL_INT* lwork, double* rwork, MKL_INT* iwork, MKL_INT* info );

void DGGSVP3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb, const double* tola, const double* tolb,
              MKL_INT* k, MKL_INT* l, double* u, const MKL_INT* ldu, double* v,
              const MKL_INT* ldv, double* q, const MKL_INT* ldq, MKL_INT* iwork,
              double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void DGGSVP3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, double* a, const MKL_INT* lda,
               double* b, const MKL_INT* ldb, const double* tola, const double* tolb,
               MKL_INT* k, MKL_INT* l, double* u, const MKL_INT* ldu, double* v,
               const MKL_INT* ldv, double* q, const MKL_INT* ldq, MKL_INT* iwork,
               double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void dggsvp3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb, const double* tola, const double* tolb,
              MKL_INT* k, MKL_INT* l, double* u, const MKL_INT* ldu, double* v,
              const MKL_INT* ldv, double* q, const MKL_INT* ldq, MKL_INT* iwork,
              double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void dggsvp3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, double* a, const MKL_INT* lda,
               double* b, const MKL_INT* ldb, const double* tola, const double* tolb,
               MKL_INT* k, MKL_INT* l, double* u, const MKL_INT* ldu, double* v,
               const MKL_INT* ldv, double* q, const MKL_INT* ldq, MKL_INT* iwork,
               double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );

void SGGSVP3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb, const float* tola, const float* tolb,
              MKL_INT* k, MKL_INT* l, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv,
              float* q, const MKL_INT* ldq, MKL_INT* iwork, float* tau, float* work,
              const MKL_INT* lwork, MKL_INT* info );
void SGGSVP3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, float* a, const MKL_INT* lda,
               float* b, const MKL_INT* ldb, const float* tola, const float* tolb,
               MKL_INT* k, MKL_INT* l, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv,
               float* q, const MKL_INT* ldq, MKL_INT* iwork, float* tau, float* work,
               const MKL_INT* lwork, MKL_INT* info );
void sggsvp3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb, const float* tola, const float* tolb,
              MKL_INT* k, MKL_INT* l, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv,
              float* q, const MKL_INT* ldq, MKL_INT* iwork, float* tau, float* work,
              const MKL_INT* lwork, MKL_INT* info );
void sggsvp3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, float* a, const MKL_INT* lda,
               float* b, const MKL_INT* ldb, const float* tola, const float* tolb,
               MKL_INT* k, MKL_INT* l, float* u, const MKL_INT* ldu, float* v, const MKL_INT* ldv,
               float* q, const MKL_INT* ldq, MKL_INT* iwork, float* tau, float* work,
               const MKL_INT* lwork, MKL_INT* info );

void CGGSVP3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, const float* tola, const float* tolb,
              MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_INT* iwork,
              float* rwork, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void CGGSVP3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb, const float* tola, const float* tolb,
               MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
               const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_INT* iwork,
               float* rwork, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info );
void cggsvp3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, const float* tola, const float* tolb,
              MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_INT* iwork,
              float* rwork, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void cggsvp3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb, const float* tola, const float* tolb,
               MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
               const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq, MKL_INT* iwork,
               float* rwork, MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info );

void ZGGSVP3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb, const double* tola, const double* tolb,
              MKL_INT* k, MKL_INT* l, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
              const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_INT* iwork,
              double* rwork, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info );
void ZGGSVP3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb, const double* tola, const double* tolb,
               MKL_INT* k, MKL_INT* l, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
               const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_INT* iwork,
               double* rwork, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info );
void zggsvp3( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
              const MKL_INT* p, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb, const double* tola, const double* tolb,
              MKL_INT* k, MKL_INT* l, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
              const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_INT* iwork,
              double* rwork, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info );
void zggsvp3_( const char* jobu, const char* jobv, const char* jobq, const MKL_INT* m,
               const MKL_INT* p, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb, const double* tola, const double* tolb,
               MKL_INT* k, MKL_INT* l, MKL_Complex16* u, const MKL_INT* ldu, MKL_Complex16* v,
               const MKL_INT* ldv, MKL_Complex16* q, const MKL_INT* ldq, MKL_INT* iwork,
               double* rwork, MKL_Complex16* tau, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info );

void CGSVJ0( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
             MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
             const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CGSVJ0_( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
              MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
              const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void cgsvj0( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
             MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
             const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void cgsvj0_( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
              MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
              const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );

void ZGSVJ0( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* d, double* sva, const MKL_INT* mv,
             MKL_Complex16* v, const MKL_INT* ldv, const double* eps, const double* sfmin,
             const double* tol, const MKL_INT* nsweep, MKL_Complex16* work, const MKL_INT* lwork,
             MKL_INT* info );
void ZGSVJ0_( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* d, double* sva, const MKL_INT* mv,
              MKL_Complex16* v, const MKL_INT* ldv, const double* eps, const double* sfmin,
              const double* tol, const MKL_INT* nsweep, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info );
void zgsvj0( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* d, double* sva, const MKL_INT* mv,
             MKL_Complex16* v, const MKL_INT* ldv, const double* eps, const double* sfmin,
             const double* tol, const MKL_INT* nsweep, MKL_Complex16* work, const MKL_INT* lwork,
             MKL_INT* info );
void zgsvj0_( const char* jobv, const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* d, double* sva, const MKL_INT* mv,
              MKL_Complex16* v, const MKL_INT* ldv, const double* eps, const double* sfmin,
              const double* tol, const MKL_INT* nsweep, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info );

void CGSVJ1( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
             MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
             const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CGSVJ1_( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
              MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
              const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void cgsvj1( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
             MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
             const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void cgsvj1_( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* d, float* sva, const MKL_INT* mv,
              MKL_Complex8* v, const MKL_INT* ldv, const float* eps, const float* sfmin,
              const float* tol, const MKL_INT* nsweep, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );

void ZGSVJ1( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
             MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, double* sva,
             const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, const double* eps,
             const double* sfmin, const double* tol, const MKL_INT* nsweep, MKL_Complex16* work,
             const MKL_INT* lwork, MKL_INT* info );
void ZGSVJ1_( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
              MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, double* sva,
              const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, const double* eps,
              const double* sfmin, const double* tol, const MKL_INT* nsweep, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info );
void zgsvj1( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
             MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, double* sva,
             const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, const double* eps,
             const double* sfmin, const double* tol, const MKL_INT* nsweep, MKL_Complex16* work,
             const MKL_INT* lwork, MKL_INT* info );
void zgsvj1_( const char* jobv, const MKL_INT* m, const MKL_INT* n, const MKL_INT* n1,
              MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* d, double* sva,
              const MKL_INT* mv, MKL_Complex16* v, const MKL_INT* ldv, const double* eps,
              const double* sfmin, const double* tol, const MKL_INT* nsweep, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info );

void CPOTRF2( const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* info );
void CPOTRF2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
               MKL_INT* info );
void cpotrf2( const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* info );
void cpotrf2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
               MKL_INT* info );

void DPOTRF2( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
              MKL_INT* info );
void DPOTRF2_( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
               MKL_INT* info );
void dpotrf2( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
              MKL_INT* info );
void dpotrf2_( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
               MKL_INT* info );

void SPOTRF2( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* info );
void SPOTRF2_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* info );
void spotrf2( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* info );
void spotrf2_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* info );

void ZPOTRF2( const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
              MKL_INT* info );
void ZPOTRF2_( const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
               MKL_INT* info );
void zpotrf2( const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
              MKL_INT* info );
void zpotrf2_( const char* uplo, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
               MKL_INT* info );

void DBDSVDX( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
              const double* d, const double* e, const double* vl, const double* vu,
              const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, double* s, double* z,
              const MKL_INT* ldz, double* work, MKL_INT* iwork, MKL_INT* info );
void DBDSVDX_( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
               const double* d, const double* e, const double* vl, const double* vu,
               const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, double* s, double* z,
               const MKL_INT* ldz, double* work, MKL_INT* iwork, MKL_INT* info );
void dbdsvdx( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
              const double* d, const double* e, const double* vl, const double* vu,
              const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, double* s, double* z,
              const MKL_INT* ldz, double* work, MKL_INT* iwork, MKL_INT* info );
void dbdsvdx_( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
               const double* d, const double* e, const double* vl, const double* vu,
               const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, double* s, double* z,
               const MKL_INT* ldz, double* work, MKL_INT* iwork, MKL_INT* info );

void SBDSVDX( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
              const float* d, const float* e, const float* vl, const float* vu,
              const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s, float* z,
              const MKL_INT* ldz, float* work, MKL_INT* iwork, MKL_INT* info );
void SBDSVDX_( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
               const float* d, const float* e, const float* vl, const float* vu,
               const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s, float* z,
               const MKL_INT* ldz, float* work, MKL_INT* iwork, MKL_INT* info );
void sbdsvdx( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
              const float* d, const float* e, const float* vl, const float* vu,
              const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s, float* z,
              const MKL_INT* ldz, float* work, MKL_INT* iwork, MKL_INT* info );
void sbdsvdx_( const char* uplo, const char* jobz, const char* range, const MKL_INT* n,
               const float* d, const float* e, const float* vl, const float* vu,
               const MKL_INT* il, const MKL_INT* iu, MKL_INT* ns, float* s, float* z,
               const MKL_INT* ldz, float* work, MKL_INT* iwork, MKL_INT* info );

void CGETRF2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* info );
void CGETRF2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
               MKL_INT* ipiv, MKL_INT* info );
void cgetrf2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* info );
void cgetrf2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
               MKL_INT* ipiv, MKL_INT* info );

void DGETRF2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* info );
void DGETRF2_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
               MKL_INT* ipiv, MKL_INT* info );
void dgetrf2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* info );
void dgetrf2_( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
               MKL_INT* ipiv, MKL_INT* info );

void SGETRF2( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_INT* info );
void SGETRF2_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_INT* info );
void sgetrf2( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_INT* info );
void sgetrf2_( const MKL_INT* m, const MKL_INT* n, float* a, const MKL_INT* lda, MKL_INT* ipiv,
               MKL_INT* info );

void ZGETRF2( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* info );
void ZGETRF2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
               MKL_INT* ipiv, MKL_INT* info );
void zgetrf2( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* info );
void zgetrf2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda,
               MKL_INT* ipiv, MKL_INT* info );

void CGGEV3( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* alpha,
             MKL_Complex8* beta, MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info );
void CGGEV3_( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* alpha,
              MKL_Complex8* beta, MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
              const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info );
void cggev3( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* alpha,
             MKL_Complex8* beta, MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info );
void cggev3_( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* alpha,
              MKL_Complex8* beta, MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
              const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info );

void ZGGEV3( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* alpha,
             MKL_Complex16* beta, MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
             const MKL_INT* ldvr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
             MKL_INT* info );
void ZGGEV3_( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* alpha,
              MKL_Complex16* beta, MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
              const MKL_INT* ldvr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
              MKL_INT* info );
void zggev3( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex16* a,
             const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* alpha,
             MKL_Complex16* beta, MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
             const MKL_INT* ldvr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
             MKL_INT* info );
void zggev3_( const char* jobvl, const char* jobvr, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* alpha,
              MKL_Complex16* beta, MKL_Complex16* vl, const MKL_INT* ldvl, MKL_Complex16* vr,
              const MKL_INT* ldvr, MKL_Complex16* work, const MKL_INT* lwork, double* rwork,
              MKL_INT* info );

void DGGEV3( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* b, const MKL_INT* ldb, double* alphar, double* alphai, double* beta,
             double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void DGGEV3_( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb, double* alphar, double* alphai, double* beta,
              double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dggev3( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* b, const MKL_INT* ldb, double* alphar, double* alphai, double* beta,
             double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void dggev3_( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb, double* alphar, double* alphai, double* beta,
              double* vl, const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr, double* work,
              const MKL_INT* lwork, MKL_INT* info );

void SGGEV3( const char* jobvl, const char* jobvr, const MKL_INT* n, float* a, const MKL_INT* lda,
             float* b, const MKL_INT* ldb, float* alphar, float* alphai, float* beta,
             float* vl, const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr, float* work,
             const MKL_INT* lwork, MKL_INT* info );
void SGGEV3_( const char* jobvl, const char* jobvr, const MKL_INT* n, float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb, float* alphar, float* alphai, float* beta,
              float* vl, const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr, float* work,
              const MKL_INT* lwork, MKL_INT* info );
void sggev3( const char* jobvl, const char* jobvr, const MKL_INT* n, float* a, const MKL_INT* lda,
             float* b, const MKL_INT* ldb, float* alphar, float* alphai, float* beta,
             float* vl, const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr, float* work,
             const MKL_INT* lwork, MKL_INT* info );
void sggev3_( const char* jobvl, const char* jobvr, const MKL_INT* n, float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb, float* alphar, float* alphai, float* beta,
              float* vl, const MKL_INT* ldvl, float* vr, const MKL_INT* ldvr, float* work,
              const MKL_INT* lwork, MKL_INT* info );

void CUNM22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CUNM22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void cunm22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void cunm22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );

void ZUNM22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex16* q, const MKL_INT* ldq,
             MKL_Complex16* c, const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
             MKL_INT* info );
void ZUNM22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex16* q, const MKL_INT* ldq,
              MKL_Complex16* c, const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info );
void zunm22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex16* q, const MKL_INT* ldq,
             MKL_Complex16* c, const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
             MKL_INT* info );
void zunm22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const MKL_Complex16* q, const MKL_INT* ldq,
              MKL_Complex16* c, const MKL_INT* ldc, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info );

void CGGHD3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CGGHD3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cgghd3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cgghd3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void DGGHD3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             double* q, const MKL_INT* ldq, double* z, const MKL_INT* ldz, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void DGGHD3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              double* q, const MKL_INT* ldq, double* z, const MKL_INT* ldz, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dgghd3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             double* q, const MKL_INT* ldq, double* z, const MKL_INT* ldz, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void dgghd3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              double* q, const MKL_INT* ldq, double* z, const MKL_INT* ldz, double* work,
              const MKL_INT* lwork, MKL_INT* info );

void SGGHD3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
             float* q, const MKL_INT* ldq, float* z, const MKL_INT* ldz, float* work,
             const MKL_INT* lwork, MKL_INT* info );
void SGGHD3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
              float* q, const MKL_INT* ldq, float* z, const MKL_INT* ldz, float* work,
              const MKL_INT* lwork, MKL_INT* info );
void sgghd3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
             float* q, const MKL_INT* ldq, float* z, const MKL_INT* ldz, float* work,
             const MKL_INT* lwork, MKL_INT* info );
void sgghd3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
              float* q, const MKL_INT* ldq, float* z, const MKL_INT* ldz, float* work,
              const MKL_INT* lwork, MKL_INT* info );

void ZGGHD3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
             const MKL_INT* ldb, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* z,
             const MKL_INT* ldz, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZGGHD3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
              const MKL_INT* ldb, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* z,
              const MKL_INT* ldz, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zgghd3( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
             const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
             const MKL_INT* ldb, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* z,
             const MKL_INT* ldz, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zgghd3_( const char* compq, const char* compz, const MKL_INT* n, const MKL_INT* ilo,
              const MKL_INT* ihi, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
              const MKL_INT* ldb, MKL_Complex16* q, const MKL_INT* ldq, MKL_Complex16* z,
              const MKL_INT* ldz, MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void CGGES3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_C_SELECT_FUNCTION_2 selctg,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
             MKL_INT* info );
void CGGES3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_C_SELECT_FUNCTION_2 selctg,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
              MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
              MKL_INT* info );
void cgges3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_C_SELECT_FUNCTION_2 selctg,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
             MKL_INT* info );
void cgges3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_C_SELECT_FUNCTION_2 selctg,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
              MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
              MKL_INT* info );

void ZGGES3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_Z_SELECT_FUNCTION_2 selctg,
             const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
             const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex16* alpha, MKL_Complex16* beta,
             MKL_Complex16* vsl, const MKL_INT* ldvsl, MKL_Complex16* vsr, const MKL_INT* ldvsr,
             MKL_Complex16* work, const MKL_INT* lwork, double* rwork, MKL_INT* bwork,
             MKL_INT* info );
void ZGGES3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_Z_SELECT_FUNCTION_2 selctg,
              const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
              const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex16* alpha, MKL_Complex16* beta,
              MKL_Complex16* vsl, const MKL_INT* ldvsl, MKL_Complex16* vsr, const MKL_INT* ldvsr,
              MKL_Complex16* work, const MKL_INT* lwork, double* rwork, MKL_INT* bwork,
              MKL_INT* info );
void zgges3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_Z_SELECT_FUNCTION_2 selctg,
             const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
             const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex16* alpha, MKL_Complex16* beta,
             MKL_Complex16* vsl, const MKL_INT* ldvsl, MKL_Complex16* vsr, const MKL_INT* ldvsr,
             MKL_Complex16* work, const MKL_INT* lwork, double* rwork, MKL_INT* bwork,
             MKL_INT* info );
void zgges3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_Z_SELECT_FUNCTION_2 selctg,
              const MKL_INT* n, MKL_Complex16* a, const MKL_INT* lda, MKL_Complex16* b,
              const MKL_INT* ldb, MKL_INT* sdim, MKL_Complex16* alpha, MKL_Complex16* beta,
              MKL_Complex16* vsl, const MKL_INT* ldvsl, MKL_Complex16* vsr, const MKL_INT* ldvsr,
              MKL_Complex16* work, const MKL_INT* lwork, double* rwork, MKL_INT* bwork,
              MKL_INT* info );

void DGGES3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_D_SELECT_FUNCTION_3 selctg,
             const MKL_INT* n, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             MKL_INT* sdim, double* alphar, double* alphai, double* beta, double* vsl,
             const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr, double* work,
             const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void DGGES3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_D_SELECT_FUNCTION_3 selctg,
              const MKL_INT* n, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              MKL_INT* sdim, double* alphar, double* alphai, double* beta, double* vsl,
              const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr, double* work,
              const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void dgges3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_D_SELECT_FUNCTION_3 selctg,
             const MKL_INT* n, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             MKL_INT* sdim, double* alphar, double* alphai, double* beta, double* vsl,
             const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr, double* work,
             const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void dgges3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_D_SELECT_FUNCTION_3 selctg,
              const MKL_INT* n, double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              MKL_INT* sdim, double* alphar, double* alphai, double* beta, double* vsl,
              const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr, double* work,
              const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );

void SGGES3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_S_SELECT_FUNCTION_3 selctg,
             const MKL_INT* n, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
             MKL_INT* sdim, float* alphar, float* alphai, float* beta, float* vsl,
             const MKL_INT* ldvsl, float* vsr, const MKL_INT* ldvsr, float* work,
             const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void SGGES3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_S_SELECT_FUNCTION_3 selctg,
              const MKL_INT* n, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
              MKL_INT* sdim, float* alphar, float* alphai, float* beta, float* vsl,
              const MKL_INT* ldvsl, float* vsr, const MKL_INT* ldvsr, float* work,
              const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void sgges3( const char* jobvsl, const char* jobvsr, const char* sort, MKL_S_SELECT_FUNCTION_3 selctg,
             const MKL_INT* n, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
             MKL_INT* sdim, float* alphar, float* alphai, float* beta, float* vsl,
             const MKL_INT* ldvsl, float* vsr, const MKL_INT* ldvsr, float* work,
             const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void sgges3_( const char* jobvsl, const char* jobvsr, const char* sort, MKL_S_SELECT_FUNCTION_3 selctg,
              const MKL_INT* n, float* a, const MKL_INT* lda, float* b, const MKL_INT* ldb,
              MKL_INT* sdim, float* alphar, float* alphai, float* beta, float* vsl,
              const MKL_INT* ldvsl, float* vsr, const MKL_INT* ldvsr, float* work,
              const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );

void DORM22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const double* q, const MKL_INT* ldq,
             double* c, const MKL_INT* ldc, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void DORM22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const double* q, const MKL_INT* ldq,
              double* c, const MKL_INT* ldc, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void dorm22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const double* q, const MKL_INT* ldq,
             double* c, const MKL_INT* ldc, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void dorm22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const double* q, const MKL_INT* ldq,
              double* c, const MKL_INT* ldc, double* work, const MKL_INT* lwork,
              MKL_INT* info );

void SORM22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const float* q, const MKL_INT* ldq,
             float* c, const MKL_INT* ldc, float* work, const MKL_INT* lwork,
             MKL_INT* info );
void SORM22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const float* q, const MKL_INT* ldq,
              float* c, const MKL_INT* ldc, float* work, const MKL_INT* lwork,
              MKL_INT* info );
void sorm22( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, const MKL_INT* n2, const float* q, const MKL_INT* ldq,
             float* c, const MKL_INT* ldc, float* work, const MKL_INT* lwork,
             MKL_INT* info );
void sorm22_( const char* side, const char* trans, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, const MKL_INT* n2, const float* q, const MKL_INT* ldq,
              float* c, const MKL_INT* ldc, float* work, const MKL_INT* lwork,
              MKL_INT* info );


/* LAPACK 3.5.0 routines */

void CHECON_ROOK( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                  float* rcond, MKL_Complex8* work, MKL_INT* info );
void CHECON_ROOK_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                   float* rcond, MKL_Complex8* work, MKL_INT* info );
void checon_rook( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                  float* rcond, MKL_Complex8* work, MKL_INT* info );
void checon_rook_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                   float* rcond, MKL_Complex8* work, MKL_INT* info );

void CHESV_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info );
void CHESV_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info );
void chesv_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info );
void chesv_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info );

void CHETF2_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void CHETF2_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void chetf2_rook( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void chetf2_rook_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void CHETRF_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info );
void CHETRF_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info );
void chetrf_rook( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info );
void chetrf_rook_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info );

void CHETRI_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                  MKL_INT* info );
void CHETRI_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                   MKL_INT* info );
void chetri_rook( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                  MKL_INT* info );
void chetri_rook_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                   MKL_INT* info );

void CHETRS_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void CHETRS_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                    const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                    MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void chetrs_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                    const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                    MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void chetrs_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void CLAHEF_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void CLAHEF_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void clahef_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void clahef_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );

void CLASYF_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void CLASYF_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void clasyf_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void clasyf_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );

void CSYCON_ROOK( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                  float* rcond, MKL_Complex8* work, MKL_INT* info );
void CSYCON_ROOK_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                   float* rcond, MKL_Complex8* work, MKL_INT* info );
void csycon_rook( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                  float* rcond, MKL_Complex8* work, MKL_INT* info );
void csycon_rook_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                   float* rcond, MKL_Complex8* work, MKL_INT* info );

void CSYSV_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info );
void CSYSV_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info );
void csysv_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                 const MKL_INT* lwork, MKL_INT* info );
void csysv_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info );

void CSYTF2_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void CSYTF2_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void csytf2_rook( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void csytf2_rook_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void CSYTRF_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info );
void CSYTRF_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info );
void csytrf_rook( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                  const MKL_INT* lwork, MKL_INT* info );
void csytrf_rook_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
                   const MKL_INT* lwork, MKL_INT* info );

void CSYTRI_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                  MKL_INT* info );
void CSYTRI_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                   MKL_INT* info );
void csytri_rook( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                  MKL_INT* info );
void csytri_rook_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
                   MKL_INT* info );

void CSYTRS_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void CSYTRS_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void csytrs_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void csytrs_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void DLASYF_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, double* a, const MKL_INT* lda, MKL_INT* ipiv,
                  double* w, const MKL_INT* ldw, MKL_INT* info );
void DLASYF_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, double* a, const MKL_INT* lda, MKL_INT* ipiv,
                   double* w, const MKL_INT* ldw, MKL_INT* info );
void dlasyf_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, double* a, const MKL_INT* lda, MKL_INT* ipiv,
                  double* w, const MKL_INT* ldw, MKL_INT* info );
void dlasyf_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, double* a, const MKL_INT* lda, MKL_INT* ipiv,
                   double* w, const MKL_INT* ldw, MKL_INT* info );

void DSYCON_ROOK( const char* uplo, const MKL_INT* n, const double* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                  double* rcond, double* work, MKL_INT* iwork, MKL_INT* info );
void DSYCON_ROOK_( const char* uplo, const MKL_INT* n, const double* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                   double* rcond, double* work, MKL_INT* iwork, MKL_INT* info );
void dsycon_rook( const char* uplo, const MKL_INT* n, const double* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                  double* rcond, double* work, MKL_INT* iwork, MKL_INT* info );
void dsycon_rook_( const char* uplo, const MKL_INT* n, const double* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                   double* rcond, double* work, MKL_INT* iwork, MKL_INT* info );

void DSYSV_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* a,
                 const MKL_INT* lda, MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                 double* work, const MKL_INT* lwork, MKL_INT* info );
void DSYSV_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  double* a, const MKL_INT* lda, MKL_INT* ipiv, double* b,
                  const MKL_INT* ldb, double* work, const MKL_INT* lwork,
                  MKL_INT* info );
void dsysv_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, double* a,
                 const MKL_INT* lda, MKL_INT* ipiv, double* b, const MKL_INT* ldb,
                 double* work, const MKL_INT* lwork, MKL_INT* info );
void dsysv_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  double* a, const MKL_INT* lda, MKL_INT* ipiv, double* b,
                  const MKL_INT* ldb, double* work, const MKL_INT* lwork,
                  MKL_INT* info );

void DSYTF2_ROOK( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
                  MKL_INT* ipiv, MKL_INT* info );
void DSYTF2_ROOK_( const char* uplo, const MKL_INT* n, double* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void dsytf2_rook( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
                  MKL_INT* ipiv, MKL_INT* info );
void dsytf2_rook_( const char* uplo, const MKL_INT* n, double* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void DSYTRF_ROOK( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
                  MKL_INT* ipiv, double* work, const MKL_INT* lwork,
                  MKL_INT* info );
void DSYTRF_ROOK_( const char* uplo, const MKL_INT* n, double* a,
                   const MKL_INT* lda, MKL_INT* ipiv, double* work,
                   const MKL_INT* lwork, MKL_INT* info );
void dsytrf_rook( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
                  MKL_INT* ipiv, double* work, const MKL_INT* lwork,
                  MKL_INT* info );
void dsytrf_rook_( const char* uplo, const MKL_INT* n, double* a,
                  const MKL_INT* lda, MKL_INT* ipiv, double* work,
                  const MKL_INT* lwork, MKL_INT* info );

void DSYTRI_ROOK( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
                  const MKL_INT* ipiv, double* work, MKL_INT* info );
void DSYTRI_ROOK_( const char* uplo, const MKL_INT* n, double* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, double* work,
                   MKL_INT* info );
void dsytri_rook( const char* uplo, const MKL_INT* n, double* a, const MKL_INT* lda,
                  const MKL_INT* ipiv, double* work, MKL_INT* info );
void dsytri_rook_( const char* uplo, const MKL_INT* n, double* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, double* work,
                   MKL_INT* info );

void DSYTRS_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  double* b, const MKL_INT* ldb, MKL_INT* info );
void DSYTRS_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   double* b, const MKL_INT* ldb, MKL_INT* info );
void dsytrs_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  double* b, const MKL_INT* ldb, MKL_INT* info );
void dsytrs_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   double* b, const MKL_INT* ldb, MKL_INT* info );

void SLASYF_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                  float* w, const MKL_INT* ldw, MKL_INT* info );
void SLASYF_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                   float* w, const MKL_INT* ldw, MKL_INT* info );
void slasyf_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                  float* w, const MKL_INT* ldw, MKL_INT* info );
void slasyf_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, float* a, const MKL_INT* lda, MKL_INT* ipiv,
                   float* w, const MKL_INT* ldw, MKL_INT* info );

void SSYCON_ROOK( const char* uplo, const MKL_INT* n, const float* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                  float* rcond, float* work, MKL_INT* iwork, MKL_INT* info );
void SSYCON_ROOK_( const char* uplo, const MKL_INT* n, const float* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                   float* rcond, float* work, MKL_INT* iwork, MKL_INT* info );
void ssycon_rook( const char* uplo, const MKL_INT* n, const float* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                  float* rcond, float* work, MKL_INT* iwork, MKL_INT* info );
void ssycon_rook_( const char* uplo, const MKL_INT* n, const float* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
                   float* rcond, float* work, MKL_INT* iwork, MKL_INT* info );

void SSYSV_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a,
                 const MKL_INT* lda, MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                 float* work, const MKL_INT* lwork, MKL_INT* info );
void SSYSV_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a,
                  const MKL_INT* lda, MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                  float* work, const MKL_INT* lwork, MKL_INT* info );
void ssysv_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a,
                 const MKL_INT* lda, MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                 float* work, const MKL_INT* lwork, MKL_INT* info );
void ssysv_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs, float* a,
                  const MKL_INT* lda, MKL_INT* ipiv, float* b, const MKL_INT* ldb,
                  float* work, const MKL_INT* lwork, MKL_INT* info );

void SSYTF2_ROOK( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                  MKL_INT* ipiv, MKL_INT* info );
void SSYTF2_ROOK_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                   MKL_INT* ipiv, MKL_INT* info );
void ssytf2_rook( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                  MKL_INT* ipiv, MKL_INT* info );
void ssytf2_rook_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                   MKL_INT* ipiv, MKL_INT* info );

void SSYTRF_ROOK( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                 MKL_INT* ipiv, float* work, const MKL_INT* lwork, MKL_INT* info );
void SSYTRF_ROOK_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                   MKL_INT* ipiv, float* work, const MKL_INT* lwork,
                   MKL_INT* info );
void ssytrf_rook( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                  MKL_INT* ipiv, float* work, const MKL_INT* lwork, MKL_INT* info );
void ssytrf_rook_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                   MKL_INT* ipiv, float* work, const MKL_INT* lwork,
                   MKL_INT* info );

void SSYTRI_ROOK( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                  const MKL_INT* ipiv, float* work, MKL_INT* info );
void SSYTRI_ROOK_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                   const MKL_INT* ipiv, float* work, MKL_INT* info );
void ssytri_rook( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                  const MKL_INT* ipiv, float* work, MKL_INT* info );
void ssytri_rook_( const char* uplo, const MKL_INT* n, float* a, const MKL_INT* lda,
                   const MKL_INT* ipiv, float* work, MKL_INT* info );

void SSYTRS_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const float* a, const MKL_INT* lda, const MKL_INT* ipiv, float* b,
                  const MKL_INT* ldb, MKL_INT* info );
void SSYTRS_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   float* b, const MKL_INT* ldb, MKL_INT* info );
void ssytrs_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const float* a, const MKL_INT* lda, const MKL_INT* ipiv, float* b,
                  const MKL_INT* ldb, MKL_INT* info );
void ssytrs_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   float* b, const MKL_INT* ldb, MKL_INT* info );

void ZHECON_ROOK( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                  double* rcond, MKL_Complex16* work, MKL_INT* info );
void ZHECON_ROOK_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                   double* rcond, MKL_Complex16* work, MKL_INT* info );
void zhecon_rook( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                  double* rcond, MKL_Complex16* work, MKL_INT* info );
void zhecon_rook_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                   double* rcond, MKL_Complex16* work, MKL_INT* info );

void ZHESV_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info );
void ZHESV_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info );
void zhesv_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info );
void zhesv_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info );

void ZHETF2_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void ZHETF2_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void zhetf2_rook( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void zhetf2_rook_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void ZHETRF_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info );
void ZHETRF_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                   const MKL_INT* lwork, MKL_INT* info );
void zhetrf_rook( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info );
void zhetrf_rook_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                   const MKL_INT* lwork, MKL_INT* info );

void ZHETRI_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                  MKL_INT* info );
void ZHETRI_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                   MKL_INT* info );
void zhetri_rook( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                  MKL_INT* info );
void zhetri_rook_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                   MKL_INT* info );

void ZHETRS_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void ZHETRS_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void zhetrs_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void zhetrs_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );

void ZLAHEF_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void ZLAHEF_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void zlahef_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void zlahef_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );

void ZLASYF_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void ZLASYF_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void zlasyf_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                  MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );
void zlasyf_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
                   MKL_INT* kb, MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                   MKL_Complex16* w, const MKL_INT* ldw, MKL_INT* info );

void ZSYCON_ROOK( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                  double* rcond, MKL_Complex16* work, MKL_INT* info );
void ZSYCON_ROOK_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                   double* rcond, MKL_Complex16* work, MKL_INT* info );
void zsycon_rook( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                  double* rcond, MKL_Complex16* work, MKL_INT* info );
void zsycon_rook_( const char* uplo, const MKL_INT* n, const MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, const double* anorm,
                   double* rcond, MKL_Complex16* work, MKL_INT* info );

void ZSYSV_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info );
void ZSYSV_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info );
void zsysv_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                 MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                 MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                 const MKL_INT* lwork, MKL_INT* info );
void zsysv_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  MKL_Complex16* a, const MKL_INT* lda, MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info );

void ZSYTF2_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void ZSYTF2_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void zsytf2_rook( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void zsytf2_rook_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void ZSYTRF_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info );
void ZSYTRF_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                   const MKL_INT* lwork, MKL_INT* info );
void zsytrf_rook( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                  const MKL_INT* lwork, MKL_INT* info );
void zsytrf_rook_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex16* work,
                   const MKL_INT* lwork, MKL_INT* info );

void ZSYTRI_ROOK( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                  MKL_INT* info );
void ZSYTRI_ROOK_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                   MKL_INT* info );
void zsytri_rook( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                  const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                  MKL_INT* info );
void zsytri_rook_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                   const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
                   MKL_INT* info );

void ZSYTRS_ROOK( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void ZSYTRS_ROOK_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void zsytrs_rook( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                  const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                  MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );
void zsytrs_rook_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
                   const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
                   MKL_Complex16* b, const MKL_INT* ldb, MKL_INT* info );

void CUNBDB1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CUNBDB1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunbdb1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunbdb1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CUNBDB2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CUNBDB2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunbdb2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunbdb2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CUNBDB3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CUNBDB3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunbdb3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunbdb3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CUNBDB4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* phantom, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void CUNBDB4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* phantom, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info );
void cunbdb4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
              MKL_Complex8* phantom, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void cunbdb4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               MKL_Complex8* taup1, MKL_Complex8* taup2, MKL_Complex8* tauq1,
               MKL_Complex8* phantom, MKL_Complex8* work, const MKL_INT* lwork,
               MKL_INT* info );

void CUNBDB5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
              const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
              MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void CUNBDB5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
               const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
               MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );
void cunbdb5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
              const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
              MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void cunbdb5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
               const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
               MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );

void CUNBDB6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
              const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
              MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void CUNBDB6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
               const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
               MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );
void cunbdb6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
              const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
              MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void cunbdb6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex8* x1, const MKL_INT* incx1, MKL_Complex8* x2,
               const MKL_INT* incx2, MKL_Complex8* q1, const MKL_INT* ldq1,
               MKL_Complex8* q2, const MKL_INT* ldq2, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );

void CUNCSD2BY1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                 const MKL_INT* ldx21, float* theta, MKL_Complex8* u1,
                 const MKL_INT* ldu1, MKL_Complex8* u2, const MKL_INT* ldu2,
                 MKL_Complex8* v1t, const MKL_INT* ldv1t, MKL_Complex8* work,
                 const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                 MKL_INT* iwork, MKL_INT* info );
void CUNCSD2BY1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                  const MKL_INT* ldx21, float* theta, MKL_Complex8* u1,
                  const MKL_INT* ldu1, MKL_Complex8* u2, const MKL_INT* ldu2,
                  MKL_Complex8* v1t, const MKL_INT* ldv1t, MKL_Complex8* work,
                  const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                  MKL_INT* iwork, MKL_INT* info );
void cuncsd2by1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                 const MKL_INT* ldx21, float* theta, MKL_Complex8* u1,
                 const MKL_INT* ldu1, MKL_Complex8* u2, const MKL_INT* ldu2,
                 MKL_Complex8* v1t, const MKL_INT* ldv1t, MKL_Complex8* work,
                 const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                 MKL_INT* iwork, MKL_INT* info );
void cuncsd2by1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x21,
                  const MKL_INT* ldx21, float* theta, MKL_Complex8* u1,
                  const MKL_INT* ldu1, MKL_Complex8* u2, const MKL_INT* ldu2,
                  MKL_Complex8* v1t, const MKL_INT* ldv1t, MKL_Complex8* work,
                  const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
                  MKL_INT* iwork, MKL_INT* info );

void DORBDB1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* work, const MKL_INT* lwork, MKL_INT* info );
void DORBDB1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* work, const MKL_INT* lwork, MKL_INT* info );
void dorbdb1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* work, const MKL_INT* lwork, MKL_INT* info );
void dorbdb1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* work, const MKL_INT* lwork, MKL_INT* info );

void DORBDB2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* work, const MKL_INT* lwork, MKL_INT* info );
void DORBDB2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* work, const MKL_INT* lwork, MKL_INT* info );
void dorbdb2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* work, const MKL_INT* lwork, MKL_INT* info );
void dorbdb2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* work, const MKL_INT* lwork, MKL_INT* info );

void DORBDB3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* work, const MKL_INT* lwork, MKL_INT* info );
void DORBDB3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* work, const MKL_INT* lwork, MKL_INT* info );
void dorbdb3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* work, const MKL_INT* lwork, MKL_INT* info );
void dorbdb3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* work, const MKL_INT* lwork, MKL_INT* info );

void DORBDB4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* phantom, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void DORBDB4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* phantom, double* work, const MKL_INT* lwork,
               MKL_INT* info );
void dorbdb4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              double* x11, const MKL_INT* ldx11, double* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              double* taup1, double* taup2, double* tauq1,
              double* phantom, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void dorbdb4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               double* x11, const MKL_INT* ldx11, double* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               double* taup1, double* taup2, double* tauq1,
               double* phantom, double* work, const MKL_INT* lwork,
               MKL_INT* info );

void DORBDB5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              double* x1, const MKL_INT* incx1, double* x2,
              const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
              double* q2, const MKL_INT* ldq2, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void DORBDB5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               double* x1, const MKL_INT* incx1, double* x2,
               const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
               double* q2, const MKL_INT* ldq2, double* work,
               const MKL_INT* lwork, MKL_INT* info );
void dorbdb5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              double* x1, const MKL_INT* incx1, double* x2,
              const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
              double* q2, const MKL_INT* ldq2, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dorbdb5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               double* x1, const MKL_INT* incx1, double* x2,
               const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
               double* q2, const MKL_INT* ldq2, double* work,
               const MKL_INT* lwork, MKL_INT* info );

void DORBDB6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              double* x1, const MKL_INT* incx1, double* x2,
              const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
              double* q2, const MKL_INT* ldq2, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void DORBDB6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               double* x1, const MKL_INT* incx1, double* x2,
               const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
               double* q2, const MKL_INT* ldq2, double* work,
               const MKL_INT* lwork, MKL_INT* info );
void dorbdb6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              double* x1, const MKL_INT* incx1, double* x2,
              const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
              double* q2, const MKL_INT* ldq2, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dorbdb6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               double* x1, const MKL_INT* incx1, double* x2,
               const MKL_INT* incx2, double* q1, const MKL_INT* ldq1,
               double* q2, const MKL_INT* ldq2, double* work,
               const MKL_INT* lwork, MKL_INT* info );

void DORCSD2BY1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 double* x11, const MKL_INT* ldx11, double* x21,
                 const MKL_INT* ldx21, double* theta, double* u1,
                 const MKL_INT* ldu1, double* u2, const MKL_INT* ldu2,
                 double* v1t, const MKL_INT* ldv1t, double* work,
                 const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void DORCSD2BY1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  double* x11, const MKL_INT* ldx11, double* x21,
                  const MKL_INT* ldx21, double* theta, double* u1,
                  const MKL_INT* ldu1, double* u2, const MKL_INT* ldu2,
                  double* v1t, const MKL_INT* ldv1t, double* work,
                  const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void dorcsd2by1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 double* x11, const MKL_INT* ldx11, double* x21,
                 const MKL_INT* ldx21, double* theta, double* u1,
                 const MKL_INT* ldu1, double* u2, const MKL_INT* ldu2,
                 double* v1t, const MKL_INT* ldv1t, double* work,
                 const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void dorcsd2by1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  double* x11, const MKL_INT* ldx11, double* x21,
                  const MKL_INT* ldx21, double* theta, double* u1,
                  const MKL_INT* ldu1, double* u2, const MKL_INT* ldu2,
                  double* v1t, const MKL_INT* ldv1t, double* work,
                  const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );

void SORBDB1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* work, const MKL_INT* lwork, MKL_INT* info );
void SORBDB1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* work, const MKL_INT* lwork, MKL_INT* info );
void sorbdb1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* work, const MKL_INT* lwork, MKL_INT* info );
void sorbdb1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* work, const MKL_INT* lwork, MKL_INT* info );

void SORBDB2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* work, const MKL_INT* lwork, MKL_INT* info );
void SORBDB2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* work, const MKL_INT* lwork, MKL_INT* info );
void sorbdb2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* work, const MKL_INT* lwork, MKL_INT* info );
void sorbdb2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* work, const MKL_INT* lwork, MKL_INT* info );

void SORBDB3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* work, const MKL_INT* lwork, MKL_INT* info );
void SORBDB3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* work, const MKL_INT* lwork, MKL_INT* info );
void sorbdb3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* work, const MKL_INT* lwork, MKL_INT* info );
void sorbdb3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* work, const MKL_INT* lwork, MKL_INT* info );

void SORBDB4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* phantom, float* work, const MKL_INT* lwork,
              MKL_INT* info );
void SORBDB4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* phantom, float* work, const MKL_INT* lwork,
               MKL_INT* info );
void sorbdb4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              float* x11, const MKL_INT* ldx11, float* x21,
              const MKL_INT* ldx21, float* theta, float* phi,
              float* taup1, float* taup2, float* tauq1,
              float* phantom, float* work, const MKL_INT* lwork,
              MKL_INT* info );
void sorbdb4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               float* x11, const MKL_INT* ldx11, float* x21,
               const MKL_INT* ldx21, float* theta, float* phi,
               float* taup1, float* taup2, float* tauq1,
               float* phantom, float* work, const MKL_INT* lwork,
               MKL_INT* info );

void SORBDB5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              float* x1, const MKL_INT* incx1, float* x2,
              const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
              float* q2, const MKL_INT* ldq2, float* work,
              const MKL_INT* lwork, MKL_INT* info );
void SORBDB5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               float* x1, const MKL_INT* incx1, float* x2,
               const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
               float* q2, const MKL_INT* ldq2, float* work,
               const MKL_INT* lwork, MKL_INT* info );
void sorbdb5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              float* x1, const MKL_INT* incx1, float* x2,
              const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
              float* q2, const MKL_INT* ldq2, float* work,
              const MKL_INT* lwork, MKL_INT* info );
void sorbdb5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               float* x1, const MKL_INT* incx1, float* x2,
               const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
               float* q2, const MKL_INT* ldq2, float* work,
               const MKL_INT* lwork, MKL_INT* info );

void SORBDB6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              float* x1, const MKL_INT* incx1, float* x2,
              const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
              float* q2, const MKL_INT* ldq2, float* work,
              const MKL_INT* lwork, MKL_INT* info );
void SORBDB6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               float* x1, const MKL_INT* incx1, float* x2,
               const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
               float* q2, const MKL_INT* ldq2, float* work,
               const MKL_INT* lwork, MKL_INT* info );
void sorbdb6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              float* x1, const MKL_INT* incx1, float* x2,
              const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
              float* q2, const MKL_INT* ldq2, float* work,
              const MKL_INT* lwork, MKL_INT* info );
void sorbdb6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               float* x1, const MKL_INT* incx1, float* x2,
               const MKL_INT* incx2, float* q1, const MKL_INT* ldq1,
               float* q2, const MKL_INT* ldq2, float* work,
               const MKL_INT* lwork, MKL_INT* info );

void SORCSD2BY1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 float* x11, const MKL_INT* ldx11, float* x21,
                 const MKL_INT* ldx21, float* theta, float* u1,
                 const MKL_INT* ldu1, float* u2, const MKL_INT* ldu2,
                 float* v1t, const MKL_INT* ldv1t, float* work,
                 const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void SORCSD2BY1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  float* x11, const MKL_INT* ldx11, float* x21,
                  const MKL_INT* ldx21, float* theta, float* u1,
                  const MKL_INT* ldu1, float* u2, const MKL_INT* ldu2,
                  float* v1t, const MKL_INT* ldv1t, float* work,
                  const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void sorcsd2by1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 float* x11, const MKL_INT* ldx11, float* x21,
                 const MKL_INT* ldx21, float* theta, float* u1,
                 const MKL_INT* ldu1, float* u2, const MKL_INT* ldu2,
                 float* v1t, const MKL_INT* ldv1t, float* work,
                 const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void sorcsd2by1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  float* x11, const MKL_INT* ldx11, float* x21,
                  const MKL_INT* ldx21, float* theta, float* u1,
                  const MKL_INT* ldu1, float* u2, const MKL_INT* ldu2,
                  float* v1t, const MKL_INT* ldv1t, float* work,
                  const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );

void ZUNBDB1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZUNBDB1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zunbdb1( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zunbdb1_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void ZUNBDB2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZUNBDB2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zunbdb2( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zunbdb2_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void ZUNBDB3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void ZUNBDB3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zunbdb3( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );
void zunbdb3_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info );

void ZUNBDB4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* phantom, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info );
void ZUNBDB4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* phantom, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info );
void zunbdb4( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
              const MKL_INT* ldx21, double* theta, double* phi,
              MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
              MKL_Complex16* phantom, MKL_Complex16* work, const MKL_INT* lwork,
              MKL_INT* info );
void zunbdb4_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
               MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
               const MKL_INT* ldx21, double* theta, double* phi,
               MKL_Complex16* taup1, MKL_Complex16* taup2, MKL_Complex16* tauq1,
               MKL_Complex16* phantom, MKL_Complex16* work, const MKL_INT* lwork,
               MKL_INT* info );

void ZUNBDB5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
              const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
              MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info );
void ZUNBDB5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
               const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
               MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );
void zunbdb5( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
              const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
              MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info );
void zunbdb5_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
               const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
               MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );

void ZUNBDB6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
              const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
              MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info );
void ZUNBDB6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
               const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
               MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );
void zunbdb6( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
              MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
              const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
              MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info );
void zunbdb6_( const MKL_INT* m1, const MKL_INT* m2, const MKL_INT* n,
               MKL_Complex16* x1, const MKL_INT* incx1, MKL_Complex16* x2,
               const MKL_INT* incx2, MKL_Complex16* q1, const MKL_INT* ldq1,
               MKL_Complex16* q2, const MKL_INT* ldq2, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );

void ZUNCSD2BY1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                 const MKL_INT* ldx21, double* theta, MKL_Complex16* u1,
                 const MKL_INT* ldu1, MKL_Complex16* u2, const MKL_INT* ldu2,
                 MKL_Complex16* v1t, const MKL_INT* ldv1t, MKL_Complex16* work,
                 const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
                 MKL_INT* iwork, MKL_INT* info );
void ZUNCSD2BY1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                  const MKL_INT* ldx21, double* theta, MKL_Complex16* u1,
                  const MKL_INT* ldu1, MKL_Complex16* u2, const MKL_INT* ldu2,
                  MKL_Complex16* v1t, const MKL_INT* ldv1t, MKL_Complex16* work,
                  const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
                  MKL_INT* iwork, MKL_INT* info );
void zuncsd2by1( const char* jobu1, const char* jobu2, const char* jobv1t,
                 const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                 MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                 const MKL_INT* ldx21, double* theta, MKL_Complex16* u1,
                 const MKL_INT* ldu1, MKL_Complex16* u2, const MKL_INT* ldu2,
                 MKL_Complex16* v1t, const MKL_INT* ldv1t, MKL_Complex16* work,
                 const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
                 MKL_INT* iwork, MKL_INT* info );
void zuncsd2by1_( const char* jobu1, const char* jobu2, const char* jobv1t,
                  const MKL_INT* m, const MKL_INT* p, const MKL_INT* q,
                  MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x21,
                  const MKL_INT* ldx21, double* theta, MKL_Complex16* u1,
                  const MKL_INT* ldu1, MKL_Complex16* u2, const MKL_INT* ldu2,
                  MKL_Complex16* v1t, const MKL_INT* ldv1t, MKL_Complex16* work,
                  const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
                  MKL_INT* iwork, MKL_INT* info );

/* LAPACK 3.4.0 routines */

void CGEMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info );
void CGEMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt,
               MKL_Complex8* c, const MKL_INT* ldc,
               MKL_Complex8* work, MKL_INT* info );
void cgemqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info );
void cgemqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt,
               MKL_Complex8* c, const MKL_INT* ldc,
               MKL_Complex8* work, MKL_INT* info );

void DGEMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const double* v, const MKL_INT* ldv,
              const double* t, const MKL_INT* ldt,
              double* c, const MKL_INT* ldc, double* work, MKL_INT* info );
void DGEMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const double* v, const MKL_INT* ldv,
               const double* t, const MKL_INT* ldt,
               double* c, const MKL_INT* ldc, double* work, MKL_INT* info );
void dgemqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const double* v, const MKL_INT* ldv,
              const double* t, const MKL_INT* ldt,
              double* c, const MKL_INT* ldc, double* work, MKL_INT* info );
void dgemqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const double* v, const MKL_INT* ldv,
               const double* t, const MKL_INT* ldt,
               double* c, const MKL_INT* ldc, double* work, MKL_INT* info );

void SGEMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const float* v, const MKL_INT* ldv, const float* t,
              const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
              MKL_INT* info );
void SGEMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const float* v, const MKL_INT* ldv, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               MKL_INT* info );
void sgemqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const float* v, const MKL_INT* ldv, const float* t,
              const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
              MKL_INT* info );
void sgemqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const float* v, const MKL_INT* ldv, const float* t,
               const MKL_INT* ldt, float* c, const MKL_INT* ldc, float* work,
               MKL_INT* info );

void ZGEMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* c, const MKL_INT* ldc,
              MKL_Complex16* work, MKL_INT* info );
void ZGEMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt,
               MKL_Complex16* c, const MKL_INT* ldc,
               MKL_Complex16* work, MKL_INT* info );
void zgemqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* c, const MKL_INT* ldc,
              MKL_Complex16* work, MKL_INT* info );
void zgemqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
               const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt,
               MKL_Complex16* c, const MKL_INT* ldc,
               MKL_Complex16* work, MKL_INT* info );

void CGEQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* work, MKL_INT* info );

void CGEQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* work, MKL_INT* info );

void cgeqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* work, MKL_INT* info );

void cgeqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* work, MKL_INT* info );

void DGEQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             double* a, const MKL_INT* lda,
             double* t, const MKL_INT* ldt,
             double* work, MKL_INT* info );

void DGEQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              double* a, const MKL_INT* lda,
              double* t, const MKL_INT* ldt,
              double* work, MKL_INT* info );

void dgeqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             double* a, const MKL_INT* lda,
             double* t, const MKL_INT* ldt,
             double* work, MKL_INT* info );

void dgeqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              double* a, const MKL_INT* lda,
              double* t, const MKL_INT* ldt,
              double* work, MKL_INT* info );

void SGEQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             float* a, const MKL_INT* lda,
             float* t, const MKL_INT* ldt,
             float* work, MKL_INT* info );

void SGEQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              float* a, const MKL_INT* lda,
              float* t, const MKL_INT* ldt,
              float* work, MKL_INT* info );

void sgeqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             float* a, const MKL_INT* lda,
             float* t, const MKL_INT* ldt,
             float* work, MKL_INT* info );

void sgeqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              float* a, const MKL_INT* lda,
              float* t, const MKL_INT* ldt,
              float* work, MKL_INT* info );

void ZGEQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex16* a, const MKL_INT* lda,
             MKL_Complex16* t, const MKL_INT* ldt,
             MKL_Complex16* work, MKL_INT* info );

void ZGEQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* work, MKL_INT* info );

void zgeqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex16* a, const MKL_INT* lda,
             MKL_Complex16* t, const MKL_INT* ldt,
             MKL_Complex16* work, MKL_INT* info );

void zgeqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* work, MKL_INT* info );

void CGEQRT3( const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info );

void CGEQRT3_( const MKL_INT* m, const MKL_INT* n,
               MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info );

void cgeqrt3( const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info );

void cgeqrt3_( const MKL_INT* m, const MKL_INT* n,
               MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info );

void DGEQRT3( const MKL_INT* m, const MKL_INT* n,
              double* a, const MKL_INT* lda,
              double* t, const MKL_INT* ldt, MKL_INT* info );

void DGEQRT3_( const MKL_INT* m, const MKL_INT* n,
               double* a, const MKL_INT* lda,
               double* t, const MKL_INT* ldt, MKL_INT* info );

void dgeqrt3( const MKL_INT* m, const MKL_INT* n,
              double* a, const MKL_INT* lda,
              double* t, const MKL_INT* ldt, MKL_INT* info );

void dgeqrt3_( const MKL_INT* m, const MKL_INT* n,
               double* a, const MKL_INT* lda,
               double* t, const MKL_INT* ldt, MKL_INT* info );

void SGEQRT3( const MKL_INT* m, const MKL_INT* n,
              float* a, const MKL_INT* lda,
              float* t, const MKL_INT* ldt, MKL_INT* info );

void SGEQRT3_( const MKL_INT* m, const MKL_INT* n,
               float* a, const MKL_INT* lda,
               float* t, const MKL_INT* ldt, MKL_INT* info );

void sgeqrt3( const MKL_INT* m, const MKL_INT* n,
              float* a, const MKL_INT* lda,
              float* t, const MKL_INT* ldt, MKL_INT* info );

void sgeqrt3_( const MKL_INT* m, const MKL_INT* n,
               float* a, const MKL_INT* lda,
               float* t, const MKL_INT* ldt, MKL_INT* info );

void ZGEQRT3( const MKL_INT* m, const MKL_INT* n,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info );

void ZGEQRT3_( const MKL_INT* m, const MKL_INT* n,
               MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info );

void zgeqrt3( const MKL_INT* m, const MKL_INT* n,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info );

void zgeqrt3_( const MKL_INT* m, const MKL_INT* n,
               MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info );

void CTPMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* work, MKL_INT* info );

void CTPMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt,
               MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, MKL_INT* info );

void ctpmqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* work, MKL_INT* info );

void ctpmqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const MKL_Complex8* v, const MKL_INT* ldv,
               const MKL_Complex8* t, const MKL_INT* ldt,
               MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* work, MKL_INT* info );

void DTPMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const double* v, const MKL_INT* ldv,
              const double* t, const MKL_INT* ldt,
              double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb,
              double* work, MKL_INT* info );

void DTPMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const double* v, const MKL_INT* ldv,
               const double* t, const MKL_INT* ldt,
               double* a, const MKL_INT* lda,
               double* b, const MKL_INT* ldb,
               double* work, MKL_INT* info );

void dtpmqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const double* v, const MKL_INT* ldv,
              const double* t, const MKL_INT* ldt,
              double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb,
              double* work, MKL_INT* info );

void dtpmqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const double* v, const MKL_INT* ldv,
               const double* t, const MKL_INT* ldt,
               double* a, const MKL_INT* lda,
               double* b, const MKL_INT* ldb,
               double* work, MKL_INT* info );

void STPMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const float* v, const MKL_INT* ldv,
              const float* t, const MKL_INT* ldt,
              float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb,
              float* work, MKL_INT* info );

void STPMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const float* v, const MKL_INT* ldv,
               const float* t, const MKL_INT* ldt,
               float* a, const MKL_INT* lda,
               float* b, const MKL_INT* ldb,
               float* work, MKL_INT* info );

void stpmqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const float* v, const MKL_INT* ldv,
              const float* t, const MKL_INT* ldt,
              float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb,
              float* work, MKL_INT* info );

void stpmqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const float* v, const MKL_INT* ldv,
               const float* t, const MKL_INT* ldt,
               float* a, const MKL_INT* lda,
               float* b, const MKL_INT* ldb,
               float* work, MKL_INT* info );

void ZTPMQRT( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* work, MKL_INT* info );

void ZTPMQRT_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt,
               MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, MKL_INT* info );

void ztpmqrt( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
              const MKL_Complex16* v, const MKL_INT* ldv,
              const MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* work, MKL_INT* info );

void ztpmqrt_( const char* side, const char* trans, const MKL_INT* m,
               const MKL_INT* n, const MKL_INT* k, const MKL_INT* l, const MKL_INT* nb,
               const MKL_Complex16* v, const MKL_INT* ldv,
               const MKL_Complex16* t, const MKL_INT* ldt,
               MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* work, MKL_INT* info );

void CTPQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* work, MKL_INT* info );

void CTPQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* work, MKL_INT* info );

void ctpqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* work, MKL_INT* info );

void ctpqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* work, MKL_INT* info );

void DTPQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             double* a, const MKL_INT* lda,
             double* b, const MKL_INT* ldb,
             double* t, const MKL_INT* ldt,
             double* work, MKL_INT* info );

void DTPQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb,
              double* t, const MKL_INT* ldt,
              double* work, MKL_INT* info );

void dtpqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             double* a, const MKL_INT* lda,
             double* b, const MKL_INT* ldb,
             double* t, const MKL_INT* ldt,
             double* work, MKL_INT* info );

void dtpqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb,
              double* t, const MKL_INT* ldt,
              double* work, MKL_INT* info );

void STPQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             float* a, const MKL_INT* lda,
             float* b, const MKL_INT* ldb,
             float* t, const MKL_INT* ldt,
             float* work, MKL_INT* info );

void STPQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb,
              float* t, const MKL_INT* ldt,
              float* work, MKL_INT* info );

void stpqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             float* a, const MKL_INT* lda,
             float* b, const MKL_INT* ldb,
             float* t, const MKL_INT* ldt,
             float* work, MKL_INT* info );

void stpqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb,
              float* t, const MKL_INT* ldt,
              float* work, MKL_INT* info );

void ZTPQRT( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             MKL_Complex16* a, const MKL_INT* lda,
             MKL_Complex16* b, const MKL_INT* ldb,
             MKL_Complex16* t, const MKL_INT* ldt,
             MKL_Complex16* work, MKL_INT* info );

void ZTPQRT_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* work, MKL_INT* info );

void ztpqrt( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
             MKL_Complex16* a, const MKL_INT* lda,
             MKL_Complex16* b, const MKL_INT* ldb,
             MKL_Complex16* t, const MKL_INT* ldt,
             MKL_Complex16* work, MKL_INT* info );

void ztpqrt_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l, const MKL_INT* nb,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* t, const MKL_INT* ldt,
              MKL_Complex16* work, MKL_INT* info );

void CTPQRT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info );

void CTPQRT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info );

void ctpqrt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info );

void ctpqrt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* t, const MKL_INT* ldt, MKL_INT* info );

void DTPQRT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb,
              double* t, const MKL_INT* ldt, MKL_INT* info );

void DTPQRT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               double* a, const MKL_INT* lda,
               double* b, const MKL_INT* ldb,
               double* t, const MKL_INT* ldt, MKL_INT* info );

void dtpqrt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb,
              double* t, const MKL_INT* ldt, MKL_INT* info );

void dtpqrt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               double* a, const MKL_INT* lda,
               double* b, const MKL_INT* ldb,
               double* t, const MKL_INT* ldt, MKL_INT* info );

void STPQRT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb,
              float* t, const MKL_INT* ldt, MKL_INT* info );

void STPQRT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               float* a, const MKL_INT* lda,
               float* b, const MKL_INT* ldb,
               float* t, const MKL_INT* ldt, MKL_INT* info );

void stpqrt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              float* a, const MKL_INT* lda,
              float* b, const MKL_INT* ldb,
              float* t, const MKL_INT* ldt, MKL_INT* info );

void stpqrt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               float* a, const MKL_INT* lda,
               float* b, const MKL_INT* ldb,
               float* t, const MKL_INT* ldt, MKL_INT* info );

void ZTPQRT2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info );

void ZTPQRT2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info );

void ztpqrt2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex16* a, const MKL_INT* lda,
              MKL_Complex16* b, const MKL_INT* ldb,
              MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info );

void ztpqrt2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
               MKL_Complex16* a, const MKL_INT* lda,
               MKL_Complex16* b, const MKL_INT* ldb,
               MKL_Complex16* t, const MKL_INT* ldt, MKL_INT* info );

/* LAPACK 3.3.0 routines */

void CBBCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
             MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
             const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
             MKL_Complex8* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
             float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
             float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void CBBCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
              MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
              const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
              MKL_Complex8* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
              float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
              float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void cbbcsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
             MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
             const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
             MKL_Complex8* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
             float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
             float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void cbbcsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
              MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
              const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
              MKL_Complex8* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
              float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
              float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void ZBBCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
             MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
             const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
             MKL_Complex16* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
             double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
             double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void ZBBCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
              MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
              const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
              MKL_Complex16* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
              double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
              double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void zbbcsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
             MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
             const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
             MKL_Complex16* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
             double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
             double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void zbbcsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
              MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
              const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
              MKL_Complex16* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
              double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
              double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void SBBCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
             float* u1, const MKL_INT* ldu1, float* u2,
             const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
             float* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
             float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
             float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void SBBCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
              float* u1, const MKL_INT* ldu1, float* u2,
              const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
              float* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
              float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
              float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void sbbcsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
             float* u1, const MKL_INT* ldu1, float* u2,
             const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
             float* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
             float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
             float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void sbbcsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, float* theta, float* phi,
              float* u1, const MKL_INT* ldu1, float* u2,
              const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
              float* v2t, const MKL_INT* ldv2t, float* b11d, float* b11e,
              float* b12d, float* b12e, float* b21d, float* b21e, float* b22d,
              float* b22e, float* rwork, const MKL_INT* lrwork, MKL_INT* info );

void DBBCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
             double* u1, const MKL_INT* ldu1, double* u2,
             const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
             double* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
             double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
             double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void DBBCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
              double* u1, const MKL_INT* ldu1, double* u2,
              const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
              double* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
              double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
              double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void dbbcsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
             double* u1, const MKL_INT* ldu1, double* u2,
             const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
             double* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
             double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
             double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void dbbcsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, double* theta, double* phi,
              double* u1, const MKL_INT* ldu1, double* u2,
              const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
              double* v2t, const MKL_INT* ldv2t, double* b11d, double* b11e,
              double* b12d, double* b12e, double* b21d, double* b21e, double* b22d,
              double* b22e, double* rwork, const MKL_INT* lrwork, MKL_INT* info );

void CUNBDB( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, MKL_Complex8* x11,
             const MKL_INT* ldx11, MKL_Complex8* x12, const MKL_INT* ldx12,
             MKL_Complex8* x21, const MKL_INT* ldx21, MKL_Complex8* x22,
             const MKL_INT* ldx22, float* theta, float* phi, MKL_Complex8* taup1,
             MKL_Complex8* taup2, MKL_Complex8* tauq1, MKL_Complex8* tauq2,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);

void CUNBDB_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, MKL_Complex8* x11,
              const MKL_INT* ldx11, MKL_Complex8* x12, const MKL_INT* ldx12,
              MKL_Complex8* x21, const MKL_INT* ldx21, MKL_Complex8* x22,
              const MKL_INT* ldx22, float* theta, float* phi, MKL_Complex8* taup1,
              MKL_Complex8* taup2, MKL_Complex8* tauq1, MKL_Complex8* tauq2,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);

void cunbdb( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, MKL_Complex8* x11,
             const MKL_INT* ldx11, MKL_Complex8* x12, const MKL_INT* ldx12,
             MKL_Complex8* x21, const MKL_INT* ldx21, MKL_Complex8* x22,
             const MKL_INT* ldx22, float* theta, float* phi, MKL_Complex8* taup1,
             MKL_Complex8* taup2, MKL_Complex8* tauq1, MKL_Complex8* tauq2,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);

void cunbdb_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, MKL_Complex8* x11,
              const MKL_INT* ldx11, MKL_Complex8* x12, const MKL_INT* ldx12,
              MKL_Complex8* x21, const MKL_INT* ldx21, MKL_Complex8* x22,
              const MKL_INT* ldx22, float* theta, float* phi, MKL_Complex8* taup1,
              MKL_Complex8* taup2, MKL_Complex8* tauq1, MKL_Complex8* tauq2,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info);

void ZUNBDB( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, MKL_Complex16* x11,
             const MKL_INT* ldx11, MKL_Complex16* x12, const MKL_INT* ldx12,
             MKL_Complex16* x21, const MKL_INT* ldx21, MKL_Complex16* x22,
             const MKL_INT* ldx22, double* theta, double* phi, MKL_Complex16* taup1,
             MKL_Complex16* taup2, MKL_Complex16* tauq1, MKL_Complex16* tauq2,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void ZUNBDB_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, MKL_Complex16* x11,
              const MKL_INT* ldx11, MKL_Complex16* x12, const MKL_INT* ldx12,
              MKL_Complex16* x21, const MKL_INT* ldx21, MKL_Complex16* x22,
              const MKL_INT* ldx22, double* theta, double* phi, MKL_Complex16* taup1,
              MKL_Complex16* taup2, MKL_Complex16* tauq1, MKL_Complex16* tauq2,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void zunbdb( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, MKL_Complex16* x11,
             const MKL_INT* ldx11, MKL_Complex16* x12, const MKL_INT* ldx12,
             MKL_Complex16* x21, const MKL_INT* ldx21, MKL_Complex16* x22,
             const MKL_INT* ldx22, double* theta, double* phi, MKL_Complex16* taup1,
             MKL_Complex16* taup2, MKL_Complex16* tauq1, MKL_Complex16* tauq2,
             MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void zunbdb_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, MKL_Complex16* x11,
              const MKL_INT* ldx11, MKL_Complex16* x12, const MKL_INT* ldx12,
              MKL_Complex16* x21, const MKL_INT* ldx21, MKL_Complex16* x22,
              const MKL_INT* ldx22, double* theta, double* phi, MKL_Complex16* taup1,
              MKL_Complex16* taup2, MKL_Complex16* tauq1, MKL_Complex16* tauq2,
              MKL_Complex16* work, const MKL_INT* lwork, MKL_INT* info);

void SORBDB( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, float* x11,
             const MKL_INT* ldx11, float* x12, const MKL_INT* ldx12,
             float* x21, const MKL_INT* ldx21, float* x22,
             const MKL_INT* ldx22, float* theta, float* phi, float* taup1,
             float* taup2, float* tauq1, float* tauq2,
             float* work, const MKL_INT* lwork, MKL_INT* info);

void SORBDB_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, float* x11,
              const MKL_INT* ldx11, float* x12, const MKL_INT* ldx12,
              float* x21, const MKL_INT* ldx21, float* x22,
              const MKL_INT* ldx22, float* theta, float* phi, float* taup1,
              float* taup2, float* tauq1, float* tauq2,
              float* work, const MKL_INT* lwork, MKL_INT* info);

void sorbdb( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, float* x11,
             const MKL_INT* ldx11, float* x12, const MKL_INT* ldx12,
             float* x21, const MKL_INT* ldx21, float* x22,
             const MKL_INT* ldx22, float* theta, float* phi, float* taup1,
             float* taup2, float* tauq1, float* tauq2,
             float* work, const MKL_INT* lwork, MKL_INT* info);

void sorbdb_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, float* x11,
              const MKL_INT* ldx11, float* x12, const MKL_INT* ldx12,
              float* x21, const MKL_INT* ldx21, float* x22,
              const MKL_INT* ldx22, float* theta, float* phi, float* taup1,
              float* taup2, float* tauq1, float* tauq2,
              float* work, const MKL_INT* lwork, MKL_INT* info);

void DORBDB( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, double* x11,
             const MKL_INT* ldx11, double* x12, const MKL_INT* ldx12,
             double* x21, const MKL_INT* ldx21, double* x22,
             const MKL_INT* ldx22, double* theta, double* phi, double* taup1,
             double* taup2, double* tauq1, double* tauq2,
             double* work, const MKL_INT* lwork, MKL_INT* info);

void DORBDB_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, double* x11,
              const MKL_INT* ldx11, double* x12, const MKL_INT* ldx12,
              double* x21, const MKL_INT* ldx21, double* x22,
              const MKL_INT* ldx22, double* theta, double* phi, double* taup1,
              double* taup2, double* tauq1, double* tauq2,
              double* work, const MKL_INT* lwork, MKL_INT* info);

void dorbdb( const char* trans, const char* signs, const MKL_INT* M,
             const MKL_INT* P, const MKL_INT* Q, double* x11,
             const MKL_INT* ldx11, double* x12, const MKL_INT* ldx12,
             double* x21, const MKL_INT* ldx21, double* x22,
             const MKL_INT* ldx22, double* theta, double* phi, double* taup1,
             double* taup2, double* tauq1, double* tauq2,
             double* work, const MKL_INT* lwork, MKL_INT* info);

void dorbdb_( const char* trans, const char* signs, const MKL_INT* M,
              const MKL_INT* P, const MKL_INT* Q, double* x11,
              const MKL_INT* ldx11, double* x12, const MKL_INT* ldx12,
              double* x21, const MKL_INT* ldx21, double* x22,
              const MKL_INT* ldx22, double* theta, double* phi, double* taup1,
              double* taup2, double* tauq1, double* tauq2,
              double* work, const MKL_INT* lwork, MKL_INT* info);

void CUNCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x12,
             const MKL_INT* ldx12, MKL_Complex8* x21, const MKL_INT* ldx21,
             MKL_Complex8* x22, const MKL_INT* ldx22, float* theta,
             MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
             const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
             MKL_Complex8* v2t, const MKL_INT* ldv2t, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, MKL_INT* info);

void CUNCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x12,
              const MKL_INT* ldx12, MKL_Complex8* x21, const MKL_INT* ldx21,
              MKL_Complex8* x22, const MKL_INT* ldx22, float* theta,
              MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
              const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
              MKL_Complex8* v2t, const MKL_INT* ldv2t, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, MKL_INT* info);

void cuncsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x12,
             const MKL_INT* ldx12, MKL_Complex8* x21, const MKL_INT* ldx21,
             MKL_Complex8* x22, const MKL_INT* ldx22, float* theta,
             MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
             const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
             MKL_Complex8* v2t, const MKL_INT* ldv2t, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, MKL_INT* info);

void cuncsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              MKL_Complex8* x11, const MKL_INT* ldx11, MKL_Complex8* x12,
              const MKL_INT* ldx12, MKL_Complex8* x21, const MKL_INT* ldx21,
              MKL_Complex8* x22, const MKL_INT* ldx22, float* theta,
              MKL_Complex8* u1, const MKL_INT* ldu1, MKL_Complex8* u2,
              const MKL_INT* ldu2, MKL_Complex8* v1t, const MKL_INT* ldv1t,
              MKL_Complex8* v2t, const MKL_INT* ldv2t, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, MKL_INT* info);

void ZUNCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x12,
             const MKL_INT* ldx12, MKL_Complex16* x21, const MKL_INT* ldx21,
             MKL_Complex16* x22, const MKL_INT* ldx22, double* theta,
             MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
             const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
             MKL_Complex16* v2t, const MKL_INT* ldv2t, MKL_Complex16* work,
             const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, MKL_INT* info);

void ZUNCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x12,
              const MKL_INT* ldx12, MKL_Complex16* x21, const MKL_INT* ldx21,
              MKL_Complex16* x22, const MKL_INT* ldx22, double* theta,
              MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
              const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
              MKL_Complex16* v2t, const MKL_INT* ldv2t, MKL_Complex16* work,
              const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, MKL_INT* info);

void zuncsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x12,
             const MKL_INT* ldx12, MKL_Complex16* x21, const MKL_INT* ldx21,
             MKL_Complex16* x22, const MKL_INT* ldx22, double* theta,
             MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
             const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
             MKL_Complex16* v2t, const MKL_INT* ldv2t, MKL_Complex16* work,
             const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, MKL_INT* info);

void zuncsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              MKL_Complex16* x11, const MKL_INT* ldx11, MKL_Complex16* x12,
              const MKL_INT* ldx12, MKL_Complex16* x21, const MKL_INT* ldx21,
              MKL_Complex16* x22, const MKL_INT* ldx22, double* theta,
              MKL_Complex16* u1, const MKL_INT* ldu1, MKL_Complex16* u2,
              const MKL_INT* ldu2, MKL_Complex16* v1t, const MKL_INT* ldv1t,
              MKL_Complex16* v2t, const MKL_INT* ldv2t, MKL_Complex16* work,
              const MKL_INT* lwork, double* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, MKL_INT* info);

void SORCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             float* x11, const MKL_INT* ldx11, float* x12,
             const MKL_INT* ldx12, float* x21, const MKL_INT* ldx21,
             float* x22, const MKL_INT* ldx22, float* theta,
             float* u1, const MKL_INT* ldu1, float* u2,
             const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
             float* v2t, const MKL_INT* ldv2t, float* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);

void SORCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              float* x11, const MKL_INT* ldx11, float* x12,
              const MKL_INT* ldx12, float* x21, const MKL_INT* ldx21,
              float* x22, const MKL_INT* ldx22, float* theta,
              float* u1, const MKL_INT* ldu1, float* u2,
              const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
              float* v2t, const MKL_INT* ldv2t, float* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);

void sorcsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             float* x11, const MKL_INT* ldx11, float* x12,
             const MKL_INT* ldx12, float* x21, const MKL_INT* ldx21,
             float* x22, const MKL_INT* ldx22, float* theta,
             float* u1, const MKL_INT* ldu1, float* u2,
             const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
             float* v2t, const MKL_INT* ldv2t, float* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);

void sorcsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              float* x11, const MKL_INT* ldx11, float* x12,
              const MKL_INT* ldx12, float* x21, const MKL_INT* ldx21,
              float* x22, const MKL_INT* ldx22, float* theta,
              float* u1, const MKL_INT* ldu1, float* u2,
              const MKL_INT* ldu2, float* v1t, const MKL_INT* ldv1t,
              float* v2t, const MKL_INT* ldv2t, float* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);

void DORCSD( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             double* x11, const MKL_INT* ldx11, double* x12,
             const MKL_INT* ldx12, double* x21, const MKL_INT* ldx21,
             double* x22, const MKL_INT* ldx22, double* theta,
             double* u1, const MKL_INT* ldu1, double* u2,
             const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
             double* v2t, const MKL_INT* ldv2t, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);

void DORCSD_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              double* x11, const MKL_INT* ldx11, double* x12,
              const MKL_INT* ldx12, double* x21, const MKL_INT* ldx21,
              double* x22, const MKL_INT* ldx22, double* theta,
              double* u1, const MKL_INT* ldu1, double* u2,
              const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
              double* v2t, const MKL_INT* ldv2t, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);

void dorcsd( const char* jobu1, const char* jobu2, const char* jobv1t,
             const char* jobv2t, const char* trans, const char* signs,
             const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
             double* x11, const MKL_INT* ldx11, double* x12,
             const MKL_INT* ldx12, double* x21, const MKL_INT* ldx21,
             double* x22, const MKL_INT* ldx22, double* theta,
             double* u1, const MKL_INT* ldu1, double* u2,
             const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
             double* v2t, const MKL_INT* ldv2t, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);

void dorcsd_( const char* jobu1, const char* jobu2, const char* jobv1t,
              const char* jobv2t, const char* trans, const char* signs,
              const MKL_INT* M, const MKL_INT* P, const MKL_INT* Q,
              double* x11, const MKL_INT* ldx11, double* x12,
              const MKL_INT* ldx12, double* x21, const MKL_INT* ldx21,
              double* x22, const MKL_INT* ldx22, double* theta,
              double* u1, const MKL_INT* ldu1, double* u2,
              const MKL_INT* ldu2, double* v1t, const MKL_INT* ldv1t,
              double* v2t, const MKL_INT* ldv2t, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info);


void CLAPMR( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );
void CLAPMR_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );
void clapmr( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );
void clapmr_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );

void DLAPMR( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             double* x, const MKL_INT* ldx, MKL_INT* k );
void DLAPMR_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              double* x, const MKL_INT* ldx, MKL_INT* k );
void dlapmr( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             double* x, const MKL_INT* ldx, MKL_INT* k );
void dlapmr_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              double* x, const MKL_INT* ldx, MKL_INT* k );

void ZLAPMR( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex16* x, const MKL_INT* ldx, MKL_INT* k );
void ZLAPMR_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex16* x, const MKL_INT* ldx, MKL_INT* k );
void zlapmr( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex16* x, const MKL_INT* ldx, MKL_INT* k );
void zlapmr_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex16* x, const MKL_INT* ldx, MKL_INT* k );

void SLAPMR( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             float* x, const MKL_INT* ldx, MKL_INT* k );
void SLAPMR_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              float* x, const MKL_INT* ldx, MKL_INT* k );
void slapmr( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             float* x, const MKL_INT* ldx, MKL_INT* k );
void slapmr_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              float* x, const MKL_INT* ldx, MKL_INT* k );

void CSYCONV( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* e, MKL_INT* info );
void CSYCONV_( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* e, MKL_INT* info );
void csyconv( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* e, MKL_INT* info );
void csyconv_( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* e, MKL_INT* info );

void ZSYCONV( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* e, MKL_INT* info );
void ZSYCONV_( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* e, MKL_INT* info );
void zsyconv( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* e, MKL_INT* info );
void zsyconv_( const char* uplo, const char* way, const MKL_INT* n,
             MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* e, MKL_INT* info );

void SSYCONV( const char* uplo, const char* way, const MKL_INT* n,
             float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* e, MKL_INT* info );
void SSYCONV_( const char* uplo, const char* way, const MKL_INT* n,
             float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* e, MKL_INT* info );
void ssyconv( const char* uplo, const char* way, const MKL_INT* n,
             float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* e, MKL_INT* info );
void ssyconv_( const char* uplo, const char* way, const MKL_INT* n,
             float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* e, MKL_INT* info );

void DSYCONV( const char* uplo, const char* way, const MKL_INT* n,
             double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* e, MKL_INT* info );
void DSYCONV_( const char* uplo, const char* way, const MKL_INT* n,
             double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* e, MKL_INT* info );
void dsyconv( const char* uplo, const char* way, const MKL_INT* n,
             double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* e, MKL_INT* info );
void dsyconv_( const char* uplo, const char* way, const MKL_INT* n,
             double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* e, MKL_INT* info );

void CSYSWAPR( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void CSYSWAPR_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void csyswapr( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void csyswapr_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );

void ZSYSWAPR( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void ZSYSWAPR_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void zsyswapr( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void zsyswapr_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );

void SSYSWAPR( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void SSYSWAPR_( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void ssyswapr( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void ssyswapr_( const char* uplo, const MKL_INT* n, float* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );

void DSYSWAPR( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void DSYSWAPR_( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void dsyswapr( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );
void dsyswapr_( const char* uplo, const MKL_INT* n, double* a,
                const MKL_INT* lda, const MKL_INT* i1, const MKL_INT* i2 );

void CSYTRI2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void CSYTRI2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );
void csytri2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void csytri2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );

void ZSYTRI2( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info );
void ZSYTRI2_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );
void zsytri2( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
              const MKL_INT* lwork, MKL_INT* info );
void zsytri2_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
               const MKL_INT* lwork, MKL_INT* info );

void SSYTRI2( const char* uplo, const MKL_INT* n, float* a,
              const MKL_INT* lda, const MKL_INT* ipiv, float* work,
              const MKL_INT* lwork, MKL_INT* info );
void SSYTRI2_( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const MKL_INT* ipiv, float* work,
               const MKL_INT* lwork, MKL_INT* info );
void ssytri2( const char* uplo, const MKL_INT* n, float* a,
              const MKL_INT* lda, const MKL_INT* ipiv, float* work,
              const MKL_INT* lwork, MKL_INT* info );
void ssytri2_( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const MKL_INT* ipiv, float* work,
               const MKL_INT* lwork, MKL_INT* info );

void DSYTRI2( const char* uplo, const MKL_INT* n, double* a,
              const MKL_INT* lda, const MKL_INT* ipiv, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void DSYTRI2_( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const MKL_INT* ipiv, double* work,
               const MKL_INT* lwork, MKL_INT* info );
void dsytri2( const char* uplo, const MKL_INT* n, double* a,
              const MKL_INT* lda, const MKL_INT* ipiv, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dsytri2_( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const MKL_INT* ipiv, double* work,
               const MKL_INT* lwork, MKL_INT* info );

void CSYTRI2X( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              MKL_INT* nb, MKL_INT* info );
void CSYTRI2X_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
               MKL_INT* nb, MKL_INT* info );
void csytri2x( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              MKL_INT* nb, MKL_INT* info );
void csytri2x_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
               MKL_INT* nb, MKL_INT* info );

void ZSYTRI2X( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
              MKL_INT* nb, MKL_INT* info );
void ZSYTRI2X_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
               MKL_INT* nb, MKL_INT* info );
void zsytri2x( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
              MKL_INT* nb, MKL_INT* info );
void zsytri2x_( const char* uplo, const MKL_INT* n, MKL_Complex16* a,
               const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex16* work,
               MKL_INT* nb, MKL_INT* info );

void SSYTRI2X( const char* uplo, const MKL_INT* n, float* a,
              const MKL_INT* lda, const MKL_INT* ipiv, float* work,
              MKL_INT* nb, MKL_INT* info );
void SSYTRI2X_( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const MKL_INT* ipiv, float* work,
               MKL_INT* nb, MKL_INT* info );
void ssytri2x( const char* uplo, const MKL_INT* n, float* a,
              const MKL_INT* lda, const MKL_INT* ipiv, float* work,
              MKL_INT* nb, MKL_INT* info );
void ssytri2x_( const char* uplo, const MKL_INT* n, float* a,
               const MKL_INT* lda, const MKL_INT* ipiv, float* work,
               MKL_INT* nb, MKL_INT* info );

void DSYTRI2X( const char* uplo, const MKL_INT* n, double* a,
              const MKL_INT* lda, const MKL_INT* ipiv, double* work,
              MKL_INT* nb, MKL_INT* info );
void DSYTRI2X_( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const MKL_INT* ipiv, double* work,
               MKL_INT* nb, MKL_INT* info );
void dsytri2x( const char* uplo, const MKL_INT* n, double* a,
              const MKL_INT* lda, const MKL_INT* ipiv, double* work,
              MKL_INT* nb, MKL_INT* info );
void dsytri2x_( const char* uplo, const MKL_INT* n, double* a,
               const MKL_INT* lda, const MKL_INT* ipiv, double* work,
               MKL_INT* nb, MKL_INT* info );

void SLARTGP( float* f, float* g, float* cs, float* sn, float* r );
void SLARTGP_( float* f, float* g, float* cs, float* sn, float* r );
void slartgp( float* f, float* g, float* cs, float* sn, float* r );
void slartgp_( float* f, float* g, float* cs, float* sn, float* r );

void DLARTGP( double* f, double* g, double* cs, double* sn, double* r );
void DLARTGP_( double* f, double* g, double* cs, double* sn, double* r );
void dlartgp( double* f, double* g, double* cs, double* sn, double* r );
void dlartgp_( double* f, double* g, double* cs, double* sn, double* r );

void SLARTGS( const float* x, const float* y, const float* sigma, float* cs, float* sn );
void SLARTGS_( const float* x, const float* y, const float* sigma, float* cs, float* sn );
void slartgs( const float* x, const float* y, const float* sigma, float* cs, float* sn );
void slartgs_( const float* x, const float* y, const float* sigma, float* cs, float* sn );

void DLARTGS( const double* x, const double* y, const double* sigma, double* cs, double* sn );
void DLARTGS_( const double* x, const double* y, const double* sigma, double* cs, double* sn );
void dlartgs( const double* x, const double* y, const double* sigma, double* cs, double* sn );
void dlartgs_( const double* x, const double* y, const double* sigma, double* cs, double* sn );

void CSYTRS2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info );
void CSYTRS2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info );
void csytrs2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info );
void csytrs2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work, MKL_INT* info );

void ZSYTRS2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );
void ZSYTRS2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );
void zsytrs2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );
void zsytrs2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );

void SSYTRS2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* b, const MKL_INT* ldb, float* work, MKL_INT* info );
void SSYTRS2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* b, const MKL_INT* ldb, float* work, MKL_INT* info );
void ssytrs2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* b, const MKL_INT* ldb, float* work, MKL_INT* info );
void ssytrs2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* a, const MKL_INT* lda, const MKL_INT* ipiv,
             float* b, const MKL_INT* ldb, float* work, MKL_INT* info );

void DSYTRS2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* b, const MKL_INT* ldb, double* work, MKL_INT* info );
void DSYTRS2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* b, const MKL_INT* ldb, double* work, MKL_INT* info );
void dsytrs2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* b, const MKL_INT* ldb, double* work, MKL_INT* info );
void dsytrs2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* b, const MKL_INT* ldb, double* work, MKL_INT* info );

void CHETRS2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
              MKL_INT* info );
void CHETRS2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               MKL_INT* info );
void chetrs2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               MKL_INT* info );
void chetrs2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
               const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
               MKL_INT* info );

void ZHETRS2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );
void ZHETRS2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );
void zhetrs2( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );
void zhetrs2_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex16* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex16* b, const MKL_INT* ldb, MKL_Complex16* work, MKL_INT* info );

/* LAPACK 3.2 routines */

void CBDSQR( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
             const MKL_INT* nru, const MKL_INT* ncc, float* d, float* e,
             MKL_Complex8* vt, const MKL_INT* ldvt, MKL_Complex8* u,
             const MKL_INT* ldu, MKL_Complex8* c, const MKL_INT* ldc,
             float* rwork, MKL_INT* info );
void CBDSQR_( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
              const MKL_INT* nru, const MKL_INT* ncc, float* d, float* e,
              MKL_Complex8* vt, const MKL_INT* ldvt, MKL_Complex8* u,
              const MKL_INT* ldu, MKL_Complex8* c, const MKL_INT* ldc,
              float* rwork, MKL_INT* info );
void cbdsqr( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
             const MKL_INT* nru, const MKL_INT* ncc, float* d, float* e,
             MKL_Complex8* vt, const MKL_INT* ldvt, MKL_Complex8* u,
             const MKL_INT* ldu, MKL_Complex8* c, const MKL_INT* ldc,
             float* rwork, MKL_INT* info );
void cbdsqr_( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
              const MKL_INT* nru, const MKL_INT* ncc, float* d, float* e,
              MKL_Complex8* vt, const MKL_INT* ldvt, MKL_Complex8* u,
              const MKL_INT* ldu, MKL_Complex8* c, const MKL_INT* ldc,
              float* rwork, MKL_INT* info );

void CGBBRD( const char* vect, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
             MKL_Complex8* ab, const MKL_INT* ldab, float* d, float* e,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* pt,
             const MKL_INT* ldpt, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void CGBBRD_( const char* vect, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
              MKL_Complex8* ab, const MKL_INT* ldab, float* d, float* e,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* pt,
              const MKL_INT* ldpt, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgbbrd( const char* vect, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
             MKL_Complex8* ab, const MKL_INT* ldab, float* d, float* e,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* pt,
             const MKL_INT* ldpt, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgbbrd_( const char* vect, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
              MKL_Complex8* ab, const MKL_INT* ldab, float* d, float* e,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* pt,
              const MKL_INT* ldpt, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, float* rwork, MKL_INT* info );

void CGBCON( const char* norm, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
             const MKL_INT* ipiv, const float* anorm, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void CGBCON_( const char* norm, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_INT* ipiv, const float* anorm, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgbcon( const char* norm, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
             const MKL_INT* ipiv, const float* anorm, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgbcon_( const char* norm, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_INT* ipiv, const float* anorm, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info );

void CGBEQUB( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* r, float* c, float* rowcnd, float* colcnd, float* amax,
              MKL_INT* info );
void CGBEQUB_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
               const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* r, float* c, float* rowcnd, float* colcnd, float* amax,
               MKL_INT* info );
void cgbequb( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* r, float* c, float* rowcnd, float* colcnd, float* amax,
              MKL_INT* info );
void cgbequb_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
               const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* r, float* c, float* rowcnd, float* colcnd, float* amax,
               MKL_INT* info );

void CGBEQU( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
             float* r, float* c, float* rowcnd, float* colcnd, float* amax,
             MKL_INT* info );
void CGBEQU_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* r, float* c, float* rowcnd, float* colcnd, float* amax,
              MKL_INT* info );
void cgbequ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
             float* r, float* c, float* rowcnd, float* colcnd, float* amax,
             MKL_INT* info );
void cgbequ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* r, float* c, float* rowcnd, float* colcnd, float* amax,
              MKL_INT* info );

void CGBRFS( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
             const MKL_INT* ldab, const MKL_Complex8* afb,
             const MKL_INT* ldafb, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info );
void CGBRFS_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
              const MKL_INT* ldab, const MKL_Complex8* afb,
              const MKL_INT* ldafb, const MKL_INT* ipiv, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* ferr, float* berr, MKL_Complex8* work, float* rwork,
              MKL_INT* info );
void cgbrfs( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
             const MKL_INT* ldab, const MKL_Complex8* afb,
             const MKL_INT* ldafb, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info );
void cgbrfs_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
              const MKL_INT* ldab, const MKL_Complex8* afb,
              const MKL_INT* ldafb, const MKL_INT* ipiv, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* ferr, float* berr, MKL_Complex8* work, float* rwork,
              MKL_INT* info );

void CGBRFSX( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_Complex8* afb, const MKL_INT* ldafb,
              const MKL_INT* ipiv, const float* r, const float* c,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void CGBRFSX_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               const MKL_Complex8* ab, const MKL_INT* ldab,
               const MKL_Complex8* afb, const MKL_INT* ldafb,
               const MKL_INT* ipiv, const float* r, const float* c,
               const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgbrfsx( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_Complex8* afb, const MKL_INT* ldafb,
              const MKL_INT* ipiv, const float* r, const float* c,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgbrfsx_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               const MKL_Complex8* ab, const MKL_INT* ldab,
               const MKL_Complex8* afb, const MKL_INT* ldafb,
               const MKL_INT* ipiv, const float* r, const float* c,
               const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info );

void CGBSV( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
            const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
            MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
            MKL_INT* info );
void CGBSV_( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
             const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info );
void cgbsv( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
            const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
            MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
            MKL_INT* info );
void cgbsv_( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
             const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info );

void CGBSVX( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
             const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
             float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void CGBSVX_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
              float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgbsvx( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
             const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
             float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgbsvx_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
              float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info );

void CGBSVXX( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
              float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void CGBSVXX_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
               const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
               float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgbsvxx( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
              float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgbsvxx_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* afb,
               const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, float* r,
               float* c, MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info );

void CGBTF2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, MKL_INT* info );
void CGBTF2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info );
void cgbtf2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, MKL_INT* info );
void cgbtf2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info );

void CGBTRF( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, MKL_INT* info );
void CGBTRF_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info );
void cgbtrf( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, MKL_INT* info );
void cgbtrf_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info );

void CGBTRS( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
             const MKL_INT* ldab, const MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void CGBTRS_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
              const MKL_INT* ldab, const MKL_INT* ipiv, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );
void cgbtrs( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
             const MKL_INT* ldab, const MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void cgbtrs_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const MKL_Complex8* ab,
              const MKL_INT* ldab, const MKL_INT* ipiv, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );

void CGEBAK( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const float* scale,
             const MKL_INT* m, MKL_Complex8* v, const MKL_INT* ldv,
             MKL_INT* info );
void CGEBAK_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const float* scale,
              const MKL_INT* m, MKL_Complex8* v, const MKL_INT* ldv,
              MKL_INT* info );
void cgebak( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const float* scale,
             const MKL_INT* m, MKL_Complex8* v, const MKL_INT* ldv,
             MKL_INT* info );
void cgebak_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const float* scale,
              const MKL_INT* m, MKL_Complex8* v, const MKL_INT* ldv,
              MKL_INT* info );

void CGEBAL( const char* job, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ilo, MKL_INT* ihi, float* scale,
             MKL_INT* info );
void CGEBAL_( const char* job, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ilo, MKL_INT* ihi, float* scale,
              MKL_INT* info );
void cgebal( const char* job, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ilo, MKL_INT* ihi, float* scale,
             MKL_INT* info );
void cgebal_( const char* job, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ilo, MKL_INT* ihi, float* scale,
              MKL_INT* info );

void CGEBD2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
             MKL_Complex8* taup, MKL_Complex8* work, MKL_INT* info );
void CGEBD2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
              MKL_Complex8* taup, MKL_Complex8* work, MKL_INT* info );
void cgebd2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
             MKL_Complex8* taup, MKL_Complex8* work, MKL_INT* info );
void cgebd2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
              MKL_Complex8* taup, MKL_Complex8* work, MKL_INT* info );

void CGEBRD( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
             MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CGEBRD_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
              MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void cgebrd( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
             MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void cgebrd_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tauq,
              MKL_Complex8* taup, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );

void CGECON( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const float* anorm, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void CGECON_( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const float* anorm, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgecon( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const float* anorm, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgecon_( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const float* anorm, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info );

void CGEEQUB( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* r, float* c, float* rowcnd,
              float* colcnd, float* amax, MKL_INT* info );
void CGEEQUB_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* r, float* c, float* rowcnd,
               float* colcnd, float* amax, MKL_INT* info );
void cgeequb( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* r, float* c, float* rowcnd,
              float* colcnd, float* amax, MKL_INT* info );
void cgeequb_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* r, float* c, float* rowcnd,
               float* colcnd, float* amax, MKL_INT* info );

void CGEEQU( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, float* r, float* c, float* rowcnd,
             float* colcnd, float* amax, MKL_INT* info );
void CGEEQU_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* r, float* c, float* rowcnd,
              float* colcnd, float* amax, MKL_INT* info );
void cgeequ( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, float* r, float* c, float* rowcnd,
             float* colcnd, float* amax, MKL_INT* info );
void cgeequ_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* r, float* c, float* rowcnd,
              float* colcnd, float* amax, MKL_INT* info );

void CGEES( const char* jobvs, const char* sort,
            MKL_C_SELECT_FUNCTION_1 select, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_INT* sdim, MKL_Complex8* w,
            MKL_Complex8* vs, const MKL_INT* ldvs, MKL_Complex8* work,
            const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
            MKL_INT* info );
void CGEES_( const char* jobvs, const char* sort,
             MKL_C_SELECT_FUNCTION_1 select, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* sdim, MKL_Complex8* w,
             MKL_Complex8* vs, const MKL_INT* ldvs, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
             MKL_INT* info );
void cgees( const char* jobvs, const char* sort,
            MKL_C_SELECT_FUNCTION_1 select, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_INT* sdim, MKL_Complex8* w,
            MKL_Complex8* vs, const MKL_INT* ldvs, MKL_Complex8* work,
            const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
            MKL_INT* info );
void cgees_( const char* jobvs, const char* sort,
             MKL_C_SELECT_FUNCTION_1 select, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* sdim, MKL_Complex8* w,
             MKL_Complex8* vs, const MKL_INT* ldvs, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* bwork,
             MKL_INT* info );

void CGEESX( const char* jobvs, const char* sort,
             MKL_C_SELECT_FUNCTION_1 select, const char* sense,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* sdim, MKL_Complex8* w, MKL_Complex8* vs,
             const MKL_INT* ldvs, float* rconde, float* rcondv,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* bwork, MKL_INT* info );
void CGEESX_( const char* jobvs, const char* sort,
              MKL_C_SELECT_FUNCTION_1 select, const char* sense,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* sdim, MKL_Complex8* w, MKL_Complex8* vs,
              const MKL_INT* ldvs, float* rconde, float* rcondv,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* bwork, MKL_INT* info );
void cgeesx( const char* jobvs, const char* sort,
             MKL_C_SELECT_FUNCTION_1 select, const char* sense,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* sdim, MKL_Complex8* w, MKL_Complex8* vs,
             const MKL_INT* ldvs, float* rconde, float* rcondv,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* bwork, MKL_INT* info );
void cgeesx_( const char* jobvs, const char* sort,
              MKL_C_SELECT_FUNCTION_1 select, const char* sense,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* sdim, MKL_Complex8* w, MKL_Complex8* vs,
              const MKL_INT* ldvs, float* rconde, float* rcondv,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* bwork, MKL_INT* info );

void CGEEV( const char* jobvl, const char* jobvr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* w,
            MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
            const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info );
void CGEEV_( const char* jobvl, const char* jobvr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* w,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info );
void cgeev( const char* jobvl, const char* jobvr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* w,
            MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
            const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info );
void cgeev_( const char* jobvl, const char* jobvr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* w,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info );

void CGEEVX( const char* balanc, const char* jobvl, const char* jobvr,
             const char* sense, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* w, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,
             float* rconde, float* rcondv, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* info );
void CGEEVX_( const char* balanc, const char* jobvl, const char* jobvr,
              const char* sense, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* w, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,
              float* rconde, float* rcondv, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* info );
void cgeevx( const char* balanc, const char* jobvl, const char* jobvr,
             const char* sense, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* w, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,
             float* rconde, float* rcondv, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* info );
void cgeevx_( const char* balanc, const char* jobvl, const char* jobvr,
              const char* sense, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* w, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              MKL_INT* ilo, MKL_INT* ihi, float* scale, float* abnrm,
              float* rconde, float* rcondv, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* info );

void CGEGS( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
            const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info );
void CGEGS_( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
             const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info );
void cgegs( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
            const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info );
void cgegs_( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
             const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info );

void CGEGV( const char* jobvl, const char* jobvr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
            const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info );
void CGEGV_( const char* jobvl, const char* jobvr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info );
void cgegv( const char* jobvl, const char* jobvr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
            const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info );
void cgegv_( const char* jobvl, const char* jobvr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info );

void CGEHD2( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info );
void CGEHD2_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info );
void cgehd2( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info );
void cgehd2_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info );

void CGEHRD( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CGEHRD_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cgehrd( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cgehrd_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CGELQ2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info );
void CGELQ2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info );
void cgelq2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info );
void cgelq2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info );

void CGELQF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void CGELQF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void cgelqf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void cgelqf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );

void CGELSD( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* iwork, MKL_INT* info );
void CGELSD_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* iwork, MKL_INT* info );
void cgelsd( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* iwork, MKL_INT* info );
void cgelsd_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* iwork, MKL_INT* info );

void CGELS( const char* trans, const MKL_INT* m, const MKL_INT* n,
            const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
            const MKL_INT* lwork, MKL_INT* info );
void CGELS_( const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void cgels( const char* trans, const MKL_INT* m, const MKL_INT* n,
            const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
            const MKL_INT* lwork, MKL_INT* info );
void cgels_( const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );

void CGELSS( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info );
void CGELSS_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info );
void cgelss( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info );
void cgelss_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, float* s, const float* rcond, MKL_INT* rank,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info );

void CGELSX( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
             MKL_INT* rank, MKL_Complex8* work, float* rwork, MKL_INT* info );
void CGELSX_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
              MKL_INT* rank, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgelsx( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
             MKL_INT* rank, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgelsx_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
              MKL_INT* rank, MKL_Complex8* work, float* rwork, MKL_INT* info );

void CGELSY( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
             MKL_INT* rank, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info );
void CGELSY_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
              MKL_INT* rank, MKL_Complex8* work, const MKL_INT* lwork,
              float* rwork, MKL_INT* info );
void cgelsy( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
             MKL_INT* rank, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info );
void cgelsy_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* jpvt, const float* rcond,
              MKL_INT* rank, MKL_Complex8* work, const MKL_INT* lwork,
              float* rwork, MKL_INT* info );

void CGEQL2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info );
void CGEQL2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info );
void cgeql2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info );
void cgeql2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info );

void CGEQLF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void CGEQLF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void cgeqlf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void cgeqlf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );

void CGEQP3( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info );
void CGEQP3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info );
void cgeqp3( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info );
void cgeqp3_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info );

void CGEQPF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void CGEQPF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgeqpf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgeqpf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau,
              MKL_Complex8* work, float* rwork, MKL_INT* info );

void CGEQR2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info );
void CGEQR2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info );
void cgeqr2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info );
void cgeqr2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info );

void CGEQR2P( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info );
void CGEQR2P_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
               MKL_INT* info );
void cgeqr2p( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info );
void cgeqr2p_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
               MKL_INT* info );

void CGEQRF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void CGEQRF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void cgeqrf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void cgeqrf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );

void CGEQRFP( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void CGEQRFP_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );
void cgeqrfp( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void cgeqrfp_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
               const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
               const MKL_INT* lwork, MKL_INT* info );

void CGERFS( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info );
void CGERFS_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void cgerfs( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info );
void cgerfs_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );

void CGERFSX( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const float* r, const float* c, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* rcond, float* berr, const MKL_INT* n_err_bnds,
              float* err_bnds_norm, float* err_bnds_comp,
              const MKL_INT* nparams, float* params, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void CGERFSX_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf,
               const MKL_INT* ipiv, const float* r, const float* c,
               const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgerfsx( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const float* r, const float* c, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* rcond, float* berr, const MKL_INT* n_err_bnds,
              float* err_bnds_norm, float* err_bnds_comp,
              const MKL_INT* nparams, float* params, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void cgerfsx_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf,
               const MKL_INT* ipiv, const float* r, const float* c,
               const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info );

void CGERQ2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info );
void CGERQ2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info );
void cgerq2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             MKL_INT* info );
void cgerq2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              MKL_INT* info );

void CGERQF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void CGERQF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void cgerqf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void cgerqf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );

void CGESC2( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
             float* scale );
void CGESC2_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
              float* scale );
void cgesc2( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
             float* scale );
void cgesc2_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
              float* scale );

void CGESDD( const char* jobz, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u,
             const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* iwork, MKL_INT* info );
void CGESDD_( const char* jobz, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u,
              const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* iwork, MKL_INT* info );
void cgesdd( const char* jobz, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u,
             const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* iwork, MKL_INT* info );
void cgesdd_( const char* jobz, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, float* s, MKL_Complex8* u,
              const MKL_INT* ldu, MKL_Complex8* vt, const MKL_INT* ldvt,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* iwork, MKL_INT* info );

void CGESVD( const char* jobu, const char* jobvt, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s,
             MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
             const MKL_INT* ldvt, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info );
void CGESVD_( const char* jobu, const char* jobvt, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s,
              MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
              const MKL_INT* ldvt, MKL_Complex8* work, const MKL_INT* lwork,
              float* rwork, MKL_INT* info );
void cgesvd( const char* jobu, const char* jobvt, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s,
             MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
             const MKL_INT* ldvt, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info );
void cgesvd_( const char* jobu, const char* jobvt, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda, float* s,
              MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* vt,
              const MKL_INT* ldvt, MKL_Complex8* work, const MKL_INT* lwork,
              float* rwork, MKL_INT* info );

void CGESV( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a,
            const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info );
void CGESV_( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void cgesv( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a,
            const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info );
void cgesv_( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );

void CGESVX( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv, char* equed,
             float* r, float* c, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void CGESVX_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* r, float* c, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* rcond, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void cgesvx( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv, char* equed,
             float* r, float* c, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgesvx_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* r, float* c, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* rcond, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );

void CGESVXX( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* r, float* c, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* rcond, float* rpvgrw, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void CGESVXX_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
               char* equed, float* r, float* c, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
               float* rcond, float* rpvgrw, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgesvxx( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* r, float* c, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* rcond, float* rpvgrw, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgesvxx_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
               char* equed, float* r, float* c, MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
               float* rcond, float* rpvgrw, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info );

void CGETC2( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* ipiv, MKL_INT* jpiv, MKL_INT* info );
void CGETC2_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* jpiv, MKL_INT* info );
void cgetc2( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* ipiv, MKL_INT* jpiv, MKL_INT* info );
void cgetc2_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* ipiv, MKL_INT* jpiv, MKL_INT* info );

void CGETF2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void CGETF2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void cgetf2( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void cgetf2_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void CGETRF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void CGETRF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void cgetrf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void cgetrf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void MKL_CGETRFNPI( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                    MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void MKL_CGETRFNPI_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                     MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void mkl_cgetrfnpi( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                    MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void mkl_cgetrfnpi_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                     MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );

void CGETRI( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CGETRI_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void cgetri( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void cgetri_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const MKL_INT* ipiv, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );

void CGETRS( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void CGETRS_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void cgetrs( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void cgetrs_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void CGGBAK( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const float* lscale,
             const float* rscale, const MKL_INT* m, MKL_Complex8* v,
             const MKL_INT* ldv, MKL_INT* info );
void CGGBAK_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const float* lscale,
              const float* rscale, const MKL_INT* m, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_INT* info );
void cggbak( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const float* lscale,
             const float* rscale, const MKL_INT* m, MKL_Complex8* v,
             const MKL_INT* ldv, MKL_INT* info );
void cggbak_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const float* lscale,
              const float* rscale, const MKL_INT* m, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_INT* info );

void CGGBAL( const char* job, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
             float* work, MKL_INT* info );
void CGGBAL_( const char* job, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
              float* work, MKL_INT* info );
void cggbal( const char* job, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
             float* work, MKL_INT* info );
void cggbal_( const char* job, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
              float* work, MKL_INT* info );

void CGGES( const char* jobvsl, const char* jobvsr, const char* sort,
            MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
            MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
            const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* bwork, MKL_INT* info );
void CGGES_( const char* jobvsl, const char* jobvsr, const char* sort,
             MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
             const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* bwork, MKL_INT* info );
void cgges( const char* jobvsl, const char* jobvsr, const char* sort,
            MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n, MKL_Complex8* a,
            const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
            MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
            const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* bwork, MKL_INT* info );
void cgges_( const char* jobvsl, const char* jobvsr, const char* sort,
             MKL_C_SELECT_FUNCTION_2 selctg, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* sdim, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vsl, const MKL_INT* ldvsl, MKL_Complex8* vsr,
             const MKL_INT* ldvsr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* bwork, MKL_INT* info );

void CGGESX( const char* jobvsl, const char* jobvsr, const char* sort,
             MKL_C_SELECT_FUNCTION_2 selctg, const char* sense,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* sdim,
             MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
             const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
             float* rconde, float* rcondv, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
             const MKL_INT* liwork, MKL_INT* bwork, MKL_INT* info );
void CGGESX_( const char* jobvsl, const char* jobvsr, const char* sort,
              MKL_C_SELECT_FUNCTION_2 selctg, const char* sense,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* sdim,
              MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
              const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
              float* rconde, float* rcondv, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              const MKL_INT* liwork, MKL_INT* bwork, MKL_INT* info );
void cggesx( const char* jobvsl, const char* jobvsr, const char* sort,
             MKL_C_SELECT_FUNCTION_2 selctg, const char* sense,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* sdim,
             MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
             const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
             float* rconde, float* rcondv, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
             const MKL_INT* liwork, MKL_INT* bwork, MKL_INT* info );
void cggesx_( const char* jobvsl, const char* jobvsr, const char* sort,
              MKL_C_SELECT_FUNCTION_2 selctg, const char* sense,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* sdim,
              MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vsl,
              const MKL_INT* ldvsl, MKL_Complex8* vsr, const MKL_INT* ldvsr,
              float* rconde, float* rcondv, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              const MKL_INT* liwork, MKL_INT* bwork, MKL_INT* info );

void CGGEV( const char* jobvl, const char* jobvr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
            const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info );
void CGGEV_( const char* jobvl, const char* jobvr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info );
void cggev( const char* jobvl, const char* jobvr, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
            MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
            const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
            float* rwork, MKL_INT* info );
void cggev_( const char* jobvl, const char* jobvr, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info );

void CGGEVX( const char* balanc, const char* jobvl, const char* jobvr,
             const char* sense, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
             float* abnrm, float* bbnrm, float* rconde, float* rcondv,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* iwork, MKL_INT* bwork, MKL_INT* info );
void CGGEVX_( const char* balanc, const char* jobvl, const char* jobvr,
              const char* sense, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
              float* abnrm, float* bbnrm, float* rconde, float* rcondv,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* iwork, MKL_INT* bwork, MKL_INT* info );
void cggevx( const char* balanc, const char* jobvl, const char* jobvr,
             const char* sense, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
             float* abnrm, float* bbnrm, float* rconde, float* rcondv,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* iwork, MKL_INT* bwork, MKL_INT* info );
void cggevx_( const char* balanc, const char* jobvl, const char* jobvr,
              const char* sense, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              MKL_INT* ilo, MKL_INT* ihi, float* lscale, float* rscale,
              float* abnrm, float* bbnrm, float* rconde, float* rcondv,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* iwork, MKL_INT* bwork, MKL_INT* info );

void CGGGLM( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* d, MKL_Complex8* x,
             MKL_Complex8* y, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CGGGLM_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* d, MKL_Complex8* x,
              MKL_Complex8* y, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void cggglm( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* d, MKL_Complex8* x,
             MKL_Complex8* y, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void cggglm_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* d, MKL_Complex8* x,
              MKL_Complex8* y, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );

void CGGHRD( const char* compq, const char* compz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_INT* info );
void CGGHRD_( const char* compq, const char* compz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_INT* info );
void cgghrd( const char* compq, const char* compz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_INT* info );
void cgghrd_( const char* compq, const char* compz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_INT* info );

void CGGLSE( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* c, MKL_Complex8* d,
             MKL_Complex8* x, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CGGLSE_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* c, MKL_Complex8* d,
              MKL_Complex8* x, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void cgglse( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* c, MKL_Complex8* d,
             MKL_Complex8* x, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void cgglse_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* c, MKL_Complex8* d,
              MKL_Complex8* x, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );

void CGGQRF( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CGGQRF_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cggqrf( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cggqrf_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CGGRQF( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CGGRQF_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cggrqf( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cggrqf_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* taua,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* taub,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CGGSVD( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
             MKL_INT* l, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, float* alpha, float* beta, MKL_Complex8* u,
             const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
             float* rwork, MKL_INT* iwork, MKL_INT* info );
void CGGSVD_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
              MKL_INT* l, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, float* alpha, float* beta, MKL_Complex8* u,
              const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* info );
void cggsvd( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
             MKL_INT* l, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, float* alpha, float* beta, MKL_Complex8* u,
             const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
             float* rwork, MKL_INT* iwork, MKL_INT* info );
void cggsvd_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
              MKL_INT* l, MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, float* alpha, float* beta, MKL_Complex8* u,
              const MKL_INT* ldu, MKL_Complex8* v, const MKL_INT* ldv,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* info );

void CGGSVP( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, const float* tola, const float* tolb,
             MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
             MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q,
             const MKL_INT* ldq, MKL_INT* iwork, float* rwork,
             MKL_Complex8* tau, MKL_Complex8* work, MKL_INT* info );
void CGGSVP_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, const float* tola, const float* tolb,
              MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
              MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q,
              const MKL_INT* ldq, MKL_INT* iwork, float* rwork,
              MKL_Complex8* tau, MKL_Complex8* work, MKL_INT* info );
void cggsvp( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, const float* tola, const float* tolb,
             MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
             MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q,
             const MKL_INT* ldq, MKL_INT* iwork, float* rwork,
             MKL_Complex8* tau, MKL_Complex8* work, MKL_INT* info );
void cggsvp_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, const float* tola, const float* tolb,
              MKL_INT* k, MKL_INT* l, MKL_Complex8* u, const MKL_INT* ldu,
              MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* q,
              const MKL_INT* ldq, MKL_INT* iwork, float* rwork,
              MKL_Complex8* tau, MKL_Complex8* work, MKL_INT* info );

void CGTCON( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
             const MKL_Complex8* d, const MKL_Complex8* du,
             const MKL_Complex8* du2, const MKL_INT* ipiv, const float* anorm,
             float* rcond, MKL_Complex8* work, MKL_INT* info );
void CGTCON_( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du,
              const MKL_Complex8* du2, const MKL_INT* ipiv, const float* anorm,
              float* rcond, MKL_Complex8* work, MKL_INT* info );
void cgtcon( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
             const MKL_Complex8* d, const MKL_Complex8* du,
             const MKL_Complex8* du2, const MKL_INT* ipiv, const float* anorm,
             float* rcond, MKL_Complex8* work, MKL_INT* info );
void cgtcon_( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du,
              const MKL_Complex8* du2, const MKL_INT* ipiv, const float* anorm,
              float* rcond, MKL_Complex8* work, MKL_INT* info );

void CGTRFS( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* dlf,
             const MKL_Complex8* df, const MKL_Complex8* duf,
             const MKL_Complex8* du2, const MKL_INT* ipiv,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void CGTRFS_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* dl, const MKL_Complex8* d,
              const MKL_Complex8* du, const MKL_Complex8* dlf,
              const MKL_Complex8* df, const MKL_Complex8* duf,
              const MKL_Complex8* du2, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void cgtrfs( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* dlf,
             const MKL_Complex8* df, const MKL_Complex8* duf,
             const MKL_Complex8* du2, const MKL_INT* ipiv,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void cgtrfs_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* dl, const MKL_Complex8* d,
              const MKL_Complex8* du, const MKL_Complex8* dlf,
              const MKL_Complex8* df, const MKL_Complex8* duf,
              const MKL_Complex8* du2, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );

void CGTSV( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl,
            MKL_Complex8* d, MKL_Complex8* du, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info );
void CGTSV_( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl,
             MKL_Complex8* d, MKL_Complex8* du, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void cgtsv( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl,
            MKL_Complex8* d, MKL_Complex8* du, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info );
void cgtsv_( const MKL_INT* n, const MKL_INT* nrhs, MKL_Complex8* dl,
             MKL_Complex8* d, MKL_Complex8* du, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );

void CGTSVX( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* dl,
             const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* dlf,
             MKL_Complex8* df, MKL_Complex8* duf, MKL_Complex8* du2,
             MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void CGTSVX_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* dlf,
              MKL_Complex8* df, MKL_Complex8* duf, MKL_Complex8* du2,
              MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgtsvx( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* dl,
             const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* dlf,
             MKL_Complex8* df, MKL_Complex8* duf, MKL_Complex8* du2,
             MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cgtsvx_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du, MKL_Complex8* dlf,
              MKL_Complex8* df, MKL_Complex8* duf, MKL_Complex8* du2,
              MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );

void CGTTRF( const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d,
             MKL_Complex8* du, MKL_Complex8* du2, MKL_INT* ipiv,
             MKL_INT* info );
void CGTTRF_( const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d,
              MKL_Complex8* du, MKL_Complex8* du2, MKL_INT* ipiv,
              MKL_INT* info );
void cgttrf( const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d,
             MKL_Complex8* du, MKL_Complex8* du2, MKL_INT* ipiv,
             MKL_INT* info );
void cgttrf_( const MKL_INT* n, MKL_Complex8* dl, MKL_Complex8* d,
              MKL_Complex8* du, MKL_Complex8* du2, MKL_INT* ipiv,
              MKL_INT* info );

void CGTTRS( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* du2,
             const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info );
void CGTTRS_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* dl, const MKL_Complex8* d,
              const MKL_Complex8* du, const MKL_Complex8* du2,
              const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* info );
void cgttrs( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* du2,
             const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info );
void cgttrs_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* dl, const MKL_Complex8* d,
              const MKL_Complex8* du, const MKL_Complex8* du2,
              const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* info );

void CGTTS2( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* du2,
             const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb );
void CGTTS2_( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* dl, const MKL_Complex8* d,
              const MKL_Complex8* du, const MKL_Complex8* du2,
              const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb );
void cgtts2( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* du2,
             const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb );
void cgtts2_( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* dl, const MKL_Complex8* d,
              const MKL_Complex8* du, const MKL_Complex8* du2,
              const MKL_INT* ipiv, MKL_Complex8* b, const MKL_INT* ldb );

void CHBEVD( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void CHBEVD_( const char* jobz, const char* uplo, const MKL_INT* n,
              const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
              float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info );
void chbevd( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void chbevd_( const char* jobz, const char* uplo, const MKL_INT* n,
              const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
              float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info );

void CHBEV( const char* jobz, const char* uplo, const MKL_INT* n,
            const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab, float* w,
            MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
            float* rwork, MKL_INT* info );
void CHBEV_( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void chbev( const char* jobz, const char* uplo, const MKL_INT* n,
            const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab, float* w,
            MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
            float* rwork, MKL_INT* info );
void chbev_( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* info );

void CHBEVX( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void CHBEVX_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
              const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void chbevx( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void chbevx_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, const MKL_INT* kd, MKL_Complex8* ab,
              const MKL_INT* ldab, MKL_Complex8* q, const MKL_INT* ldq,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );

void CHBGST( const char* vect, const char* uplo, const MKL_INT* n,
             const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
             const MKL_INT* ldab, const MKL_Complex8* bb, const MKL_INT* ldbb,
             MKL_Complex8* x, const MKL_INT* ldx, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void CHBGST_( const char* vect, const char* uplo, const MKL_INT* n,
              const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
              const MKL_INT* ldab, const MKL_Complex8* bb, const MKL_INT* ldbb,
              MKL_Complex8* x, const MKL_INT* ldx, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void chbgst( const char* vect, const char* uplo, const MKL_INT* n,
             const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
             const MKL_INT* ldab, const MKL_Complex8* bb, const MKL_INT* ldbb,
             MKL_Complex8* x, const MKL_INT* ldx, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void chbgst_( const char* vect, const char* uplo, const MKL_INT* n,
              const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
              const MKL_INT* ldab, const MKL_Complex8* bb, const MKL_INT* ldbb,
              MKL_Complex8* x, const MKL_INT* ldx, MKL_Complex8* work,
              float* rwork, MKL_INT* info );

void CHBGVD( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void CHBGVD_( const char* jobz, const char* uplo, const MKL_INT* n,
              const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
              const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
              float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info );
void chbgvd( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void chbgvd_( const char* jobz, const char* uplo, const MKL_INT* n,
              const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
              const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
              float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info );

void CHBGV( const char* jobz, const char* uplo, const MKL_INT* n,
            const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
            const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
            float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
            float* rwork, MKL_INT* info );
void CHBGV_( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void chbgv( const char* jobz, const char* uplo, const MKL_INT* n,
            const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
            const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
            float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
            float* rwork, MKL_INT* info );
void chbgv_( const char* jobz, const char* uplo, const MKL_INT* n,
             const MKL_INT* ka, const MKL_INT* kb, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* bb, const MKL_INT* ldbb,
             float* w, MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* info );

void CHBGVX( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, const MKL_INT* ka, const MKL_INT* kb,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* bb,
             const MKL_INT* ldbb, MKL_Complex8* q, const MKL_INT* ldq,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void CHBGVX_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, const MKL_INT* ka, const MKL_INT* kb,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* bb,
              const MKL_INT* ldbb, MKL_Complex8* q, const MKL_INT* ldq,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void chbgvx( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, const MKL_INT* ka, const MKL_INT* kb,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* bb,
             const MKL_INT* ldbb, MKL_Complex8* q, const MKL_INT* ldq,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void chbgvx_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, const MKL_INT* ka, const MKL_INT* kb,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* bb,
              const MKL_INT* ldbb, MKL_Complex8* q, const MKL_INT* ldq,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );

void CHBTRD( const char* vect, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
             float* d, float* e, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* work, MKL_INT* info );
void CHBTRD_( const char* vect, const char* uplo, const MKL_INT* n,
              const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
              float* d, float* e, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* work, MKL_INT* info );
void chbtrd( const char* vect, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
             float* d, float* e, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* work, MKL_INT* info );
void chbtrd_( const char* vect, const char* uplo, const MKL_INT* n,
              const MKL_INT* kd, MKL_Complex8* ab, const MKL_INT* ldab,
              float* d, float* e, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* work, MKL_INT* info );

void CHECON( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
             float* rcond, MKL_Complex8* work, MKL_INT* info );
void CHECON_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
              float* rcond, MKL_Complex8* work, MKL_INT* info );
void checon( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
             float* rcond, MKL_Complex8* work, MKL_INT* info );
void checon_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
              float* rcond, MKL_Complex8* work, MKL_INT* info );

void CHEEQUB( char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* s, float* scond, float* amax,
              MKL_Complex8* work, MKL_INT* info );
void CHEEQUB_( char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* s, float* scond, float* amax,
               MKL_Complex8* work, MKL_INT* info );
void cheequb( char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* s, float* scond, float* amax,
              MKL_Complex8* work, MKL_INT* info );
void cheequb_( char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* s, float* scond, float* amax,
               MKL_Complex8* work, MKL_INT* info );

void CHEEVD( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void CHEEVD_( const char* jobz, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, float* w,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info );
void cheevd( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void cheevd_( const char* jobz, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, float* w,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info );

void CHEEV( const char* jobz, const char* uplo, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
            const MKL_INT* lwork, float* rwork, MKL_INT* info );
void CHEEV_( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* info );
void cheev( const char* jobz, const char* uplo, const MKL_INT* n,
            MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
            const MKL_INT* lwork, float* rwork, MKL_INT* info );
void cheev_( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* info );

void CHEEVR( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info );
void CHEEVR_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info );
void cheevr( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info );
void cheevr_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info );

void CHEEVX( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
             MKL_INT* ifail, MKL_INT* info );
void CHEEVX_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              MKL_INT* ifail, MKL_INT* info );
void cheevx( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
             MKL_INT* ifail, MKL_INT* info );
void cheevx_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              MKL_INT* ifail, MKL_INT* info );

void CHEGS2( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void CHEGS2_( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );
void chegs2( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void chegs2_( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );

void CHEGST( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void CHEGST_( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );
void chegst( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void chegst_( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );

void CHEGVD( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void CHEGVD_( const MKL_INT* itype, const char* jobz, const char* uplo,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, float* w,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info );
void chegvd( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void chegvd_( const MKL_INT* itype, const char* jobz, const char* uplo,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* b, const MKL_INT* ldb, float* w,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info );

void CHEGV( const MKL_INT* itype, const char* jobz, const char* uplo,
            const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
            MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
            const MKL_INT* lwork, float* rwork, MKL_INT* info );
void CHEGV_( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* info );
void chegv( const MKL_INT* itype, const char* jobz, const char* uplo,
            const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
            MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
            const MKL_INT* lwork, float* rwork, MKL_INT* info );
void chegv_( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* b, const MKL_INT* ldb, float* w, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* info );

void CHEGVX( const MKL_INT* itype, const char* jobz, const char* range,
             const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
             MKL_INT* ifail, MKL_INT* info );
void CHEGVX_( const MKL_INT* itype, const char* jobz, const char* range,
              const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              MKL_INT* ifail, MKL_INT* info );
void chegvx( const MKL_INT* itype, const char* jobz, const char* range,
             const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
             MKL_INT* ifail, MKL_INT* info );
void chegvx_( const MKL_INT* itype, const char* jobz, const char* range,
              const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, MKL_INT* iwork,
              MKL_INT* ifail, MKL_INT* info );

void CHERFS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info );
void CHERFS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void cherfs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info );
void cherfs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );

void CHERFSX( const char* uplo, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const float* s, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void CHERFSX_( const char* uplo, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf,
               const MKL_INT* ipiv, const float* s, const MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
               float* rcond, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info );
void cherfsx( const char* uplo, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const float* s, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void cherfsx_( const char* uplo, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf,
               const MKL_INT* ipiv, const float* s, const MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
               float* rcond, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info );

void CHESV( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
            const MKL_INT* lwork, MKL_INT* info );
void CHESV_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void chesv( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
            const MKL_INT* lwork, MKL_INT* info );
void chesv_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );

void CHESVX( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info );
void CHESVX_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info );
void chesvx( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info );
void chesvx_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info );

void CHESVXX( const char* fact, char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* rpvgrw,
              float* berr, const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void CHESVXX_( const char* fact, char* uplo, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
               char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* x, const MKL_INT* ldx, float* rcond,
               float* rpvgrw, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info );
void chesvxx( const char* fact, char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* rpvgrw,
              float* berr, const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void chesvxx_( const char* fact, char* uplo, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
               char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* x, const MKL_INT* ldx, float* rcond,
               float* rpvgrw, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info );

void CHETD2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
             MKL_INT* info );
void CHETD2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
              MKL_INT* info );
void chetd2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
             MKL_INT* info );
void chetd2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
              MKL_INT* info );

void CHETF2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void CHETF2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void chetf2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void chetf2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void CHETRD( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CHETRD_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void chetrd( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void chetrd_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, float* d, float* e, MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CHETRF( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void CHETRF_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void chetrf( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void chetrf_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );

void CHETRI( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
             MKL_INT* info );
void CHETRI_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              MKL_INT* info );
void chetri( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
             MKL_INT* info );
void chetri_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              MKL_INT* info );

void CHETRS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void CHETRS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void chetrs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void chetrs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void CHFRK( const char* transr, const char* uplo, const char* trans,
            const MKL_INT* n, const MKL_INT* k, const float* alpha,
            const MKL_Complex8* a, const MKL_INT* lda, const float* beta,
            MKL_Complex8* c );
void CHFRK_( const char* transr, const char* uplo, const char* trans,
             const MKL_INT* n, const MKL_INT* k, const float* alpha,
             const MKL_Complex8* a, const MKL_INT* lda, const float* beta,
             MKL_Complex8* c );
void chfrk( const char* transr, const char* uplo, const char* trans,
            const MKL_INT* n, const MKL_INT* k, const float* alpha,
            const MKL_Complex8* a, const MKL_INT* lda, const float* beta,
            MKL_Complex8* c );
void chfrk_( const char* transr, const char* uplo, const char* trans,
             const MKL_INT* n, const MKL_INT* k, const float* alpha,
             const MKL_Complex8* a, const MKL_INT* lda, const float* beta,
             MKL_Complex8* c );

void CHGEQZ( const char* job, const char* compq, const char* compz,
             const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info );
void CHGEQZ_( const char* job, const char* compq, const char* compz,
              const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* alpha, MKL_Complex8* beta,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
              float* rwork, MKL_INT* info );
void chgeqz( const char* job, const char* compq, const char* compz,
             const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* alpha, MKL_Complex8* beta,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
             float* rwork, MKL_INT* info );
void chgeqz_( const char* job, const char* compq, const char* compz,
              const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* h, const MKL_INT* ldh, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* alpha, MKL_Complex8* beta,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
              float* rwork, MKL_INT* info );

void CHLA_TRANSTYPE( char* ret_val, int ret_val_len, const MKL_INT* trans );
void CHLA_TRANSTYPE_( char* ret_val, int ret_val_len, const MKL_INT* trans );
void chla_transtype( char* ret_val, int ret_val_len, const MKL_INT* trans );
void chla_transtype_( char* ret_val, int ret_val_len, const MKL_INT* trans );

void CHPCON( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_INT* ipiv, const float* anorm, float* rcond,
             MKL_Complex8* work, MKL_INT* info );
void CHPCON_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_INT* ipiv, const float* anorm, float* rcond,
              MKL_Complex8* work, MKL_INT* info );
void chpcon( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_INT* ipiv, const float* anorm, float* rcond,
             MKL_Complex8* work, MKL_INT* info );
void chpcon_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_INT* ipiv, const float* anorm, float* rcond,
              MKL_Complex8* work, MKL_INT* info );

void CHPEVD( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info );
void CHPEVD_( const char* jobz, const char* uplo, const MKL_INT* n,
              MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info );
void chpevd( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info );
void chpevd_( const char* jobz, const char* uplo, const MKL_INT* n,
              MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              const MKL_INT* lrwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info );

void CHPEV( const char* jobz, const char* uplo, const MKL_INT* n,
            MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
            MKL_Complex8* work, float* rwork, MKL_INT* info );
void CHPEV_( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void chpev( const char* jobz, const char* uplo, const MKL_INT* n,
            MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
            MKL_Complex8* work, float* rwork, MKL_INT* info );
void chpev_( const char* jobz, const char* uplo, const MKL_INT* n,
             MKL_Complex8* ap, float* w, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_Complex8* work, float* rwork, MKL_INT* info );

void CHPEVX( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, MKL_Complex8* ap, const float* vl,
             const float* vu, const MKL_INT* il, const MKL_INT* iu,
             const float* abstol, MKL_INT* m, float* w, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, float* rwork,
             MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void CHPEVX_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, MKL_Complex8* ap, const float* vl,
              const float* vu, const MKL_INT* il, const MKL_INT* iu,
              const float* abstol, MKL_INT* m, float* w, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, float* rwork,
              MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void chpevx( const char* jobz, const char* range, const char* uplo,
             const MKL_INT* n, MKL_Complex8* ap, const float* vl,
             const float* vu, const MKL_INT* il, const MKL_INT* iu,
             const float* abstol, MKL_INT* m, float* w, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, float* rwork,
             MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void chpevx_( const char* jobz, const char* range, const char* uplo,
              const MKL_INT* n, MKL_Complex8* ap, const float* vl,
              const float* vu, const MKL_INT* il, const MKL_INT* iu,
              const float* abstol, MKL_INT* m, float* w, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, float* rwork,
              MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );

void CHPGST( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
             MKL_Complex8* ap, const MKL_Complex8* bp, MKL_INT* info );
void CHPGST_( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
              MKL_Complex8* ap, const MKL_Complex8* bp, MKL_INT* info );
void chpgst( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
             MKL_Complex8* ap, const MKL_Complex8* bp, MKL_INT* info );
void chpgst_( const MKL_INT* itype, const char* uplo, const MKL_INT* n,
              MKL_Complex8* ap, const MKL_Complex8* bp, MKL_INT* info );

void CHPGVD( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void CHPGVD_( const MKL_INT* itype, const char* jobz, const char* uplo,
              const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void chpgvd( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void chpgvd_( const MKL_INT* itype, const char* jobz, const char* uplo,
              const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );

void CHPGV( const MKL_INT* itype, const char* jobz, const char* uplo,
            const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
            MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
            float* rwork, MKL_INT* info );
void CHPGV_( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void chpgv( const MKL_INT* itype, const char* jobz, const char* uplo,
            const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
            MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
            float* rwork, MKL_INT* info );
void chpgv_( const MKL_INT* itype, const char* jobz, const char* uplo,
             const MKL_INT* n, MKL_Complex8* ap, MKL_Complex8* bp, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             float* rwork, MKL_INT* info );

void CHPGVX( const MKL_INT* itype, const char* jobz, const char* range,
             const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_Complex8* bp, const float* vl, const float* vu,
             const MKL_INT* il, const MKL_INT* iu, const float* abstol,
             MKL_INT* m, float* w, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* ifail,
             MKL_INT* info );
void CHPGVX_( const MKL_INT* itype, const char* jobz, const char* range,
              const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_Complex8* bp, const float* vl, const float* vu,
              const MKL_INT* il, const MKL_INT* iu, const float* abstol,
              MKL_INT* m, float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* ifail,
              MKL_INT* info );
void chpgvx( const MKL_INT* itype, const char* jobz, const char* range,
             const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_Complex8* bp, const float* vl, const float* vu,
             const MKL_INT* il, const MKL_INT* iu, const float* abstol,
             MKL_INT* m, float* w, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* ifail,
             MKL_INT* info );
void chpgvx_( const MKL_INT* itype, const char* jobz, const char* range,
              const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_Complex8* bp, const float* vl, const float* vu,
              const MKL_INT* il, const MKL_INT* iu, const float* abstol,
              MKL_INT* m, float* w, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* ifail,
              MKL_INT* info );

void CHPRFS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_Complex8* afp,
             const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void CHPRFS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_Complex8* afp,
              const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void chprfs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_Complex8* afp,
             const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void chprfs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_Complex8* afp,
              const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info );

void CHPSV( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info );
void CHPSV_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void chpsv( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info );
void chpsv_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );

void CHPSVX( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
             MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void CHPSVX_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
              MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void chpsvx( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
             MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void chpsvx_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
              MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );

void CHPTRD( const char* uplo, const MKL_INT* n, MKL_Complex8* ap, float* d,
             float* e, MKL_Complex8* tau, MKL_INT* info );
void CHPTRD_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap, float* d,
              float* e, MKL_Complex8* tau, MKL_INT* info );
void chptrd( const char* uplo, const MKL_INT* n, MKL_Complex8* ap, float* d,
             float* e, MKL_Complex8* tau, MKL_INT* info );
void chptrd_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap, float* d,
              float* e, MKL_Complex8* tau, MKL_INT* info );

void CHPTRF( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* ipiv, MKL_INT* info );
void CHPTRF_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* ipiv, MKL_INT* info );
void chptrf( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* ipiv, MKL_INT* info );
void chptrf_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* ipiv, MKL_INT* info );

void CHPTRI( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );
void CHPTRI_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );
void chptri( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );
void chptri_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );

void CHPTRS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void CHPTRS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );
void chptrs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void chptrs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );

void CHSEIN( const char* side, const char* eigsrc, const char* initv,
             const MKL_INT* select, const MKL_INT* n, const MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
             MKL_INT* ifaill, MKL_INT* ifailr, MKL_INT* info );
void CHSEIN_( const char* side, const char* eigsrc, const char* initv,
              const MKL_INT* select, const MKL_INT* n, const MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
              MKL_INT* ifaill, MKL_INT* ifailr, MKL_INT* info );
void chsein( const char* side, const char* eigsrc, const char* initv,
             const MKL_INT* select, const MKL_INT* n, const MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
             MKL_INT* ifaill, MKL_INT* ifailr, MKL_INT* info );
void chsein_( const char* side, const char* eigsrc, const char* initv,
              const MKL_INT* select, const MKL_INT* n, const MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
              MKL_INT* ifaill, MKL_INT* ifailr, MKL_INT* info );

void CHSEQR( const char* job, const char* compz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CHSEQR_( const char* job, const char* compz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void chseqr( const char* job, const char* compz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void chseqr_( const char* job, const char* compz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );

void CLABRD( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
             MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x,
             const MKL_INT* ldx, MKL_Complex8* y, const MKL_INT* ldy );
void CLABRD_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
              MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x,
              const MKL_INT* ldx, MKL_Complex8* y, const MKL_INT* ldy );
void clabrd( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
             MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x,
             const MKL_INT* ldx, MKL_Complex8* y, const MKL_INT* ldy );
void clabrd_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, float* d, float* e,
              MKL_Complex8* tauq, MKL_Complex8* taup, MKL_Complex8* x,
              const MKL_INT* ldx, MKL_Complex8* y, const MKL_INT* ldy );

void CLACGV( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx );
void CLACGV_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx );
void clacgv( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx );
void clacgv_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx );

void CLACN2( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
             MKL_INT* kase, MKL_INT* isave );
void CLACN2_( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
              MKL_INT* kase, MKL_INT* isave );
void clacn2( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
             MKL_INT* kase, MKL_INT* isave );
void clacn2_( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
              MKL_INT* kase, MKL_INT* isave );

void CLACON( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
             MKL_INT* kase );
void CLACON_( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
              MKL_INT* kase );
void clacon( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
             MKL_INT* kase );
void clacon_( const MKL_INT* n, MKL_Complex8* v, MKL_Complex8* x, float* est,
              MKL_INT* kase );

void CLACP2( const char* uplo, const MKL_INT* m, const MKL_INT* n,
             const float* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb );
void CLACP2_( const char* uplo, const MKL_INT* m, const MKL_INT* n,
              const float* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb );
void clacp2( const char* uplo, const MKL_INT* m, const MKL_INT* n,
             const float* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb );
void clacp2_( const char* uplo, const MKL_INT* m, const MKL_INT* n,
              const float* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb );

void CLACPY( const char* uplo, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb );
void CLACPY_( const char* uplo, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb );
void clacpy( const char* uplo, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb );
void clacpy_( const char* uplo, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb );

void CLACRM( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const float* b, const MKL_INT* ldb,
             MKL_Complex8* c, const MKL_INT* ldc, float* rwork );
void CLACRM_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const float* b, const MKL_INT* ldb,
              MKL_Complex8* c, const MKL_INT* ldc, float* rwork );
void clacrm( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const float* b, const MKL_INT* ldb,
             MKL_Complex8* c, const MKL_INT* ldc, float* rwork );
void clacrm_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const float* b, const MKL_INT* ldb,
              MKL_Complex8* c, const MKL_INT* ldc, float* rwork );

void CLACRT( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
             MKL_Complex8* cy, const MKL_INT* incy, const MKL_Complex8* c,
             const MKL_Complex8* s );
void CLACRT_( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
              MKL_Complex8* cy, const MKL_INT* incy, const MKL_Complex8* c,
              const MKL_Complex8* s );
void clacrt( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
             MKL_Complex8* cy, const MKL_INT* incy, const MKL_Complex8* c,
             const MKL_Complex8* s );
void clacrt_( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
              MKL_Complex8* cy, const MKL_INT* incy, const MKL_Complex8* c,
              const MKL_Complex8* s );

void CLADIV( MKL_Complex8* ret_value, const MKL_Complex8* x,
             const MKL_Complex8* y );
void CLADIV_( MKL_Complex8* ret_value, const MKL_Complex8* x,
              const MKL_Complex8* y );
void cladiv( MKL_Complex8* ret_value, const MKL_Complex8* x,
             const MKL_Complex8* y );
void cladiv_( MKL_Complex8* ret_value, const MKL_Complex8* x,
              const MKL_Complex8* y );

void CLAED0( const MKL_INT* qsiz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* qstore,
             const MKL_INT* ldqs, float* rwork, MKL_INT* iwork,
             MKL_INT* info );
void CLAED0_( const MKL_INT* qsiz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* qstore,
              const MKL_INT* ldqs, float* rwork, MKL_INT* iwork,
              MKL_INT* info );
void claed0( const MKL_INT* qsiz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* qstore,
             const MKL_INT* ldqs, float* rwork, MKL_INT* iwork,
             MKL_INT* info );
void claed0_( const MKL_INT* qsiz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* qstore,
              const MKL_INT* ldqs, float* rwork, MKL_INT* iwork,
              MKL_INT* info );

void CLAED7( const MKL_INT* n, const MKL_INT* cutpnt, const MKL_INT* qsiz,
             const MKL_INT* tlvls, const MKL_INT* curlvl,
             const MKL_INT* curpbm, float* d, MKL_Complex8* q,
             const MKL_INT* ldq, const float* rho, MKL_INT* indxq,
             float* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
             const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
             const float* givnum, MKL_Complex8* work, float* rwork,
             MKL_INT* iwork, MKL_INT* info );
void CLAED7_( const MKL_INT* n, const MKL_INT* cutpnt, const MKL_INT* qsiz,
              const MKL_INT* tlvls, const MKL_INT* curlvl,
              const MKL_INT* curpbm, float* d, MKL_Complex8* q,
              const MKL_INT* ldq, const float* rho, MKL_INT* indxq,
              float* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
              const MKL_INT* perm, const MKL_INT* givptr,
              const MKL_INT* givcol, const float* givnum, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* info );
void claed7( const MKL_INT* n, const MKL_INT* cutpnt, const MKL_INT* qsiz,
             const MKL_INT* tlvls, const MKL_INT* curlvl,
             const MKL_INT* curpbm, float* d, MKL_Complex8* q,
             const MKL_INT* ldq, const float* rho, MKL_INT* indxq,
             float* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
             const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
             const float* givnum, MKL_Complex8* work, float* rwork,
             MKL_INT* iwork, MKL_INT* info );
void claed7_( const MKL_INT* n, const MKL_INT* cutpnt, const MKL_INT* qsiz,
              const MKL_INT* tlvls, const MKL_INT* curlvl,
              const MKL_INT* curpbm, float* d, MKL_Complex8* q,
              const MKL_INT* ldq, const float* rho, MKL_INT* indxq,
              float* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
              const MKL_INT* perm, const MKL_INT* givptr,
              const MKL_INT* givcol, const float* givnum, MKL_Complex8* work,
              float* rwork, MKL_INT* iwork, MKL_INT* info );

void CLAED8( MKL_INT* k, const MKL_INT* n, const MKL_INT* qsiz,
             MKL_Complex8* q, const MKL_INT* ldq, float* d, float* rho,
             const MKL_INT* cutpnt, const float* z, float* dlamda,
             MKL_Complex8* q2, const MKL_INT* ldq2, float* w, MKL_INT* indxp,
             MKL_INT* indx, const MKL_INT* indxq, MKL_INT* perm,
             MKL_INT* givptr, MKL_INT* givcol, float* givnum, MKL_INT* info );
void CLAED8_( MKL_INT* k, const MKL_INT* n, const MKL_INT* qsiz,
              MKL_Complex8* q, const MKL_INT* ldq, float* d, float* rho,
              const MKL_INT* cutpnt, const float* z, float* dlamda,
              MKL_Complex8* q2, const MKL_INT* ldq2, float* w, MKL_INT* indxp,
              MKL_INT* indx, const MKL_INT* indxq, MKL_INT* perm,
              MKL_INT* givptr, MKL_INT* givcol, float* givnum, MKL_INT* info );
void claed8( MKL_INT* k, const MKL_INT* n, const MKL_INT* qsiz,
             MKL_Complex8* q, const MKL_INT* ldq, float* d, float* rho,
             const MKL_INT* cutpnt, const float* z, float* dlamda,
             MKL_Complex8* q2, const MKL_INT* ldq2, float* w, MKL_INT* indxp,
             MKL_INT* indx, const MKL_INT* indxq, MKL_INT* perm,
             MKL_INT* givptr, MKL_INT* givcol, float* givnum, MKL_INT* info );
void claed8_( MKL_INT* k, const MKL_INT* n, const MKL_INT* qsiz,
              MKL_Complex8* q, const MKL_INT* ldq, float* d, float* rho,
              const MKL_INT* cutpnt, const float* z, float* dlamda,
              MKL_Complex8* q2, const MKL_INT* ldq2, float* w, MKL_INT* indxp,
              MKL_INT* indx, const MKL_INT* indxq, MKL_INT* perm,
              MKL_INT* givptr, MKL_INT* givcol, float* givnum, MKL_INT* info );

void CLAEIN( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
             const MKL_Complex8* h, const MKL_INT* ldh, const MKL_Complex8* w,
             MKL_Complex8* v, MKL_Complex8* b, const MKL_INT* ldb,
             float* rwork, const float* eps3, const float* smlnum,
             MKL_INT* info );
void CLAEIN_( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
              const MKL_Complex8* h, const MKL_INT* ldh, const MKL_Complex8* w,
              MKL_Complex8* v, MKL_Complex8* b, const MKL_INT* ldb,
              float* rwork, const float* eps3, const float* smlnum,
              MKL_INT* info );
void claein( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
             const MKL_Complex8* h, const MKL_INT* ldh, const MKL_Complex8* w,
             MKL_Complex8* v, MKL_Complex8* b, const MKL_INT* ldb,
             float* rwork, const float* eps3, const float* smlnum,
             MKL_INT* info );
void claein_( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
              const MKL_Complex8* h, const MKL_INT* ldh, const MKL_Complex8* w,
              MKL_Complex8* v, MKL_Complex8* b, const MKL_INT* ldb,
              float* rwork, const float* eps3, const float* smlnum,
              MKL_INT* info );

void CLAESY( const MKL_Complex8* a, const MKL_Complex8* b,
             const MKL_Complex8* c, MKL_Complex8* rt1, MKL_Complex8* rt2,
             MKL_Complex8* evscal, MKL_Complex8* cs1, MKL_Complex8* sn1 );
void CLAESY_( const MKL_Complex8* a, const MKL_Complex8* b,
              const MKL_Complex8* c, MKL_Complex8* rt1, MKL_Complex8* rt2,
              MKL_Complex8* evscal, MKL_Complex8* cs1, MKL_Complex8* sn1 );
void claesy( const MKL_Complex8* a, const MKL_Complex8* b,
             const MKL_Complex8* c, MKL_Complex8* rt1, MKL_Complex8* rt2,
             MKL_Complex8* evscal, MKL_Complex8* cs1, MKL_Complex8* sn1 );
void claesy_( const MKL_Complex8* a, const MKL_Complex8* b,
              const MKL_Complex8* c, MKL_Complex8* rt1, MKL_Complex8* rt2,
              MKL_Complex8* evscal, MKL_Complex8* cs1, MKL_Complex8* sn1 );

void CLAEV2( const MKL_Complex8* a, const MKL_Complex8* b,
             const MKL_Complex8* c, float* rt1, float* rt2, float* cs1,
             MKL_Complex8* sn1 );
void CLAEV2_( const MKL_Complex8* a, const MKL_Complex8* b,
              const MKL_Complex8* c, float* rt1, float* rt2, float* cs1,
              MKL_Complex8* sn1 );
void claev2( const MKL_Complex8* a, const MKL_Complex8* b,
             const MKL_Complex8* c, float* rt1, float* rt2, float* cs1,
             MKL_Complex8* sn1 );
void claev2_( const MKL_Complex8* a, const MKL_Complex8* b,
              const MKL_Complex8* c, float* rt1, float* rt2, float* cs1,
              MKL_Complex8* sn1 );

void CLAG2Z( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* sa,
             const MKL_INT* ldsa, MKL_Complex16* a, const MKL_INT* lda,
             MKL_INT* info );
void CLAG2Z_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* sa,
              const MKL_INT* ldsa, MKL_Complex16* a, const MKL_INT* lda,
              MKL_INT* info );
void clag2z( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* sa,
             const MKL_INT* ldsa, MKL_Complex16* a, const MKL_INT* lda,
             MKL_INT* info );
void clag2z_( const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* sa,
              const MKL_INT* ldsa, MKL_Complex16* a, const MKL_INT* lda,
              MKL_INT* info );

void CLAGS2( const MKL_INT* upper, const float* a1, const MKL_Complex8* a2,
             const float* a3, const float* b1, const MKL_Complex8* b2,
             const float* b3, float* csu, MKL_Complex8* snu, float* csv,
             MKL_Complex8* snv, float* csq, MKL_Complex8* snq );
void CLAGS2_( const MKL_INT* upper, const float* a1, const MKL_Complex8* a2,
              const float* a3, const float* b1, const MKL_Complex8* b2,
              const float* b3, float* csu, MKL_Complex8* snu, float* csv,
              MKL_Complex8* snv, float* csq, MKL_Complex8* snq );
void clags2( const MKL_INT* upper, const float* a1, const MKL_Complex8* a2,
             const float* a3, const float* b1, const MKL_Complex8* b2,
             const float* b3, float* csu, MKL_Complex8* snu, float* csv,
             MKL_Complex8* snv, float* csq, MKL_Complex8* snq );
void clags2_( const MKL_INT* upper, const float* a1, const MKL_Complex8* a2,
              const float* a3, const float* b1, const MKL_Complex8* b2,
              const float* b3, float* csu, MKL_Complex8* snu, float* csv,
              MKL_Complex8* snv, float* csq, MKL_Complex8* snq );

void CLAGTM( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const float* alpha, const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* x, const MKL_INT* ldx,
             const float* beta, MKL_Complex8* b, const MKL_INT* ldb );
void CLAGTM_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const float* alpha, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du,
              const MKL_Complex8* x, const MKL_INT* ldx, const float* beta,
              MKL_Complex8* b, const MKL_INT* ldb );
void clagtm( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const float* alpha, const MKL_Complex8* dl, const MKL_Complex8* d,
             const MKL_Complex8* du, const MKL_Complex8* x, const MKL_INT* ldx,
             const float* beta, MKL_Complex8* b, const MKL_INT* ldb );
void clagtm_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const float* alpha, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du,
              const MKL_Complex8* x, const MKL_INT* ldx, const float* beta,
              MKL_Complex8* b, const MKL_INT* ldb );

void CLAHEF( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
             MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void CLAHEF_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
              MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void clahef( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
             MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void clahef_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
              MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );

void CLAHQR( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz,
             const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* info );
void CLAHQR_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* info );
void clahqr( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz,
             const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* info );
void clahqr_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* info );

void CLAHR2( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
             const MKL_INT* ldy );
void CLAHR2_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
              const MKL_INT* ldy );
void clahr2( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
             const MKL_INT* ldy );
void clahr2_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
              const MKL_INT* ldy );

void CLAHRD( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
             const MKL_INT* ldy );
void CLAHRD_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
              const MKL_INT* ldy );
void clahrd( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
             const MKL_INT* ldy );
void clahrd_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* y,
              const MKL_INT* ldy );

void CLAIC1( const MKL_INT* job, const MKL_INT* j, const MKL_Complex8* x,
             const float* sest, const MKL_Complex8* w,
             const MKL_Complex8* gamma, float* sestpr, MKL_Complex8* s,
             MKL_Complex8* c );
void CLAIC1_( const MKL_INT* job, const MKL_INT* j, const MKL_Complex8* x,
              const float* sest, const MKL_Complex8* w,
              const MKL_Complex8* gamma, float* sestpr, MKL_Complex8* s,
              MKL_Complex8* c );
void claic1( const MKL_INT* job, const MKL_INT* j, const MKL_Complex8* x,
             const float* sest, const MKL_Complex8* w,
             const MKL_Complex8* gamma, float* sestpr, MKL_Complex8* s,
             MKL_Complex8* c );
void claic1_( const MKL_INT* job, const MKL_INT* j, const MKL_Complex8* x,
              const float* sest, const MKL_Complex8* w,
              const MKL_Complex8* gamma, float* sestpr, MKL_Complex8* s,
              MKL_Complex8* c );

void CLALS0( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
             const MKL_INT* sqre, const MKL_INT* nrhs, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* bx, const MKL_INT* ldbx,
             const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
             const MKL_INT* ldgcol, const float* givnum, const MKL_INT* ldgnum,
             const float* poles, const float* difl, const float* difr,
             const float* z, const MKL_INT* k, const float* c, const float* s,
             float* rwork, MKL_INT* info );
void CLALS0_( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
              const MKL_INT* sqre, const MKL_INT* nrhs, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* bx, const MKL_INT* ldbx,
              const MKL_INT* perm, const MKL_INT* givptr,
              const MKL_INT* givcol, const MKL_INT* ldgcol,
              const float* givnum, const MKL_INT* ldgnum, const float* poles,
              const float* difl, const float* difr, const float* z,
              const MKL_INT* k, const float* c, const float* s, float* rwork,
              MKL_INT* info );
void clals0( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
             const MKL_INT* sqre, const MKL_INT* nrhs, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* bx, const MKL_INT* ldbx,
             const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
             const MKL_INT* ldgcol, const float* givnum, const MKL_INT* ldgnum,
             const float* poles, const float* difl, const float* difr,
             const float* z, const MKL_INT* k, const float* c, const float* s,
             float* rwork, MKL_INT* info );
void clals0_( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
              const MKL_INT* sqre, const MKL_INT* nrhs, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* bx, const MKL_INT* ldbx,
              const MKL_INT* perm, const MKL_INT* givptr,
              const MKL_INT* givcol, const MKL_INT* ldgcol,
              const float* givnum, const MKL_INT* ldgnum, const float* poles,
              const float* difl, const float* difr, const float* z,
              const MKL_INT* k, const float* c, const float* s, float* rwork,
              MKL_INT* info );

void CLALSA( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* bx, const MKL_INT* ldbx, const float* u,
             const MKL_INT* ldu, const float* vt, const MKL_INT* k,
             const float* difl, const float* difr, const float* z,
             const float* poles, const MKL_INT* givptr, const MKL_INT* givcol,
             const MKL_INT* ldgcol, const MKL_INT* perm, const float* givnum,
             const float* c, const float* s, float* rwork, MKL_INT* iwork,
             MKL_INT* info );
void CLALSA_( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* bx, const MKL_INT* ldbx, const float* u,
              const MKL_INT* ldu, const float* vt, const MKL_INT* k,
              const float* difl, const float* difr, const float* z,
              const float* poles, const MKL_INT* givptr, const MKL_INT* givcol,
              const MKL_INT* ldgcol, const MKL_INT* perm, const float* givnum,
              const float* c, const float* s, float* rwork, MKL_INT* iwork,
              MKL_INT* info );
void clalsa( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* bx, const MKL_INT* ldbx, const float* u,
             const MKL_INT* ldu, const float* vt, const MKL_INT* k,
             const float* difl, const float* difr, const float* z,
             const float* poles, const MKL_INT* givptr, const MKL_INT* givcol,
             const MKL_INT* ldgcol, const MKL_INT* perm, const float* givnum,
             const float* c, const float* s, float* rwork, MKL_INT* iwork,
             MKL_INT* info );
void clalsa_( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* bx, const MKL_INT* ldbx, const float* u,
              const MKL_INT* ldu, const float* vt, const MKL_INT* k,
              const float* difl, const float* difr, const float* z,
              const float* poles, const MKL_INT* givptr, const MKL_INT* givcol,
              const MKL_INT* ldgcol, const MKL_INT* perm, const float* givnum,
              const float* c, const float* s, float* rwork, MKL_INT* iwork,
              MKL_INT* info );

void CLALSD( const char* uplo, const MKL_INT* smlsiz, const MKL_INT* n,
             const MKL_INT* nrhs, float* d, float* e, MKL_Complex8* b,
             const MKL_INT* ldb, const float* rcond, MKL_INT* rank,
             MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* info );
void CLALSD_( const char* uplo, const MKL_INT* smlsiz, const MKL_INT* n,
              const MKL_INT* nrhs, float* d, float* e, MKL_Complex8* b,
              const MKL_INT* ldb, const float* rcond, MKL_INT* rank,
              MKL_Complex8* work, float* rwork, MKL_INT* iwork,
              MKL_INT* info );
void clalsd( const char* uplo, const MKL_INT* smlsiz, const MKL_INT* n,
             const MKL_INT* nrhs, float* d, float* e, MKL_Complex8* b,
             const MKL_INT* ldb, const float* rcond, MKL_INT* rank,
             MKL_Complex8* work, float* rwork, MKL_INT* iwork, MKL_INT* info );
void clalsd_( const char* uplo, const MKL_INT* smlsiz, const MKL_INT* n,
              const MKL_INT* nrhs, float* d, float* e, MKL_Complex8* b,
              const MKL_INT* ldb, const float* rcond, MKL_INT* rank,
              MKL_Complex8* work, float* rwork, MKL_INT* iwork,
              MKL_INT* info );

float CLANGB( const char* norm, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* work );
float CLANGB_( const char* norm, const MKL_INT* n, const MKL_INT* kl,
               const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* work );
float clangb( const char* norm, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* work );
float clangb_( const char* norm, const MKL_INT* n, const MKL_INT* kl,
               const MKL_INT* ku, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* work );

float CLANGE( const char* norm, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, float* work );
float CLANGE_( const char* norm, const MKL_INT* m, const MKL_INT* n,
               const MKL_Complex8* a, const MKL_INT* lda, float* work );
float clange( const char* norm, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, float* work );
float clange_( const char* norm, const MKL_INT* m, const MKL_INT* n,
               const MKL_Complex8* a, const MKL_INT* lda, float* work );

float CLANGT( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du );
float CLANGT_( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
               const MKL_Complex8* d, const MKL_Complex8* du );
float clangt( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
              const MKL_Complex8* d, const MKL_Complex8* du );
float clangt_( const char* norm, const MKL_INT* n, const MKL_Complex8* dl,
               const MKL_Complex8* d, const MKL_Complex8* du );

float CLANHB( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* work );
float CLANHB_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* work );
float clanhb( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* work );
float clanhb_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* work );

float CLANHE( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, float* work );
float CLANHE_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* a, const MKL_INT* lda, float* work );
float clanhe( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, float* work );
float clanhe_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* a, const MKL_INT* lda, float* work );

float CLANHF( const char* norm, const char* transr, const char* uplo,
              const MKL_INT* n, const MKL_Complex8* a, float* work );
float CLANHF_( const char* norm, const char* transr, const char* uplo,
               const MKL_INT* n, const MKL_Complex8* a, float* work );
float clanhf( const char* norm, const char* transr, const char* uplo,
              const MKL_INT* n, const MKL_Complex8* a, float* work );
float clanhf_( const char* norm, const char* transr, const char* uplo,
               const MKL_INT* n, const MKL_Complex8* a, float* work );

float CLANHP( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* ap, float* work );
float CLANHP_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* ap, float* work );
float clanhp( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* ap, float* work );
float clanhp_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* ap, float* work );

float CLANHS( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* work );
float CLANHS_( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* work );
float clanhs( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* work );
float clanhs_( const char* norm, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* work );

float CLANHT( const char* norm, const MKL_INT* n, const float* d,
              const MKL_Complex8* e );
float CLANHT_( const char* norm, const MKL_INT* n, const float* d,
               const MKL_Complex8* e );
float clanht( const char* norm, const MKL_INT* n, const float* d,
              const MKL_Complex8* e );
float clanht_( const char* norm, const MKL_INT* n, const float* d,
               const MKL_Complex8* e );

float CLANSB( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* work );
float CLANSB_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* work );
float clansb( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
              float* work );
float clansb_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_INT* k, const MKL_Complex8* ab, const MKL_INT* ldab,
               float* work );

float CLANSP( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* ap, float* work );
float CLANSP_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* ap, float* work );
float clansp( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* ap, float* work );
float clansp_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* ap, float* work );

float CLANSY( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, float* work );
float CLANSY_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* a, const MKL_INT* lda, float* work );
float clansy( const char* norm, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, float* work );
float clansy_( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_Complex8* a, const MKL_INT* lda, float* work );

float CLANTB( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* ab,
              const MKL_INT* ldab, float* work );
float CLANTB_( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* ab,
               const MKL_INT* ldab, float* work );
float clantb( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* ab,
              const MKL_INT* ldab, float* work );
float clantb_( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* ab,
               const MKL_INT* ldab, float* work );

float CLANTP( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_Complex8* ap, float* work );
float CLANTP_( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* n, const MKL_Complex8* ap, float* work );
float clantp( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_Complex8* ap, float* work );
float clantp_( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* n, const MKL_Complex8* ap, float* work );

float CLANTR( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* work );
float CLANTR_( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* work );
float clantr( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* work );
float clantr_( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* work );

void CLAPLL( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
             MKL_Complex8* y, const MKL_INT* incy, float* ssmin );
void CLAPLL_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
              MKL_Complex8* y, const MKL_INT* incy, float* ssmin );
void clapll( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
             MKL_Complex8* y, const MKL_INT* incy, float* ssmin );
void clapll_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
              MKL_Complex8* y, const MKL_INT* incy, float* ssmin );

void CLAPMT( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );
void CLAPMT_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );
void clapmt( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
             MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );
void clapmt_( const MKL_INT* forwrd, const MKL_INT* m, const MKL_INT* n,
              MKL_Complex8* x, const MKL_INT* ldx, MKL_INT* k );

void CLAQGB( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
             const float* r, const float* c, const float* rowcnd,
             const float* colcnd, const float* amax, char* equed );
void CLAQGB_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
              const float* r, const float* c, const float* rowcnd,
              const float* colcnd, const float* amax, char* equed );
void claqgb( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
             const float* r, const float* c, const float* rowcnd,
             const float* colcnd, const float* amax, char* equed );
void claqgb_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, MKL_Complex8* ab, const MKL_INT* ldab,
              const float* r, const float* c, const float* rowcnd,
              const float* colcnd, const float* amax, char* equed );

void CLAQGE( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const float* r, const float* c,
             const float* rowcnd, const float* colcnd, const float* amax,
             char* equed );
void CLAQGE_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const float* r, const float* c,
              const float* rowcnd, const float* colcnd, const float* amax,
              char* equed );
void claqge( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const float* r, const float* c,
             const float* rowcnd, const float* colcnd, const float* amax,
             char* equed );
void claqge_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const float* r, const float* c,
              const float* rowcnd, const float* colcnd, const float* amax,
              char* equed );

void CLAQHB( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, float* s,
             const float* scond, const float* amax, char* equed );
void CLAQHB_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, float* s,
              const float* scond, const float* amax, char* equed );
void claqhb( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, float* s,
             const float* scond, const float* amax, char* equed );
void claqhb_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, float* s,
              const float* scond, const float* amax, char* equed );

void CLAQHE( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const float* s, const float* scond,
             const float* amax, char* equed );
void CLAQHE_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const float* s, const float* scond,
              const float* amax, char* equed );
void claqhe( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const float* s, const float* scond,
             const float* amax, char* equed );
void claqhe_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const float* s, const float* scond,
              const float* amax, char* equed );

void CLAQHP( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const float* s, const float* scond, const float* amax,
             char* equed );
void CLAQHP_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const float* s, const float* scond, const float* amax,
              char* equed );
void claqhp( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const float* s, const float* scond, const float* amax,
             char* equed );
void claqhp_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const float* s, const float* scond, const float* amax,
              char* equed );

void CLAQP2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* jpvt,
             MKL_Complex8* tau, float* vn1, float* vn2, MKL_Complex8* work );
void CLAQP2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* jpvt,
              MKL_Complex8* tau, float* vn1, float* vn2, MKL_Complex8* work );
void claqp2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* jpvt,
             MKL_Complex8* tau, float* vn1, float* vn2, MKL_Complex8* work );
void claqp2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* jpvt,
              MKL_Complex8* tau, float* vn1, float* vn2, MKL_Complex8* work );

void CLAQPS( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
             const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau, float* vn1,
             float* vn2, MKL_Complex8* auxv, MKL_Complex8* f,
             const MKL_INT* ldf );
void CLAQPS_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
              const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau, float* vn1,
              float* vn2, MKL_Complex8* auxv, MKL_Complex8* f,
              const MKL_INT* ldf );
void claqps( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
             const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau, float* vn1,
             float* vn2, MKL_Complex8* auxv, MKL_Complex8* f,
             const MKL_INT* ldf );
void claqps_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* offset,
              const MKL_INT* nb, MKL_INT* kb, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* jpvt, MKL_Complex8* tau, float* vn1,
              float* vn2, MKL_Complex8* auxv, MKL_Complex8* f,
              const MKL_INT* ldf );

void CLAQR0( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz, MKL_INT* ihiz,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void CLAQR0_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz,
              MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void claqr0( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz, MKL_INT* ihiz,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void claqr0_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz,
              MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CLAQR1( const MKL_INT* n, const MKL_Complex8* h, const MKL_INT* ldh,
             const MKL_Complex8* s1, MKL_Complex8* s2, MKL_Complex8* v );
void CLAQR1_( const MKL_INT* n, const MKL_Complex8* h, const MKL_INT* ldh,
              const MKL_Complex8* s1, MKL_Complex8* s2, MKL_Complex8* v );
void claqr1( const MKL_INT* n, const MKL_Complex8* h, const MKL_INT* ldh,
             const MKL_Complex8* s1, MKL_Complex8* s2, MKL_Complex8* v );
void claqr1_( const MKL_INT* n, const MKL_Complex8* h, const MKL_INT* ldh,
              const MKL_Complex8* s1, MKL_Complex8* s2, MKL_Complex8* v );

void CLAQR2( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
             MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
             const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
             const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
             const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
             const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );
void CLAQR2_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
              MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
              const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
              const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
              const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );
void claqr2( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
             MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
             const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
             const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
             const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
             const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );
void claqr2_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
              MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
              const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
              const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
              const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );

void CLAQR3( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
             MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
             const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
             const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
             const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
             const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );
void CLAQR3_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
              MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
              const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
              const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
              const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );
void claqr3( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
             MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
             const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
             const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
             const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
             const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );
void claqr3_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ktop, const MKL_INT* kbot, const MKL_INT* nw,
              MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* ns, MKL_INT* nd, MKL_Complex8* sh, MKL_Complex8* v,
              const MKL_INT* ldv, const MKL_INT* nh, MKL_Complex8* t,
              const MKL_INT* ldt, const MKL_INT* nv, MKL_Complex8* wv,
              const MKL_INT* ldwv, MKL_Complex8* work, const MKL_INT* lwork );

void CLAQR4( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz, MKL_INT* ihiz,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void CLAQR4_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz,
              MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void claqr4( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
             const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz, MKL_INT* ihiz,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void claqr4_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, MKL_Complex8* h,
              const MKL_INT* ldh, MKL_Complex8* w, MKL_INT* iloz,
              MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CLAQR5( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22,
             const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot,
             const MKL_INT* nshfts, MKL_Complex8* s, MKL_Complex8* h,
             const MKL_INT* ldh, const MKL_INT* iloz, const MKL_INT* ihiz,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* v,
             const MKL_INT* ldv, MKL_Complex8* u, const MKL_INT* ldu,
             const MKL_INT* nv, MKL_Complex8* wv, const MKL_INT* ldwv,
             const MKL_INT* nh, MKL_Complex8* wh, const MKL_INT* ldwh );
void CLAQR5_( const MKL_INT* wantt, const MKL_INT* wantz,
              const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop,
              const MKL_INT* kbot, const MKL_INT* nshfts, MKL_Complex8* s,
              MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* u,
              const MKL_INT* ldu, const MKL_INT* nv, MKL_Complex8* wv,
              const MKL_INT* ldwv, const MKL_INT* nh, MKL_Complex8* wh,
              const MKL_INT* ldwh );
void claqr5( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* kacc22,
             const MKL_INT* n, const MKL_INT* ktop, const MKL_INT* kbot,
             const MKL_INT* nshfts, MKL_Complex8* s, MKL_Complex8* h,
             const MKL_INT* ldh, const MKL_INT* iloz, const MKL_INT* ihiz,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* v,
             const MKL_INT* ldv, MKL_Complex8* u, const MKL_INT* ldu,
             const MKL_INT* nv, MKL_Complex8* wv, const MKL_INT* ldwv,
             const MKL_INT* nh, MKL_Complex8* wh, const MKL_INT* ldwh );
void claqr5_( const MKL_INT* wantt, const MKL_INT* wantz,
              const MKL_INT* kacc22, const MKL_INT* n, const MKL_INT* ktop,
              const MKL_INT* kbot, const MKL_INT* nshfts, MKL_Complex8* s,
              MKL_Complex8* h, const MKL_INT* ldh, const MKL_INT* iloz,
              const MKL_INT* ihiz, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_Complex8* v, const MKL_INT* ldv, MKL_Complex8* u,
              const MKL_INT* ldu, const MKL_INT* nv, MKL_Complex8* wv,
              const MKL_INT* ldwv, const MKL_INT* nh, MKL_Complex8* wh,
              const MKL_INT* ldwh );

void CLAQSB( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, const float* s,
             const float* scond, const float* amax, char* equed );
void CLAQSB_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, const float* s,
              const float* scond, const float* amax, char* equed );
void claqsb( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, const float* s,
             const float* scond, const float* amax, char* equed );
void claqsb_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, const float* s,
              const float* scond, const float* amax, char* equed );

void CLAQSP( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const float* s, const float* scond, const float* amax,
             char* equed );
void CLAQSP_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const float* s, const float* scond, const float* amax,
              char* equed );
void claqsp( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const float* s, const float* scond, const float* amax,
             char* equed );
void claqsp_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const float* s, const float* scond, const float* amax,
              char* equed );

void CLAQSY( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const float* s, const float* scond,
             const float* amax, char* equed );
void CLAQSY_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const float* s, const float* scond,
              const float* amax, char* equed );
void claqsy( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const float* s, const float* scond,
             const float* amax, char* equed );
void claqsy_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const float* s, const float* scond,
              const float* amax, char* equed );

void CLAR1V( const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn,
             const float* lambda, const float* d, const float* l,
             const float* ld, const float* lld, const float* pivmin,
             const float* gaptol, MKL_Complex8* z, const MKL_INT* wantnc,
             MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r,
             MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr,
             float* work );
void CLAR1V_( const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn,
              const float* lambda, const float* d, const float* l,
              const float* ld, const float* lld, const float* pivmin,
              const float* gaptol, MKL_Complex8* z, const MKL_INT* wantnc,
              MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r,
              MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr,
              float* work );
void clar1v( const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn,
             const float* lambda, const float* d, const float* l,
             const float* ld, const float* lld, const float* pivmin,
             const float* gaptol, MKL_Complex8* z, const MKL_INT* wantnc,
             MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r,
             MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr,
             float* work );
void clar1v_( const MKL_INT* n, const MKL_INT* b1, const MKL_INT* bn,
              const float* lambda, const float* d, const float* l,
              const float* ld, const float* lld, const float* pivmin,
              const float* gaptol, MKL_Complex8* z, const MKL_INT* wantnc,
              MKL_INT* negcnt, float* ztz, float* mingma, MKL_INT* r,
              MKL_INT* isuppz, float* nrminv, float* resid, float* rqcorr,
              float* work );

void CLAR2V( const MKL_INT* n, MKL_Complex8* x, MKL_Complex8* y,
             MKL_Complex8* z, const MKL_INT* incx, const float* c,
             const MKL_Complex8* s, const MKL_INT* incc );
void CLAR2V_( const MKL_INT* n, MKL_Complex8* x, MKL_Complex8* y,
              MKL_Complex8* z, const MKL_INT* incx, const float* c,
              const MKL_Complex8* s, const MKL_INT* incc );
void clar2v( const MKL_INT* n, MKL_Complex8* x, MKL_Complex8* y,
             MKL_Complex8* z, const MKL_INT* incx, const float* c,
             const MKL_Complex8* s, const MKL_INT* incc );
void clar2v_( const MKL_INT* n, MKL_Complex8* x, MKL_Complex8* y,
              MKL_Complex8* z, const MKL_INT* incx, const float* c,
              const MKL_Complex8* s, const MKL_INT* incc );

void CLARCM( const MKL_INT* m, const MKL_INT* n, const float* a,
             const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* c, const MKL_INT* ldc, float* rwork );
void CLARCM_( const MKL_INT* m, const MKL_INT* n, const float* a,
              const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* c, const MKL_INT* ldc, float* rwork );
void clarcm( const MKL_INT* m, const MKL_INT* n, const float* a,
             const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* c, const MKL_INT* ldc, float* rwork );
void clarcm_( const MKL_INT* m, const MKL_INT* n, const float* a,
              const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* c, const MKL_INT* ldc, float* rwork );

void CLARFB( const char* side, const char* trans, const char* direct,
             const char* storev, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
             const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* ldwork );
void CLARFB_( const char* side, const char* trans, const char* direct,
              const char* storev, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* ldwork );
void clarfb( const char* side, const char* trans, const char* direct,
             const char* storev, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
             const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* ldwork );
void clarfb_( const char* side, const char* trans, const char* direct,
              const char* storev, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* t, const MKL_INT* ldt, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* ldwork );

void CLARF( const char* side, const MKL_INT* m, const MKL_INT* n,
            const MKL_Complex8* v, const MKL_INT* incv,
            const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
            MKL_Complex8* work );
void CLARF_( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* v, const MKL_INT* incv,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work );
void clarf( const char* side, const MKL_INT* m, const MKL_INT* n,
            const MKL_Complex8* v, const MKL_INT* incv,
            const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
            MKL_Complex8* work );
void clarf_( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* v, const MKL_INT* incv,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work );

void CLARFG( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
             const MKL_INT* incx, MKL_Complex8* tau );
void CLARFG_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
              const MKL_INT* incx, MKL_Complex8* tau );
void clarfg( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
             const MKL_INT* incx, MKL_Complex8* tau );
void clarfg_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
              const MKL_INT* incx, MKL_Complex8* tau );

void CLARFGP( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
              const MKL_INT* incx, MKL_Complex8* tau );
void CLARFGP_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
               const MKL_INT* incx, MKL_Complex8* tau );
void clarfgp( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
              const MKL_INT* incx, MKL_Complex8* tau );
void clarfgp_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
               const MKL_INT* incx, MKL_Complex8* tau );

void CLARFP( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
             const MKL_INT* incx, MKL_Complex8* tau );
void CLARFP_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
              const MKL_INT* incx, MKL_Complex8* tau );
void clarfp( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
             const MKL_INT* incx, MKL_Complex8* tau );
void clarfp_( const MKL_INT* n, MKL_Complex8* alpha, MKL_Complex8* x,
              const MKL_INT* incx, MKL_Complex8* tau );

void CLARFT( const char* direct, const char* storev, const MKL_INT* n,
             const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
             const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );
void CLARFT_( const char* direct, const char* storev, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );
void clarft( const char* direct, const char* storev, const MKL_INT* n,
             const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
             const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );
void clarft_( const char* direct, const char* storev, const MKL_INT* n,
              const MKL_INT* k, const MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );

void CLARFX( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* v, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work );
void CLARFX_( const char* side, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* v, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work );
void clarfx( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* v, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work );
void clarfx_( const char* side, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* v, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work );

void CLARGV( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
             MKL_Complex8* y, const MKL_INT* incy, float* c,
             const MKL_INT* incc );
void CLARGV_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
              MKL_Complex8* y, const MKL_INT* incy, float* c,
              const MKL_INT* incc );
void clargv( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
             MKL_Complex8* y, const MKL_INT* incy, float* c,
             const MKL_INT* incc );
void clargv_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
              MKL_Complex8* y, const MKL_INT* incy, float* c,
              const MKL_INT* incc );

void CLARNV( const MKL_INT* idist, MKL_INT* iseed, const MKL_INT* n,
             MKL_Complex8* x );
void CLARNV_( const MKL_INT* idist, MKL_INT* iseed, const MKL_INT* n,
              MKL_Complex8* x );
void clarnv( const MKL_INT* idist, MKL_INT* iseed, const MKL_INT* n,
             MKL_Complex8* x );
void clarnv_( const MKL_INT* idist, MKL_INT* iseed, const MKL_INT* n,
              MKL_Complex8* x );

void CLARRV( const MKL_INT* n, const float* vl, const float* vu, float* d,
             float* l, float* pivmin, const MKL_INT* isplit, const MKL_INT* m,
             const MKL_INT* dol, const MKL_INT* dou, const float* minrgp,
             const float* rtol1, const float* rtol2, float* w, float* werr,
             float* wgap, const MKL_INT* iblock, const MKL_INT* indexw,
             const float* gers, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* info );
void CLARRV_( const MKL_INT* n, const float* vl, const float* vu, float* d,
              float* l, float* pivmin, const MKL_INT* isplit, const MKL_INT* m,
              const MKL_INT* dol, const MKL_INT* dou, const float* minrgp,
              const float* rtol1, const float* rtol2, float* w, float* werr,
              float* wgap, const MKL_INT* iblock, const MKL_INT* indexw,
              const float* gers, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* info );
void clarrv( const MKL_INT* n, const float* vl, const float* vu, float* d,
             float* l, float* pivmin, const MKL_INT* isplit, const MKL_INT* m,
             const MKL_INT* dol, const MKL_INT* dou, const float* minrgp,
             const float* rtol1, const float* rtol2, float* w, float* werr,
             float* wgap, const MKL_INT* iblock, const MKL_INT* indexw,
             const float* gers, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* info );
void clarrv_( const MKL_INT* n, const float* vl, const float* vu, float* d,
              float* l, float* pivmin, const MKL_INT* isplit, const MKL_INT* m,
              const MKL_INT* dol, const MKL_INT* dou, const float* minrgp,
              const float* rtol1, const float* rtol2, float* w, float* werr,
              float* wgap, const MKL_INT* iblock, const MKL_INT* indexw,
              const float* gers, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* isuppz, float* work, MKL_INT* iwork, MKL_INT* info );

void CLARSCL2( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
               const MKL_INT* ldx );
void CLARSCL2_( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
                const MKL_INT* ldx );
void clarscl2( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
               const MKL_INT* ldx );
void clarscl2_( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
               const MKL_INT* ldx );

void CLARTG( const MKL_Complex8* f, const MKL_Complex8* g, float* cs,
             MKL_Complex8* sn, MKL_Complex8* r );
void CLARTG_( const MKL_Complex8* f, const MKL_Complex8* g, float* cs,
              MKL_Complex8* sn, MKL_Complex8* r );
void clartg( const MKL_Complex8* f, const MKL_Complex8* g, float* cs,
             MKL_Complex8* sn, MKL_Complex8* r );
void clartg_( const MKL_Complex8* f, const MKL_Complex8* g, float* cs,
              MKL_Complex8* sn, MKL_Complex8* r );

void CLARTV( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
             MKL_Complex8* y, const MKL_INT* incy, const float* c,
             const MKL_Complex8* s, const MKL_INT* incc );
void CLARTV_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
              MKL_Complex8* y, const MKL_INT* incy, const float* c,
              const MKL_Complex8* s, const MKL_INT* incc );
void clartv( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
             MKL_Complex8* y, const MKL_INT* incy, const float* c,
             const MKL_Complex8* s, const MKL_INT* incc );
void clartv_( const MKL_INT* n, MKL_Complex8* x, const MKL_INT* incx,
              MKL_Complex8* y, const MKL_INT* incy, const float* c,
              const MKL_Complex8* s, const MKL_INT* incc );

void CLARZB( const char* side, const char* trans, const char* direct,
             const char* storev, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v,
             const MKL_INT* ldv, const MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work,
             const MKL_INT* ldwork );
void CLARZB_( const char* side, const char* trans, const char* direct,
              const char* storev, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v,
              const MKL_INT* ldv, const MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work,
              const MKL_INT* ldwork );
void clarzb( const char* side, const char* trans, const char* direct,
             const char* storev, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v,
             const MKL_INT* ldv, const MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work,
             const MKL_INT* ldwork );
void clarzb_( const char* side, const char* trans, const char* direct,
              const char* storev, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* k, const MKL_INT* l, const MKL_Complex8* v,
              const MKL_INT* ldv, const MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* c, const MKL_INT* ldc, MKL_Complex8* work,
              const MKL_INT* ldwork );

void CLARZ( const char* side, const MKL_INT* m, const MKL_INT* n,
            const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* incv,
            const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
            MKL_Complex8* work );
void CLARZ_( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* incv,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work );
void clarz( const char* side, const MKL_INT* m, const MKL_INT* n,
            const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* incv,
            const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
            MKL_Complex8* work );
void clarz_( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* l, const MKL_Complex8* v, const MKL_INT* incv,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work );

void CLARZT( const char* direct, const char* storev, const MKL_INT* n,
             const MKL_INT* k, MKL_Complex8* v, const MKL_INT* ldv,
             const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );
void CLARZT_( const char* direct, const char* storev, const MKL_INT* n,
              const MKL_INT* k, MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );
void clarzt( const char* direct, const char* storev, const MKL_INT* n,
             const MKL_INT* k, MKL_Complex8* v, const MKL_INT* ldv,
             const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );
void clarzt_( const char* direct, const char* storev, const MKL_INT* n,
              const MKL_INT* k, MKL_Complex8* v, const MKL_INT* ldv,
              const MKL_Complex8* tau, MKL_Complex8* t, const MKL_INT* ldt );

void CLASCL( const char* type, const MKL_INT* kl, const MKL_INT* ku,
             const float* cfrom, const float* cto, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* info );
void CLASCL_( const char* type, const MKL_INT* kl, const MKL_INT* ku,
              const float* cfrom, const float* cto, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* info );
void clascl( const char* type, const MKL_INT* kl, const MKL_INT* ku,
             const float* cfrom, const float* cto, const MKL_INT* m,
             const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* info );
void clascl_( const char* type, const MKL_INT* kl, const MKL_INT* ku,
              const float* cfrom, const float* cto, const MKL_INT* m,
              const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* info );

void CLASCL2( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
              const MKL_INT* ldx );
void CLASCL2_( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
               const MKL_INT* ldx );
void clascl2( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
              const MKL_INT* ldx );
void clascl2_( const MKL_INT* m, const MKL_INT* n, const float* d, MKL_Complex8* x,
               const MKL_INT* ldx );

void CLASET( const char* uplo, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* alpha, const MKL_Complex8* beta,
             MKL_Complex8* a, const MKL_INT* lda );
void CLASET_( const char* uplo, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* alpha, const MKL_Complex8* beta,
              MKL_Complex8* a, const MKL_INT* lda );
void claset( const char* uplo, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* alpha, const MKL_Complex8* beta,
             MKL_Complex8* a, const MKL_INT* lda );
void claset_( const char* uplo, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* alpha, const MKL_Complex8* beta,
              MKL_Complex8* a, const MKL_INT* lda );

void CLASR( const char* side, const char* pivot, const char* direct,
            const MKL_INT* m, const MKL_INT* n, const float* c, const float* s,
            MKL_Complex8* a, const MKL_INT* lda );
void CLASR_( const char* side, const char* pivot, const char* direct,
             const MKL_INT* m, const MKL_INT* n, const float* c,
             const float* s, MKL_Complex8* a, const MKL_INT* lda );
void clasr( const char* side, const char* pivot, const char* direct,
            const MKL_INT* m, const MKL_INT* n, const float* c, const float* s,
            MKL_Complex8* a, const MKL_INT* lda );
void clasr_( const char* side, const char* pivot, const char* direct,
             const MKL_INT* m, const MKL_INT* n, const float* c,
             const float* s, MKL_Complex8* a, const MKL_INT* lda );

void CLASSQ( const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* incx,
             float* scale, float* sumsq );
void CLASSQ_( const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* incx,
              float* scale, float* sumsq );
void classq( const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* incx,
             float* scale, float* sumsq );
void classq_( const MKL_INT* n, const MKL_Complex8* x, const MKL_INT* incx,
              float* scale, float* sumsq );

void CLASWP( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv,
             const MKL_INT* incx );
void CLASWP_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv,
              const MKL_INT* incx );
void claswp( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
             const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv,
             const MKL_INT* incx );
void claswp_( const MKL_INT* n, MKL_Complex8* a, const MKL_INT* lda,
              const MKL_INT* k1, const MKL_INT* k2, const MKL_INT* ipiv,
              const MKL_INT* incx );

void CLASYF( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
             MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void CLASYF_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
              MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void clasyf( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
             MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );
void clasyf_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
              MKL_INT* kb, MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_Complex8* w, const MKL_INT* ldw, MKL_INT* info );

void CLATBS( const char* uplo, const char* trans, const char* diag,
             const char* normin, const MKL_INT* n, const MKL_INT* kd,
             const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* x,
             float* scale, float* cnorm, MKL_INT* info );
void CLATBS_( const char* uplo, const char* trans, const char* diag,
              const char* normin, const MKL_INT* n, const MKL_INT* kd,
              const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* x,
              float* scale, float* cnorm, MKL_INT* info );
void clatbs( const char* uplo, const char* trans, const char* diag,
             const char* normin, const MKL_INT* n, const MKL_INT* kd,
             const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* x,
             float* scale, float* cnorm, MKL_INT* info );
void clatbs_( const char* uplo, const char* trans, const char* diag,
              const char* normin, const MKL_INT* n, const MKL_INT* kd,
              const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* x,
              float* scale, float* cnorm, MKL_INT* info );

void CLATDF( const MKL_INT* ijob, const MKL_INT* n, const MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* rhs, float* rdsum,
             float* rdscal, const MKL_INT* ipiv, const MKL_INT* jpiv );
void CLATDF_( const MKL_INT* ijob, const MKL_INT* n, const MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* rhs, float* rdsum,
              float* rdscal, const MKL_INT* ipiv, const MKL_INT* jpiv );
void clatdf( const MKL_INT* ijob, const MKL_INT* n, const MKL_Complex8* z,
             const MKL_INT* ldz, MKL_Complex8* rhs, float* rdsum,
             float* rdscal, const MKL_INT* ipiv, const MKL_INT* jpiv );
void clatdf_( const MKL_INT* ijob, const MKL_INT* n, const MKL_Complex8* z,
              const MKL_INT* ldz, MKL_Complex8* rhs, float* rdsum,
              float* rdscal, const MKL_INT* ipiv, const MKL_INT* jpiv );

void CLATPS( const char* uplo, const char* trans, const char* diag,
             const char* normin, const MKL_INT* n, const MKL_Complex8* ap,
             MKL_Complex8* x, float* scale, float* cnorm, MKL_INT* info );
void CLATPS_( const char* uplo, const char* trans, const char* diag,
              const char* normin, const MKL_INT* n, const MKL_Complex8* ap,
              MKL_Complex8* x, float* scale, float* cnorm, MKL_INT* info );
void clatps( const char* uplo, const char* trans, const char* diag,
             const char* normin, const MKL_INT* n, const MKL_Complex8* ap,
             MKL_Complex8* x, float* scale, float* cnorm, MKL_INT* info );
void clatps_( const char* uplo, const char* trans, const char* diag,
              const char* normin, const MKL_INT* n, const MKL_Complex8* ap,
              MKL_Complex8* x, float* scale, float* cnorm, MKL_INT* info );

void CLATRD( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, float* e, MKL_Complex8* tau,
             MKL_Complex8* w, const MKL_INT* ldw );
void CLATRD_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, float* e, MKL_Complex8* tau,
              MKL_Complex8* w, const MKL_INT* ldw );
void clatrd( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
             MKL_Complex8* a, const MKL_INT* lda, float* e, MKL_Complex8* tau,
             MKL_Complex8* w, const MKL_INT* ldw );
void clatrd_( const char* uplo, const MKL_INT* n, const MKL_INT* nb,
              MKL_Complex8* a, const MKL_INT* lda, float* e, MKL_Complex8* tau,
              MKL_Complex8* w, const MKL_INT* ldw );

void CLATRS( const char* uplo, const char* trans, const char* diag,
             const char* normin, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* x, float* scale, float* cnorm,
             MKL_INT* info );
void CLATRS_( const char* uplo, const char* trans, const char* diag,
              const char* normin, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* x, float* scale, float* cnorm,
              MKL_INT* info );
void clatrs( const char* uplo, const char* trans, const char* diag,
             const char* normin, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* x, float* scale, float* cnorm,
             MKL_INT* info );
void clatrs_( const char* uplo, const char* trans, const char* diag,
              const char* normin, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* x, float* scale, float* cnorm,
              MKL_INT* info );

void CLATRZ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* work );
void CLATRZ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* work );
void clatrz( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
             MKL_Complex8* work );
void clatrz_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* l,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* tau,
              MKL_Complex8* work );

void CLATZM( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* v, const MKL_INT* incv,
             const MKL_Complex8* tau, MKL_Complex8* c1, MKL_Complex8* c2,
             const MKL_INT* ldc, MKL_Complex8* work );
void CLATZM_( const char* side, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* v, const MKL_INT* incv,
              const MKL_Complex8* tau, MKL_Complex8* c1, MKL_Complex8* c2,
              const MKL_INT* ldc, MKL_Complex8* work );
void clatzm( const char* side, const MKL_INT* m, const MKL_INT* n,
             const MKL_Complex8* v, const MKL_INT* incv,
             const MKL_Complex8* tau, MKL_Complex8* c1, MKL_Complex8* c2,
             const MKL_INT* ldc, MKL_Complex8* work );
void clatzm_( const char* side, const MKL_INT* m, const MKL_INT* n,
              const MKL_Complex8* v, const MKL_INT* incv,
              const MKL_Complex8* tau, MKL_Complex8* c1, MKL_Complex8* c2,
              const MKL_INT* ldc, MKL_Complex8* work );

void CLAUU2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info );
void CLAUU2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info );
void clauu2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info );
void clauu2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info );

void CLAUUM( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info );
void CLAUUM_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info );
void clauum( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info );
void clauum_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info );

void CPBCON( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_Complex8* ab, const MKL_INT* ldab, const float* anorm,
             float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info );
void CPBCON_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_Complex8* ab, const MKL_INT* ldab, const float* anorm,
              float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cpbcon( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_Complex8* ab, const MKL_INT* ldab, const float* anorm,
             float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cpbcon_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_Complex8* ab, const MKL_INT* ldab, const float* anorm,
              float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info );

void CPBEQU( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_Complex8* ab, const MKL_INT* ldab, float* s,
             float* scond, float* amax, MKL_INT* info );
void CPBEQU_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_Complex8* ab, const MKL_INT* ldab, float* s,
              float* scond, float* amax, MKL_INT* info );
void cpbequ( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_Complex8* ab, const MKL_INT* ldab, float* s,
             float* scond, float* amax, MKL_INT* info );
void cpbequ_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_Complex8* ab, const MKL_INT* ldab, float* s,
              float* scond, float* amax, MKL_INT* info );

void CPBRFS( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
             const MKL_Complex8* afb, const MKL_INT* ldafb,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void CPBRFS_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_Complex8* afb, const MKL_INT* ldafb,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void cpbrfs( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
             const MKL_Complex8* afb, const MKL_INT* ldafb,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void cpbrfs_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_Complex8* afb, const MKL_INT* ldafb,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );

void CPBSTF( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void CPBSTF_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void cpbstf( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void cpbstf_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );

void CPBSV( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
            const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void CPBSV_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void cpbsv( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
            const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void cpbsv_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_INT* nrhs, MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void CPBSVX( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, const MKL_INT* nrhs, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* afb, const MKL_INT* ldafb,
             char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void CPBSVX_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* kd, const MKL_INT* nrhs, MKL_Complex8* ab,
              const MKL_INT* ldab, MKL_Complex8* afb, const MKL_INT* ldafb,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cpbsvx( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* kd, const MKL_INT* nrhs, MKL_Complex8* ab,
             const MKL_INT* ldab, MKL_Complex8* afb, const MKL_INT* ldafb,
             char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cpbsvx_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* kd, const MKL_INT* nrhs, MKL_Complex8* ab,
              const MKL_INT* ldab, MKL_Complex8* afb, const MKL_INT* ldafb,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );

void CPBTF2( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void CPBTF2_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void cpbtf2( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void cpbtf2_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );

void CPBTRF( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void CPBTRF_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void cpbtrf( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );
void cpbtrf_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              MKL_Complex8* ab, const MKL_INT* ldab, MKL_INT* info );

void CPBTRS( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void CPBTRS_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void cpbtrs( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
             const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void cpbtrs_( const char* uplo, const MKL_INT* n, const MKL_INT* kd,
              const MKL_INT* nrhs, const MKL_Complex8* ab, const MKL_INT* ldab,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void CPFTRF( const char* transr, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, MKL_INT* info );
void CPFTRF_( const char* transr, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, MKL_INT* info );
void cpftrf( const char* transr, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, MKL_INT* info );
void cpftrf_( const char* transr, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, MKL_INT* info );

void CPFTRI( const char* transr, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, MKL_INT* info );
void CPFTRI_( const char* transr, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, MKL_INT* info );
void cpftri( const char* transr, const char* uplo, const MKL_INT* n,
             MKL_Complex8* a, MKL_INT* info );
void cpftri_( const char* transr, const char* uplo, const MKL_INT* n,
              MKL_Complex8* a, MKL_INT* info );

void CPFTRS( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* a, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void CPFTRS_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );
void cpftrs( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* a, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void cpftrs_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );

void CPOCON( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const float* anorm, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void CPOCON_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const float* anorm, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void cpocon( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const float* anorm, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void cpocon_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const float* anorm, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info );

void CPOEQUB( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              float* s, float* scond, float* amax, MKL_INT* info );
void CPOEQUB_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
               float* s, float* scond, float* amax, MKL_INT* info );
void cpoequb( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              float* s, float* scond, float* amax, MKL_INT* info );
void cpoequb_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
               float* s, float* scond, float* amax, MKL_INT* info );

void CPOEQU( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             float* s, float* scond, float* amax, MKL_INT* info );
void CPOEQU_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              float* s, float* scond, float* amax, MKL_INT* info );
void cpoequ( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             float* s, float* scond, float* amax, MKL_INT* info );
void cpoequ_( const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              float* s, float* scond, float* amax, MKL_INT* info );

void CPORFS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void CPORFS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void cporfs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void cporfs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );

void CPORFSX( const char* uplo, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const float* s,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void CPORFSX_( const char* uplo, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf, const float* s,
               const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info );
void cporfsx( const char* uplo, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const float* s,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void cporfsx_( const char* uplo, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf, const float* s,
               const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info );

void CPOSV( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info );
void CPOSV_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void cposv( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info );
void cposv_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );

void CPOSVX( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void CPOSVX_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void cposvx( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void cposvx_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info );

void CPOSVXX( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void CPOSVXX_( const char* fact, const char* uplo, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info );
void cposvxx( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void cposvxx_( const char* fact, const char* uplo, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, char* equed, float* s,
               MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
               const MKL_INT* ldx, float* rcond, float* rpvgrw, float* berr,
               const MKL_INT* n_err_bnds, float* err_bnds_norm,
               float* err_bnds_comp, const MKL_INT* nparams, float* params,
               MKL_Complex8* work, float* rwork, MKL_INT* info );

void CPOTF2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info );
void CPOTF2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info );
void cpotf2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info );
void cpotf2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info );

void CPOTRF( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info );
void CPOTRF_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info );
void cpotrf( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info );
void cpotrf_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info );

void CPOTRI( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info );
void CPOTRI_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info );
void cpotri( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* info );
void cpotri_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* info );

void CPOTRS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void CPOTRS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );
void cpotrs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void cpotrs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );

void CPPCON( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const float* anorm, float* rcond, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void CPPCON_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const float* anorm, float* rcond, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void cppcon( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const float* anorm, float* rcond, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void cppcon_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const float* anorm, float* rcond, MKL_Complex8* work,
              float* rwork, MKL_INT* info );

void CPPEQU( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             float* s, float* scond, float* amax, MKL_INT* info );
void CPPEQU_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              float* s, float* scond, float* amax, MKL_INT* info );
void cppequ( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             float* s, float* scond, float* amax, MKL_INT* info );
void cppequ_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              float* s, float* scond, float* amax, MKL_INT* info );

void CPPRFS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_Complex8* afp,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void CPPRFS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_Complex8* afp,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void cpprfs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_Complex8* afp,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void cpprfs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_Complex8* afp,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );

void CPPSV( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
            MKL_INT* info );
void CPPSV_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info );
void cppsv( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
            MKL_INT* info );
void cppsv_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info );

void CPPSVX( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* ap, MKL_Complex8* afp,
             char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void CPPSVX_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* ap, MKL_Complex8* afp,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cppsvx( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, MKL_Complex8* ap, MKL_Complex8* afp,
             char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cppsvx_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* ap, MKL_Complex8* afp,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );

void CPPTRF( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* info );
void CPPTRF_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* info );
void cpptrf( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* info );
void cpptrf_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* info );

void CPPTRI( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* info );
void CPPTRI_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* info );
void cpptri( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* info );
void cpptri_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* info );

void CPPTRS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info );
void CPPTRS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* info );
void cpptrs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info );
void cpptrs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* info );

void CPSTF2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank, const float* tol,
             float* work, MKL_INT* info );
void CPSTF2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank,
              const float* tol, float* work, MKL_INT* info );
void cpstf2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank, const float* tol,
             float* work, MKL_INT* info );
void cpstf2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank,
              const float* tol, float* work, MKL_INT* info );

void CPSTRF( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank, const float* tol,
             float* work, MKL_INT* info );
void CPSTRF_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank,
              const float* tol, float* work, MKL_INT* info );
void cpstrf( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank, const float* tol,
             float* work, MKL_INT* info );
void cpstrf_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* piv, MKL_INT* rank,
              const float* tol, float* work, MKL_INT* info );

void CPTCON( const MKL_INT* n, const float* d, const MKL_Complex8* e,
             const float* anorm, float* rcond, float* rwork, MKL_INT* info );
void CPTCON_( const MKL_INT* n, const float* d, const MKL_Complex8* e,
              const float* anorm, float* rcond, float* rwork, MKL_INT* info );
void cptcon( const MKL_INT* n, const float* d, const MKL_Complex8* e,
             const float* anorm, float* rcond, float* rwork, MKL_INT* info );
void cptcon_( const MKL_INT* n, const float* d, const MKL_Complex8* e,
              const float* anorm, float* rcond, float* rwork, MKL_INT* info );

void CPTEQR( const char* compz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* z, const MKL_INT* ldz, float* work, MKL_INT* info );
void CPTEQR_( const char* compz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* z, const MKL_INT* ldz, float* work,
              MKL_INT* info );
void cpteqr( const char* compz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* z, const MKL_INT* ldz, float* work, MKL_INT* info );
void cpteqr_( const char* compz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* z, const MKL_INT* ldz, float* work,
              MKL_INT* info );

void CPTRFS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, const float* df,
             const MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void CPTRFS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, const float* df,
              const MKL_Complex8* ef, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* ferr, float* berr, MKL_Complex8* work, float* rwork,
              MKL_INT* info );
void cptrfs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, const float* df,
             const MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void cptrfs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, const float* df,
              const MKL_Complex8* ef, const MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
              float* ferr, float* berr, MKL_Complex8* work, float* rwork,
              MKL_INT* info );

void CPTSV( const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void CPTSV_( const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void cptsv( const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void cptsv_( const MKL_INT* n, const MKL_INT* nrhs, float* d, MKL_Complex8* e,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void CPTSVX( const char* fact, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, float* df,
             MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void CPTSVX_( const char* fact, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, float* df,
              MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cptsvx( const char* fact, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, float* df,
             MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cptsvx_( const char* fact, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, float* df,
              MKL_Complex8* ef, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );

void CPTTRF( const MKL_INT* n, float* d, MKL_Complex8* e, MKL_INT* info );
void CPTTRF_( const MKL_INT* n, float* d, MKL_Complex8* e, MKL_INT* info );
void cpttrf( const MKL_INT* n, float* d, MKL_Complex8* e, MKL_INT* info );
void cpttrf_( const MKL_INT* n, float* d, MKL_Complex8* e, MKL_INT* info );

void CPTTRS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void CPTTRS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );
void cpttrs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void cpttrs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );

void CPTTS2( const MKL_INT* iuplo, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, MKL_Complex8* b,
             const MKL_INT* ldb );
void CPTTS2_( const MKL_INT* iuplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, MKL_Complex8* b,
              const MKL_INT* ldb );
void cptts2( const MKL_INT* iuplo, const MKL_INT* n, const MKL_INT* nrhs,
             const float* d, const MKL_Complex8* e, MKL_Complex8* b,
             const MKL_INT* ldb );
void cptts2_( const MKL_INT* iuplo, const MKL_INT* n, const MKL_INT* nrhs,
              const float* d, const MKL_Complex8* e, MKL_Complex8* b,
              const MKL_INT* ldb );

void CROT( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
           MKL_Complex8* cy, const MKL_INT* incy, const float* c,
           const MKL_Complex8* s );
void CROT_( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
            MKL_Complex8* cy, const MKL_INT* incy, const float* c,
            const MKL_Complex8* s );
void crot( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
           MKL_Complex8* cy, const MKL_INT* incy, const float* c,
           const MKL_Complex8* s );
void crot_( const MKL_INT* n, MKL_Complex8* cx, const MKL_INT* incx,
            MKL_Complex8* cy, const MKL_INT* incy, const float* c,
            const MKL_Complex8* s );

void CSPCON( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_INT* ipiv, const float* anorm, float* rcond,
             MKL_Complex8* work, MKL_INT* info );
void CSPCON_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_INT* ipiv, const float* anorm, float* rcond,
              MKL_Complex8* work, MKL_INT* info );
void cspcon( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_INT* ipiv, const float* anorm, float* rcond,
             MKL_Complex8* work, MKL_INT* info );
void cspcon_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_INT* ipiv, const float* anorm, float* rcond,
              MKL_Complex8* work, MKL_INT* info );

void CSPMV( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* ap, const MKL_Complex8* x, const MKL_INT* incx,
            const MKL_Complex8* beta, MKL_Complex8* y, const MKL_INT* incy );
void CSPMV_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
             const MKL_Complex8* ap, const MKL_Complex8* x,
             const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
             const MKL_INT* incy );
void cspmv( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* ap, const MKL_Complex8* x, const MKL_INT* incx,
            const MKL_Complex8* beta, MKL_Complex8* y, const MKL_INT* incy );
void cspmv_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
             const MKL_Complex8* ap, const MKL_Complex8* x,
             const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
             const MKL_INT* incy );

void CSPR( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
           const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* ap );
void CSPR_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* ap );
void cspr( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
           const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* ap );
void cspr_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* ap );

void CSPRFS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_Complex8* afp,
             const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void CSPRFS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_Complex8* afp,
              const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void csprfs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_Complex8* afp,
             const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void csprfs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_Complex8* afp,
              const MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* ferr, float* berr,
              MKL_Complex8* work, float* rwork, MKL_INT* info );

void CSPSV( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info );
void CSPSV_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void cspsv( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
            const MKL_INT* ldb, MKL_INT* info );
void cspsv_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* ap, MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );

void CSPSVX( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
             MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void CSPSVX_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
              MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cspsvx( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
             MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void cspsvx_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* ap, MKL_Complex8* afp,
              MKL_INT* ipiv, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );

void CSPTRF( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* ipiv, MKL_INT* info );
void CSPTRF_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* ipiv, MKL_INT* info );
void csptrf( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             MKL_INT* ipiv, MKL_INT* info );
void csptrf_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              MKL_INT* ipiv, MKL_INT* info );

void CSPTRI( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );
void CSPTRI_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );
void csptri( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
             const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );
void csptri_( const char* uplo, const MKL_INT* n, MKL_Complex8* ap,
              const MKL_INT* ipiv, MKL_Complex8* work, MKL_INT* info );

void CSPTRS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void CSPTRS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );
void csptrs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void csptrs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* ap, const MKL_INT* ipiv, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );

void CSRSCL( const MKL_INT* n, const float* sa, MKL_Complex8* sx,
             const MKL_INT* incx );
void CSRSCL_( const MKL_INT* n, const float* sa, MKL_Complex8* sx,
              const MKL_INT* incx );
void csrscl( const MKL_INT* n, const float* sa, MKL_Complex8* sx,
             const MKL_INT* incx );
void csrscl_( const MKL_INT* n, const float* sa, MKL_Complex8* sx,
              const MKL_INT* incx );

void CSTEDC( const char* compz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void CSTEDC_( const char* compz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void cstedc( const char* compz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
             const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void cstedc_( const char* compz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_Complex8* work,
              const MKL_INT* lwork, float* rwork, const MKL_INT* lrwork,
              MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );

void CSTEGR( const char* jobz, const char* range, const MKL_INT* n, float* d,
             float* e, const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz, float* work,
             const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info );
void CSTEGR_( const char* jobz, const char* range, const MKL_INT* n, float* d,
              float* e, const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
              float* work, const MKL_INT* lwork, MKL_INT* iwork,
              const MKL_INT* liwork, MKL_INT* info );
void cstegr( const char* jobz, const char* range, const MKL_INT* n, float* d,
             float* e, const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
             MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz, float* work,
             const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info );
void cstegr_( const char* jobz, const char* range, const MKL_INT* n, float* d,
              float* e, const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, const float* abstol, MKL_INT* m, float* w,
              MKL_Complex8* z, const MKL_INT* ldz, MKL_INT* isuppz,
              float* work, const MKL_INT* lwork, MKL_INT* iwork,
              const MKL_INT* liwork, MKL_INT* info );

void CSTEIN( const MKL_INT* n, const float* d, const float* e,
             const MKL_INT* m, const float* w, const MKL_INT* iblock,
             const MKL_INT* isplit, MKL_Complex8* z, const MKL_INT* ldz,
             float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void CSTEIN_( const MKL_INT* n, const float* d, const float* e,
              const MKL_INT* m, const float* w, const MKL_INT* iblock,
              const MKL_INT* isplit, MKL_Complex8* z, const MKL_INT* ldz,
              float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void cstein( const MKL_INT* n, const float* d, const float* e,
             const MKL_INT* m, const float* w, const MKL_INT* iblock,
             const MKL_INT* isplit, MKL_Complex8* z, const MKL_INT* ldz,
             float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );
void cstein_( const MKL_INT* n, const float* d, const float* e,
              const MKL_INT* m, const float* w, const MKL_INT* iblock,
              const MKL_INT* isplit, MKL_Complex8* z, const MKL_INT* ldz,
              float* work, MKL_INT* iwork, MKL_INT* ifail, MKL_INT* info );

void CSTEMR( const char* jobz, const char* range, const MKL_INT* n, float* d,
             float* e, const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, MKL_INT* m, float* w, MKL_Complex8* z,
             const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz,
             MKL_INT* tryrac, float* work, const MKL_INT* lwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void CSTEMR_( const char* jobz, const char* range, const MKL_INT* n, float* d,
              float* e, const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, MKL_INT* m, float* w, MKL_Complex8* z,
              const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz,
              MKL_INT* tryrac, float* work, const MKL_INT* lwork,
              MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void cstemr( const char* jobz, const char* range, const MKL_INT* n, float* d,
             float* e, const float* vl, const float* vu, const MKL_INT* il,
             const MKL_INT* iu, MKL_INT* m, float* w, MKL_Complex8* z,
             const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz,
             MKL_INT* tryrac, float* work, const MKL_INT* lwork,
             MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );
void cstemr_( const char* jobz, const char* range, const MKL_INT* n, float* d,
              float* e, const float* vl, const float* vu, const MKL_INT* il,
              const MKL_INT* iu, MKL_INT* m, float* w, MKL_Complex8* z,
              const MKL_INT* ldz, const MKL_INT* nzc, MKL_INT* isuppz,
              MKL_INT* tryrac, float* work, const MKL_INT* lwork,
              MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* info );

void CSTEQR( const char* compz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* z, const MKL_INT* ldz, float* work, MKL_INT* info );
void CSTEQR_( const char* compz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* z, const MKL_INT* ldz, float* work,
              MKL_INT* info );
void csteqr( const char* compz, const MKL_INT* n, float* d, float* e,
             MKL_Complex8* z, const MKL_INT* ldz, float* work, MKL_INT* info );
void csteqr_( const char* compz, const MKL_INT* n, float* d, float* e,
              MKL_Complex8* z, const MKL_INT* ldz, float* work,
              MKL_INT* info );

void CSYCON( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
             float* rcond, MKL_Complex8* work, MKL_INT* info );
void CSYCON_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
              float* rcond, MKL_Complex8* work, MKL_INT* info );
void csycon( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
             float* rcond, MKL_Complex8* work, MKL_INT* info );
void csycon_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, const float* anorm,
              float* rcond, MKL_Complex8* work, MKL_INT* info );

void CSYEQUB( char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* s, float* scond, float* amax,
              MKL_Complex8* work, MKL_INT* info );
void CSYEQUB_( char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* s, float* scond, float* amax,
               MKL_Complex8* work, MKL_INT* info );
void csyequb( char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, float* s, float* scond, float* amax,
              MKL_Complex8* work, MKL_INT* info );
void csyequb_( char* uplo, const MKL_INT* n, const MKL_Complex8* a,
               const MKL_INT* lda, float* s, float* scond, float* amax,
               MKL_Complex8* work, MKL_INT* info );

void CSYMV( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* x,
            const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
            const MKL_INT* incy );
void CSYMV_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* x,
             const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
             const MKL_INT* incy );
void csymv( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* x,
            const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
            const MKL_INT* incy );
void csymv_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* x,
             const MKL_INT* incx, const MKL_Complex8* beta, MKL_Complex8* y,
             const MKL_INT* incy );

void CSYR( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
           const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* a,
           const MKL_INT* lda );
void CSYR_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* a,
            const MKL_INT* lda );
void csyr( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
           const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* a,
           const MKL_INT* lda );
void csyr_( const char* uplo, const MKL_INT* n, const MKL_Complex8* alpha,
            const MKL_Complex8* x, const MKL_INT* incx, MKL_Complex8* a,
            const MKL_INT* lda );

void CSYRFS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info );
void CSYRFS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void csyrfs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
             float* ferr, float* berr, MKL_Complex8* work, float* rwork,
             MKL_INT* info );
void csyrfs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );

void CSYRFSX( const char* uplo, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const float* s, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void CSYRFSX_( const char* uplo, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf,
               const MKL_INT* ipiv, const float* s, const MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
               float* rcond, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info );
void csyrfsx( const char* uplo, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const float* s, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* berr,
              const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void csyrfsx_( const char* uplo, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
               const MKL_Complex8* af, const MKL_INT* ldaf,
               const MKL_INT* ipiv, const float* s, const MKL_Complex8* b,
               const MKL_INT* ldb, MKL_Complex8* x, const MKL_INT* ldx,
               float* rcond, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info );

void CSYSV( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
            const MKL_INT* lwork, MKL_INT* info );
void CSYSV_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void csysv( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
            MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
            MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
            const MKL_INT* lwork, MKL_INT* info );
void csysv_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );

void CSYSVX( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info );
void CSYSVX_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info );
void csysvx( const char* fact, const char* uplo, const MKL_INT* n,
             const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
             MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
             const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
             MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
             MKL_INT* info );
void csysvx_( const char* fact, const char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, const MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* x,
              const MKL_INT* ldx, float* rcond, float* ferr, float* berr,
              MKL_Complex8* work, const MKL_INT* lwork, float* rwork,
              MKL_INT* info );

void CSYSVXX( const char* fact, char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* rpvgrw,
              float* berr, const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void CSYSVXX_( const char* fact, char* uplo, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
               char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* x, const MKL_INT* ldx, float* rcond,
               float* rpvgrw, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info );
void csysvxx( const char* fact, char* uplo, const MKL_INT* n,
              const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
              MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
              char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* x, const MKL_INT* ldx, float* rcond, float* rpvgrw,
              float* berr, const MKL_INT* n_err_bnds, float* err_bnds_norm,
              float* err_bnds_comp, const MKL_INT* nparams, float* params,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void csysvxx_( const char* fact, char* uplo, const MKL_INT* n,
               const MKL_INT* nrhs, MKL_Complex8* a, const MKL_INT* lda,
               MKL_Complex8* af, const MKL_INT* ldaf, MKL_INT* ipiv,
               char* equed, float* s, MKL_Complex8* b, const MKL_INT* ldb,
               MKL_Complex8* x, const MKL_INT* ldx, float* rcond,
               float* rpvgrw, float* berr, const MKL_INT* n_err_bnds,
               float* err_bnds_norm, float* err_bnds_comp,
               const MKL_INT* nparams, float* params, MKL_Complex8* work,
               float* rwork, MKL_INT* info );

void CSYTF2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void CSYTF2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void csytf2( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void csytf2_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void CSYTRF( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void CSYTRF_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void csytrf( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void csytrf_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );

void CSYTRI( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
             MKL_INT* info );
void CSYTRI_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              MKL_INT* info );
void csytri( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
             MKL_INT* info );
void csytri_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_INT* ipiv, MKL_Complex8* work,
              MKL_INT* info );

void CSYTRS( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void CSYTRS_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void csytrs( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
             const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void csytrs_( const char* uplo, const MKL_INT* n, const MKL_INT* nrhs,
              const MKL_Complex8* a, const MKL_INT* lda, const MKL_INT* ipiv,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void CTBCON( const char* norm, const char* uplo, const char* diag,
             const MKL_INT* n, const MKL_INT* kd, const MKL_Complex8* ab,
             const MKL_INT* ldab, float* rcond, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void CTBCON_( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_INT* kd, const MKL_Complex8* ab,
              const MKL_INT* ldab, float* rcond, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void ctbcon( const char* norm, const char* uplo, const char* diag,
             const MKL_INT* n, const MKL_INT* kd, const MKL_Complex8* ab,
             const MKL_INT* ldab, float* rcond, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void ctbcon_( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_INT* kd, const MKL_Complex8* ab,
              const MKL_INT* ldab, float* rcond, MKL_Complex8* work,
              float* rwork, MKL_INT* info );

void CTBRFS( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
             const MKL_Complex8* ab, const MKL_INT* ldab,
             const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void CTBRFS_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
              const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void ctbrfs( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
             const MKL_Complex8* ab, const MKL_INT* ldab,
             const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void ctbrfs_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
              const MKL_Complex8* ab, const MKL_INT* ldab,
              const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );

void CTBTRS( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
             const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void CTBTRS_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
              const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );
void ctbtrs( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
             const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_INT* info );
void ctbtrs_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* kd, const MKL_INT* nrhs,
              const MKL_Complex8* ab, const MKL_INT* ldab, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_INT* info );

void CTFSM( const char* transr, const char* side, const char* uplo,
            const char* trans, const char* diag, const MKL_INT* m,
            const MKL_INT* n, const MKL_Complex8* alpha, const MKL_Complex8* a,
            MKL_Complex8* b, const MKL_INT* ldb );
void CTFSM_( const char* transr, const char* side, const char* uplo,
             const char* trans, const char* diag, const MKL_INT* m,
             const MKL_INT* n, const MKL_Complex8* alpha,
             const MKL_Complex8* a, MKL_Complex8* b, const MKL_INT* ldb );
void ctfsm( const char* transr, const char* side, const char* uplo,
            const char* trans, const char* diag, const MKL_INT* m,
            const MKL_INT* n, const MKL_Complex8* alpha, const MKL_Complex8* a,
            MKL_Complex8* b, const MKL_INT* ldb );
void ctfsm_( const char* transr, const char* side, const char* uplo,
             const char* trans, const char* diag, const MKL_INT* m,
             const MKL_INT* n, const MKL_Complex8* alpha,
             const MKL_Complex8* a, MKL_Complex8* b, const MKL_INT* ldb );

void CTFTRI( const char* transr, const char* uplo, const char* diag,
             const MKL_INT* n, MKL_Complex8* a, MKL_INT* info );
void CTFTRI_( const char* transr, const char* uplo, const char* diag,
              const MKL_INT* n, MKL_Complex8* a, MKL_INT* info );
void ctftri( const char* transr, const char* uplo, const char* diag,
             const MKL_INT* n, MKL_Complex8* a, MKL_INT* info );
void ctftri_( const char* transr, const char* uplo, const char* diag,
              const MKL_INT* n, MKL_Complex8* a, MKL_INT* info );

void CTFTTP( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* arf, MKL_Complex8* ap, MKL_INT* info );
void CTFTTP_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* arf, MKL_Complex8* ap, MKL_INT* info );
void ctfttp( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* arf, MKL_Complex8* ap, MKL_INT* info );
void ctfttp_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* arf, MKL_Complex8* ap, MKL_INT* info );

void CTFTTR( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* arf, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* info );
void CTFTTR_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* arf, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* info );
void ctfttr( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* arf, MKL_Complex8* a, const MKL_INT* lda,
             MKL_INT* info );
void ctfttr_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* arf, MKL_Complex8* a, const MKL_INT* lda,
              MKL_INT* info );

void CTGEVC( const char* side, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, const MKL_Complex8* s, const MKL_INT* lds,
             const MKL_Complex8* p, const MKL_INT* ldp, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
             MKL_INT* info );
void CTGEVC_( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, const MKL_Complex8* s, const MKL_INT* lds,
              const MKL_Complex8* p, const MKL_INT* ldp, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
              MKL_INT* info );
void ctgevc( const char* side, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, const MKL_Complex8* s, const MKL_INT* lds,
             const MKL_Complex8* p, const MKL_INT* ldp, MKL_Complex8* vl,
             const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
             const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
             MKL_INT* info );
void ctgevc_( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, const MKL_Complex8* s, const MKL_INT* lds,
              const MKL_Complex8* p, const MKL_INT* ldp, MKL_Complex8* vl,
              const MKL_INT* ldvl, MKL_Complex8* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work, float* rwork,
              MKL_INT* info );

void CTGEX2( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* j1,
             MKL_INT* info );
void CTGEX2_( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* j1,
              MKL_INT* info );
void ctgex2( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* j1,
             MKL_INT* info );
void ctgex2_( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* j1,
              MKL_INT* info );

void CTGEXC( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* ifst,
             MKL_INT* ilst, MKL_INT* info );
void CTGEXC_( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* ifst,
              MKL_INT* ilst, MKL_INT* info );
void ctgexc( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
             const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* ifst,
             MKL_INT* ilst, MKL_INT* info );
void ctgexc_( const MKL_INT* wantq, const MKL_INT* wantz, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* b,
              const MKL_INT* ldb, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* z, const MKL_INT* ldz, const MKL_INT* ifst,
              MKL_INT* ilst, MKL_INT* info );

void CTGSEN( const MKL_INT* ijob, const MKL_INT* wantq, const MKL_INT* wantz,
             const MKL_INT* select, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* q,
             const MKL_INT* ldq, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* m, float* pl, float* pr, float* dif, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info );
void CTGSEN_( const MKL_INT* ijob, const MKL_INT* wantq, const MKL_INT* wantz,
              const MKL_INT* select, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* q,
              const MKL_INT* ldq, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* m, float* pl, float* pr, float* dif, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info );
void ctgsen( const MKL_INT* ijob, const MKL_INT* wantq, const MKL_INT* wantz,
             const MKL_INT* select, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* q,
             const MKL_INT* ldq, MKL_Complex8* z, const MKL_INT* ldz,
             MKL_INT* m, float* pl, float* pr, float* dif, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* info );
void ctgsen_( const MKL_INT* ijob, const MKL_INT* wantq, const MKL_INT* wantz,
              const MKL_INT* select, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* alpha, MKL_Complex8* beta, MKL_Complex8* q,
              const MKL_INT* ldq, MKL_Complex8* z, const MKL_INT* ldz,
              MKL_INT* m, float* pl, float* pr, float* dif, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* info );

void CTGSJA( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
             const MKL_INT* k, const MKL_INT* l, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             const float* tola, const float* tolb, float* alpha, float* beta,
             MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
             const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* work, MKL_INT* ncycle, MKL_INT* info );
void CTGSJA_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
              const MKL_INT* k, const MKL_INT* l, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              const float* tola, const float* tolb, float* alpha, float* beta,
              MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* work, MKL_INT* ncycle, MKL_INT* info );
void ctgsja( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
             const MKL_INT* k, const MKL_INT* l, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             const float* tola, const float* tolb, float* alpha, float* beta,
             MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
             const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* work, MKL_INT* ncycle, MKL_INT* info );
void ctgsja_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* p, const MKL_INT* n,
              const MKL_INT* k, const MKL_INT* l, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              const float* tola, const float* tolb, float* alpha, float* beta,
              MKL_Complex8* u, const MKL_INT* ldu, MKL_Complex8* v,
              const MKL_INT* ldv, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* work, MKL_INT* ncycle, MKL_INT* info );

void CTGSNA( const char* job, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* vl,
             const MKL_INT* ldvl, const MKL_Complex8* vr, const MKL_INT* ldvr,
             float* s, float* dif, const MKL_INT* mm, MKL_INT* m,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* iwork,
             MKL_INT* info );
void CTGSNA_( const char* job, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* b, const MKL_INT* ldb,
              const MKL_Complex8* vl, const MKL_INT* ldvl,
              const MKL_Complex8* vr, const MKL_INT* ldvr, float* s,
              float* dif, const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void ctgsna( const char* job, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* vl,
             const MKL_INT* ldvl, const MKL_Complex8* vr, const MKL_INT* ldvr,
             float* s, float* dif, const MKL_INT* mm, MKL_INT* m,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* iwork,
             MKL_INT* info );
void ctgsna_( const char* job, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* b, const MKL_INT* ldb,
              const MKL_Complex8* vl, const MKL_INT* ldvl,
              const MKL_Complex8* vr, const MKL_INT* ldvr, float* s,
              float* dif, const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );

void CTGSY2( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
             const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
             const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
             const MKL_INT* ldf, float* scale, float* rdsum, float* rdscal,
             MKL_INT* info );
void CTGSY2_( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
              const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
              const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
              const MKL_INT* ldf, float* scale, float* rdsum, float* rdscal,
              MKL_INT* info );
void ctgsy2( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
             const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
             const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
             const MKL_INT* ldf, float* scale, float* rdsum, float* rdscal,
             MKL_INT* info );
void ctgsy2_( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
              const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
              const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
              const MKL_INT* ldf, float* scale, float* rdsum, float* rdscal,
              MKL_INT* info );

void CTGSYL( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
             const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
             const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
             const MKL_INT* ldf, float* scale, float* dif, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void CTGSYL_( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
              const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
              const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
              const MKL_INT* ldf, float* scale, float* dif, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void ctgsyl( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
             const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
             const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
             const MKL_INT* ldf, float* scale, float* dif, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void ctgsyl_( const char* trans, const MKL_INT* ijob, const MKL_INT* m,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* b, const MKL_INT* ldb, MKL_Complex8* c,
              const MKL_INT* ldc, const MKL_Complex8* d, const MKL_INT* ldd,
              const MKL_Complex8* e, const MKL_INT* lde, MKL_Complex8* f,
              const MKL_INT* ldf, float* scale, float* dif, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );

void CTPCON( const char* norm, const char* uplo, const char* diag,
             const MKL_INT* n, const MKL_Complex8* ap, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void CTPCON_( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_Complex8* ap, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void ctpcon( const char* norm, const char* uplo, const char* diag,
             const MKL_INT* n, const MKL_Complex8* ap, float* rcond,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void ctpcon_( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_Complex8* ap, float* rcond,
              MKL_Complex8* work, float* rwork, MKL_INT* info );

void CTPRFS( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
             const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void CTPRFS_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
              const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );
void ctprfs( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
             const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
             const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
             float* rwork, MKL_INT* info );
void ctprfs_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
              const MKL_Complex8* b, const MKL_INT* ldb, const MKL_Complex8* x,
              const MKL_INT* ldx, float* ferr, float* berr, MKL_Complex8* work,
              float* rwork, MKL_INT* info );

void CTPTRI( const char* uplo, const char* diag, const MKL_INT* n,
             MKL_Complex8* ap, MKL_INT* info );
void CTPTRI_( const char* uplo, const char* diag, const MKL_INT* n,
              MKL_Complex8* ap, MKL_INT* info );
void ctptri( const char* uplo, const char* diag, const MKL_INT* n,
             MKL_Complex8* ap, MKL_INT* info );
void ctptri_( const char* uplo, const char* diag, const MKL_INT* n,
              MKL_Complex8* ap, MKL_INT* info );

void CTPTRS( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void CTPTRS_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void ctptrs( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
             MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );
void ctptrs_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* ap,
              MKL_Complex8* b, const MKL_INT* ldb, MKL_INT* info );

void CTPTTF( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* ap, MKL_Complex8* arf, MKL_INT* info );
void CTPTTF_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* ap, MKL_Complex8* arf, MKL_INT* info );
void ctpttf( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* ap, MKL_Complex8* arf, MKL_INT* info );
void ctpttf_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* ap, MKL_Complex8* arf, MKL_INT* info );

void CTPTTR( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void CTPTTR_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void ctpttr( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void ctpttr_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );

void CTRCON( const char* norm, const char* uplo, const char* diag,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info );
void CTRCON_( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info );
void ctrcon( const char* norm, const char* uplo, const char* diag,
             const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
             float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info );
void ctrcon_( const char* norm, const char* uplo, const char* diag,
              const MKL_INT* n, const MKL_Complex8* a, const MKL_INT* lda,
              float* rcond, MKL_Complex8* work, float* rwork, MKL_INT* info );

void CTREVC( const char* side, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void CTREVC_( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
              const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
              MKL_Complex8* work, float* rwork, MKL_INT* info );
void ctrevc( const char* side, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
             const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
             MKL_Complex8* work, float* rwork, MKL_INT* info );
void ctrevc_( const char* side, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* vl, const MKL_INT* ldvl, MKL_Complex8* vr,
              const MKL_INT* ldvr, const MKL_INT* mm, MKL_INT* m,
              MKL_Complex8* work, float* rwork, MKL_INT* info );

void CTREXC( const char* compq, const MKL_INT* n, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* q, const MKL_INT* ldq,
             const MKL_INT* ifst, const MKL_INT* ilst, MKL_INT* info );
void CTREXC_( const char* compq, const MKL_INT* n, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* q, const MKL_INT* ldq,
              const MKL_INT* ifst, const MKL_INT* ilst, MKL_INT* info );
void ctrexc( const char* compq, const MKL_INT* n, MKL_Complex8* t,
             const MKL_INT* ldt, MKL_Complex8* q, const MKL_INT* ldq,
             const MKL_INT* ifst, const MKL_INT* ilst, MKL_INT* info );
void ctrexc_( const char* compq, const MKL_INT* n, MKL_Complex8* t,
              const MKL_INT* ldt, MKL_Complex8* q, const MKL_INT* ldq,
              const MKL_INT* ifst, const MKL_INT* ilst, MKL_INT* info );

void CTRRFS( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
             const MKL_Complex8* x, const MKL_INT* ldx, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void CTRRFS_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
              const MKL_Complex8* x, const MKL_INT* ldx, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void ctrrfs( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
             const MKL_Complex8* x, const MKL_INT* ldx, float* ferr,
             float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );
void ctrrfs_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
              const MKL_Complex8* x, const MKL_INT* ldx, float* ferr,
              float* berr, MKL_Complex8* work, float* rwork, MKL_INT* info );

void CTRSEN( const char* job, const char* compq, const MKL_INT* select,
             const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* w, MKL_INT* m,
             float* s, float* sep, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CTRSEN_( const char* job, const char* compq, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* w, MKL_INT* m,
              float* s, float* sep, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void ctrsen( const char* job, const char* compq, const MKL_INT* select,
             const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
             MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* w, MKL_INT* m,
             float* s, float* sep, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void ctrsen_( const char* job, const char* compq, const MKL_INT* select,
              const MKL_INT* n, MKL_Complex8* t, const MKL_INT* ldt,
              MKL_Complex8* q, const MKL_INT* ldq, MKL_Complex8* w, MKL_INT* m,
              float* s, float* sep, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );

void CTRSNA( const char* job, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, const MKL_Complex8* t, const MKL_INT* ldt,
             const MKL_Complex8* vl, const MKL_INT* ldvl,
             const MKL_Complex8* vr, const MKL_INT* ldvr, float* s, float* sep,
             const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
             const MKL_INT* ldwork, float* rwork, MKL_INT* info );
void CTRSNA_( const char* job, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, const MKL_Complex8* t, const MKL_INT* ldt,
              const MKL_Complex8* vl, const MKL_INT* ldvl,
              const MKL_Complex8* vr, const MKL_INT* ldvr, float* s,
              float* sep, const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
              const MKL_INT* ldwork, float* rwork, MKL_INT* info );
void ctrsna( const char* job, const char* howmny, const MKL_INT* select,
             const MKL_INT* n, const MKL_Complex8* t, const MKL_INT* ldt,
             const MKL_Complex8* vl, const MKL_INT* ldvl,
             const MKL_Complex8* vr, const MKL_INT* ldvr, float* s, float* sep,
             const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
             const MKL_INT* ldwork, float* rwork, MKL_INT* info );
void ctrsna_( const char* job, const char* howmny, const MKL_INT* select,
              const MKL_INT* n, const MKL_Complex8* t, const MKL_INT* ldt,
              const MKL_Complex8* vl, const MKL_INT* ldvl,
              const MKL_Complex8* vr, const MKL_INT* ldvr, float* s,
              float* sep, const MKL_INT* mm, MKL_INT* m, MKL_Complex8* work,
              const MKL_INT* ldwork, float* rwork, MKL_INT* info );

void CTRSYL( const char* trana, const char* tranb, const MKL_INT* isgn,
             const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* c, const MKL_INT* ldc, float* scale,
             MKL_INT* info );
void CTRSYL_( const char* trana, const char* tranb, const MKL_INT* isgn,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* c, const MKL_INT* ldc, float* scale,
              MKL_INT* info );
void ctrsyl( const char* trana, const char* tranb, const MKL_INT* isgn,
             const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
             MKL_Complex8* c, const MKL_INT* ldc, float* scale,
             MKL_INT* info );
void ctrsyl_( const char* trana, const char* tranb, const MKL_INT* isgn,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* b, const MKL_INT* ldb,
              MKL_Complex8* c, const MKL_INT* ldc, float* scale,
              MKL_INT* info );

void CTRTI2( const char* uplo, const char* diag, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void CTRTI2_( const char* uplo, const char* diag, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void ctrti2( const char* uplo, const char* diag, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void ctrti2_( const char* uplo, const char* diag, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );

void CTRTRI( const char* uplo, const char* diag, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void CTRTRI_( const char* uplo, const char* diag, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void ctrtri( const char* uplo, const char* diag, const MKL_INT* n,
             MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );
void ctrtri_( const char* uplo, const char* diag, const MKL_INT* n,
              MKL_Complex8* a, const MKL_INT* lda, MKL_INT* info );

void CTRTRS( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info );
void CTRTRS_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* info );
void ctrtrs( const char* uplo, const char* trans, const char* diag,
             const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
             MKL_INT* info );
void ctrtrs_( const char* uplo, const char* trans, const char* diag,
              const MKL_INT* n, const MKL_INT* nrhs, const MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* b, const MKL_INT* ldb,
              MKL_INT* info );

void CTRTTF( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* arf,
             MKL_INT* info );
void CTRTTF_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* arf,
              MKL_INT* info );
void ctrttf( const char* transr, const char* uplo, const MKL_INT* n,
             const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* arf,
             MKL_INT* info );
void ctrttf_( const char* transr, const char* uplo, const MKL_INT* n,
              const MKL_Complex8* a, const MKL_INT* lda, MKL_Complex8* arf,
              MKL_INT* info );

void CTRTTP( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* ap, MKL_INT* info );
void CTRTTP_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* ap, MKL_INT* info );
void ctrttp( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* ap, MKL_INT* info );
void ctrttp_( const char* uplo, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* ap, MKL_INT* info );

void CTZRQF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_INT* info );
void CTZRQF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_INT* info );
void ctzrqf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_INT* info );
void ctzrqf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_INT* info );

void CTZRZF( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void CTZRZF_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void ctzrzf( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void ctzrzf_( const MKL_INT* m, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );

void CUNG2L( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info );
void CUNG2L_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info );
void cung2l( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info );
void cung2l_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info );

void CUNG2R( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info );
void CUNG2R_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info );
void cung2r( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info );
void cung2r_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info );

void CUNGBR( const char* vect, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* k, MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CUNGBR_( const char* vect, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* k, MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void cungbr( const char* vect, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* k, MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void cungbr_( const char* vect, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* k, MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );

void CUNGHR( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CUNGHR_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunghr( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunghr_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CUNGL2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info );
void CUNGL2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info );
void cungl2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info );
void cungl2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info );

void CUNGLQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CUNGLQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunglq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunglq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CUNGQL( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CUNGQL_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cungql( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cungql_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CUNGQR( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CUNGQR_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cungqr( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cungqr_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CUNGR2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info );
void CUNGR2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info );
void cungr2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, MKL_INT* info );
void cungr2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, MKL_INT* info );

void CUNGRQ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CUNGRQ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cungrq( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cungrq_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              MKL_Complex8* a, const MKL_INT* lda, const MKL_Complex8* tau,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CUNGTR( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void CUNGTR_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );
void cungtr( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* work,
             const MKL_INT* lwork, MKL_INT* info );
void cungtr_( const char* uplo, const MKL_INT* n, MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* work,
              const MKL_INT* lwork, MKL_INT* info );

void CUNM2L( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );
void CUNM2L_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );
void cunm2l( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );
void cunm2l_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );

void CUNM2R( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );
void CUNM2R_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );
void cunm2r( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );
void cunm2r_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );

void CUNMBR( const char* vect, const char* side, const char* trans,
             const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CUNMBR_( const char* vect, const char* side, const char* trans,
              const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunmbr( const char* vect, const char* side, const char* trans,
             const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunmbr_( const char* vect, const char* side, const char* trans,
              const MKL_INT* m, const MKL_INT* n, const MKL_INT* k,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CUNMHR( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CUNMHR_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunmhr( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunmhr_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CUNML2( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );
void CUNML2_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );
void cunml2( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );
void cunml2_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );

void CUNMLQ( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CUNMLQ_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void cunmlq( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void cunmlq_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );

void CUNMQL( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CUNMQL_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void cunmql( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void cunmql_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );

void CUNMQR( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CUNMQR_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void cunmqr( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void cunmqr_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );

void CUNMR2( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );
void CUNMR2_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );
void cunmr2( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );
void cunmr2_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, MKL_INT* info );

void CUNMR3( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, MKL_INT* info );
void CUNMR3_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info );
void cunmr3( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, MKL_INT* info );
void cunmr3_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info );

void CUNMRQ( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CUNMRQ_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void cunmrq( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void cunmrq_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );

void CUNMRZ( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void CUNMRZ_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunmrz( const char* side, const char* trans, const MKL_INT* m,
             const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
             const MKL_Complex8* a, const MKL_INT* lda,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );
void cunmrz_( const char* side, const char* trans, const MKL_INT* m,
              const MKL_INT* n, const MKL_INT* k, const MKL_INT* l,
              const MKL_Complex8* a, const MKL_INT* lda,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, const MKL_INT* lwork, MKL_INT* info );

void CUNMTR( const char* side, const char* uplo, const char* trans,
             const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void CUNMTR_( const char* side, const char* uplo, const char* trans,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );
void cunmtr( const char* side, const char* uplo, const char* trans,
             const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
             const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
             const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
             MKL_INT* info );
void cunmtr_( const char* side, const char* uplo, const char* trans,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* a,
              const MKL_INT* lda, const MKL_Complex8* tau, MKL_Complex8* c,
              const MKL_INT* ldc, MKL_Complex8* work, const MKL_INT* lwork,
              MKL_INT* info );

void CUPGTR( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_Complex8* tau, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* work, MKL_INT* info );
void CUPGTR_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_Complex8* tau, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* work, MKL_INT* info );
void cupgtr( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_Complex8* tau, MKL_Complex8* q, const MKL_INT* ldq,
             MKL_Complex8* work, MKL_INT* info );
void cupgtr_( const char* uplo, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_Complex8* tau, MKL_Complex8* q, const MKL_INT* ldq,
              MKL_Complex8* work, MKL_INT* info );

void CUPMTR( const char* side, const char* uplo, const char* trans,
             const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, MKL_INT* info );
void CUPMTR_( const char* side, const char* uplo, const char* trans,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info );
void cupmtr( const char* side, const char* uplo, const char* trans,
             const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* ap,
             const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
             MKL_Complex8* work, MKL_INT* info );
void cupmtr_( const char* side, const char* uplo, const char* trans,
              const MKL_INT* m, const MKL_INT* n, const MKL_Complex8* ap,
              const MKL_Complex8* tau, MKL_Complex8* c, const MKL_INT* ldc,
              MKL_Complex8* work, MKL_INT* info );

void DBDSDC( const char* uplo, const char* compq, const MKL_INT* n, double* d,
             double* e, double* u, const MKL_INT* ldu, double* vt,
             const MKL_INT* ldvt, double* q, MKL_INT* iq, double* work,
             MKL_INT* iwork, MKL_INT* info );
void DBDSDC_( const char* uplo, const char* compq, const MKL_INT* n, double* d,
              double* e, double* u, const MKL_INT* ldu, double* vt,
              const MKL_INT* ldvt, double* q, MKL_INT* iq, double* work,
              MKL_INT* iwork, MKL_INT* info );
void dbdsdc( const char* uplo, const char* compq, const MKL_INT* n, double* d,
             double* e, double* u, const MKL_INT* ldu, double* vt,
             const MKL_INT* ldvt, double* q, MKL_INT* iq, double* work,
             MKL_INT* iwork, MKL_INT* info );
void dbdsdc_( const char* uplo, const char* compq, const MKL_INT* n, double* d,
              double* e, double* u, const MKL_INT* ldu, double* vt,
              const MKL_INT* ldvt, double* q, MKL_INT* iq, double* work,
              MKL_INT* iwork, MKL_INT* info );

void DBDSQR( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
             const MKL_INT* nru, const MKL_INT* ncc, double* d, double* e,
             double* vt, const MKL_INT* ldvt, double* u, const MKL_INT* ldu,
             double* c, const MKL_INT* ldc, double* work, MKL_INT* info );
void DBDSQR_( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
              const MKL_INT* nru, const MKL_INT* ncc, double* d, double* e,
              double* vt, const MKL_INT* ldvt, double* u, const MKL_INT* ldu,
              double* c, const MKL_INT* ldc, double* work, MKL_INT* info );
void dbdsqr( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
             const MKL_INT* nru, const MKL_INT* ncc, double* d, double* e,
             double* vt, const MKL_INT* ldvt, double* u, const MKL_INT* ldu,
             double* c, const MKL_INT* ldc, double* work, MKL_INT* info );
void dbdsqr_( const char* uplo, const MKL_INT* n, const MKL_INT* ncvt,
              const MKL_INT* nru, const MKL_INT* ncc, double* d, double* e,
              double* vt, const MKL_INT* ldvt, double* u, const MKL_INT* ldu,
              double* c, const MKL_INT* ldc, double* work, MKL_INT* info );

void DDISNA( const char* job, const MKL_INT* m, const MKL_INT* n,
             const double* d, double* sep, MKL_INT* info );
void DDISNA_( const char* job, const MKL_INT* m, const MKL_INT* n,
              const double* d, double* sep, MKL_INT* info );
void ddisna( const char* job, const MKL_INT* m, const MKL_INT* n,
             const double* d, double* sep, MKL_INT* info );
void ddisna_( const char* job, const MKL_INT* m, const MKL_INT* n,
              const double* d, double* sep, MKL_INT* info );

void DGBBRD( const char* vect, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
             double* ab, const MKL_INT* ldab, double* d, double* e, double* q,
             const MKL_INT* ldq, double* pt, const MKL_INT* ldpt, double* c,
             const MKL_INT* ldc, double* work, MKL_INT* info );
void DGBBRD_( const char* vect, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
              double* ab, const MKL_INT* ldab, double* d, double* e, double* q,
              const MKL_INT* ldq, double* pt, const MKL_INT* ldpt, double* c,
              const MKL_INT* ldc, double* work, MKL_INT* info );
void dgbbrd( const char* vect, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
             double* ab, const MKL_INT* ldab, double* d, double* e, double* q,
             const MKL_INT* ldq, double* pt, const MKL_INT* ldpt, double* c,
             const MKL_INT* ldc, double* work, MKL_INT* info );
void dgbbrd_( const char* vect, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* ncc, const MKL_INT* kl, const MKL_INT* ku,
              double* ab, const MKL_INT* ldab, double* d, double* e, double* q,
              const MKL_INT* ldq, double* pt, const MKL_INT* ldpt, double* c,
              const MKL_INT* ldc, double* work, MKL_INT* info );

void DGBCON( const char* norm, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
             const MKL_INT* ipiv, const double* anorm, double* rcond,
             double* work, MKL_INT* iwork, MKL_INT* info );
void DGBCON_( const char* norm, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
              const MKL_INT* ipiv, const double* anorm, double* rcond,
              double* work, MKL_INT* iwork, MKL_INT* info );
void dgbcon( const char* norm, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
             const MKL_INT* ipiv, const double* anorm, double* rcond,
             double* work, MKL_INT* iwork, MKL_INT* info );
void dgbcon_( const char* norm, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
              const MKL_INT* ipiv, const double* anorm, double* rcond,
              double* work, MKL_INT* iwork, MKL_INT* info );

void DGBEQUB( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
              double* r, double* c, double* rowcnd, double* colcnd,
              double* amax, MKL_INT* info );
void DGBEQUB_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
               const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
               double* r, double* c, double* rowcnd, double* colcnd,
               double* amax, MKL_INT* info );
void dgbequb( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
              double* r, double* c, double* rowcnd, double* colcnd,
              double* amax, MKL_INT* info );
void dgbequb_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
               const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
               double* r, double* c, double* rowcnd, double* colcnd,
               double* amax, MKL_INT* info );

void DGBEQU( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
             double* r, double* c, double* rowcnd, double* colcnd,
             double* amax, MKL_INT* info );
void DGBEQU_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
              double* r, double* c, double* rowcnd, double* colcnd,
              double* amax, MKL_INT* info );
void dgbequ( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
             double* r, double* c, double* rowcnd, double* colcnd,
             double* amax, MKL_INT* info );
void dgbequ_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
              double* r, double* c, double* rowcnd, double* colcnd,
              double* amax, MKL_INT* info );

void DGBRFS( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
             const MKL_INT* ldab, const double* afb, const MKL_INT* ldafb,
             const MKL_INT* ipiv, const double* b, const MKL_INT* ldb,
             double* x, const MKL_INT* ldx, double* ferr, double* berr,
             double* work, MKL_INT* iwork, MKL_INT* info );
void DGBRFS_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
              const MKL_INT* ldab, const double* afb, const MKL_INT* ldafb,
              const MKL_INT* ipiv, const double* b, const MKL_INT* ldb,
              double* x, const MKL_INT* ldx, double* ferr, double* berr,
              double* work, MKL_INT* iwork, MKL_INT* info );
void dgbrfs( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
             const MKL_INT* ldab, const double* afb, const MKL_INT* ldafb,
             const MKL_INT* ipiv, const double* b, const MKL_INT* ldb,
             double* x, const MKL_INT* ldx, double* ferr, double* berr,
             double* work, MKL_INT* iwork, MKL_INT* info );
void dgbrfs_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
              const MKL_INT* ldab, const double* afb, const MKL_INT* ldafb,
              const MKL_INT* ipiv, const double* b, const MKL_INT* ldb,
              double* x, const MKL_INT* ldx, double* ferr, double* berr,
              double* work, MKL_INT* iwork, MKL_INT* info );

void DGBRFSX( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              const double* ab, const MKL_INT* ldab, const double* afb,
              const MKL_INT* ldafb, const MKL_INT* ipiv, const double* r,
              const double* c, const double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* berr,
              const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info );
void DGBRFSX_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               const double* ab, const MKL_INT* ldab, const double* afb,
               const MKL_INT* ldafb, const MKL_INT* ipiv, const double* r,
               const double* c, const double* b, const MKL_INT* ldb, double* x,
               const MKL_INT* ldx, double* rcond, double* berr,
               const MKL_INT* n_err_bnds, double* err_bnds_norm,
               double* err_bnds_comp, const MKL_INT* nparams, double* params,
               double* work, MKL_INT* iwork, MKL_INT* info );
void dgbrfsx( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              const double* ab, const MKL_INT* ldab, const double* afb,
              const MKL_INT* ldafb, const MKL_INT* ipiv, const double* r,
              const double* c, const double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* berr,
              const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info );
void dgbrfsx_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               const double* ab, const MKL_INT* ldab, const double* afb,
               const MKL_INT* ldafb, const MKL_INT* ipiv, const double* r,
               const double* c, const double* b, const MKL_INT* ldb, double* x,
               const MKL_INT* ldx, double* rcond, double* berr,
               const MKL_INT* n_err_bnds, double* err_bnds_norm,
               double* err_bnds_comp, const MKL_INT* nparams, double* params,
               double* work, MKL_INT* iwork, MKL_INT* info );

void DGBSV( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
            const MKL_INT* nrhs, double* ab, const MKL_INT* ldab,
            MKL_INT* ipiv, double* b, const MKL_INT* ldb, MKL_INT* info );
void DGBSV_( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
             const MKL_INT* nrhs, double* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, double* b, const MKL_INT* ldb, MKL_INT* info );
void dgbsv( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
            const MKL_INT* nrhs, double* ab, const MKL_INT* ldab,
            MKL_INT* ipiv, double* b, const MKL_INT* ldb, MKL_INT* info );
void dgbsv_( const MKL_INT* n, const MKL_INT* kl, const MKL_INT* ku,
             const MKL_INT* nrhs, double* ab, const MKL_INT* ldab,
             MKL_INT* ipiv, double* b, const MKL_INT* ldb, MKL_INT* info );

void DGBSVX( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
             double* ab, const MKL_INT* ldab, double* afb,
             const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
             double* c, double* b, const MKL_INT* ldb, double* x,
             const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
             double* work, MKL_INT* iwork, MKL_INT* info );
void DGBSVX_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              double* ab, const MKL_INT* ldab, double* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
              double* work, MKL_INT* iwork, MKL_INT* info );
void dgbsvx( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
             double* ab, const MKL_INT* ldab, double* afb,
             const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
             double* c, double* b, const MKL_INT* ldb, double* x,
             const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
             double* work, MKL_INT* iwork, MKL_INT* info );
void dgbsvx_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              double* ab, const MKL_INT* ldab, double* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
              double* work, MKL_INT* iwork, MKL_INT* info );

void DGBSVXX( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              double* ab, const MKL_INT* ldab, double* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
              const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info );
void DGBSVXX_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               double* ab, const MKL_INT* ldab, double* afb,
               const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
               double* c, double* b, const MKL_INT* ldb, double* x,
               const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
               const MKL_INT* n_err_bnds, double* err_bnds_norm,
               double* err_bnds_comp, const MKL_INT* nparams, double* params,
               double* work, MKL_INT* iwork, MKL_INT* info );
void dgbsvxx( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
              double* ab, const MKL_INT* ldab, double* afb,
              const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
              const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info );
void dgbsvxx_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* kl, const MKL_INT* ku, const MKL_INT* nrhs,
               double* ab, const MKL_INT* ldab, double* afb,
               const MKL_INT* ldafb, MKL_INT* ipiv, char* equed, double* r,
               double* c, double* b, const MKL_INT* ldb, double* x,
               const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
               const MKL_INT* n_err_bnds, double* err_bnds_norm,
               double* err_bnds_comp, const MKL_INT* nparams, double* params,
               double* work, MKL_INT* iwork, MKL_INT* info );

void DGBTF2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* ipiv,
             MKL_INT* info );
void DGBTF2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, double* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info );
void dgbtf2( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* ipiv,
             MKL_INT* info );
void dgbtf2_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, double* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info );

void DGBTRF( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* ipiv,
             MKL_INT* info );
void DGBTRF_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, double* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info );
void dgbtrf( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, double* ab, const MKL_INT* ldab, MKL_INT* ipiv,
             MKL_INT* info );
void dgbtrf_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, double* ab, const MKL_INT* ldab,
              MKL_INT* ipiv, MKL_INT* info );

void DGBTRS( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
             const MKL_INT* ldab, const MKL_INT* ipiv, double* b,
             const MKL_INT* ldb, MKL_INT* info );
void DGBTRS_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
              const MKL_INT* ldab, const MKL_INT* ipiv, double* b,
              const MKL_INT* ldb, MKL_INT* info );
void dgbtrs( const char* trans, const MKL_INT* n, const MKL_INT* kl,
             const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
             const MKL_INT* ldab, const MKL_INT* ipiv, double* b,
             const MKL_INT* ldb, MKL_INT* info );
void dgbtrs_( const char* trans, const MKL_INT* n, const MKL_INT* kl,
              const MKL_INT* ku, const MKL_INT* nrhs, const double* ab,
              const MKL_INT* ldab, const MKL_INT* ipiv, double* b,
              const MKL_INT* ldb, MKL_INT* info );

void DGEBAK( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const double* scale,
             const MKL_INT* m, double* v, const MKL_INT* ldv, MKL_INT* info );
void DGEBAK_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const double* scale,
              const MKL_INT* m, double* v, const MKL_INT* ldv, MKL_INT* info );
void dgebak( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const double* scale,
             const MKL_INT* m, double* v, const MKL_INT* ldv, MKL_INT* info );
void dgebak_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const double* scale,
              const MKL_INT* m, double* v, const MKL_INT* ldv, MKL_INT* info );

void DGEBAL( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info );
void DGEBAL_( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
              MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info );
void dgebal( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info );
void dgebal_( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
              MKL_INT* ilo, MKL_INT* ihi, double* scale, MKL_INT* info );

void DGEBD2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* d, double* e, double* tauq, double* taup, double* work,
             MKL_INT* info );
void DGEBD2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* d, double* e, double* tauq,
              double* taup, double* work, MKL_INT* info );
void dgebd2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* d, double* e, double* tauq, double* taup, double* work,
             MKL_INT* info );
void dgebd2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* d, double* e, double* tauq,
              double* taup, double* work, MKL_INT* info );

void DGEBRD( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* d, double* e, double* tauq, double* taup, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void DGEBRD_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* d, double* e, double* tauq,
              double* taup, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void dgebrd( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* d, double* e, double* tauq, double* taup, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void dgebrd_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* d, double* e, double* tauq,
              double* taup, double* work, const MKL_INT* lwork,
              MKL_INT* info );

void DGECON( const char* norm, const MKL_INT* n, const double* a,
             const MKL_INT* lda, const double* anorm, double* rcond,
             double* work, MKL_INT* iwork, MKL_INT* info );
void DGECON_( const char* norm, const MKL_INT* n, const double* a,
              const MKL_INT* lda, const double* anorm, double* rcond,
              double* work, MKL_INT* iwork, MKL_INT* info );
void dgecon( const char* norm, const MKL_INT* n, const double* a,
             const MKL_INT* lda, const double* anorm, double* rcond,
             double* work, MKL_INT* iwork, MKL_INT* info );
void dgecon_( const char* norm, const MKL_INT* n, const double* a,
              const MKL_INT* lda, const double* anorm, double* rcond,
              double* work, MKL_INT* iwork, MKL_INT* info );

void DGEEQUB( const MKL_INT* m, const MKL_INT* n, const double* a,
              const MKL_INT* lda, double* r, double* c, double* rowcnd,
              double* colcnd, double* amax, MKL_INT* info );
void DGEEQUB_( const MKL_INT* m, const MKL_INT* n, const double* a,
               const MKL_INT* lda, double* r, double* c, double* rowcnd,
               double* colcnd, double* amax, MKL_INT* info );
void dgeequb( const MKL_INT* m, const MKL_INT* n, const double* a,
              const MKL_INT* lda, double* r, double* c, double* rowcnd,
              double* colcnd, double* amax, MKL_INT* info );
void dgeequb_( const MKL_INT* m, const MKL_INT* n, const double* a,
               const MKL_INT* lda, double* r, double* c, double* rowcnd,
               double* colcnd, double* amax, MKL_INT* info );

void DGEEQU( const MKL_INT* m, const MKL_INT* n, const double* a,
             const MKL_INT* lda, double* r, double* c, double* rowcnd,
             double* colcnd, double* amax, MKL_INT* info );
void DGEEQU_( const MKL_INT* m, const MKL_INT* n, const double* a,
              const MKL_INT* lda, double* r, double* c, double* rowcnd,
              double* colcnd, double* amax, MKL_INT* info );
void dgeequ( const MKL_INT* m, const MKL_INT* n, const double* a,
             const MKL_INT* lda, double* r, double* c, double* rowcnd,
             double* colcnd, double* amax, MKL_INT* info );
void dgeequ_( const MKL_INT* m, const MKL_INT* n, const double* a,
              const MKL_INT* lda, double* r, double* c, double* rowcnd,
              double* colcnd, double* amax, MKL_INT* info );

void DGEES( const char* jobvs, const char* sort,
            MKL_D_SELECT_FUNCTION_2 select, const MKL_INT* n, double* a,
            const MKL_INT* lda, MKL_INT* sdim, double* wr, double* wi,
            double* vs, const MKL_INT* ldvs, double* work,
            const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void DGEES_( const char* jobvs, const char* sort,
             MKL_D_SELECT_FUNCTION_2 select, const MKL_INT* n, double* a,
             const MKL_INT* lda, MKL_INT* sdim, double* wr, double* wi,
             double* vs, const MKL_INT* ldvs, double* work,
             const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void dgees( const char* jobvs, const char* sort,
            MKL_D_SELECT_FUNCTION_2 select, const MKL_INT* n, double* a,
            const MKL_INT* lda, MKL_INT* sdim, double* wr, double* wi,
            double* vs, const MKL_INT* ldvs, double* work,
            const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );
void dgees_( const char* jobvs, const char* sort,
             MKL_D_SELECT_FUNCTION_2 select, const MKL_INT* n, double* a,
             const MKL_INT* lda, MKL_INT* sdim, double* wr, double* wi,
             double* vs, const MKL_INT* ldvs, double* work,
             const MKL_INT* lwork, MKL_INT* bwork, MKL_INT* info );

void DGEESX( const char* jobvs, const char* sort,
             MKL_D_SELECT_FUNCTION_2 select, const char* sense,
             const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* sdim,
             double* wr, double* wi, double* vs, const MKL_INT* ldvs,
             double* rconde, double* rcondv, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* bwork, MKL_INT* info );
void DGEESX_( const char* jobvs, const char* sort,
              MKL_D_SELECT_FUNCTION_2 select, const char* sense,
              const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* sdim,
              double* wr, double* wi, double* vs, const MKL_INT* ldvs,
              double* rconde, double* rcondv, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* bwork, MKL_INT* info );
void dgeesx( const char* jobvs, const char* sort,
             MKL_D_SELECT_FUNCTION_2 select, const char* sense,
             const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* sdim,
             double* wr, double* wi, double* vs, const MKL_INT* ldvs,
             double* rconde, double* rcondv, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
             MKL_INT* bwork, MKL_INT* info );
void dgeesx_( const char* jobvs, const char* sort,
              MKL_D_SELECT_FUNCTION_2 select, const char* sense,
              const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* sdim,
              double* wr, double* wi, double* vs, const MKL_INT* ldvs,
              double* rconde, double* rcondv, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, const MKL_INT* liwork,
              MKL_INT* bwork, MKL_INT* info );

void DGEEV( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
            const MKL_INT* lda, double* wr, double* wi, double* vl,
            const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr, double* work,
            const MKL_INT* lwork, MKL_INT* info );
void DGEEV_( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* wr, double* wi, double* vl,
             const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
             double* work, const MKL_INT* lwork, MKL_INT* info );
void dgeev( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
            const MKL_INT* lda, double* wr, double* wi, double* vl,
            const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr, double* work,
            const MKL_INT* lwork, MKL_INT* info );
void dgeev_( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* wr, double* wi, double* vl,
             const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
             double* work, const MKL_INT* lwork, MKL_INT* info );

void DGEEVX( const char* balanc, const char* jobvl, const char* jobvr,
             const char* sense, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* wr, double* wi, double* vl,
             const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
             MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm,
             double* rconde, double* rcondv, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void DGEEVX_( const char* balanc, const char* jobvl, const char* jobvr,
              const char* sense, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* wr, double* wi, double* vl,
              const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
              MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm,
              double* rconde, double* rcondv, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void dgeevx( const char* balanc, const char* jobvl, const char* jobvr,
             const char* sense, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* wr, double* wi, double* vl,
             const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
             MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm,
             double* rconde, double* rcondv, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void dgeevx_( const char* balanc, const char* jobvl, const char* jobvr,
              const char* sense, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* wr, double* wi, double* vl,
              const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
              MKL_INT* ilo, MKL_INT* ihi, double* scale, double* abnrm,
              double* rconde, double* rcondv, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );

void DGEGS( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
            double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
            double* alphar, double* alphai, double* beta, double* vsl,
            const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
            double* work, const MKL_INT* lwork, MKL_INT* info );
void DGEGS_( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             double* alphar, double* alphai, double* beta, double* vsl,
             const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
             double* work, const MKL_INT* lwork, MKL_INT* info );
void dgegs( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
            double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
            double* alphar, double* alphai, double* beta, double* vsl,
            const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
            double* work, const MKL_INT* lwork, MKL_INT* info );
void dgegs_( const char* jobvsl, const char* jobvsr, const MKL_INT* n,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             double* alphar, double* alphai, double* beta, double* vsl,
             const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
             double* work, const MKL_INT* lwork, MKL_INT* info );

void DGEGV( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
            const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alphar,
            double* alphai, double* beta, double* vl, const MKL_INT* ldvl,
            double* vr, const MKL_INT* ldvr, double* work,
            const MKL_INT* lwork, MKL_INT* info );
void DGEGV_( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alphar,
             double* alphai, double* beta, double* vl, const MKL_INT* ldvl,
             double* vr, const MKL_INT* ldvr, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void dgegv( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
            const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alphar,
            double* alphai, double* beta, double* vl, const MKL_INT* ldvl,
            double* vr, const MKL_INT* ldvr, double* work,
            const MKL_INT* lwork, MKL_INT* info );
void dgegv_( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alphar,
             double* alphai, double* beta, double* vl, const MKL_INT* ldvl,
             double* vr, const MKL_INT* ldvr, double* work,
             const MKL_INT* lwork, MKL_INT* info );

void DGEHD2( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             double* a, const MKL_INT* lda, double* tau, double* work,
             MKL_INT* info );
void DGEHD2_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              double* a, const MKL_INT* lda, double* tau, double* work,
              MKL_INT* info );
void dgehd2( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             double* a, const MKL_INT* lda, double* tau, double* work,
             MKL_INT* info );
void dgehd2_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              double* a, const MKL_INT* lda, double* tau, double* work,
              MKL_INT* info );

void DGEHRD( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             double* a, const MKL_INT* lda, double* tau, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void DGEHRD_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              double* a, const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dgehrd( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             double* a, const MKL_INT* lda, double* tau, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void dgehrd_( const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              double* a, const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info );

void DGEJSV( const char* joba, const char* jobu, const char* jobv, const char* jobr, const char* jobt,
             const char* jobp, const MKL_INT* m, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* sva, double* u, const MKL_INT* ldu,
             double* v, const MKL_INT* ldv, double* work, const MKL_INT* lwork,
             MKL_INT* iwork, MKL_INT* info );
void DGEJSV_( const char* joba, const char* jobu, const char* jobv, const char* jobr, const char* jobt,
              const char* jobp, const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* sva, double* u, const MKL_INT* ldu,
              double* v, const MKL_INT* ldv, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void dgejsv( const char* joba, const char* jobu, const char* jobv, const char* jobr, const char* jobt,
             const char* jobp, const MKL_INT* m, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* sva, double* u, const MKL_INT* ldu,
             double* v, const MKL_INT* ldv, double* work, const MKL_INT* lwork,
             MKL_INT* iwork, MKL_INT* info );
void dgejsv_( const char* joba, const char* jobu, const char* jobv, const char* jobr, const char* jobt,
              const char* jobp, const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* sva, double* u, const MKL_INT* ldu,
              double* v, const MKL_INT* ldv, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );

void DGELQ2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info );
void DGELQ2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info );
void dgelq2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info );
void dgelq2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info );

void DGELQF( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void DGELQF_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dgelqf( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void dgelqf_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info );

void DGELSD( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             const double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, double* s, const double* rcond, MKL_INT* rank,
             double* work, const MKL_INT* lwork, MKL_INT* iwork,
             MKL_INT* info );
void DGELSD_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              const double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, double* s, const double* rcond,
              MKL_INT* rank, double* work, const MKL_INT* lwork,
              MKL_INT* iwork, MKL_INT* info );
void dgelsd( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             const double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, double* s, const double* rcond, MKL_INT* rank,
             double* work, const MKL_INT* lwork, MKL_INT* iwork,
             MKL_INT* info );
void dgelsd_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              const double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, double* s, const double* rcond,
              MKL_INT* rank, double* work, const MKL_INT* lwork,
              MKL_INT* iwork, MKL_INT* info );

void DGELS( const char* trans, const MKL_INT* m, const MKL_INT* n,
            const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
            const MKL_INT* ldb, double* work, const MKL_INT* lwork,
            MKL_INT* info );
void DGELS_( const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void dgels( const char* trans, const MKL_INT* m, const MKL_INT* n,
            const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
            const MKL_INT* ldb, double* work, const MKL_INT* lwork,
            MKL_INT* info );
void dgels_( const char* trans, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, double* work, const MKL_INT* lwork,
             MKL_INT* info );

void DGELSS( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             double* s, const double* rcond, MKL_INT* rank, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void DGELSS_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              double* s, const double* rcond, MKL_INT* rank, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dgelss( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             double* s, const double* rcond, MKL_INT* rank, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void dgelss_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              double* s, const double* rcond, MKL_INT* rank, double* work,
              const MKL_INT* lwork, MKL_INT* info );

void DGELSX( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
             MKL_INT* info );
void DGELSX_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
              MKL_INT* info );
void dgelsx( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
             MKL_INT* info );
void dgelsx_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
              MKL_INT* info );

void DGELSY( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void DGELSY_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dgelsy( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
             double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void dgelsy_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nrhs,
              double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              MKL_INT* jpvt, const double* rcond, MKL_INT* rank, double* work,
              const MKL_INT* lwork, MKL_INT* info );

void DGEQL2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info );
void DGEQL2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info );
void dgeql2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info );
void dgeql2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info );

void DGEQLF( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void DGEQLF_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dgeqlf( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void dgeqlf_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info );

void DGEQP3( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* jpvt, double* tau, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void DGEQP3_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* jpvt, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dgeqp3( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* jpvt, double* tau, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void dgeqp3_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* jpvt, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info );

void DGEQPF( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* jpvt, double* tau, double* work, MKL_INT* info );
void DGEQPF_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* jpvt, double* tau, double* work,
              MKL_INT* info );
void dgeqpf( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* jpvt, double* tau, double* work, MKL_INT* info );
void dgeqpf_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* jpvt, double* tau, double* work,
              MKL_INT* info );

void DGEQR2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info );
void DGEQR2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info );
void dgeqr2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info );
void dgeqr2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info );

void DGEQR2P( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* tau, double* work, MKL_INT* info );
void DGEQR2P_( const MKL_INT* m, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* tau, double* work, MKL_INT* info );
void dgeqr2p( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* tau, double* work, MKL_INT* info );
void dgeqr2p_( const MKL_INT* m, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* tau, double* work, MKL_INT* info );

void DGEQRF( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void DGEQRF_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dgeqrf( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void dgeqrf_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info );

void DGEQRFP( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void DGEQRFP_( const MKL_INT* m, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* tau, double* work,
               const MKL_INT* lwork, MKL_INT* info );
void dgeqrfp( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void dgeqrfp_( const MKL_INT* m, const MKL_INT* n, double* a,
               const MKL_INT* lda, double* tau, double* work,
               const MKL_INT* lwork, MKL_INT* info );

void DGERFS( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* a, const MKL_INT* lda, const double* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const double* b,
             const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* ferr,
             double* berr, double* work, MKL_INT* iwork, MKL_INT* info );
void DGERFS_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* a, const MKL_INT* lda, const double* af,
              const MKL_INT* ldaf, const MKL_INT* ipiv, const double* b,
              const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* ferr,
              double* berr, double* work, MKL_INT* iwork, MKL_INT* info );
void dgerfs( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* a, const MKL_INT* lda, const double* af,
             const MKL_INT* ldaf, const MKL_INT* ipiv, const double* b,
             const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* ferr,
             double* berr, double* work, MKL_INT* iwork, MKL_INT* info );
void dgerfs_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* a, const MKL_INT* lda, const double* af,
              const MKL_INT* ldaf, const MKL_INT* ipiv, const double* b,
              const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* ferr,
              double* berr, double* work, MKL_INT* iwork, MKL_INT* info );

void DGERFSX( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
              const double* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const double* r, const double* c, const double* b,
              const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* rcond,
              double* berr, const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info );
void DGERFSX_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
               const double* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
               const double* r, const double* c, const double* b,
               const MKL_INT* ldb, double* x, const MKL_INT* ldx,
               double* rcond, double* berr, const MKL_INT* n_err_bnds,
               double* err_bnds_norm, double* err_bnds_comp,
               const MKL_INT* nparams, double* params, double* work,
               MKL_INT* iwork, MKL_INT* info );
void dgerfsx( const char* trans, const char* equed, const MKL_INT* n,
              const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
              const double* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
              const double* r, const double* c, const double* b,
              const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* rcond,
              double* berr, const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info );
void dgerfsx_( const char* trans, const char* equed, const MKL_INT* n,
               const MKL_INT* nrhs, const double* a, const MKL_INT* lda,
               const double* af, const MKL_INT* ldaf, const MKL_INT* ipiv,
               const double* r, const double* c, const double* b,
               const MKL_INT* ldb, double* x, const MKL_INT* ldx,
               double* rcond, double* berr, const MKL_INT* n_err_bnds,
               double* err_bnds_norm, double* err_bnds_comp,
               const MKL_INT* nparams, double* params, double* work,
               MKL_INT* iwork, MKL_INT* info );

void DGERQ2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info );
void DGERQ2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info );
void dgerq2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, MKL_INT* info );
void dgerq2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work, MKL_INT* info );

void DGERQF( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void DGERQF_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dgerqf( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* tau, double* work, const MKL_INT* lwork, MKL_INT* info );
void dgerqf_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* tau, double* work,
              const MKL_INT* lwork, MKL_INT* info );

void DGESC2( const MKL_INT* n, const double* a, const MKL_INT* lda,
             double* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
             double* scale );
void DGESC2_( const MKL_INT* n, const double* a, const MKL_INT* lda,
              double* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
              double* scale );
void dgesc2( const MKL_INT* n, const double* a, const MKL_INT* lda,
             double* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
             double* scale );
void dgesc2_( const MKL_INT* n, const double* a, const MKL_INT* lda,
              double* rhs, const MKL_INT* ipiv, const MKL_INT* jpiv,
              double* scale );

void DGESDD( const char* jobz, const MKL_INT* m, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu,
             double* vt, const MKL_INT* ldvt, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void DGESDD_( const char* jobz, const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu,
              double* vt, const MKL_INT* ldvt, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void dgesdd( const char* jobz, const MKL_INT* m, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu,
             double* vt, const MKL_INT* ldvt, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );
void dgesdd_( const char* jobz, const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* s, double* u, const MKL_INT* ldu,
              double* vt, const MKL_INT* ldvt, double* work,
              const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* info );

void DGESVD( const char* jobu, const char* jobvt, const MKL_INT* m,
             const MKL_INT* n, double* a, const MKL_INT* lda, double* s,
             double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
             double* work, const MKL_INT* lwork, MKL_INT* info );
void DGESVD_( const char* jobu, const char* jobvt, const MKL_INT* m,
              const MKL_INT* n, double* a, const MKL_INT* lda, double* s,
              double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
              double* work, const MKL_INT* lwork, MKL_INT* info );
void dgesvd( const char* jobu, const char* jobvt, const MKL_INT* m,
             const MKL_INT* n, double* a, const MKL_INT* lda, double* s,
             double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
             double* work, const MKL_INT* lwork, MKL_INT* info );
void dgesvd_( const char* jobu, const char* jobvt, const MKL_INT* m,
              const MKL_INT* n, double* a, const MKL_INT* lda, double* s,
              double* u, const MKL_INT* ldu, double* vt, const MKL_INT* ldvt,
              double* work, const MKL_INT* lwork, MKL_INT* info );

void DGESV( const MKL_INT* n, const MKL_INT* nrhs, double* a,
            const MKL_INT* lda, MKL_INT* ipiv, double* b, const MKL_INT* ldb,
            MKL_INT* info );
void DGESV_( const MKL_INT* n, const MKL_INT* nrhs, double* a,
             const MKL_INT* lda, MKL_INT* ipiv, double* b, const MKL_INT* ldb,
             MKL_INT* info );
void dgesv( const MKL_INT* n, const MKL_INT* nrhs, double* a,
            const MKL_INT* lda, MKL_INT* ipiv, double* b, const MKL_INT* ldb,
            MKL_INT* info );
void dgesv_( const MKL_INT* n, const MKL_INT* nrhs, double* a,
             const MKL_INT* lda, MKL_INT* ipiv, double* b, const MKL_INT* ldb,
             MKL_INT* info );

void DGESVJ( const char* joba, const char* jobu, const char* jobv,
             const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* sva, const MKL_INT* mv, double* v, const MKL_INT* ldv,
             double* work, const MKL_INT* lwork, MKL_INT* info );
void DGESVJ_( const char* joba, const char* jobu, const char* jobv,
              const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* sva, const MKL_INT* mv, double* v,
              const MKL_INT* ldv, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void dgesvj( const char* joba, const char* jobu, const char* jobv,
             const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* sva, const MKL_INT* mv, double* v, const MKL_INT* ldv,
             double* work, const MKL_INT* lwork, MKL_INT* info );
void dgesvj_( const char* joba, const char* jobu, const char* jobv,
              const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* sva, const MKL_INT* mv, double* v,
              const MKL_INT* ldv, double* work, const MKL_INT* lwork,
              MKL_INT* info );

void DGESVX( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
             const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
             double* c, double* b, const MKL_INT* ldb, double* x,
             const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
             double* work, MKL_INT* iwork, MKL_INT* info );
void DGESVX_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
              const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
              double* work, MKL_INT* iwork, MKL_INT* info );
void dgesvx( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
             const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
             double* c, double* b, const MKL_INT* ldb, double* x,
             const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
             double* work, MKL_INT* iwork, MKL_INT* info );
void dgesvx_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
              const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* ferr, double* berr,
              double* work, MKL_INT* iwork, MKL_INT* info );

void DGESVXX( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
              const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
              const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info );
void DGESVXX_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
               const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
               double* c, double* b, const MKL_INT* ldb, double* x,
               const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
               const MKL_INT* n_err_bnds, double* err_bnds_norm,
               double* err_bnds_comp, const MKL_INT* nparams, double* params,
               double* work, MKL_INT* iwork, MKL_INT* info );
void dgesvxx( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
              const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
              double* c, double* b, const MKL_INT* ldb, double* x,
              const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
              const MKL_INT* n_err_bnds, double* err_bnds_norm,
              double* err_bnds_comp, const MKL_INT* nparams, double* params,
              double* work, MKL_INT* iwork, MKL_INT* info );
void dgesvxx_( const char* fact, const char* trans, const MKL_INT* n,
               const MKL_INT* nrhs, double* a, const MKL_INT* lda, double* af,
               const MKL_INT* ldaf, MKL_INT* ipiv, char* equed, double* r,
               double* c, double* b, const MKL_INT* ldb, double* x,
               const MKL_INT* ldx, double* rcond, double* rpvgrw, double* berr,
               const MKL_INT* n_err_bnds, double* err_bnds_norm,
               double* err_bnds_comp, const MKL_INT* nparams, double* params,
               double* work, MKL_INT* iwork, MKL_INT* info );

void DGETC2( const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_INT* jpiv, MKL_INT* info );
void DGETC2_( const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_INT* jpiv, MKL_INT* info );
void dgetc2( const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* ipiv,
             MKL_INT* jpiv, MKL_INT* info );
void dgetc2_( const MKL_INT* n, double* a, const MKL_INT* lda, MKL_INT* ipiv,
              MKL_INT* jpiv, MKL_INT* info );

void DGETF2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* ipiv, MKL_INT* info );
void DGETF2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void dgetf2( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* ipiv, MKL_INT* info );
void dgetf2_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void DGETRF( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* ipiv, MKL_INT* info );
void DGETRF_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );
void dgetrf( const MKL_INT* m, const MKL_INT* n, double* a, const MKL_INT* lda,
             MKL_INT* ipiv, MKL_INT* info );
void dgetrf_( const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, MKL_INT* ipiv, MKL_INT* info );

void MKL_DGETRFNPI( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                    double* a, const MKL_INT* lda, MKL_INT* info );
void MKL_DGETRFNPI_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                     double* a, const MKL_INT* lda, MKL_INT* info );
void mkl_dgetrfnpi( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                    double* a, const MKL_INT* lda, MKL_INT* info );
void mkl_dgetrfnpi_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nfact,
                     double* a, const MKL_INT* lda, MKL_INT* info );

void DGETRI( const MKL_INT* n, double* a, const MKL_INT* lda,
             const MKL_INT* ipiv, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void DGETRI_( const MKL_INT* n, double* a, const MKL_INT* lda,
              const MKL_INT* ipiv, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void dgetri( const MKL_INT* n, double* a, const MKL_INT* lda,
             const MKL_INT* ipiv, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void dgetri_( const MKL_INT* n, double* a, const MKL_INT* lda,
              const MKL_INT* ipiv, double* work, const MKL_INT* lwork,
              MKL_INT* info );

void DGETRS( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* b, const MKL_INT* ldb, MKL_INT* info );
void DGETRS_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
              double* b, const MKL_INT* ldb, MKL_INT* info );
void dgetrs( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
             double* b, const MKL_INT* ldb, MKL_INT* info );
void dgetrs_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* a, const MKL_INT* lda, const MKL_INT* ipiv,
              double* b, const MKL_INT* ldb, MKL_INT* info );

void DGGBAK( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const double* lscale,
             const double* rscale, const MKL_INT* m, double* v,
             const MKL_INT* ldv, MKL_INT* info );
void DGGBAK_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const double* lscale,
              const double* rscale, const MKL_INT* m, double* v,
              const MKL_INT* ldv, MKL_INT* info );
void dggbak( const char* job, const char* side, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, const double* lscale,
             const double* rscale, const MKL_INT* m, double* v,
             const MKL_INT* ldv, MKL_INT* info );
void dggbak_( const char* job, const char* side, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, const double* lscale,
              const double* rscale, const MKL_INT* m, double* v,
              const MKL_INT* ldv, MKL_INT* info );

void DGGBAL( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* b, const MKL_INT* ldb, MKL_INT* ilo, MKL_INT* ihi,
             double* lscale, double* rscale, double* work, MKL_INT* info );
void DGGBAL_( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb, MKL_INT* ilo, MKL_INT* ihi,
              double* lscale, double* rscale, double* work, MKL_INT* info );
void dggbal( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
             double* b, const MKL_INT* ldb, MKL_INT* ilo, MKL_INT* ihi,
             double* lscale, double* rscale, double* work, MKL_INT* info );
void dggbal_( const char* job, const MKL_INT* n, double* a, const MKL_INT* lda,
              double* b, const MKL_INT* ldb, MKL_INT* ilo, MKL_INT* ihi,
              double* lscale, double* rscale, double* work, MKL_INT* info );

void DGGES( const char* jobvsl, const char* jobvsr, const char* sort,
            MKL_D_SELECT_FUNCTION_3 selctg, const MKL_INT* n, double* a,
            const MKL_INT* lda, double* b, const MKL_INT* ldb, MKL_INT* sdim,
            double* alphar, double* alphai, double* beta, double* vsl,
            const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
            double* work, const MKL_INT* lwork, MKL_INT* bwork,
            MKL_INT* info );
void DGGES_( const char* jobvsl, const char* jobvsr, const char* sort,
             MKL_D_SELECT_FUNCTION_3 selctg, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, MKL_INT* sdim,
             double* alphar, double* alphai, double* beta, double* vsl,
             const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
             double* work, const MKL_INT* lwork, MKL_INT* bwork,
             MKL_INT* info );
void dgges( const char* jobvsl, const char* jobvsr, const char* sort,
            MKL_D_SELECT_FUNCTION_3 selctg, const MKL_INT* n, double* a,
            const MKL_INT* lda, double* b, const MKL_INT* ldb, MKL_INT* sdim,
            double* alphar, double* alphai, double* beta, double* vsl,
            const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
            double* work, const MKL_INT* lwork, MKL_INT* bwork,
            MKL_INT* info );
void dgges_( const char* jobvsl, const char* jobvsr, const char* sort,
             MKL_D_SELECT_FUNCTION_3 selctg, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, MKL_INT* sdim,
             double* alphar, double* alphai, double* beta, double* vsl,
             const MKL_INT* ldvsl, double* vsr, const MKL_INT* ldvsr,
             double* work, const MKL_INT* lwork, MKL_INT* bwork,
             MKL_INT* info );

void DGGESX( const char* jobvsl, const char* jobvsr, const char* sort,
             MKL_D_SELECT_FUNCTION_3 selctg, const char* sense,
             const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, MKL_INT* sdim, double* alphar, double* alphai,
             double* beta, double* vsl, const MKL_INT* ldvsl, double* vsr,
             const MKL_INT* ldvsr, double* rconde, double* rcondv,
             double* work, const MKL_INT* lwork, MKL_INT* iwork,
             const MKL_INT* liwork, MKL_INT* bwork, MKL_INT* info );
void DGGESX_( const char* jobvsl, const char* jobvsr, const char* sort,
              MKL_D_SELECT_FUNCTION_3 selctg, const char* sense,
              const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, MKL_INT* sdim, double* alphar,
              double* alphai, double* beta, double* vsl, const MKL_INT* ldvsl,
              double* vsr, const MKL_INT* ldvsr, double* rconde,
              double* rcondv, double* work, const MKL_INT* lwork,
              MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* bwork,
              MKL_INT* info );
void dggesx( const char* jobvsl, const char* jobvsr, const char* sort,
             MKL_D_SELECT_FUNCTION_3 selctg, const char* sense,
             const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, MKL_INT* sdim, double* alphar, double* alphai,
             double* beta, double* vsl, const MKL_INT* ldvsl, double* vsr,
             const MKL_INT* ldvsr, double* rconde, double* rcondv,
             double* work, const MKL_INT* lwork, MKL_INT* iwork,
             const MKL_INT* liwork, MKL_INT* bwork, MKL_INT* info );
void dggesx_( const char* jobvsl, const char* jobvsr, const char* sort,
              MKL_D_SELECT_FUNCTION_3 selctg, const char* sense,
              const MKL_INT* n, double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, MKL_INT* sdim, double* alphar,
              double* alphai, double* beta, double* vsl, const MKL_INT* ldvsl,
              double* vsr, const MKL_INT* ldvsr, double* rconde,
              double* rcondv, double* work, const MKL_INT* lwork,
              MKL_INT* iwork, const MKL_INT* liwork, MKL_INT* bwork,
              MKL_INT* info );

void DGGEV( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
            const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alphar,
            double* alphai, double* beta, double* vl, const MKL_INT* ldvl,
            double* vr, const MKL_INT* ldvr, double* work,
            const MKL_INT* lwork, MKL_INT* info );
void DGGEV_( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alphar,
             double* alphai, double* beta, double* vl, const MKL_INT* ldvl,
             double* vr, const MKL_INT* ldvr, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void dggev( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
            const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alphar,
            double* alphai, double* beta, double* vl, const MKL_INT* ldvl,
            double* vr, const MKL_INT* ldvr, double* work,
            const MKL_INT* lwork, MKL_INT* info );
void dggev_( const char* jobvl, const char* jobvr, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alphar,
             double* alphai, double* beta, double* vl, const MKL_INT* ldvl,
             double* vr, const MKL_INT* ldvr, double* work,
             const MKL_INT* lwork, MKL_INT* info );

void DGGEVX( const char* balanc, const char* jobvl, const char* jobvr,
             const char* sense, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alphar,
             double* alphai, double* beta, double* vl, const MKL_INT* ldvl,
             double* vr, const MKL_INT* ldvr, MKL_INT* ilo, MKL_INT* ihi,
             double* lscale, double* rscale, double* abnrm, double* bbnrm,
             double* rconde, double* rcondv, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* bwork,
             MKL_INT* info );
void DGGEVX_( const char* balanc, const char* jobvl, const char* jobvr,
              const char* sense, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb,
              double* alphar, double* alphai, double* beta, double* vl,
              const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
              MKL_INT* ilo, MKL_INT* ihi, double* lscale, double* rscale,
              double* abnrm, double* bbnrm, double* rconde, double* rcondv,
              double* work, const MKL_INT* lwork, MKL_INT* iwork,
              MKL_INT* bwork, MKL_INT* info );
void dggevx( const char* balanc, const char* jobvl, const char* jobvr,
             const char* sense, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, double* alphar,
             double* alphai, double* beta, double* vl, const MKL_INT* ldvl,
             double* vr, const MKL_INT* ldvr, MKL_INT* ilo, MKL_INT* ihi,
             double* lscale, double* rscale, double* abnrm, double* bbnrm,
             double* rconde, double* rcondv, double* work,
             const MKL_INT* lwork, MKL_INT* iwork, MKL_INT* bwork,
             MKL_INT* info );
void dggevx_( const char* balanc, const char* jobvl, const char* jobvr,
              const char* sense, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb,
              double* alphar, double* alphai, double* beta, double* vl,
              const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
              MKL_INT* ilo, MKL_INT* ihi, double* lscale, double* rscale,
              double* abnrm, double* bbnrm, double* rconde, double* rcondv,
              double* work, const MKL_INT* lwork, MKL_INT* iwork,
              MKL_INT* bwork, MKL_INT* info );

void DGGGLM( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, double* d,
             double* x, double* y, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void DGGGLM_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* d,
              double* x, double* y, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void dggglm( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, double* d,
             double* x, double* y, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void dggglm_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* d,
              double* x, double* y, double* work, const MKL_INT* lwork,
              MKL_INT* info );

void DGGHRD( const char* compq, const char* compz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, double* q,
             const MKL_INT* ldq, double* z, const MKL_INT* ldz,
             MKL_INT* info );
void DGGHRD_( const char* compq, const char* compz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* q,
              const MKL_INT* ldq, double* z, const MKL_INT* ldz,
              MKL_INT* info );
void dgghrd( const char* compq, const char* compz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, double* q,
             const MKL_INT* ldq, double* z, const MKL_INT* ldz,
             MKL_INT* info );
void dgghrd_( const char* compq, const char* compz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* q,
              const MKL_INT* ldq, double* z, const MKL_INT* ldz,
              MKL_INT* info );

void DGGLSE( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, double* c,
             double* d, double* x, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void DGGLSE_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* c,
              double* d, double* x, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void dgglse( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb, double* c,
             double* d, double* x, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void dgglse_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb, double* c,
              double* d, double* x, double* work, const MKL_INT* lwork,
              MKL_INT* info );

void DGGQRF( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, double* a,
             const MKL_INT* lda, double* taua, double* b, const MKL_INT* ldb,
             double* taub, double* work, const MKL_INT* lwork, MKL_INT* info );
void DGGQRF_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, double* a,
              const MKL_INT* lda, double* taua, double* b, const MKL_INT* ldb,
              double* taub, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void dggqrf( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, double* a,
             const MKL_INT* lda, double* taua, double* b, const MKL_INT* ldb,
             double* taub, double* work, const MKL_INT* lwork, MKL_INT* info );
void dggqrf_( const MKL_INT* n, const MKL_INT* m, const MKL_INT* p, double* a,
              const MKL_INT* lda, double* taua, double* b, const MKL_INT* ldb,
              double* taub, double* work, const MKL_INT* lwork,
              MKL_INT* info );

void DGGRQF( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* taua, double* b, const MKL_INT* ldb,
             double* taub, double* work, const MKL_INT* lwork, MKL_INT* info );
void DGGRQF_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* taua, double* b, const MKL_INT* ldb,
              double* taub, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void dggrqf( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* taua, double* b, const MKL_INT* ldb,
             double* taub, double* work, const MKL_INT* lwork, MKL_INT* info );
void dggrqf_( const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* taua, double* b, const MKL_INT* ldb,
              double* taub, double* work, const MKL_INT* lwork,
              MKL_INT* info );

void DGGSVD( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
             MKL_INT* l, double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, double* alpha, double* beta, double* u,
             const MKL_INT* ldu, double* v, const MKL_INT* ldv, double* q,
             const MKL_INT* ldq, double* work, MKL_INT* iwork, MKL_INT* info );
void DGGSVD_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
              MKL_INT* l, double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, double* alpha, double* beta, double* u,
              const MKL_INT* ldu, double* v, const MKL_INT* ldv, double* q,
              const MKL_INT* ldq, double* work, MKL_INT* iwork,
              MKL_INT* info );
void dggsvd( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
             MKL_INT* l, double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb, double* alpha, double* beta, double* u,
             const MKL_INT* ldu, double* v, const MKL_INT* ldv, double* q,
             const MKL_INT* ldq, double* work, MKL_INT* iwork, MKL_INT* info );
void dggsvd_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* n, const MKL_INT* p, MKL_INT* k,
              MKL_INT* l, double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb, double* alpha, double* beta, double* u,
              const MKL_INT* ldu, double* v, const MKL_INT* ldv, double* q,
              const MKL_INT* ldq, double* work, MKL_INT* iwork,
              MKL_INT* info );

void DGGSVP( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb,
             const double* tola, const double* tolb, MKL_INT* k, MKL_INT* l,
             double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
             double* q, const MKL_INT* ldq, MKL_INT* iwork, double* tau,
             double* work, MKL_INT* info );
void DGGSVP_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb,
              const double* tola, const double* tolb, MKL_INT* k, MKL_INT* l,
              double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
              double* q, const MKL_INT* ldq, MKL_INT* iwork, double* tau,
              double* work, MKL_INT* info );
void dggsvp( const char* jobu, const char* jobv, const char* jobq,
             const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* b, const MKL_INT* ldb,
             const double* tola, const double* tolb, MKL_INT* k, MKL_INT* l,
             double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
             double* q, const MKL_INT* ldq, MKL_INT* iwork, double* tau,
             double* work, MKL_INT* info );
void dggsvp_( const char* jobu, const char* jobv, const char* jobq,
              const MKL_INT* m, const MKL_INT* p, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* b, const MKL_INT* ldb,
              const double* tola, const double* tolb, MKL_INT* k, MKL_INT* l,
              double* u, const MKL_INT* ldu, double* v, const MKL_INT* ldv,
              double* q, const MKL_INT* ldq, MKL_INT* iwork, double* tau,
              double* work, MKL_INT* info );

void DGSVJ0( const char* jobv, const MKL_INT* m, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* d, double* sva, const MKL_INT* mv,
             double* v, const MKL_INT* ldv, const double* eps,
             const double* sfmin, const double* tol, const MKL_INT* nsweep,
             double* work, const MKL_INT* lwork, MKL_INT* info );
void DGSVJ0_( const char* jobv, const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* d, double* sva, const MKL_INT* mv,
              double* v, const MKL_INT* ldv, const double* eps,
              const double* sfmin, const double* tol, const MKL_INT* nsweep,
              double* work, const MKL_INT* lwork, MKL_INT* info );
void dgsvj0( const char* jobv, const MKL_INT* m, const MKL_INT* n, double* a,
             const MKL_INT* lda, double* d, double* sva, const MKL_INT* mv,
             double* v, const MKL_INT* ldv, const double* eps,
             const double* sfmin, const double* tol, const MKL_INT* nsweep,
             double* work, const MKL_INT* lwork, MKL_INT* info );
void dgsvj0_( const char* jobv, const MKL_INT* m, const MKL_INT* n, double* a,
              const MKL_INT* lda, double* d, double* sva, const MKL_INT* mv,
              double* v, const MKL_INT* ldv, const double* eps,
              const double* sfmin, const double* tol, const MKL_INT* nsweep,
              double* work, const MKL_INT* lwork, MKL_INT* info );

void DGSVJ1( const char* jobv, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, double* a, const MKL_INT* lda, double* d,
             double* sva, const MKL_INT* mv, double* v, const MKL_INT* ldv,
             const double* eps, const double* sfmin, const double* tol,
             const MKL_INT* nsweep, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void DGSVJ1_( const char* jobv, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, double* a, const MKL_INT* lda, double* d,
              double* sva, const MKL_INT* mv, double* v, const MKL_INT* ldv,
              const double* eps, const double* sfmin, const double* tol,
              const MKL_INT* nsweep, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void dgsvj1( const char* jobv, const MKL_INT* m, const MKL_INT* n,
             const MKL_INT* n1, double* a, const MKL_INT* lda, double* d,
             double* sva, const MKL_INT* mv, double* v, const MKL_INT* ldv,
             const double* eps, const double* sfmin, const double* tol,
             const MKL_INT* nsweep, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void dgsvj1_( const char* jobv, const MKL_INT* m, const MKL_INT* n,
              const MKL_INT* n1, double* a, const MKL_INT* lda, double* d,
              double* sva, const MKL_INT* mv, double* v, const MKL_INT* ldv,
              const double* eps, const double* sfmin, const double* tol,
              const MKL_INT* nsweep, double* work, const MKL_INT* lwork,
              MKL_INT* info );

void DGTCON( const char* norm, const MKL_INT* n, const double* dl,
             const double* d, const double* du, const double* du2,
             const MKL_INT* ipiv, const double* anorm, double* rcond,
             double* work, MKL_INT* iwork, MKL_INT* info );
void DGTCON_( const char* norm, const MKL_INT* n, const double* dl,
              const double* d, const double* du, const double* du2,
              const MKL_INT* ipiv, const double* anorm, double* rcond,
              double* work, MKL_INT* iwork, MKL_INT* info );
void dgtcon( const char* norm, const MKL_INT* n, const double* dl,
             const double* d, const double* du, const double* du2,
             const MKL_INT* ipiv, const double* anorm, double* rcond,
             double* work, MKL_INT* iwork, MKL_INT* info );
void dgtcon_( const char* norm, const MKL_INT* n, const double* dl,
              const double* d, const double* du, const double* du2,
              const MKL_INT* ipiv, const double* anorm, double* rcond,
              double* work, MKL_INT* iwork, MKL_INT* info );

void DGTRFS( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* dl, const double* d, const double* du,
             const double* dlf, const double* df, const double* duf,
             const double* du2, const MKL_INT* ipiv, const double* b,
             const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* ferr,
             double* berr, double* work, MKL_INT* iwork, MKL_INT* info );
void DGTRFS_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* dl, const double* d, const double* du,
              const double* dlf, const double* df, const double* duf,
              const double* du2, const MKL_INT* ipiv, const double* b,
              const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* ferr,
              double* berr, double* work, MKL_INT* iwork, MKL_INT* info );
void dgtrfs( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* dl, const double* d, const double* du,
             const double* dlf, const double* df, const double* duf,
             const double* du2, const MKL_INT* ipiv, const double* b,
             const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* ferr,
             double* berr, double* work, MKL_INT* iwork, MKL_INT* info );
void dgtrfs_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* dl, const double* d, const double* du,
              const double* dlf, const double* df, const double* duf,
              const double* du2, const MKL_INT* ipiv, const double* b,
              const MKL_INT* ldb, double* x, const MKL_INT* ldx, double* ferr,
              double* berr, double* work, MKL_INT* iwork, MKL_INT* info );

void DGTSV( const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d,
            double* du, double* b, const MKL_INT* ldb, MKL_INT* info );
void DGTSV_( const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d,
             double* du, double* b, const MKL_INT* ldb, MKL_INT* info );
void dgtsv( const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d,
            double* du, double* b, const MKL_INT* ldb, MKL_INT* info );
void dgtsv_( const MKL_INT* n, const MKL_INT* nrhs, double* dl, double* d,
             double* du, double* b, const MKL_INT* ldb, MKL_INT* info );

void DGTSVX( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* nrhs, const double* dl, const double* d,
             const double* du, double* dlf, double* df, double* duf,
             double* du2, MKL_INT* ipiv, const double* b, const MKL_INT* ldb,
             double* x, const MKL_INT* ldx, double* rcond, double* ferr,
             double* berr, double* work, MKL_INT* iwork, MKL_INT* info );
void DGTSVX_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, const double* dl, const double* d,
              const double* du, double* dlf, double* df, double* duf,
              double* du2, MKL_INT* ipiv, const double* b, const MKL_INT* ldb,
              double* x, const MKL_INT* ldx, double* rcond, double* ferr,
              double* berr, double* work, MKL_INT* iwork, MKL_INT* info );
void dgtsvx( const char* fact, const char* trans, const MKL_INT* n,
             const MKL_INT* nrhs, const double* dl, const double* d,
             const double* du, double* dlf, double* df, double* duf,
             double* du2, MKL_INT* ipiv, const double* b, const MKL_INT* ldb,
             double* x, const MKL_INT* ldx, double* rcond, double* ferr,
             double* berr, double* work, MKL_INT* iwork, MKL_INT* info );
void dgtsvx_( const char* fact, const char* trans, const MKL_INT* n,
              const MKL_INT* nrhs, const double* dl, const double* d,
              const double* du, double* dlf, double* df, double* duf,
              double* du2, MKL_INT* ipiv, const double* b, const MKL_INT* ldb,
              double* x, const MKL_INT* ldx, double* rcond, double* ferr,
              double* berr, double* work, MKL_INT* iwork, MKL_INT* info );

void DGTTRF( const MKL_INT* n, double* dl, double* d, double* du, double* du2,
             MKL_INT* ipiv, MKL_INT* info );
void DGTTRF_( const MKL_INT* n, double* dl, double* d, double* du, double* du2,
              MKL_INT* ipiv, MKL_INT* info );
void dgttrf( const MKL_INT* n, double* dl, double* d, double* du, double* du2,
             MKL_INT* ipiv, MKL_INT* info );
void dgttrf_( const MKL_INT* n, double* dl, double* d, double* du, double* du2,
              MKL_INT* ipiv, MKL_INT* info );

void DGTTRS( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* dl, const double* d, const double* du,
             const double* du2, const MKL_INT* ipiv, double* b,
             const MKL_INT* ldb, MKL_INT* info );
void DGTTRS_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* dl, const double* d, const double* du,
              const double* du2, const MKL_INT* ipiv, double* b,
              const MKL_INT* ldb, MKL_INT* info );
void dgttrs( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* dl, const double* d, const double* du,
             const double* du2, const MKL_INT* ipiv, double* b,
             const MKL_INT* ldb, MKL_INT* info );
void dgttrs_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* dl, const double* d, const double* du,
              const double* du2, const MKL_INT* ipiv, double* b,
              const MKL_INT* ldb, MKL_INT* info );

void DGTTS2( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* dl, const double* d, const double* du,
             const double* du2, const MKL_INT* ipiv, double* b,
             const MKL_INT* ldb );
void DGTTS2_( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* dl, const double* d, const double* du,
              const double* du2, const MKL_INT* ipiv, double* b,
              const MKL_INT* ldb );
void dgtts2( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* dl, const double* d, const double* du,
             const double* du2, const MKL_INT* ipiv, double* b,
             const MKL_INT* ldb );
void dgtts2_( const MKL_INT* itrans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* dl, const double* d, const double* du,
              const double* du2, const MKL_INT* ipiv, double* b,
              const MKL_INT* ldb );

void DHGEQZ( const char* job, const char* compq, const char* compz,
             const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             double* h, const MKL_INT* ldh, double* t, const MKL_INT* ldt,
             double* alphar, double* alphai, double* beta, double* q,
             const MKL_INT* ldq, double* z, const MKL_INT* ldz, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void DHGEQZ_( const char* job, const char* compq, const char* compz,
              const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              double* h, const MKL_INT* ldh, double* t, const MKL_INT* ldt,
              double* alphar, double* alphai, double* beta, double* q,
              const MKL_INT* ldq, double* z, const MKL_INT* ldz, double* work,
              const MKL_INT* lwork, MKL_INT* info );
void dhgeqz( const char* job, const char* compq, const char* compz,
             const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
             double* h, const MKL_INT* ldh, double* t, const MKL_INT* ldt,
             double* alphar, double* alphai, double* beta, double* q,
             const MKL_INT* ldq, double* z, const MKL_INT* ldz, double* work,
             const MKL_INT* lwork, MKL_INT* info );
void dhgeqz_( const char* job, const char* compq, const char* compz,
              const MKL_INT* n, const MKL_INT* ilo, const MKL_INT* ihi,
              double* h, const MKL_INT* ldh, double* t, const MKL_INT* ldt,
              double* alphar, double* alphai, double* beta, double* q,
              const MKL_INT* ldq, double* z, const MKL_INT* ldz, double* work,
              const MKL_INT* lwork, MKL_INT* info );

void DHSEIN( const char* side, const char* eigsrc, const char* initv,
             MKL_INT* select, const MKL_INT* n, const double* h,
             const MKL_INT* ldh, double* wr, const double* wi, double* vl,
             const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
             const MKL_INT* mm, MKL_INT* m, double* work, MKL_INT* ifaill,
             MKL_INT* ifailr, MKL_INT* info );
void DHSEIN_( const char* side, const char* eigsrc, const char* initv,
              MKL_INT* select, const MKL_INT* n, const double* h,
              const MKL_INT* ldh, double* wr, const double* wi, double* vl,
              const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, double* work, MKL_INT* ifaill,
              MKL_INT* ifailr, MKL_INT* info );
void dhsein( const char* side, const char* eigsrc, const char* initv,
             MKL_INT* select, const MKL_INT* n, const double* h,
             const MKL_INT* ldh, double* wr, const double* wi, double* vl,
             const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
             const MKL_INT* mm, MKL_INT* m, double* work, MKL_INT* ifaill,
             MKL_INT* ifailr, MKL_INT* info );
void dhsein_( const char* side, const char* eigsrc, const char* initv,
              MKL_INT* select, const MKL_INT* n, const double* h,
              const MKL_INT* ldh, double* wr, const double* wi, double* vl,
              const MKL_INT* ldvl, double* vr, const MKL_INT* ldvr,
              const MKL_INT* mm, MKL_INT* m, double* work, MKL_INT* ifaill,
              MKL_INT* ifailr, MKL_INT* info );

void DHSEQR( const char* job, const char* compz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, double* h,
             const MKL_INT* ldh, double* wr, double* wi, double* z,
             const MKL_INT* ldz, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void DHSEQR_( const char* job, const char* compz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, double* h,
              const MKL_INT* ldh, double* wr, double* wi, double* z,
              const MKL_INT* ldz, double* work, const MKL_INT* lwork,
              MKL_INT* info );
void dhseqr( const char* job, const char* compz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, double* h,
             const MKL_INT* ldh, double* wr, double* wi, double* z,
             const MKL_INT* ldz, double* work, const MKL_INT* lwork,
             MKL_INT* info );
void dhseqr_( const char* job, const char* compz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, double* h,
              const MKL_INT* ldh, double* wr, double* wi, double* z,
              const MKL_INT* ldz, double* work, const MKL_INT* lwork,
              MKL_INT* info );

MKL_INT DISNAN( const double* din );
MKL_INT DISNAN_( const double* din );
MKL_INT disnan( const double* din );
MKL_INT disnan_( const double* din );

void DLABAD( double* smallx, double* large );
void DLABAD_( double* smallx, double* large );
void dlabad( double* smallx, double* large );
void dlabad_( double* smallx, double* large );

void DLABRD( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a,
             const MKL_INT* lda, double* d, double* e, double* tauq,
             double* taup, double* x, const MKL_INT* ldx, double* y,
             const MKL_INT* ldy );
void DLABRD_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a,
              const MKL_INT* lda, double* d, double* e, double* tauq,
              double* taup, double* x, const MKL_INT* ldx, double* y,
              const MKL_INT* ldy );
void dlabrd( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a,
             const MKL_INT* lda, double* d, double* e, double* tauq,
             double* taup, double* x, const MKL_INT* ldx, double* y,
             const MKL_INT* ldy );
void dlabrd_( const MKL_INT* m, const MKL_INT* n, const MKL_INT* nb, double* a,
              const MKL_INT* lda, double* d, double* e, double* tauq,
              double* taup, double* x, const MKL_INT* ldx, double* y,
              const MKL_INT* ldy );

void DLACN2( const MKL_INT* n, double* v, double* x, MKL_INT* isgn,
             double* est, MKL_INT* kase, MKL_INT* isave );
void DLACN2_( const MKL_INT* n, double* v, double* x, MKL_INT* isgn,
              double* est, MKL_INT* kase, MKL_INT* isave );
void dlacn2( const MKL_INT* n, double* v, double* x, MKL_INT* isgn,
             double* est, MKL_INT* kase, MKL_INT* isave );
void dlacn2_( const MKL_INT* n, double* v, double* x, MKL_INT* isgn,
              double* est, MKL_INT* kase, MKL_INT* isave );

void DLACON( const MKL_INT* n, double* v, double* x, MKL_INT* isgn,
             double* est, MKL_INT* kase );
void DLACON_( const MKL_INT* n, double* v, double* x, MKL_INT* isgn,
              double* est, MKL_INT* kase );
void dlacon( const MKL_INT* n, double* v, double* x, MKL_INT* isgn,
             double* est, MKL_INT* kase );
void dlacon_( const MKL_INT* n, double* v, double* x, MKL_INT* isgn,
              double* est, MKL_INT* kase );

void DLACPY( const char* uplo, const MKL_INT* m, const MKL_INT* n,
             const double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb );
void DLACPY_( const char* uplo, const MKL_INT* m, const MKL_INT* n,
              const double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb );
void dlacpy( const char* uplo, const MKL_INT* m, const MKL_INT* n,
             const double* a, const MKL_INT* lda, double* b,
             const MKL_INT* ldb );
void dlacpy_( const char* uplo, const MKL_INT* m, const MKL_INT* n,
              const double* a, const MKL_INT* lda, double* b,
              const MKL_INT* ldb );

void DLADIV( const double* a, const double* b, const double* c,
             const double* d, double* p, double* q );
void DLADIV_( const double* a, const double* b, const double* c,
              const double* d, double* p, double* q );
void dladiv( const double* a, const double* b, const double* c,
             const double* d, double* p, double* q );
void dladiv_( const double* a, const double* b, const double* c,
              const double* d, double* p, double* q );

void DLAE2( const double* a, const double* b, const double* c, double* rt1,
            double* rt2 );
void DLAE2_( const double* a, const double* b, const double* c, double* rt1,
             double* rt2 );
void dlae2( const double* a, const double* b, const double* c, double* rt1,
            double* rt2 );
void dlae2_( const double* a, const double* b, const double* c, double* rt1,
             double* rt2 );

void DLAEBZ( const MKL_INT* ijob, const MKL_INT* nitmax, const MKL_INT* n,
             const MKL_INT* mmax, const MKL_INT* minp, const MKL_INT* nbmin,
             const double* abstol, const double* reltol, const double* pivmin,
             const double* d, const double* e, const double* e2, MKL_INT* nval,
             double* ab, double* c, MKL_INT* mout, MKL_INT* nab, double* work,
             MKL_INT* iwork, MKL_INT* info );
void DLAEBZ_( const MKL_INT* ijob, const MKL_INT* nitmax, const MKL_INT* n,
              const MKL_INT* mmax, const MKL_INT* minp, const MKL_INT* nbmin,
              const double* abstol, const double* reltol, const double* pivmin,
              const double* d, const double* e, const double* e2,
              MKL_INT* nval, double* ab, double* c, MKL_INT* mout,
              MKL_INT* nab, double* work, MKL_INT* iwork, MKL_INT* info );
void dlaebz( const MKL_INT* ijob, const MKL_INT* nitmax, const MKL_INT* n,
             const MKL_INT* mmax, const MKL_INT* minp, const MKL_INT* nbmin,
             const double* abstol, const double* reltol, const double* pivmin,
             const double* d, const double* e, const double* e2, MKL_INT* nval,
             double* ab, double* c, MKL_INT* mout, MKL_INT* nab, double* work,
             MKL_INT* iwork, MKL_INT* info );
void dlaebz_( const MKL_INT* ijob, const MKL_INT* nitmax, const MKL_INT* n,
              const MKL_INT* mmax, const MKL_INT* minp, const MKL_INT* nbmin,
              const double* abstol, const double* reltol, const double* pivmin,
              const double* d, const double* e, const double* e2,
              MKL_INT* nval, double* ab, double* c, MKL_INT* mout,
              MKL_INT* nab, double* work, MKL_INT* iwork, MKL_INT* info );

void DLAED0( const MKL_INT* icompq, const MKL_INT* qsiz, const MKL_INT* n,
             double* d, const double* e, double* q, const MKL_INT* ldq,
             double* qstore, const MKL_INT* ldqs, double* work, MKL_INT* iwork,
             MKL_INT* info );
void DLAED0_( const MKL_INT* icompq, const MKL_INT* qsiz, const MKL_INT* n,
              double* d, const double* e, double* q, const MKL_INT* ldq,
              double* qstore, const MKL_INT* ldqs, double* work,
              MKL_INT* iwork, MKL_INT* info );
void dlaed0( const MKL_INT* icompq, const MKL_INT* qsiz, const MKL_INT* n,
             double* d, const double* e, double* q, const MKL_INT* ldq,
             double* qstore, const MKL_INT* ldqs, double* work, MKL_INT* iwork,
             MKL_INT* info );
void dlaed0_( const MKL_INT* icompq, const MKL_INT* qsiz, const MKL_INT* n,
              double* d, const double* e, double* q, const MKL_INT* ldq,
              double* qstore, const MKL_INT* ldqs, double* work,
              MKL_INT* iwork, MKL_INT* info );

void DLAED1( const MKL_INT* n, double* d, double* q, const MKL_INT* ldq,
             MKL_INT* indxq, const double* rho, const MKL_INT* cutpnt,
             double* work, MKL_INT* iwork, MKL_INT* info );
void DLAED1_( const MKL_INT* n, double* d, double* q, const MKL_INT* ldq,
              MKL_INT* indxq, const double* rho, const MKL_INT* cutpnt,
              double* work, MKL_INT* iwork, MKL_INT* info );
void dlaed1( const MKL_INT* n, double* d, double* q, const MKL_INT* ldq,
             MKL_INT* indxq, const double* rho, const MKL_INT* cutpnt,
             double* work, MKL_INT* iwork, MKL_INT* info );
void dlaed1_( const MKL_INT* n, double* d, double* q, const MKL_INT* ldq,
              MKL_INT* indxq, const double* rho, const MKL_INT* cutpnt,
              double* work, MKL_INT* iwork, MKL_INT* info );

void DLAED2( MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, double* d,
             double* q, const MKL_INT* ldq, MKL_INT* indxq, double* rho,
             const double* z, double* dlamda, double* w, double* q2,
             MKL_INT* indx, MKL_INT* indxc, MKL_INT* indxp, MKL_INT* coltyp,
             MKL_INT* info );
void DLAED2_( MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, double* d,
              double* q, const MKL_INT* ldq, MKL_INT* indxq, double* rho,
              const double* z, double* dlamda, double* w, double* q2,
              MKL_INT* indx, MKL_INT* indxc, MKL_INT* indxp, MKL_INT* coltyp,
              MKL_INT* info );
void dlaed2( MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, double* d,
             double* q, const MKL_INT* ldq, MKL_INT* indxq, double* rho,
             const double* z, double* dlamda, double* w, double* q2,
             MKL_INT* indx, MKL_INT* indxc, MKL_INT* indxp, MKL_INT* coltyp,
             MKL_INT* info );
void dlaed2_( MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, double* d,
              double* q, const MKL_INT* ldq, MKL_INT* indxq, double* rho,
              const double* z, double* dlamda, double* w, double* q2,
              MKL_INT* indx, MKL_INT* indxc, MKL_INT* indxp, MKL_INT* coltyp,
              MKL_INT* info );

void DLAED3( const MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, double* d,
             double* q, const MKL_INT* ldq, const double* rho, double* dlamda,
             const double* q2, const MKL_INT* indx, const MKL_INT* ctot,
             double* w, double* s, MKL_INT* info );
void DLAED3_( const MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, double* d,
              double* q, const MKL_INT* ldq, const double* rho, double* dlamda,
              const double* q2, const MKL_INT* indx, const MKL_INT* ctot,
              double* w, double* s, MKL_INT* info );
void dlaed3( const MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, double* d,
             double* q, const MKL_INT* ldq, const double* rho, double* dlamda,
             const double* q2, const MKL_INT* indx, const MKL_INT* ctot,
             double* w, double* s, MKL_INT* info );
void dlaed3_( const MKL_INT* k, const MKL_INT* n, const MKL_INT* n1, double* d,
              double* q, const MKL_INT* ldq, const double* rho, double* dlamda,
              const double* q2, const MKL_INT* indx, const MKL_INT* ctot,
              double* w, double* s, MKL_INT* info );

void DLAED4( const MKL_INT* n, const MKL_INT* i, const double* d,
             const double* z, double* delta, const double* rho, double* dlam,
             MKL_INT* info );
void DLAED4_( const MKL_INT* n, const MKL_INT* i, const double* d,
              const double* z, double* delta, const double* rho, double* dlam,
              MKL_INT* info );
void dlaed4( const MKL_INT* n, const MKL_INT* i, const double* d,
             const double* z, double* delta, const double* rho, double* dlam,
             MKL_INT* info );
void dlaed4_( const MKL_INT* n, const MKL_INT* i, const double* d,
              const double* z, double* delta, const double* rho, double* dlam,
              MKL_INT* info );

void DLAED5( const MKL_INT* i, const double* d, const double* z, double* delta,
             const double* rho, double* dlam );
void DLAED5_( const MKL_INT* i, const double* d, const double* z,
              double* delta, const double* rho, double* dlam );
void dlaed5( const MKL_INT* i, const double* d, const double* z, double* delta,
             const double* rho, double* dlam );
void dlaed5_( const MKL_INT* i, const double* d, const double* z,
              double* delta, const double* rho, double* dlam );

void DLAED6( const MKL_INT* kniter, const MKL_INT* orgati, const double* rho,
             const double* d, const double* z, const double* finit,
             double* tau, MKL_INT* info );
void DLAED6_( const MKL_INT* kniter, const MKL_INT* orgati, const double* rho,
              const double* d, const double* z, const double* finit,
              double* tau, MKL_INT* info );
void dlaed6( const MKL_INT* kniter, const MKL_INT* orgati, const double* rho,
             const double* d, const double* z, const double* finit,
             double* tau, MKL_INT* info );
void dlaed6_( const MKL_INT* kniter, const MKL_INT* orgati, const double* rho,
              const double* d, const double* z, const double* finit,
              double* tau, MKL_INT* info );

void DLAED7( const MKL_INT* icompq, const MKL_INT* n, const MKL_INT* qsiz,
             const MKL_INT* tlvls, const MKL_INT* curlvl,
             const MKL_INT* curpbm, double* d, double* q, const MKL_INT* ldq,
             MKL_INT* indxq, const double* rho, const MKL_INT* cutpnt,
             double* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
             const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
             const double* givnum, double* work, MKL_INT* iwork,
             MKL_INT* info );
void DLAED7_( const MKL_INT* icompq, const MKL_INT* n, const MKL_INT* qsiz,
              const MKL_INT* tlvls, const MKL_INT* curlvl,
              const MKL_INT* curpbm, double* d, double* q, const MKL_INT* ldq,
              MKL_INT* indxq, const double* rho, const MKL_INT* cutpnt,
              double* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
              const MKL_INT* perm, const MKL_INT* givptr,
              const MKL_INT* givcol, const double* givnum, double* work,
              MKL_INT* iwork, MKL_INT* info );
void dlaed7( const MKL_INT* icompq, const MKL_INT* n, const MKL_INT* qsiz,
             const MKL_INT* tlvls, const MKL_INT* curlvl,
             const MKL_INT* curpbm, double* d, double* q, const MKL_INT* ldq,
             MKL_INT* indxq, const double* rho, const MKL_INT* cutpnt,
             double* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
             const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
             const double* givnum, double* work, MKL_INT* iwork,
             MKL_INT* info );
void dlaed7_( const MKL_INT* icompq, const MKL_INT* n, const MKL_INT* qsiz,
              const MKL_INT* tlvls, const MKL_INT* curlvl,
              const MKL_INT* curpbm, double* d, double* q, const MKL_INT* ldq,
              MKL_INT* indxq, const double* rho, const MKL_INT* cutpnt,
              double* qstore, MKL_INT* qptr, const MKL_INT* prmptr,
              const MKL_INT* perm, const MKL_INT* givptr,
              const MKL_INT* givcol, const double* givnum, double* work,
              MKL_INT* iwork, MKL_INT* info );

void DLAED8( const MKL_INT* icompq, MKL_INT* k, const MKL_INT* n,
             const MKL_INT* qsiz, double* d, double* q, const MKL_INT* ldq,
             const MKL_INT* indxq, double* rho, const MKL_INT* cutpnt,
             const double* z, double* dlamda, double* q2, const MKL_INT* ldq2,
             double* w, MKL_INT* perm, MKL_INT* givptr, MKL_INT* givcol,
             double* givnum, MKL_INT* indxp, MKL_INT* indx, MKL_INT* info );
void DLAED8_( const MKL_INT* icompq, MKL_INT* k, const MKL_INT* n,
              const MKL_INT* qsiz, double* d, double* q, const MKL_INT* ldq,
              const MKL_INT* indxq, double* rho, const MKL_INT* cutpnt,
              const double* z, double* dlamda, double* q2, const MKL_INT* ldq2,
              double* w, MKL_INT* perm, MKL_INT* givptr, MKL_INT* givcol,
              double* givnum, MKL_INT* indxp, MKL_INT* indx, MKL_INT* info );
void dlaed8( const MKL_INT* icompq, MKL_INT* k, const MKL_INT* n,
             const MKL_INT* qsiz, double* d, double* q, const MKL_INT* ldq,
             const MKL_INT* indxq, double* rho, const MKL_INT* cutpnt,
             const double* z, double* dlamda, double* q2, const MKL_INT* ldq2,
             double* w, MKL_INT* perm, MKL_INT* givptr, MKL_INT* givcol,
             double* givnum, MKL_INT* indxp, MKL_INT* indx, MKL_INT* info );
void dlaed8_( const MKL_INT* icompq, MKL_INT* k, const MKL_INT* n,
              const MKL_INT* qsiz, double* d, double* q, const MKL_INT* ldq,
              const MKL_INT* indxq, double* rho, const MKL_INT* cutpnt,
              const double* z, double* dlamda, double* q2, const MKL_INT* ldq2,
              double* w, MKL_INT* perm, MKL_INT* givptr, MKL_INT* givcol,
              double* givnum, MKL_INT* indxp, MKL_INT* indx, MKL_INT* info );

void DLAED9( const MKL_INT* k, const MKL_INT* kstart, const MKL_INT* kstop,
             const MKL_INT* n, double* d, double* q, const MKL_INT* ldq,
             const double* rho, const double* dlamda, const double* w,
             double* s, const MKL_INT* lds, MKL_INT* info );
void DLAED9_( const MKL_INT* k, const MKL_INT* kstart, const MKL_INT* kstop,
              const MKL_INT* n, double* d, double* q, const MKL_INT* ldq,
              const double* rho, const double* dlamda, const double* w,
              double* s, const MKL_INT* lds, MKL_INT* info );
void dlaed9( const MKL_INT* k, const MKL_INT* kstart, const MKL_INT* kstop,
             const MKL_INT* n, double* d, double* q, const MKL_INT* ldq,
             const double* rho, const double* dlamda, const double* w,
             double* s, const MKL_INT* lds, MKL_INT* info );
void dlaed9_( const MKL_INT* k, const MKL_INT* kstart, const MKL_INT* kstop,
              const MKL_INT* n, double* d, double* q, const MKL_INT* ldq,
              const double* rho, const double* dlamda, const double* w,
              double* s, const MKL_INT* lds, MKL_INT* info );

void DLAEDA( const MKL_INT* n, const MKL_INT* tlvls, const MKL_INT* curlvl,
             const MKL_INT* curpbm, const MKL_INT* prmptr, const MKL_INT* perm,
             const MKL_INT* givptr, const MKL_INT* givcol,
             const double* givnum, const double* q, const MKL_INT* qptr,
             double* z, double* ztemp, MKL_INT* info );
void DLAEDA_( const MKL_INT* n, const MKL_INT* tlvls, const MKL_INT* curlvl,
              const MKL_INT* curpbm, const MKL_INT* prmptr,
              const MKL_INT* perm, const MKL_INT* givptr,
              const MKL_INT* givcol, const double* givnum, const double* q,
              const MKL_INT* qptr, double* z, double* ztemp, MKL_INT* info );
void dlaeda( const MKL_INT* n, const MKL_INT* tlvls, const MKL_INT* curlvl,
             const MKL_INT* curpbm, const MKL_INT* prmptr, const MKL_INT* perm,
             const MKL_INT* givptr, const MKL_INT* givcol,
             const double* givnum, const double* q, const MKL_INT* qptr,
             double* z, double* ztemp, MKL_INT* info );
void dlaeda_( const MKL_INT* n, const MKL_INT* tlvls, const MKL_INT* curlvl,
              const MKL_INT* curpbm, const MKL_INT* prmptr,
              const MKL_INT* perm, const MKL_INT* givptr,
              const MKL_INT* givcol, const double* givnum, const double* q,
              const MKL_INT* qptr, double* z, double* ztemp, MKL_INT* info );

void DLAEIN( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
             const double* h, const MKL_INT* ldh, const double* wr,
             const double* wi, double* vr, double* vi, double* b,
             const MKL_INT* ldb, double* work, const double* eps3,
             const double* smlnum, const double* bignum, MKL_INT* info );
void DLAEIN_( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
              const double* h, const MKL_INT* ldh, const double* wr,
              const double* wi, double* vr, double* vi, double* b,
              const MKL_INT* ldb, double* work, const double* eps3,
              const double* smlnum, const double* bignum, MKL_INT* info );
void dlaein( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
             const double* h, const MKL_INT* ldh, const double* wr,
             const double* wi, double* vr, double* vi, double* b,
             const MKL_INT* ldb, double* work, const double* eps3,
             const double* smlnum, const double* bignum, MKL_INT* info );
void dlaein_( const MKL_INT* rightv, const MKL_INT* noinit, const MKL_INT* n,
              const double* h, const MKL_INT* ldh, const double* wr,
              const double* wi, double* vr, double* vi, double* b,
              const MKL_INT* ldb, double* work, const double* eps3,
              const double* smlnum, const double* bignum, MKL_INT* info );

void DLAEV2( const double* a, const double* b, const double* c, double* rt1,
             double* rt2, double* cs1, double* sn1 );
void DLAEV2_( const double* a, const double* b, const double* c, double* rt1,
              double* rt2, double* cs1, double* sn1 );
void dlaev2( const double* a, const double* b, const double* c, double* rt1,
             double* rt2, double* cs1, double* sn1 );
void dlaev2_( const double* a, const double* b, const double* c, double* rt1,
              double* rt2, double* cs1, double* sn1 );

void DLAEXC( const MKL_INT* wantq, const MKL_INT* n, double* t,
             const MKL_INT* ldt, double* q, const MKL_INT* ldq,
             const MKL_INT* j1, const MKL_INT* n1, const MKL_INT* n2,
             double* work, MKL_INT* info );
void DLAEXC_( const MKL_INT* wantq, const MKL_INT* n, double* t,
              const MKL_INT* ldt, double* q, const MKL_INT* ldq,
              const MKL_INT* j1, const MKL_INT* n1, const MKL_INT* n2,
              double* work, MKL_INT* info );
void dlaexc( const MKL_INT* wantq, const MKL_INT* n, double* t,
             const MKL_INT* ldt, double* q, const MKL_INT* ldq,
             const MKL_INT* j1, const MKL_INT* n1, const MKL_INT* n2,
             double* work, MKL_INT* info );
void dlaexc_( const MKL_INT* wantq, const MKL_INT* n, double* t,
              const MKL_INT* ldt, double* q, const MKL_INT* ldq,
              const MKL_INT* j1, const MKL_INT* n1, const MKL_INT* n2,
              double* work, MKL_INT* info );

void DLAG2( const double* a, const MKL_INT* lda, const double* b,
            const MKL_INT* ldb, const double* safmin, double* scale1,
            double* scale2, double* wr1, double* wr2, double* wi );
void DLAG2_( const double* a, const MKL_INT* lda, const double* b,
             const MKL_INT* ldb, const double* safmin, double* scale1,
             double* scale2, double* wr1, double* wr2, double* wi );
void dlag2( const double* a, const MKL_INT* lda, const double* b,
            const MKL_INT* ldb, const double* safmin, double* scale1,
            double* scale2, double* wr1, double* wr2, double* wi );
void dlag2_( const double* a, const MKL_INT* lda, const double* b,
             const MKL_INT* ldb, const double* safmin, double* scale1,
             double* scale2, double* wr1, double* wr2, double* wi );

void DLAG2S( const MKL_INT* m, const MKL_INT* n, const double* a,
             const MKL_INT* lda, float* sa, const MKL_INT* ldsa,
             MKL_INT* info );
void DLAG2S_( const MKL_INT* m, const MKL_INT* n, const double* a,
              const MKL_INT* lda, float* sa, const MKL_INT* ldsa,
              MKL_INT* info );
void dlag2s( const MKL_INT* m, const MKL_INT* n, const double* a,
             const MKL_INT* lda, float* sa, const MKL_INT* ldsa,
             MKL_INT* info );
void dlag2s_( const MKL_INT* m, const MKL_INT* n, const double* a,
              const MKL_INT* lda, float* sa, const MKL_INT* ldsa,
              MKL_INT* info );

void DLAGS2( const MKL_INT* upper, const double* a1, const double* a2,
             const double* a3, const double* b1, const double* b2,
             const double* b3, double* csu, double* snu, double* csv,
             double* snv, double* csq, double* snq );
void DLAGS2_( const MKL_INT* upper, const double* a1, const double* a2,
              const double* a3, const double* b1, const double* b2,
              const double* b3, double* csu, double* snu, double* csv,
              double* snv, double* csq, double* snq );
void dlags2( const MKL_INT* upper, const double* a1, const double* a2,
             const double* a3, const double* b1, const double* b2,
             const double* b3, double* csu, double* snu, double* csv,
             double* snv, double* csq, double* snq );
void dlags2_( const MKL_INT* upper, const double* a1, const double* a2,
              const double* a3, const double* b1, const double* b2,
              const double* b3, double* csu, double* snu, double* csv,
              double* snv, double* csq, double* snq );

void DLAGTF( const MKL_INT* n, double* a, const double* lambda, double* b,
             double* c, const double* tol, double* d, MKL_INT* in,
             MKL_INT* info );
void DLAGTF_( const MKL_INT* n, double* a, const double* lambda, double* b,
              double* c, const double* tol, double* d, MKL_INT* in,
              MKL_INT* info );
void dlagtf( const MKL_INT* n, double* a, const double* lambda, double* b,
             double* c, const double* tol, double* d, MKL_INT* in,
             MKL_INT* info );
void dlagtf_( const MKL_INT* n, double* a, const double* lambda, double* b,
              double* c, const double* tol, double* d, MKL_INT* in,
              MKL_INT* info );

void DLAGTM( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* alpha, const double* dl, const double* d,
             const double* du, const double* x, const MKL_INT* ldx,
             const double* beta, double* b, const MKL_INT* ldb );
void DLAGTM_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* alpha, const double* dl, const double* d,
              const double* du, const double* x, const MKL_INT* ldx,
              const double* beta, double* b, const MKL_INT* ldb );
void dlagtm( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
             const double* alpha, const double* dl, const double* d,
             const double* du, const double* x, const MKL_INT* ldx,
             const double* beta, double* b, const MKL_INT* ldb );
void dlagtm_( const char* trans, const MKL_INT* n, const MKL_INT* nrhs,
              const double* alpha, const double* dl, const double* d,
              const double* du, const double* x, const MKL_INT* ldx,
              const double* beta, double* b, const MKL_INT* ldb );

void DLAGTS( const MKL_INT* job, const MKL_INT* n, const double* a,
             const double* b, const double* c, const double* d,
             const MKL_INT* in, double* y, double* tol, MKL_INT* info );
void DLAGTS_( const MKL_INT* job, const MKL_INT* n, const double* a,
              const double* b, const double* c, const double* d,
              const MKL_INT* in, double* y, double* tol, MKL_INT* info );
void dlagts( const MKL_INT* job, const MKL_INT* n, const double* a,
             const double* b, const double* c, const double* d,
             const MKL_INT* in, double* y, double* tol, MKL_INT* info );
void dlagts_( const MKL_INT* job, const MKL_INT* n, const double* a,
              const double* b, const double* c, const double* d,
              const MKL_INT* in, double* y, double* tol, MKL_INT* info );

void DLAGV2( double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             double* alphar, double* alphai, double* beta, double* csl,
             double* snl, double* csr, double* snr );
void DLAGV2_( double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              double* alphar, double* alphai, double* beta, double* csl,
              double* snl, double* csr, double* snr );
void dlagv2( double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
             double* alphar, double* alphai, double* beta, double* csl,
             double* snl, double* csr, double* snr );
void dlagv2_( double* a, const MKL_INT* lda, double* b, const MKL_INT* ldb,
              double* alphar, double* alphai, double* beta, double* csl,
              double* snl, double* csr, double* snr );

void DLAHQR( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, double* h,
             const MKL_INT* ldh, double* wr, double* wi, const MKL_INT* iloz,
             const MKL_INT* ihiz, double* z, const MKL_INT* ldz,
             MKL_INT* info );
void DLAHQR_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, double* h,
              const MKL_INT* ldh, double* wr, double* wi, const MKL_INT* iloz,
              const MKL_INT* ihiz, double* z, const MKL_INT* ldz,
              MKL_INT* info );
void dlahqr( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
             const MKL_INT* ilo, const MKL_INT* ihi, double* h,
             const MKL_INT* ldh, double* wr, double* wi, const MKL_INT* iloz,
             const MKL_INT* ihiz, double* z, const MKL_INT* ldz,
             MKL_INT* info );
void dlahqr_( const MKL_INT* wantt, const MKL_INT* wantz, const MKL_INT* n,
              const MKL_INT* ilo, const MKL_INT* ihi, double* h,
              const MKL_INT* ldh, double* wr, double* wi, const MKL_INT* iloz,
              const MKL_INT* ihiz, double* z, const MKL_INT* ldz,
              MKL_INT* info );

void DLAHR2( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, double* a,
             const MKL_INT* lda, double* tau, double* t, const MKL_INT* ldt,
             double* y, const MKL_INT* ldy );
void DLAHR2_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, double* a,
              const MKL_INT* lda, double* tau, double* t, const MKL_INT* ldt,
              double* y, const MKL_INT* ldy );
void dlahr2( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, double* a,
             const MKL_INT* lda, double* tau, double* t, const MKL_INT* ldt,
             double* y, const MKL_INT* ldy );
void dlahr2_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, double* a,
              const MKL_INT* lda, double* tau, double* t, const MKL_INT* ldt,
              double* y, const MKL_INT* ldy );

void DLAHRD( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, double* a,
             const MKL_INT* lda, double* tau, double* t, const MKL_INT* ldt,
             double* y, const MKL_INT* ldy );
void DLAHRD_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, double* a,
              const MKL_INT* lda, double* tau, double* t, const MKL_INT* ldt,
              double* y, const MKL_INT* ldy );
void dlahrd( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, double* a,
             const MKL_INT* lda, double* tau, double* t, const MKL_INT* ldt,
             double* y, const MKL_INT* ldy );
void dlahrd_( const MKL_INT* n, const MKL_INT* k, const MKL_INT* nb, double* a,
              const MKL_INT* lda, double* tau, double* t, const MKL_INT* ldt,
              double* y, const MKL_INT* ldy );

void DLAIC1( const MKL_INT* job, const MKL_INT* j, const double* x,
             const double* sest, const double* w, const double* gamma,
             double* sestpr, double* s, double* c );
void DLAIC1_( const MKL_INT* job, const MKL_INT* j, const double* x,
              const double* sest, const double* w, const double* gamma,
              double* sestpr, double* s, double* c );
void dlaic1( const MKL_INT* job, const MKL_INT* j, const double* x,
             const double* sest, const double* w, const double* gamma,
             double* sestpr, double* s, double* c );
void dlaic1_( const MKL_INT* job, const MKL_INT* j, const double* x,
              const double* sest, const double* w, const double* gamma,
              double* sestpr, double* s, double* c );

MKL_INT DLAISNAN( const double* din1, const double* din2 );
MKL_INT DLAISNAN_( const double* din1, const double* din2 );
MKL_INT dlaisnan( const double* din1, const double* din2 );
MKL_INT dlaisnan_( const double* din1, const double* din2 );

void DLALN2( const MKL_INT* ltrans, const MKL_INT* na, const MKL_INT* nw,
             const double* smin, const double* ca, const double* a,
             const MKL_INT* lda, const double* d1, const double* d2,
             const double* b, const MKL_INT* ldb, const double* wr,
             const double* wi, double* x, const MKL_INT* ldx, double* scale,
             double* xnorm, MKL_INT* info );
void DLALN2_( const MKL_INT* ltrans, const MKL_INT* na, const MKL_INT* nw,
              const double* smin, const double* ca, const double* a,
              const MKL_INT* lda, const double* d1, const double* d2,
              const double* b, const MKL_INT* ldb, const double* wr,
              const double* wi, double* x, const MKL_INT* ldx, double* scale,
              double* xnorm, MKL_INT* info );
void dlaln2( const MKL_INT* ltrans, const MKL_INT* na, const MKL_INT* nw,
             const double* smin, const double* ca, const double* a,
             const MKL_INT* lda, const double* d1, const double* d2,
             const double* b, const MKL_INT* ldb, const double* wr,
             const double* wi, double* x, const MKL_INT* ldx, double* scale,
             double* xnorm, MKL_INT* info );
void dlaln2_( const MKL_INT* ltrans, const MKL_INT* na, const MKL_INT* nw,
              const double* smin, const double* ca, const double* a,
              const MKL_INT* lda, const double* d1, const double* d2,
              const double* b, const MKL_INT* ldb, const double* wr,
              const double* wi, double* x, const MKL_INT* ldx, double* scale,
              double* xnorm, MKL_INT* info );

void DLALS0( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
             const MKL_INT* sqre, const MKL_INT* nrhs, double* b,
             const MKL_INT* ldb, double* bx, const MKL_INT* ldbx,
             const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
             const MKL_INT* ldgcol, const double* givnum,
             const MKL_INT* ldgnum, const double* poles, const double* difl,
             const double* difr, const double* z, const MKL_INT* k,
             const double* c, const double* s, double* work, MKL_INT* info );
void DLALS0_( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
              const MKL_INT* sqre, const MKL_INT* nrhs, double* b,
              const MKL_INT* ldb, double* bx, const MKL_INT* ldbx,
              const MKL_INT* perm, const MKL_INT* givptr,
              const MKL_INT* givcol, const MKL_INT* ldgcol,
              const double* givnum, const MKL_INT* ldgnum, const double* poles,
              const double* difl, const double* difr, const double* z,
              const MKL_INT* k, const double* c, const double* s, double* work,
              MKL_INT* info );
void dlals0( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
             const MKL_INT* sqre, const MKL_INT* nrhs, double* b,
             const MKL_INT* ldb, double* bx, const MKL_INT* ldbx,
             const MKL_INT* perm, const MKL_INT* givptr, const MKL_INT* givcol,
             const MKL_INT* ldgcol, const double* givnum,
             const MKL_INT* ldgnum, const double* poles, const double* difl,
             const double* difr, const double* z, const MKL_INT* k,
             const double* c, const double* s, double* work, MKL_INT* info );
void dlals0_( const MKL_INT* icompq, const MKL_INT* nl, const MKL_INT* nr,
              const MKL_INT* sqre, const MKL_INT* nrhs, double* b,
              const MKL_INT* ldb, double* bx, const MKL_INT* ldbx,
              const MKL_INT* perm, const MKL_INT* givptr,
              const MKL_INT* givcol, const MKL_INT* ldgcol,
              const double* givnum, const MKL_INT* ldgnum, const double* poles,
              const double* difl, const double* difr, const double* z,
              const MKL_INT* k, const double* c, const double* s, double* work,
              MKL_INT* info );

void DLALSA( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
             const MKL_INT* nrhs, double* b, const MKL_INT* ldb, double* bx,
             const MKL_INT* ldbx, const double* u, const MKL_INT* ldu,
             const double* vt, const MKL_INT* k, const double* difl,
             const double* difr, const double* z, const double* poles,
             const MKL_INT* givptr, const MKL_INT* givcol,
             const MKL_INT* ldgcol, const MKL_INT* perm, const double* givnum,
             const double* c, const double* s, double* work, MKL_INT* iwork,
             MKL_INT* info );
void DLALSA_( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
              const MKL_INT* nrhs, double* b, const MKL_INT* ldb, double* bx,
              const MKL_INT* ldbx, const double* u, const MKL_INT* ldu,
              const double* vt, const MKL_INT* k, const double* difl,
              const double* difr, const double* z, const double* poles,
              const MKL_INT* givptr, const MKL_INT* givcol,
              const MKL_INT* ldgcol, const MKL_INT* perm, const double* givnum,
              const double* c, const double* s, double* work, MKL_INT* iwork,
              MKL_INT* info );
void dlalsa( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
             const MKL_INT* nrhs, double* b, const MKL_INT* ldb, double* bx,
             const MKL_INT* ldbx, const double* u, const MKL_INT* ldu,
             const double* vt, const MKL_INT* k, const double* difl,
             const double* difr, const double* z, const double* poles,
             const MKL_INT* givptr, const MKL_INT* givcol,
             const MKL_INT* ldgcol, const MKL_INT* perm, const double* givnum,
             const double* c, const double* s, double* work, MKL_INT* iwork,
             MKL_INT* info );
void dlalsa_( const MKL_INT* icompq, const MKL_INT* smlsiz, const MKL_INT* n,
              const MKL_INT* nrhs, double* b, const MKL_INT* ldb, double* bx,
              const MKL_INT* ldbx, const double* u, const MKL_INT* ldu,
              const double* vt, const MKL_INT* k, const double* difl,
              const double* difr, const double* z, const double* poles,
              const MKL_INT* givptr, const MKL_INT* givcol,
              const MKL_INT* ldgcol, const MKL_INT* perm, const double* givnum,
              const double* c, const double* s, double* work, MKL_INT* iwork,
              MKL_INT* info );

void DLALSD( const char* uplo, const MKL_INT* smlsiz, const MKL_INT* n,
             const MKL_INT* nrhs, double* d, double* e, double* b,
             const MKL_INT* ldb, const double* rcond, MKL_INT* rank,
             double* work, MKL_INT* iwork, MKL_INT* info );
void DLALSD_( const char* uplo, const MKL_INT* smlsiz, const MKL_INT* n,
              const MKL_INT* nrhs, double* d, double* e, double* b,
              const MKL_INT* ldb, const double* rcond, MKL_INT* rank,
              double* work, MKL_INT* iwork, MKL_INT* info );
void dlalsd( const char* uplo, const MKL_INT* smlsiz, const MKL_INT* n,
             const MKL_INT* nrhs, double* d, double* e, double* b,
             const MKL_INT* ldb, const double* rcond, MKL_INT* rank,
             double* work, MKL_INT* iwork, MKL_INT* info );
void dlalsd_( const char* uplo, const MKL_INT* smlsiz, const MKL_INT* n,
              const MKL_INT* nrhs, double* d, double* e, double* b,
              const MKL_INT* ldb, const double* rcond, MKL_INT* rank,
              double* work, MKL_INT* iwork, MKL_INT* info );

double DLAMCH( const char* cmach );
double DLAMCH_( const char* cmach );
double dlamch( const char* cmach );
double dlamch_( const char* cmach );

void DLAMC1( MKL_INT* beta, MKL_INT* t, MKL_INT* rnd, MKL_INT* ieee1 );
void DLAMC1_( MKL_INT* beta, MKL_INT* t, MKL_INT* rnd, MKL_INT* ieee1 );
void dlamc1( MKL_INT* beta, MKL_INT* t, MKL_INT* rnd, MKL_INT* ieee1 );
void dlamc1_( MKL_INT* beta, MKL_INT* t, MKL_INT* rnd, MKL_INT* ieee1 );

void DLAMC2( MKL_INT* beta, MKL_INT* t, MKL_INT* rnd, double* eps,
             MKL_INT* emin, double* rmin, MKL_INT* emax, double* rmax );
void DLAMC2_( MKL_INT* beta, MKL_INT* t, MKL_INT* rnd, double* eps,
              MKL_INT* emin, double* rmin, MKL_INT* emax, double* rmax );
void dlamc2( MKL_INT* beta, MKL_INT* t, MKL_INT* rnd, double* eps,
             MKL_INT* emin, double* rmin, MKL_INT* emax, double* rmax );
void dlamc2_( MKL_INT* beta, MKL_INT* t, MKL_INT* rnd, double* eps,
              MKL_INT* emin, double* rmin, MKL_INT* emax, double* rmax );

double DLAMC3( const double* a, const double* b );
double DLAMC3_( const double* a, const double* b );
double dlamc3( const double* a, const double* b );
double dlamc3_( const double* a, const double* b );

void DLAMC4( MKL_INT* emin, const double* start, const MKL_INT* base );
void DLAMC4_( MKL_INT* emin, const double* start, const MKL_INT* base );
void dlamc4( MKL_INT* emin, const double* start, const MKL_INT* base );
void dlamc4_( MKL_INT* emin, const double* start, const MKL_INT* base );

void DLAMC5( const MKL_INT* beta, const MKL_INT* p, const MKL_INT* emin,
             const MKL_INT* ieee, MKL_INT* emax, double* rmax );
void DLAMC5_( const MKL_INT* beta, const MKL_INT* p, const MKL_INT* emin,
              const MKL_INT* ieee, MKL_INT* emax, double* rmax );
void dlamc5( const MKL_INT* beta, const MKL_INT* p, const MKL_INT* emin,
             const MKL_INT* ieee, MKL_INT* emax, double* rmax );
void dlamc5_( const MKL_INT* beta, const MKL_INT* p, const MKL_INT* emin,
              const MKL_INT* ieee, MKL_INT* emax, double* rmax );

void DLAMRG( const MKL_INT* n1, const MKL_INT* n2, const double* a,
             const MKL_INT* dtrd1, const MKL_INT* dtrd2, MKL_INT* index );
void DLAMRG_( const MKL_INT* n1, const MKL_INT* n2, const double* a,
              const MKL_INT* dtrd1, const MKL_INT* dtrd2, MKL_INT* index );
void dlamrg( const MKL_INT* n1, const MKL_INT* n2, const double* a,
             const MKL_INT* dtrd1, const MKL_INT* dtrd2, MKL_INT* index );
void dlamrg_( const MKL_INT* n1, const MKL_INT* n2, const double* a,
              const MKL_INT* dtrd1, const MKL_INT* dtrd2, MKL_INT* index );

MKL_INT DLANEG( const MKL_INT* n, const double* d, const double* lld,
                const double* sigma, const double* pivmin, const MKL_INT* r );
MKL_INT DLANEG_( const MKL_INT* n, const double* d, const double* lld,
                 const double* sigma, const double* pivmin, const MKL_INT* r );
MKL_INT dlaneg( const MKL_INT* n, const double* d, const double* lld,
                const double* sigma, const double* pivmin, const MKL_INT* r );
MKL_INT dlaneg_( const MKL_INT* n, const double* d, const double* lld,
                 const double* sigma, const double* pivmin, const MKL_INT* r );

double DLANGB( const char* norm, const MKL_INT* n, const MKL_INT* kl,
               const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
               double* work );
double DLANGB_( const char* norm, const MKL_INT* n, const MKL_INT* kl,
                const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
                double* work );
double dlangb( const char* norm, const MKL_INT* n, const MKL_INT* kl,
               const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
               double* work );
double dlangb_( const char* norm, const MKL_INT* n, const MKL_INT* kl,
                const MKL_INT* ku, const double* ab, const MKL_INT* ldab,
                double* work );

double DLANGE( const char* norm, const MKL_INT* m, const MKL_INT* n,
               const double* a, const MKL_INT* lda, double* work );
double DLANGE_( const char* norm, const MKL_INT* m, const MKL_INT* n,
                const double* a, const MKL_INT* lda, double* work );
double dlange( const char* norm, const MKL_INT* m, const MKL_INT* n,
               const double* a, const MKL_INT* lda, double* work );
double dlange_( const char* norm, const MKL_INT* m, const MKL_INT* n,
                const double* a, const MKL_INT* lda, double* work );

double DLANGT( const char* norm, const MKL_INT* n, const double* dl,
               const double* d, const double* du );
double DLANGT_( const char* norm, const MKL_INT* n, const double* dl,
                const double* d, const double* du );
double dlangt( const char* norm, const MKL_INT* n, const double* dl,
               const double* d, const double* du );
double dlangt_( const char* norm, const MKL_INT* n, const double* dl,
                const double* d, const double* du );

double DLANHS( const char* norm, const MKL_INT* n, const double* a,
               const MKL_INT* lda, double* work );
double DLANHS_( const char* norm, const MKL_INT* n, const double* a,
                const MKL_INT* lda, double* work );
double dlanhs( const char* norm, const MKL_INT* n, const double* a,
               const MKL_INT* lda, double* work );
double dlanhs_( const char* norm, const MKL_INT* n, const double* a,
                const MKL_INT* lda, double* work );

double DLANSB( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_INT* k, const double* ab, const MKL_INT* ldab,
               double* work );
double DLANSB_( const char* norm, const char* uplo, const MKL_INT* n,
                const MKL_INT* k, const double* ab, const MKL_INT* ldab,
                double* work );
double dlansb( const char* norm, const char* uplo, const MKL_INT* n,
               const MKL_INT* k, const double* ab, const MKL_INT* ldab,
               double* work );
double dlansb_( const char* norm, const char* uplo, const MKL_INT* n,
                const MKL_INT* k, const double* ab, const MKL_INT* ldab,
                double* work );

double DLANSF( const char* norm, const char* transr, const char* uplo,
               const MKL_INT* n, const double* a, double* work );
double DLANSF_( const char* norm, const char* transr, const char* uplo,
                const MKL_INT* n, const double* a, double* work );
double dlansf( const char* norm, const char* transr, const char* uplo,
               const MKL_INT* n, const double* a, double* work );
double dlansf_( const char* norm, const char* transr, const char* uplo,
                const MKL_INT* n, const double* a, double* work );

double DLANSP( const char* norm, const char* uplo, const MKL_INT* n,
               const double* ap, double* work );
double DLANSP_( const char* norm, const char* uplo, const MKL_INT* n,
                const double* ap, double* work );
double dlansp( const char* norm, const char* uplo, const MKL_INT* n,
               const double* ap, double* work );
double dlansp_( const char* norm, const char* uplo, const MKL_INT* n,
                const double* ap, double* work );

double DLANST( const char* norm, const MKL_INT* n, const double* d,
               const double* e );
double DLANST_( const char* norm, const MKL_INT* n, const double* d,
                const double* e );
double dlanst( const char* norm, const MKL_INT* n, const double* d,
               const double* e );
double dlanst_( const char* norm, const MKL_INT* n, const double* d,
                const double* e );

double DLANSY( const char* norm, const char* uplo, const MKL_INT* n,
               const double* a, const MKL_INT* lda, double* work );
double DLANSY_( const char* norm, const char* uplo, const MKL_INT* n,
                const double* a, const MKL_INT* lda, double* work );
double dlansy( const char* norm, const char* uplo, const MKL_INT* n,
               const double* a, const MKL_INT* lda, double* work );
double dlansy_( const char* norm, const char* uplo, const MKL_INT* n,
                const double* a, const MKL_INT* lda, double* work );

double DLANTB( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* n, const MKL_INT* k, const double* ab,
               const MKL_INT* ldab, double* work );
double DLANTB_( const char* norm, const char* uplo, const char* diag,
                const MKL_INT* n, const MKL_INT* k, const double* ab,
                const MKL_INT* ldab, double* work );
double dlantb( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* n, const MKL_INT* k, const double* ab,
               const MKL_INT* ldab, double* work );
double dlantb_( const char* norm, const char* uplo, const char* diag,
                const MKL_INT* n, const MKL_INT* k, const double* ab,
                const MKL_INT* ldab, double* work );

double DLANTP( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* n, const double* ap, double* work );
double DLANTP_( const char* norm, const char* uplo, const char* diag,
                const MKL_INT* n, const double* ap, double* work );
double dlantp( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* n, const double* ap, double* work );
double dlantp_( const char* norm, const char* uplo, const char* diag,
                const MKL_INT* n, const double* ap, double* work );

double DLANTR( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* m, const MKL_INT* n, const double* a,
               const MKL_INT* lda, double* work );
double DLANTR_( const char* norm, const char* uplo, const char* diag,
                const MKL_INT* m, const MKL_INT* n, const double* a,
                const MKL_INT* lda, double* work );
double dlantr( const char* norm, const char* uplo, const char* diag,
               const MKL_INT* m, const MKL_INT* n, const double* a,
               const MKL_INT* lda, double* work );
double dlantr_( const char* norm, const char* uplo, const char* diag,
                const MKL_INT* m, const MKL_INT* n, const double* a,
                const MKL_INT* lda, double* work );

void DLANV2( double* a, double* b, double* c, double* d, double* rt1r,
             double* rt1i, double* rt2r, double* rt2i, double* cs,
             double* sn );
void DLANV2_( double* a, double* b, double* c, double* d, double* rt1r,
              double* rt1i, double* rt2r, double* rt2i, double* cs,
              double* sn );
void dlanv2( double* a, double* b, double* c, double* d, double* rt1r,
             double* rt1i, double* rt2r, double* rt2i, double* cs,
             double* sn );
void dlanv2_( double* a, double* b, double* c, double* d, double* rt1r,
  