#################################################################################
# MIT License

# Copyright (c) 2025 Volker Wichmann

# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#################################################################################


from _typeshed import Incomplete
from typing import Any, Union, Optional, List, Literal, overload
import enum
from typing_extensions import TypeAlias  # for Python <3.10


class _SwigNonDynamicMeta(type):
    __setattr__: Incomplete

# Integer pointer-related functions
def new_intp() -> Any: ...
def copy_intp(value: int) -> Any: ...
def delete_intp(obj: Any) -> None: ...
def intp_assign(obj: Any, value: int) -> None: ...
def intp_value(obj: Any) -> int: ...

# Double (float) pointer-related functions
def new_doublep() -> Any: ...
def copy_doublep(value: float) -> Any: ...
def delete_doublep(obj: Any) -> None: ...
def doublep_assign(obj: Any, value: float) -> None: ...
def doublep_value(obj: Any) -> float: ...

SIZEOF_LONG: int

def SG_OMP_Set_Max_Num_Threads(iCores: int) -> None: ...
def SG_OMP_Get_Max_Num_Threads() -> int: ...
def SG_OMP_Get_Max_Num_Procs() -> int: ...
def SG_OMP_Get_Thread_Num() -> int: ...
def SG_Malloc(size: int) -> Any: ...
def SG_Calloc(num: int, size: int) -> Any: ...
def SG_Realloc(memblock: Any, size: int) -> Any: ...
def SG_Free(memblock: Any) -> Any: ...
def SG_Swap_Bytes(Buffer: bytes, nBytes: int) -> None: ...
def SG_Mem_Get_Int(Buffer: bytes, bSwapBytes: bool) -> int: ...
def SG_Mem_Set_Int(Buffer: bytes, Value: int, bSwapBytes: bool) -> None: ...
def SG_Mem_Get_Double(Buffer: bytes, bSwapBytes: bool) -> float: ...
def SG_Mem_Set_Double(Buffer: bytes, Value: float, bSwapBytes: bool) -> None: ...

class CSG_Buffer:
    thisown: bool
    @overload
    def __init__(self) -> CSG_Buffer: ...
    @overload
    def __init__(self, *args: Union[CSG_Buffer, int]) -> CSG_Buffer: ...
    @overload
    def Create(self) -> bool: ...
    @overload
    def Create(self, *args: Union[CSG_Buffer, int]) -> bool: ...
    __swig_destroy__: callable
    def Destroy(self) -> None: ...
    def Set_Size(self, Size: int, bShrink: bool = True) -> bool: ...
    def Inc_Size(self, Size: int) -> bool: ...
    def Get_Size(self) -> int: ...
    def Set_Data(self, Data: bytes, Size: int, bShrink: bool = True) -> bool: ...
    def Get_Data(self, Offset: int = 0) -> bytes: ...
    @overload
    def Add_Value(self, *args: Union[int, float], bBigEndian: bool = False) -> None: ...
    @overload
    def __iadd__(self, *args: Union[int, float]) -> CSG_Buffer: ...
    @overload
    def Set_Value(self, Offset: int, Value: int, bBigEndian: bool = False) -> None: ...
    @overload
    def Set_Value(self, Offset: int, Value: float, bBigEndian: bool = False) -> None: ...
    def asShort(self, Offset: int, bBigEndian: bool = False) -> int: ...
    def asInt(self, Offset: int, bBigEndian: bool = False) -> int: ...
    def asFloat(self, Offset: int, bBigEndian: bool = False) -> float: ...
    def asDouble(self, Offset: int, bBigEndian: bool = False) -> float: ...


TSG_Array_Growth_SG_ARRAY_GROWTH_0: int
TSG_Array_Growth_SG_ARRAY_GROWTH_1: int
TSG_Array_Growth_SG_ARRAY_GROWTH_2: int
TSG_Array_Growth_SG_ARRAY_GROWTH_3: int
TSG_Array_Growth_SG_ARRAY_GROWTH_FIX_8: int
TSG_Array_Growth_SG_ARRAY_GROWTH_FIX_16: int
TSG_Array_Growth_SG_ARRAY_GROWTH_FIX_32: int
TSG_Array_Growth_SG_ARRAY_GROWTH_FIX_64: int
TSG_Array_Growth_SG_ARRAY_GROWTH_FIX_128: int
TSG_Array_Growth_SG_ARRAY_GROWTH_FIX_256: int
TSG_Array_Growth_SG_ARRAY_GROWTH_FIX_512: int
TSG_Array_Growth_SG_ARRAY_GROWTH_FIX_1024: int

TSG_Array_Growth: TypeAlias = Literal[
    0,  # SG_ARRAY_GROWTH_0
    1,  # SG_ARRAY_GROWTH_1
    2,  # SG_ARRAY_GROWTH_2
    3,  # SG_ARRAY_GROWTH_3
    4,  # SG_ARRAY_GROWTH_FIX_8
    5,  # SG_ARRAY_GROWTH_FIX_16
    6,  # SG_ARRAY_GROWTH_FIX_32
    7,  # SG_ARRAY_GROWTH_FIX_64
    8,  # SG_ARRAY_GROWTH_FIX_128
    9,  # SG_ARRAY_GROWTH_FIX_256
    10, # SG_ARRAY_GROWTH_FIX_512
    11  # SG_ARRAY_GROWTH_FIX_1024
]

class CSG_Array:
    thisown: bool
    __swig_destroy__: callable
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> Any: ...
    def Destroy(self) -> bool: ...
    def Set_Growth(self, Growth) -> bool: ...
    def Get_Growth(self) -> TSG_Array_Growth: ...
    def Get_Value_Size(self) -> int: ...
    def Get_Size(self) -> int: ...
    def Get_uSize(self) -> int: ...
    def Get_Entry(self, Index) -> Any: ...
    def Del_Entry(self, Index, bShrink: bool = True) -> bool: ...
    def Get_Array(self, *args) -> Any: ...
    def Set_Array(self, *args) -> bool: ...
    def Inc_Array(self, *args) -> bool: ...
    def Dec_Array(self, *args) -> bool: ...

class CSG_Array_Pointer:
    thisown: bool
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> Any: ...
    def Destroy(self) -> None: ...
    def Set_Growth(self, Growth) -> bool: ...
    def Get_Growth(self) -> TSG_Array_Growth: ...
    def Get_Size(self) -> int: ...
    def Get_uSize(self) -> int: ...
    def Get_Array(self, *args) -> Any: ...
    def Set_Array(self, nValues, bShrink: bool = True) -> bool: ...
    def Inc_Array(self, nValues: int = 1) -> bool: ...
    def Dec_Array(self, bShrink: bool = True) -> bool: ...
    def Add(self, *args) -> bool: ...
    def Set(self, Index, Value) -> bool: ...
    def Get(self, Index) -> Any: ...
    def Del(self, *args) -> bool: ...
    def __iadd__(self, *args) -> CSG_Array_Pointer: ...
    __swig_destroy__: callable

class CSG_Array_Int:
    thisown: bool
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> Any: ...
    def Destroy(self) -> None: ...
    def Set_Growth(self, Growth) -> bool: ...
    def Get_Growth(self) -> TSG_Array_Growth: ...
    def Get_Size(self) -> int: ...
    def Get_uSize(self) -> int: ...
    def Get_Array(self, *args) -> Any: ...
    def Set_Array(self, nValues, bShrink: bool = True) -> bool: ...
    def Inc_Array(self, nValues: int = 1) -> bool: ...
    def Dec_Array(self, bShrink: bool = True) -> bool: ...
    def Add(self, *args) -> bool: ...
    def Set(self, Index, Value) -> bool: ...
    def Get(self, Index) -> int: ...
    def Assign(self, Value) -> bool: ...
    def __iadd__(self, *args) -> CSG_Array_Int: ...
    __swig_destroy__: callable

class CSG_Array_sLong:
    thisown: bool
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> Any: ...
    def Destroy(self) -> None: ...
    def Set_Growth(self, Growth) -> bool: ...
    def Get_Growth(self) -> TSG_Array_Growth: ...
    def Get_Size(self) -> int: ...
    def Get_uSize(self) -> int: ...
    def Get_Array(self, *args) -> Any: ...
    def Set_Array(self, nValues, bShrink: bool = True) -> bool: ...
    def Inc_Array(self, nValues: int = 1) -> bool: ...
    def Dec_Array(self, bShrink: bool = True) -> bool: ...
    def Add(self, *args) -> bool: ...
    def Set(self, Index, Value) -> bool: ...
    def Get(self, Index) -> int: ...
    def Assign(self, Value) -> bool: ...
    def __iadd__(self, *args) -> CSG_Array_sLong: ...
    __swig_destroy__: callable


SG_FILE_ENCODING_ANSI: int
SG_FILE_ENCODING_UTF7: int
SG_FILE_ENCODING_UTF8: int
SG_FILE_ENCODING_UTF16LE: int
SG_FILE_ENCODING_UTF16BE: int
SG_FILE_ENCODING_UTF32LE: int
SG_FILE_ENCODING_UTF32BE: int
SG_FILE_ENCODING_UNDEFINED: int

TSG_File_Flags_Encoding: TypeAlias = Literal[
    0,  # SG_FILE_ENCODING_ANSI
    1,  # SG_FILE_ENCODING_UTF7
    2,  # SG_FILE_ENCODING_UTF8
    3,  # SG_FILE_ENCODING_UTF16LE
    4,  # SG_FILE_ENCODING_UTF16BE
    5,  # SG_FILE_ENCODING_UTF32LE
    6,  # SG_FILE_ENCODING_UTF32BE
    7   # SG_FILE_ENCODING_UNDEFINED
]

class wxString: ... # dummy class

class CSG_String:
    thisown: bool
    @overload
    def __init__(self) -> CSG_String: ...
    @overload
    def __init__(self, String: Union[CSG_String, str]) -> CSG_String: ...
    @overload
    def __init__(self, Character: str, nRepeat: int = 1) -> CSG_String: ...
    @overload
    def __init__(self, pString: wxString) -> CSG_String: ...

    def Create(self, pString: wxString) -> bool: ...
    __swig_destroy__: callable
    def Length(self) -> int: ...
    def is_Empty(self) -> bool: ...
    def Get_Char(self, i: int) -> str: ...
    def Set_Char(self, i: int, Character: str) -> None: ...
    def b_str(self) -> str: ...
    def w_str(self) -> str: ...
    def c_str(self) -> str: ...
    def Prepend(self, String: CSG_String) -> CSG_String: ...
    @overload
    def Append(self, String: Union[CSG_String, str]) -> CSG_String: ...
    @overload
    def Append(self, Character: str, nRepeat: int = 1) -> CSG_String: ...
    @overload
    def __iadd__(self, String: Union[CSG_String, str]) -> CSG_String: ...
    @overload
    def __iadd__(self, Character: str) -> CSG_String: ...
    @overload
    def __add__(self, String: Union[CSG_String, str]) -> CSG_String: ...
    @overload
    def __add__(self, Character: str) -> CSG_String: ...
    def Cmp(self, String: CSG_String) -> int: ...
    def CmpNoCase(self, String: CSG_String) -> int: ...
    @overload
    def is_Same_As(self, String: Union[CSG_String, str], bCase: bool = True) -> bool: ...
    def Make_Lower(self) -> CSG_String: ...
    def Make_Upper(self) -> CSG_String: ...
    def Clear(self) -> None: ...
    @staticmethod
    def Format(Format: str) -> CSG_String: ...
    def Printf(self, Format: str) -> int: ...
    def Replace(self, Old: CSG_String, New: CSG_String, bReplaceAll: bool = True) -> int: ...
    @overload
    def Replace_Single_Char(self, Old: str, New: Union[CSG_String, str], bReplaceAll: bool = True) -> int: ...
    @overload
    def Remove(self, pos: int) -> CSG_String: ...
    @overload
    def Remove(self, pos: int, length: int) -> CSG_String: ...
    def Trim(self, fromRight: bool = False) -> int: ...
    def Trim_Both(self) -> int: ...
    @overload
    def Find(self, Character: str, fromEnd: bool = False) -> int: ...
    @overload
    def Find(self, String: CSG_String) -> int: ...
    def Contains(self, String: CSG_String) -> bool: ...
    def AfterFirst(self, Character: str) -> CSG_String: ...
    def AfterLast(self, Character: str) -> CSG_String: ...
    def BeforeFirst(self, Character: str) -> CSG_String: ...
    def BeforeLast(self, Character: str) -> CSG_String: ...
    def Right(self, count: int) -> CSG_String: ...
    def Mid(self, first: int, count: int = 0) -> CSG_String: ...
    def Left(self, count: int) -> CSG_String: ...
    def is_Number(self) -> bool: ...
    @overload
    def asInt(self) -> int: ...
    @overload
    def asInt(self, Value: int) -> bool: ...
    @overload
    def asLongLong(self) -> int: ...
    @overload
    def asLongLong(self, Value: int) -> bool: ...
    @overload
    def asDouble(self) -> float: ...
    @overload
    def asDouble(self, Value: float) -> bool: ...
    @staticmethod
    def from_UTF8(String: str, Length: int = 0) -> CSG_String: ...
    @overload
    def to_UTF8(self) -> CSG_Buffer: ...
    @overload
    def to_UTF8(self, pString: object) -> int: ...
    @overload
    def to_MBChar(self, Encoding: int) -> CSG_Buffer: ...
    @overload
    def to_MBChar(self, pString: object, Encoding: int) -> int: ...
    @overload
    def to_ASCII(self, Replace: str = "_") -> CSG_Buffer: ...
    @overload
    def to_ASCII(self, pString: object, Replace: str = "_") -> bool: ...
    def to_StdString(self) -> str: ...
    def to_StdWstring(self) -> str: ...

class CSG_Strings:
    thisown: bool
    @overload
    def __init__(self) -> CSG_Strings: ...
    @overload
    def __init__(self, Strings: CSG_Strings) -> CSG_Strings: ...
    @overload
    def __init__(self, nStrings: int, Strings: object) -> CSG_Strings: ...
    __swig_destroy__: callable
    def Create(self, Strings: CSG_Strings) -> bool: ...
    def Destroy(self) -> bool: ...
    def Set_Count(self, Count: int) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Size(self) -> int: ...
    @overload
    def Add(self, Strings: CSG_Strings) -> bool: ...
    @overload
    def Add(self, String: CSG_String) -> bool: ...
    def Ins(self, String: CSG_String, Index: int) -> bool: ...
    def Del(self, Index: int) -> bool: ...
    def Get_String(self, Index: int) -> CSG_String: ...
    @overload
    def __iadd__(self, Strings: CSG_Strings) -> CSG_Strings: ...
    @overload
    def __iadd__(self, String: CSG_String) -> CSG_Strings: ...
    def Sort(self, Ascending: bool = True) -> bool: ...
    def Clear(self) -> None: ...
    def Assign(self, Strings: CSG_Strings) -> bool: ...

SG_DEFAULT_DELIMITERS: set

SG_TOKEN_INVALID: int
SG_TOKEN_DEFAULT: int
SG_TOKEN_RET_EMPTY: int
SG_TOKEN_RET_EMPTY_ALL: int
SG_TOKEN_RET_DELIMS: int
SG_TOKEN_STRTOK: int

TSG_String_Tokenizer_Mode: TypeAlias = Literal[
    0,  # SG_TOKEN_INVALID
    1,  # SG_TOKEN_DEFAULT
    2,  # SG_TOKEN_RET_EMPTY
    3,  # SG_TOKEN_RET_EMPTY_ALL
    4,  # SG_TOKEN_RET_DELIMS
    5   # SG_TOKEN_STRTOK
]

class CSG_String_Tokenizer:
    thisown: bool
    @overload
    def __init__(self) -> CSG_String_Tokenizer: ...
    @overload
    def __init__(self, String: CSG_String, Delimiters: CSG_String = ' \t\r\n', Mode: TSG_String_Tokenizer_Mode = SG_TOKEN_DEFAULT) -> CSG_String_Tokenizer: ...
    __swig_destroy__: callable
    def Get_Tokens_Count(self) -> int: ...
    def Get_Last_Delimiter(self) -> str: ...
    def Get_Next_Token(self) -> CSG_String: ...
    def Get_Position(self) -> int: ...
    def Get_String(self) -> CSG_String: ...
    def Has_More_Tokens(self) -> bool: ...
    @overload
    def Set_String(self, String: CSG_String, Delimiters: CSG_String = ' \t\r\n', Mode: TSG_String_Tokenizer_Mode = SG_TOKEN_DEFAULT) -> None: ...
    def Set_String(self, *args) -> None: ...

def SG_String_Tokenize(String: CSG_String, Delimiters: CSG_String = ' \t\r\n', Mode: TSG_String_Tokenizer_Mode = SG_TOKEN_DEFAULT) -> CSG_Strings: ...
def SG_is_Character_Numeric(Character: int) -> bool: ...
def SG_Get_CurrentTimeStr(bWithDate: bool = True) -> CSG_String: ...
def SG_Degree_To_Double(String: CSG_String) -> float: ...
def SG_Double_To_Degree(Value: float) -> CSG_String: ...
def SG_Get_Significant_Decimals(Value: float, maxDecimals: int = 6) -> int: ...
def SG_Flip_Decimal_Separators(String: CSG_String) -> None: ...
@overload
def SG_Get_String(Value: float, Precision: int = -99) -> CSG_String: ...
@overload
def SG_Get_String(Value: int, Precision: int = 0) -> CSG_String: ...
def SG_HTML_Tag_Replacer(Text: CSG_String) -> CSG_String: ...

class CSG_Bytes:
    thisown: bool
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> bool: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    def Clear(self) -> bool: ...
    def Rewind(self) -> None: ...
    def is_EOF(self) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Bytes(self, *args) -> CSG_Bytes: ...
    def __add__(self, i) -> CSG_Bytes: ...
    def Get_Byte(self, i) -> int: ...
    def Assign(self, Bytes) -> bool: ...
    def Add(self, *args) -> bool: ...
    def __iadd__(self, *args) -> CSG_Bytes: ...
    def asByte(self, i) -> int: ...
    def asChar(self, i) -> int: ...
    def asShort(self, i, bSwapBytes: bool = False) -> int: ...
    def asWord(self, i, bSwapBytes: bool = False) -> int: ...
    def asInt(self, i, bSwapBytes: bool = False) -> int: ...
    def asDWord(self, i, bSwapBytes: bool = False) -> int: ...
    def asFloat(self, i, bSwapBytes: bool = False) -> float: ...
    def asDouble(self, i, bSwapBytes: bool = False) -> float: ...
    def Read_Byte(self) -> int: ...
    def Read_Char(self) -> int: ...
    def Read_Short(self, bSwapBytes: bool = False) -> int: ...
    def Read_Word(self, bSwapBytes: bool = False) -> int: ...
    def Read_Int(self, bSwapBytes: bool = False) -> int: ...
    def Read_DWord(self, bSwapBytes: bool = False) -> int: ...
    def Read_Float(self, bSwapBytes: bool = False) -> float: ...
    def Read_Double(self, bSwapBytes: bool = False) -> float: ...
    def toHexString(self) -> CSG_String: ...
    def fromHexString(self, HexString) -> bool: ...

class CSG_Bytes_Array:
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Bytes(self, i) -> CSG_Bytes: ...
    def Add(self) -> CSG_Bytes: ...

class CSG_Stack:
    thisown: bool
    def __init__(self, RecordSize) -> None: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    def Get_RecordSize(self) -> int: ...
    def Get_Size(self) -> int: ...
    def Clear(self, bFreeMemory: bool = False) -> bool: ...

SG_DATATYPE_Bit: int
SG_DATATYPE_Byte: int
SG_DATATYPE_Char: int
SG_DATATYPE_Word: int
SG_DATATYPE_Short: int
SG_DATATYPE_DWord: int
SG_DATATYPE_Int: int
SG_DATATYPE_ULong: int
SG_DATATYPE_Long: int
SG_DATATYPE_Float: int
SG_DATATYPE_Double: int
SG_DATATYPE_String: int
SG_DATATYPE_Date: int
SG_DATATYPE_Color: int
SG_DATATYPE_Binary: int
SG_DATATYPE_Undefined: int

TSG_Data_Type: TypeAlias = Literal[
    0,  # SG_DATATYPE_Bit
    1,  # SG_DATATYPE_Byte
    2,  # SG_DATATYPE_Char
    3,  # SG_DATATYPE_Word
    4,  # SG_DATATYPE_Short
    5,  # SG_DATATYPE_DWord
    6,  # SG_DATATYPE_Int
    7,  # SG_DATATYPE_ULong
    8,  # SG_DATATYPE_Long
    9,  # SG_DATATYPE_Float
    10, # SG_DATATYPE_Double
    11, # SG_DATATYPE_String
    12, # SG_DATATYPE_Date
    13, # SG_DATATYPE_Color
    14, # SG_DATATYPE_Binary
    15  # SG_DATATYPE_Undefined
]

SG_DATATYPES_Undefined: int
SG_DATATYPES_Bit: int
SG_DATATYPES_Byte: int
SG_DATATYPES_Char: int
SG_DATATYPES_Word: int
SG_DATATYPES_Short: int
SG_DATATYPES_DWord: int
SG_DATATYPES_Int: int
SG_DATATYPES_ULong: int
SG_DATATYPES_Long: int
SG_DATATYPES_Float: int
SG_DATATYPES_Double: int
SG_DATATYPES_String: int
SG_DATATYPES_Date: int
SG_DATATYPES_Color: int
SG_DATATYPES_Binary: int
SG_DATATYPES_Standard: int
SG_DATATYPES_SInteger: int
SG_DATATYPES_UInteger: int
SG_DATATYPES_Integer: int
SG_DATATYPES_Real: int
SG_DATATYPES_Numeric: int
SG_DATATYPES_Table: int


def SG_Data_Type_Get_Size(Type: TSG_Data_Type) -> int: ...
def SG_Data_Type_Get_Name(Type: TSG_Data_Type, bShort: bool = False) -> CSG_String: ...
def SG_Data_Type_Get_Identifier(Type: TSG_Data_Type) -> CSG_String: ...
def SG_Data_Type_Get_Type(Identifier: CSG_String) -> TSG_Data_Type: ...
def SG_Data_Type_Get_Flag(Type: TSG_Data_Type) -> int: ...
def SG_Data_Type_is_Numeric(Type: TSG_Data_Type) -> bool: ...
def SG_Data_Type_Range_Check(Type: TSG_Data_Type, Value: float) -> bool: ...

SG_FILE_TYPE_NORMAL: int
SG_FILE_TYPE_ZIP: int
SG_FILE_TYPE_TAR: int

TSG_File_Type: TypeAlias = Literal[
    0,  # SG_FILE_TYPE_NORMAL
    1,  # SG_FILE_TYPE_ZIP
    2   # SG_FILE_TYPE_TAR
]

SG_FILE_R: int
SG_FILE_W: int
SG_FILE_RW: int

ESG_File_Flags_Open: TypeAlias = Literal[
    0,  # SG_FILE_R
    1,  # SG_FILE_W
    2   # SG_FILE_RW
]

SG_FILE_START: int
SG_FILE_CURRENT: int
SG_FILE_END: int

ESG_File_Flags_Seek: TypeAlias = Literal[
    0,  # SG_FILE_START
    1,  # SG_FILE_CURRENT
    2   # SG_FILE_END
]

class CSG_File:
    thisown: bool
    __swig_destroy__: callable
    def __init__(self, *args) -> None: ...
    def Open(self, FileName, Mode=..., bBinary: bool = True, Encoding=...) -> bool: ...
    def Close(self) -> bool: ...
    def Get_File_Name(self, *args) -> CSG_String: ...
    def Get_File_Type(self) -> TSG_File_Type: ...
    def Get_Stream(self) -> Any: ...
    def Set_Encoding(self, Encoding) -> bool: ...
    def Get_Encoding(self) -> int: ...
    def is_Open(self) -> bool: ...
    def is_Reading(self) -> bool: ...
    def is_Writing(self) -> bool: ...
    def is_EOF(self) -> bool: ...
    def Length(self) -> int: ...
    def Seek(self, Offset, Origin=...) -> bool: ...
    def Seek_Start(self) -> bool: ...
    def Seek_End(self) -> bool: ...
    def Tell(self) -> int: ...
    def Flush(self) -> bool: ...
    def Printf(self, *args) -> int: ...
    def Read(self, *args) -> int: ...
    def Write(self, *args) -> int: ...
    def Read_Line(self, Line) -> bool: ...
    def Read_Char(self) -> int: ...
    def Read_Int(self, bBigEndian: bool = False) -> int: ...
    def Write_Int(self, Value, bBigEndian: bool = False) -> bool: ...
    def Read_Double(self, bBigEndian: bool = False) -> float: ...
    def Write_Double(self, Value, bBigEndian: bool = False) -> bool: ...
    def Scan(self, *args) -> bool: ...
    def Scan_Int(self) -> int: ...
    def Scan_Double(self) -> float: ...
    def Scan_String(self, Separator) -> CSG_String: ...

gSG_Data_Type_Identifier: str

class CSG_Archive(CSG_File):
    thisown: bool
    __swig_destroy__: callable
    def __init__(self, *args) -> None: ...
    def Open(self, *args) -> bool: ...
    def Close(self) -> bool: ...
    def Get_Archive(self) -> CSG_String: ...
    def Get_File_Type(self) -> TSG_File_Type: ...
    def is_Zip(self) -> bool: ...
    def is_Tar(self) -> bool: ...
    def Add_Directory(self, Name) -> bool: ...
    def Add_File(self, Name, bBinary: bool = True) -> bool: ...
    def Get_File_Count(self) -> int: ...
    def Get_File(self, *args) -> bool: ...
    def Get_File_Name(self, Index) -> CSG_String: ...
    def is_Directory(self, Index) -> bool: ...
    def Extract_All(self, toDirectory=None) -> bool: ...
    def Extract(self, File, toFile=None) -> bool: ...

class CSG_ZLib:
    thisown: bool
    def __init__(self) -> None: ...
    @staticmethod
    def is_GZip_Supported() -> bool: ...
    @staticmethod
    def Compress(*args) -> CSG_String: ...
    @staticmethod
    def Uncompress(*args) -> CSG_String: ...
    __swig_destroy__: callable

def SG_Dir_Exists(Directory: CSG_String) -> bool: ...
def SG_Dir_Create(Directory: CSG_String, bFullPath: bool = False) -> bool: ...
def SG_Dir_Delete(Directory: CSG_String, bRecursive: bool = False) -> bool: ...
def SG_Dir_Get_Current() -> CSG_String: ...
def SG_Dir_Get_Temp() -> CSG_String: ...
def SG_Dir_List_Subdirectories(List: CSG_Strings, Directory: CSG_String, bRecursive: bool = False) -> bool: ...
def SG_Dir_List_Files(List: CSG_Strings, Directory: CSG_String, Extension: CSG_String = '', bRecursive: bool = False) -> bool: ...
def SG_File_Exists(FileName: CSG_String) -> bool: ...
def SG_File_Delete(FileName: CSG_String) -> bool: ...
@overload
def SG_File_Get_Name_Temp(Prefix: CSG_String) -> CSG_String: ...
@overload
def SG_File_Get_Name_Temp(Prefix: CSG_String, Directory: CSG_String) -> CSG_String: ...
def SG_File_Get_Name(full_Path: CSG_String, bExtension: bool) -> CSG_String: ...
def SG_File_Get_Path(full_Path: CSG_String) -> CSG_String: ...
def SG_File_Get_Path_Absolute(full_Path: CSG_String) -> CSG_String: ...
def SG_File_Get_Path_Relative(Directory: CSG_String, full_Path: CSG_String) -> CSG_String: ...
@overload
def SG_File_Make_Path(Directory: CSG_String, Name: CSG_String) -> CSG_String: ...
@overload
def SG_File_Make_Path(Directory: CSG_String, Name: CSG_String, Extension: CSG_String) -> CSG_String: ...
def SG_File_Cmp_Path(Path1: CSG_String, Path2: CSG_String) -> bool: ...
def SG_File_Cmp_Extension(File: CSG_String, Extension: CSG_String) -> bool: ...
def SG_File_Get_Extension(File: CSG_String) -> CSG_String: ...
def SG_File_Set_Extension(File: CSG_String, Extension: CSG_String) -> bool: ...
def SG_Get_Environment(Variable: CSG_String, Value: CSG_String = None) -> bool: ...
def SG_Set_Environment(Variable: CSG_String, Value: CSG_String) -> bool: ...

SG_COLOR_NONE: int = -1
SG_COLOR_RANDOM: int = -2

SG_COLORS_DEFAULT: int
SG_COLORS_DEFAULT_BRIGHT: int
SG_COLORS_RAINBOW: int
SG_COLORS_RAINBOW_2: int
SG_COLORS_BLACK_WHITE: int
SG_COLORS_BLACK_RED: int
SG_COLORS_BLACK_GREEN: int
SG_COLORS_BLACK_BLUE: int
SG_COLORS_WHITE_RED: int
SG_COLORS_WHITE_GREEN: int
SG_COLORS_WHITE_BLUE: int
SG_COLORS_CYAN_WHITE: int
SG_COLORS_MAGENTA_WHITE: int
SG_COLORS_YELLOW_WHITE: int
SG_COLORS_YELLOW_RED: int
SG_COLORS_YELLOW_GREEN: int
SG_COLORS_YELLOW_BLUE: int
SG_COLORS_BLUE_RED: int
SG_COLORS_GREEN_RED: int
SG_COLORS_GREEN_BLUE: int
SG_COLORS_BLUE_WHITE_RED: int
SG_COLORS_GREEN_WHITE_RED: int
SG_COLORS_GREEN_WHITE_BLUE: int
SG_COLORS_BLUE_GREY_RED: int
SG_COLORS_RED_GREY_BLUE: int
SG_COLORS_GREEN_GREY_RED: int
SG_COLORS_RED_GREY_GREEN: int
SG_COLORS_GREEN_GREY_BLUE: int
SG_COLORS_BLUE_YELLOW_RED: int
SG_COLORS_GREEN_YELLOW_RED: int
SG_COLORS_RED_YELLOW_GREEN: int
SG_COLORS_GREEN_YELLOW_BLUE: int
SG_COLORS_RED_GREEN_BLUE: int
SG_COLORS_RED_BLUE_GREEN: int
SG_COLORS_GREEN_RED_BLUE: int
SG_COLORS_NEON: int
SG_COLORS_TOPOGRAPHY: int
SG_COLORS_TOPOGRAPHY_2: int
SG_COLORS_TOPOGRAPHY_3: int
SG_COLORS_TOPOGRAPHY_4: int
SG_COLORS_ASPECT_1: int
SG_COLORS_ASPECT_2: int
SG_COLORS_ASPECT_3: int
SG_COLORS_THERMAL_1: int
SG_COLORS_THERMAL_2: int
SG_COLORS_PRECIPITATION_1: int
SG_COLORS_PRECIPITATION_2: int
SG_COLORS_PRECIPITATION_3: int
SG_COLORS_PRECIPITATION_4: int
SG_COLORS_PRECIPITATION_5: int
SG_COLORS_VEGETATION: int
SG_COLORS_SPECTRUM_1: int
SG_COLORS_SPECTRUM_2: int
SG_COLORS_SPECTRUM_3: int
SG_COLORS_COUNT: int

ESG_Colors: TypeAlias = Literal[
    0,  1,  2,  3,
    4,  5,  6,  7,
    8,  9,  10, 11,
    12, 13, 14, 15,
    16, 17, 18, 19,
    20, 21, 22, 23,
    24, 25, 26, 27,
    28, 29, 30, 31,
    32, 33, 34, 35,
    36, 37, 38, 39,
    40, 41, 42, 43,
    44, 45, 46, 47,
    48, 49, 50, 51,
    52, 53, 54, 55,
    56, 57, 58
]

def SG_Colors_Get_Name(Index: int) -> CSG_String: ...
def SG_Color_Get_Random() -> int: ...
def SG_Color_From_RGB(Red: int, Green: int, Blue: int, Alpha: int = 0) -> int: ...
def SG_Color_From_Text(Text: CSG_String, Color: int) -> bool: ...
def SG_Color_To_Text(Color: int, bHexadecimal: bool = True) -> CSG_String: ...

class CSG_Colors:
    thisown: bool
    @overload
    def __init__(self) -> CSG_Colors: ...
    @overload
    def __init__(self, Colors: CSG_Colors) -> CSG_Colors: ...
    @overload
    def __init__(self, nColors: int, Palette: int = SG_COLORS_DEFAULT, bRevert: bool = False) -> CSG_Colors: ...
    @overload
    def __init__(self, Palette: CSG_String, nColors: int = 0, bRevert: bool = False) -> CSG_Colors: ...
    @overload
    def Create(self) -> bool: ...
    @overload
    def Create(self, Colors: CSG_Colors) -> bool: ...
    @overload
    def Create(self, nColors: int, Palette: int = SG_COLORS_DEFAULT, bRevert: bool = False) -> bool: ...
    @overload
    def Create(self, Palette: CSG_String, nColors: int = SG_COLORS_DEFAULT, bRevert: bool = False) -> bool: ...
    __swig_destroy__: callable
    def Destroy(self) -> None: ...
    def Set_Count(self, nColors: int) -> bool: ...
    def Get_Count(self) -> int: ...
    @overload
    def Set_Color(self, Index: int, Color: int) -> bool: ...
    @overload
    def Set_Color(self, Index: int, Red: int, Green: int, Blue: int) -> bool: ...
    def Set_Red(self, Index: int, Value: int) -> bool: ...
    def Set_Green(self, Index: int, Value: int) -> bool: ...
    def Set_Blue(self, Index: int, Value: int) -> bool: ...
    def Set_Brightness(self, Index: int, Value: int) -> bool: ...
    def Get_Color(self, Index: int) -> int: ...
    def Get_Red(self, Index: int) -> int: ...
    def Get_Green(self, Index: int) -> int: ...
    def Get_Blue(self, Index: int) -> int: ...
    def Get_Brightness(self, Index: int) -> int: ...
    def Get_Interpolated(self, Index: int) -> int: ...
    @staticmethod
    def Get_Predefined_Count() -> int: ...
    @staticmethod
    def Get_Predefined_Name(Index: int, bWithIndex: bool = True) -> CSG_String: ...
    @overload
    def Set_Predefined(self, Index: int, bRevert: bool = False, nColors: int = 0) -> bool: ...
    @overload
    def Set_Predefined(self, Name: CSG_String, bRevert: bool = False, nColors: int = 0) -> bool: ...
    @overload
    def Set_Palette(self, Index: int, bRevert: bool = False, nColors: int = 0) -> bool: ...
    @overload
    def Set_Palette(self, Name: CSG_String, bRevert: bool = False, nColors: int = 0) -> bool: ...
    def Set_Default(self, nColors: int = 11) -> bool: ...
    @overload
    def Set_Ramp(self, Color_A: int, Color_B: int) -> bool: ...
    @overload
    def Set_Ramp(self, Color_A: int, Color_B: int, iColor_A: int, iColor_B: int) -> bool: ...
    @overload
    def Set_Ramp_Brighness(self, Brightness_A: int, Brightness_B: int) -> bool: ...
    @overload
    def Set_Ramp_Brighness(self, Brightness_A: int, Brightness_B: int, iColor_A: int, iColor_B: int) -> bool: ...
    def Random(self) -> bool: ...
    def Invert(self) -> bool: ...
    def Revert(self) -> bool: ...
    def Greyscale(self) -> bool: ...
    @overload
    def Assign(self, Colors: CSG_Colors) -> bool: ...
    @overload
    def Assign(self, pSource: CSG_Colors) -> bool: ...
    def Load(self, File_Name: CSG_String) -> bool: ...
    def Save(self, File_Name: CSG_String, bBinary: bool) -> bool: ...
    def Serialize(self, Stream: CSG_File, bSave: bool, bBinary: bool) -> bool: ...
    def to_Text(self, String: CSG_String) -> bool: ...
    def from_Text(self, String: CSG_String) -> bool: ...

class CSG_Translator:
    thisown: bool
    __swig_destroy__: callable
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> bool: ...
    def Destroy(self) -> None: ...
    def is_CaseSensitive(self) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Text(self, i) -> str: ...
    def Get_Translation(self, *args) -> str: ...

def SG_Get_Translator() -> CSG_Translator: ...
def SG_Translate(Text) -> str: ...

SG_UI_MSG_STYLE_NORMAL: int
SG_UI_MSG_STYLE_BOLD: int
SG_UI_MSG_STYLE_ITALIC: int
SG_UI_MSG_STYLE_SUCCESS: int
SG_UI_MSG_STYLE_FAILURE: int
SG_UI_MSG_STYLE_BIG: int
SG_UI_MSG_STYLE_SMALL: int
SG_UI_MSG_STYLE_01: int
SG_UI_MSG_STYLE_02: int
SG_UI_MSG_STYLE_03: int

TSG_UI_MSG_STYLE: TypeAlias = Literal[
    0,  # SG_UI_MSG_STYLE_NORMAL
    1,  # SG_UI_MSG_STYLE_BOLD
    2,  # SG_UI_MSG_STYLE_ITALIC
    3,  # SG_UI_MSG_STYLE_SUCCESS
    4,  # SG_UI_MSG_STYLE_FAILURE
    5,  # SG_UI_MSG_STYLE_BIG
    6,  # SG_UI_MSG_STYLE_SMALL
    7,  # SG_UI_MSG_STYLE_01
    8,  # SG_UI_MSG_STYLE_02
    9   # SG_UI_MSG_STYLE_03
]

SG_UI_DATAOBJECT_UPDATE: int
SG_UI_DATAOBJECT_SHOW_MAP: int
SG_UI_DATAOBJECT_SHOW_MAP_ACTIVE: int
SG_UI_DATAOBJECT_SHOW_MAP_NEW: int
SG_UI_DATAOBJECT_SHOW_MAP_LAST: int

TSG_UI_DataObject_Update: TypeAlias = Literal[
    0,  # SG_UI_DATAOBJECT_UPDATE
    1,  # SG_UI_DATAOBJECT_SHOW_MAP
    2,  # SG_UI_DATAOBJECT_SHOW_MAP_ACTIVE
    3,  # SG_UI_DATAOBJECT_SHOW_MAP_NEW
    4   # SG_UI_DATAOBJECT_SHOW_MAP_LAST
]

SG_UI_MAP_ACTIVE: int
SG_UI_MAP_LAST: int
SG_UI_MAP_ALL: int

TSG_UI_Maps: TypeAlias = Literal[
    0,  # SG_UI_MAP_ACTIVE
    1,  # SG_UI_MAP_LAST
    2   # SG_UI_MAP_ALL
]

SG_UI_WINDOW_ARRANGE_MDI_CASCADE: int
SG_UI_WINDOW_ARRANGE_MDI_TILE_VER: int
SG_UI_WINDOW_ARRANGE_MDI_TILE_HOR: int
SG_UI_WINDOW_ARRANGE_TDI_TILE_VER: int
SG_UI_WINDOW_ARRANGE_TDI_TILE_HOR: int
SG_UI_WINDOW_ARRANGE_TDI_SPLIT_LEFT: int
SG_UI_WINDOW_ARRANGE_TDI_SPLIT_RIGHT: int
SG_UI_WINDOW_ARRANGE_TDI_SPLIT_TOP: int
SG_UI_WINDOW_ARRANGE_TDI_SPLIT_BOTTOM: int

TSG_UI_Window_Arrange: TypeAlias = Literal[
    0x0001,  # SG_UI_WINDOW_ARRANGE_MDI_CASCADE
    0x0002,  # SG_UI_WINDOW_ARRANGE_MDI_TILE_VER
    0x0004,  # SG_UI_WINDOW_ARRANGE_MDI_TILE_HOR
    0x0008,  # SG_UI_WINDOW_ARRANGE_TDI_TILE_VER
    0x0010,  # SG_UI_WINDOW_ARRANGE_TDI_TILE_HOR
    0x0020,  # SG_UI_WINDOW_ARRANGE_TDI_SPLIT_LEFT
    0x0040,  # SG_UI_WINDOW_ARRANGE_TDI_SPLIT_RIGHT
    0x0080,  # SG_UI_WINDOW_ARRANGE_TDI_SPLIT_TOP
    0x0100   # SG_UI_WINDOW_ARRANGE_TDI_SPLIT_BOTTOM
]

CALLBACK_PROCESS_GET_OKAY: int
CALLBACK_PROCESS_SET_OKAY: int
CALLBACK_PROCESS_SET_BUSY: int
CALLBACK_PROCESS_SET_PROGRESS: int
CALLBACK_PROCESS_SET_READY: int
CALLBACK_PROCESS_SET_TEXT: int
CALLBACK_STOP_EXECUTION: int
CALLBACK_DLG_MESSAGE: int
CALLBACK_DLG_CONTINUE: int
CALLBACK_DLG_ERROR: int
CALLBACK_DLG_INFO: int
CALLBACK_DLG_PARAMETERS: int
CALLBACK_MESSAGE_ADD: int
CALLBACK_MESSAGE_ADD_ERROR: int
CALLBACK_MESSAGE_ADD_EXECUTION: int
CALLBACK_DATAOBJECT_ADD: int
CALLBACK_DATAOBJECT_DEL: int
CALLBACK_DATAOBJECT_UPDATE: int
CALLBACK_DATAOBJECT_SHOW: int
CALLBACK_DATAOBJECT_ASIMAGE: int
CALLBACK_DATAOBJECT_COLORS_GET: int
CALLBACK_DATAOBJECT_COLORS_SET: int
CALLBACK_DATAOBJECT_CLASSIFY: int
CALLBACK_DATAOBJECT_PARAMS_GET: int
CALLBACK_DATAOBJECT_PARAMS_SET: int
CALLBACK_SET_MAP_EXTENT: int
CALLBACK_DIAGRAM_SHOW: int
CALLBACK_DATABASE_UPDATE: int
CALLBACK_WINDOW_ARRANGE: int
CALLBACK_GET_APP_WINDOW: int
CALLBACK_GET_APP_PATH: int

TSG_UI_Callback_ID: TypeAlias = Literal[
    0,  # CALLBACK_PROCESS_GET_OKAY
    1,  # CALLBACK_PROCESS_SET_OKAY
    2,  # CALLBACK_PROCESS_SET_BUSY
    3,  # CALLBACK_PROCESS_SET_PROGRESS
    4,  # CALLBACK_PROCESS_SET_READY
    5,  # CALLBACK_PROCESS_SET_TEXT
    6,  # CALLBACK_STOP_EXECUTION
    7,  # CALLBACK_DLG_MESSAGE
    8,  # CALLBACK_DLG_CONTINUE
    9,  # CALLBACK_DLG_ERROR
    10, # CALLBACK_DLG_INFO
    11, # CALLBACK_DLG_PARAMETERS
    12, # CALLBACK_MESSAGE_ADD
    13, # CALLBACK_MESSAGE_ADD_ERROR
    14, # CALLBACK_MESSAGE_ADD_EXECUTION
    15, # CALLBACK_DATAOBJECT_ADD
    16, # CALLBACK_DATAOBJECT_DEL
    17, # CALLBACK_DATAOBJECT_UPDATE
    18, # CALLBACK_DATAOBJECT_SHOW
    19, # CALLBACK_DATAOBJECT_ASIMAGE
    20, # CALLBACK_DATAOBJECT_COLORS_GET
    21, # CALLBACK_DATAOBJECT_COLORS_SET
    22, # CALLBACK_DATAOBJECT_CLASSIFY
    23, # CALLBACK_DATAOBJECT_PARAMS_GET
    24, # CALLBACK_DATAOBJECT_PARAMS_SET
    25, # CALLBACK_SET_MAP_EXTENT
    26, # CALLBACK_DIAGRAM_SHOW
    27, # CALLBACK_DATABASE_UPDATE
    28, # CALLBACK_WINDOW_ARRANGE
    29, # CALLBACK_GET_APP_WINDOW
    30, # CALLBACK_GET_APP_PATH
]

class CSG_UI_Parameter:
    thisown: bool
    def __init__(self, *args) -> None: ...
    Boolean: Incomplete
    Number: Incomplete
    Pointer: Incomplete
    String: Incomplete
    __swig_destroy__: callable

def SG_Set_UI_Callback(Function: Any) -> bool: ...
def SG_Get_UI_Callback() -> Any: ...
def SG_UI_Console_Set_UTF8(bOn: bool) -> None: ...
def SG_UI_Console_Get_UTF8() -> bool: ...
@overload
def SG_UI_Console_Print_StdOut(Text: Union[CSG_String, str], End: str = '\n', bFlush: bool = True) -> None: ...
@overload
def SG_UI_Console_Print_StdErr(Text: Union[CSG_String, str], End: str = '\n', bFlush: bool = True) -> None: ...
def SG_UI_Progress_Lock(bOn: bool) -> int: ...
def SG_UI_Progress_is_Locked() -> bool: ...
def SG_UI_Progress_Reset() -> int: ...
def SG_UI_Process_Get_Okay(bBlink: bool = False) -> bool: ...
def SG_UI_Process_Set_Okay(bOkay: bool = True) -> bool: ...
def SG_UI_Process_Set_Busy(bOn: bool = True, Message: CSG_String = '') -> bool: ...
@overload
def SG_UI_Process_Set_Progress(Position: int, Range: int) -> bool: ...
@overload
def SG_UI_Process_Set_Progress(Position: float, Range: float) -> bool: ...
def SG_UI_Process_Set_Ready() -> bool: ...
def SG_UI_Process_Set_Text(Text: CSG_String) -> bool: ...
def SG_UI_Stop_Execution(bDialog: bool) -> bool: ...
def SG_UI_Dlg_Message(Message: CSG_String, Caption: CSG_String) -> None: ...
def SG_UI_Dlg_Continue(Message: CSG_String, Caption: CSG_String) -> bool: ...
def SG_UI_Dlg_Error(Message: CSG_String, Caption: CSG_String) -> int: ...
def SG_UI_Dlg_Info(Message: CSG_String, Caption: CSG_String) -> None: ...
def SG_UI_Dlg_Parameters(pParameters: CSG_Parameters, Caption: CSG_String) -> bool: ...
def SG_UI_Msg_Lock(bOn: bool) -> int: ...
def SG_UI_Msg_is_Locked() -> bool: ...
def SG_UI_Msg_Reset() -> int: ...
@overload
def SG_UI_Msg_Add(Message: Union[CSG_String, str], bNewLine: bool = True, Style: TSG_UI_MSG_STYLE = SG_UI_MSG_STYLE_NORMAL) -> None: ...
@overload
def SG_UI_Msg_Add_Execution(Message: Union[CSG_String, str], bNewLine: bool = True, Style: TSG_UI_MSG_STYLE = SG_UI_MSG_STYLE_NORMAL) -> None: ...
@overload
def SG_UI_Msg_Add_Error(Message: Union[CSG_String, str]) -> None: ...
def SG_UI_Msg_Flush() -> None: ...
def SG_UI_ProgressAndMsg_Lock(bOn: bool) -> None: ...
def SG_UI_ProgressAndMsg_Reset() -> None: ...
def SG_UI_DataObject_Add(pDataObject: CSG_Data_Object, Show: int) -> bool: ...
def SG_UI_DataObject_Del(pDataObject: CSG_Data_Object, bConfirm: bool) -> bool: ...
def SG_UI_DataObject_Update(pDataObject: CSG_Data_Object, Show: int, pParameters: CSG_Parameters) -> bool: ...
def SG_UI_DataObject_Show(pDataObject: CSG_Data_Object, Show: int) -> bool: ...
def SG_UI_DataObject_asImage(pDataObject: CSG_Data_Object, pGrid: CSG_Grid) -> bool: ...
def SG_UI_DataObject_Colors_Get(pDataObject: CSG_Data_Object, pColors: CSG_Colors) -> bool: ...
def SG_UI_DataObject_Colors_Set(pDataObject: CSG_Data_Object, pColors: CSG_Colors) -> bool: ...
def SG_UI_DataObject_Classify(pDataObject: CSG_Data_Object, Options: CSG_MetaData) -> bool: ...
def SG_UI_DataObject_Params_Get(pDataObject: CSG_Data_Object, pParameters: CSG_Parameters) -> bool: ...
def SG_UI_DataObject_Params_Set(pDataObject: CSG_Data_Object, pParameters: CSG_Parameters) -> bool: ...
def SG_UI_Set_Map_Extent(xMin: float, yMin: float, xMax: float, yMax: float, Maps: int = SG_UI_MAP_ACTIVE) -> bool: ...
def SG_UI_Diagram_Show(pTable: CSG_Table, pParameters: CSG_Parameters) -> bool: ...
def SG_UI_ODBC_Update(Server: CSG_String) -> bool: ...
def SG_UI_Window_Arrange(Arrange: int) -> int: ...
def SG_UI_Get_Window_Main(): ...
def SG_UI_Get_Application_Path(bPathOnly: bool = False) -> CSG_String: ...
def SG_UI_Get_Application_Name() -> CSG_String: ...
def SG_UI_Set_Application_Name(Name: CSG_String = '') -> CSG_String: ...
def SG_UI_Get_API_Path() -> CSG_String: ...
def SG_Initialize_Environment(bLibraries: bool = True, bProjections: bool = True, SAGA_Path: str = None, bInitializeWX: bool = True) -> bool: ...
def SG_Uninitialize_Environment() -> bool: ...

class CSG_MetaData:
    thisown: bool
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> bool: ...
    __swig_destroy__: callable
    def Destroy(self) -> None: ...
    def Load(self, *args) -> bool: ...
    def Save(self, *args) -> bool: ...
    def Load_HTTP(self, Server, Path, Username=None, Password=None) -> bool: ...
    def from_XML(self, *args) -> bool: ...
    def to_XML(self, XML) -> bool: ...
    def Load_JSON(self, File) -> bool: ...
    def Save_JSON(self, File) -> bool: ...
    def from_JSON(self, JSON) -> bool: ...
    def to_JSON(self, JSON) -> bool: ...
    def Assign(self, MetaData, bAddChildren: bool = True) -> bool: ...
    def __iadd__(self, MetaData) -> CSG_MetaData: ...
    def Set_Name(self, Name) ->None: ...
    def Cmp_Name(self, String, bNoCase: bool = True) -> bool: ...
    def Get_Name(self) -> CSG_String: ...
    def Get_Content(self, *args) -> str: ...
    def Set_Content(self, Content) -> None: ...
    def Fmt_Content(self, *args) -> None: ...
    def Cmp_Content(self, String, bNoCase: bool = False) -> bool: ...
    def Get_Parent(self) -> CSG_MetaData: ...
    def Get_Count(self) -> int: ...
    def Get_Children_Count(self) -> int: ...
    def Get_Child(self, *args) -> CSG_MetaData: ...
    def Add_Child(self, *args) -> CSG_MetaData: ...
    def Ins_Child(self, *args) -> CSG_MetaData: ...
    def Mov_Child(self, from_Index, to_Index) -> bool: ...
    def Del_Child(self, *args) -> bool: ...
    def Add_Children(self, MetaData) -> bool: ...
    def Del_Children(self, Depth: int = 0, Name=None) -> bool: ...
    def __call__(self, *args): ...
    def Get_Property_Count(self) -> int: ...
    def Get_Property_Name(self, Index) -> CSG_String: ...
    def Get_Property(self, *args) -> Any: ...
    def Add_Property(self, *args) -> bool: ...
    def Set_Property(self, *args) -> bool: ...
    def Cmp_Property(self, Name, String, bNoCase: bool = False) -> bool: ...
    def Del_Property(self, *args) -> bool: ...
    def asText(self, Flags: int = 0) -> CSG_String: ...
    def Get_Table(self, Flags: int = 0) -> CSG_Table: ...

class CSG_HTTP:
    thisown: bool
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> bool: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    def is_Connected(self) -> bool: ...
    def Request(self, *args) -> bool: ...

def SG_FTP_Download(Target_Directory, Source, Username=None, Password=None, Port: int = 21, bBinary: bool = True, bVerbose: bool = False) -> bool: ...


INTERSECTION_None: int
INTERSECTION_Identical: int
INTERSECTION_Overlaps: int
INTERSECTION_Contained: int
INTERSECTION_Contains: int

TSG_Intersection: TypeAlias = Literal[
    0,  # INTERSECTION_None
    1,  # INTERSECTION_Identical
    2,  # INTERSECTION_Overlaps
    3,  # INTERSECTION_Contained
    4   # INTERSECTION_Contains
]

TSG_Point_Type_SG_POINT_TYPE_2D: int
TSG_Point_Type_SG_POINT_TYPE_3D: int
TSG_Point_Type_SG_POINT_TYPE_4D: int
TSG_Point_Type_SG_POINT_TYPE_2D_Int: int

TSG_Point_Type: TypeAlias = Literal[
    0,  # TSG_Point_Type_SG_POINT_TYPE_2D
    1,  # TSG_Point_Type_SG_POINT_TYPE_3D
    2,  # TSG_Point_Type_SG_POINT_TYPE_4D
    3   # TSG_Point_Type_SG_POINT_TYPE_2D_Int
]

class TSG_Point:
    thisown: bool
    x: float
    y: float
    def __init__(self) -> TSG_Point: ...
    __swig_destroy__: callable

class CSG_Point(TSG_Point):
    thisown: bool
    @overload
    def __init__(self) -> CSG_Point: ...
    @overload
    def __init__(self, Point: CSG_Point) -> CSG_Point: ...    
    @overload
    def __init__(self, Point: TSG_Point) -> CSG_Point: ...
    @overload
    def __init__(self, x: float, y: float) -> CSG_Point: ...
    __swig_destroy__: callable
    def Get_Type(self) -> TSG_Point_Type: ...
    def __eq__(self, Point: CSG_Point) -> bool: ...
    def __ne__(self, Point: CSG_Point) -> bool: ...
    def __add__(self, Point: CSG_Point) -> CSG_Point: ...
    def __sub__(self, Point: CSG_Point) -> CSG_Point: ...
    def __iadd__(self, Point: CSG_Point) -> CSG_Point: ...
    def __isub__(self, Point: CSG_Point) -> CSG_Point: ...
    def __mul__(self, Value: float) -> CSG_Point: ...
    def __truediv__(self, Value: float) -> CSG_Point: ...
    __div__ = __truediv__
    def __imul__(self, Value: Union[CSG_Point, float]) -> CSG_Point: ...
    def __itruediv__(self, Value: float) -> CSG_Point: ...
    __idiv__ = __itruediv__
    @overload
    def Assign(self, x: float, y: float) -> None: ...
    @overload
    def Assign(self, Point: CSG_Point) -> None: ...
    def Add(self, Point: CSG_Point) -> None: ...
    def Subtract(self, Point: CSG_Point) -> None: ...
    @overload
    def Multiply(self, Point: CSG_Point) -> None: ...
    @overload
    def Multiply(self, Value: float) -> None: ...
    def Divide(self, Value: float) -> None: ...
    def Get_Length(self) -> float: ...
    def Get_Distance(self, Point: CSG_Point) -> float: ...
    @overload
    def is_Equal(self, Point: CSG_Point, epsilon: float = 0.0) -> bool: ...
    @overload
    def is_Equal(self, x: float, y: float, epsilon: float = 0.0) -> bool: ...

class CSG_Points:
    thisown: bool
    @overload
    def __init__(self) -> CSG_Points: ...
    @overload
    def __init__(self, Points: CSG_Points) -> CSG_Points: ...
    @overload
    def __init__(self, nPoints: int, Growth: TSG_Array_Growth = TSG_Array_Growth.SG_ARRAY_GROWTH_1) -> CSG_Points: ...
    def Clear(self) -> bool: ...
    def Assign(self, Points: CSG_Points) -> bool: ...
    @overload
    def Add(self, x: float, y: float) -> bool: ...
    @overload
    def Add(self, Point: TSG_Point) -> bool: ...
    def Del(self, Index: int) -> bool: ...
    def Set_Count(self, nPoints: int) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Points(self) -> TSG_Point: ...
    __swig_destroy__: callable

class CSG_Lines:
    thisown: bool
    __swig_destroy__: callable
    @overload
    def __init__(self) -> CSG_Lines: ...
    @overload
    def Create(self, nLines: int) -> CSG_Lines: ...
    @overload
    def Create(self, Lines: CSG_Lines) -> CSG_Lines: ...
    @overload
    def Create(self, nLines: int) -> bool: ...
    @overload
    def Create(self, Lines: CSG_Lines) -> bool: ...
    def Destroy(self) -> bool: ...
    def Clear(self) -> bool: ...
    def Assign(self, Lines: CSG_Lines) -> bool: ...
    @overload
    def Add(self) -> CSG_Points: ...
    @overload
    def Add(self, Line: CSG_Points) -> bool: ...
    @overload
    def Add(self, Lines: CSG_Lines) -> bool: ...
    def Del(self, Index: int) -> bool: ...
    def Set_Count(self, nLines) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Line(self, Index: int) -> CSG_Points: ...
    @overload
    def Get_Length(self) -> float: ...
    @overload
    def Get_Length(self, Index: int) -> float: ...

class TSG_Point_3D:
    thisown: bool
    x: float
    y: float
    z: float
    def __init__(self) -> TSG_Point_3D: ...
    __swig_destroy__: callable

class CSG_Point_3D(TSG_Point_3D):
    thisown: bool
    @overload
    def __init__(self) -> CSG_Point_3D: ...
    @overload
    def __init__(self, Point: CSG_Point_3D) -> CSG_Point_3D: ...    
    @overload
    def __init__(self, Point: TSG_Point_3D) -> CSG_Point_3D: ...
    @overload
    def __init__(self, x: float, y: float, z: float) -> CSG_Point_3D: ...
    __swig_destroy__: callable
    def Get_Type(self) -> TSG_Point_Type: ...
    def __eq__(self, Point: CSG_Point_3D) -> bool: ...
    def __ne__(self, Point: CSG_Point_3D) -> bool: ...
    def __add__(self, Point: CSG_Point_3D) -> CSG_Point_3D: ...
    def __sub__(self, Point: CSG_Point_3D) -> CSG_Point_3D: ...
    def __iadd__(self, Point: CSG_Point_3D) -> CSG_Point_3D: ...
    def __isub__(self, Point: CSG_Point_3D) -> CSG_Point_3D: ...
    def __mul__(self, Value: float) -> CSG_Point_3D: ...
    def __truediv__(self, Value: float) -> CSG_Point_3D: ...
    __div__ = __truediv__
    def __imul__(self, Value: Union[CSG_Point_3D, float]) -> CSG_Point_3D: ...
    def __itruediv__(self, Value: float) -> CSG_Point_3D: ...
    __idiv__ = __itruediv__
    @overload
    def Assign(self, x: float, y: float, z: float) -> None: ...
    @overload
    def Assign(self, Point: CSG_Point_3D) -> None: ...
    def Add(self, Point: CSG_Point_3D) -> None: ...
    def Subtract(self, Point: CSG_Point_3D) -> None: ...
    @overload
    def Multiply(self, Point: CSG_Point_3D) -> None: ...
    @overload
    def Multiply(self, Value: float) -> None: ...
    def Divide(self, Value: float) -> None: ...
    def Get_Length(self) -> float: ...
    def Get_Distance(self, Point: CSG_Point_3D) -> float: ...
    @overload
    def is_Equal(self, Point: CSG_Point_3D, epsilon: float = 0.0) -> bool: ...
    @overload
    def is_Equal(self, x: float, y: float, z: float, epsilon: float = 0.0) -> bool: ...

class CSG_Points_3D:
    thisown: bool
    def __init__(self) -> CSG_Points_3D: ...
    @overload
    def __init__(self, Points: CSG_Points_3D) -> CSG_Points_3D: ...
    @overload
    def __init__(self, nPoints: int, Growth: TSG_Array_Growth = TSG_Array_Growth.SG_ARRAY_GROWTH_1) -> CSG_Points_3D: ...
    def Clear(self) -> bool: ...
    def Assign(self, Points: CSG_Points_3D) -> bool: ...
    @overload
    def Add(self, x: float, y: float, z: float) -> bool: ...
    @overload
    def Add(self, Point: TSG_Point_3D) -> bool: ...
    def Del(self, Index: int) -> bool: ...
    def Set_Count(self, nPoints: int) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Points(self) -> TSG_Point_3D: ...
    __swig_destroy__: callable

class TSG_Point_4D:
    thisown: bool
    x: float
    y: float
    z: float
    m: float
    def __init__(self) -> None: ...
    __swig_destroy__: callable

class CSG_Point_4D(TSG_Point_4D):
    thisown: bool
    @overload
    def __init__(self) -> CSG_Point_4D: ...
    @overload
    def __init__(self, Point: CSG_Point_4D) -> CSG_Point_4D: ...    
    @overload
    def __init__(self, Point: TSG_Point_4D) -> CSG_Point_4D: ...
    @overload
    def __init__(self, x: float, y: float, z: float, m: float) -> CSG_Point_4D: ...
    __swig_destroy__: callable
    def Get_Type(self) -> TSG_Point_Type: ...
    def __eq__(self, Point: CSG_Point_4D) -> bool: ...
    def __ne__(self, Point: CSG_Point_4D) -> bool: ...
    def __add__(self, Point: CSG_Point_4D) -> CSG_Point_4D: ...
    def __sub__(self, Point: CSG_Point_4D) -> CSG_Point_4D: ...
    def __mul__(self, Value: float) -> CSG_Point_4D: ...
    def __truediv__(self, Value: float) -> CSG_Point_4D: ...
    __div__ = __truediv__
    def __itruediv__(self, Value: float) -> CSG_Point_4D: ...
    __idiv__ = __itruediv__
    def __iadd__(self, Point: CSG_Point_4D) -> CSG_Point_4D: ...
    def __isub__(self, Point: CSG_Point_4D) -> CSG_Point_4D: ...
    def __imul__(self, Value: Union[CSG_Point_4D, float]) -> CSG_Point_4D: ...
    @overload
    def Assign(self, x: float, y: float, z: float, m: float) -> None: ...
    @overload
    def Assign(self, Point: CSG_Point_4D) -> None: ...
    def Add(self, Point: CSG_Point_4D) -> None: ...
    def Subtract(self, Point: CSG_Point_4D) -> None: ...
    @overload
    def Multiply(self, Point: CSG_Point_4D) -> None: ...
    @overload
    def Multiply(self, Value: float) -> None: ...
    def Divide(self, Value: float) -> None: ...
    def Get_Length(self) -> float: ...
    def Get_Distance(self, Point: CSG_Point_4D) -> float: ...
    @overload
    def is_Equal(self, Point: CSG_Point_4D, epsilon: float = 0.0) -> bool: ...
    @overload
    def is_Equal(self, x: float, y: float, z: float, m: float, epsilon: float = 0.0) -> bool: ...

class TSG_Point_Int:
    thisown: bool
    x: int
    y: int
    def __init__(self) -> TSG_Point_Int: ...
    __swig_destroy__: callable

class CSG_Points_Int:
    thisown: bool
    @overload
    def __init__(self) -> CSG_Points_Int: ...
    @overload
    def __init__(self, Points: CSG_Points_Int) -> CSG_Points_Int: ...
    @overload
    def __init__(self, nPoints: int, Growth: TSG_Array_Growth = TSG_Array_Growth.SG_ARRAY_GROWTH_1) -> CSG_Points_Int: ...
    def Clear(self) -> bool: ...
    def Assign(self, Points: CSG_Points_Int) -> bool: ...
    @overload
    def Add(self, x: int, y: int) -> bool: ...
    @overload
    def Add(self, Point: TSG_Point_Int) -> bool: ...
    def Del(self, Index: int) -> bool: ...
    def Set_Count(self, nPoints: int) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Points(self) -> TSG_Point_Int: ...
    __swig_destroy__: callable

class TSG_Rect:
    thisown: bool
    xMin: float
    yMin: float
    xMax: float
    yMax: float
    def __init__(self) -> TSG_Rect: ...
    __swig_destroy__: callable

class CSG_Rect(TSG_Rect):
    thisown: bool
    @overload
    def __init__(self) -> CSG_Rect: ...
    @overload
    def __init__(self, Rect: CSG_Rect) -> CSG_Rect: ...
    @overload
    def __init__(self, Rect: TSG_Rect) -> CSG_Rect: ...
    @overload
    def __init__(self, A: CSG_Point, B: CSG_Point) -> CSG_Rect: ...
    @overload
    def __init__(self, xMin: float, yMin: float, xMax: float, yMax: float) -> CSG_Rect: ...
    __swig_destroy__: callable
    @overload
    def Create(self, Rect: CSG_Rect) -> bool: ...
    @overload
    def Create(self, A: CSG_Point, B: CSG_Point) -> bool: ...
    @overload
    def Create(self, xMin: float, yMin: float, xMax: float, yMax: float) -> bool: ...
    def __eq__(self, Rect: CSG_Rect) -> bool: ...
    def __ne__(self, Rect: CSG_Rect) -> bool: ...
    def __iadd__(self, Point: CSG_Point) -> CSG_Rect: ...
    def __isub__(self, Point: CSG_Point) -> CSG_Rect: ...
    @overload
    def Assign(self, xMin: float, yMin: float, xMax: float, yMax: float) -> CSG_Rect: ...
    @overload
    def Assign(self, A: CSG_Point, B: CSG_Point) -> CSG_Rect: ...
    @overload
    def Assign(self, Rect: CSG_Rect) -> CSG_Rect: ...
    @overload
    def Set_BottomLeft(self, x: float, y: float) -> CSG_Rect: ...
    @overload
    def Set_BottomLeft(self, Point: CSG_Point) -> CSG_Rect: ...
    @overload
    def Set_TopRight(self, x: float, y: float) -> CSG_Rect: ...
    @overload
    def Set_TopRight(self, Point: CSG_Point) -> CSG_Rect: ...
    def Get_XMin(self) -> float: ...
    def Get_XMax(self) -> float: ...
    def Get_YMin(self) -> float: ...
    def Get_YMax(self) -> float: ...
    def Get_XRange(self) -> float: ...
    def Get_YRange(self) -> float: ...
    def Get_Area(self) -> float: ...
    def Get_Diameter(self) -> float: ...
    def Get_TopLeft(self) -> CSG_Point: ...
    def Get_BottomRight(self) -> CSG_Point: ...
    def Get_Center(self) -> CSG_Point: ...
    def Get_XCenter(self) -> float: ...
    def Get_YCenter(self) -> float: ...
    @overload
    def Move(self, dx: float, dy: float) -> CSG_Rect: ...
    @overload
    def Move(self, Point: CSG_Point) -> CSG_Rect: ...
    @overload
    def Inflate(self, d: float, bPercent: bool = True) -> CSG_Rect: ...
    @overload
    def Inflate(self, dx: float, dy: float, bPercent: bool = True) -> CSG_Rect: ...
    @overload
    def Deflate(self, d: float, bPercent: bool = True) -> CSG_Rect: ...
    @overload
    def Deflate(self, dx: float, dy: float, bPercent: bool = True) -> CSG_Rect: ...
    @overload
    def Union(self, x: float, y: float) -> CSG_Rect: ...
    @overload
    def Union(self, Point: CSG_Point) -> CSG_Rect: ...
    @overload
    def Union(self, Rect: CSG_Rect) -> CSG_Rect: ...
    def Intersect(self, Rect: CSG_Rect) -> bool: ...
    @overload
    def is_Equal(self, xMin: float, yMin: float, xMax: float, yMax: float, epsilon: float = 0.0) -> bool: ...
    @overload
    def is_Equal(self, Rect: CSG_Rect, epsilon: float = 0.0) -> bool: ...
    @overload
    def Contains(self, x: float, y: float) -> bool: ...
    @overload
    def Contains(self, Point: CSG_Point) -> bool: ...
    def Intersects(self, Rect: CSG_Rect) -> TSG_Intersection: ...

class CSG_Rects:
    thisown: bool
    @overload
    def __init__(self) -> CSG_Rects: ...
    @overload
    def __init__(self, Rects: CSG_Rects) -> CSG_Rects: ...
    __swig_destroy__: callable
    def Clear(self) -> None: ...
    def Assign(self, Rects: CSG_Rects) -> bool: ...
    @overload
    def Add(self) -> bool: ...
    @overload
    def Add(self, xMin: float, yMin: float, xMax: float, yMax: float) -> bool: ...
    @overload
    def Add(self, Rect: CSG_Rect) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Rect(self, Index: int) -> CSG_Rect: ...

class TSG_Rect_Int:
    thisown: bool
    xMin: int
    yMin: int
    xMax: int
    yMax: int
    def __init__(self) -> None: ...
    __swig_destroy__: callable

class CSG_Rect_Int(TSG_Rect_Int):
    thisown: bool
    @overload
    def __init__(self) -> CSG_Rect_Int: ...
    @overload
    def __init__(self, Rect: CSG_Rect_Int) -> CSG_Rect_Int: ...
    @overload
    def __init__(self, Rect: TSG_Rect_Int) -> CSG_Rect_Int: ...
    @overload
    def __init__(self, A: TSG_Point_Int, B: TSG_Point_Int) -> CSG_Rect_Int: ...
    @overload
    def __init__(self, xMin: int, yMin: int, xMax: int, yMax: int) -> CSG_Rect_Int: ...
    __swig_destroy__: callable
    @overload
    def Create(self, xMin: int, yMin: int, xMax: int, yMax: int) -> CSG_Rect_Int: ...
    @overload
    def Create(self, A: TSG_Point_Int, B: TSG_Point_Int) -> CSG_Rect_Int: ...
    @overload
    def Create(self, Rect: CSG_Rect_Int) -> CSG_Rect_Int: ...
    def __eq__(self, Rect: CSG_Rect_Int) -> bool: ...
    def __ne__(self, Rect: CSG_Rect_Int) -> bool: ...
    def __iadd__(self, Point: TSG_Point_Int) -> CSG_Rect_Int: ...
    def __isub__(self, Point: TSG_Point_Int) -> CSG_Rect_Int: ...
    @overload
    def Assign(self, xMin: int, yMin: int, xMax: int, yMax: int) -> CSG_Rect_Int: ...
    @overload
    def Assign(self, A: TSG_Point_Int, B: TSG_Point_Int) -> CSG_Rect_Int: ...
    @overload
    def Assign(self, Rect: CSG_Rect_Int) -> CSG_Rect_Int: ...
    @overload
    def Set_BottomLeft(self, x: int, y: int) -> CSG_Rect_Int: ...
    @overload
    def Set_BottomLeft(self, Point: TSG_Point_Int) -> CSG_Rect_Int: ...
    @overload
    def Set_TopRight(self, x: int, y: int) -> CSG_Rect_Int: ...
    @overload
    def Set_TopRight(self, Point: TSG_Point_Int) -> CSG_Rect_Int: ...
    def Get_XMin(self) -> int: ...
    def Get_XMax(self) -> int: ...
    def Get_YMin(self) -> int: ...
    def Get_YMax(self) -> int: ...
    def Get_XRange(self) -> int: ...
    def Get_YRange(self) -> int: ...
    def Get_Area(self) -> float: ...
    def Get_Diameter(self) -> float: ...
    def Get_TopLeft(self) -> TSG_Point_Int: ...
    def Get_BottomRight(self) -> TSG_Point_Int: ...
    @overload
    def Move(self, dx: int, dy: int) -> CSG_Rect_Int: ...
    @overload
    def Move(self, Point: TSG_Point_Int) -> CSG_Rect_Int: ...
    @overload
    def Inflate(self, d: int) -> CSG_Rect_Int: ...
    @overload
    def Inflate(self, dx: int, dy: int) -> CSG_Rect_Int: ...
    @overload
    def Deflate(self, d: int) -> CSG_Rect_Int: ...
    @overload
    def Deflate(self, dx: int, dy: int) -> CSG_Rect_Int: ...
    @overload
    def Union(self, x: int, y: int) -> CSG_Rect_Int: ...
    @overload
    def Union(self, Point: TSG_Point_Int) -> CSG_Rect_Int: ...
    @overload
    def Union(self, Rect: TSG_Rect_Int) -> CSG_Rect_Int: ...
    def Intersect(self, Rect: CSG_Rect_Int) -> bool: ...
    @overload
    def is_Equal(self, xMin: int, yMin: int, xMax: int, yMax: int) -> bool: ...
    @overload
    def is_Equal(self, Rect: TSG_Rect_Int) -> bool: ...
    @overload
    def Contains(self, x: float, y: float) -> bool: ...
    @overload
    def Contains(self, Point: TSG_Point_Int) -> bool: ...
    def Intersects(self, Rect: CSG_Rect_Int) -> TSG_Intersection: ...

class CSG_Rects_Int:
    thisown: bool
    def __init__(self) -> CSG_Rects_Int: ...
    __swig_destroy__: callable
    def Clear(self) -> bool: ...
    def Assign(self, Rects: CSG_Rects_Int) -> bool: ...
    @overload
    def Add(self) -> bool: ...
    @overload
    def Add(self, xMin: int, yMin: int, xMax: int, yMax: int) -> bool: ...
    @overload
    def Add(self, Rect: CSG_Rect_Int) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Rect(self, Index: int) -> CSG_Rect_Int: ...

SG_DISTWGHT_None: int
SG_DISTWGHT_IDW: int
SG_DISTWGHT_EXP: int
SG_DISTWGHT_GAUSS: int

TSG_Distance_Weighting: TypeAlias = Literal[
    0,  # SG_DISTWGHT_None
    1,  # SG_DISTWGHT_IDW
    2,  # SG_DISTWGHT_EXP
    3   # SG_DISTWGHT_GAUSS
]

class CSG_Distance_Weighting:
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    @staticmethod
    def Enable_Parameters(Parameters) -> bool: ...
    def Create_Parameters(self, *args) -> bool: ...
    @staticmethod
    def Add_Parameters(*args) -> bool: ...
    def Set_Parameters(self, Parameters) -> bool: ...
    def Get_Weighting(self) -> TSG_Distance_Weighting: ...
    def Set_Weighting(self, Weighting) -> bool: ...
    def Get_IDW_Power(self) -> float: ...
    def Set_IDW_Power(self, Value) -> bool: ...
    def Get_IDW_Offset(self) -> bool: ...
    def Set_IDW_Offset(self, bOn: bool = True) -> bool: ...
    def Get_BandWidth(self) -> float: ...
    def Set_BandWidth(self, Value) -> bool: ...
    def Get_Weight(self, Distance) -> float: ...

ESG_CRS_Format_WKT1: int
ESG_CRS_Format_WKT2: int
ESG_CRS_Format_PROJ: int
ESG_CRS_Format_JSON: int
ESG_CRS_Format_ESRI: int
ESG_CRS_Format_CODE: int
ESG_CRS_Format_Undefined: int
WKT: int  # alias for WKT1

ESG_CRS_Format: TypeAlias = Literal[
    0,  # ESG_CRS_Format_WKT1
    1,  # ESG_CRS_Format_WKT2
    2,  # ESG_CRS_Format_PROJ
    3,  # ESG_CRS_Format_JSON
    4,  # ESG_CRS_Format_ESRI
    5,  # ESG_CRS_Format_CODE
    6,  # ESG_CRS_Format_Undefined
]

ESG_CRS_Type_Geographic: int
ESG_CRS_Type_Geodetic: int
ESG_CRS_Type_Geocentric: int
ESG_CRS_Type_Projection: int
ESG_CRS_Type_Undefined: int

ESG_CRS_Type: TypeAlias = Literal[
    0,  # ESG_CRS_Type_Geographic
    1,  # ESG_CRS_Type_Geodetic
    2,  # ESG_CRS_Type_Geocentric
    3,  # ESG_CRS_Type_Projection
    4   # ESG_CRS_Type_Undefined
]

ESG_Projection_Unit_Kilometer: int
ESG_Projection_Unit_Meter: int
ESG_Projection_Unit_Decimeter: int
ESG_Projection_Unit_Centimeter: int
ESG_Projection_Unit_Millimeter: int
ESG_Projection_Unit_Int_Nautical_Mile: int
ESG_Projection_Unit_Int_Inch: int
ESG_Projection_Unit_Int_Foot: int
ESG_Projection_Unit_Int_Yard: int
ESG_Projection_Unit_Int_Statute_Mile: int
ESG_Projection_Unit_Int_Fathom: int
ESG_Projection_Unit_Int_Chain: int
ESG_Projection_Unit_Int_Link: int
ESG_Projection_Unit_US_Inch: int
ESG_Projection_Unit_US_Foot: int
ESG_Projection_Unit_US_Yard: int
ESG_Projection_Unit_US_Chain: int
ESG_Projection_Unit_US_Statute_Mile: int
ESG_Projection_Unit_Indian_Yard: int
ESG_Projection_Unit_Indian_Foot: int
ESG_Projection_Unit_Indian_Chain: int
ESG_Projection_Unit_Undefined: int
ESG_Projection_Unit_First: int  # alias for Kilometer

ESG_Projection_Unit: TypeAlias = Literal[
    0,   # ESG_Projection_Unit_Kilometer
    1,   # ESG_Projection_Unit_Meter
    2,   # ESG_Projection_Unit_Decimeter
    3,   # ESG_Projection_Unit_Centimeter
    4,   # ESG_Projection_Unit_Millimeter
    5,   # ESG_Projection_Unit_Int_Nautical_Mile
    6,   # ESG_Projection_Unit_Int_Inch
    7,   # ESG_Projection_Unit_Int_Foot
    8,   # ESG_Projection_Unit_Int_Yard
    9,   # ESG_Projection_Unit_Int_Statute_Mile
    10,  # ESG_Projection_Unit_Int_Fathom
    11,  # ESG_Projection_Unit_Int_Chain
    12,  # ESG_Projection_Unit_Int_Link
    13,  # ESG_Projection_Unit_US_Inch
    14,  # ESG_Projection_Unit_US_Foot
    15,  # ESG_Projection_Unit_US_Yard
    16,  # ESG_Projection_Unit_US_Chain
    17,  # ESG_Projection_Unit_US_Statute_Mile
    18,  # ESG_Projection_Unit_Indian_Yard
    19,  # ESG_Projection_Unit_Indian_Foot
    20,  # ESG_Projection_Unit_Indian_Chain
    21,  # ESG_Projection_Unit_Undefined
]

class CSG_Projection:
    thisown: bool
    __swig_destroy__: callable
    def Destroy(self) -> None: ...
    @overload
    def __init__(self) -> CSG_Projection: ...
    @overload
    def __init__(self, Projection: CSG_Projection) -> CSG_Projection: ...
    @overload
    def __init__(self, Definition: Union[str, CSG_String]) -> CSG_Projection: ...
    @overload
    def __init__(self, Code: int, Authority: Optional[str] = None) -> CSG_Projection: ...
    @overload
    def __init__(self, WKT2: CSG_String, PROJ: CSG_String) -> CSG_Projection: ...
    @overload
    def Create(self) -> bool: ...
    @overload
    def Create(self, Projection: CSG_Projection) -> bool: ...
    @overload
    def Create(self, Definition: Union[str, CSG_String]) -> bool: ...
    @overload
    def Create(self, Code: int, Authority: Optional[str] = None) -> bool: ...
    @overload
    def Create(self, WKT2: CSG_String, PROJ: CSG_String) -> bool: ...
    @overload
    def Assign(self, Projection: CSG_Projection) -> bool: ...
    @overload
    def Assign(self, Definition: CSG_String) -> bool: ...
    @overload
    def Assign(self, Code: int, Authority: Optional[str] = None) -> bool: ...
    def is_Okay(self) -> bool: ...
    def is_Equal(self, Projection: CSG_Projection) -> bool: ...
    def __eq__(self, Projection: CSG_Projection) -> bool: ...
    def __ne__(self, Projection: CSG_Projection) -> bool: ...
    @staticmethod
    def Get_GCS_WGS84() -> CSG_Projection: ...
    def Set_GCS_WGS84(self) -> bool: ...
    @staticmethod
    def Get_UTM_WGS84(Zone: int, bSouth: bool = False) -> CSG_Projection: ...
    def Set_UTM_WGS84(self, Zone: int, bSouth: bool = False) -> bool: ...
    @overload
    def Load(self, File: CSG_String) -> bool: ...
    @overload
    def Load(self, Stream: CSG_File) -> bool: ...
    @overload
    def Load(self, Projection: CSG_MetaData) -> bool: ...
    @overload
    def Save(self, File: CSG_String, Format: ESG_CRS_Format = ESG_CRS_Format.ESG_CRS_Format_WKT) -> bool: ...
    @overload
    def Save(self, Stream: CSG_File, Format: ESG_CRS_Format = ESG_CRS_Format.ESG_CRS_Format_WKT) -> bool: ...
    @overload
    def Save(self, Projection: CSG_MetaData) -> bool: ...
    
    def Get_Description(self, bDetails: bool = False) -> CSG_String: ...
    def Get_Name(self) -> CSG_String: ...
    def Get_WKT(self) -> CSG_String: ...
    def Get_WKT1(self) -> CSG_String: ...
    def Get_WKT2(self) -> CSG_String: ...
    def Get_PROJ(self) -> CSG_String: ...
    def Get_JSON(self) -> CSG_String: ...
    def Get_ESRI(self) -> CSG_String: ...
    def Get_XML(self) -> CSG_String: ...
    def Get_Authority(self) -> CSG_String: ...
    def Get_Code(self) -> int: ...
    def Get_Proj4(self) -> CSG_String: ...
    def Get_Authority_ID(self) -> int: ...
    def Get_EPSG(self) -> int: ...
    def is_Geographic(self) -> bool: ...
    def is_Geodetic(self) -> bool: ...
    def is_Geocentric(self) -> bool: ...
    def is_Projection(self) -> bool: ...
    def Get_Type(self) -> ESG_CRS_Type: ...
    def Get_Type_Identifier(self) -> CSG_String: ...
    def Get_Type_Name(self) -> CSG_String: ...
    def Get_Unit(self) -> ESG_Projection_Unit: ...
    def Get_Unit_Identifier(self) -> CSG_String: ...
    def Get_Unit_Name(self) -> CSG_String: ...
    def Get_Unit_To_Meter(self) -> float: ...

class CSG_Projections:
    thisown: bool
    __swig_destroy__: callable
    def __init__(self) -> None: ...
    @overload
    def __init__(self, LoadCodeList: bool) -> None: ...
    def Create(self, LoadCodeList: bool = True) -> bool: ...
    def Destroy(self) -> None: ...
    @staticmethod
    @overload
    def Parse(Definition: CSG_String, Format: ESG_CRS_Format) -> CSG_String: ...
    @staticmethod
    @overload
    def Parse(Definition: CSG_String, PROJ: Optional[CSG_String] = None, WKT2: Optional[CSG_String] = None, WKT1: Optional[CSG_String] = None, JSON: Optional[CSG_String] = None, ESRI: Optional[CSG_String] = None) -> bool: ...

    def Load(self, File: CSG_String, bAppend: bool = False) -> bool: ...
    def Save(self, File: CSG_String) -> bool: ...
    @overload
    def Add(self, Projection: CSG_Projection) -> bool: ...
    @overload
    def Add(self, WKT: str, Proj4: str, Authority: str, Authority_ID: int) -> bool: ...
    def Get_Count(self) -> int: ...
    @overload
    def Get_Projection(self, Index: int) -> CSG_Projection: ...
    @overload
    def Get_Projection(self, Code: int, Authority: Optional[str] = None) -> str: ...
    @overload
    def Get_Projection(self, Projection: CSG_Projection, Code: int, Authority: Optional[str] = None) -> bool: ...
    @overload
    def Get_Preference(self, Projection: CSG_Projection, Code: int, Authority: CSG_String) -> bool: ...
    @overload
    def Get_Preference(self, Projection: CSG_Projection, Authority_Code: CSG_String) -> bool: ...
    def Get_Names_List(self, Type: ESG_CRS_Type = ESG_CRS_Type.ESG_CRS_Type_Undefined, bAddSelect: bool = True) -> CSG_String: ...
    @staticmethod
    def Get_CRS_Type(Identifier: CSG_String) -> ESG_CRS_Type: ...
    @staticmethod
    def Get_CRS_Type_Identifier(Type: ESG_CRS_Type) -> CSG_String: ...
    @staticmethod
    def Get_CRS_Type_Name(Type: ESG_CRS_Type) -> CSG_String: ...
    @staticmethod
    def Get_Unit(Identifier: CSG_String) -> ESG_Projection_Unit: ...
    @staticmethod
    def Get_Unit_Identifier(Unit: ESG_Projection_Unit) -> CSG_String: ...
    @staticmethod
    def Get_Unit_Name(Unit: ESG_Projection_Unit, bSimple: bool = True) -> CSG_String: ...
    @staticmethod
    def Get_Unit_To_Meter(Unit: ESG_Projection_Unit) -> float: ...
    @staticmethod
    def Convert_WKT2_to_XML(WKT: CSG_String) -> CSG_String: ...
    def Set_UseInternalDB(self, bUse: bool = True) -> None: ...
    def Get_UseInternalDB(self) -> bool: ...

def SG_Get_Projections() -> CSG_Projections: ...
@overload
def SG_Get_Projected(pSource: CSG_Shapes, pTarget: CSG_Shapes, Target: CSG_Projection) -> bool: ...
@overload
def SG_Get_Projected(Source: CSG_Projection, Target: CSG_Projection, Point: TSG_Point) -> bool: ...
@overload
def SG_Get_Projected(Source: CSG_Projection, Target: CSG_Projection, Rectangle: TSG_Rect) -> bool: ...
def SG_Grid_Get_Geographic_Coordinates(pGrid: CSG_Grid, pLon: CSG_Grid, pLat: CSG_Grid) -> bool: ...
@overload
def SG_Is_Equal(a: float, b: float, epsilon: float = 0.0) -> bool: ...
@overload
def SG_Is_Equal(A: TSG_Point, B: TSG_Point, epsilon: float = 0.0) -> bool: ...
@overload
def SG_Is_Between(x: float, a: float, b: float, epsilon: float = 0.0) -> bool: ...
@overload
def SG_Is_Between(Point: TSG_Point, Corner_A: TSG_Point, Corner_B: TSG_Point, epsilon: float = 0.0) -> bool: ...
def SG_Get_Length(dx: float, dy: float) -> float: ...
@overload
def SG_Get_Distance(ax: float, ay: float, bx: float, by: float, bPolar: bool) -> float: ...
@overload
def SG_Get_Distance(ax: float, ay: float, bx: float, by: float) -> float: ...
@overload
def SG_Get_Distance(A: TSG_Point, B: TSG_Point, bPolar: bool) -> float: ...
@overload
def SG_Get_Distance(A: TSG_Point, B: TSG_Point) -> float: ...
@overload
def SG_Get_Distance(ax: float, ay: float, az: float, bx: float, by: float, bz: float) -> float: ...
@overload
def SG_Get_Distance(A: TSG_Point_3D, B: TSG_Point_3D) -> float: ...
@overload
def SG_Get_Distance_Polar(aLon: float, aLat: float, bLon: float, bLat: float, a: float = 6378137., e: float = 298.257223563, bDegree: bool = True) -> float: ...
@overload
def SG_Get_Distance_Polar(A: TSG_Point, B: TSG_Point, a: float = 6378137., e: float = 298.257223563, bDegree: bool = True) -> float: ...
@overload
def SG_Get_Angle_Of_Direction(dx: float, dy: float) -> float: ...
@overload
def SG_Get_Angle_Of_Direction(ax: float, ay: float, bx: float, by: float) -> float: ...
@overload
def SG_Get_Angle_Of_Direction(A: TSG_Point) -> float: ...
@overload
def SG_Get_Angle_Of_Direction(A: TSG_Point, B: TSG_Point) -> float: ...
def SG_Get_Angle_Difference(a: float, b: float) -> float: ...
def SG_is_Angle_Between(Angle: float, Angle_Min: float, Angle_Max: float, bCheckRange: bool = True) -> bool: ...
def SG_Get_Crossing(Crossing: TSG_Point, a1: TSG_Point, a2: TSG_Point, b1: TSG_Point, b2: TSG_Point, bExactMatch: bool = True) -> bool: ...
def SG_Get_Crossing_InRegion(Crossing: TSG_Point, a: TSG_Point, b: TSG_Point, Region: TSG_Rect) -> bool: ...
def SG_Is_Point_On_Line(Point: TSG_Point, Line_A: TSG_Point, Line_B: TSG_Point, bExactMatch: bool = False, Epsilon: float = 0.) -> bool: ...
def SG_Get_Distance_To_Line(Point: TSG_Point, Line_A: TSG_Point, Line_B: TSG_Point, bExactMatch: bool = True) -> float: ...
def SG_Get_Nearest_Point_On_Line(Point: TSG_Point, Line_A: TSG_Point, Line_B: TSG_Point, Line_Point: TSG_Point, bExactMatch: bool = True) -> float: ...
def SG_Get_Triangle_CircumCircle(Triangle: TSG_Point, Point: TSG_Point, Radius: float) -> bool: ...
@overload
def SG_Get_Polygon_Area(Points: TSG_Point, nPoints: int) -> float: ...
@overload
def SG_Get_Polygon_Area(Points: CSG_Points) -> float: ...

M_PI: float
M_PI_045: float
M_PI_090: float
M_PI_135: float
M_PI_180: float
M_PI_225: float
M_PI_270: float
M_PI_315: float
M_PI_360: float
M_RAD_TO_DEG: float
M_DEG_TO_RAD: float
M_EULER: float
N_MEGABYTE_BYTES: int
M_FLT_EPSILON: float
M_DBL_EPSILON: float
M_ALMOST_ZERO: float
M_TINY: float

def SG_Get_Square(Value: float) -> float: ...
def SG_Get_Rounded(Value: float, Decimals: int = 0) -> float: ...
def SG_Get_Rounded_To_SignificantFigures(Value: float, Decimals) -> float: ...
def SG_Get_Digit_Count(Number: int) -> int: ...
def SG_Get_Double_asString(Number: float, Width: int = -1, Precision: int = -1, bScientific: bool = False) -> CSG_String: ...
def SG_Compare_Int(a: int, b: int) -> int: ...
def SG_Compare_Double(a: float, b: float) -> int: ...
def SG_Compare_Char_Ptr(a: str, b: str) -> int: ...
def SG_Degree_To_Decimal(Deg: float, Min: float, Sec: float) -> float: ...
def SG_Decimal_To_Degree(Value: float, Deg: float, Min: float, Sec: float) -> None: ...

class CSG_Index:
    thisown: bool
    __swig_destroy__: callable
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> bool: ...
    def Destroy(self) -> bool: ...
    def Invert(self) -> bool: ...
    def Show_Progress(self, bProgress: bool = True) -> None: ...
    def Add_Entry(self, Position: int = -1) -> bool: ...
    def Del_Entry(self, Position: int = -1) -> bool: ...
    def is_Okay(self) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Index(self, Position, Ascending: bool = True) -> int: ...

class CSG_PriorityQueue:
    thisown: bool
    def __init__(self, maxSize: int = 256) -> None: ...
    __swig_destroy__: callable

    class CSG_PriorityQueueItem:
        def __init__(self) -> None: ...
        def Compare(pItem: "CSG_PriorityQueue.CSG_PriorityQueueItem") -> int: ...

    def Create(self, maxSize: int = 256) -> None: ...
    def Destroy(self) -> None: ...
    def is_Empty(self) -> bool: ...
    def Get_Size(self) -> int: ...
    def Get_Item(self, i) -> CSG_PriorityQueueItem: ...
    def Add(self, pItem) -> None: ...
    def Peek(self) -> CSG_PriorityQueueItem: ...
    def Poll(self) -> CSG_PriorityQueueItem: ...
    def Minimum(self) -> CSG_PriorityQueueItem: ...
    def Maximum(self) -> CSG_PriorityQueueItem: ...

class CSG_Vector:
    thisown: bool
    __swig_destroy__: callable
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> bool: ...
    def Destroy(self) -> bool: ...
    def Set_Rows(self, nRows) -> bool: ...
    def Add_Rows(self, nRows) -> bool: ...
    def Del_Rows(self, nRows) -> bool: ...
    def Add_Row(self, Value: float = 0.0) -> bool: ...
    def Del_Row(self, Row: int = -1) -> bool: ...
    def Get_Row_Count(self) -> int: ...
    def Get_Size(self) -> int: ...
    def Get_uSize(self) -> int: ...
    def Get_N(self) -> int: ...
    def Get_Data(self, *args) -> float: ...
    def __call__(self, x): ...
    def to_String(self, Width: int = -1, Precision: int = -1, bScientific: bool = False, Separator=None) -> CSG_String: ...
    def from_String(self, String) -> bool: ...
    def is_Null(self) -> bool: ...
    def is_Equal(self, Vector) -> bool: ...
    def is_Collinear(self, Vector) -> bool: ...
    def Assign(self, *args) -> bool: ...
    def Add(self, *args) -> bool: ...
    def Subtract(self, Vector) -> bool: ...
    def Multiply_Cross(self, Vector) -> bool: ...
    def Multiply_Scalar(self, Vector) -> float: ...
    def Multiply(self, *args) -> bool: ...
    def __eq__(self, Vector) -> bool: ...
    def __ne__(self, Vector) -> bool: ...
    def __iadd__(self, *args) -> CSG_Vector: ...
    def __isub__(self, *args) -> CSG_Vector: ...
    def __imul__(self, *args) -> CSG_Vector: ...
    def __add__(self, *args) -> CSG_Vector: ...
    def __sub__(self, *args) -> CSG_Vector: ...
    def __mul__(self, *args) -> CSG_Vector: ...
    def Set_Zero(self) -> bool: ...
    def Set_Unity(self) -> bool: ...
    def Flip_Values(self) -> bool: ...
    def Sort(self, bAscending: bool = True) -> bool: ...
    def Get_Length(self) -> float: ...
    def Get_Scalar_Product(self, Vector) -> CSG_Vector: ...
    def Get_Cross_Product(self, Vector) -> CSG_Vector: ...
    def Get_Angle(self, Vector) -> float: ...
    def Get_Unity(self) -> CSG_Vector: ...
    def begin(self) -> Any: ...
    def end(self) -> Any: ...
    def cbegin(self) -> Any: ...
    def cend(self) -> Any: ...

def SG_VectorR2_Rotate(*args) -> bool: ...
def SG_VectorR3_Rotate(*args) -> bool: ...

class CSG_Matrix:
    thisown: bool
    __swig_destroy__: callable
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> bool: ...
    def Destroy(self) -> bool: ...
    def Set_Size(self, nRows, nCols) -> bool: ...
    def Set_Cols(self, nCols) -> bool: ...
    def Set_Rows(self, nRows) -> bool: ...
    def Add_Cols(self, nCols) -> bool: ...
    def Add_Rows(self, nRows) -> bool: ...
    def Del_Cols(self, nCols) -> bool: ...
    def Del_Rows(self, nRows) -> bool: ...
    def Add_Col(self, *args) -> bool: ...
    def Add_Row(self, *args) -> bool: ...
    def Ins_Col(self, *args) -> bool: ...
    def Ins_Row(self, *args) -> bool: ...
    def Set_Col(self, *args) -> bool: ...
    def Set_Row(self, *args) -> bool: ...
    def Del_Col(self, Col) -> bool: ...
    def Del_Row(self, Row) -> bool: ...
    def Get_Col(self, Col) -> CSG_Vector: ...
    def Get_Row(self, Row) -> CSG_Vector: ...
    def Get_NX(self) -> int: ...
    def Get_NY(self) -> int: ...
    def Get_NCols(self) -> int: ...
    def Get_NRows(self) -> int: ...
    def Get_Data(self) -> Any: ...
    def __call__(self, Row, Col): ...
    def to_String(self, Width: int = -1, Precision: int = -1, bScientific: bool = False, Separator=None) -> CSG_String: ...
    def from_String(self, String) -> bool: ...
    def is_Square(self) -> bool: ...
    def is_Equal(self, Matrix) -> bool: ...
    def Assign(self, *args) -> bool: ...
    def Add(self, *args) -> bool: ...
    def Subtract(self, Matrix) -> bool: ...
    def Multiply(self, *args) -> bool: ...
    def __eq__(self, Matrix) -> bool: ...
    def __iadd__(self, *args) -> CSG_Matrix: ...
    def __isub__(self, *args) -> CSG_Matrix: ...
    def __imul__(self, *args) -> CSG_Matrix: ...
    def __add__(self, *args) -> CSG_Matrix: ...
    def __sub__(self, *args) -> CSG_Matrix: ...
    def __mul__(self, *args) -> CSG_Matrix: ...
    def Set_Zero(self) -> bool: ...
    def Set_Identity(self) -> bool: ...
    def Set_Transpose(self) -> bool: ...
    def Set_Inverse(self, bSilent: bool = True, nSubSquare: int = 0) -> bool: ...
    def Get_Determinant(self) -> float: ...
    def Get_Transpose(self) -> CSG_Matrix: ...
    def Get_Inverse(self, bSilent: bool = True, nSubSquare: int = 0) -> CSG_Matrix: ...

def SG_Matrix_Get_Rotation(*args) -> CSG_Matrix: ...
def SG_Matrix_LU_Decomposition(n, Permutation, Matrix, bSilent: bool = True, nRowChanges=None) -> bool: ...
def SG_Matrix_LU_Solve(n, Permutation, Matrix, Vector, bSilent: bool = True) -> bool: ...
def SG_Matrix_Solve(Matrix, Vector, bSilent: bool = True) -> bool: ...
def SG_Matrix_Eigen_Reduction(Matrix, Eigen_Vectors, Eigen_Values, bSilent: bool = True) -> bool: ...

class CSG_Grid_Radius:
    thisown: bool
    def __init__(self, maxRadius: int = 0) -> CSG_Grid_Radius: ...
    __swig_destroy__: callable
    def Create(self, maxRadius: int) -> bool: ...
    def Destroy(self) -> None: ...
    def Get_Maximum(self) -> int: ...
    @overload
    def Get_nPoints(self) -> int: ...
    @overload
    def Get_nPoints(self, iRadius: int) -> int: ...
    @overload
    def Get_Point(self, iPoint: int, x: int, y: int) -> float: ...
    @overload
    def Get_Point(self, iPoint: int, xOffset: int, yOffset: int, x: int, y: int) -> float: ...
    @overload
    def Get_Point(self, iRadius: int, iPoint: int, x: int, y: int) -> float: ...
    @overload
    def Get_Point(self, iRadius: int, iPoint: int, xOffset: int, yOffset: int, x: int, y: int) -> float: ...
    

class CSG_Random:
    thisown: bool
    def __init__(self) -> CSG_Random: ...
    @staticmethod
    @overload
    def Initialize() -> None: ...
    @staticmethod
    @overload
    def Initialize(Value: int) -> None: ...
    @staticmethod
    @overload
    def Get_Uniform() -> float: ...
    @staticmethod
    @overload
    def Get_Uniform(min: float, max: float) -> float: ...
    @staticmethod
    def Get_Gaussian(mean: float, stddev: float) -> float: ...
    __swig_destroy__: callable

class CSG_Simple_Statistics:
    thisown: bool
    @overload
    def __init__(self) -> CSG_Simple_Statistics: ...
    @overload
    def __init__(self, bHoldValues: bool = False) -> CSG_Simple_Statistics: ...
    @overload
    def __init__(self, Statistics: CSG_Simple_Statistics) -> CSG_Simple_Statistics: ...
    @overload
    def __init__(self, Mean: float, StdDev: float, Count: int = 1000) -> CSG_Simple_Statistics: ...
    @overload
    def __init__(self, Values: CSG_Vector, bHoldValues: bool = False) -> CSG_Simple_Statistics: ...
    @overload
    def Create(self, bHoldValues: bool = False) -> bool: ...
    @overload
    def Create(self, Statistics: CSG_Simple_Statistics) -> bool: ...
    @overload
    def Create(self, Mean: float, StdDev: float, Count: int = 1000) -> bool: ...
    @overload
    def Create(self, Values: CSG_Vector, bHoldValues: bool = False) -> bool: ...
    def Invalidate(self) -> None: ...
    def Evaluate(self) -> bool: ...
    def is_Evaluated(self) -> int: ...
    def Set_Count(self, Count: int) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Weights(self) -> float: ...
    def Get_Minimum(self) -> float: ...
    def Get_Maximum(self) -> float: ...
    def Get_Range(self) -> float: ...
    def Get_Sum(self) -> float: ...
    def Get_Sum_Of_Squares(self) -> float: ...
    def Get_Mean(self) -> float: ...
    def Get_Variance(self) -> float: ...
    def Get_StdDev(self) -> float: ...
    def Get_Kurtosis(self) -> float: ...
    def Get_Skewness(self) -> float: ...
    def Get_SkewnessPearson(self) -> float: ...
    def Get_Quantile(self, Quantile) -> float: ...
    def Get_Percentile(self, Percentile) -> float: ...
    def Get_Median(self) -> float: ...
    def Get_Gini(self) -> float: ...
    def Get_IndexOfMinimum(self) -> int: ...
    def Get_IndexOfMaximum(self) -> int: ...
    def Get_nValues_Above(self, Threshold: float, bEquals: bool = False) -> int: ...
    def Get_nValues_Below(self, Threshold: float, bEquals: bool = False) -> int: ...
    def Add(self, Statistics: CSG_Simple_Statistics) -> None: ...
    def Add_Value(self, Value: float, Weight: float = 1.0) -> None: ...
    def Get_Values(self) -> Any: ...
    def Get_Value(self, i: int) -> float: ...
    @overload
    def __iadd__(self, Statistics: CSG_Simple_Statistics) -> CSG_Simple_Statistics: ...
    @overload
    def __iadd__(self, Value: float) -> CSG_Simple_Statistics: ...
    __swig_destroy__: callable

class CSG_Unique_Value_Statistics:
    thisown: bool
    def __init__(self) -> CSG_Unique_Value_Statistics: ...
    __swig_destroy__: callable
    def Create(self, bWeights: bool = False) -> None: ...
    @overload
    def Get_Count(self) -> int: ...
    @overload
    def Get_Count(self, i: int) -> int: ...
    def Get_Weight(self, i: int) -> float: ...
    @overload
    def Get_Majority(self, bWeighted: bool = False) -> int: ...
    @overload
    def Get_Majority(self, Value: Union[float, CSG_String]) -> bool: ...
    @overload
    def Get_Majority(self, Value: Union[float, CSG_String], Count: int) -> bool: ...
    @overload
    def Get_Minority(self, bWeighted: bool = False) -> int: ...
    @overload
    def Get_Minority(self, Value: Union[float, CSG_String]) -> bool: ...
    @overload
    def Get_Minority(self, Value: Union[float, CSG_String], Count: int) -> bool: ...

class CSG_Unique_Number_Statistics(CSG_Unique_Value_Statistics):
    thisown: bool
    def __init__(self, bWeights: bool = False) -> CSG_Unique_Number_Statistics: ...
    __swig_destroy__: callable
    def Create(self, bWeights: bool = False) -> None: ...
    def __iadd__(self, Value: float) -> None: ...
    def Add_Value(self, Value: float, Weight: float = 1.0) -> None: ...
    def Get_Value(self, Index: int) -> float: ...
    def Get_Class_Index(self, Value: float) -> int: ...
    def Get_Class(self, Index: int, Value: float, Count: int) -> bool: ...
    @overload
    def Get_Majority(self, Value: float) -> bool: ...
    @overload
    def Get_Majority(self, Value: float, Count: int) -> bool: ...
    @overload
    def Get_Minority(self, Value: float) -> bool: ...
    @overload
    def Get_Minority(self, Value: float, Count: int) -> bool: ...

class CSG_Unique_String_Statistics(CSG_Unique_Value_Statistics):
    thisown: bool
    def __init__(self, bWeights: bool = False) -> CSG_Unique_String_Statistics: ...
    __swig_destroy__: callable
    def Create(self, bWeights: bool = False) -> None: ...
    def __iadd__(self, Value: CSG_String) -> None: ...
    def Add_Value(self, Value: CSG_String, Weight: float = 1.0) -> None: ...
    def Get_Value(self, Index: int) -> str: ...
    def Get_Class_Index(self, Value: CSG_String) -> int: ...
    def Get_Class(self, Index: int, Value: CSG_String, Count: int) -> bool: ...
    @overload
    def Get_Minority(self, Value: CSG_String) -> bool: ...
    @overload
    def Get_Minority(self, Value: CSG_String, Count: int) -> bool: ...

class CSG_Category_Statistics:
    thisown: bool
    def __init__(self, Type=...) -> CSG_Category_Statistics: ...
    __swig_destroy__: callable
    def Create(self, Type: TSG_Data_Type = SG_DATATYPE_String) -> None: ...
    def Destroy(self) -> None: ...
    def Get_Category_Type(self) -> TSG_Data_Type: ...
    @overload
    def Add_Value(self, Value: int) -> int: ...
    @overload
    def Add_Value(self, Value: float) -> int: ...
    @overload
    def Add_Value(self, Value: CSG_String) -> int: ...
    @overload
    def __iadd__(self, Value: int) -> None: ...
    @overload
    def __iadd__(self, Value: float) -> None: ...
    @overload
    def __iadd__(self, Value: CSG_String) -> None: ...
    def Sort(self) -> bool: ...
    @overload
    def Get_Count(self) -> int: ...
    @overload
    def Get_Count(self, iCategory: int) -> int: ...
    def asInt(self, iCategory: int) -> int: ...
    def asDouble(self, iCategory: int) -> float: ...
    def asString(self, iCategory: int) -> CSG_String: ...
    @overload
    def Get_Category(self, Value: Union[int, float, CSG_String]) -> int: ...
    @overload
    def Get_Category(self, iCategory: int, Value: Union[int, float, CSG_String], Count: int) -> bool: ...
    @overload
    def Get_Majority(self) -> int: ...
    @overload
    def Get_Majority(self, Value: Union[int, float, CSG_String]) -> bool: ...
    @overload
    def Get_Majority(self, Value: Union[int, float, CSG_String], Count: int) -> bool: ...
    @overload
    def Get_Minority(self) -> int: ...
    @overload
    def Get_Minority(self, Value: Union[int, float, CSG_String]) -> bool: ...
    @overload
    def Get_Minority(self, Value: Union[int, float, CSG_String], Count: int) -> bool: ...

class CSG_Histogram:
    thisown: bool
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    @overload
    def __init__(self) -> CSG_Histogram: ...
    @overload
    def __init__(self, Histogram: CSG_Histogram) -> CSG_Histogram: ...
    @overload
    def __init__(self, nClasses: int, Minimum: float, Maximum: float) -> CSG_Histogram: ...
    @overload
    def __init__(self, nClasses: int, Values: CSG_Vector, Minimum: float = 0.0, Maximum: float = 0.0, maxSamples: int = 0) -> CSG_Histogram: ...
    @overload
    def __init__(self, nClasses: int, pTable: CSG_Table, Field: int, Minimum: float = 0.0, Maximum: float = 0.0, maxSamples: int = 0, Normalize: int = -1, Scale: float = 1.0) -> CSG_Histogram: ...
    @overload
    def __init__(self, nClasses: int, pGrid: CSG_Grid, Minimum: float = 0.0, Maximum: float = 0.0, maxSamples: int = 0) -> CSG_Histogram: ...
    @overload
    def __init__(self, nClasses: int, pGrids: CSG_Grids, Minimum: float = 0.0, Maximum: float = 0.0, maxSamples: int = 0) -> CSG_Histogram: ...
    @overload
    def Create(self, Histogram: CSG_Histogram) -> bool: ...
    @overload
    def Create(self, nClasses: int, Minimum: float, Maximum: float) -> bool: ...
    @overload
    def Create(self, nClasses: int, Values: CSG_Vector, Minimum: float = 0.0, Maximum: float = 0.0, maxSamples: int = 0) -> bool: ...
    @overload
    def Create(self, nClasses: int, pTable: CSG_Table, Field: int, Minimum: float = 0.0, Maximum: float = 0.0, maxSamples: int = 0, Normalize: int = -1, Scale: float = 1.0) -> bool: ...
    @overload
    def Create(self, nClasses: int, pGrid: CSG_Grid, Minimum: float = 0.0, Maximum: float = 0.0, maxSamples: int = 0) -> bool: ...
    @overload
    def Create(self, nClasses: int, pGrids: CSG_Grids, Minimum: float = 0.0, Maximum: float = 0.0, maxSamples: int = 0) -> bool: ...
    def Add_Value(self, Value: float) -> None: ...
    def Add_Histogram(self, Histogram) -> bool: ...
    def Scale_Element_Count(self, Scale: float) -> bool: ...
    def Update(self) -> bool: ...
    def is_Okay(self) -> bool: ...
    def Get_Class_Count(self) -> int: ...
    def Get_Element_Count(self) -> int: ...
    def Get_Element_Maximum(self) -> int: ...
    def Get_Elements(self, i: int) -> int: ...
    def Get_Cumulative(self, i: int) -> int: ...
    def Get_Value(self, i: float) -> float: ...
    def Get_Break(self, i: int) -> float: ...
    def Get_Center(self, i: int) -> float: ...
    def __iadd__(self, Value: float) -> None: ...
    def Get_Quantile(self, Quantile: float) -> float: ...
    def Get_Quantile_Value(self, Value: float) -> float: ...
    def Get_Percentile(self, Percentile: float) -> float: ...
    def Get_Percentile_Value(self, Value: float) -> float: ...
    def Get_Statistics(self) -> CSG_Simple_Statistics: ...

class CSG_Natural_Breaks:
    thisown: bool
    __swig_destroy__: callable
    @overload
    def __init__(self) -> CSG_Natural_Breaks: ...
    @overload
    def __init__(self, pTable: CSG_Table, Field: int, nClasses: int, Histogram: int = ...) -> CSG_Natural_Breaks: ...
    @overload
    def __init__(self, pGrid: CSG_Grid, nClasses: int, Histogram: int = ...) -> CSG_Natural_Breaks: ...
    @overload
    def __init__(self, pGrids: CSG_Grids, nClasses: int, Histogram: int = ...) -> CSG_Natural_Breaks: ...
    @overload
    def __init__(self, Values: CSG_Vector, nClasses: int, Histogram: int = ...) -> CSG_Natural_Breaks: ...
    @overload
    def Create(self, pTable: CSG_Table, Field: int, nClasses: int, Histogram: int = ...) -> bool: ...
    @overload
    def Create(self, pGrid: CSG_Grid, nClasses: int, Histogram: int = ...) -> bool: ...
    @overload
    def Create(self, pGrids: CSG_Grids, nClasses: int, Histogram: int = ...) -> bool: ...
    @overload
    def Create(self, Values: CSG_Vector, nClasses: int, Histogram: int = ...) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Break(self, i: int) -> float: ...

SG_CLUSTERANALYSIS_Minimum_Distance: Incomplete
SG_CLUSTERANALYSIS_Hill_Climbing: Incomplete
SG_CLUSTERANALYSIS_Combined: Incomplete

class CSG_Cluster_Analysis:
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Create(self, nFeatures) -> bool: ...
    def Destroy(self) -> bool: ...
    def Add_Element(self) -> bool: ...
    def Set_Feature(self, iElement, iFeature, Value) -> bool: ...
    def Get_Cluster(self, iElement) -> int: ...
    def Execute(self, Method, nClusters, nMaxIterations: int = 0, Initialization: int = 0) -> bool: ...
    def Get_nElements(self) -> int: ...
    def Get_nFeatures(self) -> int: ...
    def Get_nClusters(self) -> int: ...
    def Get_Iteration(self) -> int: ...
    def Get_SP(self) -> float: ...
    def Get_nMembers(self, iCluster) -> int: ...
    def Get_Variance(self, iCluster) -> float: ...
    def Get_Centroid(self, iCluster, iFeature) -> float: ...

SG_CLASSIFY_SUPERVISED_BinaryEncoding: int
SG_CLASSIFY_SUPERVISED_ParallelEpiped: int
SG_CLASSIFY_SUPERVISED_MinimumDistance: int
SG_CLASSIFY_SUPERVISED_Mahalonobis: int
SG_CLASSIFY_SUPERVISED_MaximumLikelihood: int
SG_CLASSIFY_SUPERVISED_SAM: int
SG_CLASSIFY_SUPERVISED_WTA: int
SG_CLASSIFY_SUPERVISED_SID: int
SG_CLASSIFY_SUPERVISED_SVM: int

ESG_Classify_Supervised: TypeAlias = Literal[
    0,  # SG_CLASSIFY_SUPERVISED_BinaryEncoding
    1,  # SG_CLASSIFY_SUPERVISED_ParallelEpiped
    2,  # SG_CLASSIFY_SUPERVISED_MinimumDistance
    3,  # SG_CLASSIFY_SUPERVISED_Mahalonobis
    4,  # SG_CLASSIFY_SUPERVISED_MaximumLikelihood
    5,  # SG_CLASSIFY_SUPERVISED_SAM
    6,  # SG_CLASSIFY_SUPERVISED_WTA
    7,  # SG_CLASSIFY_SUPERVISED_SID
    8   # SG_CLASSIFY_SUPERVISED_SVM
]

class CSG_Classifier_Supervised:
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Create(self, nFeatures) -> None: ...
    def Destroy(self) -> None: ...
    def Load(self, File) -> bool: ...
    def Save(self, File, Feature_Info=None) -> bool: ...
    def Train_Clr_Samples(self) -> bool: ...
    def Train_Add_Sample(self, Class_ID, Features) -> bool: ...
    def Train(self, bClr_Samples: bool = False) -> bool: ...
    def Add_Class(self, Class_ID, Mean, Min, Max, Cov) -> bool: ...
    def Print(self) -> CSG_String: ...
    def Get_Feature_Count(self) -> int: ...
    def Get_Class_Count(self) -> int: ...
    def Get_Class_ID(self, iClass) -> CSG_String: ...
    def Get_Class_Mean(self, iClass, iFeature) -> float: ...
    def Get_Class_Minimum(self, iClass, iFeature) -> float: ...
    def Get_Class_Maximum(self, iClass, iFeature) -> float: ...
    def Get_Class(self, *args) -> Any: ...
    def Set_Threshold_Distance(self, Value) -> None: ...
    def Get_Threshold_Distance(self) -> float: ...
    def Set_Threshold_Angle(self, Value) -> None: ...
    def Get_Threshold_Angle(self) -> float: ...
    def Set_Threshold_Probability(self, Value) -> None: ...
    def Get_Threshold_Probability(self) -> float: ...
    def Set_Probability_Relative(self, Value) -> None: ...
    def Get_Probability_Relative(self) -> float: ...
    def Set_WTA(self, Method, bOn) -> None: ...
    def Get_WTA(self, Method) -> float: ...
    @staticmethod
    def Get_Name_of_Method(Method) -> CSG_String: ...
    @staticmethod
    def Get_Name_of_Quality(Method) -> CSG_String: ...

class CSG_Spline:
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Destroy(self) -> None: ...
    def Create(self, *args) -> bool: ...
    def Add(self, x, y) -> None: ...
    def Get_Count(self) -> int: ...
    def Get_xMin(self) -> float: ...
    def Get_xMax(self) -> float: ...
    def Get_x(self, i) -> float: ...
    def Get_y(self, i) -> float: ...
    def Get_Value(self, *args) -> Any: ...

class CSG_Thin_Plate_Spline:
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Destroy(self) -> None: ...
    def Set_Point_Count(self, Count) -> bool: ...
    def Get_Point_Count(self) -> int: ...
    def Get_Points(self) -> CSG_Points_3D: ...
    def Add_Point(self, *args) -> bool: ...
    def Set_Point(self, *args) -> bool: ...
    def Create(self, Regularization: float = 0.0, bSilent: bool = True) -> bool: ...
    def is_Okay(self) -> bool: ...
    def Get_Value(self, x, y) -> float: ...

TESTDIST_TYPE_Left: int
TESTDIST_TYPE_Right: int
TESTDIST_TYPE_Middle: int
TESTDIST_TYPE_TwoTail: int

TSG_Test_Distribution_Type: TypeAlias = Literal[
    0,  # TESTDIST_TYPE_Left
    1,  # TESTDIST_TYPE_Right
    2,  # TESTDIST_TYPE_Middle
    3,  # TESTDIST_TYPE_TwoTail
]

class CSG_Test_Distribution:
    thisown: bool
    @staticmethod
    def Get_F_Tail_from_R2(R2, nPredictors, nSamples, Type=...) -> float: ...
    @staticmethod
    def Get_F_Tail(F, dfn, dfd, Type=...) -> float: ...
    @staticmethod
    def Get_F_Inverse(alpha, dfn, dfd, Type=...) -> float: ...
    @staticmethod
    def Get_T_Tail(T, df, Type=...) -> float: ...
    @staticmethod
    def Get_T_Inverse(alpha, df, Type=...) -> float: ...
    @staticmethod
    def Get_Norm_P(Z) -> float: ...
    @staticmethod
    def Get_Norm_Z(P) -> float: ...
    def __init__(self) -> None: ...
    __swig_destroy__: callable

def SG_Get_Correlation_Matrix(Values, bCovariances: bool = False) -> CSG_Matrix: ...

REGRESSION_CORR_None: int
REGRESSION_CORR_Smith: int
REGRESSION_CORR_Wherry_1: int
REGRESSION_CORR_Wherry_2: int
REGRESSION_CORR_Olkin_Pratt: int
REGRESSION_CORR_Pratt: int
REGRESSION_CORR_Claudy_3: int

TSG_Regression_Correction: TypeAlias = Literal[
    0,  # REGRESSION_CORR_None
    1,  # REGRESSION_CORR_Smith
    2,  # REGRESSION_CORR_Wherry_1
    3,  # REGRESSION_CORR_Wherry_2
    4,  # REGRESSION_CORR_Olkin_Pratt
    5,  # REGRESSION_CORR_Pratt
    6,  # REGRESSION_CORR_Claudy_3
]

def SG_Regression_Get_Adjusted_R2(R2, nSamples, nPredictors, Correction=...) -> float: ...

REGRESSION_Linear: int
REGRESSION_Rez_X: int
REGRESSION_Rez_Y: int
REGRESSION_Pow: int
REGRESSION_Exp: int
REGRESSION_Log: int

TSG_Regression_Type: TypeAlias = Literal[
    0,  # REGRESSION_Linear
    1,  # REGRESSION_Rez_X
    2,  # REGRESSION_Rez_Y
    3,  # REGRESSION_Pow
    4,  # REGRESSION_Exp
    5,  # REGRESSION_Log
]

class CSG_Regression:
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Destroy(self) -> None: ...
    def Set_Values(self, nValues, x, y) -> bool: ...
    def Add_Values(self, x, y) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_xValue(self, i) -> float: ...
    def Get_yValue(self, i) -> float: ...
    def Get_Values(self, i, x, y) -> bool: ...
    def Get_xMin(self) -> float: ...
    def Get_xMax(self) -> float: ...
    def Get_xMean(self) -> float: ...
    def Get_xVariance(self) -> float: ...
    def Get_x(self, y) -> float: ...
    def Get_yMin(self) -> float: ...
    def Get_yMax(self) -> float: ...
    def Get_yMean(self) -> float: ...
    def Get_yVariance(self) -> float: ...
    def Get_y(self, x) -> float: ...
    def Get_Constant(self) -> float: ...
    def Get_Coefficient(self) -> float: ...
    def Get_R(self) -> float: ...
    def Get_R2(self) -> float: ...
    def Get_R2_Adj(self) -> float: ...
    def Get_P(self) -> float: ...
    def Get_StdError(self) -> float: ...
    def asString(self) -> str: ...
    def Get_Type(self) -> TSG_Regression_Type: ...
    def Calculate(self, *args) -> bool: ...

MLR_VAR_ID: int
MLR_VAR_NAME: int
MLR_VAR_RCOEFF: int
MLR_VAR_R: int
MLR_VAR_R2: int
MLR_VAR_R2_ADJ: int
MLR_VAR_SE: int
MLR_VAR_T: int
MLR_VAR_SIG: int
MLR_VAR_P: int

ESG_Multiple_Regression_Info_Vars: TypeAlias = Literal[
    0,  # MLR_VAR_ID
    1,  # MLR_VAR_NAME
    2,  # MLR_VAR_RCOEFF
    3,  # MLR_VAR_R
    4,  # MLR_VAR_R2
    5,  # MLR_VAR_R2_ADJ
    6,  # MLR_VAR_SE
    7,  # MLR_VAR_T
    8,  # MLR_VAR_SIG
    9   # MLR_VAR_P
]

class CSG_Regression_Multiple:
    thisown: bool
    def __init__(self, bIntercept: bool = True) -> None: ...
    __swig_destroy__: callable
    def Destroy(self) -> None: ...
    def Set_Data(self, Samples, pNames=None) -> bool: ...
    def Set_With_Intercept(self, bOn: bool = True) -> None: ...
    def Get_With_Intercept(self) -> bool: ...
    def Get_Model(self, *args) -> bool: ...
    def Get_Model_Forward(self, *args) -> bool: ...
    def Get_Model_Backward(self, *args) -> bool: ...
    def Get_Model_Stepwise(self, *args) -> bool: ...
    def Get_CrossValidation(self, nSubSamples: int = 0) -> bool: ...
    def Get_Info(self) -> CSG_String: ...
    def Get_Info_Regression(self) -> CSG_Table: ...
    def Get_Info_Model(self) -> CSG_Table: ...
    def Get_Info_Steps(self) -> CSG_Table: ...
    def Get_R2(self) -> float: ...
    def Get_R2_Adj(self) -> float: ...
    def Get_F(self) -> float: ...
    def Get_CV_RMSE(self) -> float: ...
    def Get_CV_NRMSE(self) -> float: ...
    def Get_CV_R2(self) -> float: ...
    def Get_CV_nSamples(self) -> int: ...
    def Get_DegFreedom(self) -> int: ...
    def Get_nSamples(self) -> int: ...
    def Get_nPredictors(self) -> int: ...
    def Get_Predictor(self, i) -> int: ...
    def Get_RConst(self) -> float: ...
    def Get_Name(self, iVariable) -> str: ...
    def Get_ID(self, iVariable) -> float: ...
    def Get_RCoeff(self, iVariable) -> float: ...
    def Get_R2_Partial(self, iVariable) -> float: ...
    def Get_R2_Partial_Adj(self, iVariable) -> float: ...
    def Get_StdError(self, *args) -> float: ...
    def Get_T(self, iVariable) -> float: ...
    def Get_P(self, *args) -> float: ...
    def Get_Parameter(self, iVariable, Parameter) -> float: ...
    def Get_Value(self, *args) -> Any: ...
    def Get_Residual(self, *args) -> float: ...
    def Get_Residuals(self, Residuals) -> bool: ...

class CSG_Regression_Weighted:
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    def Add_Sample(self, Weight, Dependent, Predictors) -> bool: ...
    def Get_Sample_Count(self) -> int: ...
    def Get_Predictor_Count(self) -> int: ...
    def Calculate(self, *args) -> bool: ...
    def Get_R2(self) -> float: ...
    def Get_RCoeff(self, *args) -> Any: ...
    def Get_Log_maxIter(self) -> int: ...
    def Get_Log_Epsilon(self) -> float: ...
    def Get_Log_Difference(self) -> float: ...
    def Set_Log_maxIter(self, maxIter) -> bool: ...
    def Set_Log_Epsilon(self, Epsilon) -> bool: ...
    def Set_Log_Difference(self, Difference) -> bool: ...
    def Get_CrossValidation(self, nSubSamples: int = 0) -> bool: ...
    def Get_CV_nSamples(self) -> int: ...
    def Get_CV_RMSE(self) -> float: ...
    def Get_CV_NRMSE(self) -> float: ...
    def Get_CV_R2(self) -> float: ...

class CSG_Formula:
    thisown: bool
    def __init__(self) -> CSG_Formula: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    @staticmethod
    def Get_Help_Operators(bHTML: bool = True, Additional: int = 0) -> CSG_String: ...
    def Get_Error(self, Message: CSG_String) -> bool: ...
    def Add_Function(self, Name: str, Function: float, nParameters: int, bVarying: bool = False) -> bool: ...
    def Set_Formula(self, Formula: CSG_String) -> bool: ...
    def Get_Formula(self) -> CSG_String: ...
    def Set_Variable(self, Variable: str, Value: float) -> None: ...
    @overload
    def Get_Value(self) -> float: ...
    @overload
    def Get_Value(self, x: float) -> float: ...
    @overload
    def Get_Value(self, Values: CSG_Vector) -> float: ...
    @overload
    def Get_Value(self, Values: Any, nValues: int) -> float: ...
    @overload
    def Get_Value(self, Arguments: str) -> float: ...
    def Get_Used_Variables(self) -> str: ...

SG_TREND_STRING_Formula: int
SG_TREND_STRING_Function: int
SG_TREND_STRING_Formula_Parameters: int
SG_TREND_STRING_Complete: int
SG_TREND_STRING_Compact: int

ESG_Trend_String: TypeAlias = Literal[
    0,  # SG_TREND_STRING_Formula
    1,  # SG_TREND_STRING_Function
    2,  # SG_TREND_STRING_Formula_Parameters
    3,  # SG_TREND_STRING_Complete
    4,  # SG_TREND_STRING_Compact
]

class CSG_Trend:
    thisown: bool
    def __init__(self) -> None: ...
    def Set_Formula(self, Formula) -> bool: ...
    def Get_Formula(self, Type=...) -> CSG_String: ...
    def Get_Parameter_Count(self) -> int: ...
    def Get_Parameters(self) -> Any: ...
    def Init_Parameter(self, Variable, Value) -> bool: ...
    def Clr_Data(self) -> None: ...
    def Add_Data(self, x, y) -> bool: ...
    def Set_Data(self, *args) -> None: ...
    def Get_Data_Count(self) -> int: ...
    def Get_Data_X(self, i) -> float: ...
    def Get_Data_XMin(self) -> float: ...
    def Get_Data_XMax(self) -> float: ...
    def Get_Data_XStats(self) -> CSG_Simple_Statistics: ...
    def Get_Data_Y(self, i) -> float: ...
    def Get_Data_YMin(self) -> float: ...
    def Get_Data_YMax(self) -> float: ...
    def Get_Data_YStats(self) -> CSG_Simple_Statistics: ...
    def Set_Max_Iterations(self, Iterations) -> bool: ...
    def Get_Max_Iterations(self) -> int: ...
    def Set_Max_Lambda(self, Lambda) -> bool: ...
    def Get_Max_Lambda(self) -> int: ...
    def Get_Trend(self, *args) -> bool: ...
    def is_Okay(self) -> bool: ...
    def Get_Error(self) -> CSG_String: ...
    def Get_ChiSquare(self) -> float: ...
    def Get_R2(self) -> float: ...
    def Get_Value(self, x) -> float: ...
    __swig_destroy__: callable

class CSG_Trend_Polynom:
    thisown: bool
    def __init__(self) -> None: ...
    def Destroy(self) -> bool: ...
    def Set_Order(self, Order: int = 1) -> bool: ...
    def Clr_Data(self) -> bool: ...
    def Set_Data(self, x, y, n, bAdd: bool = False) -> bool: ...
    def Add_Data(self, x, y) -> bool: ...
    def Get_Data_Count(self) -> int: ...
    def Get_Data_X(self, i) -> float: ...
    def Get_Data_Y(self, i) -> float: ...
    def Get_Trend(self) -> bool: ...
    def Get_Order(self) -> int: ...
    def Get_nCoefficients(self) -> int: ...
    def Get_Coefficient(self, i) -> float: ...
    def Get_R2(self) -> float: ...
    def Get_Value(self, x) -> float: ...
    __swig_destroy__: callable

SG_META_SOURCE: str
SG_META_FILEPATH: str
SG_META_DATABASE: str
SG_META_PROJECTION: str
SG_META_HISTORY: str

SG_DATAOBJECT_TYPE_Grid: int
SG_DATAOBJECT_TYPE_Grids: int
SG_DATAOBJECT_TYPE_Table: int
SG_DATAOBJECT_TYPE_Shapes: int
SG_DATAOBJECT_TYPE_TIN: int
SG_DATAOBJECT_TYPE_PointCloud: int
SG_DATAOBJECT_TYPE_Undefined: int

TSG_Data_Object_Type: TypeAlias = Literal[
    0,  # SG_DATAOBJECT_TYPE_Grid
    1,  # SG_DATAOBJECT_TYPE_Grids
    2,  # SG_DATAOBJECT_TYPE_Table
    3,  # SG_DATAOBJECT_TYPE_Shapes
    4,  # SG_DATAOBJECT_TYPE_TIN
    5,  # SG_DATAOBJECT_TYPE_PointCloud
    6,  # SG_DATAOBJECT_TYPE_Undefined
]

def SG_Get_Create_Pointer() -> Any: ...
def SG_Get_DataObject_Identifier(Type: TSG_Data_Object_Type) -> CSG_String: ...
def SG_Get_DataObject_Name(Type: TSG_Data_Object_Type) -> CSG_String: ...
def SG_Get_DataObject_Class_Name(Type: TSG_Data_Object_Type) -> CSG_String: ...
def SG_DataObject_Set_Max_Samples(Max_Samples: int) -> bool: ...
def SG_DataObject_Get_Max_Samples() -> int: ...
def SG_Set_History_Depth(Depth: int) -> None: ...
def SG_Get_History_Depth() -> int: ...
def SG_Set_History_Ignore_Lists(Ignore: int) -> None: ...
def SG_Get_History_Ignore_Lists() -> int: ...

class CSG_Data_Object:
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    def Get_RefID(self) -> int: ...
    def Get_Managed(self) -> int: ...
    def Get_ObjectType(self) -> TSG_Data_Object_Type: ...
    def is_Valid(self) -> bool: ...
    @overload
    def Save(self, File: Union[CSG_String, str], Format: int = 0) -> bool: ...
    def Reload(self) -> bool: ...
    def Delete(self) -> bool: ...
    def Set_File_Name(self, FileName: CSG_String) -> None: ...
    def Get_File_Name(self, bNative: bool = True) -> str: ...
    def Get_File_Type(self) -> int: ...
    def is_File_Native(self) -> bool: ...
    def Assign(self, pObject: CSG_Data_Object, bProgress: bool = False) -> bool: ...
    def Set_Name(self, Name: Union[CSG_String, str]) -> None: ...
    def Fmt_Name(self, str) -> None: ...
    def Get_Name(self) -> str: ...
    def Set_Description(self, Description: CSG_String) -> None: ...
    def Get_Description(self) -> str: ...
    def Set_Modified(self, bOn: bool = True) -> None: ...
    def is_Modified(self) -> bool: ...
    def Update(self, bForce: bool = False) -> bool: ...
    def Get_Owner(self) -> CSG_Data_Object: ...
    def Set_Owner(self, pOwner: CSG_Data_Object) -> None: ...
    def Get_MetaData(self) -> CSG_MetaData: ...
    def Get_MetaData_DB(self) -> CSG_MetaData: ...
    def Get_History(self) -> CSG_MetaData: ...
    def Get_Extent(self) -> CSG_Rect: ...
    def Get_Projection(self) -> CSG_Projection: ...
    def asTable(self, bPolymorph: bool = False) -> CSG_Table: ...
    def asShapes(self, bPolymorph: bool = False) -> CSG_Shapes: ...
    def asTIN(self, bPolymorph: bool = False) -> CSG_TIN: ...
    def asPointCloud(self, bPolymorph: bool = False) -> CSG_PointCloud: ...
    def asGrid(self, bPolymorph: bool = False) -> CSG_Grid: ...
    def asGrids(self, bPolymorph: bool = False) -> CSG_Grids: ...
    def Set_NoData_Value(self, Value: float) -> bool: ...
    def Set_NoData_Value_Range(self, Lower: float, Upper: float) -> bool: ...
    def Get_NoData_Value(self, bUpper: bool = False) -> float: ...
    def is_NoData_Value(self, Value: float) -> bool: ...
    def Save_History_to_Model(self, File: CSG_String) -> bool: ...
    def Set_Max_Samples(self, Max_Samples: int) -> bool: ...
    def Get_Max_Samples(self) -> int: ...
    @staticmethod
    def Track(Track: bool = True, Offset: bool = False) -> None: ...

def SG_Data_Object_Delete(pObject: CSG_Data_Object) -> bool: ...

class CSG_TimeSpan:
    thisown: bool
    def __init__(self, *args) -> None: ...
    @staticmethod
    def Milliseconds(ms) -> CSG_TimeSpan: ...
    @staticmethod
    def Seconds(sec) -> CSG_TimeSpan: ...
    @staticmethod
    def Minutes(min) -> CSG_TimeSpan: ...
    @staticmethod
    def Hours(hours) -> CSG_TimeSpan: ...
    @staticmethod
    def Days(days) -> CSG_TimeSpan: ...
    @staticmethod
    def Weeks(days) -> CSG_TimeSpan: ...
    @staticmethod
    def Millisecond() -> CSG_TimeSpan: ...
    @staticmethod
    def Second() -> CSG_TimeSpan: ...
    @staticmethod
    def Minute() -> CSG_TimeSpan: ...
    @staticmethod
    def Hour() -> CSG_TimeSpan: ...
    @staticmethod
    def Day() -> CSG_TimeSpan: ...
    @staticmethod
    def Week() -> CSG_TimeSpan: ...
    def __iadd__(self, ts) -> CSG_TimeSpan: ...
    def __isub__(self, ts) -> CSG_TimeSpan: ...
    def __imul__(self, n) -> CSG_TimeSpan: ...
    def Add(self, *args) -> CSG_TimeSpan: ...
    def Subtract(self, *args) -> CSG_TimeSpan: ...
    def Multiply(self, *args) -> CSG_TimeSpan: ...
    def __add__(self, ts) -> CSG_TimeSpan: ...
    def __sub__(self, ts) -> CSG_TimeSpan: ...
    def __mul__(self, n) -> CSG_TimeSpan: ...
    def Abs(self) -> CSG_TimeSpan: ...
    def Negate(self) -> CSG_TimeSpan: ...
    def Neg(self) -> CSG_TimeSpan: ...
    def __neg__(self) -> CSG_TimeSpan: ...
    def is_Null(self) -> bool: ...
    def is_Positive(self) -> bool: ...
    def is_Negative(self) -> bool: ...
    def is_EqualTo(self, ts) -> bool: ...
    def is_LongerThan(self, ts) -> bool: ...
    def is_ShorterThan(self, ts) -> bool: ...
    def __lt__(self, ts) -> bool: ...
    def __le__(self, ts) -> bool: ...
    def __eq__(self, ts) -> bool: ...
    def __ne__(self, ts) -> bool: ...
    def __ge__(self, ts) -> bool: ...
    def __gt__(self, ts) -> bool: ...
    def Get_Weeks(self) -> int: ...
    def Get_Days(self) -> int: ...
    def Get_Hours(self) -> int: ...
    def Get_Minutes(self) -> int: ...
    def Get_Seconds(self) -> int: ...
    def Get_Milliseconds(self) -> int: ...
    def Get_Value(self) -> int: ...
    def Format(self, *args) -> CSG_String: ...
    __swig_destroy__: callable

class CSG_DateTime:
    thisown: bool

    TSG_DateTime = int

    Jan: int
    Feb: int
    Mar: int
    Apr: int
    May: int
    Jun: int
    Jul: int
    Aug: int
    Sep: int
    Oct: int
    Nov: int
    Dec: int
    Inv_Month: int

    Sun: int
    Mon: int
    Tue: int
    Wed: int
    Thu: int
    Fri: int
    Sat: int
    Inv_WeekDay: int

    Inv_Year: int

    Name_Full: int
    Name_Abbr: int
    
    def __init__(self, *args) -> None: ...
    __swig_destroy__: callable
    def Set(self, *args) -> CSG_DateTime: ...
    def Set_Millisecond(self, Value) -> CSG_DateTime: ...
    def Set_Second(self, Value) -> CSG_DateTime: ...
    def Set_Minute(self, Value) -> CSG_DateTime: ...
    def Set_Hour(self, *args) -> CSG_DateTime: ...
    def Set_Day(self, Value) -> CSG_DateTime: ...
    def Set_Month(self, Value) -> CSG_DateTime: ...
    def Set_Year(self, Value) -> CSG_DateTime: ...
    def Set_DayOfYear(self, Value) -> CSG_DateTime: ...
    def Set_To_Current(self) -> CSG_DateTime: ...
    def Set_Unix_Time(self, Seconds) -> CSG_DateTime: ...
    def Set_Hours_AD(self, Hours) -> CSG_DateTime: ...
    def Reset_Time(self) -> CSG_DateTime: ...
    def From_UTC(self, noDST: bool = False) -> CSG_DateTime: ...
    def To_UTC(self, noDST: bool = False) -> CSG_DateTime: ...
    def Make_UTC(self, noDST: bool = False) -> CSG_DateTime: ...
    def is_DST(self) -> bool: ...
    def Add(self, *args) -> CSG_DateTime: ...
    def Subtract(self, *args) -> Any: ...
    def is_Valid(self) -> bool: ...
    def Get_Value(self) -> int: ...
    def Get_Millisecond(self) -> int: ...
    def Get_Second(self) -> int: ...
    def Get_Minute(self) -> int: ...
    def Get_Hour(self) -> int: ...
    def Get_Day(self) -> int: ...
    def Get_Month(self) -> int: ...
    def Get_Year(self) -> int: ...
    def Get_DayOfYear(self) -> int: ...
    def Get_WeekDay(self) -> int: ...
    def Get_WeekOfMonth(self) -> TSG_DateTime: ...
    def Get_WeekOfYear(self) -> TSG_DateTime: ...
    def Get_JDN(self) -> float: ...
    def Get_MJD(self) -> float: ...
    def Get_Unix_Time(self) -> int: ...
    def is_EarlierThan(self, DateTime) -> bool: ...
    def is_EqualTo(self, DateTime) -> bool: ...
    def is_LaterThan(self, DateTime) -> bool: ...
    def is_SameDate(self, DateTime) -> bool: ...
    def is_SameTime(self, DateTime) -> bool: ...
    def is_Between(self, t1, t2) -> bool: ...
    def is_StrictlyBetween(self, t1, t2) -> bool: ...
    def __iadd__(self, TimeSpan) -> CSG_DateTime: ...
    def __isub__(self, TimeSpan) -> CSG_DateTime: ...
    def __add__(self, TimeSpan) -> CSG_DateTime: ...
    def __sub__(self, *args) -> Any: ...
    def __lt__(self, DateTime) -> bool: ...
    def __le__(self, DateTime) -> bool: ...
    def __eq__(self, DateTime) -> bool: ...
    def __ge__(self, DateTime) -> bool: ...
    def __gt__(self, DateTime) -> bool: ...
    def Format(self, *args) -> CSG_String: ...
    def Format_Date(self) -> CSG_String: ...
    def Format_Time(self) -> CSG_String: ...
    def Format_ISODate(self) -> CSG_String: ...
    def Format_ISOTime(self) -> CSG_String: ...
    def Format_ISOCombined(self, *args) -> CSG_String: ...
    def Parse_Date(self, date) -> bool: ...
    def Parse_DateTime(self, datetime) -> bool: ...
    def Parse_Format(self, *args) -> bool: ...
    def Parse_ISOCombined(self, *args) -> bool: ...
    def Parse_ISODate(self, date) -> bool: ...
    def Parse_ISOTime(self, date) -> bool: ...
    @staticmethod
    def Get_Current_Day() -> TSG_DateTime: ...
    @staticmethod
    def Get_Current_Month() -> int: ...
    @staticmethod
    def Get_Current_Year() -> int: ...
    @staticmethod
    def Get_MonthName(*args) -> CSG_String: ...
    @staticmethod
    def Get_EnglishMonthName(*args) -> CSG_String: ...
    @staticmethod
    def Get_WeekDayName(*args) -> CSG_String: ...
    @staticmethod
    def Get_EnglishWeekDayName(*args) -> CSG_String: ...
    @staticmethod
    def Get_NumberOfDays(*args) -> TSG_DateTime: ...
    @staticmethod
    def is_LeapYear(*args) -> bool: ...
    @staticmethod
    def Now() -> CSG_DateTime: ...
    @staticmethod
    def Get_Month_Choices() -> CSG_String: ...

@overload
def SG_JulianDayNumber_To_Date(JDN: float, y: int, m: int, d: int) -> bool: ...
@overload
def SG_JulianDayNumber_To_Date(JDN: float) -> CSG_String: ...
@overload
def SG_JulianDayNumber_To_Date(JDN: int) -> CSG_String: ...
@overload
def SG_Date_To_JulianDayNumber(y: int, m: int, d: int) -> float: ...
@overload
def SG_Date_To_JulianDayNumber(Date: CSG_String) -> float: ...
def SG_Get_Day_MidOfMonth(Month: int, bLeapYear: bool = False) -> int: ...
@overload
def SG_Get_Sun_Position(JulianDayNumber: float, RA: float, Dec: float) -> bool: ...
@overload
def SG_Get_Sun_Position(Time: CSG_DateTime, RA: float, Dec: float) -> bool: ...
@overload
def SG_Get_Sun_Position(JulianDayNumber: float, Longitude: float, Latitude: float, Height: float, Azimuth: float, bRefraction: bool = False) -> bool: ...
@overload
def SG_Get_Sun_Position(Time: CSG_DateTime, Longitude: float, Latitude: float, Height: float, Azimuth: float, bRefraction: bool = False) -> bool: ...
@overload
def SG_Get_Sun_Position(JulianDayNumber: float, Longitude: float, Latitude: float, Position: CSG_Vector, bRefraction: bool = False) -> bool: ...
@overload
def SG_Get_Sun_Position(Time: CSG_DateTime, Longitude: float, Latitude: float, Position: CSG_Vector, bRefraction: bool = False) -> bool: ...
def SG_Get_Sun_Refraction(Height: float, bRadians: bool) -> float: ...
@overload
def SG_Get_Day_Length(DayOfYear: int, Latitude: float) -> float: ...
@overload
def SG_Get_Day_Length(Date: CSG_DateTime, Latitude: float) -> float: ...

SG_TABLE_VALUE_TYPE_Binary: int
SG_TABLE_VALUE_TYPE_String: int
SG_TABLE_VALUE_TYPE_Date: int
SG_TABLE_VALUE_TYPE_Int: int
SG_TABLE_VALUE_TYPE_Long: int
SG_TABLE_VALUE_TYPE_Double: int

TSG_Table_Value_Type: TypeAlias = Literal[
    0,  # SG_TABLE_VALUE_TYPE_Binary
    1,  # SG_TABLE_VALUE_TYPE_String
    2,  # SG_TABLE_VALUE_TYPE_Date
    3,  # SG_TABLE_VALUE_TYPE_Int
    4,  # SG_TABLE_VALUE_TYPE_Long
    5,  # SG_TABLE_VALUE_TYPE_Double
]

class CSG_Table_Value:
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    __swig_destroy__: callable
    def Get_Type(self) -> TSG_Table_Value_Type: ...
    def Set_Value(self, Value: Union[CSG_Bytes, str, int, float]) -> bool: ...
    def asBinary(self) -> CSG_Bytes: ...
    def asString(self, Decimals: int = -99) -> str: ...
    def asInt(self) -> int: ...
    def asLong(self) -> int: ...
    def asDouble(self) -> float: ...
    def is_Equal(self, Value: CSG_Table_Value) -> bool: ...
    def __eq__(self, Value: CSG_Table_Value) -> bool: ...

class CSG_Table_Value_Binary(CSG_Table_Value):
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Get_Type(self) -> TSG_Table_Value_Type: ...
    def Set_Value(self, Value: Union[CSG_Bytes, str, int, float]) -> bool: ...
    def Set_NoData(self) -> bool: ...
    def is_NoData(self) -> bool: ...
    def asBinary(self) -> CSG_Bytes: ...
    def asString(self, Decimals: int = -99) -> str: ...
    def asInt(self) -> int: ...
    def asLong(self) -> int: ...
    def asDouble(self) -> float: ...
    def is_Equal(self, Value: CSG_Table_Value) -> bool: ...
    def Get_Binary(self) -> CSG_Bytes: ...

class CSG_Table_Value_String(CSG_Table_Value):
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Get_Type(self) -> TSG_Table_Value_Type: ...
    def Set_Value(self, Value: Union[CSG_Bytes, str, int, float]) -> bool: ...
    def asString(self, Decimals: int = -99) -> str: ...
    def asInt(self) -> int: ...
    def asLong(self) -> int: ...
    def asDouble(self) -> float: ...
    def is_Equal(self, Value: CSG_Table_Value) -> bool: ...

class CSG_Table_Value_Date(CSG_Table_Value):
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Get_Type(self) -> TSG_Table_Value_Type: ...
    def Set_Value(self, Value: Union[CSG_Bytes, str, int, float]) -> bool: ...
    def asString(self, Decimals: int = -99) -> str: ...
    def asInt(self) -> int: ...
    def asLong(self) -> int: ...
    def asDouble(self) -> float: ...
    def is_Equal(self, Value: CSG_Table_Value) -> bool: ...

class CSG_Table_Value_Int(CSG_Table_Value):
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Get_Type(self) -> TSG_Table_Value_Type: ...
    def Set_Value(self, Value: Union[CSG_Bytes, str, int, float]) -> bool: ...
    def asString(self, Decimals: int = -99) -> str: ...
    def asInt(self) -> int: ...
    def asLong(self) -> int: ...
    def asDouble(self) -> float: ...
    def is_Equal(self, Value: CSG_Table_Value) -> bool: ...

class CSG_Table_Value_Long(CSG_Table_Value):
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Get_Type(self) -> TSG_Table_Value_Type: ...
    def Set_Value(self, Value: Union[CSG_Bytes, str, int, float]) -> bool: ...
    def asString(self, Decimals: int = -99) -> str: ...
    def asInt(self) -> int: ...
    def asLong(self) -> int: ...
    def asDouble(self) -> float: ...
    def is_Equal(self, Value: CSG_Table_Value) -> bool: ...

class CSG_Table_Value_Double(CSG_Table_Value):
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Get_Type(self) -> TSG_Table_Value_Type: ...
    @overload
    def Set_Value(self, Value: Union[CSG_Bytes, str, int, float]) -> bool: ...
    def asString(self, Decimals: int = -99) -> str: ...
    def asInt(self) -> int: ...
    def asLong(self) -> int: ...
    def asDouble(self) -> float: ...
    def is_Equal(self, Value: CSG_Table_Value) -> bool: ...

TABLE_FILETYPE_Undefined: int
TABLE_FILETYPE_Text: int
TABLE_FILETYPE_Text_NoHeadLine: int
TABLE_FILETYPE_DBase: int

TSG_Table_File_Type: TypeAlias = Literal[
    0,  # TABLE_FILETYPE_Undefined
    1,  # TABLE_FILETYPE_Text
    2,  # TABLE_FILETYPE_Text_NoHeadLine
    3,  # TABLE_FILETYPE_DBase
]

TABLE_INDEX_None: int
TABLE_INDEX_Ascending: int
TABLE_INDEX_Descending: int

TSG_Table_Index_Order: TypeAlias = Literal[
    0,  # TABLE_INDEX_None
    1,  # TABLE_INDEX_Ascending
    2,  # TABLE_INDEX_Descending
]

SG_TABLE_REC_FLAG_Modified: int
SG_TABLE_REC_FLAG_Selected: int

class CSG_Table_Record:
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Table(self) -> CSG_Table: ...
    def Get_Index(self) -> int: ...
    def is_Valid(self) -> bool: ...
    @overload
    def Set_Value(self, Field: int, Value: Union[CSG_String, str, CSG_Bytes, float, int]) -> bool: ...
    @overload
    def Set_Value(self, Field: Union[CSG_String, str], Value: Union[CSG_String,str, CSG_Bytes, float, int]) -> bool: ...
    @overload
    def Add_Value(self, Field: int, Value: float) -> bool: ...
    @overload
    def Add_Value(self, Field: Union[CSG_String, str], Value: float) -> bool: ...
    @overload
    def Mul_Value(self, Field: int, Value: float) -> bool: ...
    @overload
    def Mul_Value(self, Field: Union[CSG_String, str], Value: float) -> bool: ...
    @overload
    def Set_NoData(self, Field: int, Value: float) -> bool: ...
    @overload
    def Set_NoData(self, Field: Union[CSG_String, str], Value: float) -> bool: ...
    @overload
    def is_NoData(self, Field: int, Value: float) -> bool: ...
    @overload
    def is_NoData(self, Field: Union[CSG_String, str], Value: float) -> bool: ...
    @overload
    def asString(self, Field: int, Decimals: int = -99) -> str: ...
    @overload
    def asString(self, Field: Union[CSG_String, str], Decimals: int = -99) -> str: ...
    @overload
    def asChar(self, Field: int) -> str: ...
    @overload
    def asChar(self, Field: Union[CSG_String, str]) -> str: ...
    @overload
    def asShort(self, Field: int) -> int: ...
    @overload
    def asShort(self, Field: Union[CSG_String, str]) -> int: ...
    @overload
    def asInt(self, Field: int) -> int: ...
    @overload
    def asInt(self, Field: Union[CSG_String, str]) -> int: ...
    @overload
    def asLong(self, Field: int) -> int: ...
    @overload
    def asLong(self, Field: Union[CSG_String, str]) -> int: ...
    @overload
    def asFloat(self, Field: int) -> float: ...
    @overload
    def asFloat(self, Field: Union[CSG_String, str]) -> float: ...
    @overload
    def asDouble(self, Field: int) -> float: ...
    @overload
    def asDouble(self, Field: Union[CSG_String, str]) -> float: ...
    def Get_Value(self, Field: int) -> CSG_Table_Value: ...
    def Assign(self, pRecord: CSG_Table_Record) -> bool: ...
    def is_Selected(self) -> bool: ...
    def is_Modified(self) -> bool: ...

class CSG_Table(CSG_Data_Object):
    thisown: bool
    @overload
    def __init__(self) -> CSG_Table: ...
    @overload
    def __init__(self, Table: CSG_Table) -> CSG_Table: ...
    @overload
    def __init__(self, File: Union[CSG_String, str], Format: TSG_Table_File_Type = TSG_Table_File_Type.TABLE_FILETYPE_Undefined, Encoding: int = TSG_File_Flags_Encoding.SG_FILE_ENCODING_UNDEFINED) -> CSG_Table: ...
    @overload
    def __init__(self, File: Union[CSG_String, str], Format: TSG_Table_File_Type, Separator: str, Encoding: int = TSG_File_Flags_Encoding.SG_FILE_ENCODING_UNDEFINED) -> CSG_Table: ...
    @overload
    def Create(self) -> bool: ...
    @overload
    def Create(self, Table: CSG_Table) -> bool: ...
    @overload
    def Create(self, File: Union[CSG_String, str], Format: TSG_Table_File_Type = TSG_Table_File_Type.TABLE_FILETYPE_Undefined, Encoding: int = TSG_File_Flags_Encoding.SG_FILE_ENCODING_UNDEFINED) -> bool: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    def Get_ObjectType(self) -> TSG_Data_Object_Type: ...
    @overload
    def Assign_Values(self, Table: CSG_Table) -> bool: ...
    @overload
    def Assign_Values(self, File: str) -> bool: ...
    def Assign_Values(self, *args) -> bool: ...
    def Load(self, File: CSG_String, Format: int, Separator: str, Encoding: int = TSG_File_Flags_Encoding.SG_FILE_ENCODING_UNDEFINED) -> bool: ...
    @overload
    def Save(self, File: Union[CSG_String, str], Format: int = 0) -> bool: ...
    @overload
    def Save(self, File: Union[CSG_String, str], Format: int, Separator: str, Encoding: int = TSG_File_Flags_Encoding.SG_FILE_ENCODING_UNDEFINED) -> bool: ...
    def Set_File_Encoding(self, Encoding: int) -> bool: ...
    def Get_File_Encoding(self) -> int: ...
    def from_Text(self, Text: CSG_String) -> bool: ...
    def to_Text(self, Selection: bool = False, Header: bool = True) -> CSG_String: ...
    def Serialize(self, Stream: CSG_File, bSave: bool) -> bool: ...
    def is_Valid(self) -> bool: ...
    def is_Compatible(self, Table: CSG_Table, bExactMatch: bool = False) -> bool: ...
    def Get_Extent(self) -> CSG_Rect: ...
    @overload
    def Add_Field(self, Name: Union[CSG_String, str], Type: TSG_Data_Type, Position: int = -1) -> bool: ...
    def Del_Field(self, Field: int) -> bool: ...
    def Mov_Field(self, Field: int, Position: int) -> bool: ...
    def Get_Field_Count(self) -> int: ...
    def Get_Field_Name(self, Field: int) -> str: ...
    def Get_Field_Type(self, Field: int) -> TSG_Data_Type: ...
    def is_Field_Numeric(self, Field: int) -> bool: ...
    def Get_Field_Length(self, Field: int , Encoding: TSG_File_Flags_Encoding = TSG_File_Flags_Encoding.SG_FILE_ENCODING_UNDEFINED) -> int: ...
    @overload
    def Get_Field(self, Name: Union[CSG_String, str]) -> int: ...
    def Set_Field_Name(self, Field: int, Name: str) -> bool: ...
    def Set_Field_Type(self, Field: int, Type: TSG_Data_Type) -> bool: ...
    @overload
    def Find_Field(self, Name: Union[CSG_String, str]) -> int: ...
    @overload
    def Find_Field(self, Name: Union[CSG_String, str], Index: int) -> bool: ...
    def Get_N(self, Field: int) -> int: ...
    def Get_Minimum(self, Field: int) -> float: ...
    def Get_Maximum(self, Field: int) -> float: ...
    def Get_Range(self, Field: int) -> float: ...
    def Get_Sum(self, Field: int) -> float: ...
    def Get_Mean(self, Field: int) -> float: ...
    def Get_StdDev(self, Field: int) -> float: ...
    def Get_Variance(self, Field: int) -> float: ...
    def Get_Statistics(self, Field: int) -> CSG_Simple_Statistics: ...
    def Get_Histogram(self, Field: int, nClasses: int = 0) -> CSG_Histogram: ...
    def Add_Record(self, pCopy: CSG_Table_Record = None) -> CSG_Table_Record: ...
    def Ins_Record(self, Index: int, pCopy: CSG_Table_Record = None) -> CSG_Table_Record: ...
    def Set_Record(self, Index: int, pCopy: CSG_Table_Record) -> bool: ...
    def Del_Record(self, Index: int) -> bool: ...
    def Del_Records(self) -> bool: ...
    def Set_Count(self, nRecords: int) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Record(self, Index: int) -> CSG_Table_Record: ...
    def Get_Index(self, Index: int) -> int: ...
    def Get_Record_byIndex(self, Index: int) -> CSG_Table_Record: ...
    @overload
    def Find_Record(self, Index: int, Field: int, Value: Union[CSG_String, float], bCreateIndex: bool = False) -> bool: ...
    @overload
    def Find_Record(self, Field: int, Value: Union[CSG_String, float], bCreateIndex: bool = False) -> CSG_Table_Record: ...
    @overload
    def Set_Value(self, Index: int, Field: int, Value: Union[str, float]) -> bool: ...
    @overload
    def Get_Value(self, Index: int, Field: int, Value: Union[CSG_String, float]) -> bool: ...
    def Set_Modified(self, bModified: bool = True) -> None: ...
    def Get_Selection_Count(self) -> int: ...
    def Get_Selection_Index(self, Index: int = 0) -> int: ...
    def Get_Selection(self, Index: int = 0) -> CSG_Table_Record: ...
    def is_Selected(self, Index: int) -> bool: ...
    @overload
    def Select(self, Index: int, bInvert: bool = False) -> bool: ...
    @overload
    def Select(self, pRecord: CSG_Table_Record = None, bInvert: bool = False) -> bool: ...
    def Del_Selection(self) -> int: ...
    def Inv_Selection(self) -> int: ...
    @overload
    def Sort(self, Field: Union[CSG_String, str, int], bAscending: bool = True) -> bool: ...
    @overload
    def Sort(self, Index: CSG_Index) -> bool: ...
    @overload
    def Set_Index(self, Index: CSG_Index, Field: int, bAscending: bool = True) -> bool: ...
    @overload
    def Set_Index(self, Index: CSG_Index, Fields: List[int], nFields: int, bAscending: bool = True) -> bool: ...
    @overload
    def Set_Index(self, Index: CSG_Index, Fields: CSG_Array_Int, bAscending: bool = True) -> bool: ...
    @overload
    def Set_Index(self, Field: int, Order: TSG_Table_Index_Order = TSG_Table_Index_Order.TABLE_INDEX_Ascending, Field_2: int = -1, Order_2: TSG_Table_Index_Order = TSG_Table_Index_Order.TABLE_INDEX_None, Field_3: int = -1, Order_3: TSG_Table_Index_Order = TSG_Table_Index_Order.TABLE_INDEX_None) -> bool: ...
    def Del_Index(self) -> bool: ...
    def Toggle_Index(self, Field: int) -> bool: ...
    def is_Indexed(self) -> bool: ...
    def Get_Index_Field(self, i: int) -> int: ...
    def Get_Index_Order(self, i: int) -> TSG_Table_Index_Order: ...

@overload
def SG_Create_Table() -> CSG_Table: ...
@overload
def SG_Create_Table(Table: CSG_Table) -> CSG_Table: ...
@overload
def SG_Create_Table(File: Union[CSG_String, str], Format: TSG_Table_File_Type = TSG_Table_File_Type.TABLE_FILETYPE_Undefined, Encoding: int = TSG_File_Flags_Encoding.SG_FILE_ENCODING_UNDEFINED) -> CSG_Table: ...
@overload
def SG_Create_Table(File: Union[CSG_String, str], Format: TSG_Table_File_Type, Separator: str, Encoding: int = TSG_File_Flags_Encoding.SG_FILE_ENCODING_UNDEFINED) -> CSG_Table: ...


GRID_PYRAMID_Mean: int
GRID_PYRAMID_Max: int
GRID_PYRAMID_Min: int
GRID_PYRAMID_MaxCount: int

TSG_Grid_Pyramid_Generalisation: TypeAlias = Literal[
    0,  # GRID_PYRAMID_Mean
    1,  # GRID_PYRAMID_Max
    2,  # GRID_PYRAMID_Min
    3,  # GRID_PYRAMID_MaxCount
]

GRID_PYRAMID_Arithmetic: int
GRID_PYRAMID_Geometric: int

TSG_Grid_Pyramid_Grow_Type: TypeAlias = Literal[
    0,  # GRID_PYRAMID_Arithmetic
    1,  # GRID_PYRAMID_Geometric
]

class CSG_Grid_Pyramid:
    thisown: bool
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> bool: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Grid(self, iLevel) -> CSG_Grid: ...

GRID_FILE_FORMAT_Undefined: int
GRID_FILE_FORMAT_Binary_old: int
GRID_FILE_FORMAT_Binary: int
GRID_FILE_FORMAT_ASCII: int
GRID_FILE_FORMAT_Compressed: int
GRID_FILE_FORMAT_GeoTIFF: int

TSG_Grid_File_Format: TypeAlias = Literal[
    0,  # GRID_FILE_FORMAT_Undefined
    1,  # GRID_FILE_FORMAT_Binary_old
    2,  # GRID_FILE_FORMAT_Binary
    3,  # GRID_FILE_FORMAT_ASCII
    4,  # GRID_FILE_FORMAT_Compressed
    5,  # GRID_FILE_FORMAT_GeoTIFF
]

GRID_FILE_KEY_NAME: int
GRID_FILE_KEY_DESCRIPTION: int
GRID_FILE_KEY_UNITNAME: int
GRID_FILE_KEY_DATAFILE_NAME: int
GRID_FILE_KEY_DATAFILE_OFFSET: int
GRID_FILE_KEY_DATAFORMAT: int
GRID_FILE_KEY_BYTEORDER_BIG: int
GRID_FILE_KEY_POSITION_XMIN: int
GRID_FILE_KEY_POSITION_YMIN: int
GRID_FILE_KEY_CELLCOUNT_X: int
GRID_FILE_KEY_CELLCOUNT_Y: int
GRID_FILE_KEY_CELLSIZE: int
GRID_FILE_KEY_Z_FACTOR: int
GRID_FILE_KEY_Z_OFFSET: int
GRID_FILE_KEY_NODATA_VALUE: int
GRID_FILE_KEY_TOPTOBOTTOM: int
GRID_FILE_KEY_Count: int

TSG_Grid_File_Key: TypeAlias = Literal[
    0,  # GRID_FILE_KEY_NAME
    1,  # GRID_FILE_KEY_DESCRIPTION
    2,  # GRID_FILE_KEY_UNITNAME
    3,  # GRID_FILE_KEY_DATAFILE_NAME
    4,  # GRID_FILE_KEY_DATAFILE_OFFSET
    5,  # GRID_FILE_KEY_DATAFORMAT
    6,  # GRID_FILE_KEY_BYTEORDER_BIG
    7,  # GRID_FILE_KEY_POSITION_XMIN
    8,  # GRID_FILE_KEY_POSITION_YMIN
    9,  # GRID_FILE_KEY_CELLCOUNT_X
    10, # GRID_FILE_KEY_CELLCOUNT_Y
    11, # GRID_FILE_KEY_CELLSIZE
    12, # GRID_FILE_KEY_Z_FACTOR
    13, # GRID_FILE_KEY_Z_OFFSET
    14, # GRID_FILE_KEY_NODATA_VALUE
    15, # GRID_FILE_KEY_TOPTOBOTTOM
    16, # GRID_FILE_KEY_Count
]

GRID_FILE_KEY_TRUE: str
GRID_FILE_KEY_FALSE: str

CSG_Grid_Resampling_NearestNeighbour: int
CSG_Grid_Resampling_Bilinear: int
CSG_Grid_Resampling_Bicubic_1: int
CSG_Grid_Resampling_Bicubic_2: int
CSG_Grid_Resampling_Mean_Nodes: int
CSG_Grid_Resampling_Mean_Cells: int
CSG_Grid_Resampling_Minimum: int
CSG_Grid_Resampling_Maximum: int
CSG_Grid_Resampling_Majority: int
CSG_Grid_Resampling_Interpolations: int
CSG_Grid_Resampling_Means: int
CSG_Grid_Resampling_Extremes: int
CSG_Grid_Resampling_Aggregations: int
CSG_Grid_Resampling_All: int
CSG_Grid_Resampling_Undefined: int

CSG_Grid_Resampling: TypeAlias = Literal[
    0x001,  # NearestNeighbour
    0x002,  # Bilinear
    0x004,  # Bicubic_1
    0x008,  # Bicubic_2
    0x010,  # Mean_Nodes
    0x020,  # Mean_Cells
    0x040,  # Minimum
    0x080,  # Maximum
    0x100,  # Majority
    0x000   # Undefined
]

GRID_OPERATION_Addition: int
GRID_OPERATION_Subtraction: int
GRID_OPERATION_Multiplication: int
GRID_OPERATION_Division: int

TSG_Grid_Operation: TypeAlias = Literal[
    0,  # GRID_OPERATION_Addition
    1,  # GRID_OPERATION_Subtraction
    2,  # GRID_OPERATION_Multiplication
    3,  # GRID_OPERATION_Division
]

class CSG_Grid_System:
    thisown: bool
    @overload
    def __init__(self) -> CSG_Grid_System: ...
    @overload
    def __init__(self, System: CSG_Grid_System, Precision: int = -1) -> CSG_Grid_System: ...
    @overload
    def __init__(self, Cellsize: float, Extent: CSG_Rect, Precision: int = -1) -> CSG_Grid_System: ...
    @overload
    def __init__(self, Cellsize: float, xMin: float, yMin: float, xMax: float, yMax: float, Precision: int = -1) -> CSG_Grid_System: ...
    @overload
    def __init__(self, Cellsize: float, xMin: float, yMin: float, NX: int, NY: int, Precision: int = -1) -> CSG_Grid_System: ...
    @overload
    def __init__(self, System: CSG_String, Precision: int = -1) -> CSG_Grid_System: ...
    @overload
    def Create(self, System: CSG_Grid_System, Precision: int = -1) -> bool: ...
    @overload
    def Create(self, Cellsize: float, Extent: CSG_Rect, Precision: int = -1) -> bool: ...
    @overload
    def Create(self, Cellsize: float, xMin: float, yMin: float, xMax: float, yMax: float, Precision: int = -1) -> bool: ...
    @overload
    def Create(self, Cellsize: float, xMin: float, yMin: float, NX: int, NY: int, Precision: int = -1) -> bool: ...
    @overload
    def Create(self, System: CSG_String, Precision: int = -1) -> bool: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    @overload
    def Assign(self, System: CSG_Grid_System) -> bool: ...
    @overload
    def Assign(self, Cellsize: float, Extent: CSG_Rect) -> bool: ...
    @overload
    def Assign(self, Cellsize: float, xMin: float, yMin: float, xMax: float, yMax: float) -> bool: ...
    @overload
    def Assign(self, Cellsize: float, xMin: float, yMin: float, NX: int, NY: int) -> bool: ...
    def is_Valid(self) -> bool: ...
    def Get_Name(self, bShort: bool = True) -> str: ...
    def asString(self) -> str: ...
    def Get_Cellsize(self) -> float: ...
    def Get_Cellarea(self) -> float: ...
    def Get_NX(self) -> int: ...
    def Get_NY(self) -> int: ...
    def Get_NCells(self) -> int: ...
    def Get_Extent(self, bCells: bool = False) -> CSG_Rect: ...
    def Get_XMin(self, bCells: bool = False) -> float: ...
    def Get_XMax(self, bCells: bool = False) -> float: ...
    def Get_XRange(self, bCells: bool = False) -> float: ...
    def Get_YMin(self, bCells: bool = False) -> float: ...
    def Get_YMax(self, bCells: bool = False) -> float: ...
    def Get_YRange(self, bCells: bool = False) -> float: ...
    def __eq__(self, System: CSG_Grid_System) -> bool: ...
    def __ne__(self, System: CSG_Grid_System) -> bool: ...
    @overload
    def is_Equal(self, System: CSG_Grid_System) -> bool: ...
    @overload
    def is_Equal(self, Cellsize: float, Extent: CSG_Rect) -> bool: ...
    def Fit_xto_Grid_System(self, x: float) -> float: ...
    def Fit_yto_Grid_System(self, y: float) -> float: ...
    def Fit_to_Grid_System(self, ptWorld: TSG_Point) -> TSG_Point: ...
    def Get_xGrid_to_World(self, xGrid: int) -> float: ...
    def Get_yGrid_to_World(self, yGrid: int) -> float: ...
    def Get_Grid_to_World(self, xGrid: int, yGrid: int) -> TSG_Point: ...
    def Get_xWorld_to_Grid(self, xWorld: float) -> int: ...
    def Get_yWorld_to_Grid(self, yWorld: float) -> int: ...
    @overload
    def Get_World_to_Grid(self, xGrid: int, yGrid: int, xWorld: float, yWorld: float) -> bool: ...
    @overload
    def Get_World_to_Grid(self, xGrid: int, yGrid: int, ptWorld: TSG_Point) -> bool: ...
    def Get_Neighbor_Pos(self, Direction: int, x: int, y: int, xPos: int, yPos: int) -> bool: ...
    @staticmethod
    def Get_xTo(Direction, x: int = 0) -> int: ...
    @staticmethod
    def Get_yTo(Direction, y: int = 0) -> int: ...
    @staticmethod
    def Get_xFrom(Direction, x: int = 0) -> int: ...
    @staticmethod
    def Get_yFrom(Direction, y: int = 0) -> int: ...
    def Get_xToSave(self, Direction: int, x: int) -> int: ...
    def Get_yToSave(self, Direction: int, y: int) -> int: ...
    def Get_xFromSave(self, Direction: int, x: int) -> int: ...
    def Get_yFromSave(self, Direction: int, y: int) -> int: ...
    @overload
    def is_InGrid(self, x: int, y: int) -> bool: ...
    @overload
    def is_InGrid(self, x: int, y: int, Rand: int) -> bool: ...
    def Get_Length(self, Direction: int) -> float: ...
    @staticmethod
    def Get_UnitLength(Direction: int) -> float: ...
    @staticmethod
    def Set_Precision(Decimals: int) -> int: ...
    @staticmethod
    def Get_Precision() -> int: ...
    def Get_IndexFromRowCol(self, x: int, y: int) -> int: ...
    def Get_RowColFromIndex(self, x: int, y: int, i: int) -> int: ...

gSG_Grid_File_Key_Names: Incomplete

class CSG_Grid_File_Info:
    thisown: bool
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> bool: ...
    @staticmethod
    def Save(*args) -> bool: ...
    def Save_AUX_XML(self, *args) -> bool: ...
    m_bFlip: bool
    m_bSwapBytes: bool
    m_Offset: int
    m_zScale: float
    m_zOffset: float
    m_NoData: float
    m_Type: TSG_Data_Type
    m_Name: CSG_String
    m_Description: CSG_String
    m_Unit: CSG_String
    m_Data_File: CSG_String
    m_System: CSG_Grid_System
    m_Projection: CSG_Projection
    __swig_destroy__: callable

class CSG_Grid(CSG_Data_Object):
    thisown: bool
    @overload
    def __init__(self) -> CSG_Grid: ...
    @overload
    def __init__(self, Grid: CSG_Grid) -> CSG_Grid: ...
    @overload
    def __init__(self, File: Union[CSG_String, str], Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined, bCached: bool = False, bLoadData: bool = True) -> CSG_Grid: ...
    @overload
    def __init__(self, pGrid: CSG_Grid, Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined, bCached: bool = False) -> CSG_Grid: ...
    @overload
    def __init__(self, System: CSG_Grid_System, Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined, bCached: bool = False) -> CSG_Grid: ...
    @overload
    def __init__(self, Type: TSG_Data_Type, NX: int, NY: int, Cellsize: float = 1.0, xMin: float = 0.0, yMin: float = 0.0, bCached: bool = False) -> CSG_Grid: ...
    @overload
    def Create(self, Grid: CSG_Grid) -> bool: ...
    @overload
    def Create(self, File: Union[CSG_String, str], Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined, bCached: bool = False, bLoadData: bool = True) -> bool: ...
    @overload
    def Create(self, pGrid: CSG_Grid, Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined, bCached: bool = False) -> bool: ...
    @overload
    def Create(self, System: CSG_Grid_System, Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined, bCached: bool = False) -> bool: ...
    @overload
    def Create(self, Type: TSG_Data_Type, NX: int, NY: int, Cellsize: float = 1.0, xMin: float = 0.0, yMin: float = 0.0, bCached: bool = False) -> bool: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    @overload
    def Save(self, File: Union[CSG_String, str] , Format: int = 0) -> bool: ...
    def Get_ObjectType(self) -> TSG_Data_Object_Type: ...
    def Get_Type(self) -> TSG_Data_Type: ...
    def Get_nValueBytes(self) -> int: ...
    def Get_nLineBytes(self) -> int: ...
    def Set_Unit(self, Unit: CSG_String) -> None: ...
    def Get_Unit(self) -> CSG_String: ...
    def Get_System(self) -> CSG_Grid_System: ...
    def Get_NX(self) -> int: ...
    def Get_NY(self) -> int: ...
    def Get_NCells(self) -> int: ...
    def Get_Cellsize(self) -> float: ...
    def Get_Cellarea(self) -> float: ...
    @overload
    def Get_Extent(self) -> CSG_Rect: ...
    @overload
    def Get_Extent(self, bCells: bool = False) -> CSG_Rect: ...
    def Get_XMin(self, bCells: bool = False) -> float: ...
    def Get_XMax(self, bCells: bool = False) -> float: ...
    def Get_XRange(self, bCells: bool = False) -> float: ...
    def Get_YMin(self, bCells: bool = False) -> float: ...
    def Get_YMax(self, bCells: bool = False) -> float: ...
    def Get_YRange(self, bCells: bool = False) -> float: ...
    def Set_Scaling(self, Scale: float = 1.0, Offset: float = 0.0) -> None: ...
    def Get_Scaling(self) -> float: ...
    def Get_Offset(self) -> float: ...
    def is_Scaled(self) -> bool: ...
    def Get_Mean(self) -> float: ...
    def Get_Min(self) -> float: ...
    def Get_Max(self) -> float: ...
    def Get_Range(self) -> float: ...
    def Get_StdDev(self) -> float: ...
    def Get_Variance(self) -> float: ...
    def Get_Quantile(self, Quantile: float, bFromHistogram: bool = True) -> float: ...
    def Get_Percentile(self, Percentile: float, bFromHistogram: bool = True) -> float: ...
    @overload
    def Get_Statistics(self) -> CSG_Simple_Statistics: ...
    @overload
    def Get_Statistics(self, rWorld: CSG_Rect, Statistics: CSG_Simple_Statistics, bHoldValues: bool = False) -> bool: ...
    @overload
    def Get_Histogram(self, nClasses: int = 0) -> CSG_Histogram: ...
    @overload
    def Get_Histogram(self, rWorld: CSG_Rect, Histogram: CSG_Histogram, nClasses: int = 0) -> bool: ...
    def Get_Data_Count(self) -> int: ...
    def Get_NoData_Count(self) -> int: ...
    def is_Valid(self) -> bool: ...
    @overload
    def is_Intersecting(self, Extent: CSG_Rect) -> TSG_Intersection: ...
    @overload
    def is_Intersecting(self, Extent: TSG_Rect) -> TSG_Intersection: ...
    @overload
    def is_Intersecting(self, xMin: float, yMin: float, xMax: float, yMax: float) -> TSG_Intersection: ...
    @overload
    def is_Compatible(self, pGrid: CSG_Grid) -> bool: ...
    @overload
    def is_Compatible(self, System: CSG_Grid_System) -> bool: ...
    @overload
    def is_Compatible(self, NX: int, NY: int, Cellsize: float, xMin: float, yMin: float) -> bool: ...
    def is_InGrid(self, x: int, y: int, bCheckNoData: bool = True) -> bool: ...
    @overload
    def is_InGrid_byPos(self, x: float, y: float, bCheckNoData: bool = True) -> bool: ...
    @overload
    def is_InGrid_byPos(self, p: TSG_Point, bCheckNoData: bool = True) -> bool: ...
    def Get_Memory_Size(self) -> int: ...
    def Get_Memory_Size_MB(self) -> float: ...
    def Set_Cache(self, bOn) -> bool: ...
    def is_Cached(self) -> bool: ...
    def Assign_NoData(self) -> bool: ...
    @overload
    def Assign(self, Value: float = 0.0) -> bool: ...
    @overload
    def Assign(self, pObject: CSG_Data_Object, bProgress: bool = False) -> bool: ...
    @overload
    def Assign(self, pGrids: CSG_Grid, Method: CSG_Grid_Resampling, bProgress: bool = False) -> bool: ...
    def Flip(self) -> None: ...
    def Mirror(self) -> None: ...
    def Invert(self) -> None: ...
    def Normalise(self) -> bool: ...
    def DeNormalise(self, Minimum: float, Maximum: float) -> bool: ...
    def Standardise(self) -> bool: ...
    def DeStandardise(self, Mean: float, StdDev: float) -> bool: ...
    def Get_Gradient_NeighborDir(self, x: int, y: int, bDown: bool = True, bNoEdges: bool = True) -> int: ...
    @overload
    def Get_Gradient(self, x: int, y: int, Slope: float, Aspect: float) -> bool: ...
    @overload
    def Get_Gradient(self, x: float, y: float, Slope: float, Aspect: float, Interpolation: CSG_Grid_Resampling) -> bool: ...
    @overload
    def Get_Gradient(self, p: TSG_Point, Slope: float, Aspect: float, Interpolation: CSG_Grid_Resampling) -> bool: ...
    def Set_Modified(self, bModified: bool = True) -> None: ...
    def Set_Index(self, bOn: bool = True) -> bool: ...
    @overload
    def Get_Sorted(self, Position: int, bDown: bool = True, bCheckNoData: bool = True) -> int: ...
    @overload
    def Get_Sorted(self, Position: int, i: int, bDown: bool = True, bCheckNoData: bool = True) -> bool: ...
    @overload
    def Get_Sorted(self, Position: int, x: int, y: int, bDown: bool = True, bCheckNoData: bool = True) -> bool: ...
    @overload
    def is_NoData(self, x: int, y: int) -> bool: ...
    @overload
    def is_NoData(self, i: int) -> bool: ...
    @overload
    def Set_NoData(self, x: int, y: int) -> None: ...
    @overload
    def Set_NoData(self, i: int) -> None: ...
    def __add__(self, other: Union[CSG_Grid, float]) -> CSG_Grid: ...
    def __iadd__(self, other: Union[CSG_Grid, float]) -> CSG_Grid: ...
    def Add(self, other: Union[CSG_Grid, float]) -> CSG_Grid: ...
    def __sub__(self, other: Union[CSG_Grid, float]) -> CSG_Grid: ...
    def __isub__(self, other: Union[CSG_Grid, float]) -> CSG_Grid: ...
    def Subtract(self, other: Union[CSG_Grid, float]) -> CSG_Grid: ...
    def __mul__(self, other: Union[CSG_Grid, float]) -> CSG_Grid: ...
    def __imul__(self, other: Union[CSG_Grid, float]) -> CSG_Grid: ...
    def Multiply(self, other: Union[CSG_Grid, float]) -> CSG_Grid: ...
    def __truediv__(self, other: Union[CSG_Grid, float]) -> CSG_Grid: ...
    __div__ = __truediv__
    def __itruediv__(self, other: Union[CSG_Grid, float]) -> CSG_Grid: ...
    __idiv__ = __itruediv__
    def Divide(self, other: Union[CSG_Grid, float]) -> CSG_Grid: ...
    def __call__(self, x: int, y: int) -> float: ...
    @overload
    def Get_Value(self, x: float, y: float, Resampling: CSG_Grid_Resampling = CSG_Grid_Resampling.CSG_Grid_Resampling_Bicubic_2, bByteWise: bool = False) -> float: ...
    @overload
    def Get_Value(self, p: TSG_Point, Resampling: CSG_Grid_Resampling = CSG_Grid_Resampling.CSG_Grid_Resampling_Bicubic_2, bByteWise: bool = False) -> float: ...
    @overload
    def asByte(self, x: int, y: int, bScaled: bool = True) -> int: ...
    @overload
    def asByte(self, i: int, bScaled: bool = True) -> int: ...
    @overload
    def asChar(self, x: int, y: int, bScaled: bool = True) -> int: ...
    @overload
    def asChar(self, i: int, bScaled: bool = True) -> int: ...
    @overload
    def asShort(self, x: int, y: int, bScaled: bool = True) -> int: ...
    @overload
    def asShort(self, i: int, bScaled: bool = True) -> int: ...
    @overload
    def asInt(self, x: int, y: int, bScaled: bool = True) -> int: ...
    @overload
    def asInt(self, i: int, bScaled: bool = True) -> int: ...
    @overload
    def asLong(self, x: int, y: int, bScaled: bool = True) -> int: ...
    @overload
    def asLong(self, i: int, bScaled: bool = True) -> int: ...
    @overload
    def asFloat(self, x: int, y: int, bScaled: bool = True) -> float: ...
    @overload
    def asFloat(self, i: int, bScaled: bool = True) -> float: ...
    @overload
    def asDouble(self, x: int, y: int, bScaled: bool = True) -> float: ...
    @overload
    def asDouble(self, i: int, bScaled: bool = True) -> float: ...
    @overload
    def Add_Value(self, x: int, y: int, Value: float) -> None: ...
    @overload
    def Add_Value(self, i: int, Value: float) -> None: ...
    @overload
    def Mul_Value(self, x: int, y: int, Value: float) -> None: ...
    @overload
    def Mul_Value(self, i: int, Value: float) -> None: ...
    @overload
    def Set_Value(self, i: int, Value: float, bScaled: bool = True) -> None: ...
    @overload
    def Set_Value(self, x: int, y: int, Value: float, bScaled: bool = True) -> None: ...
    def Get_Row(self, y: int) -> CSG_Vector: ...
    def Set_Row(self, y: int, Values: CSG_Vector) -> bool: ...

@overload
def SG_Create_Grid() -> CSG_Grid: ...
@overload
def SG_Create_Grid(Grid: CSG_Grid) -> CSG_Grid: ...
@overload
def SG_Create_Grid(File: Union[CSG_String, str], Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined, bCached: bool = False, bLoadData: bool = True) -> CSG_Grid: ...
@overload
def SG_Create_Grid(pGrid: CSG_Grid, Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined, bCached: bool = False) -> CSG_Grid: ...
@overload
def SG_Create_Grid(System: CSG_Grid_System, Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined, bCached: bool = False) -> CSG_Grid: ...
@overload
def SG_Create_Grid(Type: TSG_Data_Type, NX: int, NY: int, Cellsize: float = 0.0, xMin: float = 0.0, yMin: float = 0.0, bCached: bool = False) -> CSG_Grid: ...

def SG_Grid_Cache_Get_Directory() -> str: ...
def SG_Grid_Cache_Set_Directory(Directory: str) -> None: ...
def SG_Grid_Cache_Set_Mode(Mode: int) -> None: ...
def SG_Grid_Cache_Get_Mode() -> int: ...
def SG_Grid_Cache_Set_Threshold(nBytes: int) -> None: ...
def SG_Grid_Cache_Set_Threshold_MB(nMegabytes: float) -> None: ...
def SG_Grid_Cache_Get_Threshold() -> int: ...
def SG_Grid_Cache_Get_Threshold_MB() -> float: ...
def SG_Grid_Set_File_Format_Default(Format: int) -> bool: ...
def SG_Grid_Get_File_Format_Default() -> TSG_Grid_File_Format: ...
def SG_Grid_Get_File_Extension_Default() -> CSG_String: ...

class CSG_Grid_Stack(CSG_Stack):
    thisown: bool
    def __init__(self) -> CSG_Grid_Stack: ...
    def Push(self, x: int, y: int) -> bool: ...
    def Pop(self, x: int, y: int) -> bool: ...
    __swig_destroy__: callable

SG_GRIDCELLADDR_PARM_SQUARE: int
SG_GRIDCELLADDR_PARM_CIRCLE: int
SG_GRIDCELLADDR_PARM_ANNULUS: int
SG_GRIDCELLADDR_PARM_SECTOR: int
SG_GRIDCELLADDR_PARM_SIZEDBL: int
SG_GRIDCELLADDR_PARM_MAPUNIT: int
SG_GRIDCELLADDR_PARM_WEIGHTING: int
SG_GRIDCELLADDR_PARM_DEFAULT: int

class CSG_Grid_Cell_Addressor:
    thisown: bool
    def __init__(self) -> CSG_Grid_Cell_Addressor: ...
    def Destroy(self) -> bool: ...
    @staticmethod
    def Enable_Parameters(Parameters: CSG_Parameters) -> bool: ...
    @staticmethod
    def Add_Parameters(Parameters: CSG_Parameters, Parent: CSG_String='', Style: int = 0x01 | 0x02) -> bool: ...
    def Set_Parameters(self, Parameters: CSG_Parameters, Type: int = 0) -> bool: ...
    def Get_Weighting(self) -> CSG_Distance_Weighting: ...
    def is_Square(self) -> bool: ...
    def is_Circle(self) -> bool: ...
    def is_Annulus(self) -> bool: ...
    def is_Sector(self) -> bool: ...
    def Set_Radius(self, Radius: float, bSquare: bool = False) -> bool: ...
    @overload
    def Set_Square(self, Parameters: CSG_Parameters) -> bool: ...
    @overload
    def Set_Square(self, Radius: float) -> bool: ...
    @overload
    def Set_Circle(self, Parameters: CSG_Parameters) -> bool: ...
    @overload
    def Set_Circle(self, Radius: float) -> bool: ...
    @overload
    def Set_Annulus(self, Parameters: CSG_Parameters) -> bool: ...
    @overload
    def Set_Annulus(self, Radius_Inner: float, Radius_Outer: float) -> bool: ...
    @overload
    def Set_Sector(self, Parameters: CSG_Parameters) -> bool: ...
    @overload
    def Set_Sector(self, Radius: float, Direction: float, Tolerance: float) -> bool: ...
    def Get_Radius(self, bOuter: bool = True) -> float: ...
    def Get_Radius_Inner(self) -> float: ...
    def Get_Radius_Outer(self) -> float: ...
    def Get_Direction(self) -> float: ...
    def Get_Tolerance(self) -> float: ...
    def Get_Count(self) -> int: ...
    def Get_X(self, Index: int, Offset: int = 0) -> int: ...
    def Get_Y(self, Index: int, Offset: int = 0) -> int: ...
    def Get_Distance(self, Index: int) -> float: ...
    def Get_Weight(self, Index: int) -> float: ...
    def Get_Values(self, Index: int, x: int, y: int, Distance: float, Weight: float, bOffset: bool = False) -> bool: ...
    __swig_destroy__: callable

GRIDS_FILE_FORMAT_Undefined: int
GRIDS_FILE_FORMAT_Normal: int
GRIDS_FILE_FORMAT_Compressed: int
GRIDS_FILE_FORMAT_GeoTIFF: int

TSG_Grids_File_Format: TypeAlias = Literal[
    0,  # GRIDS_FILE_FORMAT_Undefined
    1,  # GRIDS_FILE_FORMAT_Normal
    2,  # GRIDS_FILE_FORMAT_Compressed
    3   # GRIDS_FILE_FORMAT_GeoTIFF
]

SG_GRIDS_NAME_OWNER: int
SG_GRIDS_NAME_INDEX: int
SG_GRIDS_NAME_VALUE: int
SG_GRIDS_NAME_GRID: int

class CSG_Grids(CSG_Data_Object):
    thisown: bool
    __swig_destroy__: callable
    @overload
    def __init__(self) -> CSG_Grids: ...
    @overload
    def __init__(self, Grids: CSG_Grids) -> CSG_Grids: ...
    @overload
    def Create(self, pGrids: CSG_Grids, bCopyData: bool = False) -> CSG_Grids: ...
    @overload
    def Create(self, FileName: Union[CSG_String, str], bLoadData: bool = True) -> CSG_Grids: ...
    @overload
    def Create(self, System: CSG_Grid_System, NZ: int = 0, zMin: float = 0.0, Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined) -> CSG_Grids: ...
    @overload
    def Create(self, System: CSG_Grid_System, Attributes: CSG_Table, zAttribute: int = 0, Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined, bCreateGrids: bool = False) -> CSG_Grids: ...
    @overload
    def Create(self, NX: int, NY: int, NZ: int = 0, Cellsize: float = 0.0, xMin: float = 0.0, yMin: float = 0.0, zMin: float = 0.0, Type: TSG_Data_Type = ...) -> CSG_Grids: ...
    @overload
    def Create(self, Attributes: CSG_Table, zAttribute: int = 0) -> CSG_Grids: ...
    @overload
    def Create(self, Grids: CSG_Grids) -> bool: ...
    @overload
    def Create(self, pGrids: CSG_Grids, bCopyData: bool = False) -> bool: ...
    @overload
    def Create(self, FileName: Union[CSG_String, str], bLoadData: bool = True) -> bool: ...
    @overload
    def Create(self, System: CSG_Grid_System, NZ: int = 0, zMin: float = 0.0, Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined) -> bool: ...
    @overload
    def Create(self, System: CSG_Grid_System, Attributes: CSG_Table, zAttribute: int = 0, Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined, bCreateGrids: bool = False) -> bool: ...
    @overload
    def Create(self, NX: int, NY: int, NZ: int = 0, Cellsize: float = 0.0, xMin: float = 0.0, yMin: float = 0.0, zMin: float = 0.0, Type: TSG_Data_Type = ...) -> bool: ...
    @overload
    def Create(self, Attributes: CSG_Table, zAttribute: int = 0) -> bool: ...
    def Destroy(self) -> bool: ...
    def Load(self, File: CSG_String, bLoadData: bool = True) -> bool: ...
    @overload
    def Save(self, File: Union[CSG_String, str] , Format: int = 0) -> bool: ...
    def Get_ObjectType(self) -> TSG_Data_Object_Type: ...
    def Get_Type(self) -> TSG_Data_Type: ...
    def Get_nValueBytes(self) -> int: ...
    def Get_nLineBytes(self) -> int: ...
    def Set_Unit(self, Unit: CSG_String) -> None: ...
    def Get_Unit(self) -> str: ...
    def Get_System(self) -> CSG_Grid_System: ...
    def Get_NX(self) -> int: ...
    def Get_NY(self) -> int: ...
    def Get_NZ(self) -> int: ...
    def Get_NCells(self) -> int: ...
    def Get_Data_Count(self) -> int: ...
    def Get_NoData_Count(self) -> int: ...
    def Get_Cellsize(self) -> float: ...
    def Get_Cellarea(self) -> float: ...
    @overload
    def Get_Extent(self) -> CSG_Rect: ...
    @overload
    def Get_Extent(self, bCells: bool) -> CSG_Rect: ...
    def Get_XMin(self, bCells: bool = False) -> float: ...
    def Get_XMax(self, bCells: bool = False) -> float: ...
    def Get_XRange(self, bCells: bool = False) -> float: ...
    def Get_YMin(self, bCells: bool = False) -> float: ...
    def Get_YMax(self, bCells: bool = False) -> float: ...
    def Get_YRange(self, bCells: bool = False) -> float: ...
    def Get_ZMin(self, bCells: bool = False) -> float: ...
    def Get_ZMax(self, bCells: bool = False) -> float: ...
    def Get_ZRange(self, bCells: bool = False) -> float: ...
    def Set_Z_Attribute(self, Field: int, bSetNameField: bool = False) -> bool: ...
    def Get_Z_Attribute(self) -> int: ...
    def Set_Z_Name_Field(self, Field: int) -> bool: ...
    def Get_Z_Name_Field(self) -> int: ...
    @overload
    def Add_Attribute(self, Name: Union[CSG_String, str], Type: TSG_Data_Type, Insert: int = -1) -> bool: ...
    def Del_Attribute(self, Field: int) -> bool: ...
    def Get_Attributes_Ptr(self) -> CSG_Table: ...
    @overload
    def Get_Attributes(self) -> CSG_Table: ...
    @overload
    def Get_Attributes(self, i: int) -> CSG_Table_Record: ...
    @overload
    def Set_Attribute(self, i: int, Field: int, Value: CSG_String) -> bool: ...
    @overload
    def Set_Attribute(self, i: int, Field: Union[CSG_String, str], Value: Union[CSG_String, str]) -> bool: ...
    @overload
    def Set_Attribute(self, i: int, Field: int, Value: float) -> bool: ...
    @overload
    def Set_Attribute(self, i: int, Field: Union[CSG_String, str], Value: float) -> bool: ...
    def Set_Z(self, i: int, Value: float) -> bool: ...
    def Get_Z(self, i: int) -> float: ...
    def Update_Z_Order(self) -> bool: ...
    def Set_Grid_Count(self, Count: int) -> bool: ...
    def Get_Grid_Count(self) -> int: ...
    @overload
    def Add_Grid(self, Z: float) -> bool: ...
    @overload
    def Add_Grid(self, Z: float, pGrid: CSG_Grid, bAttach: bool = False) -> bool: ...
    @overload
    def Add_Grid(self, Attributes: CSG_Table_Record) -> bool: ...
    @overload
    def Add_Grid(self, Attributes: CSG_Table_Record, pGrid: CSG_Grid, bAttach: bool = False) -> bool: ...
    def Del_Grid(self, i: int, bDetach: bool = False) -> bool: ...
    def Del_Grids(self, bDetach: bool = False) -> bool: ...
    def Get_Grid(self, i: int) -> CSG_Grid: ...
    def Get_Grid_Ptr(self, i: int) -> CSG_Grid: ...
    def Get_Grid_Name(self, i: int, Style: int = 0) -> CSG_String: ...
    def Get_Memory_Size(self) -> int: ...
    def Set_Scaling(self, Scale: float = 1.0, Offset: float = 0.0) -> None: ...
    def Get_Scaling(self) -> float: ...
    def Get_Offset(self) -> float: ...
    def is_Scaled(self) -> bool: ...
    def Get_Mean(self) -> float: ...
    def Get_Min(self) -> float: ...
    def Get_Max(self) -> float: ...
    def Get_Range(self) -> float: ...
    def Get_StdDev(self) -> float: ...
    def Get_Variance(self) -> float: ...
    def Get_Quantile(self, Quantile: float, bFromHistogram: bool = True) -> float: ...
    def Get_Percentile(self, Percentile: float, bFromHistogram: bool = True) -> float: ...
    @overload
    def Get_Statistics(self) -> CSG_Simple_Statistics: ...
    @overload
    def Get_Statistics(self, rWorld: CSG_Rect, Statistics: CSG_Simple_Statistics, bHoldValues: bool = False) -> bool: ...
    @overload
    def Get_Histogram(self, nClasses: int = 0) -> CSG_Histogram: ...
    @overload
    def Get_Histogram(self, rWorld: CSG_Rect, Histogram: CSG_Histogram, nClasses: int = 0) -> bool: ...
    def Set_Max_Samples(self, Max_Samples: int) -> bool: ...
    def is_Valid(self) -> bool: ...
    @overload
    def is_Intersecting(self, Extent: CSG_Rect) -> TSG_Intersection: ...
    @overload
    def is_Intersecting(self, Extent: TSG_Rect) -> TSG_Intersection: ...
    @overload
    def is_Intersecting(self, xMin: float, yMin: float, xMax: float, yMax: float) -> TSG_Intersection: ...
    @overload
    def is_Compatible(self, pGrid: CSG_Grid) -> bool: ...
    @overload
    def is_Compatible(self, pGrids: CSG_Grids) -> bool: ...
    @overload
    def is_Compatible(self, System: CSG_Grid_System) -> bool: ...
    @overload
    def is_Compatible(self, NX: int, NY: int, Cellsize: float, xMin: float, yMin: float) -> bool: ...
    def is_InGrid(self, x: int, y: int, z: int, bCheckNoData: bool = True) -> bool: ...
    @overload
    def is_InGrid_byPos(self, x: float, y: float, z: float, bCheckNoData: bool = True) -> bool: ...
    @overload
    def is_InGrid_byPos(self, p: TSG_Point_3D, bCheckNoData: bool = True) -> bool: ...
    def Set_Modified(self, bModified: bool = True) -> None: ...
    def is_Modified(self) -> bool: ...
    def Assign_NoData(self) -> bool: ...
    @overload
    def Assign(self, Value: float = 0.0) -> bool: ...
    @overload
    def Assign(self, pObject: CSG_Data_Object, bProgress: bool = False) -> bool: ...
    @overload
    def Assign(self, pGrids: CSG_Grids, Interpolation: CSG_Grid_Resampling, bProgress: bool = False) -> bool: ...
    def __iadd__(self, Value: float) -> CSG_Grids: ...
    def Add(self, Value) -> CSG_Grids: ...
    def __isub__(self, Value: float) -> CSG_Grids: ...
    def Subtract(self, Value: float) -> CSG_Grids: ...
    def __imul__(self, Value: float) -> CSG_Grids: ...
    def Multiply(self, Value: float) -> CSG_Grids: ...
    def __itruediv__(self, Value: float) -> CSG_Grids: ...
    __idiv__ = __itruediv__
    def Divide(self, Value: float) -> CSG_Grids: ...
    def __call__(self, x: int, y: int, z: int) -> float: ...
    def Set_NoData_Value_Range(self, loValue: float, hiValue: float) -> bool: ...
    @overload
    def is_NoData(self, x: int, y: int, z: int) -> bool: ...
    @overload
    def is_NoData(self, i: int) -> bool: ...
    @overload
    def Set_NoData(self, x: int, y: int, z: int) -> None: ...
    @overload
    def Set_NoData(self, i: int) -> None: ...
    @overload
    def Get_Value(self, x: float, y: float, z: float, Resampling: CSG_Grid_Resampling = CSG_Grid_Resampling.CSG_Grid_Resampling_Bicubic_2, ZResampling: CSG_Grid_Resampling = CSG_Grid_Resampling.CSG_Grid_Resampling_Undefined) -> float: ...
    @overload
    def Get_Value(self, p: TSG_Point_3D, Resampling: CSG_Grid_Resampling = CSG_Grid_Resampling.CSG_Grid_Resampling_Bicubic_2, ZResampling: CSG_Grid_Resampling = CSG_Grid_Resampling.CSG_Grid_Resampling_Undefined) -> float: ...
    @overload
    def asByte(self, x: int, y: int, z: int, bScaled: bool = True) -> int: ...
    @overload
    def asByte(self, i: int, bScaled: bool = True) -> int: ...
    @overload
    def asChar(self, x: int, y: int, z: int, bScaled: bool = True) -> int: ...
    @overload
    def asChar(self, i: int, bScaled: bool = True) -> int: ...
    @overload
    def asShort(self, x: int, y: int, z: int, bScaled: bool = True) -> int: ...
    @overload
    def asShort(self, i: int, bScaled: bool = True) -> int: ...
    @overload
    def asInt(self, x: int, y: int, z: int, bScaled: bool = True) -> int: ...
    @overload
    def asInt(self, i: int, bScaled: bool = True) -> int: ...
    @overload
    def asLong(self, x: int, y: int, z: int, bScaled: bool = True) -> int: ...
    @overload
    def asLong(self, i: int, bScaled: bool = True) -> int: ...
    @overload
    def asFloat(self, x: int, y: int, z: int, bScaled: bool = True) -> float: ...
    @overload
    def asFloat(self, i: int, bScaled: bool = True) -> float: ...
    @overload
    def asDouble(self, x: int, y: int, z: int, bScaled: bool = True) -> float: ...
    @overload
    def asDouble(self, i: int, bScaled: bool = True) -> float: ...
    @overload
    def Add_Value(self, x: int, y: int, z: int, Value: float) -> None: ...
    @overload
    def Add_Value(self, i: int, Value: float) -> None: ...
    @overload
    def Mul_Value(self, x: int, y: int, z: int, Value: float) -> None: ...
    @overload
    def Mul_Value(self, i: int, Value: float) -> None: ...
    @overload
    def Set_Value(self, i: int, Value: float, bScaled: bool = True) -> None: ...
    @overload
    def Set_Value(self, x: int, y: int, z: int, Value: float, bScaled: bool = True) -> None: ...
    def Set_Index(self, bOn: bool = True) -> bool: ...
    @overload
    def Get_Sorted(self, Position: int, bDown: bool = True, bCheckNoData: bool = True) -> int: ...
    @overload
    def Get_Sorted(self, Position: int, i: int, bDown: bool = True, bCheckNoData: bool = True) -> bool: ...
    @overload
    def Get_Sorted(self, Position: int, x: int, y: int, z: int, bDown: bool = True, bCheckNoData: bool = True) -> bool: ...

@overload
def SG_Create_Grids() -> CSG_Grids: ...
@overload
def SG_Create_Grids(Grids: CSG_Grids) -> CSG_Grids: ...
@overload
def SG_Create_Grids(pGrids: CSG_Grids, bCopyData: bool = False) -> CSG_Grids: ...
@overload
def SG_Create_Grids(FileName: Union[CSG_String, str], bLoadData: bool = True) -> CSG_Grids: ...
@overload
def SG_Create_Grids(System: CSG_Grid_System, NZ: int = 0, zMin: float = 0.0, Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined) -> CSG_Grids: ...
@overload
def SG_Create_Grids(System: CSG_Grid_System, Attributes: CSG_Table, zAttribute: int = 0, Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined, bCreateGrids: bool = False) -> CSG_Grids: ...
@overload
def SG_Create_Grids( NX: int, NY: int, NZ: int = 0, Cellsize: float = 0.0, xMin: float = 0.0, yMin: float = 0.0, zMin: float = 0.0, Type: TSG_Data_Type = TSG_Data_Type.SG_DATATYPE_Undefined) -> CSG_Grids: ...
@overload
def SG_Create_Grids(Attributes: CSG_Table, zAttribute: int = 0) -> CSG_Grids: ...


SG_VERTEX_TYPE_XY: int
SG_VERTEX_TYPE_XYZ: int
SG_VERTEX_TYPE_XYZM: int

TSG_Vertex_Type: TypeAlias = Literal[
    0,  # SG_VERTEX_TYPE_XY
    1,  # SG_VERTEX_TYPE_XYZ
    2,  # SG_VERTEX_TYPE_XYZM
]

SHAPE_TYPE_Undefined: int
SHAPE_TYPE_Point: int
SHAPE_TYPE_Points: int
SHAPE_TYPE_Line: int
SHAPE_TYPE_Polygon: int

TSG_Shape_Type: TypeAlias = Literal[
    0,  # SHAPE_TYPE_Undefined
    1,  # SHAPE_TYPE_Point
    2,  # SHAPE_TYPE_Points
    3,  # SHAPE_TYPE_Line
    4,  # SHAPE_TYPE_Polygon
]

def SG_Get_ShapeType_Name(Type: TSG_Shape_Type) -> CSG_String: ...

SHAPE_FILE_FORMAT_Undefined: int
SHAPE_FILE_FORMAT_ESRI: int
SHAPE_FILE_FORMAT_GeoPackage: int
SHAPE_FILE_FORMAT_GeoJSON: int

TSG_Shape_File_Format: TypeAlias = Literal[
    0,  # SHAPE_FILE_FORMAT_Undefined
    1,  # SHAPE_FILE_FORMAT_ESRI
    2,  # SHAPE_FILE_FORMAT_GeoPackage
    3,  # SHAPE_FILE_FORMAT_GeoJSON
]

SHAPE_NO_COPY: int
SHAPE_COPY_GEOM: int
SHAPE_COPY_ATTR: int
SHAPE_COPY: int

TSG_ADD_Shape_Copy_Mode: TypeAlias = Literal[
    0,  # SHAPE_NO_COPY
    1,  # SHAPE_COPY_GEOM
    2,  # SHAPE_COPY_ATTR
    3,  # SHAPE_COPY
]

class CSG_Shape(CSG_Table_Record):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Destroy(self) -> None: ...
    @overload
    def Assign(self, pRecord: CSG_Table_Record) -> bool: ...
    @overload
    def Assign(self, pRecord: CSG_Table_Record, bAssign_Attributes: bool) -> bool: ...
    @overload
    def Assign(self, pRecord: CSG_Table_Record, mCopy: TSG_ADD_Shape_Copy_Mode) -> bool: ...
    def Get_Type(self) -> TSG_Shape_Type: ...
    def Get_Vertex_Type(self) -> TSG_Vertex_Type: ...
    def asPoint(self) -> CSG_Shape_Point: ...
    def asPoints(self) -> CSG_Shape_Points: ...
    def asLine(self) -> CSG_Shape_Line: ...
    def asPolygon(self) -> CSG_Shape_Polygon: ...
    @overload
    def Get_Point_Count(self) -> int: ...
    @overload
    def Get_Point_Count(self, iPart: int) -> int: ...
    def Get_Part_Count(self) -> int: ...
    def Add_Part(self, pPart: CSG_Shape_Part, bRevert: bool = False) -> int: ...
    def Get_Part(self, iPart: int) -> CSG_Shape_Part: ...
    def Del_Part(self, iPart: int) -> int: ...
    def Del_Parts(self) -> int: ...
    @overload
    def Add_Point(self, x: float, y: float, iPart: int = 0) -> int: ...
    @overload
    def Add_Point(self, p: CSG_Point, iPart: int = 0) -> int: ...
    @overload
    def Add_Point(self, p: CSG_Point_3D, iPart: int = 0) -> int: ...
    @overload
    def Add_Point(self, p: CSG_Point_4D, iPart: int = 0) -> int: ...
    @overload
    def Ins_Point(self, x: float, y: float, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Ins_Point(self, p: CSG_Point, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Ins_Point(self, p: CSG_Point_3D, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Ins_Point(self, p: CSG_Point_4D, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Set_Point(self, x: float, y: float, iPoint: int = 0, iPart: int = 0) -> int: ...
    @overload
    def Set_Point(self, p: CSG_Point, iPoint: int = 0, iPart: int = 0) -> int: ...
    @overload
    def Set_Point(self, p: CSG_Point_3D, iPoint: int = 0, iPart: int = 0) -> int: ...
    @overload
    def Set_Point(self, p: CSG_Point_4D, iPoint: int = 0, iPart: int = 0) -> int: ...
    def Del_Point(self, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Get_Point(self, iPoint: int = 0) -> TSG_Point: ...
    @overload
    def Get_Point(self, iPoint: int, iPart: int, bAscending: bool = True) -> TSG_Point: ...
    def Set_Z(self, z: float, iPoint: int = 0, iPart: int = 0) -> None: ...
    def Get_Z(self, iPoint: int = 0, iPart: int = 0, bAscending: bool = True) -> float: ...
    def Get_ZMin(self) -> float: ...
    def Get_ZMax(self) -> float: ...
    def Get_Point_Z(self, iPoint: int = 0, iPart: int = 0, bAscending: bool = True) -> TSG_Point_3D: ...
    def Set_M(self, m: float, iPoint: int = 0, iPart: int = 0) -> None: ...
    def Get_M(self, iPoint: int = 0, iPart: int = 0, bAscending: bool = True) -> float: ...
    def Get_MMin(self) -> float: ...
    def Get_MMax(self) -> float: ...
    def Get_Point_ZM(self, iPoint: int = 0, iPart: int = 0, bAscending: bool = True) -> TSG_Point_4D: ...
    @overload
    def Get_Extent(self) -> CSG_Rect: ...
    @overload
    def Get_Extent(self, iPart: int) -> CSG_Rect: ...
    def Get_Centroid(self) -> TSG_Point: ...
    @overload
    def Intersects(self, pShape: CSG_Shape) -> TSG_Intersection: ...
    @overload
    def Intersects(self, Extent: TSG_Rect) -> TSG_Intersection: ...
    @overload
    def Get_Distance(self, Point: TSG_Point) -> float: ...
    @overload
    def Get_Distance(self, Point: TSG_Point, iPart: int) -> float: ...
    @overload
    def Get_Distance(self, Point: TSG_Point, Next: TSG_Point) -> float: ...
    @overload
    def Get_Distance(self, Point: TSG_Point, Next: TSG_Point, iPart: int) -> float: ...
    def Revert_Points(self, iPart: int) -> bool: ...

class CSG_Shape_Point(CSG_Shape):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def is_Valid(self) -> bool: ...
    @overload
    def Get_Point_Count(self) -> int: ...
    @overload
    def Get_Point_Count(self, iPart: int) -> int: ...
    def Get_Part_Count(self) -> int: ...
    @overload
    def Add_Point(self, x: float, y: float, iPart: int = 0) -> int: ...
    @overload
    def Add_Point(self, p: CSG_Point, iPart: int = 0) -> int: ...
    @overload
    def Add_Point(self, p: CSG_Point_3D, iPart: int = 0) -> int: ...
    @overload
    def Add_Point(self, p: CSG_Point_4D, iPart: int = 0) -> int: ...
    @overload
    def Ins_Point(self, x: float, y: float, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Ins_Point(self, p: CSG_Point, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Ins_Point(self, p: CSG_Point_3D, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Ins_Point(self, p: CSG_Point_4D, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Set_Point(self, x: float, y: float, iPoint: int = 0, iPart: int = 0) -> int: ...
    @overload
    def Set_Point(self, p: CSG_Point, iPoint: int = 0, iPart: int = 0) -> int: ...
    @overload
    def Set_Point(self, p: CSG_Point_3D, iPoint: int = 0, iPart: int = 0) -> int: ...
    @overload
    def Set_Point(self, p: CSG_Point_4D, iPoint: int = 0, iPart: int = 0) -> int: ...
    def Del_Point(self, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Get_Point(self, iPoint: int = 0) -> TSG_Point: ...
    @overload
    def Get_Point(self, iPoint: int, iPart: int, bAscending: bool = True) -> TSG_Point: ...
    def Get_Centroid(self) -> TSG_Point: ...
    def Get_Extent(self) -> CSG_Rect: ...
    @overload
    def Get_Distance(self, Point: TSG_Point) -> float: ...
    @overload
    def Get_Distance(self, Point: TSG_Point, iPart: int) -> float: ...
    @overload
    def Get_Distance(self, Point: TSG_Point, Next: TSG_Point) -> float: ...
    @overload
    def Get_Distance(self, Point: TSG_Point, Next: TSG_Point, iPart: int) -> float: ...

class CSG_Shape_Point_Z(CSG_Shape_Point):
    thisown: bool
    def __init__(self, pOwner: CSG_Shapes, Index: int) -> None: ...
    def Set_Z(self, z: float, iPoint: int = 0, iPart: int = 0) -> None: ...
    def Get_Z(self, iPoint: int = 0, iPart: int = 0, bAscending: bool = True) -> float: ...
    def Get_ZMin(self) -> float: ...
    def Get_ZMax(self) -> float: ...
    __swig_destroy__: callable

class CSG_Shape_Point_ZM(CSG_Shape_Point_Z):
    thisown: bool
    def __init__(self, pOwner: CSG_Shapes, Index: int) -> None: ...
    def Set_M(self, m: float, iPoint: int = 0, iPart: int = 0) -> None: ...
    def Get_M(self, iPoint: int = 0, iPart: int = 0, bAscending: bool = True) -> float: ...
    def Get_MMin(self) -> float: ...
    def Get_MMax(self) -> float: ...
    __swig_destroy__: callable

class CSG_Shape_Part:
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Owner(self) -> CSG_Shape_Points: ...
    def Destroy(self) -> bool: ...
    def Assign(self, pPart: CSG_Shape_Part) -> bool: ...
    def Get_Extent(self) -> CSG_Rect: ...
    def Get_Count(self) -> int: ...
    def Get_Point(self, iPoint: int, bAscending: bool = True) -> TSG_Point: ...
    @overload
    def Add_Point(self, x: float, y: float) -> int: ...
    @overload
    def Add_Point(self, p: CSG_Point) -> int: ...
    @overload
    def Add_Point(self, p: CSG_Point_3D) -> int: ...
    @overload
    def Add_Point(self, p: CSG_Point_4D) -> int: ...
    @overload
    def Ins_Point(self, p: CSG_Point_3D, iPoint: int) -> int: ...
    @overload
    def Ins_Point(self, p: CSG_Point_4D, iPoint: int) -> int: ...
    @overload
    def Set_Point(self, x: float, y: float, iPoint: int) -> int: ...
    @overload
    def Set_Point(self, p: CSG_Point, iPoint: int) -> int: ...
    @overload
    def Set_Point(self, p: CSG_Point_3D, iPoint: int) -> int: ...
    @overload
    def Set_Point(self, p: CSG_Point_4D, iPoint: int) -> int: ...
    def Del_Point(self, iPoint: int) -> int: ...
    def Set_Z(self, z: float, iPoint: int) -> None: ...
    def Get_Z(self, iPoint: int, bAscending: bool = True) -> float: ...
    def Get_ZMin(self) -> float: ...
    def Get_ZMax(self) -> float: ...
    def Get_Point_Z(self, iPoint: int, bAscending: bool = True) -> TSG_Point_3D: ...
    def Set_M(self, m: float, iPoint: int) -> None: ...
    def Get_M(self, iPoint: int, bAscending: bool = True) -> float: ...
    def Get_MMin(self) -> float: ...
    def Get_MMax(self) -> float: ...
    def Get_Point_ZM(self, iPoint: int, bAscending: bool = True) -> TSG_Point_4D: ...
    def Add_Points(self, pPoints: CSG_Shape_Part, bAscending: bool = True) -> bool: ...
    def Revert_Points(self) -> bool: ...

class CSG_Shape_Points(CSG_Shape):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Destroy(self) -> bool: ...
    def is_Valid(self) -> bool: ...
    @overload
    def Get_Point_Count(self) -> int: ...
    @overload
    def Get_Point_Count(self, iPart: int) -> int: ...
    def Get_Part_Count(self) -> int: ...
    def Add_Part(self, pPart: CSG_Shape_Part, bRevert: bool = False) -> int: ...
    def Get_Part(self, iPart: int) -> CSG_Shape_Part: ...
    def Del_Part(self, iPart: int) -> int: ...
    def Del_Parts(self) -> int: ...
    @overload
    def Add_Point(self, x: float, y: float, iPart: int = 0) -> int: ...
    @overload
    def Add_Point(self, p: CSG_Point, iPart: int = 0) -> int: ...
    @overload
    def Add_Point(self, p: CSG_Point_3D, iPart: int = 0) -> int: ...
    @overload
    def Add_Point(self, p: CSG_Point_4D, iPart: int = 0) -> int: ...
    @overload
    def Ins_Point(self, x: float, y: float, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Ins_Point(self, p: CSG_Point, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Ins_Point(self, p: CSG_Point_3D, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Ins_Point(self, p: CSG_Point_4D, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Set_Point(self, x: float, y: float, iPoint: int = 0, iPart: int = 0) -> int: ...
    @overload
    def Set_Point(self, p: CSG_Point, iPoint: int = 0, iPart: int = 0) -> int: ...
    @overload
    def Set_Point(self, p: CSG_Point_3D, iPoint: int = 0, iPart: int = 0) -> int: ...
    @overload
    def Set_Point(self, p: CSG_Point_4D, iPoint: int = 0, iPart: int = 0) -> int: ...
    def Del_Point(self, iPoint: int, iPart: int = 0) -> int: ...
    @overload
    def Get_Point(self, iPoint: int = 0) -> TSG_Point: ...
    @overload
    def Get_Point(self, iPoint: int, iPart: int, bAscending: bool = True) -> TSG_Point: ...
    def Set_Z(self, z, iPoint: int = 0, iPart: int = 0) -> None: ...
    def Get_Z(self, iPoint: int = 0, iPart: int = 0, bAscending: bool = True) -> float: ...
    def Get_ZMin(self) -> float: ...
    def Get_ZMax(self) -> float: ...
    def Set_M(self, m, iPoint: int = 0, iPart: int = 0) -> None: ...
    def Get_M(self, iPoint: int = 0, iPart: int = 0, bAscending: bool = True) -> float: ...
    def Get_MMin(self) -> float: ...
    def Get_MMax(self) -> float: ...
    def Get_Extent(self) -> CSG_Rect: ...
    def Get_Centroid(self) -> TSG_Point: ...
    @overload
    def Get_Distance(self, Point: TSG_Point) -> float: ...
    @overload
    def Get_Distance(self, Point: TSG_Point, iPart: int) -> float: ...
    @overload
    def Get_Distance(self, Point: TSG_Point, Next: TSG_Point) -> float: ...
    @overload
    def Get_Distance(self, Point: TSG_Point, Next: TSG_Point, iPart: int) -> float: ...
    def Revert_Points(self, iPart: int) -> bool: ...

class CSG_Shape_Line(CSG_Shape_Points):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def is_Valid(self) -> bool: ...
    def Get_Centroid(self) -> TSG_Point: ...
    @overload
    def Get_Length(self) -> float: ...
    @overload
    def Get_Length(self, iPart: int) -> float: ...
    def Get_Distance(self, Point: TSG_Point, Next: TSG_Point, iPart: int) -> float: ...

SG_POLYGON_POINT_Outside: int
SG_POLYGON_POINT_Vertex: int
SG_POLYGON_POINT_Edge: int
SG_POLYGON_POINT_Interior: int

TSG_Polygon_Point_Relation: TypeAlias = Literal[
    0,  # SG_POLYGON_POINT_Outside
    1,  # SG_POLYGON_POINT_Vertex
    2,  # SG_POLYGON_POINT_Edge
    3   # SG_POLYGON_POINT_Interior
]

class CSG_Shape_Polygon_Part(CSG_Shape_Part):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def is_Clockwise(self) -> bool: ...
    def Get_Perimeter(self) -> float: ...
    def Get_Area(self) -> float: ...
    def Get_Centroid(self) -> TSG_Point: ...
    @overload
    def Get_Point_Relation(self, p: CSG_Point) -> TSG_Polygon_Point_Relation: ...
    @overload
    def Get_Point_Relation(self, x: float, y: float) -> TSG_Polygon_Point_Relation: ...
    @overload
    def is_OnEdge(self, p: CSG_Point) -> bool: ...
    @overload
    def is_OnEdge(self, x: float, y: float) -> bool: ...
    @overload
    def Contains(self, p: CSG_Point) -> bool: ...
    @overload
    def Contains(self, x: float, y: float) -> bool: ...
    def is_Neighbour(self, pPartCSG_Shape_Polygon_Part, bSimpleCheck: bool = True) -> bool: ...
    def Get_Shared_Edges(self, pPart: CSG_Shape_Polygon_Part, bVertexCheck: bool, Epsilon: float = 0.0) -> CSG_Lines: ...
    def Get_Shared_Length(self, pPart: CSG_Shape_Polygon_Part, bVertexCheck: bool, Epsilon: float = 0.0) -> float: ...
    def Get_Distance(self, Point: TSG_Point, Next: TSG_Point) -> float: ...

class CSG_Shape_Polygon(CSG_Shape_Points):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def is_Valid(self) -> bool: ...
    def Get_Polygon_Part(self, iPart: int) -> CSG_Shape_Polygon_Part: ...
    def is_Lake(self, iPart: int) -> bool: ...
    def is_Clockwise(self, iPart: int) -> bool: ...
    @overload
    def Get_Perimeter(self) -> float: ...
    @overload
    def Get_Perimeter(self, iPart: int) -> float: ...
    @overload
    def Get_Area(self) -> float: ...
    @overload
    def Get_Area(self, iPart: int) -> float: ...
    @overload
    def Get_Centroid(self) -> TSG_Point: ...
    @overload
    def Get_Centroid(self, iPart: int) -> TSG_Point: ...
    @overload
    def Get_Point_Relation(self, p: CSG_Point, iPart: int) -> TSG_Polygon_Point_Relation: ...
    @overload
    def Get_Point_Relation(self, x: float, y: float, iPart: int) -> TSG_Polygon_Point_Relation: ...
    @overload
    def Get_Point_Relation(self, p: CSG_Point) -> TSG_Polygon_Point_Relation: ...
    @overload
    def Get_Point_Relation(self, x: float, y: float) -> TSG_Polygon_Point_Relation: ...
    @overload
    def is_OnEdge(self, p: CSG_Point, iPart: int) -> bool: ...
    @overload
    def is_OnEdge(self, x: float, y: float, iPart: int) -> bool: ...
    @overload
    def is_OnEdge(self, p: CSG_Point) -> bool: ...
    @overload
    def is_OnEdge(self, x: float, y: float) -> bool: ...
    @overload
    def Contains(self, p: CSG_Point, iPart: int) -> bool: ...
    @overload
    def Contains(self, x: float, y: float, iPart: int) -> bool: ...
    @overload
    def Contains(self, p: CSG_Point) -> bool: ...
    @overload
    def Contains(self, x: float, y: float) -> bool: ...
    def is_Neighbour(self, pPolygon: CSG_Shape_Polygon, bSimpleCheck: bool = True) -> bool: ...
    def Get_Shared_Edges(self, pPolygon: CSG_Shape_Polygon, bVertexCheck: bool, Epsilon: float = 0.0) -> CSG_Lines: ...
    def Get_Shared_Length(self, pPolygon: CSG_Shape_Polygon, bVertexCheck: bool, Epsilon: float = 0.0) -> float: ...
    def Get_Distance(self, Point: TSG_Point, Next: TSG_Point, iPart: int) -> float: ...

class CSG_Shapes(CSG_Table):
    thisown: bool
    @overload
    def __init__(self) -> CSG_Shapes: ...
    @overload
    def __init__(self, Shapes: CSG_Shapes) -> CSG_Shapes: ...
    @overload
    def __init__(self, File: Union[CSG_String, str]) -> CSG_Shapes: ...
    @overload
    def __init__(self, Type: TSG_Shape_Type, Name: str = None, pTemplate: CSG_Table = None, Vertex_Type: TSG_Vertex_Type = TSG_Vertex_Type.SG_VERTEX_TYPE_XY) -> CSG_Shapes: ...
    @overload
    def Create(self) -> CSG_Shapes: ...
    @overload
    def Create(self, Shapes: CSG_Shapes) -> CSG_Shapes: ...
    @overload
    def Create(self, File: Union[CSG_String, str]) -> CSG_Shapes: ...
    @overload
    def Create(self, Type: TSG_Shape_Type, Name: str = None, pTemplate: CSG_Table = None, Vertex_Type: TSG_Vertex_Type = TSG_Vertex_Type.SG_VERTEX_TYPE_XY) -> CSG_Shapes: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    def Get_ObjectType(self) -> TSG_Data_Object_Type: ...
    def Assign(self, pObject: CSG_Shapes, bProgress: bool = False) -> bool: ...
    @overload
    def Save(self, File: Union[CSG_String, str]) -> bool: ...
    def is_Valid(self) -> bool: ...
    def Get_Type(self) -> TSG_Shape_Type: ...
    def Get_Vertex_Type(self) -> TSG_Vertex_Type: ...
    def Get_Extent(self) -> CSG_Rect: ...
    def Get_ZMin(self) -> float: ...
    def Get_ZMax(self) -> float: ...
    def Get_MMin(self) -> float: ...
    def Get_MMax(self) -> float: ...
    def Add_Shape(self, pCopy: CSG_Table_Record = None, mCopy: TSG_ADD_Shape_Copy_Mode = TSG_ADD_Shape_Copy_Mode.SHAPE_COPY) -> CSG_Shape: ...
    @overload
    def Del_Shape(self, Index: int) -> bool: ...
    @overload
    def Del_Shape(self, pShape: CSG_Shape) -> bool: ...
    def Del_Shapes(self) -> bool: ...
    @overload
    def Get_Shape(self, Point: CSG_Point, Epsilon: float = 0) -> CSG_Shape: ...
    @overload
    def Get_Shape(self, Index: int) -> CSG_Shape: ...
    def Get_Shape_byIndex(self, Index: int) -> CSG_Shape: ...
    def Make_Clean(self) -> bool: ...
    def Get_Selection_Extent(self) -> CSG_Rect: ...
    @overload
    def Select(self, Index: int, bInvert: bool = False) -> bool: ...
    @overload
    def Select(self, pShape: CSG_Table_Record = None, bInvert: bool = False) -> bool: ...
    @overload
    def Select(self, Extent: TSG_Rect, bInvert: bool = False) -> bool: ...
    @overload
    def Select(self, Point: TSG_Point, bInvert: bool = False) -> bool: ...

@overload
def SG_Create_Shapes() -> CSG_Shapes: ...
@overload
def SG_Create_Shapes(Shapes: CSG_Shapes) -> CSG_Shapes: ...
@overload
def SG_Create_Shapes(File: Union[CSG_String, str]) -> CSG_Shapes: ...
@overload
def SG_Create_Shapes(Type: TSG_Shape_Type, Name: str = None, pTemplate: CSG_Table = None, Vertex_Type: TSG_Vertex_Type = TSG_Vertex_Type.SG_VERTEX_TYPE_XY) -> CSG_Shapes: ...

def SG_Shapes_Set_File_Format_Default(Format: int) -> bool: ...
def SG_Shapes_Get_File_Format_Default() -> TSG_Shape_File_Format: ...
def SG_Shapes_Get_File_Extension_Default() -> CSG_String: ...

class CSG_PRQuadTree_Item:
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def is_Leaf(self) -> bool: ...
    def is_Node(self) -> bool: ...
    def has_Statistics(self) -> bool: ...
    def Get_Extent(self) -> CSG_Rect: ...
    def Get_xMin(self) -> float: ...
    def Get_xCenter(self) -> float: ...
    def Get_xMax(self) -> float: ...
    def Get_yMin(self) -> float: ...
    def Get_yCenter(self) -> float: ...
    def Get_yMax(self) -> float: ...
    def Get_Size(self) -> float: ...
    def Contains(self, *args) -> bool: ...
    def asLeaf(self) -> CSG_PRQuadTree_Leaf: ...
    def asNode(self) -> CSG_PRQuadTree_Node: ...

class CSG_PRQuadTree_Leaf(CSG_PRQuadTree_Item):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def is_Leaf(self) -> bool: ...
    def Get_Point(self) -> TSG_Point: ...
    def Get_X(self) -> float: ...
    def Get_Y(self) -> float: ...
    def Get_Z(self) -> float: ...

class CSG_PRQuadTree_Leaf_List(CSG_PRQuadTree_Leaf):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def has_Statistics(self) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Value(self, i) -> float: ...
    def Get_Minimum(self) -> float: ...
    def Get_Maximum(self) -> float: ...
    def Get_Range(self) -> float: ...
    def Get_Sum(self) -> float: ...
    def Get_Mean(self) -> float: ...
    def Get_Variance(self) -> float: ...
    def Get_StdDev(self) -> float: ...

class CSG_PRQuadTree_Node(CSG_PRQuadTree_Item):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def is_Node(self) -> bool: ...
    def Get_Child(self, *args) -> CSG_PRQuadTree_Item: ...
    def Add_Point(self, x, y, z) -> bool: ...
    def Get_X(self) -> CSG_Simple_Statistics: ...
    def Get_Y(self) -> CSG_Simple_Statistics: ...
    def Get_Z(self) -> CSG_Simple_Statistics: ...

class CSG_PRQuadTree_Node_Statistics(CSG_PRQuadTree_Node):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def has_Statistics(self) -> bool: ...
    def Get_X(self) -> CSG_Simple_Statistics: ...
    def Get_Y(self) -> CSG_Simple_Statistics: ...
    def Get_Z(self) -> CSG_Simple_Statistics: ...

class CSG_PRQuadTree:
    thisown: bool
    __swig_destroy__: callable
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> bool: ...
    def Destroy(self) -> None: ...
    def Add_Point(self, *args) -> bool: ...
    def Get_Point_Count(self) -> int: ...
    def Get_Root(self) -> CSG_PRQuadTree_Node: ...
    def Get_Root_Pointer(self) -> CSG_PRQuadTree_Node: ...
    def is_Okay(self) -> bool: ...
    def is_Polar(self) -> bool: ...
    def Set_Polar_Search(self, bOn) -> None: ...
    def Get_Nearest_Leaf(self, *args) -> CSG_PRQuadTree_Leaf: ...
    def Get_Nearest_Point(self, *args) -> bool: ...
    def Get_Nearest_Points(self, *args) -> int: ...
    def Select_Nearest_Points(self, *args) -> int: ...
    def Get_Selected_Count(self) -> int: ...
    def Get_Selected_Leaf(self, i) -> CSG_PRQuadTree_Leaf: ...
    def Get_Selected_Z(self, i) -> float: ...
    def Get_Selected_Distance(self, i) -> float: ...
    def Get_Selected_Point(self, i, x, y, z) -> bool: ...

class CSG_KDTree:
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    __swig_destroy__: callable
    @staticmethod
    def Get_Version() -> str: ...
    def Destroy(self) -> bool: ...
    def is_Okay(self) -> bool: ...
    def Get_Match_Count(self) -> int: ...
    def Get_Match_Index(self, i) -> int: ...
    def Get_Match_Distance(self, i) -> float: ...
    def Get_Match_Shape(self, i) -> CSG_Shape: ...
    def Get_Point_Count(self) -> int: ...
    def Get_Point(self, *args) -> Any: ...
    def Get_Point_Value(self, *args) -> float: ...

class CSG_KDTree_2D(CSG_KDTree):
    thisown: bool
    __swig_destroy__: callable
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> bool: ...
    def Destroy(self) -> bool: ...
    def Get_Point_Value(self, i) -> float: ...
    def Get_Nearest_Points(self, *args) -> int: ...
    def Get_Nearest_Point(self, *args) -> bool: ...
    def Get_Nearest_Value(self, *args) -> bool: ...
    def Get_Nearest_Shape(self, *args) -> CSG_Shape: ...
    def Get_Duplicates(self, *args) -> int: ...

class CSG_KDTree_3D(CSG_KDTree):
    thisown: bool
    __swig_destroy__: callable
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> bool: ...
    def Destroy(self) -> bool: ...
    def Get_Point_Value(self, i) -> float: ...
    def Get_Nearest_Points(self, *args) -> int: ...
    def Get_Nearest_Point(self, *args) -> bool: ...
    def Get_Nearest_Value(self, *args) -> bool: ...
    def Get_Nearest_Shape(self, *args) -> CSG_Shape: ...
    def Get_Duplicates(self, *args) -> int: ...

class CSG_Parameters_Point_Search:
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Create(self, *args) -> bool: ...
    def On_Parameter_Changed(self, pParameters, pParameter) -> bool: ...
    def On_Parameters_Enable(self, pParameters, pParameter) -> bool: ...
    def Do_Use_All(self, *args) -> bool: ...
    def Get_Min_Points(self) -> int: ...
    def Get_Max_Points(self) -> int: ...
    def Get_Radius(self) -> float: ...

class CSG_Parameters_Point_Search_KDTree_2D(CSG_Parameters_Point_Search):
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Initialize(self, pPoints, zField: int = -1) -> bool: ...
    def Finalize(self) -> bool: ...
    def Set_Location(self, *args) -> int: ...
    def Get_Count(self) -> int: ...
    def Get_Point(self, Index, x, y, z) -> bool: ...
    def Get_Points(self, *args) -> bool: ...

def SG_Shape_Get_Intersection(pSubject: CSG_Shape, pClip: CSG_Shape_Polygon, pSolution: CSG_Shape = None) -> bool: ...
def SG_Shape_Get_Difference(pSubject: CSG_Shape, pClip: CSG_Shape_Polygon, pSolution: CSG_Shape = None) -> bool: ...
def SG_Shape_Get_ExclusiveOr(pSubject: CSG_Shape, pClip: CSG_Shape_Polygon, pSolution: CSG_Shape = None) -> bool: ...
def SG_Shape_Get_Union(pSubject: CSG_Shape, pClip: CSG_Shape_Polygon, pSolution: CSG_Shape = None) -> bool: ...
def SG_Shape_Get_Dissolve(pSubject: CSG_Shape, pSolution: CSG_Shape = None) -> bool: ...

SG_LINE_JOINTYPE_Square: int
SG_LINE_JOINTYPE_Bevel: int
SG_LINE_JOINTYPE_Round: int
SG_LINE_JOINTYPE_Miter: int

TSG_Line_JoinType: TypeAlias = Literal[
    0,  # SG_LINE_JOINTYPE_Square
    1,  # SG_LINE_JOINTYPE_Bevel
    2,  # SG_LINE_JOINTYPE_Round
    3,  # SG_LINE_JOINTYPE_Miter
]

SG_LINE_ENDTYPE_Polygon: int
SG_LINE_ENDTYPE_Joined: int
SG_LINE_ENDTYPE_Butt: int
SG_LINE_ENDTYPE_Square: int
SG_LINE_ENDTYPE_Round: int

TSG_Line_EndType: TypeAlias = Literal[
    0,  # SG_LINE_ENDTYPE_Polygon
    1,  # SG_LINE_ENDTYPE_Joined
    2,  # SG_LINE_ENDTYPE_Butt
    3,  # SG_LINE_ENDTYPE_Square
    4,  # SG_LINE_ENDTYPE_Round
]

def SG_Shape_Get_Offset(pSubject: CSG_Shape, Size: float, dArc: float, pSolution: CSG_Shape = None, JoinType: TSG_Line_JoinType = TSG_Line_JoinType.SG_LINE_JOINTYPE_Round, EndType: TSG_Line_EndType = TSG_Line_EndType.SG_LINE_ENDTYPE_Round) -> bool: ...
def SG_Clipper_Get_Version() -> str: ...

SG_OGIS_BYTEORDER_XDR: int
SG_OGIS_BYTEORDER_NDR: int

ESG_OGIS_ByteOrder: TypeAlias = Literal[
    0,  # SG_OGIS_BYTEORDER_XDR (Big Endian)
    1,  # SG_OGIS_BYTEORDER_NDR (Little Endian)
]

SG_OGIS_TYPE_Undefined: int
SG_OGIS_TYPE_Point: int
SG_OGIS_TYPE_LineString: int
SG_OGIS_TYPE_Polygon: int
SG_OGIS_TYPE_MultiPoint: int
SG_OGIS_TYPE_MultiLineString: int
SG_OGIS_TYPE_MultiPolygon: int
SG_OGIS_TYPE_GeometryCollection: int
SG_OGIS_TYPE_PolyhedralSurface: int
SG_OGIS_TYPE_TIN: int
SG_OGIS_TYPE_Triangle: int
SG_OGIS_TYPE_PointZ: int
SG_OGIS_TYPE_LineStringZ: int
SG_OGIS_TYPE_PolygonZ: int
SG_OGIS_TYPE_MultiPointZ: int
SG_OGIS_TYPE_MultiLineStringZ: int
SG_OGIS_TYPE_MultiPolygonZ: int
SG_OGIS_TYPE_GeometryCollectionZ: int
SG_OGIS_TYPE_PolyhedralSurfaceZ: int
SG_OGIS_TYPE_TINZ: int
SG_OGIS_TYPE_TriangleZ: int
SG_OGIS_TYPE_PointM: int
SG_OGIS_TYPE_LineStringM: int
SG_OGIS_TYPE_PolygonM: int
SG_OGIS_TYPE_MultiPointM: int
SG_OGIS_TYPE_MultiLineStringM: int
SG_OGIS_TYPE_MultiPolygonM: int
SG_OGIS_TYPE_GeometryCollectionM: int
SG_OGIS_TYPE_PolyhedralSurfaceM: int
SG_OGIS_TYPE_TINM: int
SG_OGIS_TYPE_TriangleM: int
SG_OGIS_TYPE_PointZM: int
SG_OGIS_TYPE_LineStringZM: int
SG_OGIS_TYPE_PolygonZM: int
SG_OGIS_TYPE_MultiPointZM: int
SG_OGIS_TYPE_MultiLineStringZM: int
SG_OGIS_TYPE_MultiPolygonZM: int
SG_OGIS_TYPE_GeometryCollectionZM: int
SG_OGIS_TYPE_PolyhedralSurfaceZM: int
SG_OGIS_TYPE_TINZM: int
SG_OGIS_TYPE_TriangleZM: int

TSG_OGIS_Type_Geometry: TypeAlias = Literal[
    0,    # SG_OGIS_TYPE_Undefined

    1,    # SG_OGIS_TYPE_Point
    2,    # SG_OGIS_TYPE_LineString
    3,    # SG_OGIS_TYPE_Polygon
    4,    # SG_OGIS_TYPE_MultiPoint
    5,    # SG_OGIS_TYPE_MultiLineString
    6,    # SG_OGIS_TYPE_MultiPolygon
    7,    # SG_OGIS_TYPE_GeometryCollection
    15,   # SG_OGIS_TYPE_PolyhedralSurface
    16,   # SG_OGIS_TYPE_TIN
    17,   # SG_OGIS_TYPE_Triangle

    1001, # SG_OGIS_TYPE_PointZ
    1002, # SG_OGIS_TYPE_LineStringZ
    1003, # SG_OGIS_TYPE_PolygonZ
    1004, # SG_OGIS_TYPE_MultiPointZ
    1005, # SG_OGIS_TYPE_MultiLineStringZ
    1006, # SG_OGIS_TYPE_MultiPolygonZ
    1007, # SG_OGIS_TYPE_GeometryCollectionZ
    1015, # SG_OGIS_TYPE_PolyhedralSurfaceZ
    1016, # SG_OGIS_TYPE_TINZ
    1017, # SG_OGIS_TYPE_TriangleZ

    2001, # SG_OGIS_TYPE_PointM
    2002, # SG_OGIS_TYPE_LineStringM
    2003, # SG_OGIS_TYPE_PolygonM
    2004, # SG_OGIS_TYPE_MultiPointM
    2005, # SG_OGIS_TYPE_MultiLineStringM
    2006, # SG_OGIS_TYPE_MultiPolygonM
    2007, # SG_OGIS_TYPE_GeometryCollectionM
    2015, # SG_OGIS_TYPE_PolyhedralSurfaceM
    2016, # SG_OGIS_TYPE_TINM
    2017, # SG_OGIS_TYPE_TriangleM

    3001, # SG_OGIS_TYPE_PointZM
    3002, # SG_OGIS_TYPE_LineStringZM
    3003, # SG_OGIS_TYPE_PolygonZM
    3004, # SG_OGIS_TYPE_MultiPointZM
    3005, # SG_OGIS_TYPE_MultiLineStringZM
    3006, # SG_OGIS_TYPE_MultiPolygonZM
    3007, # SG_OGIS_TYPE_GeometryCollectionZM
    3015, # SG_OGIS_TYPE_PolyhedralSurfaceZM
    3016, # SG_OGIS_TYPE_TINZM
    3017, # SG_OGIS_TYPE_TriangleZM
]

class CSG_Shapes_OGIS_Converter:
    thisown: bool
    def __init__(self) -> None: ...
    @staticmethod
    def from_WKText(Text, pShape) -> bool: ...
    @staticmethod
    def to_WKText(pShape, Text) -> bool: ...
    @staticmethod
    def from_WKBinary(Bytes, pShape) -> bool: ...
    @staticmethod
    def to_WKBinary(pShape, Bytes) -> bool: ...
    @staticmethod
    def from_ShapeType(*args) -> Any: ...
    @staticmethod
    def to_ShapeType(*args) -> Any: ...
    @staticmethod
    def to_VertexType(*args) -> TSG_Vertex_Type: ...
    @staticmethod
    def Type_asWKText(Type) -> CSG_String: ...
    @staticmethod
    def Type_asWKBinary(Type) -> int: ...
    __swig_destroy__: callable

class CSG_Grid_OGIS_Converter:
    thisown: bool
    def __init__(self) -> None: ...
    @staticmethod
    def from_WKBinary(Bytes, pGrid) -> bool: ...
    @staticmethod
    def to_WKBinary(Bytes, pGrid, SRID: int = -1) -> bool: ...
    __swig_destroy__: callable

class CSG_TIN_Node(CSG_Table_Record):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_ID(self) -> int: ...
    def Get_Point(self) -> TSG_Point: ...
    def Get_X(self) -> float: ...
    def Get_Y(self) -> float: ...
    def Get_Neighbor_Count(self) -> int: ...
    def Get_Neighbor(self, iNeighbor) -> CSG_TIN_Node: ...
    def Get_Gradient(self, iNeighbor, iField) -> float: ...
    def Get_Triangle_Count(self) -> int: ...
    def Get_Triangle(self, iTriangle) -> CSG_TIN_Triangle: ...
    def Get_Polygon(self, Points) -> bool: ...
    def Get_Polygon_Area(self) -> float: ...

class CSG_TIN_Edge:
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Node(self, iNode) -> CSG_TIN_Node: ...

class CSG_TIN_Triangle:
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Node(self, iNode) -> CSG_TIN_Node: ...
    def Get_Extent(self) -> CSG_Rect: ...
    def Get_Area(self) -> float: ...
    def is_Containing(self, *args) -> bool: ...
    def Get_Value(self, *args) -> bool: ...
    def Get_Gradient(self, zField, Decline, Azimuth) -> bool: ...
    def Get_CircumCircle(self, Point, Radius) -> None: ...
    def Get_CircumCircle_Radius(self) -> float: ...
    def Get_CircumCircle_Point(self) -> TSG_Point: ...

class CSG_TIN(CSG_Table):
    thisown: bool
    def __init__(self, *args) -> None: ...
    def Create(self, *args) -> bool: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    def Get_ObjectType(self) -> TSG_Data_Object_Type: ...
    def Save(self, *args) -> bool: ...
    def Assign(self, pObject, bProgress: bool = False) -> bool: ...
    def is_Valid(self) -> bool: ...
    def Get_Extent(self) -> CSG_Rect: ...
    def Triangulate(self, bOn: bool = True, bUpdate: bool = False) -> bool: ...
    def Add_Node(self, Point, pRecord=None, bUpdateNow: bool = False) -> CSG_TIN_Node: ...
    def Del_Node(self, Index, bUpdateNow) -> bool: ...
    def Get_Node_Count(self) -> int: ...
    def Get_Node(self, Index) -> CSG_TIN_Node: ...
    def Get_Edge_Count(self) -> int: ...
    def Get_Edge(self, Index) -> CSG_TIN_Edge: ...
    def Get_Triangle_Count(self) -> int: ...
    def Get_Triangle(self, Index) -> CSG_TIN_Triangle: ...
    def Add_Triangle(self, *args) -> CSG_TIN_Triangle: ...

def SG_Create_TIN(*args) -> CSG_TIN: ...

POINTCLOUD_FILE_FORMAT_Undefined: int
POINTCLOUD_FILE_FORMAT_Normal: int
POINTCLOUD_FILE_FORMAT_Compressed: int

TSG_PointCloud_File_Type: TypeAlias = Literal[
    0,  # POINTCLOUD_FILE_FORMAT_Undefined
    1,  # POINTCLOUD_FILE_FORMAT_Normal
    2   # POINTCLOUD_FILE_FORMAT_Compressed
]

class CSG_PointCloud(CSG_Shapes):
    thisown: bool
    @overload
    def __init__(self) -> CSG_PointCloud: ...
    @overload
    def __init__(self, PointCloud: CSG_PointCloud) -> CSG_PointCloud: ...
    @overload
    def __init__(self, File: Union[CSG_String, str]) -> CSG_PointCloud: ...
    @overload
    def Create(self) -> bool: ...
    @overload
    def Create(self, PointCloud: CSG_PointCloud) -> bool: ...
    @overload
    def Create(self, File: Union[CSG_String, str]) -> bool: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    def Get_ObjectType(self) -> TSG_Data_Object_Type: ...
    def Assign(self, pSource: CSG_Data_Object, bProgress: bool = False) -> bool: ...
    @overload
    def Save(self, File: Union[CSG_String, str], Format: int = 0) -> bool: ...
    def Set_XYZ_Precision(self, bDouble: bool) -> None: ...
    @staticmethod
    def Get_Header_Content(FileName: CSG_String, Header: CSG_MetaData) -> bool: ...
    def is_Valid(self) -> bool: ...
    def is_Compatible(self, pPointCloud: CSG_PointCloud) -> bool: ...
    def Add_Field(self, Name: CSG_String, Type: TSG_Data_Type, Field: int = -1) -> bool: ...
    def Del_Field(self, Field: int) -> bool: ...
    def Mov_Field(self, Field: int, Position: int) -> bool: ...
    def Get_Field_Length(self, Field: int, Encoding = TSG_File_Flags_Encoding.SG_FILE_ENCODING_UNDEFINED) -> int: ...
    def Set_Field_Type(self, Field: int, Type: TSG_Data_Type) -> bool: ...
    def Get_Attribute_Count(self) -> int: ...
    def Get_Attribute_Name(self, Field: int) -> str: ...
    def Get_Attribute_Type(self, Field: int) -> TSG_Data_Type: ...
    def Get_Attribute_Length(self, Field: int, Encoding = TSG_File_Flags_Encoding.SG_FILE_ENCODING_UNDEFINED) -> int: ...
    @overload
    def Add_Point(self, x: float, y: float, z: float) -> bool: ...
    @overload
    def Add_Point(self, Point: CSG_Point_3D) -> bool: ...
    def Del_Point(self, Index: int) -> bool: ...
    def Del_Points(self) -> bool: ...
    def Set_Cursor(self, Index: int) -> bool: ...
    @overload
    def Get_X(self) -> float: ...
    @overload
    def Get_X(self, Index: int) -> float: ...
    @overload
    def Get_Y(self) -> float: ...
    @overload
    def Get_Y(self, Index: int) -> float: ...
    @overload
    def Get_Z(self) -> float: ...
    @overload
    def Get_Z(self, Index: int) -> float: ...
    @overload
    def Set_NoData(self, Field: int) -> bool: ...
    @overload
    def Set_NoData(self, Index: int, Field: int) -> bool: ...
    @overload
    def is_NoData(self, Field: int) -> bool: ...
    @overload
    def is_NoData(self, Index: int, Field: int) -> bool: ...
    @overload
    def Set_Value(self, Field: int, Value: Union[float, str]) -> bool: ...
    @overload
    def Set_Value(self, Index: int, Field: int, Value: Union[float, str]) -> bool: ...
    @overload
    def Get_Value(self, Field: int) -> float: ...
    @overload
    def Get_Value(self, Index: int, Field: int) -> float: ...
    @overload
    def Get_Value(self, Field: int, Value: CSG_String) -> bool: ...
    @overload
    def Get_Value(self, Index: int, Field: int, Value: CSG_String) -> bool: ...
    @overload
    def Set_Attribute(self, Field: int, Value: Union[float, str]) -> bool: ...
    @overload
    def Set_Attribute(self, Index: int, Field: int, Value: Union[float, str]) -> bool: ...
    @overload
    def Get_Attribute(self, Field: int) -> float: ...
    @overload
    def Get_Attribute(self, Index: int, Field: int) -> float: ...
    @overload
    def Get_Attribute(self, Field: int, Value: CSG_String) -> bool: ...
    @overload
    def Get_Attribute(self, Index: int, Field: int, Value: CSG_String) -> bool: ...
    @overload
    def Get_Point(self, Point: CSG_Point, Epsilon: float = 0) -> int: ...
    @overload
    def Get_Point(self) -> TSG_Point_3D: ...
    @overload
    def Get_Point(self, Index: int) -> TSG_Point_3D: ...
    @overload
    def Set_Point(self, Point: TSG_Point_3D) -> bool: ...
    @overload
    def Get_Point(self, Index: int, Point: TSG_Point_3D) -> bool: ...
    def Set_Modified(self, bModified: bool = True) -> None: ...
    def Get_Record(self, Index: int) -> CSG_Table_Record: ...
    def Get_Shape(self, Point: CSG_Point, Epsilon: float = 0.0) -> CSG_Shape: ...
    def Del_Record(self, Index: int) -> bool: ...
    def Del_Records(self) -> bool: ...
    def Del_Shapes(self) -> bool: ...
    def Ins_Record(self, Index: int, pCopy: CSG_Table_Record = None) -> CSG_Table_Record: ...
    def Add_Record(self, pCopy: CSG_Table_Record = None) -> CSG_Table_Record: ...
    def Add_Shape(self, pCopy: CSG_Table_Record = None, mCopy: TSG_ADD_Shape_Copy_Mode = TSG_ADD_Shape_Copy_Mode.SHAPE_COPY) -> CSG_Shape: ...
    @overload
    def Del_Shape(self, Index: int) -> bool: ...
    @overload
    def Del_Shape(self, pShape: CSG_Shape) -> bool: ...
    @overload
    def Select(self, Index: int, bInvert: bool = False) -> bool: ...
    @overload
    def Select(self, pShape: CSG_Table_Record = None, bInvert: bool = False) -> bool: ...
    @overload
    def Select(self, Extent: TSG_Rect, bInvert: bool = False) -> bool: ...
    @overload
    def Select(self, Point: TSG_Point, bInvert: bool = False) -> bool: ...
    def is_Selected(self, Index: int) -> bool: ...
    def Del_Selection(self) -> int: ...
    def Inv_Selection(self) -> int: ...
    def Get_Selection(self, Index: int = 0) -> CSG_Table_Record: ...
    def Get_Selection_Extent(self) -> CSG_Rect: ...
    def Sort(self, Index: CSG_Index) -> bool: ...

@overload
def SG_Create_PointCloud() -> CSG_PointCloud: ...
@overload
def SG_Create_PointCloud(PointCloud: CSG_PointCloud) -> CSG_PointCloud: ...
@overload
def SG_Create_PointCloud(File: Union[CSG_String, str]) -> CSG_PointCloud: ...

PARAMETER_INPUT: int
PARAMETER_OUTPUT: int
PARAMETER_OPTIONAL: int
PARAMETER_INFORMATION: int
PARAMETER_IGNORE_PROJECTION: int
PARAMETER_NOT_FOR_GUI: int
PARAMETER_NOT_FOR_CMD: int
PARAMETER_GUI_COLLAPSED: int
PARAMETER_INPUT_OPTIONAL: int
PARAMETER_OUTPUT_OPTIONAL: int

PARAMETER_DESCRIPTION_NAME: int
PARAMETER_DESCRIPTION_TYPE: int
PARAMETER_DESCRIPTION_OPTIONAL: int
PARAMETER_DESCRIPTION_PROPERTIES: int
PARAMETER_DESCRIPTION_TEXT: int
PARAMETER_DESCRIPTION_ALL: int

PARAMETER_TYPE_Node: int
PARAMETER_TYPE_Bool: int
PARAMETER_TYPE_Int: int
PARAMETER_TYPE_Double: int
PARAMETER_TYPE_Degree: int
PARAMETER_TYPE_Date: int
PARAMETER_TYPE_Range: int
PARAMETER_TYPE_Data_Type: int
PARAMETER_TYPE_Choice: int
PARAMETER_TYPE_Choices: int
PARAMETER_TYPE_String: int
PARAMETER_TYPE_Text: int
PARAMETER_TYPE_FilePath: int
PARAMETER_TYPE_Font: int
PARAMETER_TYPE_Color: int
PARAMETER_TYPE_Colors: int
PARAMETER_TYPE_FixedTable: int
PARAMETER_TYPE_Grid_System: int
PARAMETER_TYPE_Table_Field: int
PARAMETER_TYPE_Table_Fields: int
PARAMETER_TYPE_PointCloud: int
PARAMETER_TYPE_Grid: int
PARAMETER_TYPE_Grids: int
PARAMETER_TYPE_Table: int
PARAMETER_TYPE_Shapes: int
PARAMETER_TYPE_TIN: int
PARAMETER_TYPE_Grid_List: int
PARAMETER_TYPE_Grids_List: int
PARAMETER_TYPE_Table_List: int
PARAMETER_TYPE_Shapes_List: int
PARAMETER_TYPE_TIN_List: int
PARAMETER_TYPE_PointCloud_List: int
PARAMETER_TYPE_DataObject_Output: int
PARAMETER_TYPE_Parameters: int
PARAMETER_TYPE_Undefined: int

TSG_Parameter_Type: TypeAlias = Literal[
    0,   # PARAMETER_TYPE_Node
    1,   # PARAMETER_TYPE_Bool
    2,   # PARAMETER_TYPE_Int
    3,   # PARAMETER_TYPE_Double
    4,   # PARAMETER_TYPE_Degree
    5,   # PARAMETER_TYPE_Date
    6,   # PARAMETER_TYPE_Range
    7,   # PARAMETER_TYPE_Data_Type
    8,   # PARAMETER_TYPE_Choice
    9,   # PARAMETER_TYPE_Choices
    10,  # PARAMETER_TYPE_String
    11,  # PARAMETER_TYPE_Text
    12,  # PARAMETER_TYPE_FilePath
    13,  # PARAMETER_TYPE_Font
    14,  # PARAMETER_TYPE_Color
    15,  # PARAMETER_TYPE_Colors
    16,  # PARAMETER_TYPE_FixedTable
    17,  # PARAMETER_TYPE_Grid_System
    18,  # PARAMETER_TYPE_Table_Field
    19,  # PARAMETER_TYPE_Table_Fields
    20,  # PARAMETER_TYPE_PointCloud
    21,  # PARAMETER_TYPE_Grid
    22,  # PARAMETER_TYPE_Grids
    23,  # PARAMETER_TYPE_Table
    24,  # PARAMETER_TYPE_Shapes
    25,  # PARAMETER_TYPE_TIN
    26,  # PARAMETER_TYPE_Grid_List
    27,  # PARAMETER_TYPE_Grids_List
    28,  # PARAMETER_TYPE_Table_List
    29,  # PARAMETER_TYPE_Shapes_List
    30,  # PARAMETER_TYPE_TIN_List
    31,  # PARAMETER_TYPE_PointCloud_List
    32,  # PARAMETER_TYPE_DataObject_Output
    33,  # PARAMETER_TYPE_Parameters
    34   # PARAMETER_TYPE_Undefined
]

def SG_Parameter_Type_Get_Name(Type: TSG_Parameter_Type) -> CSG_String: ...
def SG_Parameter_Type_Get_Identifier(Type: TSG_Parameter_Type) -> CSG_String: ...
def SG_Parameter_Type_Get_Type(Identifier: CSG_String) -> TSG_Parameter_Type: ...

PARAMETER_CHECK_VALUES: int
PARAMETER_CHECK_ENABLE: int
PARAMETER_CHECK_ALL: int
SG_PARAMETER_DATA_SET_FALSE: int
SG_PARAMETER_DATA_SET_TRUE: int
SG_PARAMETER_DATA_SET_CHANGED: int

class CSG_Parameter:
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Parameters(self) -> CSG_Parameters: ...
    def Get_Parent(self) -> CSG_Parameter: ...
    def Get_Manager(self) -> CSG_Data_Manager: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Get_Type_Identifier(self) -> CSG_String: ...
    def Get_Type_Name(self) -> CSG_String: ...
    def Get_Identifier(self) -> str: ...
    def Cmp_Identifier(self, Identifier: CSG_String) -> bool: ...
    def Get_CmdID(self) -> CSG_String: ...
    def Set_Name(self, Name: CSG_String) -> bool: ...
    def Get_Name(self) -> str: ...
    def Set_Description(self, Description: CSG_String) -> bool: ...
    @overload
    def Get_Description(self) -> str: ...
    @overload
    def Get_Description(self, Flags: int) -> CSG_String: ...
    @overload
    def Get_Description(self, Flags: int, Separator: str) -> CSG_String: ...
    def Set_Enabled(self, bEnabled: bool = True) -> bool: ...
    def is_Enabled(self, bCheckEnv: bool = True) -> bool: ...
    def Set_Collapsed(self, bOn: bool = True) -> bool: ...
    def is_Collapsed(self) -> bool: ...
    def is_Valid(self) -> bool: ...
    def is_Input(self) -> bool: ...
    def is_Output(self) -> bool: ...
    def is_Optional(self) -> bool: ...
    def is_Information(self) -> bool: ...
    def is_Option(self) -> bool: ...
    def is_DataObject(self) -> bool: ...
    def is_DataObject_List(self) -> bool: ...
    def is_Parameters(self) -> bool: ...
    def is_Serializable(self) -> bool: ...
    def is_Compatible(self, pParameter: CSG_Parameter) -> bool: ...
    def is_Value_Equal(self, pParameter: CSG_Parameter) -> bool: ...
    def Set_UseInGUI(self, bOn: bool = False) -> None: ...
    def Set_UseInCMD(self, bOn: bool = False) -> None: ...
    def do_UseInGUI(self) -> bool: ...
    def do_UseInCMD(self) -> bool: ...
    @overload
    def ignore_Projection(self, bIgnore: bool) -> None: ...
    @overload
    def ignore_Projection(self) -> bool: ...
    def Get_DataObject_Type(self) -> TSG_Data_Object_Type: ...
    def Get_Children_Count(self) -> int: ...
    def Get_Child(self, iChild: int) -> CSG_Parameter: ...
    def Set_Children_Enabled(self, bEnabled: bool = True) -> bool: ...
    @overload
    def Set_Value(self, Value: Union[int, float, CSG_Grid_Resampling, CSG_String, str, CSG_Colors, object, CSG_Parameter]) -> bool: ...
    def Toggle_Value(self) -> bool: ...
    def Set_Default(self, Value: Union[int, float, CSG_String]) -> bool: ...
    def Get_Default(self) -> CSG_String: ...
    def is_Default(self) -> bool: ...
    def Restore_Default(self) -> bool: ...
    def Check(self, bSilent: bool = True) -> bool: ...
    def has_Changed(self, Check_Flags: int = (0x01 | 0x02)) -> bool: ...
    def asBool(self) -> bool: ...
    def asInt(self) -> int: ...
    def asColor(self) -> int: ...
    def asDouble(self) -> float: ...
    def asString(self) -> str: ...
    def asPointer(self) -> Any: ...
    def asColors(self) -> CSG_Colors: ...
    def asFont(self) -> str: ...
    def asGrid_System(self) -> CSG_Grid_System: ...
    def asGrid_Resampling(self) -> CSG_Grid_Resampling: ...
    def asDataObject(self) -> CSG_Data_Object: ...
    def asGrid(self) -> CSG_Grid: ...
    def asGrids(self) -> CSG_Grids: ...
    def asTable(self) -> CSG_Table: ...
    def asShapes(self) -> CSG_Shapes: ...
    def asTIN(self) -> CSG_TIN: ...
    def asPointCloud(self) -> CSG_PointCloud: ...
    def asValue(self) -> CSG_Parameter_Value: ...
    def asDate(self) -> CSG_Parameter_Date: ...
    def asDataType(self) -> CSG_Parameter_Data_Type: ...
    def asChoice(self) -> CSG_Parameter_Choice: ...
    def asChoices(self) -> CSG_Parameter_Choices: ...
    def asRange(self) -> CSG_Parameter_Range: ...
    def asFilePath(self) -> CSG_Parameter_File_Name: ...
    def asTableFields(self) -> CSG_Parameter_Table_Fields: ...
    def asParameters(self) -> CSG_Parameters: ...
    def asList(self) -> CSG_Parameter_List: ...
    def asGridList(self) -> CSG_Parameter_Grid_List: ...
    def asGridsList(self) -> CSG_Parameter_Grids_List: ...
    def asTableList(self) -> CSG_Parameter_Table_List: ...
    def asShapesList(self) -> CSG_Parameter_Shapes_List: ...
    def asTINList(self) -> CSG_Parameter_TIN_List: ...
    def asPointCloudList(self) -> CSG_Parameter_PointCloud_List: ...
    def Assign(self, pSource: CSG_Parameter) -> bool: ...
    def Serialize(self, MetaData: CSG_MetaData, bSave) -> bool: ...

class CSG_Parameter_Node(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    __swig_destroy__: callable

class CSG_Parameter_Bool(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def is_Default(self) -> bool: ...
    def Toggle_Value(self) -> bool: ...
    __swig_destroy__: callable

class CSG_Parameter_Value(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Set_Valid_Range(self, Minimum: float, Maximum: float) -> bool: ...
    def Set_Minimum(self, Minimum: float, bOn: bool = True) -> None: ...
    def Get_Minimum(self) -> float: ...
    def has_Minimum(self) -> bool: ...
    def Set_Maximum(self, Maximum: float, bOn: bool = True) -> None: ...
    def Get_Maximum(self) -> float: ...
    def has_Maximum(self) -> bool: ...
    __swig_destroy__: callable

class CSG_Parameter_Int(CSG_Parameter_Value):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def is_Default(self) -> bool: ...
    __swig_destroy__: callable

class CSG_Parameter_Double(CSG_Parameter_Value):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def is_Default(self) -> bool: ...
    __swig_destroy__: callable

class CSG_Parameter_Degree(CSG_Parameter_Double):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    __swig_destroy__: callable

class CSG_Parameter_Date(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Set_Date(self, Date: CSG_DateTime) -> None: ...
    def Get_Date(self) -> CSG_DateTime: ...
    __swig_destroy__: callable

class CSG_Parameter_Range(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Set_Range(self, Min: float, Max: float) -> bool: ...
    def Get_Range(self) -> float: ...
    def Set_Min(self, Min: float) -> bool: ...
    def Get_Min(self) -> float: ...
    def Get_Min_Parameter(self) -> CSG_Parameter_Double: ...
    def Set_Max(self, Max: float) -> bool: ...
    def Get_Max(self) -> float: ...
    def Get_Max_Parameter(self) -> CSG_Parameter_Double: ...
    def is_Default(self) -> bool: ...
    def Restore_Default(self) -> bool: ...

class CSG_Parameter_Choice(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def is_Default(self) -> bool: ...
    def Toggle_Value(self) -> bool: ...
    def Del_Items(self) -> bool: ...
    def Add_Item(self, Item: CSG_String, Data: CSG_String = '') -> bool: ...
    def Set_Items(self, String: str) -> bool: ...
    def Get_Items(self, bIncludeData: bool = False) -> CSG_String: ...
    def Get_Item(self, Index: int) -> str: ...
    def Get_Item_Data(self, Index: int) -> CSG_String: ...
    @overload
    def Get_Data(self) -> CSG_String: ...
    @overload
    def Get_Data(self, Value: Union[int, float, CSG_String]) -> bool: ...
    def Get_Count(self) -> int: ...
    __swig_destroy__: callable

class CSG_Parameter_Data_Type(CSG_Parameter_Choice):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Set_Data_Types(self, Data_Types: int, Default: TSG_Data_Type = SG_DATATYPE_Undefined, User: CSG_String = ...) -> bool: ...
    def Set_Data_Type(self, Value: TSG_Data_Type) -> bool: ...
    def Get_Data_Type(self, Default: TSG_Data_Type = SG_DATATYPE_Undefined) -> TSG_Data_Type: ...
    __swig_destroy__: callable

class CSG_Parameter_Choices(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    @overload
    def Set_Items(self, Items: Union[CSG_String,CSG_Strings]) -> bool: ...
    def Get_Items(self) -> CSG_String: ...
    def Del_Items(self) -> None: ...
    def Add_Item(self, Item: CSG_String, Data: CSG_String = '') -> bool: ...
    def Get_Item_Count(self) -> int: ...
    def Get_Item(self, i: int) -> CSG_String: ...
    def Get_Item_Data(self, i: int) -> CSG_String: ...
    def Get_Selection_Count(self) -> int: ...
    def Get_Selection(self, i: int) -> CSG_String: ...
    def Get_Selection_Data(self, i: int) -> CSG_String: ...
    def Get_Selection_Index(self, i: int) -> int: ...
    def is_Selected(self, Index: int) -> bool: ...
    def Select(self, Index: int, bSelect: bool = True) -> bool: ...
    def Clr_Selection(self) -> bool: ...
    __swig_destroy__: callable

class CSG_Parameter_String(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def is_Valid(self) -> bool: ...
    def Set_Password(self, bOn: bool) -> None: ...
    def is_Password(self) -> bool: ...
    __swig_destroy__: callable

class CSG_Parameter_Text(CSG_Parameter_String):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    __swig_destroy__: callable

class CSG_Parameter_File_Name(CSG_Parameter_String):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Set_Filter(self, Filter: str) -> None: ...
    def Get_Filter(self) -> str: ...
    def Set_Flag_Save(self, bFlag: bool) -> None: ...
    def is_Save(self) -> bool: ...
    def Set_Flag_Multiple(self, bFlag: bool) -> None: ...
    def is_Multiple(self) -> bool: ...
    def Set_Flag_Directory(self, bFlag: bool) -> None: ...
    def is_Directory(self) -> bool: ...
    def Get_FilePaths(self, FilePaths: CSG_Strings) -> bool: ...
    __swig_destroy__: callable

class CSG_Parameter_Font(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Restore_Default(self) -> bool: ...
    __swig_destroy__: callable

class CSG_Parameter_Color(CSG_Parameter_Int):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    __swig_destroy__: callable

class CSG_Parameter_Colors(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    __swig_destroy__: callable

class CSG_Parameter_Fixed_Table(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    __swig_destroy__: callable

class CSG_Parameter_Grid_System(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    __swig_destroy__: callable

class CSG_Parameter_Table_Field(CSG_Parameter_Int):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Add_Default(self, Value: float, Minimum: float, bMinimum: bool, Maximum: float, bMaximum: bool) -> bool: ...
    def Get_Table(self) -> CSG_Table: ...
    @staticmethod
    def Get_Choices(Table, bAllowNone: bool = False) -> CSG_String: ...
    __swig_destroy__: callable

class CSG_Parameter_Table_Fields(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Get_Count(self) -> int: ...
    def Get_Index(self, i: int) -> int: ...
    def Get_Table(self) -> CSG_Table: ...

class CSG_Parameter_Data_Object(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def is_Valid(self) -> bool: ...
    __swig_destroy__: callable

class CSG_Parameter_Data_Object_Output(CSG_Parameter_Data_Object):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Set_DataObject_Type(self, Type: TSG_Data_Object_Type) -> bool: ...
    def Get_DataObject_Type(self) -> TSG_Data_Object_Type: ...
    __swig_destroy__: callable

class CSG_Parameter_Grid(CSG_Parameter_Data_Object):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Set_Preferred_Type(self, Type: TSG_Data_Type) -> None: ...
    def Get_Preferred_Type(self) -> TSG_Data_Type: ...
    def Get_System(self) -> CSG_Grid_System: ...
    def Add_Default(self, Value: float, Minimum: float, bMinimum: bool, Maximum: float, bMaximum: bool) -> bool: ...
    __swig_destroy__: callable

class CSG_Parameter_Grids(CSG_Parameter_Grid):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    __swig_destroy__: callable

class CSG_Parameter_Table(CSG_Parameter_Data_Object):
    thisown: bool
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def __init__(self, pOwner: CSG_Parameters, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int) -> None: ...
    __swig_destroy__: callable

class CSG_Parameter_Shapes(CSG_Parameter_Data_Object):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Set_Shape_Type(self, Type: TSG_Shape_Type) -> None: ...
    def Get_Shape_Type(self) -> TSG_Shape_Type: ...
    __swig_destroy__: callable

class CSG_Parameter_TIN(CSG_Parameter_Data_Object):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    __swig_destroy__: callable

class CSG_Parameter_PointCloud(CSG_Parameter_Data_Object):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    __swig_destroy__: callable

class CSG_Parameter_List(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Add_Item(self, pItem: CSG_Data_Object) -> bool: ...
    @overload
    def Del_Item(self, pItem: CSG_Data_Object, bUpdateData: bool = True) -> bool: ...
    @overload
    def Del_Item(self, Index: int, bUpdateData: bool = True) -> bool: ...
    def Del_Items(self) -> bool: ...
    def Get_Item_Count(self) -> int: ...
    def Get_Item(self, Index: int) -> CSG_Data_Object: ...
    def Update_Data(self) -> bool: ...
    __swig_destroy__: callable

class CSG_Parameter_Grid_List(CSG_Parameter_List):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Get_System(self) -> CSG_Grid_System: ...
    def Add_Item(self, pItem: CSG_Data_Object) -> bool: ...
    @overload
    def Del_Item(self, pItem: CSG_Data_Object, bUpdateData: bool = True) -> bool: ...
    @overload
    def Del_Item(self, Index: int, bUpdateData: bool = True) -> bool: ...
    def Del_Items(self) -> bool: ...
    def Update_Data(self) -> bool: ...
    def Get_Grid_Count(self) -> int: ...
    def Get_Grid(self, Index: int) -> CSG_Grid: ...
    __swig_destroy__: callable

class CSG_Parameter_Grids_List(CSG_Parameter_List):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Get_System(self) -> CSG_Grid_System: ...
    def Add_Item(self, pItem: CSG_Data_Object) -> bool: ...
    def Get_Grids(self, Index: int) -> CSG_Grids: ...
    __swig_destroy__: callable

class CSG_Parameter_Table_List(CSG_Parameter_List):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Get_Table(self, Index: int) -> CSG_Table: ...
    __swig_destroy__: callable

class CSG_Parameter_Shapes_List(CSG_Parameter_List):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Set_Shape_Type(self, Type: TSG_Shape_Type) -> None: ...
    def Get_Shape_Type(self) -> TSG_Shape_Type: ...
    def Get_Shapes(self, Index: int) -> CSG_Shapes: ...
    __swig_destroy__: callable

class CSG_Parameter_TIN_List(CSG_Parameter_List):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def asTIN(self, Index: int) -> CSG_TIN: ...
    __swig_destroy__: callable

class CSG_Parameter_PointCloud_List(CSG_Parameter_List):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Get_PointCloud(self, Index: int) -> CSG_PointCloud: ...
    __swig_destroy__: callable

class CSG_Parameter_Parameters(CSG_Parameter):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> TSG_Parameter_Type: ...
    def Restore_Default(self) -> bool: ...

class CSG_Parameters_CRSPicker:
    thisown: bool
    def __init__(self) -> CSG_Parameters_CRSPicker: ...
    def Create(self, Parameters: CSG_Parameters, ParentID: CSG_String) -> bool: ...
    def Activate_GUI(self, bReset: bool = False) -> bool: ...
    def Deactivate_GUI(self) -> bool: ...
    @staticmethod
    def On_Parameter_Changed(pParameters: CSG_Parameters, pParameter: CSG_Parameter) -> bool: ...
    @staticmethod
    def On_Parameters_Enable(pParameters: CSG_Parameters, pParameter: CSG_Parameter) -> bool: ...
    def Get_CRS(self, Projection: CSG_Projection, bMessage: bool = False) -> bool: ...
    __swig_destroy__: callable

class CSG_Parameters_Grid_Target:
    thisown: bool
    def __init__(self) -> CSG_Parameters_Grid_Target: ...
    @overload
    def Create(self, pParameters: CSG_Parameters, bAddDefaultGrid: bool, pParent: CSG_Parameter, Prefix: CSG_String = '') -> bool: ...
    @overload
    def Create(self, pParameters: CSG_Parameters, bAddDefaultGrid: bool = True, ParentID: CSG_String = '', Prefix: CSG_String = '') -> bool: ...
    def Add_Grid(self, ID: CSG_String, Name: CSG_String, bOptional: bool) -> bool: ...
    def Add_Grids(self, ID: CSG_String, Name: CSG_String, bOptional: bool, bZLevels: bool = False) -> bool: ...
    @staticmethod
    @overload
    def On_Parameter_Changed(pParameters: CSG_Parameters, pParameter: CSG_Parameter) -> bool: ...
    @staticmethod
    @overload
    def On_Parameter_Changed(pParameters: CSG_Parameters, pParameter: CSG_Parameter, Prefix: CSG_String) -> bool: ...
    @staticmethod
    @overload
    def On_Parameters_Enable(pParameters: CSG_Parameters, pParameter: CSG_Parameter) -> bool: ...
    @staticmethod
    @overload
    def On_Parameters_Enable(pParameters: CSG_Parameters, pParameter: CSG_Parameter, Prefix: CSG_String) -> bool: ...
    @overload
    def Set_User_Defined(self, pParameters: CSG_Parameters, Extent: TSG_Rect, Rows: int, Rounding: int = 2) -> bool: ...
    @overload
    def Set_User_Defined(self, pParameters: CSG_Parameters, pPoints: CSG_Shapes, Scale: int=4, Rounding: int = 2) -> bool: ...
    @overload
    def Set_User_Defined(self, pParameters: CSG_Parameters, xMin: float, yMin: float, Size: float, nx: int, ny: int) -> bool: ...
    @overload
    def Set_User_Defined(self, pParameters: CSG_Parameters, System: CSG_Grid_System) -> bool: ...
    def Set_User_Defined_ZLevels(self, pParameters: CSG_Parameters, zMin: float, zMax: float, nLevels: int, Rounding: int = 2) -> bool: ...
    @overload
    def Get_System(self) -> CSG_Grid_System: ...
    @overload
    def Get_System(self, pParameters: CSG_Parameters) -> CSG_Grid_System: ...
    @overload
    def Get_Grid(self, ID: CSG_String, Type: TSG_Data_Type = SG_DATATYPE_Float) -> CSG_Grid: ...
    @overload
    def Get_Grid(self, Type: TSG_Data_Type = SG_DATATYPE_Float) -> CSG_Grid: ...
    @overload
    def Get_Grids(self, ID: CSG_String, Type: TSG_Data_Type = SG_DATATYPE_Float) -> CSG_Grids: ...
    @overload
    def Get_Grids(self, Type: TSG_Data_Type = SG_DATATYPE_Float) -> CSG_Grids: ...
    __swig_destroy__: callable


class CSG_Parameters:
    thisown: bool
    __swig_destroy__: callable
    @overload
    def __init__(self) -> CSG_Parameters: ...
    @overload
    def __init__(self, Parameters: CSG_Parameters) -> CSG_Parameters: ...
    @overload
    def __init__(self, Name: str, Description: str = None, Identifier: str = None, bGrid_System: bool = False) -> CSG_Parameters: ...
    @overload
    def __init__(self, pOwner: Any, Name: str, Description: str = None, Identifier: str = None, bGrid_System: bool = False) -> CSG_Parameters: ...
    @overload
    def Create(self, Parameters: CSG_Parameters) -> bool: ...
    @overload
    def Create(self, Name: str, Description: str = None, Identifier: str = None, bGrid_System: bool = False) -> bool: ...
    @overload
    def Create(self, pOwner: Any, Name: str, Description: str = None, Identifier: str = None, bGrid_System: bool = False) -> bool: ...
    def Destroy(self) -> None: ...
    def Get_Owner(self) -> Any: ...
    def Get_Tool(self) -> CSG_Tool: ...
    def Set_Tool(self, pTool: CSG_Tool) -> None: ...
    def Get_Manager(self) -> CSG_Data_Manager: ...
    def Set_Manager(self, pManager: CSG_Data_Manager) -> None: ...
    def Push(self, pManager: CSG_Data_Manager = None, bRestoreDefaults: bool = True) -> bool: ...
    def Pop(self) -> bool: ...
    def Use_Grid_System(self) -> bool: ...
    def has_GUI(self) -> bool: ...
    def Get_Count(self) -> int: ...
    def Set_Identifier(self, Identifier: CSG_String) -> None: ...
    def Cmp_Identifier(self, Identifier: CSG_String) -> bool: ...
    def Get_Identifier(self) -> CSG_String: ...
    def Set_Name(self, Name: CSG_String) -> None: ...
    def Get_Name(self) -> CSG_String: ...
    def Set_Description(self, Description: CSG_String) -> None: ...
    def Get_Description(self) -> CSG_String: ...
    @overload
    def Add_Reference(self, Authors: CSG_String, Year: CSG_String, Title: CSG_String, Where: CSG_String, Link: str = None, Link_Text: str = None) -> None: ...
    @overload
    def Add_Reference(self, Link: str, Link_Text: str = None) -> None: ...
    def Del_References(self) -> None: ...
    def Get_References(self) -> CSG_String: ...
    @overload
    def Set_Enabled(self, bEnabled: bool = True) -> None: ...
    @overload
    def Set_Enabled(self, Identifier: CSG_String, bEnabled: bool = True) -> None: ...
    def Set_Callback_On_Parameter_Changed(self, pCallback: int) -> Any: ...
    def Set_Callback(self, bActive: bool = True) -> bool: ...
    @overload
    def Get_Parameter(self, i: int) -> CSG_Parameter: ...
    @overload
    def Get_Parameter(self, i: int, MsgOnError: bool) -> CSG_Parameter: ...
    @overload
    def Get_Parameter(self, ID: Union[CSG_String, str], MsgOnError: bool = False) -> CSG_Parameter: ...
    @overload
    def __call__(self, i: int) -> CSG_Parameter: ...
    @overload
    def __call__(self, ID: Union[CSG_String, str]) -> CSG_Parameter: ...
    @overload
    def Del_Parameter(self, i: int) -> bool: ...
    @overload
    def Del_Parameter(self, ID: CSG_String) -> bool: ...
    def Del_Parameters(self) -> bool: ...
    def Add_Parameter(self, pParameter: CSG_Parameter) -> CSG_Parameter: ...
    def Add_Data_Type(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Data_Types: int, Default: TSG_Data_Type = SG_DATATYPE_Undefined, User: CSG_String = '') -> CSG_Parameter: ...
    def Add_Choices(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Items: CSG_String) -> CSG_Parameter: ...
    def Add_Grid_Resampling(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Methods: CSG_Grid_Resampling = CSG_Grid_Resampling_Interpolations, Default: CSG_Grid_Resampling = CSG_Grid_Resampling_Bicubic_2) -> CSG_Parameter: ...
    def Add_Grids(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int, bSystem_Dependent: bool = True, Preferred_Type: TSG_Data_Type = SG_DATATYPE_Undefined) -> CSG_Parameter: ...
    def Add_Grids_Output(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    def Add_Grids_List(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int, bSystem_Dependent: bool = True) -> CSG_Parameter: ...
    @overload
    def Set_Parameter(self, ID: Union[CSG_String, str], pValue: CSG_Parameter) -> bool: ...
    @overload
    def Set_Parameter(self, ID: Union[CSG_String, str], Value: Union[Any, CSG_Data_Object, int, float, CSG_String, str], Type: int = PARAMETER_TYPE_Undefined) -> bool: ...
    def Restore_Defaults(self, bClearData: bool = False) -> bool: ...
    def Assign(self, pSource: CSG_Parameters) -> bool: ...
    def Assign_Values(self, pSource: CSG_Parameters) -> bool: ...
    def Assign_Parameters(self, pSource: CSG_Parameters) -> bool: ...
    @overload
    def Load(self, Data: CSG_MetaData) -> bool: ...
    @overload
    def Load(self, File: CSG_String) -> bool: ...
    @overload
    def Save(self, Data: CSG_MetaData) -> bool: ...
    @overload
    def Save(self, File: CSG_String) -> bool: ...
    @overload
    def Serialize(self, Data: CSG_MetaData, bSave: bool) -> bool: ...
    @overload
    def Serialize(self, Data: CSG_MetaData) -> bool: ...
    @overload
    def Serialize(self, File: CSG_String, bSave: bool) -> bool: ...
    @overload
    def Serialize(self, File: CSG_String) -> bool: ...
    def Serialize_Compatibility(self, Stream: CSG_File) -> bool: ...
    def DataObjects_Check(self, bSilent: bool = False) -> bool: ...
    def Get_String(self, String: CSG_String, bOptionsOnly: bool) -> bool: ...
    def Msg_String(self, bOptionsOnly: bool) -> bool: ...
    def Set_History(self, History: CSG_MetaData, bOptions: bool = True, bDataObjects: bool = True) -> bool: ...
    def is_Managed(self) -> bool: ...
    def Get_Grid_System_Parameter(self) -> CSG_Parameter: ...
    def Get_Grid_System(self) -> CSG_Grid_System: ...
    def Set_Grid_System(self, System: CSG_Grid_System) -> bool: ...
    def Reset_Grid_System(self) -> bool: ...
    @overload
    def Add_Node(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, bCollapsed: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Node(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    @overload
    def Add_Value(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: float = 0.0, Minimum: float = 0.0, bMinimum: bool = False, Maximum: float = 0.0, bMaximum: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Value(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: float = 0.0, Minimum: float = 0.0, bMinimum: bool = False, Maximum: float = 0.0, bMaximum: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Info_Value(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: float = 0.0) -> CSG_Parameter: ...
    @overload
    def Add_Info_Value(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: float = 0.0) -> CSG_Parameter: ...
    @overload
    def Add_Bool(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Bool(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Int(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: float = 0.0, Minimum: float = 0.0, bMinimum: bool = False, Maximum: float = 0.0, bMaximum: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Int(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: float = 0.0, Minimum: float = 0.0, bMinimum: bool = False, Maximum: float = 0.0, bMaximum: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Double(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: float = 0.0, Minimum: float = 0.0, bMinimum: bool = False, Maximum: float = 0.0, bMaximum: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Double(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: float = 0.0, Minimum: float = 0.0, bMinimum: bool = False, Maximum: float = 0.0, bMaximum: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Degree(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: float = 0.0, Minimum: float = 0.0, bMinimum: bool = False, Maximum: float = 0.0, bMaximum: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Degree(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: float = 0.0, Minimum: float = 0.0, bMinimum: bool = False, Maximum: float = 0.0, bMaximum: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Date(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: float = 0.0) -> CSG_Parameter: ...
    @overload
    def Add_Date(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: float = 0.0) -> CSG_Parameter: ...
    @overload
    def Add_Color(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: int = 0) -> CSG_Parameter: ...
    @overload
    def Add_Color(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Value: int = 0) -> CSG_Parameter: ...
    @overload
    def Add_Range(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Range_Min: float = 0.0, Range_Max: float = 0.0, Minimum: float = 0.0, bMinimum: bool = False, Maximum: float = 0.0, bMaximum: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Range(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Range_Min: float = 0.0, Range_Max: float = 0.0, Minimum: float = 0.0, bMinimum: bool = False, Maximum: float = 0.0, bMaximum: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Info_Range(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Range_Min: float = 0.0, Range_Max: float = 0.0) -> CSG_Parameter: ...
    @overload
    def Add_Info_Range(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Type: TSG_Parameter_Type, Range_Min: float = 0.0, Range_Max: float = 0.0) -> CSG_Parameter: ...   
    @overload
    def Add_Choice(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Items: CSG_String, Default: int = 0) -> CSG_Parameter: ...
    @overload
    def Add_Choice(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Items: CSG_String, Default: int = 0) -> CSG_Parameter: ...
    @overload
    def Add_String(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, String: CSG_String, bLongText: bool = False, bPassword: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_String(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, String: CSG_String, bLongText: bool = False, bPassword: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Info_String(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, String: CSG_String, bLongText: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Info_String(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, String: CSG_String, bLongText: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_FilePath(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Filter: str = None, Default: str = None, bSave: bool = False, bDirectory: bool = False, bMultiple: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_FilePath(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Filter: str = None, Default: str = None, bSave: bool = False, bDirectory: bool = False, bMultiple: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Font(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, pInit: str = None) -> CSG_Parameter: ...
    @overload
    def Add_Font(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, pInit: str = None) -> CSG_Parameter: ...
    @overload
    def Add_Colors(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Palette: int = 0, nColors: int = 11, bRevert: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Colors(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, pInit: CSG_Colors) -> CSG_Parameter: ...
    @overload
    def Add_Colors(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, pInit: CSG_Colors = None) -> CSG_Parameter: ...
    @overload
    def Add_FixedTable(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, pInit: CSG_Table = None) -> CSG_Parameter: ...
    @overload
    def Add_FixedTable(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, pInit: CSG_Table = None) -> CSG_Parameter: ...
    @overload
    def Add_Grid_System(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, pInit: CSG_Grid_System = None) -> CSG_Parameter: ...
    @overload
    def Add_Grid_System(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, pInit: CSG_Grid_System = None) -> CSG_Parameter: ...
    @overload
    def Add_Grid(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int, bSystem_Dependent: bool = True, Preferred_Type: TSG_Data_Type = SG_DATATYPE_Undefined) -> CSG_Parameter: ...
    @overload
    def Add_Grid(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int, bSystem_Dependent: bool = True, Preferred_Type: TSG_Data_Type = SG_DATATYPE_Undefined) -> CSG_Parameter: ...
    @overload
    def Add_Grid_or_Const(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Value: float = 0.0, Minimum = 0.0, bMinimum: bool = False, Maximum: float = 0.0, bMaximum: bool = False, bSystem_Dependent: bool = True) -> CSG_Parameter: ...
    @overload
    def Add_Grid_or_Const(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Value: float = 0.0, Minimum = 0.0, bMinimum: bool = False, Maximum: float = 0.0, bMaximum: bool = False, bSystem_Dependent: bool = True) -> CSG_Parameter: ...
    @overload
    def Add_Grid_Output(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    @overload
    def Add_Grid_Output(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    @overload
    def Add_Grid_List(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int, bSystem_Dependent: bool = True) -> CSG_Parameter: ...
    @overload
    def Add_Grid_List(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int, bSystem_Dependent: bool = True) -> CSG_Parameter: ...
    @overload
    def Add_Table_Field(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, bAllowNone: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Table_Field(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, bAllowNone: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Table_Field_or_Const(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Value: float = 0.0, Minimum = 0.0, bMinimum: bool = False, Maximum: float = 0.0, bMaximum: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Table_Field_or_Const(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Value: float = 0.0, Minimum = 0.0, bMinimum: bool = False, Maximum: float = 0.0, bMaximum: bool = False) -> CSG_Parameter: ...
    @overload
    def Add_Table_Fields(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    @overload
    def Add_Table_Fields(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    @overload
    def Add_Table(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int) -> CSG_Parameter: ...
    @overload
    def Add_Table(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int) -> CSG_Parameter: ...
    @overload
    def Add_Table_Output(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    @overload
    def Add_Table_Output(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    @overload
    def Add_Table_List(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int) -> CSG_Parameter: ...
    @overload
    def Add_Table_List(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int) -> CSG_Parameter: ...
    @overload
    def Add_Shapes(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int, Shape_Type: TSG_Shape_Type = SHAPE_TYPE_Undefined) -> CSG_Parameter: ...
    @overload
    def Add_Shapes(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int, Shape_Type: TSG_Shape_Type = SHAPE_TYPE_Undefined) -> CSG_Parameter: ...
    @overload
    def Add_Shapes_Output(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    @overload
    def Add_Shapes_Output(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    @overload
    def Add_Shapes_List(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int, Shape_Type: TSG_Shape_Type = SHAPE_TYPE_Undefined) -> CSG_Parameter: ...
    @overload
    def Add_Shapes_List(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int, Shape_Type: TSG_Shape_Type = SHAPE_TYPE_Undefined) -> CSG_Parameter: ...
    @overload
    def Add_TIN(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int) -> CSG_Parameter: ...
    @overload
    def Add_TIN(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int) -> CSG_Parameter: ...
    @overload
    def Add_TIN_Output(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    @overload
    def Add_TIN_Output(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    @overload
    def Add_TIN_List(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int) -> CSG_Parameter: ...
    @overload
    def Add_TIN_List(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int) -> CSG_Parameter: ...
    @overload
    def Add_PointCloud(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int) -> CSG_Parameter: ...
    @overload
    def Add_PointCloud(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int) -> CSG_Parameter: ...
    @overload
    def Add_PointCloud_Output(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    @overload
    def Add_PointCloud_Output(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    @overload
    def Add_PointCloud_List(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int) -> CSG_Parameter: ...
    @overload
    def Add_PointCloud_List(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String, Constraint: int) -> CSG_Parameter: ...
    @overload
    def Add_Parameters(self, ParentID: CSG_String, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...
    @overload
    def Add_Parameters(self, pParent: CSG_Parameter, ID: CSG_String, Name: CSG_String, Description: CSG_String) -> CSG_Parameter: ...

SG_SUMMARY_FMT_FLAT: int
SG_SUMMARY_FMT_HTML: int
SG_SUMMARY_FMT_XML: int

TSG_Summary_Format: TypeAlias = Literal[
    0,  # SG_SUMMARY_FMT_FLAT
    1,  # SG_SUMMARY_FMT_HTML
    2   # SG_SUMMARY_FMT_XML
]

TOOL_TYPE_Base: int
TOOL_TYPE_Interactive: int
TOOL_TYPE_Grid: int
TOOL_TYPE_Grid_Interactive: int
TOOL_TYPE_Chain: int

TSG_Tool_Type: TypeAlias = Literal[
    0,  # TOOL_TYPE_Base
    1,  # TOOL_TYPE_Interactive
    2,  # TOOL_TYPE_Grid
    3,  # TOOL_TYPE_Grid_Interactive
    4   # TOOL_TYPE_Chain
]

TOOL_ERROR_Unknown: int
TOOL_ERROR_Calculation: int

TSG_Tool_Error: TypeAlias = Literal[
    0,  # TOOL_ERROR_Unknown
    1   # TOOL_ERROR_Calculation
]

class CSG_Tool:
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    __swig_destroy__: callable
    def Destroy(self) -> None: ...
    def Get_Type(self) -> TSG_Tool_Type: ...
    def Get_ID(self) -> CSG_String: ...
    def Get_Library(self) -> CSG_String: ...
    def Get_File_Name(self) -> CSG_String: ...
    def Get_Name(self) -> CSG_String: ...
    def Get_Author(self) -> CSG_String: ...
    def Get_Version(self) -> CSG_String: ...
    def Get_Description(self) -> CSG_String: ...
    def Get_References(self) -> CSG_Strings: ...
    def Get_Icon(self) -> bytes: ...
    def Get_Summary(self, bParameters: bool = True, Menu: CSG_String = "", Description: CSG_String = "", Format: int = TSG_Summary_Format.SG_SUMMARY_FMT_HTML) -> CSG_String: ...
    @overload
    def Get_MenuPath(self) -> CSG_String: ...
    @overload
    def Get_MenuPath(self, bSolved: bool) -> CSG_String: ...
    def Get_Parameters_Count(self) -> int: ...
    @overload
    def Get_Parameters(self) -> CSG_Parameters: ...
    @overload
    def Get_Parameters(self, i: int) -> CSG_Parameters: ...
    @overload
    def Get_Parameters(self, Identifier: CSG_String) -> CSG_Parameters: ...
    @overload
    def Get_Parameter(self, ID: Union[CSG_String, str]) -> CSG_Parameter: ...
    @overload
    def Set_Parameter(self, ID: Union[CSG_String, str], pValue: CSG_Parameter) -> bool: ...
    @overload
    def Set_Parameter(self, ID: Union[CSG_String, str], Value: Union[int, float, Any, CSG_String, str], Type = TSG_Parameter_Type.PARAMETER_TYPE_Undefined) -> bool: ...
    def Reset(self, bManager: bool = True) -> bool: ...
    def Reset_Manager(self) -> bool: ...
    def Reset_Grid_System(self) -> bool: ...
    def Update_Parameter_States(self) -> bool: ...
    def Set_Callback(self, bActive: bool = True) -> None: ...
    def Set_Manager(self, pManager: CSG_Data_Manager) -> bool: ...
    def Get_Manager(self) -> CSG_Data_Manager: ...
    def Create_Manager(self) -> CSG_Data_Manager: ...
    def Delete_Manager(self, bDetachData: bool = False, bReset: bool = True) -> bool: ...
    def Set_Grid_System(self, System: CSG_Grid_System) -> bool: ...
    def Get_Grid_System(self) -> CSG_Grid_System: ...
    def Settings_Push(self, pManager: CSG_Data_Manager = ...) -> bool: ...
    def Settings_Pop(self) -> bool: ...
    def do_Sync_Projections(self) -> bool: ...
    def needs_GUI(self) -> bool: ...
    def has_GUI(self) -> bool: ...
    def has_CMD(self) -> bool: ...
    def is_Grid(self) -> bool: ...
    def is_Interactive(self) -> bool: ...
    def is_Progress(self) -> bool: ...
    def is_Executing(self) -> bool: ...
    def Set_Show_Progress(self, bOn: bool = True) -> None: ...
    def On_Before_Execution(self) -> bool: ...
    def On_After_Execution(self) -> bool: ...
    def Execute(self, bAddHistory: bool = False) -> bool: ...
    def Get_Execution_Info(self) -> str: ...
    def Get_History(self, Depth: int = -1) -> CSG_MetaData: ...
    def Set_History(self, pDataObject: CSG_Data_Object, Depth: int = -1) -> bool: ...

    class Script_Format(enum.IntEnum):
        CMD_Shell = 0
        CMD_Batch = 1
        CMD_Usage = 2
        Toolchain = 3
        Python = 4
        Python_Wrapper_Func_Name = 5
        Python_Wrapper_Func_ID = 6
        Python_Wrapper_Call_Name = 7
        Python_Wrapper_Call_ID = 8

    Script_Format: TypeAlias = Literal[
        0,  # CMD_Shell
        1,  # CMD_Batch
        2,  # CMD_Usage
        3,  # Toolchain
        4,  # Python
        5,  # Python_Wrapper_Func_Name
        6,  # Python_Wrapper_Func_ID
        7,  # Python_Wrapper_Call_Name
        8,  # Python_Wrapper_Call_ID
    ]

    def Get_Script(self, Format: int, bHeader: bool = True, Arguments: int = 0, bWrapArgs: bool = True) -> CSG_String: ...

class CSG_Tool_Grid(CSG_Tool):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    __swig_destroy__: callable
    def Get_Type(self) -> TSG_Tool_Type: ...
    def Get_System(self) -> CSG_Grid_System: ...
    def Set_System(self, System: CSG_Grid_System) -> bool: ...
    def is_Grid(self) -> bool: ...

TOOL_INTERACTIVE_UNDEFINED: int
TOOL_INTERACTIVE_LDOWN: int
TOOL_INTERACTIVE_LUP: int
TOOL_INTERACTIVE_LDCLICK: int
TOOL_INTERACTIVE_MDOWN: int
TOOL_INTERACTIVE_MUP: int
TOOL_INTERACTIVE_MDCLICK: int
TOOL_INTERACTIVE_RDOWN: int
TOOL_INTERACTIVE_RUP: int
TOOL_INTERACTIVE_RDCLICK: int
TOOL_INTERACTIVE_MOVE: int
TOOL_INTERACTIVE_MOVE_LDOWN: int
TOOL_INTERACTIVE_MOVE_MDOWN: int
TOOL_INTERACTIVE_MOVE_RDOWN: int

TSG_Tool_Interactive_Mode: TypeAlias = Literal[
    0,  # TOOL_INTERACTIVE_UNDEFINED
    1,  # TOOL_INTERACTIVE_LDOWN
    2,  # TOOL_INTERACTIVE_LUP
    3,  # TOOL_INTERACTIVE_LDCLICK
    4,  # TOOL_INTERACTIVE_MDOWN
    5,  # TOOL_INTERACTIVE_MUP
    6,  # TOOL_INTERACTIVE_MDCLICK
    7,  # TOOL_INTERACTIVE_RDOWN
    8,  # TOOL_INTERACTIVE_RUP
    9,  # TOOL_INTERACTIVE_RDCLICK
    10, # TOOL_INTERACTIVE_MOVE
    11, # TOOL_INTERACTIVE_MOVE_LDOWN
    12, # TOOL_INTERACTIVE_MOVE_MDOWN
    13  # TOOL_INTERACTIVE_MOVE_RDOWN
]

TOOL_INTERACTIVE_DRAG_NONE: int
TOOL_INTERACTIVE_DRAG_LINE: int
TOOL_INTERACTIVE_DRAG_BOX: int
TOOL_INTERACTIVE_DRAG_CIRCLE: int

TSG_Tool_Interactive_DragMode: TypeAlias = Literal[
    0,  # TOOL_INTERACTIVE_DRAG_NONE
    1,  # TOOL_INTERACTIVE_DRAG_LINE
    2,  # TOOL_INTERACTIVE_DRAG_BOX
    3   # TOOL_INTERACTIVE_DRAG_CIRCLE
]

TOOL_INTERACTIVE_KEY_LEFT: int
TOOL_INTERACTIVE_KEY_MIDDLE: int
TOOL_INTERACTIVE_KEY_RIGHT: int
TOOL_INTERACTIVE_KEY_SHIFT: int
TOOL_INTERACTIVE_KEY_ALT: int
TOOL_INTERACTIVE_KEY_CTRL: int

class CSG_Tool_Interactive_Base:
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Set_Projection(self, Projection: CSG_Projection) -> bool: ...
    def Execute_Position(self, ptWorld: CSG_Point, Mode: TSG_Tool_Interactive_Mode, Keys: int) -> bool: ...
    def Execute_Keyboard(self, Character: int, Keys: int) -> bool: ...
    def Execute_Finish(self) -> bool: ...
    def Get_Drag_Mode(self) -> int: ...

class CSG_Tool_Interactive(CSG_Tool_Interactive_Base, CSG_Tool):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    __swig_destroy__: callable
    def Get_Type(self) -> TSG_Tool_Type: ...
    def needs_GUI(self) -> bool: ...
    def is_Interactive(self) -> bool: ...

class CSG_Tool_Grid_Interactive(CSG_Tool_Interactive_Base, CSG_Tool_Grid):
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    __swig_destroy__: callable
    def Get_Type(self) -> TSG_Tool_Type: ...
    def needs_GUI(self) -> bool: ...
    def is_Interactive(self) -> bool: ...

TLB_INFO_Name: int
TLB_INFO_Description: int
TLB_INFO_Author: int
TLB_INFO_Version: int
TLB_INFO_Menu_Path: int
TLB_INFO_Category: int
TLB_INFO_User: int
TLB_INFO_File: int
TLB_INFO_Library: int
TLB_INFO_SAGA_Version: int
TLB_INFO_Count: int

TSG_TLB_Info: TypeAlias = Literal[
    0,  # TLB_INFO_Name
    1,  # TLB_INFO_Description
    2,  # TLB_INFO_Author
    3,  # TLB_INFO_Version
    4,  # TLB_INFO_Menu_Path
    5,  # TLB_INFO_Category
    6,  # TLB_INFO_User
    7,  # TLB_INFO_File
    8,  # TLB_INFO_Library
    9,  # TLB_INFO_SAGA_Version
    10  # TLB_INFO_Count
]

class CSG_Tool_Library_Interface:
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Create(self, Version: CSG_String, TLB_Path: CSG_String, Fnc_Info: Any, Fnc_Create_Tool: Any) -> bool: ...
    def Destroy(self) -> bool: ...
    def Get_Info(self, ID: int) -> CSG_String: ...
    def Get_Count(self) -> int: ...
    def Get_Tool(self, i: int) -> CSG_Tool: ...
    def Create_Tool(self, i: int, bWithGUI: bool = False, bWithCMD: bool = True) -> CSG_Tool: ...
    def Delete_Tool(self, pTool: CSG_Tool) -> bool: ...
    def Delete_Tools(self) -> bool: ...

SYMBOL_TLB_Initialize: str
SYMBOL_TLB_Finalize: str
SYMBOL_TLB_Get_Interface: str

ESG_Library_Type_Library: int
ESG_Library_Type_Chain: int
ESG_Library_Type_Undefined: int

ESG_Library_Type: TypeAlias = Literal[
    0,  # Library
    1,  # Chain
    2   # Undefined
]

class CSG_Tool_Library:
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Get_Type(self) -> ESG_Library_Type: ...
    def is_Valid(self) -> bool: ...
    def Get_Library_Name(self) -> CSG_String: ...
    def Get_Info(self, Type: int) -> CSG_String: ...
    def Get_Name(self) -> CSG_String: ...
    def Get_Description(self) -> CSG_String: ...
    def Get_Author(self) -> CSG_String: ...
    def Get_Version(self) -> CSG_String: ...
    def Get_Category(self) -> CSG_String: ...
    @overload
    def Get_Summary(self, Format: int, bInteractive: bool = True) -> CSG_String: ...
    @overload
    def Get_Summary(self, Path: CSG_String) -> bool: ...
    def Get_Count(self) -> int: ...
    @overload
    def Get_Tool(self, Index: int, Type: TSG_Tool_Type = ...) -> CSG_Tool: ...
    @overload
    def Get_Tool(self, Name: Union[CSG_String, str], Type: TSG_Tool_Type = ...) -> CSG_Tool: ...
    @overload
    def Create_Tool(self, Index: int, bWithGUI: bool = False, bWithCMD: bool = True) -> CSG_Tool: ...
    @overload
    def Create_Tool(self, Name: Union[CSG_String, str], bWithGUI: bool = False, bWithCMD: bool = True) -> CSG_Tool: ...
    def Delete_Tool(self, pTool: CSG_Tool) -> bool: ...
    def Delete_Tools(self) -> bool: ...
    @overload
    def Get_File_Name(self) -> CSG_String: ...
    @overload
    def Get_File_Name(self, i: int) -> CSG_String: ...
    @overload
    def Get_Menu(self) -> CSG_String: ...
    @overload
    def Get_Menu(self, i: int) -> CSG_String: ...
    @overload
    def Add_Reference(self, Authors: CSG_String, Year: CSG_String, Title: CSG_String, Where: CSG_String, Link: Optional[str] = None, Link_Text: Optional[str] = None) -> None: ...
    @overload
    def Add_Reference(self, Link: CSG_String, Link_Text: Optional[str] = None) -> None: ...
    
    def Del_References(self) -> None: ...
    def Get_References(self) -> CSG_Strings: ...

class CSG_Tool_Library_Manager:
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    def Destroy(self) -> bool: ...
    def Get_Count(self) -> int: ...
    def Get_Tool_Count(self) -> int: ...
    def Add_Default_Libraries(self, bVerbose: bool = False) -> bool: ...
    @overload
    def Add_Library(self, File: Union[CSG_String, str]) -> CSG_Tool_Library: ...
    @overload
    def Add_Directory(self, Directory: Union[CSG_String, str], bOnlySubDirectories: bool = False) -> int: ...
    @overload
    def Del_Library(self, i: int) -> bool: ...
    @overload
    def Del_Library(self, pLibrary: CSG_Tool_Library) -> bool: ...
    @overload
    def Get_Library(self, i: int) -> CSG_Tool_Library: ...
    @overload
    def Get_Library(self, Name: Union[CSG_String, str], bLibrary: bool, Type: ESG_Library_Type) -> CSG_Tool_Library: ...
    def is_Loaded(self, pLibrary: CSG_Tool_Library) -> bool: ...
    @overload
    def Get_Tool(self, Library: Union[CSG_String, str], Index: int) -> CSG_Tool: ...
    @overload
    def Get_Tool(self, Library: Union[CSG_String, str], Name: Union[CSG_String, str]) -> CSG_Tool: ...
    @overload
    def Create_Tool(self, Library: Union[CSG_String, str], Index: int, bWithGUI: bool = False, bWithCMD: bool = True) -> CSG_Tool: ...
    @overload
    def Create_Tool(self, Library: Union[CSG_String, str], Name: Union[CSG_String, str], bWithGUI: bool = False, bWithCMD: bool = True) -> CSG_Tool: ...
    def Delete_Tool(self, pTool: CSG_Tool) -> bool: ...
    @overload
    def Get_Summary(self, Format: int = ...) -> CSG_String: ...
    @overload
    def Get_Summary(self, Path: CSG_String) -> bool: ...
    def Create_Python_ToolBox(self, Destination: CSG_String, bClean: bool = True, bName: bool = True, bSingleFile: bool = False) -> bool: ...

def SG_Get_Tool_Library_Manager() -> CSG_Tool_Library_Manager: ...

class CSG_Data_Collection:
    thisown: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def Count(self) -> int: ...
    def Get(self, i: int) -> CSG_Data_Object: ...
    @overload
    def Delete(self, pObject: CSG_Data_Object, bDetach: bool = False) -> bool: ...
    @overload
    def Delete(self, i: int, bDetach: bool = False) -> bool: ...
    @overload
    def Delete(self, bDetach: bool = False, bUnsaved: bool = False) -> bool: ...
    def Find(self, File: CSG_String, bNative: bool = True) -> CSG_Data_Object: ...
    def Exists(self, pObject: CSG_Data_Object) -> bool: ...
   

class CSG_Data_Manager:
    thisown: bool
    def __init__(self) -> None: ...
    __swig_destroy__: callable
    @overload
    def Table(self) -> CSG_Data_Collection: ...
    @overload
    def Table(self, i: int) -> CSG_Table: ...
    @overload
    def TIN(self) -> CSG_Data_Collection: ...
    @overload
    def TIN(self, i: int) -> CSG_TIN: ...
    @overload
    def PointCloud(self) -> CSG_Data_Collection: ...
    @overload
    def PointCloud(self, i: int) -> CSG_PointCloud: ...
    @overload
    def Shapes(self) -> CSG_Data_Collection: ...
    @overload
    def Shapes(self, i: int) -> CSG_Shapes: ...
    @overload
    def Grid(self) -> CSG_Data_Collection: ...
    @overload
    def Grid(self, i: int) -> CSG_Grid: ...
    @overload
    def Grids(self) -> CSG_Data_Collection: ...
    @overload
    def Grids(self, i: int) -> CSG_Grids: ...
    @overload
    def Add(self, pObject: CSG_Data_Object) -> CSG_Data_Object: ...
    @overload
    def Add(self, File: Union[CSG_String, str], Type: TSG_Data_Object_Type = ...) -> CSG_Data_Object: ...
    @overload
    def Add_Table(self) -> CSG_Table: ...
    @overload
    def Add_Table(self, File: Union[CSG_String, str]) -> CSG_Table: ...
    @overload
    def Add_Shapes(self) -> CSG_Shapes: ...
    @overload
    def Add_Shapes(self, File: Union[CSG_String, str]) -> CSG_Shapes: ...
    @overload
    def Add_PointCloud(self) -> CSG_PointCloud: ...
    @overload
    def Add_PointCloud(self, File: Union[CSG_String, str]) -> CSG_PointCloud: ...
    @overload
    def Add_TIN(self) -> CSG_TIN: ...
    @overload
    def Add_TIN(self, File: Union[CSG_String, str]) -> CSG_TIN: ...
    @overload
    def Add_Grid(self) -> CSG_Grid: ...
    @overload
    def Add_Grid(self, File: Union[CSG_String, str]) -> CSG_Grid: ...
    @overload
    def Add_Grids(self) -> CSG_Grids: ...
    @overload
    def Add_Grids(self, File: Union[CSG_String, str]) -> CSG_Grids: ...
    @overload
    def Delete(self, pObject: CSG_Data_Object, bDetach: bool = False) -> bool: ...
    @overload
    def Delete(self, bDetach: bool = False, bUnsaved: bool = False) -> bool: ...
    def Find(self, File: CSG_String, bNative: bool = True) -> CSG_Data_Object: ...
    def Exists(self, pObject: CSG_Data_Object) -> bool: ...
    def Get_Summary(self) -> CSG_String: ...

def SG_Get_Data_Manager()-> CSG_Data_Manager: ...

SAGA_MAJOR_VERSION: int
SAGA_MINOR_VERSION: int
SAGA_RELEASE_NUMBER: int
SAGA_VERSION: str

def SAGA_API_Get_Version() -> str: ...
@overload
def SG_Compare_Version(Version: CSG_String, Mayjor: int, Minor: int, Release: int) -> int: ...
@overload
def SG_Compare_Version(Version: CSG_String, Release: CSG_String) -> int: ...
@overload
def SG_Compare_SAGA_Version(Version: CSG_String) -> int: ...
@overload
def SG_Compare_SAGA_Version(Mayjor: int, Minor: int, Release: int) -> int: ...
