## Pygame Documentation Overview

### Accessing Documentation

Obviously you can visit pygame.org/docs to see the documentation, 
but the documentation can also be launched with `python -m pygame.docs`

### Generating the Documentation

Steps:
- Have Python 3.6 or higher
- install Sphinx (`pip install Sphinx==4.5.0`)
- fork the pygame repository, download and navigate to it in the terminal
- run `python setup.py docs`

This will create a new folder under the `docs` folder. 
In `docs/generated`, you will find a local copy of the pygame documentation.

You can launch this by clicking on index.html or by running the command
`python -m docs` from the pygame folder. (The same as manually running
__main__.py in `docs/`). The docs launch command will direct you to the
pygame website if there aren't any locally generated docs.

There is also a `docs --fullgeneration` or `docs --f` command for regenerating
everything regardless of whether Sphinx thinks it should be regenerated. This
is useful when editing the theme CSS.

###  Contributing

If you see any grammatical mistakes or errors in the documentation,
contributing to the docs is a great way to help out.

For simple things, no issue is necessary -- but if you want to change
something complex it would be best to open an issue first.

Some background that may help with changes: pygame's documentation
is written in rst files, which stands for "ReStructured Text." We use Sphinx
([Sphinx Documentation](https://www.sphinx-doc.org/en/master/)) to convert
these rst files into html, which are then hosted on the pygame website.

Sphinx has a good ReStructured Text primer to learn the basics:
https://www.sphinx-doc.org/en/master/usage/restructuredtext/basics.html

Contributing steps:
- Have an idea to improve the docs, perhaps create an issue on GitHub
- Find the file you want to edit: it will most likely be in `docs/reST/ref`.
OR
- Pygame docs pages have an "Edit on GitHub" button, which will show you the file
- Download the pygame source from GitHub locally.  
     ^ One way to do this is to fork and use a Git client to make that a local repository
- Implement your idea.
- Follow the steps in "Generating the Documentation"
     ^ This is important to test your changes work well
- Commit your changes, create a pull request

## Documentation Style

The pygame documentation files have developed the convention of a 79 character
line limit, from PEP8.

They also use a 3 space indent.

## Pygame Documentation Implementation Details

This is meant to be a place for explanations of things that may confuse people
in the future.

### Hidden modules

Pygame still has documentation for the old cdrom and Overlay modules, which
are discontinued in SDL2 based pygame (pygame 2). It just doesn't show them,
because `docs/reST/themes/classic/elements.html` now has a list of
"blacklisted" modules to not put into the top bar. It also uses this for the
experimental sdl2_video docs.

### Styling / Themes

CSS rules for the generated HTML come from
`docs/reST/themes/classic/static/pygame.css_t`. This, in turn, inherits rules
from Sphinx's basic.css, which is autogenerated when Sphinx builds.

This is an example of a
[Sphinx static template](https://www.sphinx-doc.org/en/master/development/theming.html#static-templates)