# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221001

from __future__ import absolute_import

from .assertion_details import AssertionDetails
from .batch_detect_dominant_language_details import BatchDetectDominantLanguageDetails
from .batch_detect_dominant_language_result import BatchDetectDominantLanguageResult
from .batch_detect_health_entity_details import BatchDetectHealthEntityDetails
from .batch_detect_health_entity_result import BatchDetectHealthEntityResult
from .batch_detect_language_entities_details import BatchDetectLanguageEntitiesDetails
from .batch_detect_language_entities_result import BatchDetectLanguageEntitiesResult
from .batch_detect_language_key_phrases_details import BatchDetectLanguageKeyPhrasesDetails
from .batch_detect_language_key_phrases_result import BatchDetectLanguageKeyPhrasesResult
from .batch_detect_language_pii_entities_details import BatchDetectLanguagePiiEntitiesDetails
from .batch_detect_language_pii_entities_result import BatchDetectLanguagePiiEntitiesResult
from .batch_detect_language_sentiments_details import BatchDetectLanguageSentimentsDetails
from .batch_detect_language_sentiments_result import BatchDetectLanguageSentimentsResult
from .batch_detect_language_text_classification_details import BatchDetectLanguageTextClassificationDetails
from .batch_detect_language_text_classification_result import BatchDetectLanguageTextClassificationResult
from .batch_language_translation_details import BatchLanguageTranslationDetails
from .batch_language_translation_result import BatchLanguageTranslationResult
from .capabilities import Capabilities
from .capability import Capability
from .change_endpoint_compartment_details import ChangeEndpointCompartmentDetails
from .change_job_compartment_details import ChangeJobCompartmentDetails
from .change_model_compartment_details import ChangeModelCompartmentDetails
from .change_project_compartment_details import ChangeProjectCompartmentDetails
from .class_metrics import ClassMetrics
from .classification_multi_class_mode_details import ClassificationMultiClassModeDetails
from .classification_multi_label_mode_details import ClassificationMultiLabelModeDetails
from .classification_type import ClassificationType
from .configuration_details import ConfigurationDetails
from .confusion_matrix_details import ConfusionMatrixDetails
from .create_endpoint_details import CreateEndpointDetails
from .create_job_details import CreateJobDetails
from .create_model_details import CreateModelDetails
from .create_project_details import CreateProjectDetails
from .data_science_labeling_dataset import DataScienceLabelingDataset
from .dataset_details import DatasetDetails
from .detect_dominant_language_details import DetectDominantLanguageDetails
from .detect_dominant_language_result import DetectDominantLanguageResult
from .detect_language_entities_details import DetectLanguageEntitiesDetails
from .detect_language_entities_result import DetectLanguageEntitiesResult
from .detect_language_key_phrases_details import DetectLanguageKeyPhrasesDetails
from .detect_language_key_phrases_result import DetectLanguageKeyPhrasesResult
from .detect_language_sentiments_details import DetectLanguageSentimentsDetails
from .detect_language_sentiments_result import DetectLanguageSentimentsResult
from .detect_language_text_classification_details import DetectLanguageTextClassificationDetails
from .detect_language_text_classification_result import DetectLanguageTextClassificationResult
from .detected_language import DetectedLanguage
from .document_error import DocumentError
from .documents_configuration import DocumentsConfiguration
from .dominant_language_document import DominantLanguageDocument
from .dominant_language_document_result import DominantLanguageDocumentResult
from .endpoint import Endpoint
from .endpoint_collection import EndpointCollection
from .endpoint_summary import EndpointSummary
from .entity import Entity
from .entity_document_result import EntityDocumentResult
from .entity_label_error_analysis import EntityLabelErrorAnalysis
from .entity_metrics import EntityMetrics
from .error_details import ErrorDetails
from .evaluation_result_collection import EvaluationResultCollection
from .evaluation_result_summary import EvaluationResultSummary
from .evaluation_results import EvaluationResults
from .health_entity import HealthEntity
from .health_entity_document_result import HealthEntityDocumentResult
from .hierarchical_entity import HierarchicalEntity
from .input_configuration import InputConfiguration
from .input_location import InputLocation
from .job import Job
from .job_collection import JobCollection
from .job_summary import JobSummary
from .key_phrase import KeyPhrase
from .key_phrase_document_result import KeyPhraseDocumentResult
from .location_details import LocationDetails
from .mel_concept import MelConcept
from .mel_concept_details import MelConceptDetails
from .model import Model
from .model_collection import ModelCollection
from .model_details import ModelDetails
from .model_metadata_details import ModelMetadataDetails
from .model_summary import ModelSummary
from .model_type_info import ModelTypeInfo
from .named_entity_recognition_evaluation_result import NamedEntityRecognitionEvaluationResult
from .named_entity_recognition_evaluation_results import NamedEntityRecognitionEvaluationResults
from .named_entity_recognition_model_details import NamedEntityRecognitionModelDetails
from .named_entity_recognition_model_metrics import NamedEntityRecognitionModelMetrics
from .object_list_dataset import ObjectListDataset
from .object_prefix_output_location import ObjectPrefixOutputLocation
from .object_storage_dataset import ObjectStorageDataset
from .object_storage_file_name_location import ObjectStorageFileNameLocation
from .object_storage_prefix_location import ObjectStoragePrefixLocation
from .pii_entity import PiiEntity
from .pii_entity_document_result import PiiEntityDocumentResult
from .pii_entity_mask import PiiEntityMask
from .pii_entity_masking import PiiEntityMasking
from .pii_entity_remove import PiiEntityRemove
from .pii_entity_replace import PiiEntityReplace
from .pii_model_details import PiiModelDetails
from .pre_deployed_language_models import PreDeployedLanguageModels
from .pre_trained_health_nlu_model_details import PreTrainedHealthNluModelDetails
from .pre_trained_key_phrase_extraction_model_details import PreTrainedKeyPhraseExtractionModelDetails
from .pre_trained_language_detection_model_details import PreTrainedLanguageDetectionModelDetails
from .pre_trained_named_entity_recognition_model_details import PreTrainedNamedEntityRecognitionModelDetails
from .pre_trained_pii_model_details import PreTrainedPiiModelDetails
from .pre_trained_sentiment_analysis_model_details import PreTrainedSentimentAnalysisModelDetails
from .pre_trained_summarization import PreTrainedSummarization
from .pre_trained_text_classification_model_details import PreTrainedTextClassificationModelDetails
from .pre_trained_universal_model import PreTrainedUniversalModel
from .profile import Profile
from .project import Project
from .project_collection import ProjectCollection
from .project_summary import ProjectSummary
from .relation_entity import RelationEntity
from .resolved_entities import ResolvedEntities
from .resolved_entity import ResolvedEntity
from .sentiment_aspect import SentimentAspect
from .sentiment_document_result import SentimentDocumentResult
from .sentiment_sentence import SentimentSentence
from .test_and_validation_dataset_strategy import TestAndValidationDatasetStrategy
from .test_strategy import TestStrategy
from .text_classification import TextClassification
from .text_classification_document_result import TextClassificationDocumentResult
from .text_classification_evaluation_results import TextClassificationEvaluationResults
from .text_classification_model_details import TextClassificationModelDetails
from .text_classification_model_evaluation_result import TextClassificationModelEvaluationResult
from .text_classification_model_metrics import TextClassificationModelMetrics
from .text_document import TextDocument
from .translation_document_result import TranslationDocumentResult
from .update_endpoint_details import UpdateEndpointDetails
from .update_job_details import UpdateJobDetails
from .update_model_details import UpdateModelDetails
from .update_project_details import UpdateProjectDetails
from .work_request import WorkRequest
from .work_request_error import WorkRequestError
from .work_request_error_collection import WorkRequestErrorCollection
from .work_request_log import WorkRequestLog
from .work_request_log_collection import WorkRequestLogCollection
from .work_request_resource import WorkRequestResource
from .work_request_summary import WorkRequestSummary
from .work_request_summary_collection import WorkRequestSummaryCollection

# Maps type names to classes for ai_language services.
ai_language_type_mapping = {
    "AssertionDetails": AssertionDetails,
    "BatchDetectDominantLanguageDetails": BatchDetectDominantLanguageDetails,
    "BatchDetectDominantLanguageResult": BatchDetectDominantLanguageResult,
    "BatchDetectHealthEntityDetails": BatchDetectHealthEntityDetails,
    "BatchDetectHealthEntityResult": BatchDetectHealthEntityResult,
    "BatchDetectLanguageEntitiesDetails": BatchDetectLanguageEntitiesDetails,
    "BatchDetectLanguageEntitiesResult": BatchDetectLanguageEntitiesResult,
    "BatchDetectLanguageKeyPhrasesDetails": BatchDetectLanguageKeyPhrasesDetails,
    "BatchDetectLanguageKeyPhrasesResult": BatchDetectLanguageKeyPhrasesResult,
    "BatchDetectLanguagePiiEntitiesDetails": BatchDetectLanguagePiiEntitiesDetails,
    "BatchDetectLanguagePiiEntitiesResult": BatchDetectLanguagePiiEntitiesResult,
    "BatchDetectLanguageSentimentsDetails": BatchDetectLanguageSentimentsDetails,
    "BatchDetectLanguageSentimentsResult": BatchDetectLanguageSentimentsResult,
    "BatchDetectLanguageTextClassificationDetails": BatchDetectLanguageTextClassificationDetails,
    "BatchDetectLanguageTextClassificationResult": BatchDetectLanguageTextClassificationResult,
    "BatchLanguageTranslationDetails": BatchLanguageTranslationDetails,
    "BatchLanguageTranslationResult": BatchLanguageTranslationResult,
    "Capabilities": Capabilities,
    "Capability": Capability,
    "ChangeEndpointCompartmentDetails": ChangeEndpointCompartmentDetails,
    "ChangeJobCompartmentDetails": ChangeJobCompartmentDetails,
    "ChangeModelCompartmentDetails": ChangeModelCompartmentDetails,
    "ChangeProjectCompartmentDetails": ChangeProjectCompartmentDetails,
    "ClassMetrics": ClassMetrics,
    "ClassificationMultiClassModeDetails": ClassificationMultiClassModeDetails,
    "ClassificationMultiLabelModeDetails": ClassificationMultiLabelModeDetails,
    "ClassificationType": ClassificationType,
    "ConfigurationDetails": ConfigurationDetails,
    "ConfusionMatrixDetails": ConfusionMatrixDetails,
    "CreateEndpointDetails": CreateEndpointDetails,
    "CreateJobDetails": CreateJobDetails,
    "CreateModelDetails": CreateModelDetails,
    "CreateProjectDetails": CreateProjectDetails,
    "DataScienceLabelingDataset": DataScienceLabelingDataset,
    "DatasetDetails": DatasetDetails,
    "DetectDominantLanguageDetails": DetectDominantLanguageDetails,
    "DetectDominantLanguageResult": DetectDominantLanguageResult,
    "DetectLanguageEntitiesDetails": DetectLanguageEntitiesDetails,
    "DetectLanguageEntitiesResult": DetectLanguageEntitiesResult,
    "DetectLanguageKeyPhrasesDetails": DetectLanguageKeyPhrasesDetails,
    "DetectLanguageKeyPhrasesResult": DetectLanguageKeyPhrasesResult,
    "DetectLanguageSentimentsDetails": DetectLanguageSentimentsDetails,
    "DetectLanguageSentimentsResult": DetectLanguageSentimentsResult,
    "DetectLanguageTextClassificationDetails": DetectLanguageTextClassificationDetails,
    "DetectLanguageTextClassificationResult": DetectLanguageTextClassificationResult,
    "DetectedLanguage": DetectedLanguage,
    "DocumentError": DocumentError,
    "DocumentsConfiguration": DocumentsConfiguration,
    "DominantLanguageDocument": DominantLanguageDocument,
    "DominantLanguageDocumentResult": DominantLanguageDocumentResult,
    "Endpoint": Endpoint,
    "EndpointCollection": EndpointCollection,
    "EndpointSummary": EndpointSummary,
    "Entity": Entity,
    "EntityDocumentResult": EntityDocumentResult,
    "EntityLabelErrorAnalysis": EntityLabelErrorAnalysis,
    "EntityMetrics": EntityMetrics,
    "ErrorDetails": ErrorDetails,
    "EvaluationResultCollection": EvaluationResultCollection,
    "EvaluationResultSummary": EvaluationResultSummary,
    "EvaluationResults": EvaluationResults,
    "HealthEntity": HealthEntity,
    "HealthEntityDocumentResult": HealthEntityDocumentResult,
    "HierarchicalEntity": HierarchicalEntity,
    "InputConfiguration": InputConfiguration,
    "InputLocation": InputLocation,
    "Job": Job,
    "JobCollection": JobCollection,
    "JobSummary": JobSummary,
    "KeyPhrase": KeyPhrase,
    "KeyPhraseDocumentResult": KeyPhraseDocumentResult,
    "LocationDetails": LocationDetails,
    "MelConcept": MelConcept,
    "MelConceptDetails": MelConceptDetails,
    "Model": Model,
    "ModelCollection": ModelCollection,
    "ModelDetails": ModelDetails,
    "ModelMetadataDetails": ModelMetadataDetails,
    "ModelSummary": ModelSummary,
    "ModelTypeInfo": ModelTypeInfo,
    "NamedEntityRecognitionEvaluationResult": NamedEntityRecognitionEvaluationResult,
    "NamedEntityRecognitionEvaluationResults": NamedEntityRecognitionEvaluationResults,
    "NamedEntityRecognitionModelDetails": NamedEntityRecognitionModelDetails,
    "NamedEntityRecognitionModelMetrics": NamedEntityRecognitionModelMetrics,
    "ObjectListDataset": ObjectListDataset,
    "ObjectPrefixOutputLocation": ObjectPrefixOutputLocation,
    "ObjectStorageDataset": ObjectStorageDataset,
    "ObjectStorageFileNameLocation": ObjectStorageFileNameLocation,
    "ObjectStoragePrefixLocation": ObjectStoragePrefixLocation,
    "PiiEntity": PiiEntity,
    "PiiEntityDocumentResult": PiiEntityDocumentResult,
    "PiiEntityMask": PiiEntityMask,
    "PiiEntityMasking": PiiEntityMasking,
    "PiiEntityRemove": PiiEntityRemove,
    "PiiEntityReplace": PiiEntityReplace,
    "PiiModelDetails": PiiModelDetails,
    "PreDeployedLanguageModels": PreDeployedLanguageModels,
    "PreTrainedHealthNluModelDetails": PreTrainedHealthNluModelDetails,
    "PreTrainedKeyPhraseExtractionModelDetails": PreTrainedKeyPhraseExtractionModelDetails,
    "PreTrainedLanguageDetectionModelDetails": PreTrainedLanguageDetectionModelDetails,
    "PreTrainedNamedEntityRecognitionModelDetails": PreTrainedNamedEntityRecognitionModelDetails,
    "PreTrainedPiiModelDetails": PreTrainedPiiModelDetails,
    "PreTrainedSentimentAnalysisModelDetails": PreTrainedSentimentAnalysisModelDetails,
    "PreTrainedSummarization": PreTrainedSummarization,
    "PreTrainedTextClassificationModelDetails": PreTrainedTextClassificationModelDetails,
    "PreTrainedUniversalModel": PreTrainedUniversalModel,
    "Profile": Profile,
    "Project": Project,
    "ProjectCollection": ProjectCollection,
    "ProjectSummary": ProjectSummary,
    "RelationEntity": RelationEntity,
    "ResolvedEntities": ResolvedEntities,
    "ResolvedEntity": ResolvedEntity,
    "SentimentAspect": SentimentAspect,
    "SentimentDocumentResult": SentimentDocumentResult,
    "SentimentSentence": SentimentSentence,
    "TestAndValidationDatasetStrategy": TestAndValidationDatasetStrategy,
    "TestStrategy": TestStrategy,
    "TextClassification": TextClassification,
    "TextClassificationDocumentResult": TextClassificationDocumentResult,
    "TextClassificationEvaluationResults": TextClassificationEvaluationResults,
    "TextClassificationModelDetails": TextClassificationModelDetails,
    "TextClassificationModelEvaluationResult": TextClassificationModelEvaluationResult,
    "TextClassificationModelMetrics": TextClassificationModelMetrics,
    "TextDocument": TextDocument,
    "TranslationDocumentResult": TranslationDocumentResult,
    "UpdateEndpointDetails": UpdateEndpointDetails,
    "UpdateJobDetails": UpdateJobDetails,
    "UpdateModelDetails": UpdateModelDetails,
    "UpdateProjectDetails": UpdateProjectDetails,
    "WorkRequest": WorkRequest,
    "WorkRequestError": WorkRequestError,
    "WorkRequestErrorCollection": WorkRequestErrorCollection,
    "WorkRequestLog": WorkRequestLog,
    "WorkRequestLogCollection": WorkRequestLogCollection,
    "WorkRequestResource": WorkRequestResource,
    "WorkRequestSummary": WorkRequestSummary,
    "WorkRequestSummaryCollection": WorkRequestSummaryCollection
}
