# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Link(object):
    """
    Details of the link between two nodes.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Link object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Link.
        :type id: str

        :param source:
            The value to assign to the source property of this Link.
        :type source: str

        :param destination:
            The value to assign to the destination property of this Link.
        :type destination: str

        :param repeat_count:
            The value to assign to the repeat_count property of this Link.
        :type repeat_count: int

        :param forwarding_loss:
            The value to assign to the forwarding_loss property of this Link.
        :type forwarding_loss: float

        :param delay_in_milliseconds:
            The value to assign to the delay_in_milliseconds property of this Link.
        :type delay_in_milliseconds: float

        :param min_delay_in_milliseconds:
            The value to assign to the min_delay_in_milliseconds property of this Link.
        :type min_delay_in_milliseconds: float

        :param max_delay_in_milliseconds:
            The value to assign to the max_delay_in_milliseconds property of this Link.
        :type max_delay_in_milliseconds: float

        :param paths:
            The value to assign to the paths property of this Link.
        :type paths: list[str]

        """
        self.swagger_types = {
            'id': 'str',
            'source': 'str',
            'destination': 'str',
            'repeat_count': 'int',
            'forwarding_loss': 'float',
            'delay_in_milliseconds': 'float',
            'min_delay_in_milliseconds': 'float',
            'max_delay_in_milliseconds': 'float',
            'paths': 'list[str]'
        }

        self.attribute_map = {
            'id': 'id',
            'source': 'source',
            'destination': 'destination',
            'repeat_count': 'repeatCount',
            'forwarding_loss': 'forwardingLoss',
            'delay_in_milliseconds': 'delayInMilliseconds',
            'min_delay_in_milliseconds': 'minDelayInMilliseconds',
            'max_delay_in_milliseconds': 'maxDelayInMilliseconds',
            'paths': 'paths'
        }

        self._id = None
        self._source = None
        self._destination = None
        self._repeat_count = None
        self._forwarding_loss = None
        self._delay_in_milliseconds = None
        self._min_delay_in_milliseconds = None
        self._max_delay_in_milliseconds = None
        self._paths = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Link.
        ID of the link.


        :return: The id of this Link.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Link.
        ID of the link.


        :param id: The id of this Link.
        :type: str
        """
        self._id = id

    @property
    def source(self):
        """
        Gets the source of this Link.
        ID of the source node.


        :return: The source of this Link.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this Link.
        ID of the source node.


        :param source: The source of this Link.
        :type: str
        """
        self._source = source

    @property
    def destination(self):
        """
        Gets the destination of this Link.
        ID of the destination node.


        :return: The destination of this Link.
        :rtype: str
        """
        return self._destination

    @destination.setter
    def destination(self, destination):
        """
        Sets the destination of this Link.
        ID of the destination node.


        :param destination: The destination of this Link.
        :type: str
        """
        self._destination = destination

    @property
    def repeat_count(self):
        """
        Gets the repeat_count of this Link.
        Number of times the link is repeated.


        :return: The repeat_count of this Link.
        :rtype: int
        """
        return self._repeat_count

    @repeat_count.setter
    def repeat_count(self, repeat_count):
        """
        Sets the repeat_count of this Link.
        Number of times the link is repeated.


        :param repeat_count: The repeat_count of this Link.
        :type: int
        """
        self._repeat_count = repeat_count

    @property
    def forwarding_loss(self):
        """
        Gets the forwarding_loss of this Link.
        Average packet loss.


        :return: The forwarding_loss of this Link.
        :rtype: float
        """
        return self._forwarding_loss

    @forwarding_loss.setter
    def forwarding_loss(self, forwarding_loss):
        """
        Sets the forwarding_loss of this Link.
        Average packet loss.


        :param forwarding_loss: The forwarding_loss of this Link.
        :type: float
        """
        self._forwarding_loss = forwarding_loss

    @property
    def delay_in_milliseconds(self):
        """
        Gets the delay_in_milliseconds of this Link.
        Difference of the packet response time between source and destination nodes, in milliseconds.


        :return: The delay_in_milliseconds of this Link.
        :rtype: float
        """
        return self._delay_in_milliseconds

    @delay_in_milliseconds.setter
    def delay_in_milliseconds(self, delay_in_milliseconds):
        """
        Sets the delay_in_milliseconds of this Link.
        Difference of the packet response time between source and destination nodes, in milliseconds.


        :param delay_in_milliseconds: The delay_in_milliseconds of this Link.
        :type: float
        """
        self._delay_in_milliseconds = delay_in_milliseconds

    @property
    def min_delay_in_milliseconds(self):
        """
        Gets the min_delay_in_milliseconds of this Link.
        Minimum delay in milliseconds.


        :return: The min_delay_in_milliseconds of this Link.
        :rtype: float
        """
        return self._min_delay_in_milliseconds

    @min_delay_in_milliseconds.setter
    def min_delay_in_milliseconds(self, min_delay_in_milliseconds):
        """
        Sets the min_delay_in_milliseconds of this Link.
        Minimum delay in milliseconds.


        :param min_delay_in_milliseconds: The min_delay_in_milliseconds of this Link.
        :type: float
        """
        self._min_delay_in_milliseconds = min_delay_in_milliseconds

    @property
    def max_delay_in_milliseconds(self):
        """
        Gets the max_delay_in_milliseconds of this Link.
        Maximum delay in milliseconds.


        :return: The max_delay_in_milliseconds of this Link.
        :rtype: float
        """
        return self._max_delay_in_milliseconds

    @max_delay_in_milliseconds.setter
    def max_delay_in_milliseconds(self, max_delay_in_milliseconds):
        """
        Sets the max_delay_in_milliseconds of this Link.
        Maximum delay in milliseconds.


        :param max_delay_in_milliseconds: The max_delay_in_milliseconds of this Link.
        :type: float
        """
        self._max_delay_in_milliseconds = max_delay_in_milliseconds

    @property
    def paths(self):
        """
        Gets the paths of this Link.
        List of all path IDs of which this link is part of.


        :return: The paths of this Link.
        :rtype: list[str]
        """
        return self._paths

    @paths.setter
    def paths(self, paths):
        """
        Sets the paths of this Link.
        List of all path IDs of which this link is part of.


        :param paths: The paths of this Link.
        :type: list[str]
        """
        self._paths = paths

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
