# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200131


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourceVulnerability(object):
    """
    CG vulnerability object
    """

    #: A constant which can be used with the risk_level property of a ResourceVulnerability.
    #: This constant has a value of "CRITICAL"
    RISK_LEVEL_CRITICAL = "CRITICAL"

    #: A constant which can be used with the risk_level property of a ResourceVulnerability.
    #: This constant has a value of "HIGH"
    RISK_LEVEL_HIGH = "HIGH"

    #: A constant which can be used with the risk_level property of a ResourceVulnerability.
    #: This constant has a value of "MEDIUM"
    RISK_LEVEL_MEDIUM = "MEDIUM"

    #: A constant which can be used with the risk_level property of a ResourceVulnerability.
    #: This constant has a value of "LOW"
    RISK_LEVEL_LOW = "LOW"

    #: A constant which can be used with the risk_level property of a ResourceVulnerability.
    #: This constant has a value of "MINOR"
    RISK_LEVEL_MINOR = "MINOR"

    #: A constant which can be used with the risk_level property of a ResourceVulnerability.
    #: This constant has a value of "NONE"
    RISK_LEVEL_NONE = "NONE"

    def __init__(self, **kwargs):
        """
        Initializes a new ResourceVulnerability object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ResourceVulnerability.
        :type id: str

        :param description:
            The value to assign to the description property of this ResourceVulnerability.
        :type description: str

        :param risk_level:
            The value to assign to the risk_level property of this ResourceVulnerability.
            Allowed values for this property are: "CRITICAL", "HIGH", "MEDIUM", "LOW", "MINOR", "NONE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type risk_level: str

        :param url:
            The value to assign to the url property of this ResourceVulnerability.
        :type url: str

        :param time_first_detected:
            The value to assign to the time_first_detected property of this ResourceVulnerability.
        :type time_first_detected: datetime

        :param time_last_detected:
            The value to assign to the time_last_detected property of this ResourceVulnerability.
        :type time_last_detected: datetime

        :param time_published:
            The value to assign to the time_published property of this ResourceVulnerability.
        :type time_published: datetime

        :param time_last_modified:
            The value to assign to the time_last_modified property of this ResourceVulnerability.
        :type time_last_modified: datetime

        :param cvss_score:
            The value to assign to the cvss_score property of this ResourceVulnerability.
        :type cvss_score: str

        :param package_details:
            The value to assign to the package_details property of this ResourceVulnerability.
        :type package_details: list[oci.cloud_guard.models.PackageDetail]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ResourceVulnerability.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ResourceVulnerability.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ResourceVulnerability.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'description': 'str',
            'risk_level': 'str',
            'url': 'str',
            'time_first_detected': 'datetime',
            'time_last_detected': 'datetime',
            'time_published': 'datetime',
            'time_last_modified': 'datetime',
            'cvss_score': 'str',
            'package_details': 'list[PackageDetail]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'description': 'description',
            'risk_level': 'riskLevel',
            'url': 'url',
            'time_first_detected': 'timeFirstDetected',
            'time_last_detected': 'timeLastDetected',
            'time_published': 'timePublished',
            'time_last_modified': 'timeLastModified',
            'cvss_score': 'cvssScore',
            'package_details': 'packageDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }

        self._id = None
        self._description = None
        self._risk_level = None
        self._url = None
        self._time_first_detected = None
        self._time_last_detected = None
        self._time_published = None
        self._time_last_modified = None
        self._cvss_score = None
        self._package_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ResourceVulnerability.
        The cve id of the vulnerability


        :return: The id of this ResourceVulnerability.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ResourceVulnerability.
        The cve id of the vulnerability


        :param id: The id of this ResourceVulnerability.
        :type: str
        """
        self._id = id

    @property
    def description(self):
        """
        **[Required]** Gets the description of this ResourceVulnerability.
        The description of the vulnerability


        :return: The description of this ResourceVulnerability.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ResourceVulnerability.
        The description of the vulnerability


        :param description: The description of this ResourceVulnerability.
        :type: str
        """
        self._description = description

    @property
    def risk_level(self):
        """
        **[Required]** Gets the risk_level of this ResourceVulnerability.
        The Risk Level

        Allowed values for this property are: "CRITICAL", "HIGH", "MEDIUM", "LOW", "MINOR", "NONE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The risk_level of this ResourceVulnerability.
        :rtype: str
        """
        return self._risk_level

    @risk_level.setter
    def risk_level(self, risk_level):
        """
        Sets the risk_level of this ResourceVulnerability.
        The Risk Level


        :param risk_level: The risk_level of this ResourceVulnerability.
        :type: str
        """
        allowed_values = ["CRITICAL", "HIGH", "MEDIUM", "LOW", "MINOR", "NONE"]
        if not value_allowed_none_or_none_sentinel(risk_level, allowed_values):
            risk_level = 'UNKNOWN_ENUM_VALUE'
        self._risk_level = risk_level

    @property
    def url(self):
        """
        Gets the url of this ResourceVulnerability.
        URL of the CVE


        :return: The url of this ResourceVulnerability.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this ResourceVulnerability.
        URL of the CVE


        :param url: The url of this ResourceVulnerability.
        :type: str
        """
        self._url = url

    @property
    def time_first_detected(self):
        """
        Gets the time_first_detected of this ResourceVulnerability.
        First detected time


        :return: The time_first_detected of this ResourceVulnerability.
        :rtype: datetime
        """
        return self._time_first_detected

    @time_first_detected.setter
    def time_first_detected(self, time_first_detected):
        """
        Sets the time_first_detected of this ResourceVulnerability.
        First detected time


        :param time_first_detected: The time_first_detected of this ResourceVulnerability.
        :type: datetime
        """
        self._time_first_detected = time_first_detected

    @property
    def time_last_detected(self):
        """
        Gets the time_last_detected of this ResourceVulnerability.
        First detected time


        :return: The time_last_detected of this ResourceVulnerability.
        :rtype: datetime
        """
        return self._time_last_detected

    @time_last_detected.setter
    def time_last_detected(self, time_last_detected):
        """
        Sets the time_last_detected of this ResourceVulnerability.
        First detected time


        :param time_last_detected: The time_last_detected of this ResourceVulnerability.
        :type: datetime
        """
        self._time_last_detected = time_last_detected

    @property
    def time_published(self):
        """
        Gets the time_published of this ResourceVulnerability.
        Time the vulnerability was published


        :return: The time_published of this ResourceVulnerability.
        :rtype: datetime
        """
        return self._time_published

    @time_published.setter
    def time_published(self, time_published):
        """
        Sets the time_published of this ResourceVulnerability.
        Time the vulnerability was published


        :param time_published: The time_published of this ResourceVulnerability.
        :type: datetime
        """
        self._time_published = time_published

    @property
    def time_last_modified(self):
        """
        Gets the time_last_modified of this ResourceVulnerability.
        Time the vulnerability was last modified


        :return: The time_last_modified of this ResourceVulnerability.
        :rtype: datetime
        """
        return self._time_last_modified

    @time_last_modified.setter
    def time_last_modified(self, time_last_modified):
        """
        Sets the time_last_modified of this ResourceVulnerability.
        Time the vulnerability was last modified


        :param time_last_modified: The time_last_modified of this ResourceVulnerability.
        :type: datetime
        """
        self._time_last_modified = time_last_modified

    @property
    def cvss_score(self):
        """
        Gets the cvss_score of this ResourceVulnerability.
        cvssScore of CVE


        :return: The cvss_score of this ResourceVulnerability.
        :rtype: str
        """
        return self._cvss_score

    @cvss_score.setter
    def cvss_score(self, cvss_score):
        """
        Sets the cvss_score of this ResourceVulnerability.
        cvssScore of CVE


        :param cvss_score: The cvss_score of this ResourceVulnerability.
        :type: str
        """
        self._cvss_score = cvss_score

    @property
    def package_details(self):
        """
        Gets the package_details of this ResourceVulnerability.
        list for packages causing vulnerability


        :return: The package_details of this ResourceVulnerability.
        :rtype: list[oci.cloud_guard.models.PackageDetail]
        """
        return self._package_details

    @package_details.setter
    def package_details(self, package_details):
        """
        Sets the package_details of this ResourceVulnerability.
        list for packages causing vulnerability


        :param package_details: The package_details of this ResourceVulnerability.
        :type: list[oci.cloud_guard.models.PackageDetail]
        """
        self._package_details = package_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ResourceVulnerability.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`

        Avoid entering confidential information.


        :return: The freeform_tags of this ResourceVulnerability.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ResourceVulnerability.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`

        Avoid entering confidential information.


        :param freeform_tags: The freeform_tags of this ResourceVulnerability.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ResourceVulnerability.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this ResourceVulnerability.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ResourceVulnerability.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this ResourceVulnerability.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ResourceVulnerability.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this ResourceVulnerability.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ResourceVulnerability.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this ResourceVulnerability.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
