# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GetIpInventoryVcnOverlapDetails(object):
    """
    Lists the compartment to find VCN overlap.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GetIpInventoryVcnOverlapDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param region_list:
            The value to assign to the region_list property of this GetIpInventoryVcnOverlapDetails.
        :type region_list: list[str]

        :param compartment_list:
            The value to assign to the compartment_list property of this GetIpInventoryVcnOverlapDetails.
        :type compartment_list: list[str]

        """
        self.swagger_types = {
            'region_list': 'list[str]',
            'compartment_list': 'list[str]'
        }

        self.attribute_map = {
            'region_list': 'regionList',
            'compartment_list': 'compartmentList'
        }

        self._region_list = None
        self._compartment_list = None

    @property
    def region_list(self):
        """
        **[Required]** Gets the region_list of this GetIpInventoryVcnOverlapDetails.
        Lists the selected regions.


        :return: The region_list of this GetIpInventoryVcnOverlapDetails.
        :rtype: list[str]
        """
        return self._region_list

    @region_list.setter
    def region_list(self, region_list):
        """
        Sets the region_list of this GetIpInventoryVcnOverlapDetails.
        Lists the selected regions.


        :param region_list: The region_list of this GetIpInventoryVcnOverlapDetails.
        :type: list[str]
        """
        self._region_list = region_list

    @property
    def compartment_list(self):
        """
        **[Required]** Gets the compartment_list of this GetIpInventoryVcnOverlapDetails.
        The list of `OCID`__ of the compartments.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_list of this GetIpInventoryVcnOverlapDetails.
        :rtype: list[str]
        """
        return self._compartment_list

    @compartment_list.setter
    def compartment_list(self, compartment_list):
        """
        Sets the compartment_list of this GetIpInventoryVcnOverlapDetails.
        The list of `OCID`__ of the compartments.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_list: The compartment_list of this GetIpInventoryVcnOverlapDetails.
        :type: list[str]
        """
        self._compartment_list = compartment_list

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
