# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InventoryIpAddressSummary(object):
    """
    Provides the IP address and its corresponding VNIC ID, VNIC name, and DNS hostname.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InventoryIpAddressSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ip_address:
            The value to assign to the ip_address property of this InventoryIpAddressSummary.
        :type ip_address: str

        :param vnic_id:
            The value to assign to the vnic_id property of this InventoryIpAddressSummary.
        :type vnic_id: str

        :param vnic_name:
            The value to assign to the vnic_name property of this InventoryIpAddressSummary.
        :type vnic_name: str

        :param dns_host_name:
            The value to assign to the dns_host_name property of this InventoryIpAddressSummary.
        :type dns_host_name: str

        """
        self.swagger_types = {
            'ip_address': 'str',
            'vnic_id': 'str',
            'vnic_name': 'str',
            'dns_host_name': 'str'
        }

        self.attribute_map = {
            'ip_address': 'ipAddress',
            'vnic_id': 'vnicId',
            'vnic_name': 'vnicName',
            'dns_host_name': 'dnsHostName'
        }

        self._ip_address = None
        self._vnic_id = None
        self._vnic_name = None
        self._dns_host_name = None

    @property
    def ip_address(self):
        """
        Gets the ip_address of this InventoryIpAddressSummary.
        The IP address assigned from a subnet.


        :return: The ip_address of this InventoryIpAddressSummary.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this InventoryIpAddressSummary.
        The IP address assigned from a subnet.


        :param ip_address: The ip_address of this InventoryIpAddressSummary.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def vnic_id(self):
        """
        Gets the vnic_id of this InventoryIpAddressSummary.
        The `OCID`__ of the VNIC.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The vnic_id of this InventoryIpAddressSummary.
        :rtype: str
        """
        return self._vnic_id

    @vnic_id.setter
    def vnic_id(self, vnic_id):
        """
        Sets the vnic_id of this InventoryIpAddressSummary.
        The `OCID`__ of the VNIC.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param vnic_id: The vnic_id of this InventoryIpAddressSummary.
        :type: str
        """
        self._vnic_id = vnic_id

    @property
    def vnic_name(self):
        """
        Gets the vnic_name of this InventoryIpAddressSummary.
        The name of the VNIC.


        :return: The vnic_name of this InventoryIpAddressSummary.
        :rtype: str
        """
        return self._vnic_name

    @vnic_name.setter
    def vnic_name(self, vnic_name):
        """
        Sets the vnic_name of this InventoryIpAddressSummary.
        The name of the VNIC.


        :param vnic_name: The vnic_name of this InventoryIpAddressSummary.
        :type: str
        """
        self._vnic_name = vnic_name

    @property
    def dns_host_name(self):
        """
        Gets the dns_host_name of this InventoryIpAddressSummary.
        The DNS hostname of the resource assigned with the IP address.


        :return: The dns_host_name of this InventoryIpAddressSummary.
        :rtype: str
        """
        return self._dns_host_name

    @dns_host_name.setter
    def dns_host_name(self, dns_host_name):
        """
        Sets the dns_host_name of this InventoryIpAddressSummary.
        The DNS hostname of the resource assigned with the IP address.


        :param dns_host_name: The dns_host_name of this InventoryIpAddressSummary.
        :type: str
        """
        self._dns_host_name = dns_host_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
