# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseFeatureConfiguration(object):
    """
    The details of an external database feature configuration.
    """

    #: A constant which can be used with the feature property of a DatabaseFeatureConfiguration.
    #: This constant has a value of "DIAGNOSTICS_AND_MANAGEMENT"
    FEATURE_DIAGNOSTICS_AND_MANAGEMENT = "DIAGNOSTICS_AND_MANAGEMENT"

    #: A constant which can be used with the feature_status property of a DatabaseFeatureConfiguration.
    #: This constant has a value of "ENABLED"
    FEATURE_STATUS_ENABLED = "ENABLED"

    #: A constant which can be used with the feature_status property of a DatabaseFeatureConfiguration.
    #: This constant has a value of "NOT_ENABLED"
    FEATURE_STATUS_NOT_ENABLED = "NOT_ENABLED"

    #: A constant which can be used with the feature_status property of a DatabaseFeatureConfiguration.
    #: This constant has a value of "UNSUPPORTED"
    FEATURE_STATUS_UNSUPPORTED = "UNSUPPORTED"

    #: A constant which can be used with the feature_status property of a DatabaseFeatureConfiguration.
    #: This constant has a value of "FAILED_ENABLING"
    FEATURE_STATUS_FAILED_ENABLING = "FAILED_ENABLING"

    #: A constant which can be used with the feature_status property of a DatabaseFeatureConfiguration.
    #: This constant has a value of "FAILED_DISABLING"
    FEATURE_STATUS_FAILED_DISABLING = "FAILED_DISABLING"

    #: A constant which can be used with the feature_status property of a DatabaseFeatureConfiguration.
    #: This constant has a value of "FAILED"
    FEATURE_STATUS_FAILED = "FAILED"

    #: A constant which can be used with the feature_status property of a DatabaseFeatureConfiguration.
    #: This constant has a value of "ENABLED_WITH_WARNINGS"
    FEATURE_STATUS_ENABLED_WITH_WARNINGS = "ENABLED_WITH_WARNINGS"

    #: A constant which can be used with the feature_status property of a DatabaseFeatureConfiguration.
    #: This constant has a value of "PENDING_DISABLE"
    FEATURE_STATUS_PENDING_DISABLE = "PENDING_DISABLE"

    #: A constant which can be used with the feature_status property of a DatabaseFeatureConfiguration.
    #: This constant has a value of "ENABLING"
    FEATURE_STATUS_ENABLING = "ENABLING"

    #: A constant which can be used with the feature_status property of a DatabaseFeatureConfiguration.
    #: This constant has a value of "DISABLING"
    FEATURE_STATUS_DISABLING = "DISABLING"

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseFeatureConfiguration object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_management.models.DatabaseDiagnosticsAndManagementFeatureConfiguration`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param feature:
            The value to assign to the feature property of this DatabaseFeatureConfiguration.
            Allowed values for this property are: "DIAGNOSTICS_AND_MANAGEMENT"
        :type feature: str

        :param feature_status:
            The value to assign to the feature_status property of this DatabaseFeatureConfiguration.
            Allowed values for this property are: "ENABLED", "NOT_ENABLED", "UNSUPPORTED", "FAILED_ENABLING", "FAILED_DISABLING", "FAILED", "ENABLED_WITH_WARNINGS", "PENDING_DISABLE", "ENABLING", "DISABLING"
        :type feature_status: str

        :param connector_details:
            The value to assign to the connector_details property of this DatabaseFeatureConfiguration.
        :type connector_details: oci.database_management.models.ConnectorDetails

        :param database_connection_details:
            The value to assign to the database_connection_details property of this DatabaseFeatureConfiguration.
        :type database_connection_details: oci.database_management.models.DatabaseConnectionDetails

        """
        self.swagger_types = {
            'feature': 'str',
            'feature_status': 'str',
            'connector_details': 'ConnectorDetails',
            'database_connection_details': 'DatabaseConnectionDetails'
        }

        self.attribute_map = {
            'feature': 'feature',
            'feature_status': 'featureStatus',
            'connector_details': 'connectorDetails',
            'database_connection_details': 'databaseConnectionDetails'
        }

        self._feature = None
        self._feature_status = None
        self._connector_details = None
        self._database_connection_details = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['feature']

        if type == 'DIAGNOSTICS_AND_MANAGEMENT':
            return 'DatabaseDiagnosticsAndManagementFeatureConfiguration'
        else:
            return 'DatabaseFeatureConfiguration'

    @property
    def feature(self):
        """
        **[Required]** Gets the feature of this DatabaseFeatureConfiguration.
        The name of the Database Management feature.

        Allowed values for this property are: "DIAGNOSTICS_AND_MANAGEMENT"


        :return: The feature of this DatabaseFeatureConfiguration.
        :rtype: str
        """
        return self._feature

    @feature.setter
    def feature(self, feature):
        """
        Sets the feature of this DatabaseFeatureConfiguration.
        The name of the Database Management feature.


        :param feature: The feature of this DatabaseFeatureConfiguration.
        :type: str
        """
        allowed_values = ["DIAGNOSTICS_AND_MANAGEMENT"]
        if not value_allowed_none_or_none_sentinel(feature, allowed_values):
            raise ValueError(
                f"Invalid value for `feature`, must be None or one of {allowed_values}"
            )
        self._feature = feature

    @property
    def feature_status(self):
        """
        **[Required]** Gets the feature_status of this DatabaseFeatureConfiguration.
        The list of statuses for Database Management features.

        Allowed values for this property are: "ENABLED", "NOT_ENABLED", "UNSUPPORTED", "FAILED_ENABLING", "FAILED_DISABLING", "FAILED", "ENABLED_WITH_WARNINGS", "PENDING_DISABLE", "ENABLING", "DISABLING"


        :return: The feature_status of this DatabaseFeatureConfiguration.
        :rtype: str
        """
        return self._feature_status

    @feature_status.setter
    def feature_status(self, feature_status):
        """
        Sets the feature_status of this DatabaseFeatureConfiguration.
        The list of statuses for Database Management features.


        :param feature_status: The feature_status of this DatabaseFeatureConfiguration.
        :type: str
        """
        allowed_values = ["ENABLED", "NOT_ENABLED", "UNSUPPORTED", "FAILED_ENABLING", "FAILED_DISABLING", "FAILED", "ENABLED_WITH_WARNINGS", "PENDING_DISABLE", "ENABLING", "DISABLING"]
        if not value_allowed_none_or_none_sentinel(feature_status, allowed_values):
            raise ValueError(
                f"Invalid value for `feature_status`, must be None or one of {allowed_values}"
            )
        self._feature_status = feature_status

    @property
    def connector_details(self):
        """
        Gets the connector_details of this DatabaseFeatureConfiguration.

        :return: The connector_details of this DatabaseFeatureConfiguration.
        :rtype: oci.database_management.models.ConnectorDetails
        """
        return self._connector_details

    @connector_details.setter
    def connector_details(self, connector_details):
        """
        Sets the connector_details of this DatabaseFeatureConfiguration.

        :param connector_details: The connector_details of this DatabaseFeatureConfiguration.
        :type: oci.database_management.models.ConnectorDetails
        """
        self._connector_details = connector_details

    @property
    def database_connection_details(self):
        """
        Gets the database_connection_details of this DatabaseFeatureConfiguration.

        :return: The database_connection_details of this DatabaseFeatureConfiguration.
        :rtype: oci.database_management.models.DatabaseConnectionDetails
        """
        return self._database_connection_details

    @database_connection_details.setter
    def database_connection_details(self, database_connection_details):
        """
        Sets the database_connection_details of this DatabaseFeatureConfiguration.

        :param database_connection_details: The database_connection_details of this DatabaseFeatureConfiguration.
        :type: oci.database_management.models.DatabaseConnectionDetails
        """
        self._database_connection_details = database_connection_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
