# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlFleetMetricDefinition(object):
    """
    The list of aggregated metrics for the Managed MySQL Databases in the fleet.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlFleetMetricDefinition object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_value:
            The value to assign to the metric_value property of this MySqlFleetMetricDefinition.
        :type metric_value: int

        :param metric_value_double:
            The value to assign to the metric_value_double property of this MySqlFleetMetricDefinition.
        :type metric_value_double: float

        :param metric_name:
            The value to assign to the metric_name property of this MySqlFleetMetricDefinition.
        :type metric_name: str

        :param timestamp:
            The value to assign to the timestamp property of this MySqlFleetMetricDefinition.
        :type timestamp: datetime

        :param dimensions:
            The value to assign to the dimensions property of this MySqlFleetMetricDefinition.
        :type dimensions: list[oci.database_management.models.MetricDimensionDefinition]

        :param unit:
            The value to assign to the unit property of this MySqlFleetMetricDefinition.
        :type unit: str

        """
        self.swagger_types = {
            'metric_value': 'int',
            'metric_value_double': 'float',
            'metric_name': 'str',
            'timestamp': 'datetime',
            'dimensions': 'list[MetricDimensionDefinition]',
            'unit': 'str'
        }

        self.attribute_map = {
            'metric_value': 'metricValue',
            'metric_value_double': 'metricValueDouble',
            'metric_name': 'metricName',
            'timestamp': 'timestamp',
            'dimensions': 'dimensions',
            'unit': 'unit'
        }

        self._metric_value = None
        self._metric_value_double = None
        self._metric_name = None
        self._timestamp = None
        self._dimensions = None
        self._unit = None

    @property
    def metric_value(self):
        """
        **[Required]** Gets the metric_value of this MySqlFleetMetricDefinition.
        The value of the metric.


        :return: The metric_value of this MySqlFleetMetricDefinition.
        :rtype: int
        """
        return self._metric_value

    @metric_value.setter
    def metric_value(self, metric_value):
        """
        Sets the metric_value of this MySqlFleetMetricDefinition.
        The value of the metric.


        :param metric_value: The metric_value of this MySqlFleetMetricDefinition.
        :type: int
        """
        self._metric_value = metric_value

    @property
    def metric_value_double(self):
        """
        Gets the metric_value_double of this MySqlFleetMetricDefinition.
        The value of the metric.


        :return: The metric_value_double of this MySqlFleetMetricDefinition.
        :rtype: float
        """
        return self._metric_value_double

    @metric_value_double.setter
    def metric_value_double(self, metric_value_double):
        """
        Sets the metric_value_double of this MySqlFleetMetricDefinition.
        The value of the metric.


        :param metric_value_double: The metric_value_double of this MySqlFleetMetricDefinition.
        :type: float
        """
        self._metric_value_double = metric_value_double

    @property
    def metric_name(self):
        """
        **[Required]** Gets the metric_name of this MySqlFleetMetricDefinition.
        The name of the metric.


        :return: The metric_name of this MySqlFleetMetricDefinition.
        :rtype: str
        """
        return self._metric_name

    @metric_name.setter
    def metric_name(self, metric_name):
        """
        Sets the metric_name of this MySqlFleetMetricDefinition.
        The name of the metric.


        :param metric_name: The metric_name of this MySqlFleetMetricDefinition.
        :type: str
        """
        self._metric_name = metric_name

    @property
    def timestamp(self):
        """
        **[Required]** Gets the timestamp of this MySqlFleetMetricDefinition.
        The data point date and time in UTC in ISO-8601 format.


        :return: The timestamp of this MySqlFleetMetricDefinition.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this MySqlFleetMetricDefinition.
        The data point date and time in UTC in ISO-8601 format.


        :param timestamp: The timestamp of this MySqlFleetMetricDefinition.
        :type: datetime
        """
        self._timestamp = timestamp

    @property
    def dimensions(self):
        """
        **[Required]** Gets the dimensions of this MySqlFleetMetricDefinition.
        The dimensions of the metric.


        :return: The dimensions of this MySqlFleetMetricDefinition.
        :rtype: list[oci.database_management.models.MetricDimensionDefinition]
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this MySqlFleetMetricDefinition.
        The dimensions of the metric.


        :param dimensions: The dimensions of this MySqlFleetMetricDefinition.
        :type: list[oci.database_management.models.MetricDimensionDefinition]
        """
        self._dimensions = dimensions

    @property
    def unit(self):
        """
        **[Required]** Gets the unit of this MySqlFleetMetricDefinition.
        The unit of the metric value.


        :return: The unit of this MySqlFleetMetricDefinition.
        :rtype: str
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """
        Sets the unit of this MySqlFleetMetricDefinition.
        The unit of the metric value.


        :param unit: The unit of this MySqlFleetMetricDefinition.
        :type: str
        """
        self._unit = unit

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
