# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateFsuCollectionDetails(object):
    """
    The information about new Exadata Fleet Update Collection.
    """

    #: A constant which can be used with the type property of a CreateFsuCollectionDetails.
    #: This constant has a value of "DB"
    TYPE_DB = "DB"

    #: A constant which can be used with the type property of a CreateFsuCollectionDetails.
    #: This constant has a value of "GI"
    TYPE_GI = "GI"

    #: A constant which can be used with the service_type property of a CreateFsuCollectionDetails.
    #: This constant has a value of "EXACS"
    SERVICE_TYPE_EXACS = "EXACS"

    #: A constant which can be used with the service_type property of a CreateFsuCollectionDetails.
    #: This constant has a value of "EXACC"
    SERVICE_TYPE_EXACC = "EXACC"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateFsuCollectionDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_software_update.models.CreateDbFsuCollectionDetails`
        * :class:`~oci.fleet_software_update.models.CreateGiFsuCollectionDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateFsuCollectionDetails.
        :type display_name: str

        :param type:
            The value to assign to the type property of this CreateFsuCollectionDetails.
            Allowed values for this property are: "DB", "GI"
        :type type: str

        :param service_type:
            The value to assign to the service_type property of this CreateFsuCollectionDetails.
            Allowed values for this property are: "EXACS", "EXACC"
        :type service_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateFsuCollectionDetails.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateFsuCollectionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateFsuCollectionDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'type': 'str',
            'service_type': 'str',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'type': 'type',
            'service_type': 'serviceType',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._type = None
        self._service_type = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'DB':
            return 'CreateDbFsuCollectionDetails'

        if type == 'GI':
            return 'CreateGiFsuCollectionDetails'
        else:
            return 'CreateFsuCollectionDetails'

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateFsuCollectionDetails.
        Exadata Fleet Update Collection Identifier.


        :return: The display_name of this CreateFsuCollectionDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateFsuCollectionDetails.
        Exadata Fleet Update Collection Identifier.


        :param display_name: The display_name of this CreateFsuCollectionDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CreateFsuCollectionDetails.
        Collection type.
        DB: Only Database entity type resources allowed.
        GI: CloudVMCluster and VMCluster entity type resources allowed.

        Allowed values for this property are: "DB", "GI"


        :return: The type of this CreateFsuCollectionDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateFsuCollectionDetails.
        Collection type.
        DB: Only Database entity type resources allowed.
        GI: CloudVMCluster and VMCluster entity type resources allowed.


        :param type: The type of this CreateFsuCollectionDetails.
        :type: str
        """
        allowed_values = ["DB", "GI"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def service_type(self):
        """
        **[Required]** Gets the service_type of this CreateFsuCollectionDetails.
        Exadata service type for the target resource members.

        Allowed values for this property are: "EXACS", "EXACC"


        :return: The service_type of this CreateFsuCollectionDetails.
        :rtype: str
        """
        return self._service_type

    @service_type.setter
    def service_type(self, service_type):
        """
        Sets the service_type of this CreateFsuCollectionDetails.
        Exadata service type for the target resource members.


        :param service_type: The service_type of this CreateFsuCollectionDetails.
        :type: str
        """
        allowed_values = ["EXACS", "EXACC"]
        if not value_allowed_none_or_none_sentinel(service_type, allowed_values):
            raise ValueError(
                f"Invalid value for `service_type`, must be None or one of {allowed_values}"
            )
        self._service_type = service_type

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateFsuCollectionDetails.
        Compartment Identifier


        :return: The compartment_id of this CreateFsuCollectionDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateFsuCollectionDetails.
        Compartment Identifier


        :param compartment_id: The compartment_id of this CreateFsuCollectionDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateFsuCollectionDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateFsuCollectionDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateFsuCollectionDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateFsuCollectionDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateFsuCollectionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateFsuCollectionDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateFsuCollectionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateFsuCollectionDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
